/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.extra.war.report.antx;

import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.opengts.db.tables.Account;
import org.opengts.dbtools.DBException;
import org.opengts.dbtools.DBRecordHandler;
import org.opengts.extra.tables.Antx;
import org.opengts.extra.war.report.antx.AntxChannel;
import org.opengts.extra.war.report.antx.AntxData;
import org.opengts.extra.war.report.antx.AntxLayout;
import org.opengts.util.Print;
import org.opengts.war.report.DBDataIterator;
import org.opengts.war.report.ReportConstraints;
import org.opengts.war.report.ReportData;
import org.opengts.war.report.ReportDeviceList;
import org.opengts.war.report.ReportEntry;
import org.opengts.war.report.ReportException;
import org.opengts.war.report.ReportLayout;
import org.opengts.war.tools.RequestProperties;

public class AntxDailyReport
extends ReportData {
    private List<AntxData> rowData = null;

    public AntxDailyReport(ReportEntry rptEntry, RequestProperties reqState, ReportDeviceList devList) throws ReportException {
        super(rptEntry, reqState, devList);
        if (this.getAccount() == null) {
            throw new ReportException("Account must be specified");
        }
    }

    @Override
    public void postInitialize() {
    }

    @Override
    public ReportLayout getReportLayout() {
        return AntxLayout.getReportLayout();
    }

    @Override
    public DBDataIterator getBodyDataIterator() {
        this.rowData = new Vector<AntxData>();
        ReportConstraints rc = this.getReportConstraints();
        long startTime = rc.getTimeStart();
        long endTime = rc.getTimeEnd();
        long limit = rc.getSelectionLimit();
        Account currAcct = this.getAccount();
        String currAcctID = currAcct.getAccountID();
        ReportDeviceList devList = this.getReportDeviceList();
        DBRecordHandler<Antx> rcdHandler = new DBRecordHandler<Antx>(){

            public int handleDBRecord(Antx a) throws DBException {
                Print.logInfo((String)"Processing record ...", (Object[])new Object[0]);
                AntxData fd = new AntxData();
                fd.setDevice(a.getDevice());
                int chan = a.getChannelID();
                int type = a.getType();
                fd.setValue("deviceID", a.getDeviceID());
                fd.setValue("timestamp", a.getTimestamp());
                fd.setValue("fieldID", a.getFieldID());
                fd.setValue("channelID", chan);
                fd.setValue("type", type);
                fd.setValue("data0", a.getData0());
                fd.setValue("data1", a.getData1());
                fd.setValue("data2", a.getData2());
                fd.setValue("data3", a.getData3());
                fd.setValue("data4", a.getData4());
                if (type == 0) {
                    int afUnits;
                    AntxChannel af = AntxChannel.GetAntxChannel(chan);
                    int n = afUnits = af != null ? af.getUnits() : 0;
                    if (afUnits == 6) {
                        fd.setValue("speed", a.getData0());
                    } else if (afUnits == 5) {
                        fd.setValue("distance", a.getData0());
                    } else if (afUnits == 8) {
                        fd.setValue("totalFuel", a.getData0());
                    }
                }
                AntxDailyReport.this.rowData.add(fd);
                return 1;
            }
        };
        Iterator<String> i = devList.iterator();
        while (i.hasNext()) {
            String deviceID = i.next();
            try {
                Antx.getRecordCallback((DBRecordHandler)rcdHandler, (String)currAcctID, (String)deviceID, (long)startTime, (long)endTime, (long)limit);
            }
            catch (DBException dbe) {
                Print.logException((String)"Error", (Throwable)dbe);
            }
        }
        return new ReportData.ListDataIterator(this, this.rowData);
    }

    @Override
    public DBDataIterator getTotalsDataIterator() {
        return null;
    }
}

