/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.extra.war.report.antx;

import java.util.Locale;
import java.util.Map;
import org.opengts.db.tables.Account;
import org.opengts.extra.war.report.antx.AntxField;
import org.opengts.util.ListTools;

public class AntxChannel
extends AntxField {
    public static final int UNITS_NONE = 0;
    public static final int UNITS_BOOLEAN = 1;
    public static final int UNITS_PERCENT = 2;
    public static final int UNITS_HOURS = 3;
    public static final int UNITS_TEMP = 4;
    public static final int UNITS_DISTANCE = 5;
    public static final int UNITS_SPEED = 6;
    public static final int UNITS_PRESSURE = 7;
    public static final int UNITS_FUEL_USED = 8;
    public static final int UNITS_ECON = 9;
    public static final int UNITS_VOLRATE = 10;
    public static final double KILOMETERS_PER_MILE = 1.609344;
    public static final double LITERS_PER_GALLON = 3.785411784;
    public static final double LPH_PER_GPS = 13627.4824224;
    public static final double PSI_PER_KPA = 0.14503773773020923;
    public static final double KPA_PER_PSI = 6.894757293168361;
    public static final double KPL_PER_MPG = 0.4251437074302721;
    public static final double MINUTES_PER_HOUR = 0.016666666666666666;
    public static final double PERCENT_FRAC = 0.01;
    public static final double C_GAIN = 0.55555556;
    public static final double C_OFFSET = -17.77777778;
    public static final int CHAN_UNDEFINED = 0;
    public static final int CHAN_GSM = 1;
    public static final int CHAN_COMM = 2;
    public static final int CHAN_CAN = 3;
    public static final int CHAN_DIN1 = 4;
    public static final int CHAN_DIN2 = 5;
    public static final int CHAN_DIN4 = 6;
    public static final int CHAN_ENGINE_RUN = 9;
    public static final int CHAN_SHUTDOWN = 10;
    public static final int CHAN_WARNING = 11;
    public static final int CHAN_PTO_STATE = 16;
    public static final int CHAN_FAN_DRIVE_STATE = 17;
    public static final int CHAN_PTO_ENABLED = 18;
    public static final int CHAN_FUEL_LEVEL = 51;
    public static final int CHAN_RPM = 52;
    public static final int CHAN_TOTAL_ENGINE_HOURS = 53;
    public static final int CHAN_COOLANT_TEMPERATURE = 56;
    public static final int CHAN_BATTERY_SWITCHED = 57;
    public static final int CHAN_BATTERY_UNSWITCHED = 58;
    public static final int CHAN_OIL_PRESSURE = 59;
    public static final int CHAN_FUEL_RATE = 60;
    public static final int CHAN_ANALOG_INPUT = 62;
    public static final int CHAN_VEHICLE_DISTANCE = 79;
    public static final int CHAN_ENGINE_STARTS = 81;
    public static final int CHAN_IDLE_TIME_START = 82;
    public static final int CHAN_IDLE_FUEL_START = 83;
    public static final int CHAN_WORK_TIME_START = 84;
    public static final int CHAN_WORK_FUEL_START = 85;
    public static final int CHAN_IDLE_TIME_DAY = 86;
    public static final int CHAN_IDLE_FUEL_DAY = 87;
    public static final int CHAN_WORK_TIME_DAY = 88;
    public static final int CHAN_WORK_FUEL_DAY = 89;
    public static final int CHAN_OIL_LEVEL = 90;
    public static final int CHAN_OIL_TEMPERATURE = 91;
    public static final int CHAN_COOLANT_LEVEL = 92;
    public static final int CHAN_AVERAGE_FUEL_ECON = 93;
    public static final int CHAN_INSTANT_FUEL_ECON = 94;
    public static final int CHAN_THROTTLE_POSITION = 95;
    public static final int CHAN_VEHICLE_SPEED = 96;
    public static final int CHAN_BAROMETRIC_PRESSURE = 105;
    public static final int CHAN_CABIN_TEMPERATURE = 106;
    public static final int CHAN_AMBIENT_TEMPERATURE = 107;
    public static final int CHAN_ACCEL_PEDAL_POSITION = 108;
    public static final int CHAN_AIR_FILTER_DIFF_PRESSUE = 109;
    public static final int CHAN_ENGINE_LOAD = 110;
    public static final int CHAN_ENGINE_TORQUE = 111;
    public static final int CHAN_FUEL_BY_RPM = 112;
    public static final int CHAN_DISTANCE_BY_RPM = 113;
    public static final int CHAN_FUEL_BY_SPEED = 114;
    public static final int CHAN_DISTANCE_BY_SPEED = 115;
    public static final int CHAN_FUEL_BY_LOAD = 116;
    public static final int CHAN_FUEL_BY_TORQUE = 117;
    public static final int CHAN_DISTANCE_BY_DAY = 118;
    public static final int CHAN_FUEL_BY_DAY = 119;
    public static final int CHAN_PTO_FUEL_BY_DAY = 150;
    public static final int CHAN_ENGINE_FUEL_TEMPERATURE = 151;
    public static final int CHAN_ESTIMATED_FAN_SPEED = 152;
    public static final int CHAN_TRANS_OIL_TEMPERATURE = 153;
    public static final int CHAN_GEN_TOTAL_KW_HOURS = 250;
    public static final int CHAN_GEN_TOTAL_REACTIVE_POWER = 251;
    public static final int CHAN_GEN_POWER_FACTOR = 252;
    public static final int CHAN_GEN_TOTAL_REAL_POWER = 253;
    public static final int CHAN_GEN_AVG_LINE_LINE_AC_RMS = 254;
    public static final int CHAN_GEN_AVG_LINE_NEUT_AC_RMS = 255;
    public static final int CHAN_GEN_AVG_AC_FREQUENCY = 256;
    public static final int CHAN_GEN_AVG_AC_RMS_CURRENT = 257;
    public static final Map ChannelDescription = ListTools.toMap((String)"toString", (Object[])new AntxChannel[]{new AntxChannel(0, "undefined"), new AntxChannel(1, "GSM Status"), new AntxChannel(2, "Comm Status"), new AntxChannel(3, "CAN Status"), new AntxChannel(4, "DIN1", 1, 1.0), new AntxChannel(5, "DIN2", 1, 1.0), new AntxChannel(6, "DIN4", 1, 1.0), new AntxChannel(9, "Engine Running", 1, 1.0), new AntxChannel(10, "Shutdown LED", 1, 1.0), new AntxChannel(11, "Warning LED", 1, 1.0), new AntxChannel(16, "PTO State", 1, 1.0), new AntxChannel(17, "Fan Drive State", 1, 1.0), new AntxChannel(18, "PTO Enabled State", 1, 1.0), new AntxChannel(51, "Fuel Level", 2, 0.01), new AntxChannel(52, "RPM"), new AntxChannel(53, "Engine Hours", 3, 1.0), new AntxChannel(56, "Coolant Temp", 4, 0.55555556, -17.77777778), new AntxChannel(57, "Battery Sw"), new AntxChannel(58, "Battery Unsw"), new AntxChannel(59, "Oil Pressure", 7, 6.894757293168361), new AntxChannel(60, "Fuel Rate", 10, 13627.4824224), new AntxChannel(62, "Analog Input"), new AntxChannel(79, "Distance", 5, 1.609344), new AntxChannel(81, "Engine Starts"), new AntxChannel(82, "Idle Time Start", 3, 0.016666666666666666), new AntxChannel(83, "Idle Fuel Start", 8, 3.785411784), new AntxChannel(84, "Work Time Start", 3, 0.016666666666666666), new AntxChannel(85, "Work Fuel Start", 8, 3.785411784), new AntxChannel(86, "Idle Time Day", 3, 0.016666666666666666), new AntxChannel(87, "Idle Fuel Day", 8, 3.785411784), new AntxChannel(88, "Work Time Day", 3, 0.016666666666666666), new AntxChannel(89, "Work Fuel Day", 8, 3.785411784), new AntxChannel(90, "Oil Level", 2, 0.01), new AntxChannel(91, "Oil Temperature", 4, 0.55555556, -17.77777778), new AntxChannel(92, "Coolant Level", 2, 0.01), new AntxChannel(93, "Avg Fuel Econ", 9, 0.4251437074302721), new AntxChannel(94, "Inst Fuel Econ", 9, 0.4251437074302721), new AntxChannel(95, "Throttle Pos", 2, 0.01), new AntxChannel(96, "Speed", 6, 1.609344), new AntxChannel(105, "Barometric Press", 7, 6.894757293168361), new AntxChannel(106, "Cabin Temp", 4, 0.55555556, -17.77777778), new AntxChannel(107, "Ambient Temp", 4, 0.55555556, -17.77777778), new AntxChannel(108, "Accel Pdal Pos", 2, 0.01), new AntxChannel(109, "Air Filter Diff Press", 7, 6.894757293168361), new AntxChannel(110, "Engine Load", 2, 0.01), new AntxChannel(111, "Engine Torque", 2, 0.01), new AntxChannel(112, "Fuel by RPM", 8, 3.785411784), new AntxChannel(113, "Distance by RPM", 5, 1.609344), new AntxChannel(114, "Fuel by Speed", 8, 3.785411784), new AntxChannel(115, "Distance by Speed", 5, 1.609344), new AntxChannel(116, "Fuel by Load", 8, 3.785411784), new AntxChannel(117, "Fuel by Torque", 8, 3.785411784), new AntxChannel(118, "Distance by Day", 5, 1.609344), new AntxChannel(119, "Fuel by Day", 8, 3.785411784), new AntxChannel(150, "PTO Fuel by Day", 8, 3.785411784), new AntxChannel(151, "Eng Fuel Temp", 8, 3.785411784), new AntxChannel(152, "Fan Speed", 2, 0.01), new AntxChannel(153, "Trans Oil Temp", 4, 0.55555556, -17.77777778), new AntxChannel(250, "Gen Total KW Hours"), new AntxChannel(251, "Gen Total Reactive Pwr"), new AntxChannel(252, "Gen Power Factor"), new AntxChannel(253, "Gen Total Real Pwr"), new AntxChannel(254, "Gen Avg Line/Line AC RMS"), new AntxChannel(255, "Gen Avg Line/Neut AC RMS"), new AntxChannel(256, "Gen Avg AC Freq"), new AntxChannel(257, "Gen Avg AC RMS Current")});
    private int units = 0;
    private double gain = 0.0;
    private double offset = 0.0;

    public static AntxChannel GetAntxChannel(int ch) {
        AntxChannel ac = (AntxChannel)ChannelDescription.get(String.valueOf(ch));
        if (ac != null) {
            return ac;
        }
        return (AntxChannel)ChannelDescription.get(String.valueOf(0));
    }

    public static String GetChannelDescription(int ch) {
        return AntxChannel.GetAntxChannel(ch).getDescription();
    }

    public static double ConvertChannelUnits(int ch, double value) {
        return AntxChannel.ConvertChannelUnits(AntxChannel.GetAntxChannel(ch), value);
    }

    public static double ConvertChannelUnits(AntxChannel ac, double value) {
        return ac != null ? ac.convertUnits(value) : value;
    }

    public static String GetChannelUnitsDescription(Account a, int fld, int ch) {
        if (fld == 61) {
            return "Count";
        }
        if (fld == 62) {
            return "Hours";
        }
        AntxChannel ac = AntxChannel.GetAntxChannel(ch);
        return ac != null ? ac.accountUnitsDescription(a, null) : "";
    }

    public static double GetAccountUnitsValue(Account a, int fld, int ch, double value) {
        if (fld == 61) {
            return value;
        }
        if (fld == 62) {
            return value;
        }
        AntxChannel ac = AntxChannel.GetAntxChannel(ch);
        return ac != null ? ac.toAccountUnits(a, value) : value;
    }

    public AntxChannel(int id, String desc, int units, double gain, double offset) {
        super(id, desc);
        this.units = units;
        this.gain = gain;
        this.offset = offset;
    }

    public AntxChannel(int id, String desc, int units, double gain) {
        this(id, desc, units, gain, 0.0);
    }

    public AntxChannel(int id, String desc) {
        this(id, desc, 0, 0.0, 0.0);
    }

    public int getUnits() {
        return this.units;
    }

    public String accountUnitsDescription(Account a, Locale locale) {
        switch (this.units) {
            case 0: {
                return "";
            }
            case 1: {
                return "Bool";
            }
            case 2: {
                return "%";
            }
            case 3: {
                return "Hours";
            }
            case 4: {
                return Account.getTemperatureUnits((Account)a).toString(locale);
            }
            case 5: {
                return Account.getDistanceUnits((Account)a).toString(locale);
            }
            case 6: {
                return Account.getSpeedUnits((Account)a).toString(locale);
            }
            case 7: {
                return Account.getPressureUnits((Account)a).toString(locale);
            }
            case 8: {
                return Account.getVolumeUnits((Account)a).toString(locale);
            }
            case 9: {
                return Account.getEconomyUnits((Account)a).toString(locale);
            }
            case 10: {
                return Account.getVolumeUnits((Account)a).toString(locale) + "/H";
            }
        }
        return "";
    }

    public double toAccountUnits(Account a, double value) {
        switch (this.units) {
            case 0: {
                return value;
            }
            case 1: {
                return value != 0.0 ? 1.0 : 0.0;
            }
            case 2: {
                return value;
            }
            case 3: {
                return value;
            }
            case 4: {
                return Account.getTemperatureUnits((Account)a).convertFromC(value);
            }
            case 5: {
                return Account.getDistanceUnits((Account)a).convertFromKM(value);
            }
            case 6: {
                return Account.getSpeedUnits((Account)a).convertFromKPH(value);
            }
            case 7: {
                return Account.getPressureUnits((Account)a).convertFromKPa(value);
            }
            case 8: {
                return Account.getVolumeUnits((Account)a).convertFromLiters(value);
            }
            case 9: {
                return Account.getEconomyUnits((Account)a).convertFromKPL(value);
            }
            case 10: {
                return Account.getVolumeUnits((Account)a).convertFromLiters(value);
            }
        }
        return value;
    }

    public double convertUnits(double value) {
        if (this.units == 1) {
            return value != 0.0 ? 1.0 : 0.0;
        }
        if (this.gain == 0.0) {
            return value;
        }
        return value * this.gain + this.offset;
    }
}

