/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.util;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;
import org.opengts.util.StringTools;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XMLTools {
    public static String startTAG(boolean isSoapReq, String tag, String attr, boolean endTag, boolean newLine) {
        StringBuffer sb = new StringBuffer();
        sb.append(isSoapReq ? "&lt;" : "<");
        sb.append(tag);
        if (!StringTools.isBlank(attr)) {
            if (!attr.startsWith(" ")) {
                sb.append(" ");
            }
            sb.append(attr);
        }
        if (endTag) {
            sb.append("/");
        }
        sb.append(isSoapReq ? "&gt;" : ">");
        if (!isSoapReq && newLine) {
            sb.append("\n");
        }
        return sb.toString();
    }

    public static String endTAG(boolean isSoapReq, String tag, boolean newLine) {
        StringBuffer sb = new StringBuffer();
        sb.append(isSoapReq ? "&lt;/" : "</");
        sb.append(tag);
        sb.append(isSoapReq ? "&gt;" : ">");
        if (!isSoapReq && newLine) {
            sb.append("\n");
        }
        return sb.toString();
    }

    public static String CDATA(boolean isSoapReq, String content) {
        if (content == null || content.equals("")) {
            return "";
        }
        if (isSoapReq) {
            return "&lt;![CDATA[" + content + "]]&gt;";
        }
        return "<![CDATA[" + content + "]]>";
    }

    public static String PREFIX(boolean isSoapReq, int indent) {
        return isSoapReq ? "" : StringTools.replicateString(" ", indent);
    }

    public static String ATTR(String key, Object value) {
        if (value != null) {
            return XMLTools.ATTR(key, value.toString());
        }
        return "";
    }

    public static String ATTR(String key, String value) {
        if (value != null && !value.equals("")) {
            StringBuffer sb = new StringBuffer();
            sb.append(" ").append(key).append("=\"").append(value).append("\"");
            return sb.toString();
        }
        return "";
    }

    public static String ATTR(String key, int value) {
        return XMLTools.ATTR(key, String.valueOf(value));
    }

    public static String ATTR(String key, long value) {
        return XMLTools.ATTR(key, String.valueOf(value));
    }

    public static String ATTR(String key, boolean value) {
        return XMLTools.ATTR(key, String.valueOf(value));
    }

    public static Document getDocument(File xmlFile) {
        return XMLTools.getDocument(xmlFile, false);
    }

    public static Document getDocument(File xmlFile, boolean checkErrors) {
        if (xmlFile == null) {
            Print.logError("XML file is null!", new Object[0]);
            return null;
        }
        if (!xmlFile.exists()) {
            Print.logError("XML file does not exist: " + xmlFile, new Object[0]);
            return null;
        }
        Document doc = null;
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            if (checkErrors) {
                dbf.setValidating(true);
                dbf.setIgnoringElementContentWhitespace(true);
            }
            DocumentBuilder db = dbf.newDocumentBuilder();
            if (checkErrors) {
                db.setErrorHandler(new XMLErrorHandler());
            }
            doc = db.parse(xmlFile);
        }
        catch (ParserConfigurationException pce) {
            Print.logError("Parse error: " + pce, new Object[0]);
        }
        catch (SAXException se) {
            Print.logError("Parse error: " + se, new Object[0]);
        }
        catch (IOException ioe) {
            Print.logError("IO error: " + ioe, new Object[0]);
        }
        return doc;
    }

    public static Document getDocument(InputStream input) {
        return XMLTools.getDocument(input, false);
    }

    public static Document getDocument(InputStream input, boolean checkErrors) {
        if (input == null) {
            Print.logError("XML stream is null!", new Object[0]);
            return null;
        }
        Document doc = null;
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            if (checkErrors) {
                dbf.setValidating(true);
                dbf.setIgnoringElementContentWhitespace(true);
            }
            DocumentBuilder db = dbf.newDocumentBuilder();
            if (checkErrors) {
                db.setErrorHandler(new XMLErrorHandler());
            }
            doc = db.parse(input);
        }
        catch (ParserConfigurationException pce) {
            Print.logError("Parse error: " + pce, new Object[0]);
        }
        catch (SAXException se) {
            Print.logError("Parse error: " + se, new Object[0]);
        }
        catch (IOException ioe) {
            Print.logError("IO error: " + ioe, new Object[0]);
        }
        return doc;
    }

    public static Document getDocument(byte[] xml) {
        return XMLTools.getDocument(xml, false);
    }

    public static Document getDocument(byte[] xml, boolean checkErrors) {
        if (xml == null) {
            Print.logError("XML data is null!", new Object[0]);
            return null;
        }
        return XMLTools.getDocument(new ByteArrayInputStream(xml), checkErrors);
    }

    public static Document getDocument(String xml) {
        return XMLTools.getDocument(StringTools.getBytes(xml), false);
    }

    public static Document getDocument(String xml, boolean checkErrors) {
        return XMLTools.getDocument(StringTools.getBytes(xml), checkErrors);
    }

    public static String getNodeText(Node root) {
        return XMLTools.getNodeText(root, null, false, "");
    }

    public static String getNodeText(Node root, String repNewline) {
        return XMLTools.getNodeText(root, repNewline, false, "");
    }

    public static String getNodeText(Node root, String repNewline, boolean resolveRT) {
        return XMLTools.getNodeText(root, repNewline, resolveRT, "");
    }

    public static String getNodeText(Node root, String repNewline, boolean resolveRT, String dft) {
        StringBuffer text = null;
        if (root != null) {
            NodeList list = root.getChildNodes();
            for (int i = 0; i < list.getLength(); ++i) {
                Node n = list.item(i);
                if (n.getNodeType() == 4) {
                    if (text == null) {
                        text = new StringBuffer();
                    }
                    text.append(n.getNodeValue());
                    continue;
                }
                if (n.getNodeType() != 3) continue;
                if (text == null) {
                    text = new StringBuffer();
                }
                text.append(n.getNodeValue());
            }
        }
        if (text == null) {
            if (StringTools.isBlank(dft)) {
                return dft;
            }
            text = new StringBuffer(dft);
        }
        if (repNewline != null) {
            StringBuffer sb = new StringBuffer();
            String[] s = StringTools.parseStringArray(text.toString(), "\n\r");
            for (int i = 0; i < s.length; ++i) {
                String line = s[i].trim();
                if (line.equals("")) continue;
                if (sb.length() > 0) {
                    sb.append(repNewline);
                }
                sb.append(line);
            }
            text = sb;
        }
        if (resolveRT) {
            return RTConfig.insertKeyValues(text.toString());
        }
        return text.toString();
    }

    public static String[] parseLines(String text) {
        return StringTools.parseStringArray(text, "\r\n");
    }

    public static String getAttribute(Element elem, String key) {
        return XMLTools.getAttribute(elem, key, null, false);
    }

    public static String getAttribute(Element elem, String key, String dft) {
        return XMLTools.getAttribute(elem, key, dft, false);
    }

    public static String getAttribute(Element elem, String key, String dft, boolean resolveRT) {
        String val;
        String rtn = dft;
        if (elem != null && !StringTools.isBlank(key) && elem.hasAttribute(key) && (val = elem.getAttribute(key)) != null) {
            rtn = val;
        }
        if (resolveRT) {
            return RTConfig.insertKeyValues(rtn);
        }
        return rtn;
    }

    public static boolean getAttributeBoolean(Element elem, String key, boolean dft) {
        return StringTools.parseBoolean(XMLTools.getAttribute(elem, key, null, false), dft);
    }

    public static boolean getAttributeBoolean(Element elem, String key, boolean dft, boolean resolveRT) {
        return StringTools.parseBoolean(XMLTools.getAttribute(elem, key, null, resolveRT), dft);
    }

    public static int getAttributeInt(Element elem, String key, int dft) {
        return StringTools.parseInt(XMLTools.getAttribute(elem, key, null, false), dft);
    }

    public static int getAttributeInt(Element elem, String key, int dft, boolean resolveRT) {
        return StringTools.parseInt(XMLTools.getAttribute(elem, key, null, resolveRT), dft);
    }

    public static long getAttributeLong(Element elem, String key, long dft) {
        return StringTools.parseLong(XMLTools.getAttribute(elem, key, null, false), dft);
    }

    public static long getAttributeLong(Element elem, String key, long dft, boolean resolveRT) {
        return StringTools.parseLong(XMLTools.getAttribute(elem, key, null, resolveRT), dft);
    }

    public static double getAttributeDouble(Element elem, String key, double dft) {
        return StringTools.parseDouble(XMLTools.getAttribute(elem, key, null, false), dft);
    }

    public static double getAttributeDouble(Element elem, String key, double dft, boolean resolveRT) {
        return StringTools.parseDouble(XMLTools.getAttribute(elem, key, null, resolveRT), dft);
    }

    public static Element getChildElement(Node root, String name) {
        NodeList list = root.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node n = list.item(i);
            if (n.getNodeType() != 1 || name != null && !n.getNodeName().equalsIgnoreCase(name)) continue;
            return (Element)n;
        }
        return null;
    }

    public static NodeList getChildElements(Node root, String name) {
        final Vector<Node> elemList = new Vector<Node>();
        NodeList childNodes = root.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node n = childNodes.item(i);
            if (n.getNodeType() != 1 || name != null && !n.getNodeName().equalsIgnoreCase(name)) continue;
            elemList.add(n);
        }
        return new NodeList(){

            @Override
            public int getLength() {
                return elemList.size();
            }

            @Override
            public Node item(int index) {
                return index >= 0 && index < elemList.size() ? (Node)elemList.get(index) : null;
            }
        };
    }

    public static String getPathText(Element root, String nodes) {
        Element node = XMLTools.getPathElement(root, nodes);
        return node != null ? XMLTools.getNodeText(node) : null;
    }

    public static Element getPathElement(Element root, String nodes) {
        return XMLTools.getPathElement(root, new StringTokenizer(nodes, "/"));
    }

    public static Element getPathElement(Element root, StringTokenizer nodes) {
        if (root == null) {
            return null;
        }
        if (nodes == null) {
            return XMLTools.getChildElement(root, null);
        }
        if (!nodes.hasMoreTokens()) {
            return root;
        }
        String nextName = nodes.nextToken();
        return XMLTools.getPathElement(XMLTools.getChildElement(root, nextName), nodes);
    }

    public static String nodeToString(Node n) {
        try {
            TransformerFactory xfact = TransformerFactory.newInstance();
            try {
                xfact.setAttribute("indent-number", new Integer(2));
            }
            catch (Throwable th) {
                // empty catch block
            }
            Transformer xform = xfact.newTransformer();
            xform.setOutputProperty("indent", "yes");
            StreamResult out = new StreamResult(new StringWriter());
            DOMSource ds = new DOMSource(n);
            xform.transform(ds, out);
            return out.getWriter().toString();
        }
        catch (TransformerConfigurationException tce) {
            Print.logException("Converting Node to String", tce);
            return null;
        }
        catch (TransformerException te) {
            Print.logException("Converting Node to String", te);
            return null;
        }
    }

    public static void printNodeTree(String indent, Node n) {
        NodeList child;
        String objVal = n.getNodeValue();
        String strVal = objVal != null ? objVal.toString().trim() : "null";
        Print.logInfo(indent + "Name: " + n.getNodeName() + " ['" + strVal + "']", new Object[0]);
        NamedNodeMap attr = n.getAttributes();
        if (attr != null) {
            for (int i = 0; i < attr.getLength(); ++i) {
                XMLTools.printNodeTree(indent + "   [A] ", attr.item(i));
            }
        }
        if ((child = n.getChildNodes()) != null) {
            for (int i = 0; i < child.getLength(); ++i) {
                XMLTools.printNodeTree(indent + "    ", child.item(i));
            }
        }
    }

    public static void main(String[] argv) {
        System.out.println("");
        File xmlFile = argv.length > 0 ? new File(argv[0]) : null;
        System.out.println("Loading XML file: " + xmlFile);
        Document doc = XMLTools.getDocument(xmlFile, true);
        if (doc == null) {
            System.out.println("");
            System.out.println("Fatal XML errors found!");
            System.exit(99);
        }
        String xmlStr = XMLTools.nodeToString(doc);
        System.out.println("");
        System.out.println(xmlStr);
    }

    public static class XMLErrorHandler
    implements ErrorHandler {
        private void printError(String msg, SAXParseException spe) {
            int line = spe.getLineNumber();
            int col = spe.getColumnNumber();
            System.out.println(msg + " [" + line + ":" + col + "] " + spe.getMessage());
        }

        @Override
        public void error(SAXParseException spe) throws SAXException {
            this.printError("ERROR", spe);
        }

        @Override
        public void fatalError(SAXParseException spe) throws SAXException {
            this.printError("FATAL", spe);
        }

        @Override
        public void warning(SAXParseException spe) throws SAXException {
            this.printError("WARN ", spe);
        }
    }
}

