/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.util;

import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.opengts.util.Base64;
import org.opengts.util.ListTools;
import org.opengts.util.OrderedMap;
import org.opengts.util.OrderedSet;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;
import org.opengts.util.RTProperties;
import org.opengts.util.StringTools;

public class URIArg {
    private static final String PROP_uriArgScrambleSeed = "URIArg.ScrambleSeed";
    private static final BigInteger DefaultScrambleSeed = BigInteger.ONE;
    private static char[] Base64Alphabet = null;
    private static final char Base64Pad = '.';
    private boolean uniqueKeys = false;
    private Collection<KeyVal> keys = null;
    private String uri = "";
    private static final String[] ARG_DECODE = new String[]{"decode", "d"};
    private static final String[] ARG_ENCODE = new String[]{"encode", "e"};
    private static final String[] ARG_RTPENC = new String[]{"rtpEnc"};
    private static final String[] ARG_RTPDEC = new String[]{"rtpDec"};

    private static char[] getBase64Alphabet() {
        if (Base64Alphabet == null) {
            BigInteger seed = RTConfig.getBigInteger(PROP_uriArgScrambleSeed, DefaultScrambleSeed);
            Base64Alphabet = Base64.shuffleAlphabet(seed);
            for (int i = 0; i < Base64Alphabet.length; ++i) {
                if (Base64Alphabet[i] == '+') {
                    URIArg.Base64Alphabet[i] = 45;
                    continue;
                }
                if (Base64Alphabet[i] != '/') continue;
                URIArg.Base64Alphabet[i] = 95;
            }
        }
        return Base64Alphabet;
    }

    public static String _des64(String e) {
        if (!StringTools.isBlank(e)) {
            try {
                byte[] b = Base64.decode(e, URIArg.getBase64Alphabet(), '.');
                return StringTools.toStringValue(b, ' ');
            }
            catch (Base64.Base64DecodeException bde) {
                Print.logError("Invalid Base64 characters", bde);
                return "";
            }
        }
        return "";
    }

    public static String _ens64(String d) {
        if (!StringTools.isBlank(d)) {
            return Base64.encode(StringTools.getBytes(d), URIArg.getBase64Alphabet(), '.');
        }
        return "";
    }

    public static RTProperties parseRTP(String rtpArg) {
        String s;
        if (!StringTools.isBlank(rtpArg) && !StringTools.isBlank(s = URIArg._des64(rtpArg))) {
            return new RTProperties(s);
        }
        return null;
    }

    public static String encodeRTP(RTProperties rtp) {
        if (rtp != null) {
            return URIArg._ens64(rtp.toString());
        }
        return null;
    }

    private static boolean shouldEncodeArgChar(char ch) {
        if (Character.isLetterOrDigit(ch)) {
            return false;
        }
        return ch != '_' && ch != '-' && ch != '.';
    }

    public static String encodeArg(String s) {
        return URIArg.encodeArg(null, s, false).toString();
    }

    public static StringBuffer encodeArg(StringBuffer sb, String s) {
        return URIArg.encodeArg(sb, s, false);
    }

    public static StringBuffer encodeArg(StringBuffer sb, String s, boolean obfuscateAll) {
        if (sb == null) {
            sb = new StringBuffer();
        }
        if (s != null) {
            char[] ch = new char[s.length()];
            s.getChars(0, s.length(), ch, 0);
            for (int i = 0; i < ch.length; ++i) {
                if (obfuscateAll || URIArg.shouldEncodeArgChar(ch[i])) {
                    sb.append("%");
                    sb.append(Integer.toHexString(256 + (ch[i] & 0xFF)).substring(1));
                    continue;
                }
                sb.append(ch[i]);
            }
        }
        return sb;
    }

    public static String obfuscateArg(String s) {
        return URIArg.encodeArg(new StringBuffer(), s, true).toString();
    }

    public static StringBuffer decodeArg(StringBuffer sb, String s) {
        if (sb == null) {
            sb = new StringBuffer();
        }
        if (s != null) {
            char[] ch = new char[s.length()];
            s.getChars(0, s.length(), ch, 0);
            for (int i = 0; i < ch.length; ++i) {
                if (ch[i] == '%') {
                    if (i + 2 < ch.length) {
                        int ch1 = StringTools.hexIndex(ch[i + 1]);
                        int ch2 = StringTools.hexIndex(ch[i + 2]);
                        sb.append((char)((ch1 << 4 | ch2) & 0xFF));
                        i += 2;
                        continue;
                    }
                    i = ch.length - 1;
                    continue;
                }
                sb.append(ch[i]);
            }
        }
        return sb;
    }

    public static boolean isAbsoluteURL(String url) {
        if (url == null) {
            return false;
        }
        for (int i = 0; i < 16 && i < url.length(); ++i) {
            char ch = url.charAt(i);
            if (ch == ':') {
                return true;
            }
            if (Character.isLetterOrDigit(ch) || ch == '.') continue;
            return false;
        }
        return false;
    }

    public URIArg(URIArg uriArg) {
        this.setUniqueKeys(uriArg.hasUniqueKeys());
        this._setURI(uriArg.uri);
        this.setKeys(uriArg.keys);
    }

    public URIArg(String uri, boolean unique) {
        this.setUniqueKeys(unique);
        this.setURI(uri);
    }

    public URIArg(String uri) {
        this(uri, false);
    }

    public URIArg(StringBuffer reqURL, String query) {
        this.setUniqueKeys(false);
        this.setURI(StringTools.trim(reqURL) + "?" + StringTools.trim(query));
    }

    public void setUniqueKeys(boolean unique) {
        this.uniqueKeys = unique;
        this.setKeys(this.keys);
    }

    public boolean hasUniqueKeys() {
        return this.uniqueKeys;
    }

    public void setURI(String uri) {
        int p;
        int n = p = uri != null ? uri.indexOf("?") : -1;
        if (p >= 0) {
            this._setURI(uri.substring(0, p));
            String[] a = StringTools.parseStringArray(uri.substring(p + 1), "&");
            for (int i = 0; i < a.length; ++i) {
                String key = "";
                String val = "";
                int e = a[i].indexOf("=");
                if (e >= 0) {
                    key = a[i].substring(0, e);
                    val = a[i].substring(e + 1);
                } else {
                    key = a[i];
                    val = "";
                }
                this._addArg(key, val, false, false);
            }
        } else {
            this._setURI(uri);
        }
    }

    protected void _setURI(String uri) {
        this.uri = uri != null ? uri : "";
    }

    public String getURI() {
        return this.uri;
    }

    public void addExtension(String ext) {
        if (!StringTools.isBlank(ext) && !this.uri.endsWith(ext)) {
            this.uri = this.uri + ext;
        }
    }

    protected void setKeys(Collection<KeyVal> k) {
        this.keys = null;
        if (k != null) {
            for (KeyVal kv : k) {
                this.getKeyValList().add(new KeyVal(kv));
            }
        }
    }

    protected Collection<KeyVal> getKeyValList() {
        if (this.keys == null) {
            this.keys = this.hasUniqueKeys() ? new OrderedSet() : new Vector();
        }
        return this.keys;
    }

    protected OrderedMap<String, KeyVal> getKeyValMap() {
        OrderedMap<String, KeyVal> kvMap = new OrderedMap<String, KeyVal>();
        for (KeyVal kv : this.getKeyValList()) {
            String kn = kv.getKey();
            if (kvMap.containsKey(kn)) continue;
            kvMap.put(kn, kv);
        }
        return kvMap;
    }

    public List<String> getArgNames() {
        Vector<String> knList = new Vector<String>();
        for (KeyVal kv : this.getKeyValList()) {
            knList.add(kv.getKey());
        }
        return knList;
    }

    public URIArg addArg(String key, double value) {
        return this._addArg(key, String.valueOf(value), true, false);
    }

    public URIArg addArg(String key, int value) {
        return this._addArg(key, String.valueOf(value), true, false);
    }

    public URIArg addArg(String key, long value) {
        return this._addArg(key, String.valueOf(value), true, false);
    }

    public URIArg addArg(String key, RTProperties rtp) {
        String r;
        String string = r = rtp != null ? rtp.toString() : null;
        if (!StringTools.isBlank(r)) {
            return this._addArg(key, URIArg.encodeRTP(rtp), false, false);
        }
        return this.addArg(key, "");
    }

    public URIArg addArg(String key, String value) {
        return this._addArg(key, value, true, false);
    }

    public URIArg addArg(String key, String value, boolean obfuscate) {
        return this._addArg(key, value, true, obfuscate);
    }

    protected URIArg _addArg(String key, String value, boolean encode, boolean obfuscate) {
        if (!StringTools.isBlank(key)) {
            String val = encode ? this.encodeArg(value, obfuscate) : value;
            this.getKeyValList().add(new KeyVal(key, val));
        }
        return this;
    }

    protected URIArg addArg(KeyVal keyVal) {
        if (keyVal != null) {
            this.getKeyValList().add(new KeyVal(keyVal));
        }
        return this;
    }

    public URIArg removeArg(String key) {
        if (key != null) {
            Iterator<KeyVal> i = this.getKeyValList().iterator();
            while (i.hasNext()) {
                KeyVal kv = i.next();
                if (!kv.getKey().equals(key)) continue;
                i.remove();
            }
        }
        return this;
    }

    public URIArg removeArg(String[] keys) {
        if (keys != null) {
            for (String k : keys) {
                this.removeArg(k);
            }
        }
        return this;
    }

    public URIArg removeBlankValues() {
        Iterator<KeyVal> i = this.getKeyValList().iterator();
        while (i.hasNext()) {
            KeyVal kv = i.next();
            if (kv.hasValue()) continue;
            i.remove();
        }
        return this;
    }

    public boolean hasArg(String key) {
        return this.getKeyVal(key) != null;
    }

    public boolean hasArg(String[] key) {
        return this.getKeyVal(key) != null;
    }

    public boolean setArgValue(String key, int value) {
        return this.setArgValue(key, String.valueOf(value), false);
    }

    public boolean setArgValue(String key, String value) {
        return this.setArgValue(key, value, false);
    }

    public boolean setArgValue(String key, String value, boolean obfuscate) {
        if (key != null) {
            KeyVal kv = this.getKeyVal(key);
            if (kv != null) {
                kv.setValue(this.encodeArg(value, obfuscate));
                return true;
            }
            this.addArg(key, value, obfuscate);
            return true;
        }
        return false;
    }

    public boolean setArgValue(String[] key, int value) {
        return this.setArgValue(key, String.valueOf(value), false);
    }

    public boolean setArgValue(String[] key, String value) {
        return this.setArgValue(key, value, false);
    }

    public boolean setArgValue(String[] key, String value, boolean obfuscate) {
        if (ListTools.size(key) >= 1) {
            boolean hadArg = this.hasArg(key);
            for (int i = 1; i < key.length; ++i) {
                this.removeArg(key[i]);
            }
            this.setArgValue(key[0], value, obfuscate);
            return hadArg;
        }
        return false;
    }

    protected KeyVal getKeyVal(String key) {
        if (key != null) {
            Collection<KeyVal> kvList = this.getKeyValList();
            for (KeyVal kv : kvList) {
                if (!kv.getKey().equals(key)) continue;
                return kv;
            }
            return null;
        }
        return null;
    }

    protected KeyVal getKeyVal(String[] keys) {
        if (keys != null) {
            for (String k : keys) {
                KeyVal kv = this.getKeyVal(k);
                if (kv == null) continue;
                return kv;
            }
        }
        return null;
    }

    public String getArgValue(String key) {
        KeyVal kv = this.getKeyVal(key);
        return kv != null ? kv.getValue() : null;
    }

    public String getArgValue(String[] keys) {
        KeyVal kv = this.getKeyVal(keys);
        return kv != null ? kv.getValue() : null;
    }

    public String getArgString() {
        return this.getArgString(null).toString();
    }

    public StringBuffer getArgString(StringBuffer sbuff) {
        return this.getArgString(sbuff, true);
    }

    public StringBuffer getArgString(StringBuffer sbuff, boolean includeBlankValues) {
        StringBuffer sb = sbuff != null ? sbuff : new StringBuffer();
        int argCnt = 0;
        for (KeyVal kv : this.getKeyValList()) {
            if (!includeBlankValues && !kv.hasValue()) continue;
            if (argCnt > 0) {
                sb.append("&");
            }
            sb.append(kv.toString());
            ++argCnt;
        }
        return sb;
    }

    public RTProperties getArgProperties() {
        RTProperties rtp = new RTProperties();
        for (KeyVal kv : this.getKeyValList()) {
            rtp.setString(kv.getKey(), this.decodeArg(kv.getValue()));
        }
        return rtp;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeBlankValues) {
        StringBuffer sb = new StringBuffer(this.getURI());
        if (!ListTools.isEmpty(this.getKeyValList())) {
            sb.append("?");
            this.getArgString(sb, includeBlankValues);
        }
        return sb.toString();
    }

    public URIArg rtpEncode(String rtpKey, String ... exclKeys) {
        URIArg rtpUrl = new URIArg(this.getURI());
        RTProperties rtp = new RTProperties();
        for (KeyVal kv : this.getKeyValList()) {
            String kn = kv.getKey();
            if (ListTools.contains(exclKeys, kn)) {
                rtpUrl.addArg(kv);
                continue;
            }
            rtp.setString(kn, kv.getValue());
        }
        rtpUrl.addArg(rtpKey, rtp);
        return rtpUrl;
    }

    public URIArg rtpDecode(String rtpKey) {
        URIArg cpyUrl = new URIArg(this.getURI());
        for (KeyVal kv : this.getKeyValList()) {
            String kn = kv.getKey();
            if (!kn.equals(rtpKey)) {
                cpyUrl.addArg(kv);
                continue;
            }
            RTProperties rtp = URIArg.parseRTP(kv.getValue());
            for (Object rpk : rtp.getPropertyKeys()) {
                String rk = rpk.toString();
                String rv = rtp.getString(rk, "");
                cpyUrl.addArg(rk, rv);
            }
        }
        return cpyUrl;
    }

    public URL toURL() throws MalformedURLException {
        return new URL(this.toString());
    }

    public String getProtocol() {
        try {
            URL url = new URL(this.getURI());
            return url.getProtocol();
        }
        catch (MalformedURLException mue) {
            return null;
        }
    }

    public boolean setProtocol(String _proto) {
        String uri = this.getURI();
        if (!StringTools.isBlank(_proto) && URIArg.isAbsoluteURL(uri)) {
            try {
                URL oldURI = new URL(uri);
                String proto = _proto;
                String host = oldURI.getHost();
                int port = oldURI.getPort();
                String file = oldURI.getFile();
                URL newURI = new URL(proto, host, port, file);
                this._setURI(newURI.toString());
                return true;
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return false;
    }

    public String getHost() {
        try {
            URL url = new URL(this.getURI());
            return url.getHost();
        }
        catch (MalformedURLException mue) {
            return null;
        }
    }

    public boolean setHost(String _host) {
        String uri = this.getURI();
        if (!StringTools.isBlank(_host) && URIArg.isAbsoluteURL(uri)) {
            try {
                URL oldURI = new URL(uri);
                String proto = oldURI.getProtocol();
                String host = _host;
                int port = oldURI.getPort();
                String file = oldURI.getFile();
                URL newURI = new URL(proto, host, port, file);
                this._setURI(newURI.toString());
                return true;
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return false;
    }

    public int getPort() {
        try {
            URL url = new URL(this.getURI());
            return url.getPort();
        }
        catch (MalformedURLException mue) {
            return -1;
        }
    }

    public boolean setPort(int _port) {
        String uri = this.getURI();
        if (_port > 0 && URIArg.isAbsoluteURL(uri)) {
            try {
                URL oldURI = new URL(uri);
                String proto = oldURI.getProtocol();
                String host = oldURI.getHost();
                int port = _port;
                String file = oldURI.getFile();
                URL newURI = new URL(proto, host, port, file);
                this._setURI(newURI.toString());
                return true;
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return false;
    }

    public String getFile() {
        try {
            URL url = new URL(this.getURI());
            return url.getFile();
        }
        catch (MalformedURLException mue) {
            return null;
        }
    }

    private String encodeArg(String s, boolean obfuscateAll) {
        StringBuffer sb = URIArg.encodeArg(null, s, obfuscateAll);
        return sb.toString();
    }

    private String decodeArg(String s) {
        StringBuffer sb = URIArg.decodeArg(null, s);
        return sb.toString();
    }

    private static void usage() {
        Print.logInfo("Usage:", new Object[0]);
        Print.logInfo("  java ... " + URIArg.class.getName() + " {options}", new Object[0]);
        Print.logInfo("Options:", new Object[0]);
        Print.logInfo("  -encode=<ASCII>    Encode ASCII string to URL argument string", new Object[0]);
        Print.logInfo("  -decode=<args>     Decode URL argument string to ASCII", new Object[0]);
        Print.logInfo("  -rtpEnc=<url>      RTP Encode URL [key = 'rtp']", new Object[0]);
        Print.logInfo("  -rtpDec=<url>      RTP Decode URL [key = 'rtp']", new Object[0]);
        System.exit(1);
    }

    public static void main(String[] argv) {
        RTConfig.setCommandLineArgs(argv);
        if (RTConfig.hasProperty(ARG_DECODE)) {
            String a = RTConfig.getString(ARG_DECODE, "");
            String s = URIArg.decodeArg(new StringBuffer(), a).toString();
            Print.sysPrintln("ASCII: " + s, new Object[0]);
            System.exit(0);
        }
        if (RTConfig.hasProperty(ARG_ENCODE)) {
            String s = RTConfig.getString(ARG_ENCODE, "");
            String a = URIArg.encodeArg(new StringBuffer(), s).toString();
            Print.sysPrintln("Args: " + a, new Object[0]);
            System.exit(0);
        }
        if (RTConfig.hasProperty(ARG_RTPDEC)) {
            URIArg rtpUrl = new URIArg(RTConfig.getString(ARG_RTPDEC, ""));
            URIArg decUrl = rtpUrl.rtpDecode("rtp");
            Print.sysPrintln("URL: " + decUrl.toString(), new Object[0]);
            System.exit(0);
        }
        if (RTConfig.hasProperty(ARG_RTPENC)) {
            URIArg decUrl = new URIArg(RTConfig.getString(ARG_RTPENC, ""));
            URIArg rtpUrl = decUrl.rtpEncode("rtp", new String[0]);
            Print.sysPrintln("URL: " + rtpUrl.toString(), new Object[0]);
            System.exit(0);
        }
        URIArg.usage();
    }

    protected class KeyVal {
        private String key = "";
        private String val = "";

        public KeyVal(KeyVal kv) {
            this.key = kv != null ? kv.getKey() : "";
            this.val = kv != null ? kv.getValue() : "";
        }

        public KeyVal(String key, String val) {
            this.key = key != null ? key : "";
            this.val = val != null ? val : "";
        }

        public String getKey() {
            return this.key;
        }

        public boolean hasValue() {
            return this.val != null && !this.val.equals("");
        }

        public String getValue() {
            return this.val;
        }

        public void setValue(String val) {
            this.val = val != null ? val : "";
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(this.key);
            if (this.hasValue()) {
                sb.append("=").append(this.val);
            }
            return sb.toString();
        }

        public boolean equals(Object other) {
            if (!(other instanceof KeyVal)) {
                return false;
            }
            if (URIArg.this.hasUniqueKeys()) {
                return this.getKey().equals(((KeyVal)other).getKey());
            }
            return this.toString().equals(other.toString());
        }
    }
}

