/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.util;

import java.util.List;
import java.util.Vector;
import org.opengts.util.JSON;
import org.opengts.util.ListTools;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;
import org.opengts.util.RTProperties;
import org.opengts.util.StringTools;

public class TreeNode {
    public static final String SLASH_SEPARATOR = "/";
    public static final char SLASH_SEPARATOR_CHAR = '/';
    private String name = "";
    private String description = "";
    private int type = 0;
    private TreeNode parent = null;
    private List<TreeNode> children = null;
    private RTProperties rtProp = null;
    private Object value = null;
    public static final String JSON_Key_name = "name";
    public static final String JSON_Key_description = "description";
    public static final String JSON_Key_children = "children";

    public static TreeNode createTreePath(TreeNode parent, String[] name) {
        return TreeNode.createTreePath(parent, name, null);
    }

    public static TreeNode createTreePath(TreeNode parent, String[] name, Class<? extends TreeNode> treeNodeClass) {
        if (ListTools.isEmpty(name)) {
            return parent;
        }
        if (parent == null) {
            Print.logStackTrace("Parent is null!");
            return null;
        }
        TreeNode tn = parent;
        try {
            for (int n = 0; n < name.length; ++n) {
                TreeNode sn = tn.getChildByName(name[n]);
                if (sn == null) {
                    sn = treeNodeClass != null ? treeNodeClass.newInstance() : new TreeNode();
                    sn.setName(name[n]);
                    tn.addChild(sn);
                }
                tn = sn;
            }
        }
        catch (Throwable th) {
            return null;
        }
        return tn;
    }

    public static TreeNode getTreePath(TreeNode parent, String[] name) {
        if (ListTools.isEmpty(name)) {
            return parent;
        }
        if (parent == null) {
            Print.logStackTrace("Parent is null!");
            return null;
        }
        TreeNode tn = parent;
        for (int n = 0; n < name.length; ++n) {
            TreeNode sn = tn.getChildByName(name[n]);
            if (sn == null) {
                return null;
            }
            tn = sn;
        }
        return tn;
    }

    public static List<String> flattenTree(List<String> list, String prefix, char sep, TreeNode parent) {
        if (list == null) {
            list = new Vector<String>();
        }
        if (parent == null) {
            return list;
        }
        String name = parent.getName();
        prefix = StringTools.trim(prefix) + sep + name;
        list.add(prefix);
        Print.sysPrintln(prefix, new Object[0]);
        if (parent.hasChildren()) {
            for (TreeNode tn : parent.getChildren()) {
                TreeNode.flattenTree(list, prefix, sep, tn);
            }
        }
        return list;
    }

    public static <TN extends TreeNode> void printTree(TN parent) {
        if (parent != null) {
            parent.printChildren(0);
        }
    }

    public TreeNode() {
    }

    public TreeNode(String name) {
        this.setName(name);
    }

    public TreeNode(String name, List<TreeNode> children) {
        this(name);
        this.addChildren(children);
    }

    public void setName(String name) {
        this.name = StringTools.trim(name);
    }

    public String getName() {
        return this.name;
    }

    public void setType(int type) {
        this.type = type;
    }

    public int getType() {
        return this.type;
    }

    public void setDescription(String desc) {
        this.description = StringTools.trim(desc);
    }

    public String getDescription() {
        if (!StringTools.isBlank(this.description)) {
            return this.description;
        }
        return this.getName();
    }

    public List<TreeNode> getChildren() {
        return this.children;
    }

    public boolean hasChildren() {
        return !ListTools.isEmpty(this.children);
    }

    public int size() {
        return ListTools.size(this.children);
    }

    public void addChildren(List<TreeNode> children) {
        if (children != null) {
            for (TreeNode tn : children) {
                this.addChild(tn);
            }
        }
    }

    public TreeNode addChild(TreeNode node) {
        if (node == null) {
            return null;
        }
        if (this.isAncestor(node)) {
            Print.logStackTrace("Attempting to add an ancestor to this node");
            return null;
        }
        if (this.children == null) {
            this.children = new Vector<TreeNode>();
        }
        this.children.add(node);
        node.setParent(this);
        return node;
    }

    public TreeNode getChildAt(int ndx) {
        List<TreeNode> chList = this.getChildren();
        if (chList != null && ndx >= 0 && ndx < chList.size()) {
            return chList.get(ndx);
        }
        return null;
    }

    public TreeNode getChildByName(String name) {
        if (StringTools.isBlank(name)) {
            return null;
        }
        if (this.hasChildren()) {
            for (TreeNode tn : this.getChildren()) {
                if (!tn.getName().equals(name)) continue;
                return tn;
            }
        }
        return null;
    }

    public TreeNode getChildByPath(String[] name) {
        if (ListTools.isEmpty(name)) {
            return null;
        }
        TreeNode tn = this.getChildByName(name[0]);
        for (int n = 1; tn != null && n < name.length; tn = tn.getChildByName(name[n]), ++n) {
        }
        return tn;
    }

    public TreeNode getChildByValue(Object val) {
        if (val == null) {
            return null;
        }
        if (this.hasChildren()) {
            for (TreeNode tn : this.getChildren()) {
                Object v = tn.getObject();
                if (v == null || !val.equals(v)) continue;
                return tn;
            }
        }
        return null;
    }

    public boolean removeChild(TreeNode tn) {
        if (this.children != null && this.children.contains(tn)) {
            tn.setParent(null);
            this.children.remove(tn);
            return true;
        }
        return false;
    }

    public boolean removeFromParent() {
        TreeNode parent = this.getParent();
        if (parent != null) {
            parent.removeChild(this);
            return true;
        }
        return false;
    }

    public boolean hasNextSibling() {
        return this.getNextSibling() != null;
    }

    public TreeNode getNextSibling() {
        TreeNode parent = this.getParent();
        if (parent == null) {
            return null;
        }
        List<TreeNode> siblings = parent.getChildren();
        if (siblings != null) {
            int sz = siblings.size();
            for (int n = 0; n < sz; ++n) {
                if (siblings.get(n) != this) continue;
                return n + 1 < sz ? siblings.get(n + 1) : null;
            }
        }
        return null;
    }

    public boolean hasPreviousSibling() {
        return this.getPreviousSibling() != null;
    }

    public TreeNode getPreviousSibling() {
        TreeNode parent = this.getParent();
        if (parent == null) {
            return null;
        }
        List<TreeNode> siblings = parent.getChildren();
        if (siblings != null) {
            int sz = siblings.size();
            for (int n = 0; n < sz; ++n) {
                if (siblings.get(n) != this) continue;
                return n - 1 >= 0 ? siblings.get(n - 1) : null;
            }
        }
        return null;
    }

    protected void setParent(TreeNode node) {
        this.parent = node;
    }

    protected TreeNode getParent() {
        return this.parent;
    }

    public boolean hasParent() {
        return this.parent != null;
    }

    public boolean isRootNode() {
        return this.parent == null;
    }

    public boolean isAncestor(TreeNode node) {
        if (node == null) {
            return false;
        }
        for (TreeNode tn = this; tn != null; tn = tn.getParent()) {
            if (node != tn) continue;
            return true;
        }
        return false;
    }

    public boolean isOffspring(TreeNode node) {
        if (node == null) {
            return false;
        }
        if (this.hasChildren()) {
            for (TreeNode tn : this.getChildren()) {
                if (!tn.isOffspring(node)) continue;
                return true;
            }
        }
        return false;
    }

    public int getLevel() {
        return this.getLevel(null);
    }

    public int getLevel(TreeNode parent) {
        int L = 0;
        TreeNode tn = this.getParent();
        while (tn != null && tn != parent) {
            tn = tn.getParent();
            ++L;
        }
        return L;
    }

    public TreeNode[] getPath() {
        return this.getPath(null);
    }

    public TreeNode[] getPath(TreeNode parent) {
        Vector<TreeNode> path = new Vector<TreeNode>();
        for (TreeNode tn = this; tn != null && tn != parent; tn = tn.getParent()) {
            path.add(tn);
        }
        int pathLen = path.size();
        TreeNode[] pathStr = new TreeNode[pathLen];
        for (int i = 0; i < pathLen; ++i) {
            pathStr[i] = (TreeNode)path.get(pathLen - 1 - i);
        }
        return pathStr;
    }

    public String[] getPathNames() {
        return this.getPathNames(null);
    }

    public String[] getPathNames(TreeNode parent) {
        TreeNode[] tn = this.getPath(parent);
        if (ListTools.isEmpty(tn)) {
            return new String[0];
        }
        String[] pn = new String[tn.length];
        for (int i = 0; i < pn.length; ++i) {
            pn[i] = tn[i].getName();
        }
        return pn;
    }

    public String getPathName(String sep) {
        return this.getPathName(null, sep);
    }

    public String getPathName(TreeNode parent, String sep) {
        String s = sep != null ? sep : SLASH_SEPARATOR;
        StringBuffer sb = new StringBuffer();
        for (TreeNode tn : this.getPath(parent)) {
            sb.append(s).append(tn.getName());
        }
        return sb.toString();
    }

    public String[] getPathDescriptions() {
        return this.getPathDescriptions(null);
    }

    public String[] getPathDescriptions(TreeNode parent) {
        TreeNode[] tn = this.getPath(parent);
        if (ListTools.isEmpty(tn)) {
            return new String[0];
        }
        String[] pn = new String[tn.length];
        for (int i = 0; i < pn.length; ++i) {
            String d = tn[i].getDescription();
            pn[i] = !StringTools.isBlank(d) ? d : tn[i].getName();
        }
        return pn;
    }

    public String getPathDescription(String sep) {
        return this.getPathDescription(null, sep);
    }

    public String getPathDescription(TreeNode parent, String sep) {
        String s = sep != null ? sep : SLASH_SEPARATOR;
        StringBuffer sb = new StringBuffer();
        for (TreeNode tn : this.getPath(parent)) {
            sb.append(s);
            String d = tn.getDescription();
            sb.append(!StringTools.isBlank(d) ? d : tn.getName());
        }
        return sb.toString();
    }

    public TreeNode traverseTree(TreeNodeHandler tnh) {
        if (tnh == null) {
            return null;
        }
        if (tnh.startNode(this)) {
            return this;
        }
        if (this.hasChildren()) {
            for (TreeNode tn : this.getChildren()) {
                TreeNode foundNode = tn.traverseTree(tnh);
                if (foundNode == null) continue;
                return foundNode;
            }
        }
        tnh.endNode(this);
        return null;
    }

    public TreeNode findChildByName(final String name) {
        return this.traverseTree(new TreeNodeHandler(){

            @Override
            public boolean startNode(TreeNode tn) {
                return tn != null && tn.getName().equals(name);
            }

            @Override
            public void endNode(TreeNode tn) {
            }
        });
    }

    public TreeNode findChildByProperty(final String key, final Object value) {
        if (StringTools.isBlank(key)) {
            return null;
        }
        return this.traverseTree(new TreeNodeHandler(){

            @Override
            public boolean startNode(TreeNode tn) {
                if (tn == null) {
                    return false;
                }
                if (!tn.hasProperty(key)) {
                    return false;
                }
                Object v = tn.getProperty(key);
                if (v == value) {
                    return true;
                }
                return v != null && v.equals(value);
            }

            @Override
            public void endNode(TreeNode tn) {
            }
        });
    }

    public JSON._Array getJsonChildrenArray() {
        JSON._Array children = null;
        if (this.hasChildren()) {
            children = new JSON._Array();
            for (TreeNode tn : this.getChildren()) {
                children.addValue(tn.getJsonObject());
            }
        }
        return children;
    }

    public JSON._Object getJsonObject() {
        return this._setJsonNodeValues(new JSON._Object(), this.getName(), this.getDescription(), this.getJsonChildrenArray());
    }

    protected JSON._Object _setJsonNodeValues(JSON._Object jsonObj, String name, String desc, JSON._Array children) {
        jsonObj.addKeyValue(JSON_Key_name, name);
        jsonObj.addKeyValue(JSON_Key_description, desc);
        if (children != null) {
            jsonObj.addKeyValue(JSON_Key_children, children);
        }
        return jsonObj;
    }

    public String toString() {
        return this.getPathName(SLASH_SEPARATOR);
    }

    public String toString(String sep) {
        return this.getPathName(sep);
    }

    public void printChildren() {
        this.printChildren(-1);
    }

    public void printChildren(int lvl) {
        int level = lvl >= 0 ? lvl : this.getLevel();
        String sep = SLASH_SEPARATOR;
        String indent = StringTools.replicateString("    ", level);
        String desc = this.getDescription();
        if (StringTools.isBlank(desc)) {
            desc = this.getName();
        }
        StringBuffer sb = new StringBuffer();
        sb.append(indent).append(desc);
        if (this.hasChildren()) {
            sb.append(":");
            Print.sysPrintln(sb.toString(), new Object[0]);
            for (TreeNode tn : this.getChildren()) {
                tn.printChildren(level + 1);
            }
        } else {
            Print.sysPrintln(sb.toString(), new Object[0]);
        }
    }

    public boolean equals(Object other) {
        if (!(other instanceof TreeNode)) {
            return false;
        }
        return other == this;
    }

    public RTProperties getProperties() {
        if (this.rtProp == null) {
            this.rtProp = new RTProperties();
        }
        return this.rtProp;
    }

    public boolean hasProperties() {
        return this.rtProp != null && !this.rtProp.isEmpty();
    }

    public boolean hasProperty(String key) {
        return this.rtProp != null ? this.rtProp.hasProperty(key) : false;
    }

    public Object getProperty(String key, Object dft) {
        return this.rtProp != null ? this.rtProp.getProperty(key, dft) : null;
    }

    public Object getProperty(String key) {
        return this.getProperty(key, null);
    }

    public void setProperty(String key, Object val) {
        this.getProperties().setProperty((Object)key, val);
    }

    public void setObject(Object val) {
        this.value = val;
    }

    public Object getObject() {
        return this.value;
    }

    public boolean hasObject() {
        return this.value != null;
    }

    public boolean isLeaf() {
        return this.value != null;
    }

    public static void main(String[] argv) {
        RTConfig.setCommandLineArgs(argv);
        String[] list = new String[]{"AA/BA/CA/DA/EA", "AA/BA/CA/DA/EB", "AA/BA/CA/DB/EA", "AA/BA/CA/DB/EB", "AA/BA/CA/DB/EC", "AA/BA/CA/DC/EA", "AA/BA/CB/DA/EA", "AA/BA/CB/DA/EB", "AA/BA/CB/DB/EA", "AA/BA/CB/DB/EB", "AA/BA/CB/DB/EC", "AA/BA/CB/DC/EA", "AA/BB/CA/DA/EA", "AA/BB/CA/DA/EB", "AA/BB/CA/DB/EA", "AA/BB/CA/DB/EB", "AA/BB/CA/DB/EC", "AA/BB/CA/DC/EA", "AA/BB/CB/DA/EA", "AA/BB/CB/DA/EB", "AA/BB/CB/DB/EA", "AA/BB/CB/DB/EB", "AA/BB/CB/DB/EC", "AA/BB/CB/DC/EA"};
        TreeNode root = new TreeNode("root");
        for (String a : list) {
            String[] aa = StringTools.split(a, '/');
            TreeNode.createTreePath(root, aa);
        }
        TreeNode.printTree(root);
        Vector<String> flatList = new Vector<String>();
        TreeNode.flattenTree(flatList, "", '-', root);
        JSON._Object jsonObj = root.getJsonObject();
        Print.sysPrintln("JSON:\n" + jsonObj, new Object[0]);
    }

    public static interface TreeNodeHandler {
        public boolean startNode(TreeNode var1);

        public void endNode(TreeNode var1);
    }
}

