/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.util;

import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.WeakHashMap;
import org.opengts.util.DateTime;
import org.opengts.util.ListTools;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;
import org.opengts.util.RTKey;
import org.opengts.util.StringTools;

public class ThreadPool {
    private static final int DFT_POOL_SIZE = 20;
    private static final int DFT_MAX_IDLE_AGE_SEC = 0;
    private static final long DFT_MAX_IDLE_AGE_MS = 0L;
    private static final int DFT_MAX_QUEUE_SIZE = 0;
    public static final int STOP_WAITING = -1;
    public static final int STOP_NEVER = 0;
    public static final int STOP_NOW = 1;
    private static boolean globalStopThreadsNow = false;
    private static Map<ThreadPool, String> threadPoolList = new WeakHashMap<ThreadPool, String>();
    private ThreadGroup poolGroup = null;
    private int maxPoolSize = 20;
    private long maxIdleAgeMS = 0L;
    private List<ThreadJob> jobThreadPool = null;
    private int threadId = 1;
    private List<Runnable> jobQueue = null;
    private int maxQueueSize = 0;
    private int waitingCount = 0;
    private int stopThreads = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void _AddThreadPool(ThreadPool tp) {
        if (tp != null) {
            Map<ThreadPool, String> map = threadPoolList;
            synchronized (map) {
                try {
                    if (!threadPoolList.containsKey(tp)) {
                        threadPoolList.put(tp, "");
                    }
                }
                catch (Throwable th) {
                    Print.logException("ThreadPool weak reference list", th);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void StopThreads(boolean stopNow) {
        Map<ThreadPool, String> map = threadPoolList;
        synchronized (map) {
            if (stopNow) {
                globalStopThreadsNow = true;
            }
            for (ThreadPool tp : threadPoolList.keySet()) {
                tp.stopThreads(stopNow);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int GetTotalThreadCount() {
        int count = 0;
        Map<ThreadPool, String> map = threadPoolList;
        synchronized (map) {
            for (ThreadPool tp : threadPoolList.keySet()) {
                count += tp.getPoolSize();
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int PrintThreadCount() {
        int count = 0;
        Map<ThreadPool, String> map = threadPoolList;
        synchronized (map) {
            for (ThreadPool tp : threadPoolList.keySet()) {
                String n = tp.getName();
                int s = tp.getPoolSize();
                Print.logInfo("ThreadPool '" + n + "' size=" + s, new Object[0]);
                count += s;
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StringBuffer GetThreadPoolState(StringBuffer sb) {
        if (sb == null) {
            sb = new StringBuffer();
        }
        Map<ThreadPool, String> map = threadPoolList;
        synchronized (map) {
            sb.append("ThreadPools:\n");
            if (!ListTools.isEmpty(threadPoolList)) {
                for (ThreadPool tp : threadPoolList.keySet()) {
                    String name = tp.getName();
                    int pSize = tp.getPoolSize();
                    int maxPSize = tp.getMaxPoolSize();
                    int active = tp.getActiveCount();
                    int qSize = tp.getQueueSize();
                    int maxQSize = tp.getMaxQueueSize();
                    sb.append("  ");
                    sb.append("Name=").append(name).append(" ");
                    int n = name.length();
                    for (int s = 18; s > n; --s) {
                        sb.append(" ");
                    }
                    sb.append("MaxPoolSize=").append(maxPSize).append("  ");
                    sb.append("PoolSize=").append(pSize).append("  ");
                    sb.append("Active=").append(active).append("  ");
                    sb.append("MaxQueueSize=").append(maxQSize).append("  ");
                    sb.append("QueueSize=").append(qSize).append("  ");
                    sb.append("\n");
                }
            } else {
                sb.append("  ");
                sb.append("None");
                sb.append("\n");
            }
        }
        return sb;
    }

    public ThreadPool(String name) {
        this(name, 20, 0, 0);
    }

    public ThreadPool(String name, int maxPoolSize) {
        this(name, maxPoolSize, 0, 0);
    }

    public ThreadPool(String name, int maxPoolSize, int maxIdleSec, int maxQueueSize) {
        this(name, RTKey.valueOf(!StringTools.isBlank(name) ? "ThreadPool." + name : null), maxPoolSize, maxIdleSec, maxQueueSize);
    }

    public ThreadPool(String name, RTKey propPfx_, int maxPoolSize, int maxIdleSec, int maxQueueSize) {
        String groupName = !StringTools.isBlank(name) ? name.trim() : "ThreadPool";
        this.poolGroup = new ThreadGroup(groupName);
        this.jobThreadPool = new Vector<ThreadJob>();
        this.jobQueue = new Vector<Runnable>();
        int n = this.stopThreads = globalStopThreadsNow ? 1 : 0;
        if (!RTKey.isBlank(propPfx_)) {
            this.setMaxPoolSize(propPfx_.rtSuffix("maximumPoolSize"), maxPoolSize);
            this.setMaxIdleSec(propPfx_.rtSuffix("maximumIdleSeconds"), maxIdleSec);
            this.setMaxQueueSize(propPfx_.rtSuffix("maximumQueueSize"), maxQueueSize);
        } else {
            this.setMaxPoolSize(maxPoolSize);
            this.setMaxIdleSec(maxIdleSec);
            this.setMaxQueueSize(maxQueueSize);
        }
        ThreadPool._AddThreadPool(this);
    }

    public String getName() {
        return this.getThreadGroup().getName();
    }

    public String toString() {
        return this.getName();
    }

    public boolean equals(Object other) {
        return this == other;
    }

    public ThreadGroup getThreadGroup() {
        return this.poolGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getActiveCount() {
        int cnt = 0;
        List<ThreadJob> list = this.jobThreadPool;
        synchronized (list) {
            for (ThreadJob tj : this.jobThreadPool) {
                if (!tj.isRunning()) continue;
                ++cnt;
            }
        }
        return cnt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPoolSize() {
        int size = 0;
        List<ThreadJob> list = this.jobThreadPool;
        synchronized (list) {
            size = this.jobThreadPool.size();
        }
        return size;
    }

    public void setMaxPoolSize(int maxSize) {
        this.maxPoolSize = maxSize > 0 ? maxSize : 20;
    }

    public void setMaxPoolSize(RTKey propKey, int dftMaxSize) {
        int propMps;
        int n = propMps = propKey != null ? RTConfig.getInt(propKey.toString(), -1) : -1;
        this.maxPoolSize = propMps > 0 ? propMps : (dftMaxSize > 0 ? dftMaxSize : 20);
        Print.logDebug("[" + this.getName() + "] ThreadPool 'maximumPoolSize': " + this.maxPoolSize, new Object[0]);
    }

    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public void setMaxIdleSec(int maxIdleSec) {
        this.setMaxIdleMS((long)maxIdleSec * 1000L);
    }

    public void setMaxIdleSec(RTKey propKeySec, int dftMaxIdleSec) {
        int propMidSec;
        int n = propMidSec = propKeySec != null ? RTConfig.getInt(propKeySec.toString(), -1) : -1;
        if (propMidSec >= 0) {
            this.setMaxIdleMS((long)propMidSec * 1000L);
        } else if (dftMaxIdleSec >= 0) {
            this.setMaxIdleMS((long)dftMaxIdleSec * 1000L);
        } else {
            this.setMaxIdleMS(0L);
        }
        Print.logDebug("[" + this.getName() + "] ThreadPool 'maximumIdleSec': " + this.getMaxIdleMS() / 1000L, new Object[0]);
    }

    public void setMaxIdleMS(long maxIdleMS) {
        this.maxIdleAgeMS = maxIdleMS >= 0L ? maxIdleMS : 0L;
    }

    public long getMaxIdleMS() {
        return this.maxIdleAgeMS;
    }

    public void setMaxQueueSize(int maxQSize) {
        this.maxQueueSize = maxQSize >= 0 ? maxQSize : 0;
    }

    public void setMaxQueueSize(RTKey propKey, int dftMaxQSize) {
        int propMqs;
        int n = propMqs = propKey != null ? RTConfig.getInt(propKey.toString(), -1) : -1;
        this.maxQueueSize = propMqs > 0 ? propMqs : (dftMaxQSize > 0 ? dftMaxQSize : 0);
        Print.logDebug("[" + this.getName() + "] ThreadPool 'maximumQueueSize': " + this.maxQueueSize, new Object[0]);
    }

    public int getMaxQueueSize() {
        return this.maxQueueSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean run(Runnable job) {
        if (job == null) {
            return false;
        }
        if (this.stopThreads == 1) {
            return false;
        }
        int maxQueueSize = this.getMaxQueueSize();
        boolean addedJob = false;
        List<ThreadJob> list = this.jobThreadPool;
        synchronized (list) {
            List<Runnable> list2 = this.jobQueue;
            synchronized (list2) {
                if (maxQueueSize <= 0 || this.jobQueue.size() < maxQueueSize) {
                    this.jobQueue.add(job);
                    if (this.waitingCount == 0 && this.jobThreadPool.size() < this.maxPoolSize) {
                        String tn = StringTools.format(this.threadId++, "000").trim();
                        ThreadJob tj = new ThreadJob(this, this.getName() + "_" + tn);
                        this.jobThreadPool.add(tj);
                        Print.logDebug("New Thread: " + tj.getName() + " [" + this.getMaxPoolSize() + "]", new Object[0]);
                    }
                    this.jobQueue.notify();
                    addedJob = true;
                }
            }
        }
        return addedJob;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getQueueSize() {
        int qsize = 0;
        List<Runnable> list = this.jobQueue;
        synchronized (list) {
            qsize = this.jobQueue.size();
        }
        return qsize;
    }

    public void stopThreads() {
        this.stopThreads(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopThreads(boolean stopNow) {
        List<Runnable> list = this.jobQueue;
        synchronized (list) {
            this.stopThreads = stopNow ? 1 : -1;
            this.jobQueue.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _removeThreadJob(ThreadJob thread) {
        if (thread != null) {
            List<ThreadJob> list = this.jobThreadPool;
            synchronized (list) {
                this.jobThreadPool.remove(thread);
            }
        }
    }

    public static void main(String[] argv) {
        int i;
        RTConfig.setCommandLineArgs(argv);
        RTKey propPfx = RTKey.valueOf(RTConfig.getString("prop", null));
        ThreadPool pool_1 = new ThreadPool("Test_1", propPfx, 3, -1, -1);
        ThreadPool pool_2 = new ThreadPool("Test_2", 3);
        for (i = 0; i < 15; ++i) {
            final int n = i;
            Print.logInfo("Job " + i, new Object[0]);
            Runnable job = new Runnable(){
                int num;
                {
                    this.num = n;
                }

                @Override
                public void run() {
                    Print.logInfo("Start Job: " + this.getName(), new Object[0]);
                    try {
                        Thread.sleep(2000 + this.num * 89);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    Print.logInfo("Stop  Job:                " + this.getName(), new Object[0]);
                }

                public String getName() {
                    return "[" + Thread.currentThread().getName() + "] " + this.num;
                }
            };
            if ((i & 1) == 0) {
                pool_1.run(job);
            } else {
                pool_2.run(job);
            }
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        Print.logInfo("Stop Threads", new Object[0]);
        ThreadPool.StopThreads(true);
        for (i = 0; i < 20; ++i) {
            Print.sysPrintln("---------------------------", new Object[0]);
            int cnt = ThreadPool.PrintThreadCount();
            if (cnt <= 0) break;
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        Print.sysPrintln("Total Thread Count: " + ThreadPool.GetTotalThreadCount(), new Object[0]);
    }

    private static class ThreadJob
    extends Thread {
        private ThreadPool threadPool = null;
        private Runnable job = null;
        private long creationTimeMS = 0L;
        private long lastUsedTimeMS = 0L;

        public ThreadJob(ThreadPool pool, String name) {
            super(pool.getThreadGroup(), name);
            this.threadPool = pool;
            this.lastUsedTimeMS = this.creationTimeMS = DateTime.getCurrentTimeMillis();
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                boolean stop = false;
                List list = this.threadPool.jobQueue;
                synchronized (list) {
                    while (this.job == null) {
                        if (this.threadPool.stopThreads == 1) {
                            stop = true;
                            break;
                        }
                        if (this.threadPool.jobQueue.size() > 0) {
                            this.job = (Runnable)this.threadPool.jobQueue.remove(0);
                            continue;
                        }
                        if (this.threadPool.stopThreads == -1) {
                            stop = true;
                            break;
                        }
                        if (this.threadPool.maxIdleAgeMS > 0L && DateTime.getCurrentTimeMillis() - this.lastUsedTimeMS > this.threadPool.maxIdleAgeMS) {
                            stop = true;
                            break;
                        }
                        int tmoMS = 20000;
                        this.threadPool.waitingCount++;
                        try {
                            this.threadPool.jobQueue.wait(tmoMS);
                        }
                        catch (InterruptedException ie) {
                            // empty catch block
                        }
                        this.threadPool.waitingCount--;
                    }
                }
                if (stop) break;
                this.job.run();
                list = this.threadPool.jobQueue;
                synchronized (list) {
                    this.job = null;
                }
                this.lastUsedTimeMS = DateTime.getCurrentTimeMillis();
            }
            this.threadPool._removeThreadJob(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isRunning() {
            boolean rtn = false;
            List list = this.threadPool.jobQueue;
            synchronized (list) {
                rtn = this.job != null;
            }
            return rtn;
        }
    }
}

