/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.util;

import java.util.Collection;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import org.opengts.util.Print;
import org.opengts.util.StringTools;

public class ThreadLocalMap<K, V>
extends ThreadLocal<Map<K, V>>
implements Map<K, V> {
    private Class<Map<K, V>> mapClass = null;
    private ThreadLocal<Map<K, V>> threadLocal = null;

    public ThreadLocalMap() {
        this(null);
    }

    public ThreadLocalMap(Class<Map<K, V>> mapClass) {
        this.mapClass = mapClass;
        this.threadLocal = new ThreadLocal<Map<K, V>>(){

            @Override
            protected Map<K, V> initialValue() {
                if (ThreadLocalMap.this.mapClass == null) {
                    return new Hashtable();
                }
                try {
                    return (Map)ThreadLocalMap.this.mapClass.newInstance();
                }
                catch (Throwable t) {
                    Print.logException("Error instantiating: " + StringTools.className(ThreadLocalMap.this.mapClass), t);
                    return new Hashtable();
                }
            }
        };
    }

    public Class<Map<K, V>> getMapClass() {
        return this.mapClass;
    }

    protected Map<K, V> getMap() {
        Map<K, V> map = this.threadLocal.get();
        if (map == null) {
            Print.logError("'<ThreadLocal>.get()' has return null!", new Object[0]);
        }
        return map;
    }

    @Override
    public void clear() {
        this.getMap().clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.getMap().containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.getMap().containsValue(value);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.getMap().entrySet();
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof ThreadLocalMap) {
            return ((Object)this.getMap()).equals(((ThreadLocalMap)o).getMap());
        }
        return false;
    }

    @Override
    public V get(Object key) {
        return key != null ? (V)this.getMap().get(key) : null;
    }

    @Override
    public int hashCode() {
        return ((Object)this.getMap()).hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.getMap().isEmpty();
    }

    @Override
    public Set<K> keySet() {
        return this.getMap().keySet();
    }

    @Override
    public V put(K key, V value) {
        if (key == null) {
            Print.logStackTrace("Null key");
            return null;
        }
        if (value == null) {
            this.getMap().remove(key);
            return null;
        }
        return this.getMap().put(key, value);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> t) {
        this.getMap().putAll(t);
    }

    @Override
    public V remove(Object key) {
        return this.getMap().remove(key);
    }

    @Override
    public int size() {
        return this.getMap().size();
    }

    @Override
    public Collection<V> values() {
        return this.getMap().values();
    }
}

