/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.util;

import java.awt.Dimension;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.SortedMap;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opengts.util.DateTime;
import org.opengts.util.DayNumber;
import org.opengts.util.ListTools;
import org.opengts.util.OrderedMap;
import org.opengts.util.Payload;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;

public class StringTools {
    public static final char BACKSPACE = '\b';
    public static final char FORM_FEED = '\f';
    public static final char NEW_LINE = '\n';
    public static final char CARRIAGE_RETURN = '\r';
    public static final char TAB = '\t';
    public static final String WhitespaceChars = " \t\b\f\r\n";
    public static final char KeyValSeparatorEQUAL = '=';
    public static final char KeyValSeparatorCOLON = ':';
    public static final char KeyValSeparatorChar = '=';
    public static final char[] KeyValSeparatorChars = new char[]{'=', ':'};
    public static final char PropertySeparatorSPACE = ' ';
    public static final char PropertySeparatorSEMIC = ';';
    public static final char PropertySeparatorChar = ' ';
    public static final String STRING_TRUE = "true";
    public static final String STRING_FALSE = "false";
    private static final String[] BooleanTRUE = new String[]{"true", "yes", "on", "1"};
    private static final String[] BooleanFALSE = new String[]{"false", "no", "off", "0"};
    public static final String FORMAT_DATE = "date";
    public static final String FORMAT_DATE2 = "date2";
    public static final String FORMAT_TIME = "time";
    public static final String CharEncoding_UTF_8 = "UTF-8";
    public static final String CharEncoding_UTF_16 = "UTF-16";
    public static final String CharEncoding_8859_1 = "ISO-8859-1";
    public static final String CharEncoding_US_ASCII = "US-ASCII";
    private static final char ESCAPE_CHAR = '\\';
    public static final String HEX = "0123456789ABCDEF";
    public static final String ArraySeparator = ",";
    public static final char ARRAY_DELIM = ',';
    public static final char ARRAY_DOUBLE_QUOTE = '\"';
    public static final char ARRAY_SINGLE_QUOTE = '\'';
    public static final char ARRAY_QUOTE = '\"';
    public static final int STRIP_INCLUDE = 0;
    public static final int STRIP_EXCLUDE = 1;
    public static final char KEY_START_ESC = '\\';
    public static final String KEY_START = "${";
    public static final String KEY_END = "}";
    public static final String DFT_DELIM = "=";
    public static final String ARG_DELIM = ":";
    private static Map<String, DecimalFormat> formatMap = null;
    public static final int ELAPSED_FORMAT_SS = -1;
    public static final int ELAPSED_FORMAT_HHMMSS = 0;
    public static final int ELAPSED_FORMAT_HHMM = 1;
    public static final int ELAPSED_FORMAT_HHHhh = 2;
    public static final int ELAPSED_FORMAT_HHHh = 3;
    public static final int ELAPSED_FORMAT_MMMSS = 4;
    private static String BASE_DIGITS = "0123456789abcdefghijklmnopqrstvwxyzABCDEFGHIJKLMNOPQRSTVWXYZ()[]{}<>!@#&-=_+:~";
    private static int BASE_LEN = BASE_DIGITS.length();
    public static final String HTML_SP = "&nbsp;";
    public static final String HTML_LT = "&lt;";
    public static final String HTML_GT = "&gt;";
    public static final String HTML_AMP = "&amp;";
    public static final String HTML_DEG = "&deg;";
    public static final String HTML_QUOTE = "&quote;";
    public static final String HTML_DOUBLE_QUOTE = "&quote;";
    public static final String HTML_APOS = "&#39;";
    public static final String HTML_SINGLE_QUOTE = "&#39;";
    public static final String HTML_br = "<br>";
    public static final String HTML_BR = "<BR>";
    public static final String HTML_HR = "<HR>";
    private static String RANDOM_CHARS = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ.!@#&-=_+";
    private static final String[] ARG_HEX = new String[]{"hex"};
    private static final String[] ARG_LONG = new String[]{"long"};
    private static final String[] ARG_TO_HEX = new String[]{"tohex"};
    private static final String[] ARG_FORMAT = new String[]{"fmt", "format"};
    private static final String[] ARG_TO_UNICODE = new String[]{"tounicode"};
    private static final String[] ARG_FROM_UNICODE = new String[]{"fromunicode"};
    private static final String[] ARG_ARRAY = new String[]{"array"};
    private static final String[] ARG_SPLIT = new String[]{"split"};
    private static final String[] ARG_REPLACE = new String[]{"replace"};

    private static int _constrainOffset(int ofs, int length) {
        if (ofs < 0 || length <= 0) {
            return 0;
        }
        if (ofs > length) {
            return length;
        }
        return ofs;
    }

    private static int _constrainLength(int ofs, int len, int length) {
        if (len < 0) {
            return length - ofs;
        }
        if (len > length - ofs) {
            return length - ofs;
        }
        return len;
    }

    public static String getCharacterEncoding() {
        try {
            String charSet = Charset.defaultCharset().name();
            return !StringTools.isBlank(charSet) ? charSet : CharEncoding_UTF_8;
        }
        catch (Throwable th) {
            Print.logException("Unsupported Character Set?", th);
            return CharEncoding_UTF_8;
        }
    }

    public static String[] getCharacterEncodings() {
        SortedMap<String, Charset> csMap = Charset.availableCharsets();
        String[] charEnc = new String[csMap.size()];
        int c = 0;
        Iterator i = csMap.keySet().iterator();
        while (i.hasNext()) {
            charEnc[c++] = (String)i.next();
        }
        return charEnc;
    }

    public static int length(String s) {
        return s != null ? s.length() : 0;
    }

    public static String truncate(String s, int maxLen) {
        if (s == null) {
            return s;
        }
        if (maxLen <= 0) {
            return "";
        }
        if (s.length() > maxLen) {
            return s.substring(0, maxLen);
        }
        return s;
    }

    public static char[] getChars(String s) {
        return s != null ? s.toCharArray() : null;
    }

    public static char[] getChars(byte[] b) {
        if (b != null) {
            char[] c = new char[b.length];
            for (int i = 0; i < b.length; ++i) {
                c[i] = (char)(b[i] & 0xFF);
            }
            return c;
        }
        return null;
    }

    public static byte[] getBytes(StringBuffer sb) {
        return sb != null ? StringTools.getBytes(sb.toString()) : null;
    }

    public static byte[] getBytes(String s) {
        if (s != null) {
            try {
                return s.getBytes(StringTools.getCharacterEncoding());
            }
            catch (UnsupportedEncodingException uce) {
                Print.logStackTrace("Charset not found: " + StringTools.getCharacterEncoding());
                return s.getBytes();
            }
        }
        return null;
    }

    public static byte[] getBytes(char[] c) {
        if (c != null) {
            byte[] b = new byte[c.length];
            for (int i = 0; i < c.length; ++i) {
                b[i] = (byte)c[i];
            }
            return b;
        }
        return null;
    }

    public static boolean isValidID(String s, char ... x) {
        if (s == null || s.equals("")) {
            return false;
        }
        char[] ch = s.toCharArray();
        if (!Character.isLetterOrDigit(ch[0])) {
            return false;
        }
        for (int i = 1; i < ch.length; ++i) {
            if (Character.isLetterOrDigit(ch[i]) || x != null && ListTools.contains(x, ch[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean isNumeric(String s) {
        return StringTools.isNumeric(s, false);
    }

    public static boolean isNumeric(String s, boolean inclHex) {
        if (s == null) {
            return false;
        }
        char[] ch = s.toCharArray();
        for (int i = 0; i < ch.length; ++i) {
            if (Character.isDigit(ch[i]) || inclHex && StringTools.isHexDigit(ch[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean isAlphaNumeric(String s, boolean inclSpace) {
        if (s == null) {
            return false;
        }
        char[] ch = s.toCharArray();
        for (int i = 0; i < ch.length; ++i) {
            if (Character.isLetterOrDigit(ch[i]) || inclSpace && ch[i] == ' ') continue;
            return false;
        }
        return true;
    }

    public static boolean isAlphaNumeric(String s, char ... x) {
        if (s == null || s.equals("")) {
            return false;
        }
        char[] ch = s.toCharArray();
        for (int i = 0; i < ch.length; ++i) {
            if (Character.isLetterOrDigit(ch[i]) || x != null && ListTools.contains(x, ch[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean isAlphaNumeric(byte[] b) {
        return StringTools.isAlphaNumeric(b, 0, -1);
    }

    public static boolean isAlphaNumeric(byte[] b, int ofs) {
        return StringTools.isAlphaNumeric(b, ofs, -1);
    }

    public static boolean isAlphaNumeric(byte[] b, int ofs, int len) {
        if (b == null || b.length == 0) {
            return false;
        }
        len = StringTools._constrainLength(ofs = StringTools._constrainOffset(ofs, b.length), len, b.length);
        if (len <= 0) {
            return false;
        }
        for (int i = ofs; i < ofs + len; ++i) {
            if (b[i] >= 48 && b[i] <= 57 || b[i] >= 97 && b[i] <= 122 || b[i] >= 65 && b[i] <= 90) continue;
            return false;
        }
        return true;
    }

    public static boolean isPrintableASCII(byte[] b) {
        return StringTools.isPrintableASCII(b, 0, -1, true);
    }

    public static boolean isPrintableASCII(byte[] b, boolean inclSpace) {
        return StringTools.isPrintableASCII(b, 0, -1, inclSpace);
    }

    public static boolean isPrintableASCII(byte[] b, int ofs, int len, boolean inclSpace) {
        if (b == null || b.length == 0) {
            return false;
        }
        len = StringTools._constrainLength(ofs = StringTools._constrainOffset(ofs, b.length), len, b.length);
        if (len <= 0) {
            return false;
        }
        for (int i = ofs; i < ofs + len; ++i) {
            if (b[i] >= 33 && b[i] <= 126) continue;
            if (!inclSpace) {
                return false;
            }
            if (b[i] == 32 || b[i] == 9 || b[i] == 10 || b[i] == 13) continue;
            return false;
        }
        return true;
    }

    public static String toStringValue(String s, char repUnp) {
        if (s == null) {
            return "";
        }
        if (StringTools.isBlank(s)) {
            return s;
        }
        byte[] b = StringTools.getBytes(s);
        return StringTools.toStringValue(b, 0, -1, repUnp);
    }

    public static String toStringValue(byte[] b, char repUnp) {
        return StringTools.toStringValue(b, 0, -1, repUnp);
    }

    public static String toStringValue(byte[] b) {
        return StringTools.toStringValue(b, 0, -1);
    }

    public static String toStringValue(byte[] b, int ofs) {
        return StringTools.toStringValue(b, ofs, -1);
    }

    public static String toStringValue(byte[] b, int ofs, int len, char repUnp) {
        if (b != null) {
            if (repUnp != '\u0000' && !StringTools.isPrintableASCII(b, true)) {
                byte[] p = new byte[b.length];
                System.arraycopy(b, 0, p, 0, b.length);
                for (int i = 0; i < p.length; ++i) {
                    if (p[i] >= 32 && p[i] <= 126) continue;
                    p[i] = (byte)repUnp;
                }
                b = p;
            }
            return StringTools.toStringValue(b, ofs, len);
        }
        return null;
    }

    public static String toStringValue(byte[] b, int ofs, int len) {
        if (b == null) {
            return null;
        }
        if (len == 0) {
            return "";
        }
        len = StringTools._constrainLength(ofs = StringTools._constrainOffset(ofs, b.length), len, b.length);
        if (len <= 0) {
            return "";
        }
        try {
            return new String(b, ofs, len, StringTools.getCharacterEncoding());
        }
        catch (Throwable t) {
            Print.logException("Byte=>String conversion error", t);
            try {
                return new String(b, ofs, len);
            }
            catch (Throwable th) {
                return "";
            }
        }
    }

    public static String toStringValue(char[] c) {
        return new String(c);
    }

    public static String toString(Object v) {
        if (v == null) {
            return "";
        }
        if (v instanceof Object[]) {
            return StringTools.toString((Object[])v);
        }
        if (v instanceof double[]) {
            return StringTools.toString((double[])v);
        }
        if (v instanceof long[]) {
            return StringTools.toString((long[])v);
        }
        if (v instanceof int[]) {
            return StringTools.toString((int[])v);
        }
        if (v instanceof byte[]) {
            return StringTools.toString((byte[])v);
        }
        if (v instanceof char[]) {
            return StringTools.toString((char[])v);
        }
        if (v.getClass().isArray()) {
            char delim = ',';
            boolean alwaysQuote = false;
            StringBuffer sb = new StringBuffer();
            sb.append("{");
            int vLen = Array.getLength(v);
            for (int i = 0; i < vLen; ++i) {
                if (sb.length() > 0) {
                    sb.append(delim);
                }
                Object v_i = Array.get(v, i);
                String s = StringTools.toString(v_i);
                if (alwaysQuote || s.indexOf(32) >= 0 || s.indexOf(9) >= 0 || s.indexOf(34) >= 0 || s.indexOf(delim) >= 0) {
                    s = StringTools.quoteString(s);
                }
                sb.append(s);
            }
            sb.append(KEY_END);
            return sb.toString();
        }
        return v.toString();
    }

    public static String toString(Object[] v) {
        StringBuffer sb = new StringBuffer();
        sb.append("{");
        sb.append(StringTools.join(v, ','));
        sb.append(KEY_END);
        return sb.toString();
    }

    public static String toString(double v) {
        return String.valueOf(v);
    }

    public static String toString(double[] v) {
        StringBuffer sb = new StringBuffer();
        sb.append("{");
        sb.append(StringTools.join(v, ','));
        sb.append(KEY_END);
        return sb.toString();
    }

    public static String toString(float v) {
        return String.valueOf(v);
    }

    public static String toString(float[] v) {
        StringBuffer sb = new StringBuffer();
        sb.append("{");
        sb.append(StringTools.join(v, ','));
        sb.append(KEY_END);
        return sb.toString();
    }

    public static String toString(long v) {
        StringBuffer sb = new StringBuffer();
        sb.append(String.valueOf(v));
        return sb.toString();
    }

    public static String toString(long[] v) {
        StringBuffer sb = new StringBuffer();
        sb.append("{");
        sb.append(StringTools.join(v, ','));
        sb.append(KEY_END);
        return sb.toString();
    }

    public static String toString(int v) {
        StringBuffer sb = new StringBuffer();
        sb.append(String.valueOf(v));
        return sb.toString();
    }

    public static String toString(int[] v) {
        StringBuffer sb = new StringBuffer();
        sb.append("{");
        sb.append(StringTools.join(v, ','));
        sb.append(KEY_END);
        return sb.toString();
    }

    public static String toString(short v) {
        StringBuffer sb = new StringBuffer();
        sb.append(String.valueOf(v));
        return sb.toString();
    }

    public static String toString(byte v) {
        StringBuffer sb = new StringBuffer();
        sb.append(String.valueOf(v));
        return sb.toString();
    }

    public static String toString(byte[] v) {
        StringBuffer sb = new StringBuffer();
        sb.append("0x").append(StringTools.toHexString(v));
        return sb.toString();
    }

    public static String toString(char v) {
        return StringTools.toStringValue(new char[]{v});
    }

    public static String toString(char[] v) {
        return StringTools.toStringValue(v);
    }

    public static byte[] toUTF8Bytes(byte[] b) {
        if (b == null) {
            return null;
        }
        if (b.length == 0) {
            return new byte[0];
        }
        try {
            String s = new String(b, CharEncoding_US_ASCII);
            return s.getBytes(CharEncoding_UTF_8);
        }
        catch (Throwable t) {
            Print.logException("Byte=>String conversion error", t);
            return b;
        }
    }

    public static String toUTF16String(byte[] b) {
        int ofs = 0;
        int len = -1;
        if (b == null) {
            return null;
        }
        if (len == 0) {
            return "";
        }
        if (len < 0) {
            len = b.length - ofs;
        }
        try {
            return new String(b, ofs, len, CharEncoding_UTF_16);
        }
        catch (Throwable t) {
            Print.logException("Byte=>String conversion error", t);
            return new String(b, ofs, len);
        }
    }

    public static String escapeJSON(String s) {
        if (s != null) {
            StringBuffer sb = new StringBuffer();
            int len = s.length();
            for (int i = 0; i < len; ++i) {
                char ch = s.charAt(i);
                if (ch == '\\') {
                    sb.append('\\').append('\\');
                    continue;
                }
                if (ch == '\n') {
                    sb.append('\\').append('n');
                    continue;
                }
                if (ch == '\r') {
                    sb.append('\\').append('r');
                    continue;
                }
                if (ch == '\t') {
                    sb.append('\\').append('t');
                    continue;
                }
                if (ch == '\"') {
                    sb.append('\\').append('\"');
                    continue;
                }
                if (ch >= ' ' && ch <= '~') {
                    sb.append(ch);
                    continue;
                }
                sb.append(ch);
            }
            return sb.toString();
        }
        return "";
    }

    public static String escapeUnicode(String s) {
        if (s != null) {
            StringBuffer sb = new StringBuffer();
            int len = s.length();
            for (int i = 0; i < len; ++i) {
                char ch = s.charAt(i);
                if (ch == '\n' || ch == '\r') {
                    sb.append(ch);
                    continue;
                }
                if (ch == '\t' || ch == '\f') {
                    sb.append(ch);
                    continue;
                }
                if (ch < ' ' || ch > '~') {
                    sb.append('\\');
                    sb.append('u');
                    sb.append(StringTools.hexNybble(ch >> 12 & 0xF));
                    sb.append(StringTools.hexNybble(ch >> 8 & 0xF));
                    sb.append(StringTools.hexNybble(ch >> 4 & 0xF));
                    sb.append(StringTools.hexNybble(ch & 0xF));
                    continue;
                }
                sb.append(ch);
            }
            return sb.toString();
        }
        return "";
    }

    public static String unescapeUnicode(String u) {
        if (u != null) {
            StringBuffer sb = new StringBuffer();
            int len = u.length();
            int i = 0;
            while (i < len) {
                char ch = u.charAt(i);
                if (ch == '\\' && i + 5 < len && u.charAt(i + 1) == 'u') {
                    int hndx;
                    int val = 0;
                    int x = i += 2;
                    while (i < x + 4 && (hndx = StringTools.hexIndex(u.charAt(i))) >= 0) {
                        val = val << 4 | hndx;
                        ++i;
                    }
                    sb.append((char)val);
                    continue;
                }
                sb.append(ch);
                ++i;
            }
            return sb.toString();
        }
        return "";
    }

    public static String trim(StringBuffer sb) {
        String s = sb != null ? sb.toString().trim() : "";
        return s;
    }

    public static String trim(Object obj) {
        String s = obj != null ? obj.toString().trim() : "";
        return s;
    }

    public static String trim(String str) {
        String s = str != null ? str.trim() : "";
        return s;
    }

    public static boolean isBlank(String s) {
        if (s == null) {
            return true;
        }
        return s.trim().equals("");
    }

    public static boolean isBlank(StringBuffer s) {
        if (s == null) {
            return true;
        }
        return s.toString().trim().equals("");
    }

    public static boolean isBlank(Object s) {
        if (s == null) {
            return true;
        }
        return s.toString().trim().equals("");
    }

    public static String blankDefault(Object target, String dft) {
        if (target == null) {
            return dft;
        }
        String t = target.toString();
        return !StringTools.isBlank(t) ? t : dft;
    }

    public static String blankDefault(String target, String dft) {
        return StringTools.isBlank(target) ? dft : target;
    }

    public static boolean equals(String s1, String s2) {
        if (s1 != null) {
            return s2 != null ? s1.equals(s2) : false;
        }
        return s2 == null;
    }

    public static boolean equalsIgnoreCase(String s1, String s2) {
        if (s1 != null) {
            return s2 != null ? s1.equalsIgnoreCase(s2) : false;
        }
        return s2 == null;
    }

    public static String trimLeading(String s, char c) {
        int x;
        int slen;
        int n = slen = s != null ? s.length() : 0;
        if (slen == 0) {
            return "";
        }
        for (x = 0; x < slen && s.charAt(x) == c; ++x) {
        }
        return x == 0 ? s : (x >= slen ? "" : s.substring(x));
    }

    public static String trimLeading(String s) {
        int x;
        int slen;
        int n = slen = s != null ? s.length() : 0;
        if (slen == 0) {
            return "";
        }
        for (x = 0; x < slen && Character.isWhitespace(s.charAt(x)); ++x) {
        }
        return x == 0 ? s : (x >= slen ? "" : s.substring(x));
    }

    public static String trimLeading(Object s) {
        return s != null ? StringTools.trimLeading(s.toString()) : "";
    }

    public static String trimTrailing(String s, char c) {
        int x;
        int slen;
        int n = slen = s != null ? s.length() : 0;
        if (slen == 0) {
            return "";
        }
        for (x = slen - 1; x >= 0 && s.charAt(x) == c; --x) {
        }
        return x == slen - 1 ? s : (x < 0 ? "" : s.substring(0, x + 1));
    }

    public static String trimTrailing(String s) {
        int x;
        int slen;
        int n = slen = s != null ? s.length() : 0;
        if (slen == 0) {
            return "";
        }
        for (x = slen - 1; x >= 0 && Character.isWhitespace(s.charAt(x)); --x) {
        }
        return x == slen - 1 ? s : (x < 0 ? "" : s.substring(0, x + 1));
    }

    public static String trimTrailing(Object s) {
        return s != null ? StringTools.trimTrailing(s.toString()) : "";
    }

    public static String reverse(String s) {
        if (StringTools.isBlank(s)) {
            return s;
        }
        return new StringBuffer(s).reverse().toString();
    }

    public static String quoteString(String s) {
        return StringTools.quoteString(s, '\"');
    }

    public static String quoteString(String s, char q) {
        if (s == null) {
            s = "";
        }
        int len = s.length();
        char[] ch = new char[len];
        s.getChars(0, len, ch, 0);
        StringBuffer qsb = new StringBuffer();
        qsb.append(q);
        for (int c = 0; c < len; ++c) {
            if (ch[c] == q) {
                qsb.append('\\').append(q);
                continue;
            }
            if (ch[c] == '\\') {
                qsb.append('\\').append('\\');
                continue;
            }
            if (ch[c] == '\n') {
                qsb.append('\\').append('n');
                continue;
            }
            if (ch[c] == '\r') {
                qsb.append('\\').append('r');
                continue;
            }
            if (ch[c] == '\t') {
                qsb.append('\\').append('t');
                continue;
            }
            qsb.append(ch[c]);
        }
        qsb.append(q);
        return qsb.toString();
    }

    public static String quoteCSVString(String s) {
        if (s == null) {
            s = "";
        }
        boolean needsQuotes = true;
        char q = '\"';
        if (s.indexOf(q) >= 0) {
            StringBuffer sb = new StringBuffer();
            if (needsQuotes) {
                sb.append(q);
            }
            for (int i = 0; i < s.length(); ++i) {
                char ch = s.charAt(i);
                if (ch == q) {
                    sb.append("\"\"");
                    continue;
                }
                sb.append(ch);
            }
            if (needsQuotes) {
                sb.append(q);
            }
            return sb.toString();
        }
        if (needsQuotes) {
            return "\"" + s + "\"";
        }
        return s;
    }

    public static String encodeCSV(String[] d, boolean checkTextQuote) {
        if (d != null) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < d.length; ++i) {
                if (sb.length() > 0) {
                    sb.append(ArraySeparator);
                }
                String v = d[i] != null ? d[i] : "";
                String t = checkTextQuote ? "'" + v : v;
                sb.append(StringTools.quoteCSVString(t));
            }
            return sb.toString();
        }
        return "";
    }

    public static String encodeCSV(String[] d) {
        return StringTools.encodeCSV(d, false);
    }

    public static String parseQuote(String s) {
        StringBuffer sb = new StringBuffer();
        StringTools.parseQuote(s.toCharArray(), 0, sb);
        return sb.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int parseQuote(char[] ch, int a, StringBuffer sb) {
        boolean parseOctal = false;
        int chLen = ch != null ? ch.length : 0;
        if (chLen <= 0) return a;
        if (a < 0) return a;
        if (a >= chLen) {
            return a;
        }
        if (ch[a] != '\"' && ch[a] != '\'') {
            while (a < chLen) {
                if (Character.isWhitespace(ch[a])) return a;
                sb.append(ch[a]);
                ++a;
            }
            return a;
        }
        char quote = ch[a];
        ++a;
        while (a < chLen && ch[a] != quote) {
            block11: {
                block12: {
                    block15: {
                        block14: {
                            block13: {
                                int n;
                                if (a + 1 >= chLen || ch[a] != '\\') break block12;
                                ++a;
                                if (!parseOctal) break block13;
                                for (n = a; n < chLen && n < a + 3 && ch[n] >= '0' && ch[n] <= '8'; ++n) {
                                }
                                if (n <= a) break block13;
                                String octalStr = new String(ch, a, n - a);
                                try {
                                    int octal = Integer.parseInt(octalStr, 8) & 0xFF;
                                    sb.append((char)octal);
                                }
                                catch (NumberFormatException nfe) {
                                    Print.logStackTrace("Unable to parse octal: " + octalStr);
                                }
                                a = n - 1;
                                break block11;
                            }
                            if (ch[a] != '0') break block14;
                            sb.append('\u0000');
                            break block11;
                        }
                        if (ch[a] != 'r') break block15;
                        sb.append('\r');
                        break block11;
                    }
                    if (ch[a] == 'n') {
                        sb.append('\n');
                        break block11;
                    } else if (ch[a] == 't') {
                        sb.append('\t');
                        break block11;
                    } else {
                        sb.append(ch[a]);
                    }
                    break block11;
                }
                sb.append(ch[a]);
            }
            ++a;
        }
        if (a >= chLen) return a;
        ++a;
        return a;
    }

    public static <T> Number parseNumber(Object data, Class<?> numberClass, Number dft) {
        if (data == null) {
            return dft;
        }
        if (numberClass == null || !Number.class.isAssignableFrom(numberClass)) {
            return dft;
        }
        if (numberClass.isAssignableFrom(data.getClass())) {
            return (Number)data;
        }
        FilterNumber num = new FilterNumber(data.toString(), numberClass);
        if (!num.supportsType(numberClass)) {
            return dft;
        }
        return num.toNumber(dft);
    }

    public static double parseDouble(byte[] b, int ofs, boolean isBigEndian, double dft) {
        if (b == null || ofs + 8 > b.length) {
            return dft;
        }
        int i = ofs;
        long doubleLong = 0L;
        doubleLong = isBigEndian ? (((long)b[i + 0] & 0xFFL) << 56) + (((long)b[i + 1] & 0xFFL) << 48) + (((long)b[i + 2] & 0xFFL) << 40) + (((long)b[i + 3] & 0xFFL) << 32) + (((long)b[i + 4] & 0xFFL) << 24) + (((long)b[i + 5] & 0xFFL) << 16) + (((long)b[i + 6] & 0xFFL) << 8) + ((long)b[i + 7] & 0xFFL) : (((long)b[i + 7] & 0xFFL) << 56) + (((long)b[i + 6] & 0xFFL) << 48) + (((long)b[i + 5] & 0xFFL) << 40) + (((long)b[i + 4] & 0xFFL) << 32) + (((long)b[i + 3] & 0xFFL) << 24) + (((long)b[i + 2] & 0xFFL) << 16) + (((long)b[i + 1] & 0xFFL) << 8) + ((long)b[i + 0] & 0xFFL);
        return Double.longBitsToDouble(doubleLong);
    }

    public static double[] parseDouble(Object[] data, double dft) {
        if (data == null) {
            return new double[0];
        }
        double[] valList = new double[data.length];
        for (int i = 0; i < data.length; ++i) {
            valList[i] = StringTools.parseDouble(data[i], dft);
        }
        return valList;
    }

    public static double parseDouble(Object data, double dft) {
        if (data == null) {
            return dft;
        }
        if (data instanceof Number) {
            return ((Number)data).doubleValue();
        }
        return StringTools.parseDouble(data.toString(), dft);
    }

    public static double parseDouble(String data, double dft) {
        return StringTools.parseDouble(new FilterNumber(data, Double.class), dft);
    }

    public static double parseDouble(FilterNumber num, double dft) {
        if (num != null && num.supportsType(Double.class)) {
            try {
                return Double.parseDouble(num.getValueString());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return dft;
    }

    public static boolean isDouble(String data, boolean strict) {
        if (StringTools.isBlank(data)) {
            return false;
        }
        FilterNumber fn = new FilterNumber(data, Double.class);
        return fn.isValid(strict);
    }

    public static boolean isDouble(Object data, boolean strict) {
        if (data == null) {
            return false;
        }
        if (data instanceof Number) {
            return strict ? data instanceof Double : true;
        }
        return StringTools.isDouble(data.toString(), strict);
    }

    public static float parseFloat(byte[] b, int ofs, boolean isBigEndian, float dft) {
        if (b == null || ofs + 4 > b.length) {
            return dft;
        }
        int i = ofs;
        int floatInt = 0;
        floatInt = isBigEndian ? ((b[i + 0] & 0xFF) << 24) + ((b[i + 1] & 0xFF) << 16) + ((b[i + 2] & 0xFF) << 8) + (b[i + 3] & 0xFF) : ((b[i + 3] & 0xFF) << 24) + ((b[i + 2] & 0xFF) << 16) + ((b[i + 1] & 0xFF) << 8) + (b[i + 0] & 0xFF);
        return Float.intBitsToFloat(floatInt);
    }

    public static float parseFloat(Object data, float dft) {
        if (data == null) {
            return dft;
        }
        if (data instanceof Number) {
            return ((Number)data).floatValue();
        }
        return StringTools.parseFloat(data.toString(), dft);
    }

    public static float parseFloat(String data, float dft) {
        return StringTools.parseFloat(new FilterNumber(data, Float.class), dft);
    }

    public static float parseFloat(FilterNumber num, float dft) {
        if (num != null && num.supportsType(Float.class)) {
            try {
                return Float.parseFloat(num.getValueString());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return dft;
    }

    public static boolean isFloat(String data, boolean strict) {
        if (StringTools.isBlank(data)) {
            return false;
        }
        FilterNumber fn = new FilterNumber(data, Float.class);
        return fn.isValid(strict);
    }

    public static boolean isFloat(Object data, boolean strict) {
        if (data == null) {
            return false;
        }
        if (data instanceof Number) {
            return strict ? data instanceof Float : true;
        }
        return StringTools.isFloat(data.toString(), strict);
    }

    public static long[] parseLong(Object[] data, long dft) {
        if (data == null) {
            return new long[0];
        }
        long[] valList = new long[data.length];
        for (int i = 0; i < data.length; ++i) {
            valList[i] = StringTools.parseLong(data[i], dft);
        }
        return valList;
    }

    public static long parseLong(Object data, long dft) {
        if (data == null) {
            return dft;
        }
        if (data instanceof Number) {
            return ((Number)data).longValue();
        }
        if (data instanceof DateTime) {
            return ((DateTime)data).getTimeSec();
        }
        return StringTools.parseLong(data.toString(), dft);
    }

    public static long parseLong(String data, long dft) {
        return StringTools.parseLong(new FilterNumber(data, Long.class), dft);
    }

    public static long parseLong(FilterNumber num, long dft) {
        block4: {
            if (num != null && num.supportsType(Long.class)) {
                if (num.isHex()) {
                    return StringTools.parseHexLong(num.getValueString(), dft);
                }
                try {
                    return Long.parseLong(num.getValueString());
                }
                catch (NumberFormatException nfe) {
                    BigInteger bigLong = StringTools.parseBigInteger(num, null);
                    if (bigLong == null) break block4;
                    return bigLong.longValue();
                }
            }
        }
        return dft;
    }

    public static long parseLong(byte[] b, int ofs, int len, boolean isBigEndian, boolean signed, long dft) {
        return Payload.decodeLong(b, ofs, len, isBigEndian, signed, dft);
    }

    public static boolean isLong(String data, boolean strict) {
        if (StringTools.isBlank(data)) {
            return false;
        }
        FilterNumber fn = new FilterNumber(data, Long.class);
        return fn.isValid(strict);
    }

    public static boolean isLong(Object data, boolean strict) {
        if (data == null) {
            return false;
        }
        if (data instanceof Number) {
            return strict ? data instanceof Long : true;
        }
        return StringTools.isLong(data.toString(), strict);
    }

    public static int[] parseInt(Object[] data, int dft) {
        if (data == null) {
            return new int[0];
        }
        int[] valList = new int[data.length];
        for (int i = 0; i < data.length; ++i) {
            valList[i] = StringTools.parseInt(data[i], dft);
        }
        return valList;
    }

    public static int parseInt(Object data, int dft) {
        if (data == null) {
            return dft;
        }
        if (data instanceof Number) {
            return ((Number)data).intValue();
        }
        return StringTools.parseInt(data.toString(), dft);
    }

    public static int parseInt(String data, int dft) {
        return StringTools.parseInt(new FilterNumber(data, Integer.class), dft);
    }

    public static int parseInt(FilterNumber num, int dft) {
        block4: {
            if (num != null && num.supportsType(Integer.class)) {
                if (num.isHex()) {
                    return (int)StringTools.parseHexLong(num.getValueString(), dft);
                }
                try {
                    return Integer.parseInt(num.getValueString());
                }
                catch (NumberFormatException nfe) {
                    BigInteger bigLong = StringTools.parseBigInteger(num, null);
                    if (bigLong == null) break block4;
                    return bigLong.intValue();
                }
            }
        }
        return dft;
    }

    public static int parseInt(byte[] b, int ofs, int len, boolean isBigEndian, boolean signed, int dft) {
        return (int)Payload.decodeLong(b, ofs, len, isBigEndian, signed, dft);
    }

    public static boolean isInt(String data, boolean strict) {
        if (StringTools.isBlank(data)) {
            return false;
        }
        FilterNumber fn = new FilterNumber(data, Integer.class);
        return fn.isValid(strict);
    }

    public static boolean isInt(Object data, boolean strict) {
        if (data == null) {
            return false;
        }
        if (data instanceof Number) {
            return strict ? data instanceof Integer : true;
        }
        return StringTools.isInt(data.toString(), strict);
    }

    public static int parseShort(Object data, short dft) {
        if (data == null) {
            return dft;
        }
        if (data instanceof Number) {
            return ((Number)data).shortValue();
        }
        return StringTools.parseShort(data.toString(), dft);
    }

    public static short parseShort(String data, short dft) {
        return StringTools.parseShort(new FilterNumber(data, Short.class), dft);
    }

    public static short parseShort(FilterNumber num, short dft) {
        block4: {
            if (num != null && num.supportsType(Short.class)) {
                if (num.isHex()) {
                    return (short)StringTools.parseHexLong(num.getValueString(), dft);
                }
                try {
                    return Short.parseShort(num.getValueString());
                }
                catch (NumberFormatException nfe) {
                    BigInteger bigLong = StringTools.parseBigInteger(num, null);
                    if (bigLong == null) break block4;
                    return bigLong.shortValue();
                }
            }
        }
        return dft;
    }

    public static boolean isShort(String data, boolean strict) {
        if (StringTools.isBlank(data)) {
            return false;
        }
        FilterNumber fn = new FilterNumber(data, Short.class);
        return fn.isValid(strict);
    }

    public static boolean isShort(Object data, boolean strict) {
        if (data == null) {
            return false;
        }
        if (data instanceof Number) {
            return strict ? data instanceof Short : true;
        }
        return StringTools.isShort(data.toString(), strict);
    }

    public static BigInteger parseBigInteger(Object data, BigInteger dft) {
        if (data == null) {
            return dft;
        }
        if (data instanceof BigInteger) {
            return (BigInteger)data;
        }
        if (data instanceof Number) {
            return BigInteger.valueOf(((Number)data).longValue());
        }
        if (data instanceof DateTime) {
            return BigInteger.valueOf(((DateTime)data).getTimeSec());
        }
        return StringTools.parseBigInteger(data.toString(), dft);
    }

    public static BigInteger parseBigInteger(String data, BigInteger dft) {
        return StringTools.parseBigInteger(new FilterNumber(data, BigInteger.class), dft);
    }

    public static BigInteger parseBigInteger(FilterNumber num, BigInteger dft) {
        if (num != null && num.supportsType(BigInteger.class)) {
            if (num.isHex()) {
                try {
                    return new BigInteger(num.getHexBytes());
                }
                catch (NumberFormatException nfe) {
                }
            } else {
                try {
                    return new BigInteger(num.getValueString());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return dft;
    }

    public static boolean isBigInteger(String data, boolean strict) {
        if (StringTools.isBlank(data)) {
            return false;
        }
        FilterNumber fn = new FilterNumber(data, BigInteger.class);
        return fn.isValid(strict);
    }

    public static boolean isBigInteger(Object data, boolean strict) {
        if (data == null) {
            return false;
        }
        if (data instanceof Number) {
            return strict ? data instanceof BigInteger : true;
        }
        return StringTools.isBigInteger(data.toString(), strict);
    }

    public static boolean parseBoolean(Object data, boolean dft) {
        if (data == null) {
            return dft;
        }
        if (data instanceof Boolean) {
            return (Boolean)data;
        }
        return StringTools.parseBoolean(data.toString(), dft);
    }

    public static boolean parseBoolean(String data, boolean dft) {
        if (data != null) {
            String v = data.toLowerCase();
            if (dft) {
                for (int i = 0; i < BooleanFALSE.length; ++i) {
                    if (!v.startsWith(BooleanFALSE[i])) continue;
                    return false;
                }
            } else {
                for (int i = 0; i < BooleanTRUE.length; ++i) {
                    if (!v.startsWith(BooleanTRUE[i])) continue;
                    return true;
                }
            }
            return dft;
        }
        return dft;
    }

    public static boolean isBoolean(String data, boolean strict) {
        if (data != null) {
            boolean ok;
            int i;
            String v = data.toLowerCase();
            for (i = 0; i < BooleanTRUE.length; ++i) {
                boolean bl = ok = strict ? v.equals(BooleanTRUE[i]) : v.startsWith(BooleanTRUE[i]);
                if (!ok) continue;
                return true;
            }
            for (i = 0; i < BooleanFALSE.length; ++i) {
                boolean bl = ok = strict ? v.equals(BooleanFALSE[i]) : v.startsWith(BooleanFALSE[i]);
                if (!ok) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isBoolean(Object data, boolean strict) {
        if (data == null) {
            return false;
        }
        if (data instanceof Boolean) {
            return true;
        }
        return StringTools.isBoolean(data.toString(), strict);
    }

    public static String parseString(Object data, String dft) {
        if (data == null) {
            return dft;
        }
        if (data instanceof String) {
            return (String)data;
        }
        if (data instanceof byte[]) {
            return StringTools.parseString((byte[])data, dft);
        }
        return data.toString();
    }

    public static String parseString(byte[] data, String dft) {
        return StringTools.parseString(data, 0, dft);
    }

    public static String parseString(byte[] data, int ofs, String dft) {
        if (data == null) {
            return dft;
        }
        if (ofs < 0) {
            return dft;
        }
        int sLen = 0;
        sLen = 0;
        while (ofs + sLen < data.length && data[ofs + sLen] != 0) {
            ++sLen;
        }
        return sLen > 0 ? StringTools.toStringValue(data, ofs, sLen) : "";
    }

    public static Dimension parseDimension(String data, Dimension dft) {
        int p;
        int n = p = data != null ? data.indexOf("/") : -1;
        if (p > 0) {
            int w = StringTools.parseInt(data.substring(0, p), 0);
            int h = StringTools.parseInt(data.substring(p + 1), 0);
            return new Dimension(w, h);
        }
        return dft;
    }

    public static boolean isHexDigit(char ch) {
        return HEX.indexOf(Character.toUpperCase(ch)) >= 0;
    }

    public static boolean isHexDigit(byte b) {
        char ch = (char)b;
        return HEX.indexOf(Character.toUpperCase(ch)) >= 0;
    }

    public static int hexIndex(char ch) {
        return HEX.indexOf(Character.toUpperCase(ch));
    }

    public static char hexNybble(byte nybble) {
        return HEX.charAt(nybble & 0xF);
    }

    public static char hexNybble(int nybble) {
        return HEX.charAt(nybble & 0xF);
    }

    public static byte[] parseHex(String data, byte[] dft) {
        if (data != null) {
            String d = data.toUpperCase();
            String s = d.startsWith("0X") ? d.substring(2) : d;
            for (int i = 0; i < s.length(); ++i) {
                if (HEX.indexOf(s.charAt(i)) >= 0) continue;
                s = s.substring(0, i);
                break;
            }
            if (s.equals("")) {
                return dft;
            }
            if ((s.length() & 1) == 1) {
                s = "0" + s;
            }
            byte[] rtn = new byte[s.length() / 2];
            for (int i = 0; i < s.length(); i += 2) {
                int c2;
                int c1 = HEX.indexOf(s.charAt(i));
                if (c1 < 0) {
                    c1 = 0;
                }
                if ((c2 = HEX.indexOf(s.charAt(i + 1))) < 0) {
                    c2 = 0;
                }
                rtn[i / 2] = (byte)(c1 << 4 & 0xF0 | c2 & 0xF);
            }
            return rtn;
        }
        return dft;
    }

    public static int parseHex(String data, int dft) {
        return (int)StringTools.parseHexLong(data, dft);
    }

    public static int parseHexInt(String data, int dft) {
        return (int)StringTools.parseHexLong(data, dft);
    }

    public static long parseHex(String data, long dft) {
        return StringTools.parseHexLong(data, dft);
    }

    public static long parseHexLong(String data, long dft) {
        byte[] b = StringTools.parseHex(data, null);
        if (b != null) {
            long val = 0L;
            for (int i = 0; i < b.length; ++i) {
                val = val << 8 | (long)(b[i] & 0xFF);
            }
            return val;
        }
        return dft;
    }

    public static int hexLength(String data) {
        int s;
        String d;
        int e;
        if (StringTools.isBlank(data)) {
            return 0;
        }
        for (e = s = (d = data.toUpperCase()).startsWith("0X") ? 2 : 0; e < d.length() && HEX.indexOf(d.charAt(e)) >= 0; ++e) {
        }
        return e;
    }

    public static boolean isHex(String data, boolean strict) {
        int s;
        String d;
        int e;
        if (StringTools.isBlank(data)) {
            return false;
        }
        for (e = s = (d = data.toUpperCase()).startsWith("0X") ? 2 : 0; e < d.length(); ++e) {
            if (HEX.indexOf(d.charAt(e)) >= 0) continue;
            if (!strict) break;
            return false;
        }
        return e > s;
    }

    public static StringBuffer formatHexString(byte[] b) {
        return StringTools.formatHexString(b, 0, -1, 16, true, null);
    }

    public static StringBuffer formatHexString(byte[] b, int blockLen) {
        return StringTools.formatHexString(b, 0, -1, blockLen, true, null);
    }

    public static StringBuffer formatHexString(byte[] b, int blockLen, StringBuffer sb) {
        return StringTools.formatHexString(b, 0, -1, blockLen, true, sb);
    }

    public static StringBuffer formatHexString(byte[] b, int bOfs, int bLen, int blockLen, boolean showAscii, StringBuffer sb) {
        int j;
        int bMaxNdx;
        int headerLen = 0;
        if (b == null) {
            b = new byte[]{};
        }
        if (sb == null) {
            sb = new StringBuffer();
        }
        int bi = bOfs >= 0 ? bOfs : 0;
        int n = bMaxNdx = bLen >= 0 && bi + bLen <= b.length ? bi + bLen : b.length;
        if (blockLen <= 0) {
            blockLen = bMaxNdx - bi < 16 ? bLen : 16;
        }
        int rulerLen = headerLen > blockLen ? headerLen : blockLen;
        sb.append("    : ** ");
        int ri = 1;
        while (ri < rulerLen) {
            j = ri;
            while (ri < rulerLen & ri - j < 4) {
                sb.append("-- ");
                ++ri;
            }
            if (ri < rulerLen) {
                sb.append("++ ");
                ++ri;
            }
            j = ri;
            while (ri < rulerLen & ri - j < 4) {
                sb.append("-- ");
                ++ri;
            }
            if (ri >= rulerLen) continue;
            sb.append(StringTools.format(ri, "00 "));
            ++ri;
        }
        sb.append("\n");
        if (headerLen > 0) {
            sb.append(StringTools.format(bi, "0000")).append(": ");
            int j2 = bi;
            while (j2 - bi < headerLen) {
                if (j2 < bMaxNdx) {
                    StringTools.toHexString(b[j2], sb);
                } else {
                    sb.append("  ");
                }
                sb.append(" ");
                ++j2;
            }
            if (showAscii) {
                sb.append(" ");
                j2 = bi;
                while (j2 - bi < headerLen) {
                    if (j2 < bMaxNdx) {
                        if (b[j2] >= 32 && b[j2] <= 126) {
                            sb.append((char)b[j2]);
                        } else {
                            sb.append('.');
                        }
                    } else {
                        sb.append(" ");
                    }
                    ++j2;
                }
            }
            sb.append("\n");
            bi += headerLen;
        }
        int count = 0;
        while (bi < bMaxNdx) {
            sb.append(StringTools.format(bi, "0000")).append(": ");
            j = bi;
            while (j - bi < blockLen) {
                if (j < bMaxNdx) {
                    StringTools.toHexString(b[j], sb);
                    ++count;
                } else {
                    sb.append("  ");
                }
                sb.append(" ");
                ++j;
            }
            if (showAscii) {
                sb.append(" ");
                j = bi;
                while (j - bi < blockLen) {
                    if (j < bMaxNdx) {
                        if (b[j] >= 32 && b[j] <= 126) {
                            sb.append((char)b[j]);
                        } else {
                            sb.append('.');
                        }
                    } else {
                        sb.append(" ");
                    }
                    ++j;
                }
            }
            sb.append("\n");
            bi += blockLen;
        }
        sb.append(count).append(" bytes\n");
        return sb;
    }

    public static StringBuffer toHexString(byte b, StringBuffer sb) {
        if (sb == null) {
            sb = new StringBuffer();
        }
        sb.append(HEX.charAt(b >> 4 & 0xF));
        sb.append(HEX.charAt(b & 0xF));
        return sb;
    }

    public static String toHexString(byte b) {
        return StringTools.toHexString(b, null).toString();
    }

    public static StringBuffer toHexString(byte[] b, int ofs, int len, StringBuffer sb) {
        if (sb == null) {
            sb = new StringBuffer();
        }
        if (b != null) {
            int bstrt = ofs < 0 ? 0 : ofs;
            int bstop = len < 0 ? b.length : Math.min(b.length, ofs + len);
            for (int i = bstrt; i < bstop; ++i) {
                StringTools.toHexString(b[i], sb);
            }
        }
        return sb;
    }

    public static StringBuffer toHexString(byte[] b, StringBuffer sb) {
        return StringTools.toHexString(b, 0, -1, sb);
    }

    public static String toHexString(byte[] b) {
        return StringTools.toHexString(b, 0, -1, null).toString();
    }

    public static String toHexString(byte[] b, int ofs, int len) {
        return StringTools.toHexString(b, ofs, len, null).toString();
    }

    public static String toHexString(BigInteger val, int bitLen) {
        StringBuffer hex;
        int nybbleLen;
        if (val == null) {
            return "";
        }
        int bitCount = val.bitCount();
        if (bitLen <= 0 && (bitLen = (bitCount + 7) / 8 * 8) < 8) {
            bitLen = 8;
        }
        if (bitCount > bitLen) {
            val = val.and(BigInteger.ONE.shiftLeft(bitLen).subtract(BigInteger.ONE));
        }
        if ((nybbleLen = (bitLen + 7) / 8 * 2) > (hex = new StringBuffer(val.toString(16).toUpperCase())).length()) {
            hex.insert(0, StringTools.replicateString("0", nybbleLen - hex.length()));
        }
        return hex.toString();
    }

    public static String toHexString(BigInteger val) {
        return StringTools.toHexString(val, -1);
    }

    public static String toHexString(long val, int bitLen) {
        if (bitLen <= 0) {
            bitLen = (val & 0xFFFFFFFF00000000L) != 0L ? 64 : ((val & 0xFFFF0000L) != 0L ? 32 : ((val & 0xFF00L) != 0L ? 16 : 8));
        } else if (bitLen > 64) {
            bitLen = 64;
        }
        int nybbleLen = (bitLen + 7) / 8 * 2;
        StringBuffer hex = new StringBuffer(Long.toHexString(val).toUpperCase());
        if (nybbleLen <= 16 && nybbleLen > hex.length()) {
            String mask = "0000000000000000";
            hex.insert(0, mask.substring(0, nybbleLen - hex.length()));
        }
        return hex.toString();
    }

    public static String toHexString(long val) {
        return StringTools.toHexString(val, 64);
    }

    public static String toHexString(int val) {
        return StringTools.toHexString((long)val & 0xFFFFFFFFL, 32);
    }

    public static String toHexString(short val) {
        return StringTools.toHexString((long)val & 0xFFFFL, 16);
    }

    public static String toHexString(Number val) {
        if (val == null) {
            return "";
        }
        if (val instanceof Byte) {
            return StringTools.toHexString(val.byteValue());
        }
        if (val instanceof Short) {
            return StringTools.toHexString(val.shortValue());
        }
        if (val instanceof Integer) {
            return StringTools.toHexString(val.intValue());
        }
        if (val instanceof Long) {
            return StringTools.toHexString(val.longValue());
        }
        if (val instanceof BigInteger) {
            return StringTools.toHexString(val, -1);
        }
        return StringTools.toHexString(val.longValue());
    }

    public static String toHexString(Number val, int bitLen) {
        if (val == null) {
            return "";
        }
        if (val instanceof BigInteger) {
            return StringTools.toHexString(val, bitLen);
        }
        return StringTools.toHexString(val.longValue(), bitLen);
    }

    public static StringBuffer toBinaryString(byte[] b, int ofs, int len, StringBuffer sb) {
        if (sb == null) {
            sb = new StringBuffer();
        }
        if (b != null) {
            int bstrt = ofs < 0 ? 0 : ofs;
            int bstop = len < 0 ? b.length : Math.min(b.length, ofs + len);
            for (int i = bstrt; i < bstop; ++i) {
                if (i > 0) {
                    sb.append(" ");
                }
                StringTools.toBinaryString(b[i], sb);
            }
        }
        return sb;
    }

    public static StringBuffer toBinaryString(byte[] b, StringBuffer sb) {
        if (sb == null) {
            sb = new StringBuffer();
        }
        if (b != null) {
            for (int i = 0; i < b.length; ++i) {
                if (i > 0) {
                    sb.append(" ");
                }
                StringTools.toBinaryString(b[i], sb);
            }
        }
        return sb;
    }

    public static String toBinaryString(byte[] b) {
        return StringTools.toBinaryString(b, new StringBuffer()).toString();
    }

    public static String toBinaryString(byte[] b, int ofs, int len) {
        return StringTools.toBinaryString(b, ofs, len, null).toString();
    }

    public static StringBuffer toBinaryString(byte b, StringBuffer sb) {
        return StringTools.toBinaryString(b, 8, sb);
    }

    public static String toBinaryString(byte b) {
        return StringTools.toBinaryString(b, null).toString();
    }

    public static StringBuffer toBinaryString(int i, StringBuffer sb) {
        return StringTools.toBinaryString(i, 32, sb);
    }

    public static String toBinaryString(int i) {
        return StringTools.toBinaryString(i, null).toString();
    }

    public static StringBuffer toBinaryString(long i, int bc, StringBuffer sb) {
        String s;
        if (bc <= 0) {
            bc = 64;
        }
        if (sb == null) {
            sb = new StringBuffer();
        }
        if ((s = Long.toBinaryString(i)).length() > bc) {
            s = s.substring(s.length() - bc);
        } else if (s.length() < bc) {
            while (s.length() < bc) {
                s = "0" + s;
            }
        }
        sb.append(s);
        return sb;
    }

    public static StringBuffer toBinaryString(long i, StringBuffer sb) {
        return StringTools.toBinaryString(i, -1, sb);
    }

    public static String toBinaryString(long i) {
        return StringTools.toBinaryString(i, -1, null).toString();
    }

    public static String setFirstUpperCase(String s) {
        if (s != null) {
            boolean space = true;
            boolean digitSpace = true;
            StringBuffer sb = new StringBuffer(s);
            for (int i = 0; i < sb.length(); ++i) {
                char ch = sb.charAt(i);
                if (Character.isWhitespace(ch)) {
                    space = true;
                    continue;
                }
                if (digitSpace && Character.isDigit(ch)) {
                    space = true;
                    continue;
                }
                if (space) {
                    if (Character.isLowerCase(ch)) {
                        sb.setCharAt(i, (char)(ch - 32));
                    }
                    space = false;
                    continue;
                }
                if (!Character.isUpperCase(ch)) continue;
                sb.setCharAt(i, (char)(ch + 32));
            }
            return sb.toString();
        }
        return null;
    }

    public static boolean startsWith(byte[] b, String p) {
        if (b != null && p != null && b.length >= p.length()) {
            for (int i = 0; i < p.length(); ++i) {
                if (p.charAt(i) == (char)b[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean startsWith(byte[] b, String[] ap) {
        if (b != null && ap != null) {
            for (String p : ap) {
                if (!StringTools.startsWith(b, p)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public static boolean startsWith(String t, String p) {
        if (t != null && p != null) {
            return t.startsWith(p);
        }
        return false;
    }

    public static boolean startsWith(String t, String[] ap) {
        if (t != null && ap != null) {
            for (String p : ap) {
                if (!StringTools.startsWith(t, p)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public static boolean startsWithIgnoreCase(String t, String p) {
        if (t != null && p != null) {
            return t.toLowerCase().startsWith(p.toLowerCase());
        }
        return false;
    }

    public static boolean startsWithIgnoreCase(String t, String[] ap) {
        if (t != null && ap != null) {
            for (String p : ap) {
                if (!StringTools.startsWithIgnoreCase(t, p)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public static boolean endsWith(String t, String p) {
        if (t != null && p != null) {
            return t.endsWith(p);
        }
        return false;
    }

    public static boolean endsWithIgnoreCase(String t, String p) {
        if (t != null && p != null) {
            return t.toLowerCase().endsWith(p.toLowerCase());
        }
        return false;
    }

    public static boolean endsWithIgnoreCase(String t, String[] p) {
        if (t != null && p != null) {
            String tlc = t.toLowerCase();
            for (int i = 0; i < p.length; ++i) {
                String plc;
                if (p[i] == null || !tlc.endsWith(plc = p[i].toLowerCase())) continue;
                return true;
            }
        }
        return false;
    }

    public static int indexOfIgnoreCase(String t, String p) {
        if (t != null && p != null) {
            return t.toLowerCase().indexOf(p.toLowerCase());
        }
        return -1;
    }

    public static int indexOfIgnoreCase(String tt, String[] pp) {
        if (tt != null && !ListTools.isEmpty(pp)) {
            String t = tt.toLowerCase();
            for (String p : pp) {
                int ndx = t.indexOf(p.toLowerCase());
                if (ndx < 0) continue;
                return ndx;
            }
            return -1;
        }
        return -1;
    }

    public static int indexOf(String t, String p) {
        if (t != null && p != null) {
            return t.indexOf(p);
        }
        return -1;
    }

    public static int indexOf(String t, char c) {
        if (t != null) {
            return t.indexOf(c);
        }
        return -1;
    }

    public static int indexOf(String t, int n, String p) {
        if (t != null && p != null && n >= 0 && n < t.length()) {
            return t.indexOf(p, n);
        }
        return -1;
    }

    public static int indexOf(String t, int n, char c) {
        if (t != null && n >= 0 && n < t.length()) {
            return t.indexOf(c, n);
        }
        return -1;
    }

    public static int indexOf(String tt, String ... pp) {
        if (tt != null && !ListTools.isEmpty(pp)) {
            String t = tt;
            for (String p : pp) {
                int ndx = t.indexOf(p);
                if (ndx < 0) continue;
                return ndx;
            }
            return -1;
        }
        return -1;
    }

    public static int indexOf(String tt, char ... cc) {
        if (tt != null && !ListTools.isEmpty(cc)) {
            String t = tt;
            for (char c : cc) {
                int ndx = t.indexOf(c);
                if (ndx < 0) continue;
                return ndx;
            }
            return -1;
        }
        return -1;
    }

    public static int indexOf(String tt, int n, String ... pp) {
        if (tt != null && !ListTools.isEmpty(pp) && n >= 0 && n < tt.length()) {
            String t = tt;
            for (String p : pp) {
                int ndx = t.indexOf(p, n);
                if (ndx < 0) continue;
                return ndx;
            }
            return -1;
        }
        return -1;
    }

    public static int indexOf(String tt, int n, char ... cc) {
        if (tt != null && !ListTools.isEmpty(cc) && n >= 0 && n < tt.length()) {
            String t = tt;
            for (char c : cc) {
                int ndx = t.indexOf(c, n);
                if (ndx < 0) continue;
                return ndx;
            }
            return -1;
        }
        return -1;
    }

    public static int lastIndexOf(String t, String p) {
        if (t != null && p != null) {
            return t.lastIndexOf(p);
        }
        return -1;
    }

    public static int lastIndexOf(String t, char c) {
        if (t != null) {
            return t.lastIndexOf(c);
        }
        return -1;
    }

    public static int lastIndexOf(String t, int n, String p) {
        if (t != null && p != null && n >= 0 && n < t.length()) {
            return t.lastIndexOf(p, n);
        }
        return -1;
    }

    public static int lastIndexOf(String t, int n, char c) {
        if (t != null && n >= 0 && n < t.length()) {
            return t.lastIndexOf(c, n);
        }
        return -1;
    }

    public static int lastIndexOf(String tt, String ... pp) {
        if (tt != null && !ListTools.isEmpty(pp)) {
            String t = tt;
            for (String p : pp) {
                int ndx = t.lastIndexOf(p);
                if (ndx < 0) continue;
                return ndx;
            }
            return -1;
        }
        return -1;
    }

    public static int lastIndexOf(String tt, char ... cc) {
        if (tt != null && !ListTools.isEmpty(cc)) {
            String t = tt;
            for (char c : cc) {
                int ndx = t.lastIndexOf(c);
                if (ndx < 0) continue;
                return ndx;
            }
            return -1;
        }
        return -1;
    }

    public static int lastIndexOf(String tt, int n, String ... pp) {
        if (tt != null && !ListTools.isEmpty(pp) && n >= 0 && n < tt.length()) {
            String t = tt;
            for (String p : pp) {
                int ndx = t.lastIndexOf(p, n);
                if (ndx < 0) continue;
                return ndx;
            }
            return -1;
        }
        return -1;
    }

    public static int lastIndexOf(String tt, int n, char ... cc) {
        if (tt != null && !ListTools.isEmpty(cc) && n >= 0 && n < tt.length()) {
            String t = tt;
            for (char c : cc) {
                int ndx = t.lastIndexOf(c, n);
                if (ndx < 0) continue;
                return ndx;
            }
            return -1;
        }
        return -1;
    }

    public static boolean contains(String t, String m) {
        if (t != null && m != null) {
            return t.indexOf(m) >= 0;
        }
        return false;
    }

    public static boolean containsIgnoreCase(String t, String m) {
        if (t != null && m != null) {
            return t.toLowerCase().indexOf(m.toLowerCase()) >= 0;
        }
        return false;
    }

    public static int indexOf(char[] A, char c) {
        if (A != null) {
            for (int i = 0; i < A.length; ++i) {
                if (A[i] != c) continue;
                return i;
            }
        }
        return -1;
    }

    public static int indexOf(byte[] B, byte b) {
        if (B != null) {
            for (int i = 0; i < B.length; ++i) {
                if (B[i] != b) continue;
                return i;
            }
        }
        return -1;
    }

    public static String[] parseArray(String s) {
        return StringTools.parseArray(s, ',');
    }

    public static String[] parseArray(String s, char arrayDelim) {
        if (StringTools.isBlank(s)) {
            return new String[0];
        }
        int len = s.length();
        char[] ch = new char[len];
        s.getChars(0, len, ch, 0);
        Vector<String> v = new Vector<String>();
        int a = 0;
        while (a < len) {
            StringBuffer sb;
            if (Character.isWhitespace(ch[a])) {
                while (a < len && Character.isWhitespace(ch[a])) {
                    ++a;
                }
                continue;
            }
            if (ch[a] == arrayDelim) {
                v.add("");
                ++a;
                continue;
            }
            if (ch[a] == '\"' || ch[a] == '\'') {
                sb = new StringBuffer();
                v.add(sb.toString());
                for (a = StringTools.parseQuote(ch, a, sb); a < len && ch[a] != arrayDelim; ++a) {
                }
                if (a >= len) break;
                ++a;
                continue;
            }
            sb = new StringBuffer();
            while (a < len && ch[a] != arrayDelim) {
                sb.append(ch[a++]);
            }
            v.add(sb.toString().trim());
            if (a >= len) break;
            ++a;
        }
        return ListTools.toArray(v, String.class);
    }

    public static String encodeArray(Object[] list, char delim, boolean alwaysQuote) {
        return StringTools.encodeArray(list, 0, -1, delim, alwaysQuote);
    }

    public static String encodeArray(Object[] list, int ofs, int max, char delim, boolean alwaysQuote) {
        StringBuffer sb = new StringBuffer();
        if (list != null) {
            int i;
            if (max < 0 || max > list.length) {
                max = list.length;
            }
            int n = i = ofs >= 0 ? ofs : 0;
            while (i < max) {
                String s;
                if (sb.length() > 0) {
                    sb.append(delim);
                }
                String string = s = list[i] != null ? list[i].toString() : "";
                if (alwaysQuote || s.indexOf(32) >= 0 || s.indexOf(9) >= 0 || s.indexOf(34) >= 0 || s.indexOf(delim) >= 0) {
                    s = StringTools.quoteString(s);
                }
                sb.append(s);
                ++i;
            }
        }
        return sb.toString();
    }

    public static String encodeArray(Object list, char delim, boolean alwaysQuote) {
        return StringTools.encodeArray(list, 0, -1, delim, alwaysQuote);
    }

    public static String encodeArray(Object list, int ofs, int max, char delim, boolean alwaysQuote) {
        if (list == null) {
            return "";
        }
        if (list instanceof Object[]) {
            return StringTools.encodeArray((Object[])list, ofs, max, delim, alwaysQuote);
        }
        if (list.getClass().isArray()) {
            int i;
            StringBuffer sb = new StringBuffer();
            int listLen = Array.getLength(list);
            if (max < 0 || max > listLen) {
                max = listLen;
            }
            int n = i = ofs >= 0 ? ofs : 0;
            while (i < max) {
                Object list_i;
                String s;
                if (sb.length() > 0) {
                    sb.append(delim);
                }
                String string = s = (list_i = Array.get(list, i)) != null ? list_i.toString() : "";
                if (alwaysQuote || s.indexOf(32) >= 0 || s.indexOf(9) >= 0 || s.indexOf(34) >= 0 || s.indexOf(delim) >= 0) {
                    s = StringTools.quoteString(s);
                }
                sb.append(s);
                ++i;
            }
            return sb.toString();
        }
        if (ofs <= 0 && max != 0) {
            return alwaysQuote ? StringTools.quoteString(list.toString()) : list.toString();
        }
        return "";
    }

    public static String encodeArray(List<Object> list, char delim, boolean alwaysQuote) {
        return StringTools.encodeArray(ListTools.toArray(list), delim, alwaysQuote);
    }

    public static String encodeArray(List<Object> list) {
        return StringTools.encodeArray(ListTools.toArray(list), ',', true);
    }

    public static String encodeArray(List<Object> list, boolean alwaysQuote) {
        return StringTools.encodeArray(ListTools.toArray(list), ',', alwaysQuote);
    }

    public static String encodeArray(Object[] list) {
        return StringTools.encodeArray(list, ',', true);
    }

    public static String encodeArray(Object[] list, boolean alwaysQuote) {
        return StringTools.encodeArray(list, ',', alwaysQuote);
    }

    public static String encodeArray(String[] list) {
        return StringTools.encodeArray(list, ',', true);
    }

    public static String encodeArray(String[] list, boolean alwaysQuote) {
        return StringTools.encodeArray(list, ',', alwaysQuote);
    }

    public static String encodeArray(Object list) {
        return StringTools.encodeArray(list, ',', true);
    }

    public static String encodeArray(Object list, boolean alwaysQuote) {
        return StringTools.encodeArray(list, ',', alwaysQuote);
    }

    public static String[] toArray(List list) {
        if (list != null) {
            String[] s = new String[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                Object obj = list.get(i);
                s[i] = obj != null ? obj.toString() : null;
            }
            return s;
        }
        return new String[0];
    }

    public static String[] parseStringArray(String value, char delim) {
        return StringTools.parseStringArray(value, String.valueOf(delim), true);
    }

    public static String[] parseStringArray(String value, String sdelim) {
        return StringTools.parseStringArray(value, sdelim, true);
    }

    public static String[] parseStringArray(StringBuffer value, char delim) {
        if (value == null) {
            return new String[0];
        }
        return StringTools.parseStringArray(value.toString(), String.valueOf(delim), true);
    }

    public static String[] parseStringArray(StringBuffer value, String sdelim) {
        if (value == null) {
            return new String[0];
        }
        return StringTools.parseStringArray(value.toString(), sdelim, true);
    }

    public static String[] parseStringArray(StringBuffer value, String sdelim, boolean trim) {
        if (value == null) {
            return new String[0];
        }
        return StringTools.parseStringArray(value.toString(), sdelim, trim);
    }

    public static String[] parseStringArray(String value, String sdelim, boolean trim) {
        if (value != null) {
            boolean skipNL = sdelim.equals("\r\n");
            Vector<String> v1 = new Vector<String>();
            ListTools.toList(new StringTokenizer(value, sdelim, true), v1);
            int dupDelim = 1;
            boolean consumeNextNL = false;
            Vector<String> v2 = new Vector<String>();
            for (String s : v1) {
                if (s.length() == 1 && sdelim.indexOf(s) >= 0) {
                    if (skipNL) {
                        char ch = s.charAt(0);
                        if (consumeNextNL && ch == '\n') {
                            consumeNextNL = false;
                            continue;
                        }
                        boolean bl = consumeNextNL = ch == '\r';
                        if (dupDelim > 0) {
                            v2.add("");
                        }
                        ++dupDelim;
                        continue;
                    }
                    if (dupDelim > 0) {
                        v2.add("");
                    }
                    ++dupDelim;
                    continue;
                }
                v2.add(trim ? s.trim() : s);
                dupDelim = 0;
                consumeNextNL = false;
            }
            if (dupDelim > 0) {
                v2.add("");
            }
            return v2.toArray(new String[v2.size()]);
        }
        return new String[0];
    }

    public static String[] split(String value, char delim) {
        return StringTools.parseStringArray(value, String.valueOf(delim), true);
    }

    public static String[] split(String value, char delim, boolean trim) {
        return StringTools.parseStringArray(value, String.valueOf(delim), trim);
    }

    public static String[] split(StringBuffer value, char delim) {
        return StringTools.parseStringArray(value, String.valueOf(delim), true);
    }

    public static String[] split(StringBuffer value, char delim, boolean trim) {
        return StringTools.parseStringArray(value, String.valueOf(delim), trim);
    }

    public static String[] split(byte[] value, char delim) {
        return StringTools.split(value, delim, true);
    }

    public static String[] split(byte[] value, char delim, boolean trim) {
        String s = StringTools.toStringValue(value);
        return StringTools.parseStringArray(s, String.valueOf(delim), trim);
    }

    public static String join(String[] val, int ofs, char delim) {
        StringBuffer sb = new StringBuffer();
        if (val != null) {
            int i;
            int n = i = ofs >= 0 ? ofs : 0;
            while (i < val.length) {
                if (val[i] != null) {
                    if (sb.length() > 0) {
                        sb.append(delim);
                    }
                    sb.append(val[i]);
                }
                ++i;
            }
        }
        return sb.toString();
    }

    public static String join(String[] val, char delim) {
        return StringTools.join(val, 0, delim);
    }

    public static String join(String[] val, int ofs, String delim) {
        StringBuffer sb = new StringBuffer();
        if (val != null) {
            int i;
            int n = i = ofs >= 0 ? ofs : 0;
            while (i < val.length) {
                if (sb.length() > 0) {
                    sb.append(delim);
                }
                if (val[i] != null) {
                    sb.append(val[i]);
                }
                ++i;
            }
        }
        return sb.toString();
    }

    public static String join(String[] val, String delim) {
        return StringTools.join(val, 0, delim);
    }

    public static String join(Object[] val, int ofs, char delim) {
        StringBuffer sb = new StringBuffer();
        if (val != null) {
            int i;
            int n = i = ofs >= 0 ? ofs : 0;
            while (i < val.length) {
                if (sb.length() > 0) {
                    sb.append(delim);
                }
                if (val[i] != null) {
                    sb.append(val[i].toString());
                }
                ++i;
            }
        }
        return sb.toString();
    }

    public static String join(Object[] val, char delim) {
        return StringTools.join(val, 0, delim);
    }

    public static String join(Object[] val, int ofs, String delim) {
        StringBuffer sb = new StringBuffer();
        if (val != null) {
            int i;
            int n = i = ofs >= 0 ? ofs : 0;
            while (i < val.length) {
                if (sb.length() > 0) {
                    sb.append(delim);
                }
                if (val[i] != null) {
                    sb.append(val[i].toString());
                }
                ++i;
            }
        }
        return sb.toString();
    }

    public static String join(Object[] val, String delim) {
        return StringTools.join(val, 0, delim);
    }

    public static String join(Iterable<?> list, int ofs, char delim) {
        StringBuffer sb = new StringBuffer();
        if (list != null) {
            for (Object val : list) {
                if (ofs > 0) {
                    --ofs;
                    continue;
                }
                if (sb.length() > 0) {
                    sb.append(delim);
                }
                if (val == null) continue;
                sb.append(val.toString());
            }
        }
        return sb.toString();
    }

    public static String join(Iterable<?> list, char delim) {
        return StringTools.join(list, 0, delim);
    }

    public static String join(Iterable<?> list, int ofs, String delim) {
        StringBuffer sb = new StringBuffer();
        if (list != null) {
            for (Object val : list) {
                if (ofs > 0) {
                    --ofs;
                    continue;
                }
                if (sb.length() > 0) {
                    sb.append(delim);
                }
                if (val == null) continue;
                sb.append(val.toString());
            }
        }
        return sb.toString();
    }

    public static String join(Iterable<?> list, String delim) {
        return StringTools.join(list, 0, delim);
    }

    public static String join(int[] val, char delim) {
        StringBuffer sb = new StringBuffer();
        if (val != null) {
            for (int i = 0; i < val.length; ++i) {
                if (sb.length() > 0) {
                    sb.append(delim);
                }
                sb.append(val[i]);
            }
        }
        return sb.toString();
    }

    public static String join(int[] val, String delim) {
        StringBuffer sb = new StringBuffer();
        if (val != null) {
            for (int i = 0; i < val.length; ++i) {
                if (sb.length() > 0) {
                    sb.append(delim);
                }
                sb.append(val[i]);
            }
        }
        return sb.toString();
    }

    public static String join(long[] val, char delim) {
        StringBuffer sb = new StringBuffer();
        if (val != null) {
            for (int i = 0; i < val.length; ++i) {
                if (sb.length() > 0) {
                    sb.append(delim);
                }
                sb.append(val[i]);
            }
        }
        return sb.toString();
    }

    public static String join(long[] val, String delim) {
        StringBuffer sb = new StringBuffer();
        if (val != null) {
            for (int i = 0; i < val.length; ++i) {
                if (sb.length() > 0) {
                    sb.append(delim);
                }
                sb.append(val[i]);
            }
        }
        return sb.toString();
    }

    public static String join(double[] val, char delim) {
        StringBuffer sb = new StringBuffer();
        if (val != null) {
            for (int i = 0; i < val.length; ++i) {
                if (sb.length() > 0) {
                    sb.append(delim);
                }
                sb.append(val[i]);
            }
        }
        return sb.toString();
    }

    public static String join(double[] val, String delim) {
        StringBuffer sb = new StringBuffer();
        if (val != null) {
            for (int i = 0; i < val.length; ++i) {
                if (sb.length() > 0) {
                    sb.append(delim);
                }
                sb.append(val[i]);
            }
        }
        return sb.toString();
    }

    public static String join(float[] val, char delim) {
        StringBuffer sb = new StringBuffer();
        if (val != null) {
            for (int i = 0; i < val.length; ++i) {
                if (sb.length() > 0) {
                    sb.append(delim);
                }
                sb.append(val[i]);
            }
        }
        return sb.toString();
    }

    public static String join(float[] val, String delim) {
        StringBuffer sb = new StringBuffer();
        if (val != null) {
            for (int i = 0; i < val.length; ++i) {
                if (sb.length() > 0) {
                    sb.append(delim);
                }
                sb.append(val[i]);
            }
        }
        return sb.toString();
    }

    private static boolean _isSepChar(char ch, char sepChar) {
        if (sepChar == '\u0000' || sepChar == ' ') {
            return Character.isWhitespace(ch);
        }
        return ch == sepChar;
    }

    private static boolean _isSepChar(char ch, char[] sepChar) {
        if (sepChar == null || sepChar.length == 0) {
            return false;
        }
        for (int s = 0; s < sepChar.length; ++s) {
            if (!StringTools._isSepChar(ch, sepChar[s])) continue;
            return true;
        }
        return false;
    }

    private static int _indexOfChar(String S, char[] C) {
        int slen = S.length();
        for (int si = 0; si < slen; ++si) {
            char ch = S.charAt(si);
            for (int ci = 0; ci < C.length; ++ci) {
                if (ch != C[ci]) continue;
                return si;
            }
        }
        return -1;
    }

    public static Map<String, String> parseProperties(String props) {
        return StringTools.parseProperties(props, ' ', KeyValSeparatorChars, null);
    }

    public static Map<String, String> parseProperties(String props, char propSep) {
        return StringTools.parseProperties(props, propSep, KeyValSeparatorChars, null);
    }

    public static Map<String, String> parseProperties(String props, Map<String, String> properties) {
        return StringTools.parseProperties(props, ' ', KeyValSeparatorChars, properties);
    }

    public static Map<String, String> parseProperties(String props, char propSep, Map<String, String> properties) {
        return StringTools.parseProperties(props, propSep, KeyValSeparatorChars, properties);
    }

    public static Map<String, String> parseProperties(String props, char propSep, char[] keyValSep) {
        return StringTools.parseProperties(props, propSep, keyValSep, null);
    }

    public static Map<String, String> parseProperties(String props, char propSep, char[] keyValSep, Map<String, String> properties) {
        boolean spacePropSep;
        boolean bl = spacePropSep = propSep == '\u0000' || propSep == ' ';
        if (properties == null) {
            properties = new OrderedMap<String, String>();
        }
        String r = StringTools.trim(props);
        boolean n1 = false;
        int n2 = r.indexOf(32);
        int n3 = StringTools._indexOfChar(r, keyValSep);
        if (n2 < 0) {
            n2 = r.length();
        }
        n2 = n3 < 0 || n2 < n3 ? 0 : 0;
        int argsLen = r.length() - n2;
        int a = 0;
        char[] args = new char[argsLen];
        r.getChars(n2, r.length(), args, 0);
        while (a < argsLen) {
            while (a < argsLen && (Character.isWhitespace(args[a]) || StringTools._isSepChar(args[a], propSep))) {
                ++a;
            }
            StringBuffer propName = new StringBuffer();
            while (!(a >= argsLen || Character.isWhitespace(args[a]) || StringTools._isSepChar(args[a], propSep) || StringTools._isSepChar(args[a], keyValSep))) {
                propName.append(args[a]);
                ++a;
            }
            if (!spacePropSep) {
                while (a < argsLen && Character.isWhitespace(args[a])) {
                    ++a;
                }
            }
            StringBuffer propValue = new StringBuffer();
            if (a < argsLen && StringTools._isSepChar(args[a], keyValSep)) {
                ++a;
                if (!spacePropSep) {
                    while (a < argsLen && Character.isWhitespace(args[a])) {
                        ++a;
                    }
                }
                if (a < argsLen && args[a] == '\"') {
                    ++a;
                    while (a < argsLen && args[a] != '\"') {
                        if (a + 1 < argsLen && args[a] == '\\') {
                            ++a;
                        }
                        propValue.append(args[a]);
                        ++a;
                    }
                    if (a < argsLen) {
                        ++a;
                    }
                } else {
                    while (a < argsLen && !Character.isWhitespace(args[a]) && !StringTools._isSepChar(args[a], propSep)) {
                        propValue.append(args[a]);
                        ++a;
                    }
                }
            }
            if (propName.length() > 0) {
                String key = propName.toString();
                String val = propValue.toString();
                properties.put(key, val);
            }
            while (a < argsLen && !StringTools._isSepChar(args[a], propSep)) {
                ++a;
            }
            if (a >= argsLen || StringTools._isSepChar(args[a], propSep)) continue;
            ++a;
        }
        return properties;
    }

    public static String stripChars(String src, char[] chars) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < chars.length; ++i) {
            sb.append(chars[i]);
        }
        return StringTools.stripChars(src, sb.toString(), 1);
    }

    public static String stripChars(String src, char ch) {
        return StringTools.stripChars(src, String.valueOf(ch), 1);
    }

    public static String stripChars(String src, String chars) {
        return StringTools.stripChars(src, chars, 1);
    }

    public static String stripChars(String src, char ch, int stripType) {
        return StringTools.stripChars(src, String.valueOf(ch), stripType);
    }

    public static String stripChars(String src, String chars, int stripType) {
        if (src != null && chars != null) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < src.length(); ++i) {
                char ch = src.charAt(i);
                if (stripType == 0) {
                    if (chars.indexOf(ch) < 0) continue;
                    sb.append(ch);
                    continue;
                }
                if (chars.indexOf(ch) >= 0) continue;
                sb.append(ch);
            }
            return sb.toString();
        }
        return src;
    }

    public static String trimTrailingComments(String S, String C) {
        if (StringTools.isBlank(S)) {
            return S;
        }
        if (StringTools.isBlank(C)) {
            return S;
        }
        String[] R = StringTools.split(S, '\n');
        for (int r = 0; r < R.length; ++r) {
            int p = R[r].indexOf(C);
            if (p < 0) continue;
            R[r] = StringTools.trimTrailing(R[r].substring(0, p));
        }
        return StringTools.join(R, "\n");
    }

    public static String replaceChars(String src, char ch, char repChar) {
        return StringTools.replaceChars(src, String.valueOf(ch), String.valueOf(repChar));
    }

    public static String replaceChars(String src, String chars, char repChar) {
        return StringTools.replaceChars(src, chars, String.valueOf(repChar));
    }

    public static String replaceChars(String src, String chars, String repStr) {
        if (src != null && chars != null) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < src.length(); ++i) {
                char ch = src.charAt(i);
                if (chars.indexOf(ch) >= 0) {
                    if (repStr == null) continue;
                    sb.append(repStr);
                    continue;
                }
                sb.append(ch);
            }
            return sb.toString();
        }
        return src;
    }

    public static String replaceWhitespace(String src, char repChar) {
        return StringTools.replaceWhitespace(src, String.valueOf(repChar));
    }

    public static String replaceWhitespace(String src, String repStr) {
        if (src != null && repStr != null) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < src.length(); ++i) {
                char ch = src.charAt(i);
                if (Character.isWhitespace(ch)) {
                    sb.append(repStr);
                    continue;
                }
                sb.append(ch);
            }
            return sb.toString();
        }
        return src;
    }

    public static String replaceKeys(String text, KeyValueMap keyMap) {
        return StringTools.replaceKeys(text, keyMap, null, null, null, null, null);
    }

    public static String replaceKeys(String text, KeyValueMap keyMap, ValueFilter filter) {
        return StringTools.replaceKeys(text, keyMap, filter, null, null, null, null);
    }

    public static String replaceKeys(String text, KeyValueMap keyMap, ValueFilter filter, String keyStart, String keyEnd, String argDelim, String dftDelim) {
        if (StringTools.isBlank(keyStart)) {
            keyStart = KEY_START;
        }
        if (text == null || text.indexOf(keyStart) < 0) {
            return text;
        }
        StringBuffer repText = StringTools.replaceKeys(new StringBuffer(text), keyMap, filter, keyStart, keyEnd, argDelim, dftDelim, true);
        return repText.toString();
    }

    public static StringBuffer replaceKeys(StringBuffer repText, KeyValueMap keyMap, ValueFilter filter, String keyStart, String keyEnd, String argDelim, String dftDelim, boolean replaceEsc) {
        boolean inclSBNdx;
        int ks;
        if (StringTools.isBlank(keyStart)) {
            keyStart = KEY_START;
        }
        if (StringTools.isBlank(keyEnd)) {
            keyEnd = KEY_END;
        }
        if (StringTools.isBlank(dftDelim)) {
            dftDelim = DFT_DELIM;
        }
        if (StringTools.isBlank(argDelim)) {
            argDelim = ARG_DELIM;
        }
        int n = ks = repText != null ? repText.indexOf(keyStart) : -1;
        if (ks < 0) {
            return repText;
        }
        boolean bl = inclSBNdx = keyMap instanceof KeyValueMap_SBIndex;
        while (ks >= 0) {
            String key;
            String arg;
            String keyArg;
            String dftStr;
            if (!replaceEsc && ks > 0 && repText.charAt(ks - 1) == '\\') {
                ks = repText.indexOf(keyStart, ks + 1);
                continue;
            }
            int ke = repText.indexOf(keyEnd, ks);
            if (ke < 0) break;
            int ksi = ks > 0 && repText.charAt(ks - 1) == '\\' ? ks - 1 : ks;
            int ksx = ks + keyStart.length();
            int kex = ke + keyEnd.length();
            String keyArgDft = repText.substring(ksx, ke);
            int d = keyArgDft.indexOf(dftDelim);
            if (d >= 0) {
                dftStr = keyArgDft.substring(d + dftDelim.length());
                keyArg = keyArgDft.substring(0, d).trim();
            } else {
                dftStr = "";
                keyArg = keyArgDft;
            }
            int a = keyArg.indexOf(argDelim);
            if (a >= 0) {
                arg = keyArg.substring(a + argDelim.length());
                key = keyArg.substring(0, a).trim();
            } else {
                arg = null;
                key = keyArg;
            }
            String kv = keyMap != null ? (inclSBNdx ? ((KeyValueMap_SBIndex)keyMap).getKeyValue(key, arg, null, ksi) : keyMap.getKeyValue(key, arg, null)) : null;
            String fv = kv != null ? (filter != null ? filter.getFilteredValue(kv) : kv) : dftStr;
            repText.replace(ksi, kex, fv);
            ks = repText.indexOf(keyStart, ks);
        }
        return repText;
    }

    public static String replicateString(String pattern, int count) {
        if (pattern != null && count > 0) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < count; ++i) {
                sb.append(pattern);
            }
            return sb.toString();
        }
        return "";
    }

    public static String padRight(String s, char padChar, int len) {
        if (s == null) {
            return StringTools.replicateString(String.valueOf(padChar), len);
        }
        if (s.length() >= len) {
            return s;
        }
        return s + StringTools.replicateString(String.valueOf(padChar), len - s.length());
    }

    public static String leftAlign(String s, int len) {
        return StringTools.padRight(s, ' ', len);
    }

    public static String leftJustify(String s, int len) {
        return StringTools.padRight(s, ' ', len);
    }

    public static String padLeft(String s, char padChar, int len) {
        if (s == null) {
            return StringTools.replicateString(String.valueOf(padChar), len);
        }
        if (s.length() >= len) {
            return s;
        }
        return StringTools.replicateString(String.valueOf(padChar), len - s.length()) + s;
    }

    public static String rightAlign(String s, int len) {
        return StringTools.padLeft(s, ' ', len);
    }

    public static String rightJustify(String s, int len) {
        return StringTools.padLeft(s, ' ', len);
    }

    public static String rightAlign(long s, int len) {
        return StringTools.padLeft(String.valueOf(s), ' ', len);
    }

    public static String rightJustify(long s, int len) {
        return StringTools.padLeft(String.valueOf(s), ' ', len);
    }

    public static StringBuffer padToIndex(StringBuffer sb, char padChar, int ndx) {
        if (sb == null) {
            sb = new StringBuffer();
        }
        for (int c = sb.length(); c < ndx; ++c) {
            sb.append(padChar);
        }
        return sb;
    }

    public static String encodeNewline(String text) {
        if (text != null) {
            return StringTools.encodeNewline(new StringBuffer(text)).toString();
        }
        return null;
    }

    public static StringBuffer encodeNewline(StringBuffer sb) {
        if (sb != null) {
            int c = 0;
            while (c < sb.length()) {
                char ch = sb.charAt(c);
                if (ch == '\r') {
                    sb.deleteCharAt(c);
                    continue;
                }
                if (ch == '\n') {
                    sb.replace(c, c + 1, "\\n");
                    c += 2;
                    continue;
                }
                ++c;
            }
        }
        return sb;
    }

    public static String decodeNewline(String text) {
        if (text != null) {
            return StringTools.decodeNewline(new StringBuffer(text)).toString();
        }
        return null;
    }

    public static StringBuffer decodeNewline(StringBuffer sb) {
        return StringTools.replace(sb, "\\n", "\n");
    }

    public static String escapeChars(String text) {
        return StringTools.encodeEscapedCharacters(text);
    }

    public static String encodeEscapedCharacters(String text) {
        if (text != null) {
            return StringTools.encodeEscapedCharacters(new StringBuffer(text)).toString();
        }
        return null;
    }

    public static StringBuffer encodeEscapedCharacters(StringBuffer sb) {
        if (sb != null) {
            int c = 0;
            while (c < sb.length()) {
                char ch = sb.charAt(c);
                if (ch == '\r') {
                    sb.replace(c, c + 1, "\\r");
                    c += 2;
                    continue;
                }
                if (ch == '\n') {
                    sb.replace(c, c + 1, "\\n");
                    c += 2;
                    continue;
                }
                if (ch == '\t') {
                    sb.replace(c, c + 1, "\\t");
                    c += 2;
                    continue;
                }
                ++c;
            }
        }
        return sb;
    }

    public static String unescapeChars(String text) {
        return StringTools.decodeEscapedCharacters(text);
    }

    public static String decodeEscapedCharacters(String text) {
        if (text != null) {
            return StringTools.decodeEscapedCharacters(new StringBuffer(text)).toString();
        }
        return null;
    }

    public static StringBuffer decodeEscapedCharacters(StringBuffer sb) {
        StringTools.replace(sb, "\\n", "\n");
        StringTools.replace(sb, "\\r", "\r");
        StringTools.replace(sb, "\\t", "\t");
        return sb;
    }

    public static String replace(String text, String key, String val) {
        if (text != null) {
            return StringTools.replace(new StringBuffer(text), key, val).toString();
        }
        return null;
    }

    public static StringBuffer replace(StringBuffer sb, String key, String val) {
        if (sb != null) {
            int s = 0;
            while ((s = sb.indexOf(key, s)) >= 0) {
                int e = s + key.length();
                sb.replace(s, e, val);
                s += val.length();
            }
        }
        return sb;
    }

    public static String regexReplace(String target, String regex, String val) {
        try {
            int flags = 10;
            Pattern pattern = Pattern.compile(regex, flags);
            Matcher matcher = pattern.matcher(target);
            return matcher.replaceAll(val);
        }
        catch (Throwable th) {
            Print.logException("Pattern match error", th);
            return target;
        }
    }

    public static StringBuffer regexReplace(StringBuffer target, String regexKey, String val) {
        String s = StringTools.regexReplace(target.toString(), regexKey, val);
        return target.replace(0, target.length(), s);
    }

    public static boolean regexMatches(String target, String regex) {
        try {
            return Pattern.matches(regex, target);
        }
        catch (Throwable th) {
            Print.logException("Pattern match error", th);
            return false;
        }
    }

    public static RegexIndex regexIndexOf(String target, String regex) {
        return StringTools.regexIndexOf(target, regex, 0);
    }

    public static RegexIndex regexIndexOf(String target, String regex, int ndx) {
        try {
            int flags = 8;
            Pattern pattern = Pattern.compile(regex, flags);
            Matcher match = pattern.matcher(target);
            if (match.find(ndx)) {
                return new RegexIndex(match);
            }
            return null;
        }
        catch (Throwable th) {
            Print.logException("Pattern match error", th);
            return null;
        }
    }

    public static RegexIndex regexIndexOf(RegexIndex regNdx) {
        if (regNdx == null) {
            return null;
        }
        if (regNdx.getMatcher() == null) {
            return null;
        }
        if (regNdx.getMatcher().find()) {
            return regNdx;
        }
        return null;
    }

    public static String insertKeyValues(String text, String startDelim, String endDelim, String dftDelim, String[][] rep) {
        return StringTools.insertKeyValues(text, startDelim, endDelim, dftDelim, rep, false);
    }

    public static String insertKeyValues(String text, String startDelim, String endDelim, String dftDelim, String[][] rep, boolean htmlFilter) {
        if (text != null) {
            HashMap<String, String> repMap = new HashMap<String, String>();
            for (int i = 0; i < rep.length; ++i) {
                if (rep[i] == null || rep[i].length < 2) continue;
                repMap.put(rep[i][0], rep[i][1]);
            }
            return StringTools.insertKeyValues(text, startDelim, endDelim, dftDelim, repMap, htmlFilter);
        }
        return text;
    }

    public static String insertKeyValues(String text, String startDelim, String endDelim, String dftDelim, Map<String, String> map) {
        return StringTools.insertKeyValues(text, startDelim, endDelim, dftDelim, map, false);
    }

    public static String insertKeyValues(String text, String startDelim, String endDelim, String dftDelim, final Map<String, String> map, boolean htmlFilter) {
        if (text != null) {
            KeyValueMap rm = new KeyValueMap(){

                @Override
                public String getKeyValue(String key, String argNotUsed, String dft) {
                    Object val = key != null ? (Object)map.get(key) : null;
                    return val != null ? val.toString() : dft;
                }
            };
            return StringTools.insertKeyValues(text, startDelim, endDelim, dftDelim, rm, htmlFilter);
        }
        return text;
    }

    public static String insertKeyValues(String text, String startDelim, String endDelim, String dftDelim, KeyValueMap rmap) {
        return StringTools.insertKeyValues(text, startDelim, endDelim, dftDelim, rmap, false);
    }

    public static String insertKeyValues(String text, String startDelim, String endDelim, String dftDelim, KeyValueMap rmap, boolean htmlFilter) {
        String argDelim = ARG_DELIM;
        if (text == null) {
            return text;
        }
        if (StringTools.isBlank(startDelim)) {
            startDelim = KEY_START;
        }
        if (StringTools.isBlank(endDelim)) {
            endDelim = KEY_END;
        }
        if (StringTools.isBlank(argDelim)) {
            argDelim = ARG_DELIM;
        }
        if (StringTools.isBlank(dftDelim)) {
            dftDelim = DFT_DELIM;
        }
        char[] startDelimChars = startDelim.toCharArray();
        int startDelimLen = startDelimChars.length;
        char[] endDelimChars = endDelim.toCharArray();
        int endDelimLen = endDelimChars.length;
        StringBuffer sb = new StringBuffer(text);
        int s = 0;
        while (s < sb.length() && (s = sb.indexOf(startDelim, s)) >= 0) {
            String val;
            String key;
            String arg;
            String keyArg;
            String dftStr;
            if (s > 0 && sb.charAt(s - 1) == '\\') {
                s += startDelimLen;
                continue;
            }
            int e = StringTools._findEndDelimiter(sb, s + startDelimLen, startDelimChars, endDelimChars);
            if (e < 0) break;
            String keyArgDft = sb.substring(s + startDelimLen, e).trim();
            int d = keyArgDft.indexOf(dftDelim);
            if (d >= 0) {
                dftStr = keyArgDft.substring(d + dftDelim.length());
                keyArg = keyArgDft.substring(0, d).trim();
            } else {
                dftStr = "";
                keyArg = keyArgDft;
            }
            int a = keyArg.indexOf(argDelim);
            if (a >= 0) {
                arg = keyArg.substring(a + argDelim.length());
                key = keyArg.substring(0, a).trim();
            } else {
                arg = null;
                key = keyArg;
            }
            String string = val = rmap != null ? rmap.getKeyValue(key, arg, dftStr) : "?" + key + "?";
            if (val != null) {
                sb.replace(s, e + endDelimLen, htmlFilter ? StringTools.htmlFilterText(val) : val);
                s += val.length();
                continue;
            }
            s = e + endDelimLen;
        }
        return sb.toString();
    }

    private static int _findEndDelimiter(StringBuffer sb, int c, char[] sd, char[] ed) {
        int level = 1;
        int sblen = sb.length();
        while (c < sblen) {
            int x;
            if (sb.charAt(c) == '\\') {
                if (++c >= sblen) continue;
                ++c;
                continue;
            }
            if (sb.charAt(c) == sd[0]) {
                for (x = 1; x < sd.length && c + x < sblen && sb.charAt(c + x) == sd[x]; ++x) {
                }
                if (x == sd.length) {
                    ++level;
                    c += x;
                    continue;
                }
            }
            if (sb.charAt(c) == ed[0]) {
                for (x = 1; x < ed.length && c + x < sblen && sb.charAt(c + x) == ed[x]; ++x) {
                }
                if (x == ed.length) {
                    if (--level == 0) {
                        return c;
                    }
                    c += x;
                    continue;
                }
            }
            ++c;
        }
        return -1;
    }

    public static String formatLine(String fmt, final Object ... v) {
        StringBuffer repText = new StringBuffer(fmt);
        KeyValueMap_SBIndex kvm = new KeyValueMap_SBIndex(){
            private int lastColNdx = -1;

            @Override
            public String getKeyValue(String key, String arg, String dft, int lenNdx) {
                if (StringTools.isBlank(key)) {
                    return dft;
                }
                if (Character.isDigit(key.charAt(0))) {
                    int ndx = StringTools.parseInt(key, -1);
                    if (ndx >= 0 && ndx < v.length) {
                        String r = v[ndx] != null ? v[ndx].toString() : "";
                        int j = StringTools.parseInt(arg, 0);
                        if (j > 0) {
                            return StringTools.leftJustify(r, j);
                        }
                        if (j < 0) {
                            return StringTools.rightJustify(r, -j);
                        }
                        return r;
                    }
                    return dft;
                }
                if (key.equalsIgnoreCase("c")) {
                    int ndx;
                    String ndxArg = StringTools.blankDefault(arg, dft);
                    if (ndxArg.startsWith("+")) {
                        ndx = StringTools.parseInt(ndxArg, -1);
                        if (ndx >= 0 && this.lastColNdx >= 0) {
                            ndx += this.lastColNdx;
                        }
                    } else {
                        ndx = StringTools.parseInt(ndxArg, -1);
                    }
                    if (ndx > 0 && ndx < 999) {
                        if (lenNdx >= 0 && ndx > lenNdx) {
                            String r = StringTools.replicateString(" ", ndx - lenNdx);
                            this.lastColNdx = ndx;
                            return r;
                        }
                        return "";
                    }
                    return "";
                }
                return dft;
            }
        };
        StringTools.replaceKeys(repText, kvm, null, "{", KEY_END, ARG_DELIM, DFT_DELIM, false).toString();
        return repText.toString();
    }

    public static int compare(byte[] b1, byte[] b2) {
        return StringTools.compare(b1, b2, -1);
    }

    public static int compare(byte[] b1, byte[] b2, int len) {
        if (b1 == null && b2 == null) {
            return 0;
        }
        if (b1 == null) {
            return 1;
        }
        if (b2 == null) {
            return -1;
        }
        int n1 = b1.length;
        int n2 = b2.length;
        int i = 0;
        if (len < 0) {
            len = n1 >= n2 ? n1 : n2;
        }
        for (i = 0; i < n1 && i < n2 && i < len; ++i) {
            if (b1[i] == b2[i]) continue;
            return b1[i] - b2[i];
        }
        return i < len ? n1 - n2 : 0;
    }

    public static int compare(byte[] b1, String s) {
        return StringTools.compare(b1, s != null ? StringTools.getBytes(s) : null, -1);
    }

    public static boolean compareEquals(byte[] b1, byte[] b2, int len) {
        if (b1 == b2) {
            return true;
        }
        if (b1 == null || b2 == null) {
            return false;
        }
        return StringTools.compare(b1, b2, len) == 0;
    }

    public static boolean compareEquals(byte[] b1, byte[] b2) {
        return StringTools.compareEquals(b1, b2, -1);
    }

    public static boolean compareEquals(byte[] b, String s) {
        return StringTools.compareEquals(b, s != null ? StringTools.getBytes(s) : null, -1);
    }

    public static int diff(String s1, String s2) {
        int len = -1;
        if (s1 == null && s2 == null) {
            return -1;
        }
        if (s1 == null || s2 == null) {
            return 0;
        }
        int n1 = s1.length();
        int n2 = s2.length();
        int i = 0;
        if (len < 0) {
            len = n1 >= n2 ? n1 : n2;
        }
        for (i = 0; i < n1 && i < n2 && i < len; ++i) {
            if (s1.charAt(i) == s2.charAt(i)) continue;
            return i;
        }
        return i < len ? i : -1;
    }

    public static int diff(byte[] b1, byte[] b2) {
        return StringTools.diff(b1, b2, -1);
    }

    public static int diff(byte[] b1, byte[] b2, int len) {
        if (b1 == null && b2 == null) {
            return -1;
        }
        if (b1 == null || b2 == null) {
            return 0;
        }
        int n1 = b1.length;
        int n2 = b2.length;
        int i = 0;
        if (len < 0) {
            len = n1 >= n2 ? n1 : n2;
        }
        for (i = 0; i < n1 && i < n2 && i < len; ++i) {
            if (b1[i] == b2[i]) continue;
            return i;
        }
        return i < len ? i : -1;
    }

    private static DecimalFormat _getFormatter(String fmt) {
        DecimalFormat df;
        if (StringTools.isBlank(fmt)) {
            fmt = "0";
        }
        if (formatMap == null) {
            formatMap = new HashMap<String, DecimalFormat>();
        }
        if ((df = formatMap.get(fmt)) == null) {
            df = new DecimalFormat(fmt, new DecimalFormatSymbols(Locale.US));
            formatMap.put(fmt, df);
        }
        return df;
    }

    public static String format(double val, String fmt) {
        return StringTools.format(val, fmt, -1);
    }

    public static String format(double val, String fmt, int fieldSize) {
        String s = "";
        if (fmt == null) {
            s = String.valueOf(val);
        } else if (fmt.startsWith("%")) {
            try {
                s = String.format(fmt, val);
            }
            catch (Throwable th) {
                Print.logException("Format exception [" + fmt + "]", th);
                s = String.valueOf(val);
            }
        } else {
            s = StringTools._getFormatter(fmt).format(val);
        }
        if (fieldSize > s.length()) {
            s = StringTools.rightAlign(s, fieldSize);
        }
        return s;
    }

    public static String format(BigInteger val, String fmt) {
        return StringTools.format(val, fmt, -1);
    }

    public static String format(BigInteger val, String fmt, int fieldSize) {
        String s = null;
        if (val == null) {
            s = "";
        } else if (fmt == null) {
            s = String.valueOf(val);
        } else if (fmt.startsWith("x") || fmt.startsWith("X")) {
            int byteLen = StringTools.parseInt(fmt.substring(1), -1);
            String hex = StringTools.toHexString(val, byteLen * 8);
            if (fmt.startsWith("x")) {
                hex = hex.toLowerCase();
            }
            s = "0x" + hex;
        } else if (fmt.startsWith("hex") || fmt.startsWith("HEX")) {
            int byteLen = StringTools.parseInt(fmt.substring(3), -1);
            String hex = StringTools.toHexString(val, byteLen * 8);
            if (fmt.startsWith("h")) {
                hex = hex.toLowerCase();
            }
            s = "0x" + hex;
        } else if (fmt.startsWith("%")) {
            try {
                s = String.format(fmt, val);
            }
            catch (Throwable th) {
                Print.logException("Format exception [" + fmt + "]", th);
                s = String.valueOf(val);
            }
        } else {
            s = StringTools._getFormatter(fmt).format(val);
        }
        if (fieldSize > s.length()) {
            s = StringTools.rightAlign(s, fieldSize);
        }
        return s;
    }

    public static String format(long val, String fmt) {
        return StringTools.format(val, fmt, -1);
    }

    public static String format(long val, String fmt, int fieldSize) {
        String s = null;
        if (fmt == null) {
            s = String.valueOf(val);
        } else if (fmt.startsWith(FORMAT_TIME)) {
            if (val > 0L) {
                int p = fmt.indexOf(58);
                TimeZone tz = p > 0 ? DateTime.getTimeZone(fmt.substring(p + 1)) : DateTime.getDefaultTimeZone();
                s = new DateTime(val).format("yyyy/MM/dd HH:mm:ss zzz", tz);
            } else {
                s = "";
            }
        } else if (fmt.startsWith(FORMAT_DATE)) {
            s = val > 0L ? new DayNumber(val).format("yyyy/MM/dd") : "";
        } else if (fmt.startsWith(FORMAT_DATE2)) {
            s = val > 0L ? new DayNumber(val).format("yyyy-MM-dd") : "";
        } else if (fmt.startsWith("x") || fmt.startsWith("X")) {
            int byteLen = StringTools.parseInt(fmt.substring(1), -1);
            String hex = StringTools.toHexString(val, byteLen * 8);
            if (fmt.startsWith("x")) {
                hex = hex.toLowerCase();
            }
            s = "0x" + hex;
        } else if (fmt.startsWith("hex") || fmt.startsWith("HEX")) {
            int byteLen = StringTools.parseInt(fmt.substring(3), -1);
            String hex = StringTools.toHexString(val, byteLen * 8);
            if (fmt.startsWith("h")) {
                hex = hex.toLowerCase();
            }
            s = "0x" + hex;
        } else if (fmt.startsWith("%")) {
            try {
                s = String.format(fmt, val);
            }
            catch (Throwable th) {
                Print.logException("Format exception [" + fmt + "]", th);
                s = String.valueOf(val);
            }
        } else {
            s = StringTools._getFormatter(fmt).format(val);
        }
        if (fieldSize > s.length()) {
            s = StringTools.rightAlign(s, fieldSize);
        }
        return s;
    }

    public static String format(int val, String fmt) {
        return StringTools.format((long)val, fmt, -1);
    }

    public static String format(int val, String fmt, int fieldSize) {
        return StringTools.format((long)val, fmt, fieldSize);
    }

    public static String format(short val, String fmt) {
        return StringTools.format((long)val, fmt, -1);
    }

    public static String format(short val, String fmt, int fieldSize) {
        return StringTools.format((long)val, fmt, fieldSize);
    }

    public static String formatElapsedSeconds(long elapsedSec, int fmt) {
        StringBuffer sb = new StringBuffer();
        switch (fmt) {
            case 0: {
                int h = (int)(elapsedSec / 3600L);
                int m = (int)(elapsedSec / 60L % 60L);
                int s = (int)(elapsedSec % 60L);
                sb.append(StringTools.format(h, "0"));
                sb.append(ARG_DELIM);
                sb.append(StringTools.format(m, "00"));
                sb.append(ARG_DELIM);
                sb.append(StringTools.format(s, "00"));
                break;
            }
            case 1: {
                int h = (int)(elapsedSec / 3600L);
                int m = (int)(elapsedSec / 60L % 60L);
                int s = (int)(elapsedSec % 60L);
                if (s > 30 && ++m > 59) {
                    ++h;
                    m = 0;
                }
                sb.append(StringTools.format(h, "0"));
                sb.append(ARG_DELIM);
                sb.append(StringTools.format(m, "00"));
                break;
            }
            case 2: {
                double h = (double)elapsedSec / 3600.0;
                sb.append(StringTools.format(h, "0.00"));
                break;
            }
            case 3: {
                double h = (double)elapsedSec / 3600.0;
                sb.append(StringTools.format(h, "0.0"));
                break;
            }
            case 4: {
                int m = (int)(elapsedSec / 60L);
                int s = (int)(elapsedSec % 60L);
                sb.append(StringTools.format(m, "0"));
                sb.append(ARG_DELIM);
                sb.append(StringTools.format(s, "00"));
                break;
            }
            default: {
                sb.append(elapsedSec);
            }
        }
        return sb.toString();
    }

    public static String className(Object c) {
        if (c == null) {
            return "null";
        }
        if (c instanceof Class) {
            Class clzz = (Class)c;
            if (clzz.isArray()) {
                Class<?> elemClz = clzz.getComponentType();
                return elemClz.getName() + "[]";
            }
            return clzz.getName();
        }
        if (c.getClass().isArray()) {
            Class<?> clzz = c.getClass();
            Class<?> elemClz = clzz.getComponentType();
            return elemClz.getName() + "[]";
        }
        return c.getClass().getName();
    }

    public static Class classForName(String n) {
        if (StringTools.isBlank(n)) {
            return null;
        }
        if (n.indexOf(".") < 0) {
            n = "java.lang." + n;
        }
        try {
            return Class.forName(n);
        }
        catch (ClassNotFoundException cnfe) {}
        finally {
            return null;
        }
    }

    public static boolean isAssignableFrom(String targetClassName, Class testClass) {
        Class targetClass = StringTools.classForName(targetClassName);
        return StringTools.isAssignableFrom(targetClass, testClass);
    }

    public static boolean isAssignableFrom(Class<?> targetClass, Class<?> testClass) {
        if (targetClass == null) {
            return false;
        }
        if (testClass == null) {
            return false;
        }
        return targetClass.isAssignableFrom(testClass);
    }

    private static void printArray(String m, String[] s) {
        Print.logInfo(m, new Object[0]);
        for (int i = 0; i < s.length; ++i) {
            Print.logInfo(i + ") " + s[i], new Object[0]);
        }
    }

    public static String compressDigits(long num) {
        return StringTools.compressDigits(num, BASE_DIGITS);
    }

    public static String compressDigits(long num, String alpha) {
        int alphaLen = alpha.length();
        StringBuffer sb = new StringBuffer();
        for (long v = num; v > 0L; v /= (long)alphaLen) {
            sb.append(alpha.charAt((int)(v % (long)alphaLen)));
        }
        return sb.reverse().toString();
    }

    public static long decompressDigits(String str) {
        return StringTools.decompressDigits(str, BASE_DIGITS);
    }

    public static long decompressDigits(String str, String alpha) {
        int alphaLen = alpha.length();
        long accum = 0L;
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            accum = accum * (long)alphaLen + (long)alpha.indexOf(ch);
        }
        return accum;
    }

    public static String htmlFilterValue(Object text) {
        return StringTools.htmlFilter(text, HTMLFilterType.VALUE);
    }

    public static String htmlFilterText(Object text) {
        return StringTools.htmlFilter(text, HTMLFilterType.TEXT);
    }

    public static String htmlFilter(Object text, HTMLFilterType filterType) {
        String SINGLE_QUOTE;
        String DOUBLE_QUOTE;
        String NEWLINE;
        String s;
        String string = s = text != null ? text.toString() : "";
        if (s.length() == 0) {
            return "";
        }
        if (s.equals(" ")) {
            return HTML_SP;
        }
        switch (filterType != null ? filterType : HTMLFilterType.VALUE) {
            case TEXT: {
                NEWLINE = HTML_BR;
                DOUBLE_QUOTE = "\"";
                SINGLE_QUOTE = "&#39;";
                break;
            }
            default: {
                NEWLINE = "";
                DOUBLE_QUOTE = "\"";
                SINGLE_QUOTE = "&#39;";
            }
        }
        int sp = 0;
        char[] ch = new char[s.length()];
        s.getChars(0, s.length(), ch, 0);
        StringBuffer sb = new StringBuffer();
        block14: for (int i = 0; i < ch.length; ++i) {
            if (i == 0 && ch[i] == ' ') {
                sb.append(HTML_SP);
                continue;
            }
            if (i == ch.length - 1 && ch[i] == ' ') {
                sb.append(HTML_SP);
                continue;
            }
            sp = ch[i] == ' ' ? sp + 1 : 0;
            switch (ch[i]) {
                case '<': {
                    sb.append(HTML_LT);
                    continue block14;
                }
                case '>': {
                    sb.append(HTML_GT);
                    continue block14;
                }
                case '&': {
                    sb.append(HTML_AMP);
                    continue block14;
                }
                case '\u00b0': {
                    sb.append(HTML_DEG);
                    continue block14;
                }
                case '\"': {
                    sb.append(DOUBLE_QUOTE);
                    continue block14;
                }
                case '\'': {
                    sb.append(SINGLE_QUOTE);
                    continue block14;
                }
                case '\n': {
                    sb.append(NEWLINE);
                    continue block14;
                }
                case '\r': {
                    continue block14;
                }
                case ' ': {
                    sb.append((sp & 1) == 0 ? HTML_SP : " ");
                    continue block14;
                }
                default: {
                    sb.append(ch[i]);
                }
            }
        }
        return sb.toString();
    }

    public static String createRandomString(int len) {
        return StringTools.createRandomString(len, RANDOM_CHARS);
    }

    public static String createRandomString(int len, String alpha) {
        Random ran = new Random();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < len; ++i) {
            sb.append(alpha.charAt(ran.nextInt(alpha.length())));
        }
        return sb.toString();
    }

    public static void main(String[] argv) {
        String splitStr;
        String arryStr;
        String format;
        String frunicode;
        String tounicode;
        String tohex;
        RTConfig.setCommandLineArgs(argv);
        Print.sysPrintln("Current Character set: " + StringTools.getCharacterEncoding(), new Object[0]);
        String hex = RTConfig.getString(ARG_HEX, null);
        if (hex != null) {
            byte[] b = StringTools.parseHex(hex = StringTools.stripChars(hex, " \t\r\n"), null);
            if (b != null) {
                byte[] sb = new byte[b.length];
                for (int i = 0; i < b.length; ++i) {
                    sb[i] = b[i] < 32 || b[i] > 126 ? 46 : b[i];
                }
                Print.sysPrintln("String(ASCII): " + StringTools.toStringValue(sb), new Object[0]);
                try {
                    String utf8 = new String(b, CharEncoding_UTF_8);
                    StringBuffer utf8SB = new StringBuffer();
                    for (int i = 0; i < utf8.length(); ++i) {
                        if (utf8.charAt(i) >= ' ') {
                            utf8SB.append(utf8.charAt(i));
                            continue;
                        }
                        utf8SB.append(".");
                    }
                    Print.sysPrintln("String(UTF8) : " + utf8SB, new Object[0]);
                }
                catch (UnsupportedEncodingException uee) {
                    // empty catch block
                }
                if (b.length <= 8) {
                    Payload p = new Payload(b);
                    long v = p.readLong(b.length, 0L);
                    Print.sysPrintln("Long  : " + v, new Object[0]);
                }
            } else {
                Print.sysPrintln("ERROR: Invalid hex value", new Object[0]);
            }
            System.exit(0);
        }
        if ((tohex = RTConfig.getString(ARG_TO_HEX, null)) != null) {
            if (StringTools.isLong(tohex, true)) {
                long val = StringTools.parseLong(tohex, 0L);
                Print.sysPrintln("Long: (" + val + ") 0x" + StringTools.toHexString(val), new Object[0]);
            } else {
                byte[] b = StringTools.getBytes(tohex);
                Print.sysPrintln("Byte: 0x" + StringTools.toHexString(b), new Object[0]);
            }
            System.exit(0);
        }
        if (RTConfig.hasProperty(ARG_LONG)) {
            String longStr = RTConfig.getString(ARG_LONG, "").toUpperCase();
            String longHex = longStr.startsWith("0X") ? longStr.substring(2) : "";
            int longBits = longHex.length() * 4;
            long longBE64 = RTConfig.getLong(ARG_LONG, 0L);
            int bitLen = longBits > 0 ? longBits : (BigInteger.valueOf(longBE64).bitLength() + 7) / 8 * 8;
            Print.sysPrintln("Big-Endian:", new Object[0]);
            Print.sysPrintln("  Long (Dec 64-bit): " + longBE64, new Object[0]);
            Print.sysPrintln("  Long (Hex 64-bit): 0x" + StringTools.toHexString(longBE64, 64), new Object[0]);
            Print.sysPrintln("  Long (Hex " + bitLen + "-bit): 0x" + StringTools.toHexString(longBE64, bitLen), new Object[0]);
            long longLE64 = Payload.reverseByteOrder(longBE64, (bitLen + 7) / 8);
            Print.sysPrintln("Little-Endian:", new Object[0]);
            Print.sysPrintln("  Long (Dec 64-bit): " + longLE64, new Object[0]);
            Print.sysPrintln("  Long (Hex 64-bit): 0x" + StringTools.toHexString(longLE64, 64), new Object[0]);
            Print.sysPrintln("  Long (Hex " + bitLen + "-bit): 0x" + StringTools.toHexString(longLE64, bitLen), new Object[0]);
            System.exit(0);
        }
        if ((tounicode = RTConfig.getString(ARG_TO_UNICODE, null)) != null) {
            String uc = StringTools.escapeUnicode(tounicode);
            Print.sysPrintln("String : " + tounicode, new Object[0]);
            Print.sysPrintln("Unicode: " + uc, new Object[0]);
            System.exit(0);
        }
        if ((frunicode = RTConfig.getString(ARG_FROM_UNICODE, null)) != null) {
            String st = StringTools.unescapeUnicode(frunicode);
            Print.sysPrintln("Unicode: " + frunicode, new Object[0]);
            Print.sysPrintln("String : " + st, new Object[0]);
            System.exit(0);
        }
        if ((format = RTConfig.getString(ARG_FORMAT, null)) != null) {
            String[] fmt = StringTools.split(format, ',');
            if (ListTools.isEmpty(fmt)) {
                Print.sysPrintln("No Value,Format specified", new Object[0]);
            } else if (fmt[0].indexOf(".") >= 0) {
                String F;
                double V = StringTools.parseDouble(fmt[0], 0.0);
                String string = F = fmt.length > 1 ? fmt[1] : null;
                if (!StringTools.isBlank(F)) {
                    Print.sysPrintln("Formatted Value [" + fmt[0] + "]: \"" + F + "\" ==>" + StringTools.format(V, F) + "<", new Object[0]);
                } else {
                    Print.sysPrintln("Formatted Value [" + fmt[0] + "]: n/a", new Object[0]);
                }
            } else {
                String F;
                long V = StringTools.parseLong(fmt[0], 0L);
                String string = F = fmt.length > 1 ? fmt[1] : null;
                if (!StringTools.isBlank(F)) {
                    Print.sysPrintln("Formatted Value [" + fmt[0] + "]: \"" + F + "\" ==>" + StringTools.format(V, F) + "<", new Object[0]);
                } else {
                    Print.sysPrintln("Formatted Value [" + fmt[0] + "]: n/a", new Object[0]);
                }
            }
            System.exit(0);
        }
        if ((arryStr = RTConfig.getString(ARG_ARRAY, null)) != null) {
            String[] a = StringTools.parseArray(arryStr);
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < a.length; ++i) {
                if (sb.length() > 0) {
                    sb.append("|");
                }
                sb.append(">").append(a[i]).append("<");
            }
            Print.sysPrintln(sb.toString(), new Object[0]);
            System.exit(0);
        }
        if ((splitStr = RTConfig.getString(ARG_SPLIT, null)) != null) {
            String[] a = StringTools.split(splitStr, ',');
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < a.length; ++i) {
                if (sb.length() > 0) {
                    sb.append("|");
                }
                sb.append(">").append(a[i]).append("<");
            }
            Print.sysPrintln(sb.toString(), new Object[0]);
            System.exit(0);
        }
    }

    public static enum HTMLFilterType {
        VALUE,
        TEXT;

    }

    public static class RegexIndex {
        private Matcher matcher = null;
        private int startPos = -1;
        private int endPos = -1;

        public RegexIndex(Matcher match) {
            this.matcher = match;
        }

        public RegexIndex(int start, int end) {
            this.startPos = start;
            this.endPos = end;
        }

        public Matcher getMatcher() {
            return this.matcher;
        }

        public int getStart() {
            return this.matcher != null ? this.matcher.start() : this.startPos;
        }

        public int getEnd() {
            return this.matcher != null ? this.matcher.end() : this.endPos;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(this.getStart());
            sb.append("/");
            sb.append(this.getEnd());
            return sb.toString();
        }
    }

    public static interface ValueFilter {
        public String getFilteredValue(String var1);
    }

    public static abstract class KeyValueMap_SBIndex
    implements KeyValueMap {
        @Override
        public String getKeyValue(String key, String arg, String dft) {
            return this.getKeyValue(key, arg, dft, -1);
        }

        public abstract String getKeyValue(String var1, String var2, String var3, int var4);
    }

    public static interface KeyValueMap {
        public String getKeyValue(String var1, String var2, String var3);
    }

    public static class FilterNumber {
        private String inpStr = null;
        private Class<?> type = null;
        private boolean isHex = false;
        private boolean hasDecPoint = false;
        private String numStr = null;
        private int startPos = -1;
        private int endPos = -1;

        public FilterNumber(String val, Class<?> type) {
            String num;
            boolean foundDigit;
            int ps;
            int p;
            int s;
            if (val == null) {
                return;
            }
            for (s = 0; s < val.length() && Character.isWhitespace(val.charAt(s)); ++s) {
            }
            if (s == val.length()) {
                return;
            }
            String v = val;
            int vlen = v.length();
            boolean hex = false;
            if (s + 1 < vlen && v.charAt(s) == '0' && Character.toLowerCase(v.charAt(s + 1)) == 'x') {
                hex = true;
                s += 2;
            }
            if (!hex && s < vlen && v.charAt(s) == '+') {
                ++s;
            }
            int n = p = !hex && s < vlen && v.charAt(s) == '-' ? s + 1 : s;
            if (hex) {
                ps = p;
                while (p < vlen && StringTools.HEX.indexOf(Character.toUpperCase(v.charAt(p))) >= 0) {
                    ++p;
                }
            } else {
                ps = p;
                while (p < vlen && Character.isDigit(v.charAt(p))) {
                    ++p;
                }
            }
            boolean bl = foundDigit = p > ps;
            if (p >= vlen) {
                num = v.substring(s, p);
            } else if (type != null && (Long.class.isAssignableFrom(type) || Integer.class.isAssignableFrom(type) || Short.class.isAssignableFrom(type) || Byte.class.isAssignableFrom(type) || BigInteger.class.isAssignableFrom(type))) {
                num = v.substring(s, p);
            } else if (v.charAt(p) != '.') {
                num = v.substring(s, p);
            } else {
                this.hasDecPoint = true;
                ps = ++p;
                while (p < vlen && Character.isDigit(v.charAt(p))) {
                    ++p;
                }
                if (p > ps) {
                    foundDigit = true;
                }
                num = v.substring(s, p);
            }
            if (foundDigit) {
                this.isHex = hex;
                this.inpStr = val;
                this.type = type;
                this.numStr = num;
                this.startPos = s;
                this.endPos = p;
            }
        }

        public <T> boolean supportsType(Class<T> ct) {
            if (this.numStr != null && this.type != null && ct != null) {
                if (this.type.isAssignableFrom(ct)) {
                    return true;
                }
                if (Short.class.isAssignableFrom(ct)) {
                    return this.type.isAssignableFrom(Byte.class);
                }
                if (Integer.class.isAssignableFrom(ct)) {
                    return this.type.isAssignableFrom(Short.class) || this.type.isAssignableFrom(Byte.class);
                }
                if (Long.class.isAssignableFrom(ct)) {
                    return this.type.isAssignableFrom(Integer.class) || this.type.isAssignableFrom(Short.class) || this.type.isAssignableFrom(Byte.class);
                }
                if (BigInteger.class.isAssignableFrom(ct)) {
                    return this.type.isAssignableFrom(Long.class) || this.type.isAssignableFrom(Integer.class) || this.type.isAssignableFrom(Short.class) || this.type.isAssignableFrom(Byte.class);
                }
                if (Float.class.isAssignableFrom(ct)) {
                    return this.type.isAssignableFrom(BigInteger.class) || this.type.isAssignableFrom(Long.class) || this.type.isAssignableFrom(Integer.class) || this.type.isAssignableFrom(Short.class) || this.type.isAssignableFrom(Byte.class);
                }
                if (Double.class.isAssignableFrom(ct)) {
                    return this.type.isAssignableFrom(Float.class) || this.type.isAssignableFrom(BigInteger.class) || this.type.isAssignableFrom(Long.class) || this.type.isAssignableFrom(Integer.class) || this.type.isAssignableFrom(Short.class) || this.type.isAssignableFrom(Byte.class);
                }
            }
            return false;
        }

        public String getInputString() {
            return this.inpStr;
        }

        public Class getClassType() {
            return this.type;
        }

        public String getClassTypeName() {
            if (this.type != null) {
                String cn = this.type.getName();
                if (cn.startsWith("java.lang.")) {
                    return cn.substring("java.lang.".length());
                }
                if (cn.startsWith("java.math.")) {
                    return cn.substring("java.math.".length());
                }
                return cn;
            }
            return "null";
        }

        public boolean isHex() {
            return this.isHex;
        }

        public String getValueString() {
            return this.numStr;
        }

        public boolean hasDecimalPoint() {
            return this.hasDecPoint;
        }

        public boolean isValid(boolean strict) {
            if (this.getValueString() == null) {
                return false;
            }
            if (!strict) {
                return true;
            }
            return this.getInputString().length() == this.getEnd();
        }

        public byte[] getHexBytes() {
            if (this.isHex) {
                return StringTools.parseHex(this.getValueString(), new byte[0]);
            }
            return new BigInteger(this.getValueString()).toByteArray();
        }

        public int getStart() {
            return this.startPos;
        }

        public int getEnd() {
            return this.endPos;
        }

        public int getLength() {
            return this.endPos - this.startPos;
        }

        public Number toNumber(Number dft) {
            if (this.numStr != null && this.type != null) {
                try {
                    if (Byte.class.equals(this.type)) {
                        return new Byte(this.numStr);
                    }
                    if (Short.class.equals(this.type)) {
                        return new Short(this.numStr);
                    }
                    if (Integer.class.equals(this.type)) {
                        return new Integer(this.numStr);
                    }
                    if (Long.class.equals(this.type)) {
                        return new Long(this.numStr);
                    }
                    if (BigInteger.class.equals(this.type)) {
                        return new BigInteger(this.numStr);
                    }
                    if (Float.class.equals(this.type)) {
                        return new Float(this.numStr);
                    }
                    if (Double.class.equals(this.type)) {
                        return new Double(this.numStr);
                    }
                    Print.logError("Unkrecognized Number type: " + StringTools.className(this.type), new Object[0]);
                    return dft;
                }
                catch (NumberFormatException nfe) {
                    Print.logException("Number conversion error", nfe);
                    return dft;
                }
            }
            return dft;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(StringTools.quoteString(this.getInputString()));
            sb.append("/");
            sb.append(this.getClassTypeName());
            sb.append("/");
            sb.append(this.getStart());
            sb.append("/");
            sb.append(this.getEnd());
            return sb.toString();
        }
    }
}

