/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.util;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.opengts.util.FileTools;
import org.opengts.util.HTMLTools;
import org.opengts.util.ListTools;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;
import org.opengts.util.StringTools;
import org.opengts.util.XMLTools;
import org.w3c.dom.Document;

public class ServiceRequest {
    protected static final String SRTAG_Request = "GTSRequest";
    protected static final String SRTAG_Response = "GTSResponse";
    protected static final String SRTAG_Message = "Message";
    protected static final String SRTAG_Authorization = "Authorization";
    protected static final String SRATTR_command = "command";
    protected static final String SRATTR_result = "result";
    protected static final String SRATTR_code = "code";
    protected static final String SRATTR_account = "account";
    protected static final String SRATTR_user = "user";
    protected static final String SRATTR_password = "password";
    protected static final String METHOD_handleRequest = "handleRequest";
    private JMXServiceURL jmxURL = null;
    private String jmxObjectName = "";
    private URL serviceURL = null;
    private Authorization auth = null;
    private String command = null;
    private RequestBody requestBody = null;

    public ServiceRequest() {
    }

    public ServiceRequest(ServiceRequest other) {
        if (other != null) {
            this.jmxURL = other.jmxURL;
            this.jmxObjectName = other.jmxObjectName;
            this.serviceURL = other.serviceURL;
            this.command = other.command;
            this.requestBody = other.requestBody;
            if (other.auth != null) {
                this.setAuthorization(new Authorization(other.auth));
            }
        }
    }

    public ServiceRequest(String url) throws MalformedURLException {
        this.setURL(url);
    }

    public ServiceRequest(URL serviceURL) {
        this.setURL(serviceURL);
    }

    public ServiceRequest(JMXServiceURL jmxURL, String jmxObjName) {
        this.setURL(jmxURL, jmxObjName);
    }

    public ServiceRequest setURL(String url) throws MalformedURLException {
        this.jmxURL = null;
        this.serviceURL = null;
        if (StringTools.startsWithIgnoreCase(url, "http")) {
            this.serviceURL = new URL(url);
        } else if (StringTools.startsWithIgnoreCase(url, "service:jmx:")) {
            this.jmxURL = new JMXServiceURL(url);
        } else {
            throw new MalformedURLException("Invalid URL: " + url);
        }
        return this;
    }

    public ServiceRequest setURL(URL url) {
        this.jmxURL = null;
        this.serviceURL = url;
        return this;
    }

    public URL getURL() {
        return this.serviceURL;
    }

    public ServiceRequest setURL(JMXServiceURL url, String jmxObjName) {
        this.jmxURL = url;
        this.setJMXObjectName(jmxObjName);
        this.serviceURL = null;
        return this;
    }

    public JMXServiceURL getJMXServiceURL() {
        return this.jmxURL;
    }

    public boolean isJMX() {
        return this.jmxURL != null;
    }

    public void setJMXObjectName(String objName) {
        this.jmxObjectName = objName != null ? objName : "";
    }

    public String getJMXObjectName() {
        return this.jmxObjectName;
    }

    public ServiceRequest setAuthorization(String acctID, String userID, String passwd) {
        this.setAuthorization(new Authorization(acctID, userID, passwd));
        return this;
    }

    public ServiceRequest setAuthorization(Authorization auth) {
        this.auth = auth;
        if (this.auth != null) {
            this.auth.setServiceRequest(this);
        }
        return this;
    }

    public ServiceRequest setCommand(String cmd) {
        this.command = StringTools.trim(cmd);
        return this;
    }

    public String getCommand() {
        return this.command != null ? this.command : "";
    }

    public ServiceRequest setRequestBody(RequestBody rb) {
        this.requestBody = rb;
        return this;
    }

    public StringBuffer appendRequestBody(StringBuffer sb, int indent) {
        if (this.requestBody != null) {
            this.requestBody.appendRequestBody(sb, indent);
        }
        return sb;
    }

    public String toXML(String command, RequestBody rb) {
        StringBuffer sb = new StringBuffer();
        int indent = 3;
        sb.append("<?xml version='1.0' encoding='UTF-8' standalone='no' ?>\n");
        sb.append("<" + this.getTagRequest());
        String cmd = StringTools.blankDefault(command, this.getCommand());
        if (!StringTools.isBlank(cmd)) {
            sb.append(" " + this.getAttrCommand() + "=\"" + cmd + "\"");
        }
        sb.append(">\n");
        if (this.auth != null) {
            this.auth.toXML(sb, indent);
        }
        if (rb != null) {
            rb.appendRequestBody(sb, indent);
        } else {
            this.appendRequestBody(sb, indent);
        }
        sb.append("</" + this.getTagRequest() + ">\n");
        return sb.toString();
    }

    public String toString() {
        return this.toXML(this.getCommand(), null);
    }

    public Document sendRequest(String command, RequestBody rb) throws IOException {
        int timeoutMS = -1;
        try {
            return this._sendRequest(this.toXML(command, rb), timeoutMS);
        }
        catch (HTMLTools.HttpIOException hioe) {
            int respCode = hioe.getResponseCode();
            String respMsg = hioe.getResponseMessage();
            Print.logError("HTTP Error: [" + respCode + "] " + respMsg, new Object[0]);
            throw hioe;
        }
    }

    public Document sendRequest(File reqFile) throws IOException {
        int timeoutMS = -1;
        byte[] rq = FileTools.readFile(reqFile);
        if (!ListTools.isEmpty(rq)) {
            String rqStr = StringTools.toStringValue(rq).trim();
            if (rqStr.startsWith("<")) {
                try {
                    return this._sendRequest(rqStr, timeoutMS);
                }
                catch (HTMLTools.HttpIOException hioe) {
                    int respCode = hioe.getResponseCode();
                    String respMsg = hioe.getResponseMessage();
                    Print.logError("HTTP Error: [" + respCode + "] " + respMsg, new Object[0]);
                    throw hioe;
                }
            }
            Print.logError("Invalid Request XML: \n" + rqStr, new Object[0]);
            return null;
        }
        Print.logError("File not found (or is empty): " + reqFile, new Object[0]);
        return null;
    }

    protected Document _sendRequest(String reqXMLStr, int timeoutMS) throws IOException {
        Document xmlDoc;
        byte[] xmlResp;
        if (RTConfig.isDebugMode()) {
            if (this.isJMX()) {
                Print.logInfo("JMX url: " + this.getJMXServiceURL(), new Object[0]);
                Print.logInfo("   name: " + this.getJMXObjectName(), new Object[0]);
            } else {
                Print.logInfo("HTTP url: " + this.getURL(), new Object[0]);
            }
            Print.logInfo("Request:\n" + reqXMLStr, new Object[0]);
        }
        byte[] byArray = xmlResp = this.isJMX() ? this._sendRequest_JMX(reqXMLStr) : this._sendRequest_HTTP(reqXMLStr, timeoutMS);
        if (RTConfig.isDebugMode()) {
            Print.logInfo("Response:\n" + StringTools.toStringValue(xmlResp).trim(), new Object[0]);
        }
        if ((xmlDoc = XMLTools.getDocument(xmlResp)) == null) {
            Print.logError("Response:\n" + StringTools.toStringValue(xmlResp).trim(), new Object[0]);
            throw new IOException("Response XML Document error");
        }
        return xmlDoc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] _sendRequest_JMX(String reqXMLStr) throws IOException {
        JMXConnector jmxc = JMXConnectorFactory.connect(this.getJMXServiceURL(), null);
        byte[] xmlResp = null;
        try {
            MBeanServerConnection mbsc = jmxc.getMBeanServerConnection();
            String objName = this.getJMXObjectName();
            ObjectName name = null;
            try {
                name = new ObjectName(objName);
            }
            catch (MalformedObjectNameException mone) {
                throw new IOException("Invalid ObjectName: " + objName);
            }
            try {
                String xml = (String)mbsc.invoke(name, METHOD_handleRequest, new Object[]{reqXMLStr}, new String[]{"java.lang.String"});
                xmlResp = xml.getBytes();
            }
            catch (Throwable th) {
                throw new IOException("MBean Invocation: " + th.getMessage());
            }
        }
        finally {
            try {
                jmxc.close();
            }
            catch (Throwable th) {}
        }
        return xmlResp;
    }

    protected byte[] _sendRequest_HTTP(String reqXMLStr, int timeoutMS) throws IOException {
        byte[] xmlReq = reqXMLStr.toString().getBytes();
        return HTMLTools.readPage_POST(this.getURL(), HTMLTools.MIME_XML(), xmlReq, timeoutMS);
    }

    public String getTagResponse() {
        return SRTAG_Response;
    }

    public String getTagRequest() {
        return SRTAG_Request;
    }

    public String getTagAuthorization() {
        return SRTAG_Authorization;
    }

    public String getAttrCommand() {
        return SRATTR_command;
    }

    public String getAttrResult() {
        return SRATTR_result;
    }

    public String getAttrAccount() {
        return SRATTR_account;
    }

    public String getAttrUser() {
        return SRATTR_user;
    }

    public String getAttrPassword() {
        return SRATTR_password;
    }

    public static class Authorization {
        private ServiceRequest servReq = null;
        private String accountID = null;
        private String userID = null;
        private String password = null;

        public Authorization() {
        }

        public Authorization(Authorization other) {
            if (other != null) {
                this.accountID = other.accountID;
                this.userID = other.userID;
                this.password = other.password;
            }
        }

        public Authorization(String aid, String uid, String pwd) {
            this.servReq = null;
            this.accountID = StringTools.trim(aid);
            this.userID = StringTools.trim(uid);
            this.password = pwd;
        }

        public void setServiceRequest(ServiceRequest servReq) {
            this.servReq = servReq;
        }

        public StringBuffer toXML(StringBuffer sb, int indent) {
            if (sb == null) {
                sb = new StringBuffer();
            }
            sb.append(StringTools.replicateString(" ", indent));
            sb.append("<" + this.getTagAuthorization());
            if (!StringTools.isBlank(this.accountID)) {
                sb.append(" " + this.getAttrAccount() + "=\"" + this.accountID + "\"");
            }
            if (!StringTools.isBlank(this.userID)) {
                sb.append(" " + this.getAttrUser() + "=\"" + this.userID + "\"");
            }
            if (!StringTools.isBlank(this.password)) {
                sb.append(" " + this.getAttrPassword() + "=\"" + this.password + "\"");
            }
            sb.append("/>\n");
            return sb;
        }

        public String toString() {
            return this.toXML(null, 3).toString();
        }

        public String getTagAuthorization() {
            return this.servReq != null ? this.servReq.getTagAuthorization() : ServiceRequest.SRTAG_Authorization;
        }

        public String getAttrAccount() {
            return this.servReq != null ? this.servReq.getAttrAccount() : ServiceRequest.SRATTR_account;
        }

        public String getAttrUser() {
            return this.servReq != null ? this.servReq.getAttrUser() : ServiceRequest.SRATTR_user;
        }

        public String getAttrPassword() {
            return this.servReq != null ? this.servReq.getAttrPassword() : ServiceRequest.SRATTR_password;
        }
    }

    public static interface RequestBody {
        public StringBuffer appendRequestBody(StringBuffer var1, int var2);
    }
}

