/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.util;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.ClosedByInterruptException;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.net.ServerSocketFactory;
import javax.net.ssl.SSLServerSocketFactory;
import org.opengts.util.AccumulatorInteger;
import org.opengts.util.ClientPacketHandler;
import org.opengts.util.DateTime;
import org.opengts.util.ListTools;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;
import org.opengts.util.StringTools;

public class ServerSocketThread
extends Thread {
    public static final int PACKET_LEN_INCREMENTAL_ = 0x1000000;
    public static final int PACKET_LEN_INCREMENTAL_MASK = 0xFFFFFF;
    public static final int PACKET_LEN_LINE_TERMINATOR = -1;
    public static final int PACKET_LEN_END_OF_STREAM = -2;
    public static final int PACKET_LEN_INCREMENT_EOL = 0x1FFFFFF;
    public static final boolean ACK_FROM_LISTEN_PORT = true;
    public static int MinimumTimeoutIntervalMS = 0;
    private static int ListenBacklog = 50;
    private static InetAddress LocalBindAddress = null;
    private static Vector<ServerSocketThread> SSTList = new Vector();
    private int listenPort = 0;
    private int clientPort = -1;
    private InetAddress bindAddress = null;
    private DatagramSocket datagramSocket = null;
    private ServerSocket serverSocket = null;
    private List<ServerSessionThread> clientThreadPool = null;
    private List<ClientPacketHandler> activeSessionList = null;
    private ClientPacketHandler clientPacketHandler = null;
    private Class clientPacketHandlerClass = null;
    private long sessionTimeoutMS = -1L;
    private long idleTimeoutMS = -1L;
    private long packetTimeoutMS = -1L;
    private int lingerTimeoutSec = 4;
    private int maxReadLength = -1;
    private int minReadLength = -1;
    private boolean terminateOnTimeout = true;
    private boolean isTextPackets = true;
    private int[] lineTerminatorChar = new int[]{10};
    private int[] backspaceChar = new int[]{8};
    private int[] ignoreChar = new int[]{13};
    private boolean includePacketLineTerm = false;
    private byte[] packetTermPattern = null;
    private boolean promptEnabled = true;
    private byte[] prompt = null;
    private int promptIndex = -1;
    private boolean autoPrompt = false;
    private List<ActionListener> actionListeners = null;
    private boolean LogEnable = true;
    private static long ServeSocketThread_counter = 0L;
    private static long ServerSessionThread_counter = 0L;

    public static void setMinimuTimeoutIntervalMS(int minTMS) {
        MinimumTimeoutIntervalMS = minTMS > 5000 ? minTMS : 5000;
    }

    public static void setListenBacklog(int backlog) {
        ListenBacklog = backlog;
    }

    public static void setBindAddress(InetAddress bindAddr) {
        if (bindAddr != null && !ServerSocketThread.isLocalInterfaceAddress(bindAddr)) {
            Print.logWarn("BindAddress not found in NetworkInterface: " + bindAddr, new Object[0]);
        }
        LocalBindAddress = bindAddr;
    }

    public static boolean hasBindAddress() {
        return LocalBindAddress != null;
    }

    public static InetAddress getDefaultBindAddress() {
        return LocalBindAddress;
    }

    public static InetAddress[] getNetworkInterfaceAddresses() throws SocketException {
        Vector<InetAddress> ialist = new Vector<InetAddress>();
        Enumeration<NetworkInterface> ne = NetworkInterface.getNetworkInterfaces();
        while (ne.hasMoreElements()) {
            NetworkInterface ni = ne.nextElement();
            if (ni.isLoopback()) continue;
            Enumeration<InetAddress> ie = ni.getInetAddresses();
            while (ie.hasMoreElements()) {
                InetAddress ia = ie.nextElement();
                ialist.add(ia);
            }
        }
        return ialist.toArray(new InetAddress[ialist.size()]);
    }

    public static boolean isLocalInterfaceAddress(InetAddress addr) {
        if (addr == null) {
            return false;
        }
        if (addr.isLoopbackAddress()) {
            return true;
        }
        try {
            Set<InetAddress> ias = ListTools.toSet(ServerSocketThread.getNetworkInterfaceAddresses());
            return ias.contains(addr);
        }
        catch (Throwable th) {
            Print.logException("Getting NetworkInterface addresses", th);
            return false;
        }
    }

    public static DatagramSocket createDatagramSocket(InetAddress bindAddr, int port) throws SocketException {
        InetAddress bind;
        InetAddress inetAddress = bind = bindAddr != null ? bindAddr : ServerSocketThread.getDefaultBindAddress();
        if (bind != null) {
            return new DatagramSocket(new InetSocketAddress(bind, port));
        }
        return new DatagramSocket(port);
    }

    public static DatagramSocket createDatagramSocket(int port) throws SocketException {
        return ServerSocketThread.createDatagramSocket(null, port);
    }

    public static ServerSocket createServerSocket(InetAddress bindAddr, int port) throws IOException {
        InetAddress bind = bindAddr != null ? bindAddr : ServerSocketThread.getDefaultBindAddress();
        try {
            return new ServerSocket(port, ListenBacklog, bind);
        }
        catch (IllegalArgumentException iae) {
            throw new IOException(iae);
        }
        catch (Throwable th) {
            throw new IOException(th);
        }
    }

    public static boolean isValidPort(int port) {
        return port > 0 && port <= 65535;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void _AddSST(ServerSocketThread sst) {
        Vector<ServerSocketThread> vector = SSTList;
        synchronized (vector) {
            SSTList.add(sst);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void _RemoveSST(ServerSocketThread sst) {
        Vector<ServerSocketThread> vector = SSTList;
        synchronized (vector) {
            SSTList.remove(sst);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean shutdownAll(long tmoMS) {
        final long timeoutMS = tmoMS >= 1000L ? tmoMS : 1000L;
        int count = 0;
        ServerSocketThread firstSST = null;
        Vector<ServerSocketThread> vector = SSTList;
        synchronized (vector) {
            count = SSTList.size();
            if (count > 0) {
                firstSST = SSTList.get(0);
            }
        }
        if (count == 0) {
            return true;
        }
        if (count == 1 && firstSST != null) {
            boolean ok = firstSST.shutdown(timeoutMS);
            return ok;
        }
        final AccumulatorInteger forcedCount = new AccumulatorInteger(0);
        Vector<ServerSocketThread> vector2 = SSTList;
        synchronized (vector2) {
            for (final ServerSocketThread sst : SSTList) {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        boolean ok = sst.shutdown(timeoutMS);
                        if (!ok) {
                            forcedCount.increment();
                        }
                    }
                }).start();
            }
        }
        long waitMS = timeoutMS + 1000L;
        long startMS = DateTime.getCurrentTimeMillis();
        boolean didTimeout = false;
        int remainingThreads = 0;
        do {
            Vector<ServerSocketThread> vector3 = SSTList;
            synchronized (vector3) {
                remainingThreads = SSTList.size();
            }
            if (remainingThreads <= 0) break;
            long nowMS = DateTime.getCurrentTimeMillis();
            long deltaMS = nowMS - startMS;
            if (deltaMS >= waitMS) {
                didTimeout = true;
                break;
            }
            try {
                Thread.sleep(500L);
            }
            catch (Throwable th) {
                // empty catch block
            }
        } while (remainingThreads > 0);
        return !didTimeout && forcedCount.get() <= 0;
    }

    private ServerSocketThread() {
        super("Server_" + ServeSocketThread_counter++);
        this.bindAddress = ServerSocketThread.getDefaultBindAddress();
        this.clientThreadPool = new Vector<ServerSessionThread>();
        this.activeSessionList = new Vector<ClientPacketHandler>();
        this.actionListeners = new Vector<ActionListener>();
        ServerSocketThread._AddSST(this);
    }

    public ServerSocketThread(DatagramSocket ds) {
        this();
        this.datagramSocket = ds;
        this.bindAddress = ds != null ? ds.getLocalAddress() : ServerSocketThread.getDefaultBindAddress();
        this.listenPort = ds != null ? ds.getLocalPort() : -1;
    }

    public ServerSocketThread(ServerSocket ss) {
        this();
        this.serverSocket = ss;
        this.bindAddress = ss != null ? ss.getInetAddress() : ServerSocketThread.getDefaultBindAddress();
        this.listenPort = ss != null ? ss.getLocalPort() : -1;
    }

    public ServerSocketThread(InetAddress bindAddr, int port) throws IOException {
        this();
        this.bindAddress = bindAddr != null ? bindAddr : ServerSocketThread.getDefaultBindAddress();
        this.serverSocket = ServerSocketThread.createServerSocket(this.bindAddress, port);
        this.listenPort = port;
    }

    public ServerSocketThread(int port) throws IOException {
        this((InetAddress)null, port);
    }

    public ServerSocketThread(InetAddress bindAddr, int port, boolean useSSL) throws IOException {
        this();
        this.bindAddress = bindAddr != null ? bindAddr : ServerSocketThread.getDefaultBindAddress();
        this.serverSocket = useSSL ? SSLServerSocketFactory.getDefault().createServerSocket(port, ListenBacklog, this.bindAddress) : ServerSocketFactory.getDefault().createServerSocket(port, ListenBacklog, this.bindAddress);
        this.listenPort = port;
    }

    public ServerSocketThread(int port, boolean useSSL) throws IOException {
        this((InetAddress)null, port, useSSL);
    }

    @Override
    public void start() {
        super.start();
    }

    public void start(String name) {
        if (!StringTools.isBlank(name)) {
            this.setName(name);
        }
        super.start();
    }

    public void setLoggingEnabled(boolean enable) {
        this.LogEnable = enable;
    }

    public boolean getLoggingEnabled() {
        return this.LogEnable;
    }

    public DatagramSocket getDatagramSocket() {
        return this.datagramSocket;
    }

    public ServerSocket getServerSocket() {
        return this.serverSocket;
    }

    public int getLocalPort() {
        return this.listenPort;
    }

    public InetAddress getBindAddress() {
        return this.bindAddress;
    }

    public void testSession(byte[] data) {
        ByteArrayInputStream bais = data != null ? new ByteArrayInputStream(data) : null;
        this.testSession(bais);
    }

    public void testSession(InputStream dataInput) {
        if (dataInput == null) {
            Print.logError("InputStream is null", new Object[0]);
            return;
        }
        this.runInputStreamSession(dataInput, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean runInputStreamSession(InputStream dataInput, boolean waitUntilDone) {
        boolean threadRunning = this.isAlive();
        ClientSocket clientSocket = new ClientSocket(dataInput);
        this._dispatchServerSessionThread(clientSocket);
        if (waitUntilDone) {
            boolean isRunning = true;
            while (isRunning) {
                try {
                    Thread.sleep(200L);
                }
                catch (Throwable th) {
                    // empty catch block
                }
                isRunning = false;
                List<ServerSessionThread> list = this.clientThreadPool;
                synchronized (list) {
                    for (ServerSessionThread sst : this.clientThreadPool) {
                        if (sst.isAvailable()) continue;
                        isRunning = true;
                        break;
                    }
                }
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            ClientSocket clientSocket;
            block16: {
                clientSocket = null;
                try {
                    if (this.serverSocket != null) {
                        clientSocket = new ClientSocket(this.serverSocket.accept());
                        break block16;
                    }
                    if (this.datagramSocket != null) {
                        byte[] b = new byte[this.getMaximumPacketLength()];
                        DatagramPacket dp = new DatagramPacket(b, b.length);
                        this.datagramSocket.receive(dp);
                        clientSocket = new ClientSocket(dp);
                        if (this.LogEnable) {
                            Print.logInfo("DatagramPacket.getAddress()=" + dp.getAddress() + ", getSocketAddress()=" + dp.getSocketAddress(), new Object[0]);
                        }
                        break block16;
                    }
                    Print.logStackTrace("ServerSocketThread has not been properly initialized");
                    break;
                }
                catch (SocketException se) {
                    String portStr;
                    if (this.serverSocket != null) {
                        int port = this.serverSocket.getLocalPort();
                        if (port <= 0) {
                            port = this.getLocalPort();
                        }
                        String string = portStr = port <= 0 ? "?" : String.valueOf(port);
                        if (!this.LogEnable) break;
                        Print.logInfo("Shutdown TCP server on port " + portStr, new Object[0]);
                        break;
                    }
                    if (this.datagramSocket != null) {
                        int port = this.datagramSocket.getLocalPort();
                        if (port <= 0) {
                            port = this.getLocalPort();
                        }
                        String string = portStr = port <= 0 ? "?" : String.valueOf(port);
                        if (!this.LogEnable) break;
                        Print.logInfo("Shutdown UDP server on port " + portStr, new Object[0]);
                        break;
                    }
                    if (!this.LogEnable) break;
                    Print.logInfo("Shutdown must have been called", new Object[0]);
                    break;
                }
                catch (IOException ioe) {
                    Print.logError("Connection - " + ioe, new Object[0]);
                    continue;
                }
            }
            ServerSessionThread dispatchedSST = null;
            List<ServerSessionThread> list = this.clientThreadPool;
            synchronized (list) {
                for (ServerSessionThread sst : this.clientThreadPool) {
                    boolean foundThread = sst.setClientIfAvailable(clientSocket);
                    if (!foundThread) continue;
                    dispatchedSST = sst;
                    break;
                }
                if (dispatchedSST == null) {
                    dispatchedSST = new ServerSessionThread(clientSocket, true);
                    this.clientThreadPool.add(dispatchedSST);
                }
            }
        }
        ServerSocketThread._RemoveSST(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shutdown(long tmoMS) {
        long timeoutMS = tmoMS >= 1000L ? tmoMS : 1000L;
        try {
            List<ServerSessionThread> list = this.clientThreadPool;
            synchronized (list) {
                for (ServerSessionThread sst : this.clientThreadPool) {
                    if (sst == null) continue;
                    sst.signalShutdown();
                }
            }
            long startMS = DateTime.getCurrentTimeMillis();
            boolean didTimeout = false;
            int remainingThreads = 0;
            do {
                List<ServerSessionThread> list2 = this.clientThreadPool;
                synchronized (list2) {
                    remainingThreads = this.clientThreadPool.size();
                }
                if (remainingThreads <= 0) break;
                long nowMS = DateTime.getCurrentTimeMillis();
                long deltaMS = nowMS - startMS;
                if (deltaMS >= timeoutMS) {
                    didTimeout = true;
                    break;
                }
                try {
                    Thread.sleep(500L);
                }
                catch (Throwable th) {
                    // empty catch block
                }
            } while (remainingThreads > 0);
            if (this.serverSocket != null) {
                this.serverSocket.close();
            }
            if (this.datagramSocket != null) {
                this.datagramSocket.close();
            }
            return !didTimeout;
        }
        catch (Throwable th) {
            Print.logException("Error shutting down ServerSocketThreads", th);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean _dispatchServerSessionThread(ClientSocket clientSocket) {
        boolean foundThread = false;
        Thread dispatchedSST = null;
        List<ServerSessionThread> list = this.clientThreadPool;
        synchronized (list) {
            for (ServerSessionThread sst : this.clientThreadPool) {
                foundThread = sst.setClientIfAvailable(clientSocket);
                if (!foundThread) continue;
                dispatchedSST = sst;
                break;
            }
            if (dispatchedSST == null) {
                boolean startThread = this.isAlive();
                dispatchedSST = new ServerSessionThread(clientSocket, startThread);
                this.clientThreadPool.add((ServerSessionThread)dispatchedSST);
            }
        }
        if (dispatchedSST != null && !dispatchedSST.isAlive()) {
            if (this.LogEnable) {
                Print.logInfo("Running ClientSocket in-line ...", new Object[0]);
            }
            try {
                ((ServerSessionThread)dispatchedSST).handleClientSession(clientSocket);
                ((ServerSessionThread)dispatchedSST).close();
            }
            catch (Throwable th) {
                Print.logException("Dispatched ServerSessionThread", th);
            }
            return true;
        }
        return false;
    }

    public void setRemotePort(int remotePort) {
        this.clientPort = remotePort;
    }

    public int getRemotePort() {
        return this.clientPort;
    }

    public boolean hasListeners() {
        return this.actionListeners.size() > 0;
    }

    public void addActionListener(ActionListener al) {
        if (!this.actionListeners.contains(al)) {
            this.actionListeners.add(al);
        }
    }

    public void removeActionListener(ActionListener al) {
        this.actionListeners.remove(al);
    }

    protected boolean invokeListeners(byte[] msgBytes) throws Exception {
        if (msgBytes != null) {
            String msg = StringTools.toStringValue(msgBytes);
            for (ActionListener alObj : this.actionListeners) {
                if (!(alObj instanceof ActionListener)) continue;
                ActionListener al = alObj;
                ActionEvent ae = new ActionEvent(this, 1001, msg);
                al.actionPerformed(ae);
            }
            return true;
        }
        return false;
    }

    public void setClientPacketHandler(ClientPacketHandler cph) {
        this.clientPacketHandler = cph;
    }

    public void setClientPacketHandlerClass(Class<? extends ClientPacketHandler> cphc) {
        if (cphc != null && !ClientPacketHandler.class.isAssignableFrom(cphc)) {
            throw new ClassCastException("Invalid ClientPacketHandler class");
        }
        this.clientPacketHandlerClass = cphc;
        this.clientPacketHandler = null;
    }

    public ClientPacketHandler getClientPacketHandler() {
        if (this.clientPacketHandler != null) {
            return this.clientPacketHandler;
        }
        if (this.clientPacketHandlerClass != null) {
            try {
                return (ClientPacketHandler)this.clientPacketHandlerClass.newInstance();
            }
            catch (Throwable t) {
                Print.logException("ClientPacketHandler", t);
                return null;
            }
        }
        return null;
    }

    public void setSessionTimeout(long timeoutMS) {
        this.sessionTimeoutMS = timeoutMS;
    }

    public long getSessionTimeout() {
        return this.sessionTimeoutMS;
    }

    public boolean hasSessionTimeout() {
        return this.sessionTimeoutMS > 0L;
    }

    public void setIdleTimeout(long timeoutMS) {
        this.idleTimeoutMS = timeoutMS;
    }

    public long getIdleTimeout() {
        return this.idleTimeoutMS;
    }

    public void setPacketTimeout(long timeoutMS) {
        this.packetTimeoutMS = timeoutMS;
    }

    public long getPacketTimeout() {
        return this.packetTimeoutMS;
    }

    public void setTerminateOnTimeout(boolean timeoutQuit) {
        this.terminateOnTimeout = timeoutQuit;
    }

    public boolean getTerminateOnTimeout() {
        return this.terminateOnTimeout;
    }

    public void setLingerTimeoutSec(int timeoutSec) {
        this.lingerTimeoutSec = timeoutSec;
    }

    public int getLingerTimeoutSec() {
        return this.lingerTimeoutSec;
    }

    public void setTextPackets(boolean isText) {
        this.isTextPackets = isText;
        if (!this.isTextPackets()) {
            this.setBackspaceChar(null);
            this.setIgnoreChar(null);
        }
    }

    public boolean isTextPackets() {
        return this.isTextPackets;
    }

    public void setMaximumPacketLength(int len) {
        this.maxReadLength = len;
    }

    public int getMaximumPacketLength() {
        if (this.maxReadLength > 0) {
            return this.maxReadLength;
        }
        if (this.isTextPackets()) {
            return 2048;
        }
        return 1024;
    }

    public void setMinimumPacketLength(int len) {
        this.minReadLength = len;
    }

    public int getMinimumPacketLength() {
        if (this.minReadLength > 0) {
            return this.minReadLength;
        }
        if (this.isTextPackets()) {
            return 1;
        }
        return this.getMaximumPacketLength();
    }

    public void setLineTerminatorChar(int term) {
        this.setLineTerminatorChar(new int[]{term});
    }

    public void setLineTerminatorChar(int[] term) {
        this.lineTerminatorChar = term;
    }

    public int[] getLineTerminatorChar() {
        return this.lineTerminatorChar;
    }

    public boolean isLineTerminatorChar(int ch) {
        int[] termChar = this.getLineTerminatorChar();
        if (termChar != null && ch >= 0) {
            for (int i = 0; i < termChar.length; ++i) {
                if (termChar[i] != ch) continue;
                return true;
            }
        }
        return false;
    }

    public void setIncludePacketLineTerminator(boolean rtnTerm) {
        this.includePacketLineTerm = rtnTerm;
    }

    public boolean getIncludePacketLineTerminator() {
        return this.includePacketLineTerm;
    }

    public boolean includePacketLineTerminator() {
        return this.includePacketLineTerm;
    }

    public void setPacketTerminatorPattern(byte[] pktTerm) {
        this.packetTermPattern = (byte[])(!ListTools.isEmpty(pktTerm) ? pktTerm : null);
        this.setTextPackets(false);
    }

    public byte[] getPacketTerminatorPattern() {
        return !ListTools.isEmpty(this.packetTermPattern) ? this.packetTermPattern : null;
    }

    public void setBackspaceChar(int bs) {
        this.setBackspaceChar(new int[]{bs});
    }

    public void setBackspaceChar(int[] bs) {
        this.backspaceChar = bs;
    }

    public int[] getBackspaceChar() {
        return this.backspaceChar;
    }

    public boolean isBackspaceChar(int ch) {
        if (this.hasPrompt() && this.backspaceChar != null && ch >= 0) {
            for (int i = 0; i < this.backspaceChar.length; ++i) {
                if (this.backspaceChar[i] != ch) continue;
                return true;
            }
        }
        return false;
    }

    public void setIgnoreChar(int[] bs) {
        this.ignoreChar = bs;
    }

    public int[] getIgnoreChar() {
        return this.ignoreChar;
    }

    public boolean isIgnoreChar(int ch) {
        if (this.ignoreChar != null && ch >= 0) {
            for (int i = 0; i < this.ignoreChar.length; ++i) {
                if (this.ignoreChar[i] != ch) continue;
                return true;
            }
        }
        return false;
    }

    public void setAutoPrompt(boolean auto) {
        if (auto) {
            this.prompt = null;
            this.autoPrompt = true;
        } else {
            this.autoPrompt = false;
        }
    }

    public void setPrompt(byte[] prompt) {
        this.prompt = prompt;
        this.autoPrompt = false;
    }

    public void setPrompt(String prompt) {
        this.setPrompt(StringTools.getBytes(prompt));
    }

    protected byte[] getPrompt(int ndx) {
        this.promptIndex = ndx;
        if (this.prompt != null) {
            return this.prompt;
        }
        if (this.autoPrompt && this.isTextPackets()) {
            return StringTools.getBytes("" + (this.promptIndex + 1) + "> ");
        }
        return null;
    }

    public boolean hasPrompt() {
        return this.prompt != null || this.autoPrompt && this.isTextPackets();
    }

    public void setPromptEnabled(boolean enable) {
        this.promptEnabled = enable;
    }

    public boolean getPromptEnabled() {
        return this.promptEnabled && this.hasPrompt();
    }

    protected int getPromptIndex() {
        return this.promptIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tcpWriteToSessionID(String sessionID, byte[] data) {
        if (StringTools.isBlank(sessionID)) {
            Print.logError("No TCP SessionID specified", new Object[0]);
            return false;
        }
        if (ListTools.isEmpty(data)) {
            Print.logWarn("No data to write to TCP session: " + sessionID, new Object[0]);
            return false;
        }
        int sidCount = 0;
        int rtnOK = 0;
        List<ClientPacketHandler> list = this.activeSessionList;
        synchronized (list) {
            for (ClientPacketHandler cph : this.activeSessionList) {
                if (!cph.equalsSessionID(sessionID)) continue;
                SessionInfo sessInfo = cph.getSessionInfo();
                if (this.LogEnable && sessInfo != null) {
                    InetAddress clIP = sessInfo.getInetAddress();
                    int clPort = sessInfo.getRemotePort();
                    long sessTime = sessInfo.getSessionStartTime();
                    long recvTime = sessInfo.getSessionReceiveTime();
                    StringBuffer sb = new StringBuffer();
                    sb.append("Found TCP SessionID #");
                    sb.append(sidCount);
                    sb.append(" '").append(sessionID).append("': ");
                    sb.append(StringTools.trim(clIP)).append(":").append(clPort);
                    sb.append(", ");
                    sb.append(sessTime);
                    sb.append(", ");
                    sb.append(recvTime);
                    Print.logInfo(sb.toString(), new Object[0]);
                }
                if (cph.tcpWrite(data)) {
                    ++rtnOK;
                }
                if (this.LogEnable) {
                    StringBuffer sb = new StringBuffer();
                    sb.append("Write TCP SessionID #");
                    sb.append(sidCount);
                    sb.append(" '").append(sessionID).append("': ");
                    sb.append("0x").append(StringTools.toHexString(data));
                    sb.append(rtnOK > 0 ? " (success)" : " (failed)");
                    Print.logInfo(sb.toString(), new Object[0]);
                }
                ++sidCount;
            }
        }
        if (this.LogEnable && sidCount <= 0) {
            Print.logWarn("TCP SessionID not found: " + sessionID, new Object[0]);
        }
        return rtnOK > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean logActiveSessions(String header, StringBuffer asb) {
        long nowMS = DateTime.getCurrentTimeMillis();
        String PFX = "  ";
        if (!StringTools.isBlank(header)) {
            if (asb != null) {
                asb.append(header).append("\n");
            } else {
                Print.logInfo(header, new Object[0]);
            }
        }
        int count = 0;
        List<ClientPacketHandler> list = this.activeSessionList;
        synchronized (list) {
            StringBuffer csb = new StringBuffer();
            for (ClientPacketHandler cph : this.activeSessionList) {
                SessionInfo sessInfo = cph.getSessionInfo();
                if (sessInfo == null) continue;
                ++count;
                csb.setLength(0);
                csb.append(PFX).append("Client:");
                try {
                    Thread sessThread = sessInfo.getSessionThread();
                    String protoMode = sessInfo.isTCP() ? "TCP" : (sessInfo.isUDP() ? "UDP" : "???");
                    int localPort = sessInfo.getLocalPort();
                    InetAddress remIP = sessInfo.getInetAddress();
                    int remPort = sessInfo.getRemotePort();
                    long sessTimeMS = sessInfo.getSessionStartTimeMS();
                    long sessTime = sessInfo.getSessionStartTime();
                    long recvTime = sessInfo.getSessionReceiveTime();
                    long activeMS = nowMS - sessTimeMS;
                    csb.append(" Thread=").append(sessThread.getName());
                    csb.append(" Mode=").append(protoMode);
                    csb.append(" Local=").append(localPort);
                    csb.append(" Remote=").append(remIP.toString()).append(":").append(remPort);
                    csb.append(" Start=").append(sessTime);
                    csb.append(" Active=").append(activeMS).append("ms");
                }
                catch (Throwable th) {
                    csb.append("ERROR ").append(th.toString());
                }
                if (asb != null) {
                    asb.append(csb).append("\n");
                    continue;
                }
                Print.logInfo(csb.toString(), new Object[0]);
            }
        }
        if (count <= 0 && !StringTools.isBlank(header)) {
            String footer = "No active sessions";
            if (asb != null) {
                asb.append(PFX).append(footer).append("\n");
            } else {
                Print.logInfo(PFX + footer, new Object[0]);
            }
        }
        return count > 0;
    }

    public boolean logActiveSessions(String header) {
        return this.logActiveSessions(header, null);
    }

    public boolean sysPrintActiveSessions(String header) {
        StringBuffer asb = new StringBuffer();
        boolean S = this.logActiveSessions(header, asb);
        Print.sysPrintln(asb.toString(), new Object[0]);
        return S;
    }

    public static void sendDatagram(InetAddress host, int port, byte[] data) throws IOException {
        if (host == null) {
            throw new IOException("Invalid destination host");
        }
        if (data == null) {
            throw new IOException("Data buffer is null");
        }
        DatagramPacket sendPacket = new DatagramPacket(data, data.length, host, port);
        DatagramSocket datagramSocket = ServerSocketThread.createDatagramSocket(0);
        datagramSocket.send(sendPacket);
    }

    public static class SSEndOfStreamException
    extends IOException {
        private int byteIndex = 0;

        public SSEndOfStreamException(String msg, int byteNdx) {
            super(msg);
            this.byteIndex = byteNdx;
        }

        public int getByteIndex() {
            return this.byteIndex;
        }
    }

    public static class SSReadTimeoutException
    extends IOException {
        private int byteIndex = 0;
        private byte[] dataPacket = null;
        private int dataPacketLen = 0;

        public SSReadTimeoutException(String msg, int byteNdx) {
            super(msg);
            this.byteIndex = byteNdx;
        }

        public int getByteIndex() {
            return this.byteIndex;
        }

        public void setDataPacket(byte[] data, int len) {
            this.dataPacket = data;
            this.dataPacketLen = len;
        }
    }

    public static class SSSessionTimeoutException
    extends IOException {
        public SSSessionTimeoutException(String msg) {
            super(msg);
        }
    }

    public class ServerSessionThread
    extends Thread
    implements SessionInfo {
        private Object runLock;
        private Object tcpWriteLock;
        private ClientSocket client;
        private long sessionStartTimeMS;
        private long sessionStartTime;
        private long sessionReceiveTime;
        private long readByteCount;
        private long writeByteCount;
        private boolean shutdown;

        public ServerSessionThread() {
            this((ClientSocket)null, false);
        }

        public ServerSessionThread(ClientSocket clientSock, boolean startThread) {
            super("ClientSession_" + StringTools.format(ServerSessionThread_counter++, "000").trim());
            this.runLock = new Object();
            this.tcpWriteLock = new Object();
            this.client = null;
            this.sessionStartTimeMS = 0L;
            this.sessionStartTime = 0L;
            this.sessionReceiveTime = 0L;
            this.readByteCount = 0L;
            this.writeByteCount = 0L;
            this.shutdown = false;
            this.client = clientSock;
            if (startThread) {
                this.start();
            }
        }

        @Override
        public void start() {
            super.start();
        }

        @Override
        public Thread getSessionThread() {
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean setClientIfAvailable(ClientSocket clientSocket) {
            boolean rtn = false;
            Object object = this.runLock;
            synchronized (object) {
                if (this.client != null) {
                    rtn = false;
                } else {
                    this.client = clientSocket;
                    this.runLock.notify();
                    rtn = true;
                }
            }
            return rtn;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isAvailable() {
            boolean rtn = false;
            Object object = this.runLock;
            synchronized (object) {
                rtn = this.client == null;
            }
            return rtn;
        }

        @Override
        public int getLocalPort() {
            return ServerSocketThread.this.getLocalPort();
        }

        @Override
        public int getRemotePort() {
            return this._getRemotePort(this.client);
        }

        @Override
        public boolean isTCP() {
            return this.client != null ? this.client.isTCP() : false;
        }

        @Override
        public boolean isUDP() {
            return this.client != null ? this.client.isUDP() : false;
        }

        @Override
        public boolean isInputStream() {
            return this.client != null ? this.client.isInputStream() : false;
        }

        @Override
        public InetAddress getInetAddress() {
            return this.client != null ? this.client.getInetAddress() : null;
        }

        @Override
        public int getAvailableBytes() {
            return this.client != null ? this.client.available() : 0;
        }

        @Override
        public long getReadByteCount() {
            return this.readByteCount;
        }

        @Override
        public long getWriteByteCount() {
            return this.writeByteCount;
        }

        @Override
        public long getSessionStartTimeMS() {
            return this.sessionStartTimeMS;
        }

        @Override
        public long getSessionStartTime() {
            return this.sessionStartTime;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long getSessionReceiveTime() {
            long rtn = 0L;
            Object object = this.runLock;
            synchronized (object) {
                rtn = this.sessionReceiveTime;
            }
            return rtn;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean tcpWrite(byte[] data) {
            boolean rtn = false;
            if (data != null && data.length > 0) {
                Object object = this.runLock;
                synchronized (object) {
                    if (this.client != null && this.client.isTCP()) {
                        try {
                            OutputStream output = this.client.getOutputStream();
                            rtn = this._tcpWrite(output, data);
                        }
                        catch (Throwable th) {
                            rtn = false;
                        }
                    }
                }
            }
            return rtn;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean udpWrite(byte[] data) {
            boolean rtn = false;
            if (data != null && data.length > 0) {
                Object object = this.runLock;
                synchronized (object) {
                    if (this.client != null) {
                        if (this.client.isTCP()) {
                            if (ServerSocketThread.this.LogEnable) {
                                Print.logInfo("UDP] Ignoring TCP write: 0x%s", StringTools.toHexString(data));
                            }
                        } else if (this.client.isUDP()) {
                            try {
                                InetAddress inetAddr = this.client.getInetAddress();
                                int rp = this.getRemotePort();
                                this._sendUDPResponse(inetAddr, rp, data);
                                rtn = true;
                            }
                            catch (Throwable th) {
                                rtn = false;
                            }
                        } else if (this.client.isInputStream() && ServerSocketThread.this.LogEnable) {
                            Print.logInfo("UDP] Ignoring InputStream write: 0x%s", StringTools.toHexString(data));
                        }
                    }
                }
            }
            return rtn;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void forceCloseTCPSession() {
            Object object = this.runLock;
            synchronized (object) {
                this.interrupt();
                if (this.client != null) {
                    try {
                        this.client.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            IOException rethrowIOE = null;
            Object object = this.runLock;
            synchronized (object) {
                if (this.client != null) {
                    try {
                        this.client.close();
                    }
                    catch (IOException ioe) {
                        rethrowIOE = ioe;
                    }
                    this.client = null;
                }
            }
            if (rethrowIOE != null) {
                throw rethrowIOE;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void signalShutdown() {
            Object object = this.runLock;
            synchronized (object) {
                this.shutdown = true;
                this.runLock.notify();
            }
        }

        public boolean isShutdown() {
            return this._isShutdown();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object;
            block13: while (!this.isShutdown()) {
                object = this.runLock;
                synchronized (object) {
                    while (this.client == null) {
                        try {
                            this.runLock.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        if (!this._isShutdown()) continue;
                        break block13;
                    }
                }
                this.handleClientSession(this.client);
                object = this.runLock;
                synchronized (object) {
                    this.client = null;
                }
            }
            try {
                this.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            object = ServerSocketThread.this.clientThreadPool;
            synchronized (object) {
                ServerSocketThread.this.clientThreadPool.remove(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleClientSession(ClientSocket clientSock) {
            OutputStream output;
            Throwable termError;
            ClientPacketHandler clientHandler;
            InetAddress inetAddr;
            block77: {
                this.sessionStartTimeMS = DateTime.getCurrentTimeMillis();
                this.sessionStartTime = DateTime.getCurrentTimeSec();
                this.sessionReceiveTime = 0L;
                this.readByteCount = 0L;
                this.writeByteCount = 0L;
                if (clientSock == null) {
                    Print.logStackTrace("ClientSocket is null");
                    return;
                }
                inetAddr = clientSock.getInetAddress();
                int remotePort = clientSock.getPort();
                if ((clientSock.isTCP() || clientSock.isUDP()) && ServerSocketThread.this.LogEnable) {
                    Print.logInfo("Remote client port: " + inetAddr + ":" + remotePort + "[" + clientSock.getLocalPort() + "]", new Object[0]);
                }
                long sessionTimeoutAt = ServerSocketThread.this.hasSessionTimeout() ? DateTime.getCurrentTimeMillis() + ServerSocketThread.this.getSessionTimeout() : -1L;
                clientHandler = ServerSocketThread.this.getClientPacketHandler();
                if (clientHandler != null) {
                    clientHandler.setSessionInfo(this);
                    List list = ServerSocketThread.this.activeSessionList;
                    synchronized (list) {
                        ServerSocketThread.this.activeSessionList.add(clientHandler);
                    }
                    clientHandler.sessionStarted(inetAddr, clientSock.isTCP(), ServerSocketThread.this.isTextPackets());
                }
                termError = null;
                output = null;
                try {
                    byte[] initialPacket;
                    output = clientSock.getOutputStream();
                    if (clientHandler != null && clientHandler.getTerminateSession()) break block77;
                    if (clientHandler != null && (initialPacket = clientHandler.getInitialPacket()) != null && initialPacket.length > 0 && clientSock.isTCP()) {
                        this._tcpWrite(output, initialPacket);
                    }
                    int i = 0;
                    while (true) {
                        block78: {
                            byte[] prompt;
                            long currentTimeMS;
                            if (sessionTimeoutAt > 0L && (currentTimeMS = DateTime.getCurrentTimeMillis()) >= sessionTimeoutAt) {
                                throw new SSSessionTimeoutException("Session timeout");
                            }
                            if (this._isPromptEnabled(clientSock, clientHandler) && (prompt = ServerSocketThread.this.getPrompt(i)) != null && prompt.length > 0) {
                                this._tcpWrite(output, prompt);
                            }
                            byte[] line = null;
                            line = ServerSocketThread.this.isTextPackets() ? this._readLine(clientSock, clientHandler) : this._readPacket(clientSock, clientHandler);
                            if (clientHandler != null && clientHandler.getTerminateSession()) break block77;
                            if (line != null) {
                                this.sessionReceiveTime = DateTime.getCurrentTimeSec();
                            }
                            if (line != null && ServerSocketThread.this.hasListeners()) {
                                try {
                                    ServerSocketThread.this.invokeListeners(line);
                                }
                                catch (Throwable t) {
                                    break;
                                }
                            }
                            if (line != null && clientHandler != null) {
                                try {
                                    byte[] response = clientHandler.getHandlePacket(line);
                                    if (response != null && response.length > 0) {
                                        if (clientSock.isTCP()) {
                                            if (ServerSocketThread.this.LogEnable) {
                                                if (!StringTools.isPrintableASCII(response)) {
                                                    Print.logInfo("TCP Resp Hex: 0x%s", StringTools.toHexString(response));
                                                }
                                                Print.logInfo("TCP Resp Asc: %s", StringTools.toStringValue(response, '.'));
                                            }
                                            this._tcpWrite(output, response);
                                        } else if (clientSock.isUDP()) {
                                            int rp = this._getRemotePort(clientSock, clientHandler.getResponsePort());
                                            try {
                                                this._sendUDPResponse(inetAddr, rp, response);
                                            }
                                            catch (IOException ioeUDP) {
                                                Print.logException("Sending UDP response [" + inetAddr + ":" + rp + "]", ioeUDP);
                                            }
                                        } else if (clientSock.isInputStream() && ServerSocketThread.this.LogEnable) {
                                            Print.logInfo("Ignoring InputStream response: 0x%s", StringTools.toHexString(response));
                                        }
                                    }
                                    if (clientHandler.getTerminateSession()) {
                                    }
                                    break block78;
                                }
                                catch (Throwable t) {
                                    Print.logException("Unexpected exception: ", t);
                                }
                                break;
                            }
                        }
                        if (clientSock.isTCP()) {
                            if (this._isShutdown()) {
                                break;
                            }
                        } else if (clientSock.isUDP()) {
                            int avail = clientSock.available();
                            if (avail <= 0) break;
                            if (ServerSocketThread.this.LogEnable) {
                                Print.logDebug("UDP: bytes remaining - %d", avail);
                            }
                        } else if (clientSock.isInputStream()) {
                            int avail = clientSock.available();
                            if (avail <= 0) break;
                            if (ServerSocketThread.this.LogEnable) {
                                Print.logDebug("InputStream: bytes remaining - %d", avail);
                            }
                        }
                        ++i;
                    }
                }
                catch (SSSessionTimeoutException ste) {
                    if (RTConfig.isDebugMode()) {
                        Print.logWarn(ste.getMessage(), new Object[0]);
                    } else {
                        Print.logWarn(ste.getMessage(), new Object[0]);
                    }
                    termError = ste;
                }
                catch (SSReadTimeoutException rte) {
                    if (rte.getByteIndex() <= 0) {
                        Print.logInfo(rte.getMessage(), new Object[0]);
                    } else {
                        Print.logWarn(rte.getMessage(), new Object[0]);
                        termError = rte;
                    }
                }
                catch (SSEndOfStreamException eos) {
                    if (clientSock.isTCP()) {
                        if (eos.getByteIndex() <= 0) {
                            Print.logInfo(eos.getMessage(), new Object[0]);
                        } else {
                            Print.logWarn(eos.getMessage(), new Object[0]);
                            termError = eos;
                        }
                    }
                }
                catch (SocketException se) {
                    Print.logError("Connection closed", new Object[0]);
                    termError = se;
                }
                catch (Throwable t) {
                    Print.logException("?", t);
                    termError = t;
                }
            }
            if (ServerSocketThread.this.LogEnable) {
                long deltaMS = DateTime.getCurrentTimeMillis() - this.sessionStartTimeMS;
                Print.logInfo("End of " + clientSock.getSessionType() + " session [" + deltaMS + " ms] ...", new Object[0]);
            }
            if (clientHandler != null) {
                try {
                    byte[] finalPacket = clientHandler.getFinalPacket(termError != null);
                    if (finalPacket != null && finalPacket.length > 0) {
                        if (clientSock.isTCP()) {
                            this._tcpWrite(output, finalPacket);
                        } else if (clientSock.isUDP()) {
                            int rp = this._getRemotePort(clientSock, clientHandler.getResponsePort());
                            this._sendUDPResponse(inetAddr, rp, finalPacket);
                        } else if (clientSock.isInputStream() && ServerSocketThread.this.LogEnable) {
                            Print.logInfo("Ignoring InputStream finalPacket: 0x" + StringTools.toHexString(finalPacket), new Object[0]);
                        }
                    }
                }
                catch (Throwable t) {
                    Print.logException("Final packet transmission", t);
                }
                clientHandler.sessionTerminated(termError, this.readByteCount, this.writeByteCount);
                List t = ServerSocketThread.this.activeSessionList;
                synchronized (t) {
                    ServerSocketThread.this.activeSessionList.remove(clientHandler);
                }
                clientHandler.setSessionInfo(null);
            }
            if (output != null) {
                try {
                    output.flush();
                }
                catch (IOException ioe) {
                    Print.logException("Flush", ioe);
                }
                catch (Throwable t) {
                    Print.logException("?", t);
                }
            }
            if (clientSock.isTCP()) {
                int ltSec = ServerSocketThread.this.getLingerTimeoutSec();
                try {
                    clientSock.setSoLinger(ltSec);
                }
                catch (SocketException se) {
                    Print.logException("[non-critical]: setSoLinger(" + ltSec + ")", se);
                }
                catch (Throwable t) {
                    Print.logException("[non-critical]: Unexpected exeption - setSoLinger(" + ltSec + ")", t);
                }
            } else if (clientSock.isUDP() || clientSock.isInputStream()) {
                // empty if block
            }
            try {
                clientSock.close();
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }

        private int _getRemotePort(ClientSocket clientSock) {
            int rPort = ServerSocketThread.this.getRemotePort();
            if (rPort <= 0 && clientSock != null) {
                rPort = clientSock.getPort();
            }
            return rPort;
        }

        private int _getRemotePort(ClientSocket clientSock, int overridePort) {
            return overridePort > 0 ? overridePort : this._getRemotePort(clientSock);
        }

        private int _getMinimumPacketLength(ClientPacketHandler clientHandler) {
            int len;
            if (clientHandler != null && (len = clientHandler.getMinimumPacketLength()) > 0) {
                return len;
            }
            return ServerSocketThread.this.getMinimumPacketLength();
        }

        private int _getMaximumPacketLength(ClientPacketHandler clientHandler) {
            int len;
            if (clientHandler != null && (len = clientHandler.getMaximumPacketLength()) > 0) {
                return len;
            }
            return ServerSocketThread.this.getMaximumPacketLength();
        }

        private boolean _isShutdown() {
            return this.shutdown;
        }

        private boolean _isPromptEnabled(ClientSocket clientSock, ClientPacketHandler clientHandler) {
            if (clientSock != null && !clientSock.isTCP()) {
                return false;
            }
            if (!ServerSocketThread.this.getPromptEnabled()) {
                return false;
            }
            return clientHandler == null || clientHandler.getPromptEnabled();
        }

        private void _sendUDPResponse(InetAddress clientAddr, int clientPort, byte[] pkt) throws IOException {
            if (pkt != null && pkt.length != 0) {
                if (clientPort <= 0) {
                    Print.logWarn("Unable to send packet Datagram: unknown port", new Object[0]);
                } else {
                    boolean closeSocket = false;
                    DatagramSocket dgSocket = null;
                    dgSocket = ServerSocketThread.this.datagramSocket;
                    closeSocket = false;
                    DatagramPacket respPkt = new DatagramPacket(pkt, pkt.length, clientAddr, clientPort);
                    for (int retry = 1; retry > 0; --retry) {
                        if (ServerSocketThread.this.LogEnable) {
                            String clientIP = clientAddr.toString();
                            String pktHex = StringTools.toHexString(pkt);
                            if (RTConfig.isDebugMode()) {
                                int locPort = dgSocket.getLocalPort();
                                String bindAddr = StringTools.blankDefault(dgSocket.getLocalAddress(), "null");
                                Print.logDebug("UDP Response (from %s:%d to %s:%d) 0x%s", bindAddr, locPort, clientIP, clientPort, pktHex);
                            } else {
                                Print.logInfo("UDP Response [%s:%d] 0x%s", clientIP, clientPort, pktHex);
                            }
                        }
                        dgSocket.send(respPkt);
                        this.writeByteCount += (long)pkt.length;
                    }
                    if (closeSocket) {
                        dgSocket.close();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean _tcpWrite(OutputStream output, byte[] data) throws IOException {
            boolean rtn = false;
            if (output != null && data != null && data.length > 0) {
                Object object = this.tcpWriteLock;
                synchronized (object) {
                    try {
                        output.write(data);
                        output.flush();
                        this.writeByteCount += (long)data.length;
                        rtn = true;
                    }
                    catch (IOException t) {
                        Print.logError("writeBytes error - " + t, new Object[0]);
                        throw t;
                    }
                }
            }
            return rtn;
        }

        /*
         * Loose catch block
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private int _readByte(ClientSocket clientSock, ClientPacketHandler clientHandler, long timeoutAtMS, int byteNdx) throws IOException {
            InputStream input = clientSock.getInputStream();
            while (true) {
                if (timeoutAtMS > 0L) {
                    long currentTimeMS = DateTime.getCurrentTimeMillis();
                    if (currentTimeMS >= timeoutAtMS) {
                        if (byteNdx > 0) throw new SSReadTimeoutException("Read timeout [@ " + byteNdx + "]", byteNdx);
                        throw new SSReadTimeoutException("Read timeout [empty packet]", byteNdx);
                    }
                    int minTimeout = MinimumTimeoutIntervalMS;
                    int maxTimeout = (int)(timeoutAtMS - currentTimeMS);
                    int actTimeout = minTimeout <= 0 ? maxTimeout : (minTimeout < maxTimeout ? minTimeout : maxTimeout);
                    clientSock.setSoTimeout(actTimeout);
                }
                try {
                    int ch = input.read();
                    if (ch < 0) {
                        if (byteNdx > 0) throw new SSEndOfStreamException("End of stream [@ " + byteNdx + "]", byteNdx);
                        throw new SSEndOfStreamException("End of stream [empty packet]", byteNdx);
                    }
                    ++this.readByteCount;
                    return ch;
                }
                catch (ClosedByInterruptException cbie) {
                    throw new SSEndOfStreamException("End of stream [close interrupt detected]", byteNdx);
                }
                catch (InterruptedIOException ie) {
                    if (clientHandler == null) continue;
                    clientHandler.idleTimeoutInterrupt();
                    if (clientHandler.getTerminateSession()) throw new SSEndOfStreamException("End of stream [terminate interrupt detected]", byteNdx);
                    continue;
                }
                catch (SocketException se) {
                    throw se;
                }
                break;
            }
            catch (IOException ioe) {
                throw ioe;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private byte[] _readLine(ClientSocket clientSock, ClientPacketHandler clientHandler) throws IOException {
            long idleTimeoutMS = ServerSocketThread.this.getIdleTimeout();
            long pcktTimeoutMS = ServerSocketThread.this.getPacketTimeout();
            long pcktTimeoutAt = idleTimeoutMS > 0L ? DateTime.getCurrentTimeMillis() + idleTimeoutMS : -1L;
            int maxLen = this._getMaximumPacketLength(clientHandler);
            byte[] buff = new byte[maxLen];
            int buffLen = 0;
            boolean isIdle = true;
            long readStartTime = DateTime.getCurrentTimeMillis();
            try {
                while (true) {
                    byte[] newBuff;
                    int ch = this._readByte(clientSock, clientHandler, pcktTimeoutAt, buffLen);
                    if (isIdle) {
                        isIdle = false;
                        if (pcktTimeoutMS > 0L) {
                            pcktTimeoutAt = DateTime.getCurrentTimeMillis() + pcktTimeoutMS;
                        }
                    }
                    if (ServerSocketThread.this.isLineTerminatorChar(ch)) {
                        if (ServerSocketThread.this.includePacketLineTerminator()) {
                            if (buffLen >= buff.length) {
                                newBuff = new byte[buff.length + 1];
                                System.arraycopy(buff, 0, newBuff, 0, buff.length);
                                buff = newBuff;
                            }
                            buff[buffLen++] = (byte)ch;
                        }
                        break;
                    }
                    if (ServerSocketThread.this.isTextPackets()) {
                        if (ServerSocketThread.this.isIgnoreChar(ch)) continue;
                        if (ServerSocketThread.this.isBackspaceChar(ch)) {
                            if (buffLen <= 0) continue;
                            --buffLen;
                            continue;
                        }
                        if (ch < 32 && ch != 9) continue;
                    }
                    if (buffLen >= buff.length) {
                        newBuff = new byte[buff.length * 2];
                        System.arraycopy(buff, 0, newBuff, 0, buff.length);
                        buff = newBuff;
                    }
                    buff[buffLen++] = (byte)ch;
                    if (maxLen > 0 && buffLen >= maxLen) break;
                }
            }
            catch (SSReadTimeoutException te) {
                if (buffLen > 0) {
                    Print.logWarn("Timeout: " + StringTools.toStringValue(buff, 0, buffLen), new Object[0]);
                }
                if (ServerSocketThread.this.getTerminateOnTimeout()) {
                    throw te;
                }
            }
            catch (SSEndOfStreamException eos) {
                if (clientSock.isTCP()) {
                    if (buffLen > 0) {
                        Print.logWarn("EOS: (ASCII) " + StringTools.toStringValue(buff, 0, buffLen), new Object[0]);
                    }
                    Print.logError(eos.getMessage(), new Object[0]);
                    throw eos;
                }
                if (!clientSock.isUDP() && !clientSock.isInputStream()) {
                    // empty if block
                }
            }
            catch (IOException ioe) {
                Print.logError("ReadLine error - " + ioe, new Object[0]);
                throw ioe;
            }
            long readEndTime = DateTime.getCurrentTimeMillis();
            if (buff.length == buffLen) {
                return buff;
            }
            byte[] newBuff = new byte[buffLen];
            System.arraycopy(buff, 0, newBuff, 0, buffLen);
            return newBuff;
        }

        private byte[] _readPacket(ClientSocket clientSock, ClientPacketHandler clientHandler) throws IOException {
            int packetLen;
            byte[] packet;
            block38: {
                long idleTimeoutMS = ServerSocketThread.this.getIdleTimeout();
                long pcktTimeoutMS = ServerSocketThread.this.getPacketTimeout();
                long pcktTimeoutAt = idleTimeoutMS > 0L ? DateTime.getCurrentTimeMillis() + idleTimeoutMS : -1L;
                int maxLen = this._getMaximumPacketLength(clientHandler);
                int minLen = this._getMinimumPacketLength(clientHandler);
                byte[] pktTerm = ServerSocketThread.this.getPacketTerminatorPattern();
                int pktState = 0;
                packet = new byte[maxLen];
                packetLen = 0;
                boolean isIdle = true;
                boolean breakOnLineTerm = false;
                boolean incrementOnLineTerm = false;
                boolean failOnEOS = clientSock.isTCP();
                try {
                    int actualLen = 0;
                    while (true) {
                        int avail;
                        int nextLen;
                        int lastByte = this._readByte(clientSock, clientHandler, pcktTimeoutAt, packetLen);
                        if (isIdle) {
                            isIdle = false;
                            if (pcktTimeoutMS > 0L) {
                                pcktTimeoutAt = DateTime.getCurrentTimeMillis() + pcktTimeoutMS;
                            }
                        }
                        if (breakOnLineTerm) {
                            if (ServerSocketThread.this.isLineTerminatorChar(lastByte)) {
                                if (ServerSocketThread.this.includePacketLineTerminator()) {
                                    packet[packetLen++] = (byte)lastByte;
                                }
                                break;
                            }
                            if (ServerSocketThread.this.isIgnoreChar(lastByte)) continue;
                            packet[packetLen++] = (byte)lastByte;
                        } else {
                            packet[packetLen++] = (byte)lastByte;
                        }
                        if (packetLen >= maxLen) break;
                        if (actualLen > 0) {
                            if (packetLen < actualLen) continue;
                            break;
                        }
                        if (pktTerm != null) {
                            if (pktTerm[pktState] == (byte)lastByte) {
                                if (++pktState >= pktTerm.length) {
                                    break;
                                }
                            } else {
                                pktState = 0;
                            }
                        }
                        if (incrementOnLineTerm && ServerSocketThread.this.isLineTerminatorChar(lastByte)) {
                            incrementOnLineTerm = false;
                            minLen = packetLen;
                        }
                        if (packetLen < minLen || clientHandler == null) continue;
                        int newPktLen = clientHandler.getActualPacketLength(packet, packetLen);
                        boolean haveActual = newPktLen >= 0 && newPktLen < 0xFFFFFF;
                        int n = nextLen = newPktLen < 0 ? newPktLen : newPktLen & 0xFFFFFF;
                        if (clientHandler.getTerminateSession()) break;
                        if (haveActual) {
                            if (nextLen == packetLen) {
                                actualLen = packetLen;
                                break;
                            }
                            if (nextLen < packetLen) {
                                Print.logError("Actual length [" + nextLen + "] < Packet length [" + packetLen + "]", new Object[0]);
                                actualLen = packetLen;
                                break;
                            }
                            if (nextLen > maxLen) {
                                Print.logError("Actual length [" + nextLen + "] > Maximum length [" + maxLen + "]", new Object[0]);
                                actualLen = maxLen;
                                continue;
                            }
                            actualLen = nextLen;
                            continue;
                        }
                        if (nextLen == -1) {
                            if (ServerSocketThread.this.isLineTerminatorChar(lastByte)) {
                                if (!ServerSocketThread.this.includePacketLineTerminator()) {
                                    --packetLen;
                                }
                                actualLen = packetLen;
                                break;
                            }
                            breakOnLineTerm = true;
                            actualLen = maxLen;
                            continue;
                        }
                        if (nextLen == -2) {
                            avail = clientSock.available();
                            actualLen = packetLen + avail;
                            if (actualLen > maxLen) {
                                actualLen = maxLen;
                            }
                            failOnEOS = false;
                            continue;
                        }
                        if (nextLen < -2) {
                            avail = clientSock.available();
                            actualLen = packetLen + avail;
                            if (actualLen > maxLen) {
                                actualLen = maxLen;
                            }
                            failOnEOS = false;
                            continue;
                        }
                        if (nextLen == 0xFFFFFF) {
                            incrementOnLineTerm = true;
                            minLen = maxLen;
                            continue;
                        }
                        if (nextLen > maxLen) {
                            Print.logWarn("Incremental length [" + nextLen + "] > Maximum length [" + maxLen + "]", new Object[0]);
                            minLen = maxLen;
                            continue;
                        }
                        minLen = nextLen > packetLen ? nextLen : packetLen + 1;
                    }
                }
                catch (SSReadTimeoutException rte) {
                    if (failOnEOS) {
                        if (packetLen > 0) {
                            Print.logWarn("Timeout: 0x" + StringTools.toHexString(packet, 0, packetLen), new Object[0]);
                        }
                        if (ServerSocketThread.this.getTerminateOnTimeout()) {
                            throw rte;
                        }
                    }
                }
                catch (SSEndOfStreamException eos) {
                    if ((clientHandler == null || !clientHandler.getTerminateSession()) && failOnEOS) {
                        if (packetLen > 0) {
                            Print.logWarn("EOS: 0x" + StringTools.toHexString(packet, 0, packetLen), new Object[0]);
                        }
                        Print.logError(eos.getMessage(), new Object[0]);
                        throw eos;
                    }
                }
                catch (SocketException se) {
                    if (clientHandler == null || !clientHandler.getTerminateSession()) {
                        Print.logError("ReadPacket error - " + se, new Object[0]);
                        throw se;
                    }
                }
                catch (IOException ioe) {
                    if (clientHandler != null && clientHandler.getTerminateSession()) break block38;
                    Print.logError("ReadPacket error - " + ioe, new Object[0]);
                    throw ioe;
                }
            }
            if (packet.length == packetLen) {
                return packet;
            }
            byte[] newPacket = new byte[packetLen];
            System.arraycopy(packet, 0, newPacket, 0, packetLen);
            return newPacket;
        }
    }

    public static interface SessionInfo {
        public Thread getSessionThread();

        public long getSessionStartTimeMS();

        public long getSessionStartTime();

        public long getSessionReceiveTime();

        public int getLocalPort();

        public boolean isTCP();

        public boolean isUDP();

        public boolean isInputStream();

        public void forceCloseTCPSession();

        public int getAvailableBytes();

        public InetAddress getInetAddress();

        public int getRemotePort();

        public boolean tcpWrite(byte[] var1);

        public boolean udpWrite(byte[] var1);

        public long getReadByteCount();

        public long getWriteByteCount();
    }

    private class ClientSocket {
        private Socket tcpClient = null;
        private DatagramPacket udpClient = null;
        private InputStream inpStream = null;
        private boolean isInpStream = false;
        private boolean isOpen = true;

        public ClientSocket(Socket tcpClient) {
            this.tcpClient = tcpClient;
            this.isOpen = true;
        }

        public ClientSocket(DatagramPacket udpClient) {
            this.udpClient = udpClient;
            this.isOpen = true;
        }

        public ClientSocket(InputStream inStream) {
            this.inpStream = inStream;
            this.isInpStream = true;
            this.isOpen = true;
        }

        public boolean isTCP() {
            return this.tcpClient != null;
        }

        public boolean isUDP() {
            return this.udpClient != null;
        }

        public boolean isInputStream() {
            return this.isInpStream;
        }

        public String getSessionType() {
            if (this.isTCP()) {
                return "TCP";
            }
            if (this.isUDP()) {
                return "UDP";
            }
            if (this.isInputStream()) {
                return "InputStream";
            }
            return "UNKNOWN";
        }

        public int available() {
            if (!this.isOpen) {
                return 0;
            }
            try {
                return this.getInputStream().available();
            }
            catch (Throwable t) {
                return 0;
            }
        }

        public InetAddress getInetAddress() {
            if (!this.isOpen) {
                return null;
            }
            if (this.isTCP()) {
                return this.tcpClient.getInetAddress();
            }
            if (this.isUDP()) {
                try {
                    SocketAddress sa = this.udpClient.getSocketAddress();
                    if (sa instanceof InetSocketAddress) {
                        return ((InetSocketAddress)sa).getAddress();
                    }
                    return null;
                }
                catch (Throwable th) {
                    return null;
                }
            }
            if (this.isInputStream()) {
                return null;
            }
            return null;
        }

        public int getPort() {
            if (!this.isOpen) {
                return -1;
            }
            if (this.isTCP()) {
                return this.tcpClient.getPort();
            }
            if (this.isUDP()) {
                return this.udpClient.getPort();
            }
            if (this.isInputStream()) {
                return -1;
            }
            return -1;
        }

        public int getLocalPort() {
            if (!this.isOpen) {
                return -1;
            }
            return ServerSocketThread.this.getLocalPort();
        }

        public OutputStream getOutputStream() throws IOException {
            if (!this.isOpen) {
                return null;
            }
            if (this.isTCP()) {
                return this.tcpClient.getOutputStream();
            }
            if (this.isUDP()) {
                return null;
            }
            if (this.isInputStream()) {
                return null;
            }
            return null;
        }

        public InputStream getInputStream() throws IOException {
            if (!this.isOpen) {
                return null;
            }
            if (this.isTCP()) {
                return this.tcpClient.getInputStream();
            }
            if (this.isUDP()) {
                if (this.inpStream == null) {
                    this.inpStream = new ByteArrayInputStream(this.udpClient.getData(), 0, this.udpClient.getLength());
                }
                return this.inpStream;
            }
            if (this.isInputStream()) {
                return this.inpStream;
            }
            return null;
        }

        public void setSoTimeout(int timeoutSec) throws SocketException {
            if (!this.isOpen) {
                return;
            }
            if (this.isTCP()) {
                this.tcpClient.setSoTimeout(timeoutSec);
            } else if (this.isUDP() || this.isInputStream()) {
                // empty if block
            }
        }

        public void setSoLinger(int timeoutSec) throws SocketException {
            if (!this.isOpen) {
                return;
            }
            if (this.isTCP()) {
                if (timeoutSec <= 0) {
                    this.tcpClient.setSoLinger(false, 0);
                } else {
                    this.tcpClient.setSoLinger(true, timeoutSec);
                }
            } else if (this.isUDP() || this.isInputStream()) {
                // empty if block
            }
        }

        public void setSoLinger(boolean on, int timeoutSec) throws SocketException {
            if (!this.isOpen) {
                return;
            }
            if (this.isTCP()) {
                if (timeoutSec <= 0) {
                    on = false;
                }
                this.tcpClient.setSoLinger(on, timeoutSec);
            } else if (this.isUDP() || this.isInputStream()) {
                // empty if block
            }
        }

        public void close() throws IOException {
            if (this.isTCP()) {
                this.tcpClient.close();
            } else if (this.isUDP() || this.isInputStream()) {
                // empty if block
            }
            this.isOpen = false;
        }
    }
}

