/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.SendFailedException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.opengts.util.FileTools;
import org.opengts.util.HTMLTools;
import org.opengts.util.ListTools;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;
import org.opengts.util.SendMail;
import org.opengts.util.StringTools;

public class SendMailArgs {
    public static final boolean USE_AUTHENTICATOR = true;
    public static final String SSL_FACTORY = "javax.net.ssl.SSLSocketFactory";
    private static Object IgnEmailLock = new Object();
    private static boolean IgnEmailInit = false;
    private static File IgnEmailFile = null;
    private static long IgnEmailModTime = 0L;
    private static Set<String> IgnEmailSet = null;
    private static boolean IgnEmailDebug = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean IsIgnoredEmailAddress(String e) {
        if (StringTools.isBlank(e)) {
            return true;
        }
        Object object = IgnEmailLock;
        synchronized (object) {
            if (!IgnEmailInit) {
                File ignFile = RTConfig.getFile("smtp.ignoredEmail.file", null);
                if (ignFile != null && !ignFile.isAbsolute()) {
                    File dir = RTConfig.getLoadedConfigDir();
                    ignFile = dir != null ? new File(dir, ignFile.toString()) : null;
                }
                IgnEmailFile = ignFile;
                IgnEmailModTime = 0L;
                IgnEmailSet = null;
                IgnEmailInit = true;
                if (IgnEmailFile != null) {
                    Print.logInfo("Init IgnoredEmail file: " + IgnEmailFile, new Object[0]);
                }
            }
            if (IgnEmailFile == null || !IgnEmailFile.isFile()) {
                if (IgnEmailSet != null) {
                    Print.logWarn("IgnoredEmail file no longer exists: " + IgnEmailFile, new Object[0]);
                    IgnEmailModTime = 0L;
                    IgnEmailSet = null;
                }
            } else {
                long lastMod = IgnEmailFile.lastModified();
                if (lastMod == 0L) {
                    Print.logWarn("No IgnoredEmail file last modified time: " + IgnEmailFile, new Object[0]);
                    IgnEmailModTime = 0L;
                    IgnEmailSet = null;
                } else if (lastMod > IgnEmailModTime) {
                    Print.logInfo("(Re)Loading IgnoredEmail file: " + IgnEmailFile, new Object[0]);
                    HashSet<String> ignSet = new HashSet<String>();
                    FileInputStream fis = null;
                    try {
                        fis = new FileInputStream(IgnEmailFile);
                        int r = 0;
                        while (true) {
                            String line = null;
                            try {
                                line = FileTools.readLine(fis);
                                if (line == null) {
                                    break;
                                }
                                line = line.trim();
                            }
                            catch (EOFException eof) {
                                break;
                            }
                            if (!line.startsWith("#") && line.indexOf("@") > 0) {
                                if (IgnEmailDebug) {
                                    Print.logInfo("Adding IgnoredEmail Addr: " + line, new Object[0]);
                                }
                                ignSet.add(line);
                            }
                            ++r;
                        }
                    }
                    catch (IOException ioe) {
                        Print.logException("IgnoredEmail file IO Error", ioe);
                    }
                    finally {
                        if (fis != null) {
                            try {
                                fis.close();
                            }
                            catch (Throwable th) {}
                        }
                    }
                    IgnEmailSet = !ListTools.isEmpty(ignSet) ? ignSet : null;
                    IgnEmailModTime = lastMod;
                }
            }
        }
        if (ListTools.isEmpty(IgnEmailSet)) {
            return false;
        }
        return IgnEmailSet.contains(e);
    }

    public static String parseEMailAddress(String addr) {
        if (!StringTools.isBlank(addr)) {
            try {
                InternetAddress ia = new InternetAddress(addr, true);
                return ia.getAddress();
            }
            catch (Throwable ae) {
                Print.logWarn("Invalid EMail address: " + addr, new Object[0]);
                return null;
            }
        }
        return null;
    }

    public static boolean send(SendMail.Args args) {
        String from = args.getFrom();
        String[] to = args.getTo();
        String[] cc = args.getCc();
        String[] bcc = args.getBcc();
        String subject = args.getSubject();
        String msgBody = args.getBody();
        Properties headers = args.getHeaders();
        SendMail.Attachment attach = args.getAttachment();
        SendMail.SmtpProperties smtpProps = args.getSmtpProperties();
        Properties props = new Properties();
        if (smtpProps.getDebug()) {
            props.put("mail.debug", "true");
            Print.logDebug("SendMail debug mode", new Object[0]);
        }
        String smtpHost = smtpProps.getHost();
        int smtpPort = smtpProps.getPort();
        final String smtpUser = smtpProps.getUser();
        String smtpEmail = smtpProps.getUserEmail();
        final String smtpPass = smtpProps.getPassword();
        String enableSSL = smtpProps.getEnableSSL();
        String enableTLS = smtpProps.getEnableTLS();
        if (StringTools.isBlank(smtpHost) || smtpHost.endsWith("example.com")) {
            Print.logError("Null/Invalid SMTP host, not sending email", new Object[0]);
            return false;
        }
        if (smtpPort <= 0) {
            Print.logError("Invalid SMTP port, not sending email", new Object[0]);
            return false;
        }
        props.put("mail.smtp.host", smtpHost);
        props.put("mail.smtp.port", String.valueOf(smtpPort));
        props.put("mail.smtp.connectiontimeout", "60000");
        props.put("mail.smtp.timeout", "60000");
        if (enableSSL.equals("only") || enableSSL.equals("true")) {
            props.put("mail.smtp.socketFactory.port", String.valueOf(smtpPort));
            props.put("mail.smtp.socketFactory.class", SSL_FACTORY);
            props.put("mail.smtp.socketFactory.fallback", "false");
            if (enableSSL.equals("only")) {
                props.put("mail.smtp.ssl.enable", "true");
                props.put("mail.smtp.ssl.socketFactory.port", String.valueOf(smtpPort));
            }
        }
        if (enableTLS.equals("only") || enableTLS.equals("true")) {
            props.put("mail.smtp.starttls.required", "true");
            props.put("mail.smtp.starttls.enable", "true");
        }
        Authenticator auth = null;
        if (!StringTools.isBlank(smtpUser)) {
            auth = new Authenticator(){

                public PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(smtpUser, smtpPass);
                }
            };
            props.put("mail.smtp.user", smtpUser);
            props.put("mail.smtp.auth", "true");
        }
        Session session = Session.getInstance((Properties)props, auth);
        try {
            MimeMessage msg = new MimeMessage(session);
            if (StringTools.isBlank(from) || from.equalsIgnoreCase("default")) {
                msg.setFrom((Address)new InternetAddress(smtpEmail));
            } else {
                msg.setFrom((Address)new InternetAddress(from));
            }
            InternetAddress[] toAddr = SendMailArgs._convertRecipients(to);
            InternetAddress[] ccAddr = SendMailArgs._convertRecipients(cc);
            InternetAddress[] bccAddr = SendMailArgs._convertRecipients(bcc);
            if (toAddr != null && toAddr.length > 0) {
                for (String string : headers.keySet()) {
                    String v = headers.getProperty(string);
                    if (v == null) continue;
                    msg.setHeader(string, v);
                }
                msg.setRecipients(Message.RecipientType.TO, (Address[])toAddr);
                msg.setRecipients(Message.RecipientType.CC, (Address[])ccAddr);
                msg.setRecipients(Message.RecipientType.BCC, (Address[])bccAddr);
                msg.setSubject(subject, "UTF-8");
                msg.setSentDate(new Date());
                if (attach != null && attach.getSize() > 0) {
                    MimeMultipart multipart = new MimeMultipart();
                    if (msgBody != null && !msgBody.equals("")) {
                        MimeBodyPart mimeBodyPart = new MimeBodyPart();
                        mimeBodyPart.setText(msgBody, "UTF-8");
                        multipart.addBodyPart((BodyPart)mimeBodyPart);
                    }
                    MimeBodyPart mimeBodyPart = new MimeBodyPart();
                    ByteArrayDataSource source = new ByteArrayDataSource(attach.getName(), attach.getType(), attach.getBytes());
                    mimeBodyPart.setDataHandler(new DataHandler((DataSource)source));
                    mimeBodyPart.setFileName(source.getName());
                    multipart.addBodyPart((BodyPart)mimeBodyPart);
                    msg.setContent((Multipart)multipart);
                } else {
                    msg.setText(msgBody, "UTF-8");
                }
                msg.saveChanges();
                Transport.send((Message)msg);
                Print.logDebug("Email sent ...", new Object[0]);
                return true;
            }
            return false;
        }
        catch (MessagingException me) {
            Print.logStackTrace("Unable to send email [host=" + smtpHost + "; port=" + smtpPort + "]", me);
            MessagingException ex = me;
            while (ex != null) {
                if (ex instanceof SendFailedException) {
                    SendFailedException sfex = (SendFailedException)ex;
                    SendMailArgs._printAddresses("Invalid:", sfex.getInvalidAddresses());
                    SendMailArgs._printAddresses("Valid Unsent:", sfex.getValidUnsentAddresses());
                    SendMailArgs._printAddresses("Valid Sent:", sfex.getValidSentAddresses());
                }
                ex = ex instanceof MessagingException ? ex.getNextException() : null;
            }
            return false;
        }
    }

    private static InternetAddress[] _convertRecipients(String[] to) throws AddressException {
        Vector<InternetAddress> inetAddr = new Vector<InternetAddress>();
        for (int i = 0; i < to.length; ++i) {
            String t;
            String string = t = to[i] != null ? to[i].trim() : "";
            if (t.equals("")) continue;
            if (SendMailArgs.IsIgnoredEmailAddress(t)) {
                Print.logWarn("Ignoring Email Address: " + t, new Object[0]);
                continue;
            }
            try {
                inetAddr.add(new InternetAddress(t));
                continue;
            }
            catch (AddressException ae) {
                Print.logStackTrace("Address: " + t + " (skipped)", ae);
            }
        }
        return inetAddr.toArray(new InternetAddress[inetAddr.size()]);
    }

    private static void _printAddresses(String msg, Address[] addr) {
        if (addr != null) {
            Print.logInfo(msg, new Object[0]);
            for (int i = 0; i < addr.length; ++i) {
                Print.logInfo("    " + addr[i], new Object[0]);
            }
        }
    }

    private static class ByteArrayDataSource
    implements DataSource {
        private String name = null;
        private String type = null;
        private Object source = null;

        private ByteArrayDataSource(String name, String type, Object src) {
            this.name = name;
            this.type = type;
            this.source = src;
        }

        public ByteArrayDataSource(String name, byte[] src) {
            this(name, (String)null, src);
        }

        public ByteArrayDataSource(String name, String type, byte[] src) {
            this(name, type, (Object)src);
        }

        public ByteArrayDataSource(String name, String src) {
            this(name, null, src);
        }

        public ByteArrayDataSource(String name, String type, String src) {
            this(name, type, (Object)src);
        }

        public String getName() {
            return this.name != null ? this.name : "";
        }

        public String getContentType() {
            if (this.type != null) {
                return this.type;
            }
            if (this.getName().toLowerCase().endsWith(".csv")) {
                return HTMLTools.MIME_CSV();
            }
            if (this.getName().toLowerCase().endsWith(".gif")) {
                return HTMLTools.MIME_GIF();
            }
            if (this.getName().toLowerCase().endsWith(".png")) {
                return HTMLTools.MIME_PNG();
            }
            if (this.source instanceof byte[]) {
                return SendMail.DefaultContentType((byte[])this.source);
            }
            if (this.source instanceof ByteArrayOutputStream) {
                return SendMail.DefaultContentType(((ByteArrayOutputStream)this.source).toByteArray());
            }
            return HTMLTools.MIME_PLAIN();
        }

        public InputStream getInputStream() {
            return new ByteArrayInputStream(this.toByteArray());
        }

        public OutputStream getOutputStream() {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte[] b = this.toByteArray();
            if (b != null && b.length > 0) {
                out.write(b, 0, b.length);
            }
            this.source = out;
            return (ByteArrayOutputStream)this.source;
        }

        private byte[] toByteArray() {
            if (this.source == null) {
                return new byte[0];
            }
            if (this.source instanceof byte[]) {
                return (byte[])this.source;
            }
            if (this.source instanceof ByteArrayOutputStream) {
                return ((ByteArrayOutputStream)this.source).toByteArray();
            }
            return StringTools.getBytes(this.source.toString());
        }
    }
}

