/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import org.opengts.util.FileTools;
import org.opengts.util.HTMLTools;
import org.opengts.util.MethodAction;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;
import org.opengts.util.RTKey;
import org.opengts.util.RTProperties;
import org.opengts.util.StringTools;
import org.opengts.util.ThreadPool;

public class SendMail {
    public static final String SendMailArgs_className = "org.opengts.util.SendMailArgs";
    private static Class _SendMailArgs_class = null;
    public static final String EXAMPLE_DOT_COM = "example.com";
    public static final String X_OwnerId = "X-OwnerId";
    public static final String X_AssetId = "X-AssetId";
    public static final String X_PageType = "X-PageType";
    public static final String X_Requestor = "X-Requestor";
    public static final String X_OriginatingIP = "X-OriginatingIP";
    public static final String X_EventTime = "X-EventTime";
    public static final String X_StatusCode = "X-StatusCode";
    public static final String X_AlarmRule = "X-AlarmRule";
    public static final String X_GPSLocation = "X-GPSLocation";
    public static final byte[] MAGIC_GIF_87a = HTMLTools.MAGIC_GIF_87a;
    public static final byte[] MAGIC_GIF_89a = HTMLTools.MAGIC_GIF_89a;
    public static final byte[] MAGIC_JPEG = HTMLTools.MAGIC_JPEG;
    public static final byte[] MAGIC_PNG = HTMLTools.MAGIC_PNG;
    public static final String THREAD_NONE = "none";
    public static final int _THREAD_NONE = -1;
    public static final String THREAD_CURRENT = "current";
    public static final int _THREAD_CURRENT = 0;
    public static final String THREAD_POOL = "pool";
    public static final int _THREAD_POOL = 1;
    public static final String THREAD_NEW = "new";
    public static final int _THREAD_NEW = 2;
    public static final String THREAD_DEBUG = "debug";
    public static final int _THREAD_DEBUG = 3;
    private static final RTKey PROP_ThreadPool_SendMail_ = RTKey.valueOf("SendMail.ThreadPool.");
    private static final int ThreadPool_SendMail_Size = 20;
    private static final int ThreadPool_SendMail_IdleSec = 0;
    private static final int ThreadPool_SendMail_QueSize = 0;
    private static ThreadPool ThreadPool_SendMail = new ThreadPool("SendMail", PROP_ThreadPool_SendMail_, 20, 0, 0);
    private static final String DFT_ATTACHMENT_NAME = "attachment.att";
    private static final String DFT_ATTACHMENT_TYPE = "application/octet-stream";
    private static String[] ARG_ADDR = new String[]{"addr", "a"};
    private static String[] ARG_FROM = new String[]{"from", "f"};
    private static String[] ARG_TO = new String[]{"to", "t"};
    private static String[] ARG_SUBJECT = new String[]{"subject", "subj", "s"};
    private static String[] ARG_BODY = new String[]{"body", "b"};
    private static String[] ARG_ATTACH = new String[]{"attach", "att"};

    private static Class GetSendMailArgs_class() {
        if (_SendMailArgs_class == null) {
            try {
                _SendMailArgs_class = Class.forName(SendMailArgs_className);
            }
            catch (Throwable th) {
                Print.logError("Class 'org.opengts.util.SendMailArgs': " + th, new Object[0]);
                return null;
            }
        }
        return _SendMailArgs_class;
    }

    public static boolean IsSendMailEnabled() {
        return SendMail.GetSendMailArgs_class() != null;
    }

    public static boolean IsBlankEmailAddress(String email) {
        if ((email = StringTools.trim(email)).equals("")) {
            return true;
        }
        return StringTools.endsWithIgnoreCase(email, EXAMPLE_DOT_COM);
    }

    public static void SetShowThreadModel(boolean show) {
        RTConfig.setBoolean("smtp.threadModel.show", show);
    }

    public static boolean GetShowThreadModel() {
        return RTConfig.getBoolean("smtp.threadModel.show");
    }

    public static void SetThreadModel(String model) {
        RTConfig.setString("smtp.threadModel", model);
    }

    public static void SetThreadModel(String model, boolean show) {
        SendMail.SetThreadModel(model);
        SendMail.SetShowThreadModel(false);
    }

    private static int GetThreadModel() {
        return SendMail.GetThreadModel(RTConfig.getString("smtp.threadModel"));
    }

    private static int GetThreadModel(String model) {
        if (model == null) {
            return RTConfig.isTestMode() ? 0 : 1;
        }
        if (model.equalsIgnoreCase(THREAD_NONE)) {
            return -1;
        }
        if (model.equalsIgnoreCase(THREAD_CURRENT)) {
            return 0;
        }
        if (model.equalsIgnoreCase(THREAD_NEW)) {
            return 2;
        }
        if (model.equalsIgnoreCase(THREAD_DEBUG)) {
            return 3;
        }
        return 1;
    }

    public static String getDefaultUserEmail(String mainEmail) {
        if (!SendMail.IsBlankEmailAddress(mainEmail)) {
            return StringTools.trim(mainEmail);
        }
        String email = RTConfig.getString("smtp.user.emailAddress", null);
        return !SendMail.IsBlankEmailAddress(email) ? email : null;
    }

    public boolean sendSysadmin(String subject, String msgBody) {
        SmtpProperties smtpProps = new SmtpProperties();
        String to = smtpProps.getSysadminEmail();
        if (StringTools.isBlank(to)) {
            Print.logWarn("'To' \"smtp.sysadmin.emailAddress\" not specified", new Object[0]);
            return false;
        }
        String from = smtpProps.getUserEmail();
        if (StringTools.isBlank(from)) {
            Print.logWarn("'From' \"smtp.user.emailAddress\" not specified", new Object[0]);
            return false;
        }
        return SendMail.send(from, to, subject, msgBody, smtpProps);
    }

    public static boolean send(String from, String to, String subject, String msgBody, SmtpProperties smtpProps) {
        String[] ato = to != null ? StringTools.parseStringArray(to, ',') : null;
        String[] acc = null;
        String[] abcc = null;
        return SendMail.send(null, from, ato, acc, abcc, subject, msgBody, null, smtpProps);
    }

    public static boolean send(String from, String to, String subject, String msgBody, Attachment attach, SmtpProperties smtpProps) {
        String[] ato = to != null ? StringTools.parseStringArray(to, ',') : null;
        String[] acc = null;
        String[] abcc = null;
        return SendMail.send(null, from, ato, acc, abcc, subject, msgBody, attach, smtpProps);
    }

    public static boolean send(String from, String to, String cc, String bcc, String subject, String msgBody, Attachment attach, SmtpProperties smtpProps) {
        String[] ato = to != null ? StringTools.parseStringArray(to, ',') : null;
        String[] acc = cc != null ? StringTools.parseStringArray(cc, ',') : null;
        String[] abcc = bcc != null ? StringTools.parseStringArray(bcc, ',') : null;
        return SendMail.send(null, from, ato, acc, abcc, subject, msgBody, attach, smtpProps);
    }

    public static boolean send(Properties headers, String from, String[] to, String[] cc, String[] bcc, String subject, String msgBody, Attachment attach, SmtpProperties smtpProps) {
        Args args = new Args(headers, from, to, cc, bcc, subject, msgBody, attach, smtpProps);
        SendMailRunnable smr = new SendMailRunnable(args);
        boolean showThreadModel = SendMail.GetShowThreadModel();
        switch (SendMail.GetThreadModel()) {
            case -1: {
                Print.logDebug("Skipping SendMail (disabled by 'smtp.threadModel') ...", new Object[0]);
                return false;
            }
            case 0: {
                if (showThreadModel) {
                    Print.logDebug("Running SendMail in current thread", new Object[0]);
                }
                smr.run();
                return smr.emailSent();
            }
            case 2: {
                if (showThreadModel) {
                    Print.logDebug("Starting new SendMail thread", new Object[0]);
                }
                new Thread(smr).start();
                break;
            }
            case 3: {
                Print.logDebug("Debug SendMail (email not sent)", new Object[0]);
                Print.logDebug(smr.getArgs().toString(), new Object[0]);
                return false;
            }
            default: {
                if (showThreadModel) {
                    Print.logDebug("Running SendMail in thread pool", new Object[0]);
                }
                ThreadPool_SendMail.run(smr);
            }
        }
        return true;
    }

    public static String DefaultContentType(byte[] data) {
        Object code = null;
        if (StringTools.compareEquals(data, MAGIC_GIF_87a, -1)) {
            return HTMLTools.MIME_GIF();
        }
        if (StringTools.compareEquals(data, MAGIC_GIF_89a, -1)) {
            return HTMLTools.MIME_GIF();
        }
        if (StringTools.compareEquals(data, MAGIC_JPEG, -1)) {
            return HTMLTools.MIME_JPEG();
        }
        if (StringTools.compareEquals(data, MAGIC_PNG, -1)) {
            return HTMLTools.MIME_PNG();
        }
        return DFT_ATTACHMENT_TYPE;
    }

    public static boolean validateAddresses(String addr) {
        if (StringTools.isBlank(addr)) {
            return false;
        }
        String[] addrArry = StringTools.parseStringArray(addr, ',');
        if (addrArry.length == 0) {
            return false;
        }
        for (int i = 0; i < addrArry.length; ++i) {
            String em = addrArry[i].trim();
            if (em.equals("")) {
                return false;
            }
            if (SendMail.validateAddress(em)) continue;
            return false;
        }
        return true;
    }

    public static boolean validateAddress(String addr) {
        return !StringTools.isBlank(SendMail.getEMailAddress(addr));
    }

    public static String getEMailAddress(String addr) {
        try {
            Class sendMailArgs = SendMail.GetSendMailArgs_class();
            MethodAction ma = new MethodAction((Object)sendMailArgs, "parseEMailAddress", String.class);
            return (String)ma.invoke(addr);
        }
        catch (Throwable th) {
            Print.logWarn("Unable to invoke 'parseEMailAddress': " + th, new Object[0]);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] argv) {
        RTConfig.setCommandLineArgs(argv);
        SendMail.SetThreadModel(THREAD_CURRENT);
        SmtpProperties smtpDft = new SmtpProperties();
        if (RTConfig.hasProperty(ARG_ADDR)) {
            String addr = RTConfig.getString(ARG_ADDR, "");
            Print.sysPrintln("Checking: " + addr, new Object[0]);
            Print.sysPrintln("Address : " + SendMail.getEMailAddress(addr), new Object[0]);
            Print.sysPrintln("Valid   ? " + SendMail.validateAddress(addr), new Object[0]);
            Print.sysPrintln("", new Object[0]);
            System.exit(0);
        }
        String fromAddr = RTConfig.getString(ARG_FROM, null);
        if (StringTools.isBlank(fromAddr = RTConfig.insertKeyValues(fromAddr)) || fromAddr.endsWith(EXAMPLE_DOT_COM)) {
            fromAddr = smtpDft.getUserEmail();
            if (StringTools.isBlank(fromAddr)) {
                Print.sysPrintln("ERROR: Missing 'From' address.", new Object[0]);
                Print.sysPrintln("(define \"smtp.user.emailAddress\" in 'default.conf')", new Object[0]);
                Print.sysPrintln("", new Object[0]);
                System.exit(1);
            }
        } else if (fromAddr.equalsIgnoreCase("blank") || fromAddr.equalsIgnoreCase("default")) {
            fromAddr = null;
        }
        String toAddr = RTConfig.getString(ARG_TO, null);
        if (StringTools.isBlank(toAddr = RTConfig.insertKeyValues(toAddr)) || toAddr.endsWith(EXAMPLE_DOT_COM)) {
            Print.sysPrintln("Missing 'To' address", new Object[0]);
            Print.sysPrintln("(specify '-to=<emailAddress>' option on command-line)", new Object[0]);
            Print.sysPrintln("", new Object[0]);
            System.exit(1);
        }
        String subject = RTConfig.getString(ARG_SUBJECT, "Test EMail");
        subject = RTConfig.insertKeyValues(subject);
        String body = RTConfig.getString(ARG_BODY, "");
        if (body.startsWith("file:")) {
            InputStream uis = null;
            try {
                URL url = new URL(body);
                uis = url.openStream();
                byte[] b = FileTools.readStream(uis);
                body = StringTools.toStringValue(b);
            }
            catch (Throwable th) {
                Print.sysPrintln("ERROR: Error reading body file URL - " + th, new Object[0]);
                System.exit(99);
            }
            finally {
                try {
                    uis.close();
                }
                catch (Throwable th) {}
            }
        }
        body = RTConfig.insertKeyValues(body);
        body = StringTools.replace(body, "\\n", "\n");
        Attachment attach = null;
        if (RTConfig.hasProperty(ARG_ATTACH)) {
            File attachFile = RTConfig.getFile(ARG_ATTACH, null);
            if (attachFile != null && attachFile.isFile()) {
                FileInputStream fis = null;
                try {
                    fis = new FileInputStream(attachFile);
                    byte[] b = FileTools.readStream(fis);
                    String name = attachFile.getName();
                    String ext = FileTools.getExtension(attachFile);
                    String type = HTMLTools.getMimeTypeFromExtension(ext, null);
                    if (type == null) {
                        type = SendMail.DefaultContentType(b);
                    }
                    attach = new Attachment(b, name, type);
                }
                catch (Throwable th) {
                    Print.sysPrintln("ERROR: Unable to load attachment - " + th, new Object[0]);
                }
                finally {
                    try {
                        ((InputStream)fis).close();
                    }
                    catch (Throwable th) {}
                }
            } else {
                Print.sysPrintln("ERROR: Specified Attachment does not exist - " + attachFile, new Object[0]);
                System.exit(99);
            }
        }
        Print.sysPrintln("Sending EMail:", new Object[0]);
        Print.sysPrintln("   From   : " + fromAddr, new Object[0]);
        Print.sysPrintln("   To     : " + toAddr, new Object[0]);
        Print.sysPrintln("   Subject: " + subject, new Object[0]);
        if (SendMail.send(fromAddr, toAddr, subject, body, attach, smtpDft)) {
            Print.sysPrintln("... sent", new Object[0]);
        } else {
            Print.sysPrintln("... Unable to send EMail", new Object[0]);
        }
        Print.sysPrintln("", new Object[0]);
        System.exit(0);
    }

    public static class SmtpProperties {
        private RTProperties smtpProps = null;

        public SmtpProperties() {
            this(null);
        }

        public SmtpProperties(RTProperties rtp) {
            this.smtpProps = rtp != null ? rtp : new RTProperties();
        }

        public void setDebug(boolean V) {
            String K = "smtp.debug";
            this.smtpProps.setBoolean(K, V);
        }

        public boolean getDebug() {
            String K = "smtp.debug";
            boolean V = this.smtpProps.hasProperty(K) ? this.smtpProps.getBoolean(K, false) : RTConfig.getBoolean(K);
            return V;
        }

        public void setHost(String V) {
            String K = "smtp.host";
            this.smtpProps.setString(K, StringTools.trim(V));
        }

        public String getHost() {
            String V;
            String K = "smtp.host";
            String string = V = this.smtpProps.hasProperty(K) ? this.smtpProps.getString(K, null) : null;
            if (StringTools.isBlank(V)) {
                V = RTConfig.getString(K);
            }
            if (StringTools.endsWithIgnoreCase(V, SendMail.EXAMPLE_DOT_COM)) {
                V = null;
            }
            return StringTools.trim(V);
        }

        public void setPort(int V) {
            String K = "smtp.port";
            this.smtpProps.setInt(K, V > 0 ? V : 0);
        }

        public int getPort() {
            int V;
            String K = "smtp.port";
            int n = V = this.smtpProps.hasProperty(K) ? this.smtpProps.getInt(K, 0) : 0;
            if (V <= 0) {
                V = RTConfig.getInt(K, 25);
            }
            return V;
        }

        public void setUser(String V) {
            String K = "smtp.user";
            this.smtpProps.setString(K, StringTools.trim(V));
        }

        public String getUser() {
            String V;
            String K = "smtp.user";
            String string = V = this.smtpProps.hasProperty(K) ? this.smtpProps.getString(K, null) : null;
            if (StringTools.isBlank(V)) {
                V = RTConfig.getString(K);
            }
            return StringTools.trim(V);
        }

        public void setUserEmail(String V) {
            String K = "smtp.user.emailAddress";
            this.smtpProps.setString(K, StringTools.trim(V));
        }

        public String getUserEmail() {
            String V;
            String K = "smtp.user.emailAddress";
            String string = V = this.smtpProps.hasProperty(K) ? this.smtpProps.getString(K, null) : null;
            if ((StringTools.isBlank(V) || StringTools.endsWithIgnoreCase(V, SendMail.EXAMPLE_DOT_COM)) && StringTools.endsWithIgnoreCase(V = RTConfig.getString(K), SendMail.EXAMPLE_DOT_COM)) {
                V = null;
            }
            return StringTools.trim(V);
        }

        public String getUserEmail(String mainEmail) {
            return !SendMail.IsBlankEmailAddress(mainEmail) ? StringTools.trim(mainEmail) : this.getUserEmail();
        }

        public void setPassword(String V) {
            String K = "smtp.password";
            this.smtpProps.setString(K, V);
        }

        public String getPassword() {
            String V;
            String K = "smtp.password";
            String string = V = this.smtpProps.hasProperty(K) ? this.smtpProps.getString(K, null) : null;
            if (V == null) {
                V = RTConfig.getString(K);
            }
            return V;
        }

        public void setEnableSSL(String V) {
            String K = "smtp.enableSSL";
            this.smtpProps.setString(K, StringTools.trim(V));
        }

        public String getEnableSSL() {
            String V;
            String K = "smtp.enableSSL";
            String string = V = this.smtpProps.hasProperty(K) ? this.smtpProps.getString(K, null) : null;
            if (StringTools.isBlank(V)) {
                V = RTConfig.getString(K);
            }
            return StringTools.trim(V);
        }

        public void setEnableTLS(String V) {
            String K = "smtp.enableTLS";
            this.smtpProps.setString(K, StringTools.trim(V));
        }

        public String getEnableTLS() {
            String V;
            String K = "smtp.enableTLS";
            String string = V = this.smtpProps.hasProperty(K) ? this.smtpProps.getString(K, null) : null;
            if (StringTools.isBlank(V)) {
                V = RTConfig.getString(K);
            }
            return StringTools.trim(V);
        }

        public void setSysadminEmail(String V) {
            String K = "smtp.sysadmin.emailAddress";
            this.smtpProps.setString(K, StringTools.trim(V));
        }

        public String getSysadminEmail() {
            String V;
            String K = "smtp.sysadmin.emailAddress";
            String string = V = this.smtpProps.hasProperty(K) ? this.smtpProps.getString(K, null) : null;
            if ((StringTools.isBlank(V) || StringTools.endsWithIgnoreCase(V, SendMail.EXAMPLE_DOT_COM)) && StringTools.endsWithIgnoreCase(V = RTConfig.getString(K), SendMail.EXAMPLE_DOT_COM)) {
                V = null;
            }
            return StringTools.trim(V);
        }

        public String toString() {
            return this.smtpProps.toString();
        }

        public void printProperties(String msg) {
            this.smtpProps.printProperties(msg);
        }
    }

    public static class Args {
        private Properties headers = null;
        private String from = null;
        private String[] to = null;
        private String[] cc = null;
        private String[] bcc = null;
        private String subject = null;
        private String msgBody = null;
        private Attachment attachment = null;
        private SmtpProperties smtpProps = null;

        public Args(Properties headers, String from, String[] to, String[] cc, String[] bcc, String subject, String msgBody, Attachment attach, SmtpProperties smtpProps) {
            this.headers = headers != null ? headers : new Properties();
            this.from = from;
            this.to = to;
            this.cc = cc;
            this.bcc = bcc;
            this.subject = subject;
            this.msgBody = msgBody;
            this.attachment = attach;
            this.smtpProps = smtpProps != null ? smtpProps : new SmtpProperties();
        }

        public Properties getHeaders() {
            return this.headers;
        }

        public String getFrom() {
            return this.from != null ? this.from : "";
        }

        public String[] getTo() {
            return this.to != null ? this.to : new String[]{};
        }

        public String[] getCc() {
            return this.cc != null ? this.cc : new String[]{};
        }

        public String[] getBcc() {
            return this.bcc != null ? this.bcc : new String[]{};
        }

        public String getSubject() {
            return this.subject != null ? this.subject : "";
        }

        public String getBody() {
            return this.msgBody != null ? this.msgBody : "";
        }

        public Attachment getAttachment() {
            return this.attachment;
        }

        public SmtpProperties getSmtpProperties() {
            return this.smtpProps;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer().append("\n");
            Properties headers = this.getHeaders();
            if (headers != null && !headers.isEmpty()) {
                for (String string : headers.keySet()) {
                    String v = headers.getProperty(string);
                    if (v == null) continue;
                    sb.append(string).append(": ");
                    sb.append(v).append("\n");
                }
            }
            sb.append("From: ").append(this.getFrom()).append("\n");
            sb.append("To: ").append(StringTools.encodeArray(this.getTo())).append("\n");
            sb.append("Subject: ").append(this.getSubject()).append("\n");
            sb.append(this.getBody()).append("\n");
            Attachment attach = this.getAttachment();
            if (attach != null && attach.getSize() > 0) {
                sb.append("---- attachment ----\n");
                sb.append(StringTools.toHexString(attach.getBytes())).append("\n");
            }
            sb.append("\n");
            return sb.toString();
        }
    }

    public static class Attachment {
        private byte[] data = null;
        private String name = "attachment.att";
        private String type = "application/octet-stream";

        public Attachment(byte[] data) {
            this(data, null, null);
        }

        public Attachment(byte[] data, String name, String type) {
            this.data = data;
            this.name = name != null && !name.equals("") ? name : SendMail.DFT_ATTACHMENT_NAME;
            this.type = type != null && !type.equals("") ? type : SendMail.DFT_ATTACHMENT_TYPE;
        }

        public byte[] getBytes() {
            return this.data;
        }

        public int getSize() {
            return this.data != null ? this.data.length : 0;
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }
    }

    private static class SendMailRunnable
    implements Runnable {
        private Args args = null;
        private boolean emailSent = false;

        public SendMailRunnable(Args args) {
            this.args = args;
            this.emailSent = false;
        }

        public Args getArgs() {
            return this.args;
        }

        @Override
        public void run() {
            if (this.args != null) {
                try {
                    Class sendMailArgs = SendMail.GetSendMailArgs_class();
                    MethodAction ma = new MethodAction((Object)sendMailArgs, "send", Args.class);
                    this.emailSent = (Boolean)ma.invoke(this.args);
                }
                catch (Throwable th) {
                    Print.logDebug("Email 'send' failed: " + th, new Object[0]);
                    this.emailSent = false;
                }
            }
        }

        public boolean emailSent() {
            return this.emailSent;
        }
    }
}

