/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.util;

import java.io.IOException;
import java.io.OutputStream;
import java.net.BindException;
import java.net.InetAddress;
import org.opengts.util.AbstractClientPacketHandler;
import org.opengts.util.CachedLogOutputStream;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;
import org.opengts.util.ServerSocketThread;
import org.opengts.util.StringTools;

public class RemoteLogServer {
    public static final String VERSION = "0.1.1";
    public static final String LOG_OUTPUT_BEGIN = "<LogOutput>\n";
    public static final String LOG_OUTPUT_END = "</LogOutput>\n";
    private CachedLogOutputStream logOutputStream = null;
    private InetAddress bindAddr = null;
    private int listenPort = 0;
    private ServerSocketThread logSST = null;
    private String header = null;
    private static CachedLogOutputStream testLogStream = null;

    public static InetAddress GetLocalBindAddress(String bindHost) {
        InetAddress bindAddr = null;
        if (!StringTools.isBlank(bindHost)) {
            try {
                bindAddr = InetAddress.getByName(bindHost);
                if (!ServerSocketThread.isLocalInterfaceAddress(bindAddr)) {
                    System.err.println("ERROR: BindAddress not found in NetworkInterface - " + bindAddr);
                }
            }
            catch (IOException ioe) {
                System.err.println("ERROR: BindAddress not found - " + bindHost);
                bindAddr = null;
            }
        }
        return bindAddr;
    }

    public RemoteLogServer(int port, CachedLogOutputStream clos) {
        this((InetAddress)null, port, clos);
    }

    public RemoteLogServer(String bindHost, int port, CachedLogOutputStream clos) {
        this(RemoteLogServer.GetLocalBindAddress(bindHost), port, clos);
    }

    public RemoteLogServer(InetAddress bindAddr, int port, CachedLogOutputStream clos) {
        if (port <= 0) {
            throw new IllegalArgumentException("Invalid port specification: " + port);
        }
        if (clos == null) {
            throw new IllegalArgumentException("Specified CachedLogOutputStream is null");
        }
        this.bindAddr = bindAddr;
        this.listenPort = port;
        this.logOutputStream = clos;
    }

    public InetAddress getBindAddress() {
        return this.bindAddr;
    }

    public int getListenPort() {
        return this.listenPort;
    }

    public void setHeader(String h) {
        this.header = h;
    }

    public String getHeader() {
        return this.header;
    }

    public boolean hasHeader() {
        return !StringTools.isBlank(this.header);
    }

    public boolean startServer() {
        if (this.logSST != null) {
            Print.sysPrintln("ERROR: RemoteLogServer already started", new Object[0]);
            return false;
        }
        InetAddress baddr = this.getBindAddress();
        String bhost = baddr != null ? baddr.getHostName() : "";
        int lport = this.getListenPort();
        try {
            this.logSST = new ServerSocketThread(baddr, lport);
            this.logSST.setTextPackets(true);
            this.logSST.setPrompt(">> ");
            this.logSST.setBackspaceChar(new int[]{8});
            this.logSST.setLineTerminatorChar(new int[]{13, 10});
            this.logSST.setIgnoreChar(new int[]{10});
            this.logSST.setMaximumPacketLength(1000);
            this.logSST.setMinimumPacketLength(1);
            this.logSST.setIdleTimeout(600000L);
            this.logSST.setPacketTimeout(600000L);
            this.logSST.setSessionTimeout(1200000L);
            this.logSST.setLingerTimeoutSec(0);
            this.logSST.setTerminateOnTimeout(true);
            this.logSST.setClientPacketHandler(new RemoteLogHandler());
            this.logSST.setLoggingEnabled(false);
        }
        catch (BindException be) {
            String msg = be.getMessage();
            Print.sysPrintln("Unable to bind to '" + bhost + ":" + lport + "' - " + msg, new Object[0]);
            return false;
        }
        catch (IOException ioe) {
            if (ioe.getCause() instanceof BindException) {
                String msg = ioe.getCause().getMessage();
                Print.sysPrintln("Unable to bind to '" + bhost + ":" + lport + "' - " + msg, new Object[0]);
            } else {
                Print.sysPrintln("Error initializing ServerSocketThread: " + ioe, new Object[0]);
            }
            return false;
        }
        catch (Throwable th) {
            Print.sysPrintln("Unknown error: " + th, new Object[0]);
            th.printStackTrace();
            return false;
        }
        Print.sysPrintln("Starting RemoteLogServer listener - '" + bhost + ":" + lport + "'", new Object[0]);
        this.logSST.start();
        return true;
    }

    public static CachedLogOutputStream GetCachedLogOutputStream(boolean allowTest) {
        OutputStream out = Print.getRedirectedOutputStream();
        if (out instanceof CachedLogOutputStream) {
            return (CachedLogOutputStream)out;
        }
        if (testLogStream == null && allowTest) {
            testLogStream = new CachedLogOutputStream();
        }
        return testLogStream;
    }

    public static void main(String[] argv) {
        RTConfig.setCommandLineArgs(argv);
        if (!Print.isRemoteLogging()) {
            String host = RTConfig.getString("host", null);
            int port = RTConfig.getInt("port", 12345);
            Print.closeRedirectedOutputStream();
            Print.setRedirectedOutput(new CachedLogOutputStream());
            CachedLogOutputStream clos = RemoteLogServer.GetCachedLogOutputStream(true);
            if (clos == null) {
                Print.sysPrintln("'Print' does not define CachedLogOutputStream", new Object[0]);
            }
            RemoteLogServer rls = new RemoteLogServer(host, port, clos);
            rls.setHeader("RemoteLogServer test [Version 0.1.1]");
            rls.startServer();
        } else {
            System.out.println("RemoteLogServer already running ...");
        }
        Print.sysPrintln("Waiting ...", new Object[0]);
    }

    public class RemoteLogHandler
    extends AbstractClientPacketHandler {
        public RemoteLogHandler() {
            super.setTerminateSession(false);
        }

        @Override
        public byte[] getInitialPacket() {
            if (RemoteLogServer.this.hasHeader()) {
                String h = RemoteLogServer.this.getHeader();
                StringBuffer sb = new StringBuffer();
                sb.append("-------------------------------------------------\n");
                sb.append(h);
                if (!h.endsWith("\n")) {
                    sb.append("\n");
                }
                sb.append("-------------------------------------------------\n");
                return sb.toString().getBytes();
            }
            return null;
        }

        @Override
        public void sessionStarted(InetAddress inetAddr, boolean isTCP, boolean isText) {
            super.sessionStarted(inetAddr, isTCP, isText);
            Print.sysPrintln("Session started", new Object[0]);
        }

        @Override
        public void sessionTerminated(Throwable err, long readCount, long writeCount) {
            super.sessionTerminated(err, readCount, writeCount);
            Print.sysPrintln("Session terminated", new Object[0]);
        }

        @Override
        public int getActualPacketLength(byte[] packet, int packetLen) {
            return -1;
        }

        @Override
        public byte[] getHandlePacket(byte[] pkt) throws Exception {
            try {
                return this._getHandlePacket(pkt);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
            catch (Error er) {
                er.printStackTrace();
                throw er;
            }
        }

        private byte[] _getHandlePacket(byte[] pkt) throws Exception {
            String s = StringTools.toStringValue(pkt).trim();
            CachedLogOutputStream clos = RemoteLogServer.GetCachedLogOutputStream(false);
            if (clos == null) {
                return "ERROR: CachedLogOutputStream is not defined.".getBytes();
            }
            String cmd = StringTools.toStringValue(pkt).trim();
            if (cmd.equals("")) {
                return null;
            }
            if (cmd.equalsIgnoreCase("get")) {
                if (clos.size() > 0) {
                    String r;
                    StringBuffer sb = new StringBuffer();
                    sb.append(RemoteLogServer.LOG_OUTPUT_BEGIN);
                    while ((r = clos.readLine()) != null) {
                        sb.append(r);
                    }
                    sb.append(RemoteLogServer.LOG_OUTPUT_END);
                    return sb.toString().getBytes();
                }
                return null;
            }
            if (cmd.equalsIgnoreCase("reset") || cmd.equalsIgnoreCase("clear")) {
                clos.reset();
                return "Reset\n\n".getBytes();
            }
            if (StringTools.startsWithIgnoreCase(cmd, "sample")) {
                int p = cmd.indexOf(" ");
                final int count = p < 0 ? 3 : StringTools.parseInt(cmd.substring(p + 1), 3);
                Runnable sampleThread = new Runnable(){

                    @Override
                    public void run() {
                        int C = count < 30 ? count : 30;
                        for (int i = 0; i < C; ++i) {
                            switch (i % 3) {
                                case 0: {
                                    Print.logInfo(i + "] Sample INFO message", new Object[0]);
                                    break;
                                }
                                case 1: {
                                    Print.logWarn(i + "] Sample WARN message", new Object[0]);
                                    break;
                                }
                                case 2: {
                                    Print.logError(i + "] Sample ERROR message", new Object[0]);
                                }
                            }
                            try {
                                Thread.sleep(1000L);
                                continue;
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                    }
                };
                new Thread(sampleThread).start();
                return "Loading log samples\n\n".getBytes();
            }
            if (StringTools.startsWithIgnoreCase(cmd, "prompt")) {
                int p = cmd.indexOf(" ");
                if (p < 0) {
                    this.setPromptEnabled(true);
                    return null;
                }
                String state = cmd.substring(p + 1).trim();
                boolean enabled = StringTools.parseBoolean(state, true);
                this.setPromptEnabled(enabled);
                return null;
            }
            return ("Unknown Command: " + cmd + "\n\n").getBytes();
        }
    }
}

