/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import org.opengts.util.FileTools;
import org.opengts.util.ListTools;
import org.opengts.util.OrderedMap;
import org.opengts.util.OrderedSet;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;
import org.opengts.util.RTKey;
import org.opengts.util.StringTools;

public class RTProperties
implements Cloneable,
StringTools.KeyValueMap,
RTConfig.PropertySetter,
RTConfig.PropertyGetter {
    public static final String PROP_usePropertiesLoad = "RTConfig.usePropertiesLoad";
    public static final String PROP_removeInlineComments = "RTConfig.removeInlineComments";
    private static boolean USE_PROPERTIES_LOADER = false;
    private static boolean REMOVE_INLINE_COMMENTS = false;
    private static final String INLINE_COMMENT_SEQUENCE = " ##";
    private static final String INCLUDE_PROTOCOL_FILE = "file";
    private static final String INCLUDE_PROTOCOL_HTTP = "http";
    private static final String INCLUDE_PROTOCOL_HTTPS = "https";
    public static final String NameStart = "[";
    public static final String NameEnd = "]";
    public static final char[] KeyValSeparatorChars = StringTools.KeyValSeparatorChars;
    public static final char PropertySeparatorChar = ' ';
    public static final char ARRAY_DELIM = ',';
    public static final String KEY_START_DELIMITER = "${";
    public static final String KEY_END_DELIMITER = "}";
    public static final String KEY_DFT_DELIMITER = "=";
    public static final int KEY_MAX_RECURSION = 6;
    public static final int KEY_REPLACEMENT_NONE = 0;
    public static final int KEY_REPLACEMENT_LOCAL = 1;
    public static final int KEY_REPLACEMENT_GLOBAL = 2;
    private static final boolean DEFAULT_TRUE_IF_BOOLEAN_STRING_EMPTY = true;
    public static final String KEYVAL_PREFIX = "-";
    public static final char KEYVAL_PREFIX_CHAR = '-';
    public static final char KEYVAL_SEPARATOR_CHAR_1 = '=';
    public static final char KEYVAL_SEPARATOR_CHAR_2 = ':';
    public boolean DEBUG = false;
    private String cfgDirRoot = null;
    private Map<Object, Object> cfgProperties = null;
    private boolean ignoreCase = false;
    private boolean allowBlankValues = true;
    private char propertySeparator = (char)32;
    private char[] keyValueSeparators = KeyValSeparatorChars;
    private int keyReplacementMode = 0;
    private int nextCmdLineArg = -1;
    private boolean enableConfigLogMessages = true;
    private boolean enableIncludes = true;
    protected static Class<OrderedMap> DefaultMapClass = OrderedMap.class;
    private List<PropertyChangeListener> changeListeners = null;
    private static final String KEY_INCLUDE_URL = "%include";
    private static final String KEY_INCLUDE_URL_OPT = "%include?";
    private static final String KEY_LOG = "%log";
    private static final String KEY_DEBUGMODE = "%debugMode";
    private static final String KEY_IF = "%if";
    private static final String KEY_ELSE = "%else";
    private static final String KEY_ENDIF = "%endif";
    private static final int MAX_INCLUDE_RECURSION = 3;

    public static void setRemoveInlineComments(boolean ric) {
        REMOVE_INLINE_COMMENTS = ric;
    }

    private static boolean IsXML(URL url) {
        return url != null && StringTools.endsWithIgnoreCase(url.toString(), ".xml");
    }

    private int _indexOfKeyValSeparator(String kv) {
        for (int i = 0; i < kv.length(); ++i) {
            char ch = kv.charAt(i);
            if (ch != '=' && ch != ':') continue;
            return i;
        }
        return -1;
    }

    public RTProperties(Map<?, ?> map) {
        this.setBackingProperties(map);
    }

    public RTProperties() {
        this((Map)null);
    }

    public RTProperties(String props) {
        this();
        this.setProperties(props, true);
    }

    public RTProperties(String props, boolean inclName) {
        this();
        this.setProperties(props, inclName);
    }

    public RTProperties(String props, char propSep) {
        this();
        this.setPropertySeparatorChar(propSep);
        this.setProperties(props, true);
    }

    public RTProperties(String props, char propSep, char[] keyValSep) {
        this();
        this.setPropertySeparatorChar(propSep);
        this.setKeyValueSeparatorChars(keyValSep);
        this.setProperties(props, true);
    }

    public RTProperties(String[] argv) {
        this();
        if (argv != null) {
            for (int i = 0; i < argv.length; ++i) {
                String val;
                if (StringTools.isBlank(argv[i])) continue;
                String kv = argv[i];
                if (kv.startsWith("'") && kv.endsWith("'")) {
                    kv = kv.substring(1, kv.length() - 1);
                } else if (kv.startsWith("\"") && kv.endsWith("\"")) {
                    kv = kv.substring(1, kv.length() - 1);
                }
                int p = this._indexOfKeyValSeparator(kv);
                String key = p >= 0 ? kv.substring(0, p).trim() : kv;
                String string = val = p >= 0 ? kv.substring(p + 1).trim() : "";
                if (key.startsWith(KEYVAL_PREFIX)) {
                    while (key.startsWith(KEYVAL_PREFIX)) {
                        key = key.substring(1);
                    }
                    if (p < 0) {
                        if (key.equals("")) {
                            if (i >= argv.length + 1) break;
                            this.nextCmdLineArg = i + 1;
                            break;
                        }
                        if (i + 1 < argv.length && !argv[i + 1].startsWith(KEYVAL_PREFIX)) {
                            ++i;
                            val = kv;
                        }
                    }
                }
                if (key.equals("")) {
                    Print.logWarn("Ignoring invalid key argument: '%s'", kv);
                    continue;
                }
                this.setString(key, val);
            }
        }
    }

    public RTProperties(File cfgFile) {
        this(RTProperties.CreateDefaultMap());
        if (cfgFile != null && !StringTools.isBlank(cfgFile.toString())) {
            if (cfgFile.isFile()) {
                if (!RTConfig.getBoolean("rtquiet", true)) {
                    Print.logInfo("Loading config file: " + cfgFile, new Object[0]);
                }
                try {
                    this.setProperties(cfgFile, true);
                }
                catch (IOException ioe) {
                    Print.logError("Unable to load config file: " + cfgFile + " [" + ioe + NameEnd, new Object[0]);
                }
            } else {
                Print.logError("Config file doesn't exist: " + cfgFile, new Object[0]);
            }
        }
    }

    public RTProperties(URL cfgURL) {
        this(RTProperties.CreateDefaultMap());
        if (cfgURL != null) {
            if (!RTConfig.getBoolean("rtquiet", true)) {
                Print.logInfo("Loading config file: " + cfgURL, new Object[0]);
            }
            try {
                this.setProperties(cfgURL, true);
            }
            catch (IOException ioe) {
                Print.logError("Unable to load config file: " + cfgURL + " [" + ioe + NameEnd, new Object[0]);
            }
        }
    }

    public RTProperties(InputStream in) {
        this(RTProperties.CreateDefaultMap());
        if (in != null) {
            try {
                this.setProperties(in, true);
            }
            catch (IOException ioe) {
                Print.logError("Unable to load InputStream [" + ioe + NameEnd, new Object[0]);
            }
        }
    }

    public RTProperties(RTProperties rtp) {
        this();
        this.setProperties(rtp, true);
    }

    public Object clone() {
        return new RTProperties(this);
    }

    public boolean getIgnoreKeyCase() {
        return this.ignoreCase;
    }

    public void setIgnoreKeyCase(boolean ignCase) {
        this.ignoreCase = ignCase;
        Map<Object, Object> props = this.getProperties();
        if (props instanceof OrderedMap) {
            ((OrderedMap)props).setIgnoreCase(this.ignoreCase);
        } else if (ignCase) {
            Print.logWarn("Backing map is not an 'OrderedMap', case insensitive keys not in effect", new Object[0]);
        }
    }

    public boolean getAllowBlankValues() {
        return this.allowBlankValues;
    }

    public void setAllowBlankValues(boolean allowBlank) {
        this.allowBlankValues = allowBlank;
        if (!allowBlank) {
            // empty if block
        }
    }

    public boolean getIncludesEnabled() {
        return this.enableIncludes;
    }

    public void setIncludesEnabled(boolean enable) {
        this.enableIncludes = enable;
    }

    public boolean getConfigLogMessagesEnabled() {
        return this.enableConfigLogMessages;
    }

    public void setConfigLogMessagesEnabled(boolean enable) {
        this.enableConfigLogMessages = enable;
    }

    public String getName() {
        return this.getString("%name", "");
    }

    public void setName(String name) {
        this.setString("%name", name);
    }

    public void checkDefaults() {
        Iterator<?> i = this.keyIterator();
        while (i.hasNext()) {
            String key = i.next().toString();
            if (RTKey.hasDefault(key)) continue;
            Print.logDebug("No default for key: " + key, new Object[0]);
        }
    }

    protected static Map<Object, Object> CreateDefaultMap() {
        return new OrderedMap<Object, Object>();
    }

    public int getNextCommandLineArgumentIndex() {
        return this.nextCmdLineArg;
    }

    public boolean validateKeyAttributes(String[] keyAttr, boolean printErrors) {
        if (ListTools.isEmpty(keyAttr)) {
            return true;
        }
        int error = 0;
        HashSet argKeys = new HashSet(this.getPropertyKeys());
        block6: for (int i = 0; i < keyAttr.length; ++i) {
            String[] aKey = null;
            boolean mandatory = false;
            int valType = 0;
            int p = this._indexOfKeyValSeparator(keyAttr[i]);
            if (p != 0) {
                if (p < 0) {
                    aKey = StringTools.split(keyAttr[i], ',');
                    mandatory = false;
                    valType = 0;
                } else {
                    aKey = StringTools.split(keyAttr[i].substring(0, p), ',');
                    mandatory = keyAttr[i].charAt(p) == '=';
                    String[] attr = StringTools.split(keyAttr[i].substring(p + 1), ',');
                    for (int a = 0; a < attr.length; ++a) {
                        if (attr[a].equals("m")) {
                            mandatory = true;
                            continue;
                        }
                        if (attr[a].equals("o")) {
                            mandatory = false;
                            continue;
                        }
                        if (attr[a].equals("s")) {
                            valType = 0;
                            continue;
                        }
                        if (attr[a].equals("i")) {
                            valType = 1;
                            continue;
                        }
                        if (attr[a].equals("f")) {
                            valType = 2;
                            continue;
                        }
                        if (attr[a].equals("d")) {
                            valType = 2;
                            continue;
                        }
                        if (!attr[a].equals("b")) continue;
                        valType = 3;
                    }
                }
            }
            boolean keyFound = false;
            String keyStr = StringTools.join(aKey, ',');
            if (ListTools.isEmpty(aKey)) continue;
            int found = 0;
            for (int k = 0; k < aKey.length; ++k) {
                if (this.hasProperty(aKey[k])) {
                    ++found;
                }
                argKeys.remove(aKey[k]);
            }
            if (found > 1) {
                if (printErrors) {
                    Print.sysPrintln("ERROR: Multiple values found for keys: " + keyStr, new Object[0]);
                }
                ++error;
            }
            keyFound = found > 0;
            String keyValue = this.getString(aKey, null);
            if (StringTools.isBlank(keyValue)) {
                if (!mandatory || keyFound && valType == 3) continue;
                if (printErrors) {
                    Print.sysPrintln("ERROR: Mandatory key not specified: " + keyStr, new Object[0]);
                }
                ++error;
                continue;
            }
            String firstKey = this.getFirstDefinedKey(aKey);
            switch (valType) {
                case 0: {
                    continue block6;
                }
                case 1: {
                    if (StringTools.isLong(keyValue, true)) continue block6;
                    if (printErrors) {
                        Print.sysPrintln("ERROR: Invalid value for key (i): " + firstKey, new Object[0]);
                    }
                    ++error;
                    continue block6;
                }
                case 2: {
                    if (StringTools.isDouble(keyValue, true)) continue block6;
                    if (printErrors) {
                        Print.sysPrintln("ERROR: Invalid value for key (f): " + firstKey, new Object[0]);
                    }
                    ++error;
                    continue block6;
                }
                case 3: {
                    if (StringTools.isBoolean(keyValue, true)) continue block6;
                    if (printErrors) {
                        Print.sysPrintln("ERROR: Invalid value for key (b): " + firstKey, new Object[0]);
                    }
                    ++error;
                }
            }
        }
        if (!argKeys.isEmpty()) {
            boolean UNRECOGNIZED_ARGUMENT_ERROR = false;
            for (Object key : argKeys) {
                String ks = key.toString();
                if (ks.startsWith("$")) continue;
                if (UNRECOGNIZED_ARGUMENT_ERROR) {
                    if (printErrors) {
                        Print.sysPrintln("ERROR: Unrecognized argument specified: " + ks, new Object[0]);
                    }
                    ++error;
                    continue;
                }
                if (!printErrors) continue;
                Print.sysPrintln("WARNING: Unrecognized argument specified: " + ks, new Object[0]);
            }
        }
        return error == 0;
    }

    public void addChangeListener(PropertyChangeListener pcl) {
        if (this.changeListeners == null) {
            this.changeListeners = new Vector<PropertyChangeListener>();
        }
        this.changeListeners.add(pcl);
    }

    public void removeChangeListener(PropertyChangeListener pcl) {
        if (this.changeListeners != null) {
            this.changeListeners.remove(pcl);
        }
    }

    protected void firePropertyChanged(Object key, Object oldVal) {
        if (this.changeListeners != null) {
            Object newVal = this.getProperties().get(key);
            PropertyChangeEvent pce = new PropertyChangeEvent(key, oldVal, newVal);
            Iterator<PropertyChangeListener> i = this.changeListeners.iterator();
            while (i.hasNext()) {
                i.next().propertyChange(pce);
            }
        }
    }

    public void setBackingProperties(Map<?, ?> map) {
        this.cfgProperties = map;
    }

    public Map<Object, Object> getProperties() {
        if (this.cfgProperties == null) {
            this.cfgProperties = RTProperties.CreateDefaultMap();
            if (this.cfgProperties instanceof OrderedMap) {
                ((OrderedMap)this.cfgProperties).setIgnoreCase(this.ignoreCase);
            }
        }
        return this.cfgProperties;
    }

    protected Map<String, String> getStringProperties() {
        Map<Object, Object> objProps = this.getProperties();
        return objProps;
    }

    protected Map<Object, Object> getImmutableProperties() {
        final Map<Object, Object> props = this.getProperties();
        return new Map<Object, Object>(){

            @Override
            public boolean containsKey(Object K) {
                return props.containsKey(K);
            }

            @Override
            public boolean containsValue(Object K) {
                return props.containsValue(K);
            }

            @Override
            public Object get(Object K) {
                return props.get(K);
            }

            public int hasCode() {
                return ((Object)props).hashCode();
            }

            @Override
            public boolean isEmpty() {
                return props.isEmpty();
            }

            @Override
            public int size() {
                return props.size();
            }

            @Override
            public Set<Object> keySet() {
                return new AbstractSet<Object>(){

                    @Override
                    public int size() {
                        return props.size();
                    }

                    @Override
                    public Iterator<Object> iterator() {
                        final Iterator i = props.keySet().iterator();
                        return new Iterator<Object>(){

                            @Override
                            public boolean hasNext() {
                                return i.hasNext();
                            }

                            @Override
                            public Object next() {
                                return i.next();
                            }

                            @Override
                            public void remove() {
                                throw new UnsupportedOperationException();
                            }
                        };
                    }
                };
            }

            @Override
            public Set<Map.Entry<Object, Object>> entrySet() {
                return new AbstractSet<Map.Entry<Object, Object>>(){

                    @Override
                    public int size() {
                        return props.entrySet().size();
                    }

                    @Override
                    public Iterator<Map.Entry<Object, Object>> iterator() {
                        final Iterator i = props.entrySet().iterator();
                        return new Iterator<Map.Entry<Object, Object>>(){

                            @Override
                            public boolean hasNext() {
                                return i.hasNext();
                            }

                            @Override
                            public Map.Entry<Object, Object> next() {
                                final Map.Entry me = (Map.Entry)i.next();
                                return new Map.Entry<Object, Object>(){

                                    @Override
                                    public boolean equals(Object o) {
                                        return ((Object)me).equals(o);
                                    }

                                    @Override
                                    public Object getKey() {
                                        return me.getKey();
                                    }

                                    @Override
                                    public Object getValue() {
                                        return me.getValue();
                                    }

                                    @Override
                                    public int hashCode() {
                                        return ((Object)me).hashCode();
                                    }

                                    @Override
                                    public Object setValue(Object value) {
                                        throw new UnsupportedOperationException();
                                    }
                                };
                            }

                            @Override
                            public void remove() {
                                throw new UnsupportedOperationException();
                            }
                        };
                    }
                };
            }

            @Override
            public Collection<Object> values() {
                final Collection c = props.values();
                return new AbstractCollection<Object>(){

                    @Override
                    public int size() {
                        return c.size();
                    }

                    @Override
                    public Iterator<Object> iterator() {
                        final Iterator i = c.iterator();
                        return new Iterator<Object>(){

                            @Override
                            public boolean hasNext() {
                                return i.hasNext();
                            }

                            @Override
                            public Object next() {
                                return i.next();
                            }

                            @Override
                            public void remove() {
                                throw new UnsupportedOperationException();
                            }
                        };
                    }
                };
            }

            @Override
            public void clear() {
                throw new UnsupportedOperationException();
            }

            @Override
            public String remove(Object K) {
                throw new UnsupportedOperationException();
            }

            @Override
            public String put(Object K, Object V) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void putAll(Map<? extends Object, ? extends Object> m) {
                throw new UnsupportedOperationException();
            }
        };
    }

    public int size() {
        if (this.cfgProperties == null) {
            return 0;
        }
        return this.cfgProperties.size();
    }

    public boolean isEmpty() {
        if (this.cfgProperties == null) {
            return true;
        }
        return this.cfgProperties.size() <= 0;
    }

    public Iterator<?> keyIterator() {
        return this.getPropertyKeys().iterator();
    }

    public Set<?> getPropertyKeys() {
        return this.getProperties().keySet();
    }

    public Set<String> getPropertyKeys(String startsWith) {
        OrderedSet<String> keys = new OrderedSet<String>();
        Iterator<?> i = this.keyIterator();
        while (i.hasNext()) {
            String k = i.next().toString();
            if (startsWith == null) {
                keys.add(k);
                continue;
            }
            if (this.getIgnoreKeyCase()) {
                if (!StringTools.startsWithIgnoreCase(k, startsWith)) continue;
                keys.add(k);
                continue;
            }
            if (!k.startsWith(startsWith)) continue;
            keys.add(k);
        }
        return keys;
    }

    public RTProperties getSubset(String keyStartsWith) {
        RTProperties rtp = new RTProperties();
        rtp.setIgnoreKeyCase(this.getIgnoreKeyCase());
        Iterator<?> i = this.keyIterator();
        while (i.hasNext()) {
            String v;
            Object k = i.next();
            if (!(k instanceof String)) continue;
            String ks = (String)k;
            if (this.getIgnoreKeyCase()) {
                if (!StringTools.startsWithIgnoreCase(ks, keyStartsWith)) continue;
                v = this.getString(ks, null);
                rtp.setProperty((Object)ks, v);
                continue;
            }
            if (!ks.startsWith(keyStartsWith)) continue;
            v = this.getString(ks, null);
            rtp.setProperty((Object)ks, v);
        }
        return rtp;
    }

    public static boolean containsKey(Map<Object, Object> map, Object key, boolean blankOK) {
        if (map == null || key == null) {
            return false;
        }
        if (blankOK) {
            return map.containsKey(key);
        }
        Object val = map.get(key);
        if (val instanceof String) {
            return !StringTools.isBlank((String)val);
        }
        return val != null;
    }

    public boolean hasProperty(Object[] keyList) {
        if (keyList != null) {
            Map<Object, Object> props = this.getProperties();
            boolean allowBlanks = this.getAllowBlankValues();
            for (Object key : keyList) {
                if (!RTProperties.containsKey(props, key, allowBlanks)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean hasProperty(Object key) {
        if (key != null) {
            Map<Object, Object> props = this.getProperties();
            boolean allowBlanks = this.getAllowBlankValues();
            return RTProperties.containsKey(props, key, allowBlanks);
        }
        return false;
    }

    public String getFirstDefinedKey(String[] key) {
        if (key != null) {
            for (int i = 0; i < key.length; ++i) {
                if (!this.hasProperty(key[i])) continue;
                return key[i];
            }
        }
        return null;
    }

    public String getFirstDefinedKey(String key) {
        return this.hasProperty(key) ? key : null;
    }

    @Override
    public void setProperty(Object key, Object value) {
        if (key != null) {
            String k;
            Map<Object, Object> props = this.getProperties();
            if (!this.getAllowBlankValues() && value instanceof String && StringTools.isBlank((String)value)) {
                value = null;
            }
            String string = k = key instanceof String ? (String)key : null;
            if (!StringTools.isBlank(k) && "|!^".indexOf(k.charAt(0)) >= 0) {
                key = k.substring(1);
                value = null;
            }
            if (value != null && value.getClass().isArray()) {
                Class<?> arrayClass = value.getClass();
                if (arrayClass.getComponentType().isPrimitive()) {
                    value = StringTools.encodeArray(value, ',', false);
                } else {
                    Object[] a = (Object[])value;
                    boolean quote = !(a instanceof Number[]);
                    value = StringTools.encodeArray(a, ',', quote);
                }
            }
            if (!(props instanceof Properties) || key instanceof String) {
                Object oldVal = props.get(key);
                if (value == null) {
                    props.remove(key);
                } else if (props instanceof OrderedMap && key.equals("%name")) {
                    ((OrderedMap)props).put(0, key, value);
                } else {
                    props.put(key, value);
                }
                this.firePropertyChanged(key, oldVal);
            }
        }
    }

    public String setProperties(RTProperties rtp) {
        return this.setProperties(rtp, false);
    }

    public String setProperties(RTProperties rtp, boolean inclName) {
        if (rtp != null) {
            return this.setProperties(rtp.getProperties(), inclName);
        }
        return null;
    }

    public String setProperties(URL url) throws IOException {
        return this.setProperties(url, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String setProperties(URL url, boolean inclName) throws IOException {
        String name = null;
        if (url != null) {
            InputStream uis = url.openStream();
            try {
                name = this._setProperties(uis, inclName, url);
            }
            finally {
                try {
                    uis.close();
                }
                catch (IOException ioe) {}
            }
        }
        return name;
    }

    public String setProperties(File file) throws IOException {
        return this.setProperties(file, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String setProperties(File file, boolean inclName) throws IOException {
        String name = null;
        if (file != null) {
            File absFile = file.getAbsoluteFile();
            FileInputStream fis = new FileInputStream(absFile);
            try {
                name = this._setProperties(fis, inclName, FileTools.toURL(absFile));
            }
            finally {
                try {
                    fis.close();
                }
                catch (IOException ioe) {}
            }
        }
        return name;
    }

    public String setProperties(InputStream in) throws IOException {
        return this._setProperties(in, false, null);
    }

    public String setProperties(InputStream in, boolean inclName) throws IOException {
        return this._setProperties(in, false, null);
    }

    private String _setProperties(InputStream in, boolean inclName, URL inputURL) throws IOException {
        OrderedProperties props = new OrderedProperties(inputURL);
        if (inputURL != null) {
            props.put("%configURL", inputURL.toString());
        }
        boolean isXML = RTProperties.IsXML(inputURL);
        props.loadProperties(props, in, isXML);
        return this.setProperties(props.getOrderedMap(), inclName);
    }

    public String setProperties(Map props) {
        return this.setProperties(props, false);
    }

    public String setProperties(Map props, boolean inclName) {
        if (props != null) {
            String n = null;
            for (Object key : props.keySet()) {
                Object val = props.get(key);
                if ("%name".equals(key)) {
                    String string = n = val != null ? val.toString() : null;
                    if (!inclName) continue;
                    this.setName(n);
                    continue;
                }
                this.setProperty(key, val);
            }
            return n;
        }
        return null;
    }

    public void setPropertySeparatorChar(char propSep) {
        this.propertySeparator = propSep;
    }

    public char getPropertySeparatorChar() {
        return this.propertySeparator;
    }

    public void setKeyValueSeparatorChars(char[] keyValSep) {
        this.keyValueSeparators = !ListTools.isEmpty(keyValSep) ? keyValSep : KeyValSeparatorChars;
    }

    public void setKeyValueSeparatorChar(char keyValSep) {
        this.keyValueSeparators = new char[]{keyValSep};
    }

    public char[] getKeyValueSeparatorChars() {
        return this.keyValueSeparators;
    }

    public char getKeyValueSeparatorChar() {
        return this.keyValueSeparators[0];
    }

    public String setProperties(String props) {
        return this.setProperties(props, false);
    }

    public String setProperties(String props, char propSep) {
        this.setPropertySeparatorChar(propSep);
        return this.setProperties(props, false);
    }

    public String setProperties(String props, boolean inclName) {
        if (props != null) {
            char propSep = this.getPropertySeparatorChar();
            char[] keyValSep = this.getKeyValueSeparatorChars();
            String n = null;
            String p = props.trim();
            if (p.startsWith(NameStart)) {
                int x = p.indexOf(NameEnd);
                if (x > 0) {
                    n = p.substring(1, x).trim();
                    p = p.substring(x + 1).trim();
                } else {
                    p = p.substring(1).trim();
                }
            }
            Map<String, String> propMap = StringTools.parseProperties(p, propSep, keyValSep);
            if (n == null) {
                n = this.setProperties(propMap, inclName);
            } else {
                this.setProperties(propMap, false);
                if (inclName) {
                    this.setName(n);
                }
            }
            return n;
        }
        return null;
    }

    public void removeProperty(Object key) {
        Map<Object, Object> props;
        if (key != null && (!((props = this.getProperties()) instanceof Properties) || key instanceof String)) {
            Object oldVal = props.get(key);
            props.remove(key);
            this.firePropertyChanged(key, oldVal);
        }
    }

    public void removeProperties(Object key) {
        this.removeProperty(key);
    }

    public void removeProperties(String[] keyArry) {
        if (!ListTools.isEmpty(keyArry)) {
            for (String key : keyArry) {
                this.removeProperty(key);
            }
        }
    }

    public void removeProperties(RTProperties rtp) {
        if (rtp != null) {
            Iterator<?> i = rtp.keyIterator();
            while (i.hasNext()) {
                Object key = i.next();
                this.removeProperty(key);
            }
        }
    }

    public void clearProperties() {
        this.getProperties().clear();
        this.firePropertyChanged(null, null);
    }

    public void resetProperties(Map props) {
        this.clearProperties();
        this.setProperties(props, true);
    }

    public String insertKeyValues(String text) {
        return this._insertKeyValues(null, text, KEY_START_DELIMITER, KEY_END_DELIMITER, KEY_DFT_DELIMITER);
    }

    public String insertKeyValues(String text, String startDelim, String endDelim) {
        return this._insertKeyValues(null, text, startDelim, endDelim, KEY_DFT_DELIMITER);
    }

    public String _insertKeyValues(Object key, String text) {
        return this._insertKeyValues(key, text, KEY_START_DELIMITER, KEY_END_DELIMITER, KEY_DFT_DELIMITER);
    }

    public String _insertKeyValues(final Object mainKey, String text, String startDelim, String endDelim, String dftDelim) {
        if (text != null) {
            StringTools.KeyValueMap rm = new StringTools.KeyValueMap(){
                private Set<Object> thisKeySet = new HashSet<Object>();
                private Set<Object> fullKeySet = new HashSet<Object>();

                @Override
                public String getKeyValue(String k, String argNotUsed, String dft) {
                    if (k == null) {
                        this.fullKeySet.addAll(this.thisKeySet);
                        if (mainKey != null) {
                            this.fullKeySet.add(mainKey);
                        }
                        this.thisKeySet.clear();
                        return null;
                    }
                    String key = k;
                    if (this.fullKeySet.contains(key)) {
                        if (RTProperties.this.DEBUG) {
                            Print.logError("Key already processed: " + key, new Object[0]);
                        }
                        return null;
                    }
                    this.thisKeySet.add(key);
                    Object obj = RTProperties.this._getProperty(key, dft);
                    return obj != null ? obj.toString() : dft;
                }
            };
            String s_old = text;
            for (int i = 0; i < 6; ++i) {
                rm.getKeyValue(null, null, null);
                String s_new = StringTools.insertKeyValues(s_old, startDelim, endDelim, dftDelim, rm, false);
                if (s_new.equals(s_old)) {
                    return s_new;
                }
                s_old = s_new;
            }
            return s_old;
        }
        return text;
    }

    public void setKeyReplacementMode(int mode) {
        this.keyReplacementMode = mode;
    }

    private Object _replaceKeyValues(Object key, Object obj) {
        if (this.keyReplacementMode == 0) {
            return obj;
        }
        if (obj == null || !(obj instanceof String)) {
            return obj;
        }
        if (this.keyReplacementMode == 1) {
            return this._insertKeyValues(key, (String)obj);
        }
        return RTConfig._insertKeyValues(key, (String)obj);
    }

    private Object _getProperty(Object key, Object dft, Class dftClass, boolean replaceKeys) {
        Object value = this.getProperties().get(key);
        if (value == null) {
            return replaceKeys ? this._replaceKeyValues(key, dft) : dft;
        }
        if (dft == null && dftClass == null) {
            return replaceKeys ? this._replaceKeyValues(key, value) : value;
        }
        Class<?> c = dftClass != null ? dftClass : dft.getClass();
        try {
            return RTProperties.convertToType(replaceKeys ? this._replaceKeyValues(key, value) : value, c);
        }
        catch (Throwable t) {
            return replaceKeys ? this._replaceKeyValues(key, dft) : dft;
        }
    }

    public Object _getProperty(Object key, Object dft) {
        return this._getProperty(key, dft, null, false);
    }

    @Override
    public Object getProperty(Object key, Object dft) {
        return this._getProperty(key, dft, null, true);
    }

    protected static Object convertToType(Object val, Class<?> type) throws Throwable {
        if (type == null || val == null) {
            return val;
        }
        if (type.isAssignableFrom(val.getClass())) {
            return val;
        }
        if (type == String.class) {
            return val.toString();
        }
        try {
            Constructor<?> meth = type.getConstructor(type);
            return meth.newInstance(val);
        }
        catch (Throwable t1) {
            try {
                Constructor<?> meth = type.getConstructor(String.class);
                return meth.newInstance(val.toString());
            }
            catch (Throwable t2) {
                Print.logError("Can't convert value to " + type.getName() + ": " + val, new Object[0]);
                throw t2;
            }
        }
    }

    public String getString(String key) {
        return this.getString(key, null);
    }

    public String getString(String[] key, String dft) {
        return this.getString(this.getFirstDefinedKey(key), dft);
    }

    public String getString(String key, String dft) {
        return this.getString(key, dft, true);
    }

    public String getString(String key, String dft, boolean replaceKeys) {
        Object val = this._getProperty(key, dft, String.class, replaceKeys);
        if (val == null) {
            return null;
        }
        if (val.equals("<null>")) {
            return null;
        }
        return val.toString();
    }

    public void setString(String key, String value) {
        this.setProperty((Object)key, value);
    }

    @Override
    public String getKeyValue(String key, String arg, String dft) {
        return this.getString(key, dft);
    }

    public String[] getStringArray(String key) {
        return this.getStringArray(key, null);
    }

    public String[] getStringArray(String[] key, String[] dft) {
        return this.getStringArray(this.getFirstDefinedKey(key), dft);
    }

    public String[] getStringArray(String key, String[] dft) {
        String val = this.getString(key, null);
        if (val == null) {
            return dft;
        }
        String[] va = StringTools.parseArray(val);
        return va;
    }

    public void setStringArray(String key, String[] val) {
        this.setStringArray(key, val, true);
    }

    public void setStringArray(String key, String[] val, boolean alwaysQuote) {
        String valStr = StringTools.encodeArray(val, ',', alwaysQuote);
        this.setString(key, valStr);
    }

    public void setProperty(String key, String[] val) {
        this.setStringArray(key, val, true);
    }

    public Class getClass(String key) {
        return this.getClass(key, null);
    }

    public Class getClass(String key, Class dft) {
        Object val = this._getProperty(key, null, null, true);
        if (val == null) {
            return dft;
        }
        if (val instanceof Class) {
            return (Class)val;
        }
        try {
            return Class.forName(val.toString());
        }
        catch (Throwable th) {
            return dft;
        }
    }

    public void setClass(String key, Class value) {
        this.setProperty((Object)key, value);
    }

    public File getFile(String key) {
        return this.getFile(key, null);
    }

    public File getFile(String key, File dft) {
        Object val = this._getProperty(key, null, null, true);
        if (val == null) {
            return dft;
        }
        if (val instanceof File) {
            return (File)val;
        }
        return new File(val.toString());
    }

    public void setFile(String key, File value) {
        this.setProperty((Object)key, value);
    }

    public boolean isDouble(String key, boolean strict) {
        Object val = this._getProperty(key, null, null, true);
        return StringTools.isDouble(val, strict);
    }

    public double getDouble(String key) {
        return this.getDouble(key, 0.0);
    }

    public double getDouble(String[] key, double dft) {
        return this.getDouble(this.getFirstDefinedKey(key), dft);
    }

    public double getDouble(String key, double dft) {
        Object val = this._getProperty(key, null, null, true);
        if (val == null) {
            return dft;
        }
        if (val instanceof Number) {
            return ((Number)val).doubleValue();
        }
        return StringTools.parseDouble(val.toString(), dft);
    }

    public double[] getDoubleArray(String key, double[] dft) {
        String[] val = this.getStringArray(key, null);
        if (val == null) {
            return dft;
        }
        double[] n = new double[val.length];
        for (int i = 0; i < val.length; ++i) {
            n[i] = StringTools.parseDouble(val[i], 0.0);
        }
        return n;
    }

    public void setDouble(String key, double value) {
        this.setProperty(key, value);
    }

    public void setDoubleArray(String key, double[] value) {
        this.setProperty((Object)key, value);
    }

    public void setProperty(String key, double value) {
        this.setProperty((Object)key, new Double(value));
    }

    public boolean isFloat(String key, boolean strict) {
        Object val = this._getProperty(key, null, null, true);
        return StringTools.isFloat(val, strict);
    }

    public float getFloat(String key) {
        return this.getFloat(key, 0.0f);
    }

    public float getFloat(String[] key, float dft) {
        return this.getFloat(this.getFirstDefinedKey(key), dft);
    }

    public float getFloat(String key, float dft) {
        Object val = this._getProperty(key, null, null, true);
        if (val == null) {
            return dft;
        }
        if (val instanceof Number) {
            return ((Number)val).floatValue();
        }
        return StringTools.parseFloat(val.toString(), dft);
    }

    public float[] getFloatArray(String key, float[] dft) {
        String[] val = this.getStringArray(key, null);
        if (val == null) {
            return dft;
        }
        float[] n = new float[val.length];
        for (int i = 0; i < val.length; ++i) {
            n[i] = StringTools.parseFloat(val[i], 0.0f);
        }
        return n;
    }

    public void setFloat(String key, float value) {
        this.setProperty(key, value);
    }

    public void setFloatArray(String key, float[] value) {
        this.setProperty((Object)key, value);
    }

    public void setProperty(String key, float value) {
        this.setProperty((Object)key, new Float(value));
    }

    public boolean isBigInteger(String key, boolean strict) {
        Object val = this._getProperty(key, null, null, true);
        return StringTools.isBigInteger(val, strict);
    }

    public BigInteger getBigInteger(String key) {
        return this.getBigInteger(key, BigInteger.ZERO);
    }

    public BigInteger getBigInteger(String[] key, BigInteger dft) {
        return this.getBigInteger(this.getFirstDefinedKey(key), dft);
    }

    public BigInteger getBigInteger(String key, BigInteger dft) {
        Object val = this._getProperty(key, null, null, true);
        if (val == null) {
            return dft;
        }
        if (val instanceof BigInteger) {
            return (BigInteger)val;
        }
        if (val instanceof Number) {
            return BigInteger.valueOf(((Number)val).longValue());
        }
        return StringTools.parseBigInteger(val.toString(), dft);
    }

    public BigInteger[] getBigIntegerArray(String key, BigInteger[] dft) {
        String[] val = this.getStringArray(key, null);
        if (val == null) {
            return dft;
        }
        BigInteger[] n = new BigInteger[val.length];
        for (int i = 0; i < val.length; ++i) {
            n[i] = StringTools.parseBigInteger(val[i], BigInteger.ZERO);
        }
        return n;
    }

    public void setBigInteger(String key, BigInteger value) {
        this.setProperty((Object)key, (Object)value);
    }

    public void setBigIntegerArray(String key, BigInteger[] value) {
        this.setProperty((Object)key, value);
    }

    public void setProperty(String key, BigInteger value) {
        this.setProperty((Object)key, (Object)value);
    }

    public boolean isLong(String key, boolean strict) {
        Object val = this._getProperty(key, null, null, true);
        return StringTools.isLong(val, strict);
    }

    public long getLong(String key) {
        return this.getLong(key, 0L);
    }

    public long getLong(String[] key, long dft) {
        return this.getLong(this.getFirstDefinedKey(key), dft);
    }

    public long getLong(String key, long dft) {
        Object val = this._getProperty(key, null, null, true);
        if (val == null) {
            return dft;
        }
        if (val instanceof Number) {
            return ((Number)val).longValue();
        }
        return StringTools.parseLong(val.toString(), dft);
    }

    public long[] getLongArray(String key, long[] dft) {
        String[] val = this.getStringArray(key, null);
        if (val == null) {
            return dft;
        }
        long[] n = new long[val.length];
        for (int i = 0; i < val.length; ++i) {
            n[i] = StringTools.parseLong(val[i], 0L);
        }
        return n;
    }

    public void setLong(String key, long value) {
        this.setProperty(key, value);
    }

    public void setLongArray(String key, long[] value) {
        this.setProperty((Object)key, value);
    }

    public void setProperty(String key, long value) {
        this.setProperty((Object)key, new Long(value));
    }

    public boolean isInt(String key, boolean strict) {
        Object val = this._getProperty(key, null, null, true);
        return StringTools.isInt(val, strict);
    }

    public int getInt(String key) {
        return this.getInt(key, 0);
    }

    public int getInt(String[] key, int dft) {
        return this.getInt(this.getFirstDefinedKey(key), dft);
    }

    public int getInt(String key, int dft) {
        Object val = this._getProperty(key, null, null, true);
        if (val == null) {
            return dft;
        }
        if (val instanceof Number) {
            return ((Number)val).intValue();
        }
        return StringTools.parseInt(val.toString(), dft);
    }

    public int[] getIntArray(String key, int[] dft) {
        String[] val = this.getStringArray(key, null);
        if (val == null) {
            return dft;
        }
        int[] n = new int[val.length];
        for (int i = 0; i < val.length; ++i) {
            n[i] = StringTools.parseInt(val[i], 0);
        }
        return n;
    }

    public void setInt(String key, int value) {
        this.setProperty(key, value);
    }

    public void setIntArray(String key, int[] value) {
        this.setProperty((Object)key, value);
    }

    public void setProperty(String key, int value) {
        this.setProperty((Object)key, new Integer(value));
    }

    public boolean isBoolean(String key, boolean strict) {
        Object val = this._getProperty(key, null, null, true);
        return StringTools.isBoolean(val, strict);
    }

    public boolean getBoolean(String key) {
        boolean dft = false;
        return this._getBoolean_dft(key, dft, true);
    }

    public boolean getBoolean(String[] key, boolean dft) {
        return this.getBoolean(this.getFirstDefinedKey(key), dft);
    }

    public boolean getBoolean(String key, boolean dft) {
        return this._getBoolean_dft(key, dft, true);
    }

    private boolean _getBoolean_dft(String key, boolean dft, boolean dftTrueIfEmpty) {
        Object val = this._getProperty(key, null, null, true);
        if (val == null) {
            return dft;
        }
        if (val instanceof Boolean) {
            return (Boolean)val;
        }
        if (val.toString().equals("")) {
            return dftTrueIfEmpty ? true : dft;
        }
        return StringTools.parseBoolean(val.toString(), dft);
    }

    public void setBoolean(String key, boolean value) {
        this.setProperty(key, value);
    }

    public void setBooleanArray(String key, boolean[] value) {
        this.setProperty((Object)key, value);
    }

    public void setProperty(String key, boolean value) {
        this.setProperty((Object)key, new Boolean(value));
    }

    public void printProperties(String msg) {
        this.printProperties(msg, null, null);
    }

    public void printProperties(String msg, RTProperties exclProps) {
        this.printProperties(msg, exclProps, null);
    }

    public void printProperties(String msg, Collection<?> orderBy) {
        this.printProperties(msg, null, orderBy);
    }

    public void printProperties(String msg, RTProperties exclProps, Collection<?> orderBy) {
        if (!StringTools.isBlank(msg)) {
            Print.sysPrintln(msg, new Object[0]);
        }
        String prefix = "   ";
        if (this.isEmpty()) {
            Print.sysPrintln(prefix + "<empty>\n", new Object[0]);
        } else {
            if (orderBy == null) {
                orderBy = new Vector(this.getPropertyKeys());
                ListTools.sort((List)orderBy, null);
            }
            Print.sysPrintln(this.toString(exclProps, orderBy, prefix), new Object[0]);
        }
    }

    public void logProperties(String msg) {
        this.logProperties(msg, null, null);
    }

    public void logProperties(String msg, RTProperties exclProps, Collection<?> orderBy) {
        String m = msg != null ? msg + "\n" : "\n";
        String prefix = "   ";
        if (this.isEmpty()) {
            Print.logInfo(m + prefix + "<empty>\n", new Object[0]);
        } else {
            if (orderBy == null) {
                orderBy = new Vector(this.getPropertyKeys());
                ListTools.sort((List)orderBy, null);
            }
            Print.logInfo(m + this.toString(exclProps, orderBy, prefix), new Object[0]);
        }
    }

    public boolean equals(Object other) {
        if (other instanceof RTProperties) {
            RTProperties rtp = (RTProperties)other;
            Map<Object, Object> M1 = this.getProperties();
            Map<Object, Object> M2 = rtp.getProperties();
            if (M1.size() == M2.size()) {
                for (Object key : M1.keySet()) {
                    if (M2.containsKey(key)) {
                        String m2ValStr;
                        Object m1Val = M1.get(key);
                        Object m2Val = M2.get(key);
                        String m1ValStr = m1Val != null ? m1Val.toString() : null;
                        String string = m2ValStr = m2Val != null ? m2Val.toString() : null;
                        if (m1Val == m2Val || m1ValStr != null && m1ValStr.equals(m2ValStr)) continue;
                        return false;
                    }
                    return false;
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public void saveProperties(File cfgFile) throws IOException {
        this.saveProperties(cfgFile, false);
    }

    public void saveProperties(File cfgFile, boolean merge) throws IOException {
        if (cfgFile == null) {
            throw new IOException("File is null");
        }
        Map<Object, Object> propMap = this.getProperties();
        if (merge && cfgFile.exists()) {
            String mergedConf;
            String valS;
            String[] conf = StringTools.split(StringTools.toStringValue(FileTools.readFile(cfgFile)), '\n');
            HashMap<String, String> newP = new HashMap<String, String>();
            for (Object key : propMap.keySet()) {
                Object val = propMap.get(key);
                String keyS = key != null ? key.toString() : "";
                valS = val != null ? val.toString() : "";
                String ke = keyS + this.getKeyValueSeparatorChar();
                int found = 0;
                for (int i = conf.length - 1; i >= 0; --i) {
                    if (!conf[i].startsWith(ke)) continue;
                    conf[i] = ke + val;
                    ++found;
                }
                if (found == 0) {
                    String keh = "#" + ke;
                    for (int i = 0; i < conf.length; ++i) {
                        if (!conf[i].startsWith(keh)) continue;
                        conf[i] = ke + val;
                        ++found;
                        break;
                    }
                }
                if (found != 0 || keyS.equals("%configURL")) continue;
                newP.put(keyS, valS);
            }
            if (newP.size() > 0) {
                List<String> mergeList = ListTools.toList(conf, new Vector());
                if (!ListTools.isEmpty(conf) && !StringTools.isBlank(conf[conf.length - 1])) {
                    mergeList.add("");
                }
                mergeList.add("# --- additional properties");
                for (String keyS : newP.keySet()) {
                    valS = (String)newP.get(keyS);
                    mergeList.add(keyS + this.getKeyValueSeparatorChar() + valS);
                }
                mergedConf = StringTools.join(mergeList, "\n");
            } else {
                mergedConf = StringTools.join(conf, "\n");
            }
            if (!mergedConf.endsWith("\n")) {
                mergedConf = mergedConf + "\n";
            }
            FileTools.writeFile(mergedConf.getBytes(), cfgFile);
        } else {
            StringBuffer strProps = new StringBuffer();
            for (Object keyObj : propMap.keySet()) {
                Object valObj = propMap.get(keyObj);
                strProps.append(keyObj.toString());
                strProps.append(this.getKeyValueSeparatorChar());
                if (valObj != null) {
                    strProps.append(valObj.toString());
                }
                strProps.append("\n");
            }
            FileTools.writeFile(strProps.toString().getBytes(), cfgFile);
        }
    }

    public String[] toStringArray(boolean dashPrefix) {
        Vector<String> list = new Vector<String>();
        Map<Object, Object> propMap = this.getProperties();
        for (Object keyObj : propMap.keySet()) {
            Object valObj = propMap.get(keyObj);
            StringBuffer sb = new StringBuffer();
            if (dashPrefix) {
                sb.append(KEYVAL_PREFIX);
            }
            sb.append(keyObj.toString()).append(this.getKeyValueSeparatorChar());
            String v = StringTools.trim(valObj);
            if (v.indexOf(" ") >= 0 || v.indexOf("\t") >= 0 || v.indexOf("\"") >= 0) {
                sb.append(StringTools.quoteString(v));
            } else {
                sb.append(v);
            }
            list.add(sb.toString());
        }
        return list.toArray(new String[list.size()]);
    }

    public String toString() {
        return this.toString(null, null, null);
    }

    public String toString(RTProperties exclProps) {
        return this.toString(exclProps, null, null);
    }

    public String toString(Collection<?> orderBy) {
        return this.toString(null, orderBy, null);
    }

    public String toString(RTProperties exclProps, Collection<?> orderBy) {
        return this.toString(null, orderBy, null);
    }

    public String toString(RTProperties exclProps, Collection<?> orderBy, String newLinePrefix) {
        StringBuffer sb = new StringBuffer();
        boolean inclNewLine = newLinePrefix != null;
        String n = this.getName();
        if (!n.equals("")) {
            if (inclNewLine) {
                sb.append(newLinePrefix);
            }
            sb.append(NameStart).append(n).append(NameEnd);
            if (inclNewLine) {
                sb.append("\n");
            } else {
                sb.append(this.getPropertySeparatorChar());
            }
        }
        Map<Object, Object> propMap = this.getProperties();
        Map<Object, Object> exclMap = exclProps != null ? exclProps.getProperties() : null;
        Set<Object> orderSet = null;
        if (orderBy != null) {
            orderSet = new OrderedSet(orderBy, true);
            orderSet.addAll(propMap.keySet());
        } else {
            orderSet = propMap.keySet();
        }
        Iterator<Object> i = orderSet.iterator();
        while (i.hasNext()) {
            String valStr;
            Object keyObj = i.next();
            if ("%name".equals(keyObj) || !RTProperties.containsKey(propMap, keyObj, this.getAllowBlankValues())) continue;
            Object valObj = propMap.get(keyObj);
            if (exclMap != null && RTProperties.compareMapValues(valObj, exclMap.get(keyObj))) continue;
            if (inclNewLine) {
                sb.append(newLinePrefix);
            }
            if (keyObj instanceof String) {
                sb.append((String)keyObj);
            } else {
                sb.append(keyObj.toString());
                sb.append(NameStart).append(StringTools.className(keyObj)).append(NameEnd);
            }
            sb.append(this.getKeyValueSeparatorChar());
            String string = valStr = valObj != null ? valObj.toString() : "";
            if (valStr.indexOf(" ") >= 0 || valStr.indexOf("\t") >= 0 || valStr.indexOf("\"") >= 0) {
                sb.append(StringTools.quoteString(valStr));
            } else {
                sb.append(valStr);
            }
            if (inclNewLine) {
                sb.append("\n");
                continue;
            }
            if (!i.hasNext()) continue;
            sb.append(this.getPropertySeparatorChar());
        }
        return inclNewLine ? sb.toString() : sb.toString().trim();
    }

    private static boolean compareMapValues(Object value, Object target) {
        if (value == null && target == null) {
            return true;
        }
        if (value == null || target == null) {
            return false;
        }
        if (value.equals(target)) {
            return true;
        }
        return value.toString().equals(target.toString());
    }

    private static boolean isEOL(byte b) {
        return b == 10 || b == 13;
    }

    private static boolean isEOL(char b) {
        return b == '\n' || b == '\r';
    }

    private static boolean isCOMMENT(byte b) {
        return b == 35 || b == 33;
    }

    private static boolean isCOMMENT(char b) {
        return b == '#' || b == '!';
    }

    private static boolean isSEP(byte b) {
        return b == 61 || b == 58;
    }

    private static boolean isSEP(char b) {
        return b == '=' || b == ':';
    }

    public static void main(String[] argv) {
        RTProperties rtp = new RTProperties("[mdf] -test=\"Hello World\" -another=test hello= world=");
        Print.sysPrintln("RTP] " + rtp, new Object[0]);
        rtp.printProperties("Test RTProperties:");
    }

    public class OrderedProperties
    extends Properties {
        private OrderedProperties parentProps = null;
        private boolean debugMode = false;
        private int recursionLevel = 0;
        private OrderedMap<String, String> orderedMap = null;
        private URL inputURL = null;

        public OrderedProperties(URL inputURL) {
            this(1, inputURL);
        }

        private OrderedProperties(int recursion, URL inputURL) {
            this.recursionLevel = recursion;
            this.orderedMap = new OrderedMap();
            this.inputURL = inputURL;
        }

        public void setParentProperties(OrderedProperties parent) {
            this.parentProps = parent;
        }

        public boolean getBoolean(String key, boolean dft) {
            if (key == null) {
                return dft;
            }
            if (this.orderedMap.containsKey(key)) {
                return StringTools.parseBoolean(this.orderedMap.get(key), dft);
            }
            if (this.containsKey(key)) {
                return StringTools.parseBoolean(this.get(key), dft);
            }
            if (this.parentProps != null && this.parentProps.containsKey(key)) {
                return this.parentProps.getBoolean(key, dft);
            }
            return RTConfig.getBoolean(key, dft);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object put(Object key, Object value) {
            if (key == null || value == null) {
                return value;
            }
            String ks = key.toString();
            String vs = StringTools.trimTrailing(value);
            if (ks.startsWith("%")) {
                if (this.debugMode) {
                    Print.logInfo("(DEBUG) Found Constant key: " + ks, new Object[0]);
                }
                if (ks.equalsIgnoreCase(RTProperties.KEY_DEBUGMODE)) {
                    this.debugMode = StringTools.parseBoolean(vs, false);
                    if (this.debugMode) {
                        Print.logInfo("(DEBUG) 'debugMode' set to " + this.debugMode, new Object[0]);
                    }
                    return value;
                }
                if (ks.equalsIgnoreCase(RTProperties.KEY_INCLUDE_URL) || ks.equalsIgnoreCase(RTProperties.KEY_INCLUDE_URL_OPT)) {
                    String v = RTConfig.insertKeyValues(vs, this.orderedMap);
                    if (!RTProperties.this.getIncludesEnabled()) {
                        Print.logWarn("'include' statements disabled [%s] ...", v);
                    } else if (StringTools.isBlank(v)) {
                        Print.logError("Invalid/blank 'include' URL: " + vs, new Object[0]);
                    } else if (this.recursionLevel >= 3) {
                        Print.logWarn("Excessive 'include' recursion [%s] ...", v);
                    } else {
                        InputStream uis = null;
                        URL url = null;
                        try {
                            if (this.debugMode) {
                                Print.logInfo("(DEBUG) Including: " + v, new Object[0]);
                            }
                            url = new URL(v);
                            String parent = this.inputURL != null ? this.inputURL.toString() : "";
                            String parProto = this.inputURL != null ? this.inputURL.getProtocol().toLowerCase() : "";
                            String urlPath = url.getPath();
                            String urlProto = url.getProtocol().toLowerCase();
                            if (!StringTools.isBlank(parProto)) {
                                if (parProto.equals(RTProperties.INCLUDE_PROTOCOL_FILE)) {
                                    int ls;
                                    if (urlProto.equals(RTProperties.INCLUDE_PROTOCOL_FILE) && !new File(urlPath).isAbsolute() && (ls = parent.lastIndexOf("/")) > 0) {
                                        url = new URL(parent.substring(0, ls + 1) + urlPath);
                                    }
                                } else if (parProto.startsWith(RTProperties.INCLUDE_PROTOCOL_HTTP)) {
                                    if (urlProto.equals(RTProperties.INCLUDE_PROTOCOL_FILE)) {
                                        Print.logError("Invalid 'include' URL protocol: " + url, new Object[0]);
                                        url = null;
                                    } else if (urlProto.equals(parProto) && !urlPath.startsWith("/")) {
                                        int cs = parent.indexOf("://");
                                        int ls = parent.lastIndexOf("/");
                                        if (cs > 0 && ls >= cs + 3) {
                                            url = new URL(parent.substring(0, ls + 1) + urlPath);
                                        }
                                    }
                                }
                            }
                            if (url != null) {
                                boolean isXML = RTProperties.IsXML(url);
                                if (this.debugMode) {
                                    Print.logInfo("(DEBUG) Including URL: [" + vs + "] " + url, new Object[0]);
                                }
                                uis = url.openStream();
                                OrderedProperties props = new OrderedProperties(this.recursionLevel + 1, url);
                                props.setParentProperties(this);
                                props.put("%configURL", url.toString());
                                props.loadProperties(props, uis, isXML);
                                props.remove("%configURL");
                                this.orderedMap.putAll(props.getOrderedMap());
                            }
                        }
                        catch (MalformedURLException mue) {
                            Print.logException("Invalid URL: " + url, mue);
                        }
                        catch (IllegalArgumentException iae) {
                            Print.logException("Invalid URL arguments: " + url, iae);
                        }
                        catch (Throwable th) {
                            if (!ks.equalsIgnoreCase(RTProperties.KEY_INCLUDE_URL_OPT)) {
                                Print.logException("Error including properties: " + url, th);
                            }
                        }
                        finally {
                            if (uis != null) {
                                try {
                                    uis.close();
                                }
                                catch (IOException ioe) {}
                            }
                        }
                    }
                    return value;
                }
                if (ks.equalsIgnoreCase(RTProperties.KEY_LOG)) {
                    if (RTProperties.this.getConfigLogMessagesEnabled()) {
                        StringBuffer sb = new StringBuffer();
                        if (this.inputURL != null) {
                            String filePath = this.inputURL.getPath();
                            int p = filePath.lastIndexOf("/");
                            String fileName = p >= 0 ? filePath.substring(p + 1) : filePath;
                            sb.append(RTProperties.NameStart).append(fileName).append("] ");
                        }
                        RTProperties tempProps = new RTProperties(this);
                        RTConfig.pushTemporaryProperties(tempProps);
                        Print.resetVars();
                        sb.append(RTConfig.insertKeyValues(vs, this.orderedMap)).append("\n");
                        Print._writeLog(4, sb.toString());
                        RTConfig.popTemporaryProperties(tempProps);
                    }
                    return value;
                }
                if (ks.startsWith(RTProperties.KEY_IF) || ks.startsWith(RTProperties.KEY_ELSE) || ks.startsWith(RTProperties.KEY_ENDIF)) {
                    Print.logError("'%if..%else..%endif' NOT SUPPORTED HERE !!!", new Object[0]);
                    return "";
                }
                if (ks.equalsIgnoreCase("%configURL")) {
                    Object rtn = super.put(key, value);
                    this.orderedMap.put(ks, vs);
                    return rtn;
                }
                Print.logError("Invalid/unrecognized key specified: " + ks, new Object[0]);
                return value;
            }
            if (key instanceof String && ((String)key).endsWith("?")) {
                String k = (String)key;
                if (this.containsKey(k = k.substring(0, k.length() - 1)) || this.orderedMap.containsKey(k) || RTConfig.hasProperty(k)) {
                    return super.get(k);
                }
                key = k;
            }
            Object rtn = super.put(key, value);
            this.orderedMap.put(ks, vs);
            return rtn;
        }

        @Override
        public Object remove(Object key) {
            if (key != null) {
                Object rtn = super.remove(key);
                this.orderedMap.remove(key.toString());
                return rtn;
            }
            return null;
        }

        public OrderedMap<String, String> getOrderedMap() {
            return this.orderedMap;
        }

        @Override
        public void load(Reader r) throws IOException {
            throw new UnsupportedOperationException("load(Reader) not supported");
        }

        @Override
        public void load(InputStream in) throws IOException {
            super.load(in);
        }

        public Properties loadProperties(Properties props, InputStream in, boolean isXML) throws IOException {
            if (props == null || in == null) {
                return null;
            }
            if (isXML) {
                props.loadFromXML(in);
                return props;
            }
            return this.loadProperties(props, in);
        }

        public Properties loadProperties(Properties props, InputStream in) throws IOException {
            if (props == null || in == null) {
                return null;
            }
            if (this.getBoolean(RTProperties.PROP_usePropertiesLoad, USE_PROPERTIES_LOADER)) {
                props.load(in);
                return props;
            }
            byte[] data = FileTools.readStream(in);
            String dataStr = StringTools.toStringValue(data);
            String[] ds = StringTools.split(dataStr, '\n');
            int ifLevel = 0;
            boolean inclDef = true;
            for (int i = 0; i < ds.length; ++i) {
                int vc;
                String val;
                int line = i + 1;
                String d = ds[i].trim();
                int dlen = d.length();
                if (d.equals("") || RTProperties.isCOMMENT(d.charAt(0))) continue;
                if (d.startsWith(RTProperties.KEY_IF)) {
                    boolean eq;
                    String comp;
                    int c;
                    if (d.length() <= c || d.charAt(c) != ' ') {
                        Print.logError("*** [" + line + "] Invalid '%if' specification: " + d, new Object[0]);
                        continue;
                    }
                    if (ifLevel > 0) {
                        Print.logError("*** [" + line + "] Nested '%if' not supported", new Object[0]);
                        continue;
                    }
                    ++ifLevel;
                    for (c = RTProperties.KEY_IF.length(); c < dlen && Character.isWhitespace(d.charAt(c)); ++c) {
                    }
                    if (c >= dlen) {
                        Print.logError("*** [" + line + "] Missing conditional after '%if'", new Object[0]);
                        continue;
                    }
                    int k = c;
                    while (c < dlen && d.charAt(c) != '!' && d.charAt(c) != '=') {
                        ++c;
                    }
                    String ifKey = c < dlen ? d.substring(k, c).trim() : d.substring(k).trim();
                    boolean not = false;
                    boolean hasComp = false;
                    int t = c;
                    while (c < dlen && (d.charAt(c) == '!' || d.charAt(c) == '=')) {
                        ++c;
                    }
                    String string = comp = c > t ? d.substring(t, c) : "";
                    if (comp.equals("")) {
                        hasComp = false;
                        not = false;
                    } else if (comp.equals(RTProperties.KEY_DFT_DELIMITER) || comp.equals("==")) {
                        hasComp = true;
                        not = false;
                    } else if (comp.equals("!=")) {
                        hasComp = true;
                        not = true;
                    } else {
                        Print.logError("*** [" + line + "] Invalid condition operator: " + comp, new Object[0]);
                        continue;
                    }
                    String ifVal = c < dlen ? d.substring(c).trim() : (hasComp ? "" : null);
                    String pkVal = null;
                    pkVal = props.containsKey(ifKey) ? props.getProperty(ifKey) : (this.orderedMap.containsKey(ifKey) ? this.orderedMap.get(ifKey) : RTConfig.getString(ifKey, null));
                    if (ifVal != null) {
                        if (pkVal != null) {
                            eq = ifVal.equalsIgnoreCase(pkVal);
                            inclDef = not ? !eq : eq;
                            continue;
                        }
                        eq = StringTools.isBlank(ifVal);
                        inclDef = not ? !eq : eq;
                        continue;
                    }
                    boolean bl = eq = pkVal != null;
                    inclDef = not ? !eq : eq;
                    continue;
                }
                if (d.startsWith(RTProperties.KEY_ELSE)) {
                    if (ifLevel <= 0) {
                        Print.logError("*** [" + line + "] '%else' without previous '%if'", new Object[0]);
                        ifLevel = 0;
                        inclDef = true;
                        continue;
                    }
                    boolean bl = inclDef = !inclDef;
                    if (d.length() <= RTProperties.KEY_ELSE.length()) continue;
                    Print.logWarn("*** [" + line + "] Invalid characters following '%else'", new Object[0]);
                    continue;
                }
                if (d.startsWith(RTProperties.KEY_ENDIF)) {
                    if (--ifLevel < 0) {
                        Print.logError("*** [" + line + "] '%endif' without previous '%if'", new Object[0]);
                        ifLevel = 0;
                        inclDef = true;
                        continue;
                    }
                    if (ifLevel == 0) {
                        inclDef = true;
                    }
                    if (d.length() <= RTProperties.KEY_ENDIF.length()) continue;
                    Print.logWarn("*** [" + line + "] Invalid characters following '%endif'", new Object[0]);
                    continue;
                }
                if (d.startsWith(RTProperties.KEY_LOG)) {
                    if (!inclDef || !RTProperties.this.getConfigLogMessagesEnabled()) continue;
                    String msg = d.substring(RTProperties.KEY_LOG.length()).trim();
                    if (msg.length() > 0 && RTProperties.isSEP(msg.charAt(0))) {
                        msg = msg.substring(1).trim();
                    }
                    StringBuffer sb = new StringBuffer();
                    if (this.inputURL != null) {
                        String filePath = this.inputURL.getPath();
                        int p = filePath.lastIndexOf("/");
                        String fileName = p >= 0 ? filePath.substring(p + 1) : filePath;
                        sb.append(RTProperties.NameStart).append(fileName).append("] ");
                    }
                    RTProperties tempProps = new RTProperties(this);
                    RTConfig.pushTemporaryProperties(tempProps);
                    Print.resetVars();
                    sb.append(RTConfig.insertKeyValues(msg, this.orderedMap).trim()).append("\n");
                    Print._writeLog(4, sb.toString());
                    RTConfig.popTemporaryProperties(tempProps);
                    continue;
                }
                if (!inclDef) continue;
                int p = d.indexOf(RTProperties.KEY_DFT_DELIMITER);
                if (p < 0) {
                    p = d.indexOf(":");
                }
                String key = p >= 0 ? d.substring(0, p) : d;
                String string = val = p >= 0 ? d.substring(p + 1) : "";
                if (key.equals("")) continue;
                if (this.getBoolean(RTProperties.PROP_removeInlineComments, REMOVE_INLINE_COMMENTS) && (vc = val.indexOf(RTProperties.INLINE_COMMENT_SEQUENCE)) >= 0) {
                    val = StringTools.trimTrailing(val.substring(0, vc));
                }
                props.put(key, val);
            }
            if (!inclDef) {
                Print.logError("*** Missing '%endif'", new Object[0]);
            }
            return props;
        }
    }

    public class PropertyChangeEvent {
        private Object keyObj = null;
        private Object oldVal = null;
        private Object newVal = null;

        public PropertyChangeEvent(Object key, Object oldValue, Object newValue) {
            this.keyObj = key;
            this.oldVal = oldValue;
            this.newVal = newValue;
        }

        public RTProperties getSource() {
            return RTProperties.this;
        }

        public Object getKey() {
            return this.keyObj;
        }

        public Object getOldValue() {
            return this.oldVal;
        }

        public Object getNewValue() {
            return this.newVal;
        }
    }

    public static interface PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent var1);
    }
}

