/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.util;

import java.io.PrintStream;
import java.util.Iterator;
import java.util.Map;
import org.opengts.util.OrderedMap;
import org.opengts.util.OrderedSet;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;
import org.opengts.util.RTProperties;
import org.opengts.util.StringTools;

public class RTKey
implements Comparable<RTKey> {
    public static final String NULL_VALUE = "<null>";
    public static final String DEFAULT_LOCALE = "en";
    public static final String DEFAULT_DATEFORMAT = "yyyy/MM/dd";
    public static final String DEFAULT_TIMEFORMAT = "HH:mm:ss";
    public static final String SESSION_NAME = "session.name";
    public static final String SESSION_LOCALE = "session.locale";
    public static final String SESSION_USER = "session.user";
    public static final String SESSION_IPADDRESS = "session.ipAddress";
    public static final String RT_QUIET = "rtquiet";
    public static final String RT_VERBOSE = "rtverbose";
    public static final String RT_PID_FILE = "rtpidfile";
    public static final String RT_CONTEXT_NAME = "rtcontext.name";
    public static final String RT_CONTEXT_PATH = "rtcontext.path";
    public static final String LOCALE = "locale";
    public static final String LOCALE_DATEFORMAT = "locale.dateFormat";
    public static final String LOCALE_TIMEFORMAT = "locale.timeFormat";
    public static final String CONFIG_FILE_DIR = "configFileDir";
    public static final String WEBAPP_FILE = "webappFile";
    public static final String CONFIG_FILE = "configFile";
    public static final String COMMAND_LINE_CONF = "conf";
    public static final String TEST_MODE = "testMode";
    public static final String DEBUG = "debug";
    public static final String DEBUG_MODE = "debugMode";
    public static final String ADMIN_MODE = "adminMode";
    public static final String HTTP_USER_AGENT = "http.userAgent";
    public static final String HTTP_PROXY_HOST = "http.proxy.host";
    public static final String HTTP_PROXY_PORT = "http.proxy.port";
    public static final String URL_CONNECT_TIMEOUT = "url.connect.timeout";
    public static final String URL_READ_TIMEOUT = "url.read.timeout";
    public static final String SMTP_DEBUG = "smtp.debug";
    public static final String SMTP_SERVER_HOST = "smtp.host";
    public static final String SMTP_SERVER_PORT = "smtp.port";
    public static final String SMTP_SERVER_USER = "smtp.user";
    public static final String SMTP_SERVER_USER_EMAIL = "smtp.user.emailAddress";
    public static final String SMTP_SERVER_PASSWORD = "smtp.password";
    public static final String SMTP_ENABLE_SSL = "smtp.enableSSL";
    public static final String SMTP_ENABLE_TLS = "smtp.enableTLS";
    public static final String SMTP_THREAD_MODEL = "smtp.threadModel";
    public static final String SMTP_THREAD_MODEL_SHOW = "smtp.threadModel.show";
    public static final String SMTP_IGNORED_EMAIL_FILE = "smtp.ignoredEmail.file";
    public static final String SMTP_SERVER_SYSADMIN_EMAIL = "smtp.sysadmin.emailAddress";
    public static final String[] SMTP_PROPERTIES = new String[]{"smtp.debug", "smtp.host", "smtp.port", "smtp.user", "smtp.user.emailAddress", "smtp.password", "smtp.enableSSL", "smtp.enableTLS", "smtp.threadModel", "smtp.threadModel.show", "smtp.ignoredEmail.file", "smtp.sysadmin.emailAddress"};
    public static final String LOG_NAME = "log.name";
    public static final String LOG_LEVEL = "log.level";
    public static final String LOG_LEVEL_HEADER = "log.level.header";
    public static final String LOG_JAVA_LOGGER = "log.javaLogger";
    public static final String LOG_REDIRECT_LOG = "log.redirectLog";
    public static final String LOG_REMOTE_LOGGING = "log.remoteLogging";
    public static final String LOG_DIR = "log.dir";
    public static final String LOG_FILE = "log.file";
    public static final String LOG_FILE_ENABLE = "log.file.enable";
    public static final String LOG_FILE_ROTATE_SIZE = "log.file.rotate.maxSize";
    public static final String LOG_FILE_ROTATE_EXTN = "log.file.rotate.dateFormatExtn";
    public static final String LOG_FILE_ROTATE_DELETE_AGE = "log.file.rotate.deleteAge";
    public static final String LOG_INCL_DATE = "log.include.date";
    public static final String LOG_INCL_STACKFRAME = "log.include.frame";
    public static final String LOG_EMAIL_EXCEPTIONS = "log.email.sendExceptions";
    public static final String LOG_EMAIL_FROM = "log.email.fromAddr";
    public static final String LOG_EMAIL_TO = "log.email.toAddr";
    public static final String LOG_SENDMAIL_CLASS = "log.email.sendmailClass";
    public static final String DB_DBCONNECTION_POOL = "db.dbConnectionPool";
    public static final String DB_DATASOURCE_CLASS = "db.dataSource.class";
    public static final String DB_DATASOURCE_MAX_ACTIVE = "db.dataSource.maxActive";
    public static final String DB_DATASOURCE_MAX_IDLE = "db.dataSource.maxIdle";
    public static final String DB_DATASOURCE_MAX_WAIT = "db.dataSource.maxWait";
    public static final String DB_PROVIDER = "db.sql.provider";
    public static final String DB_NAME = "db.sql.dbname";
    public static final String DB_URL = "db.sql.url";
    public static final String DB_URL_DB = "db.sql.url.db";
    public static final String DB_HOST = "db.sql.host";
    public static final String DB_PORT = "db.sql.port";
    public static final String DB_USER = "db.sql.user";
    public static final String DB_PASS = "db.sql.password";
    public static final String DB_UTF8 = "db.sql.utf8";
    public static final String DB_TABLE_NAME_PREFIX = "db.tableNamePrefix";
    public static final String DB_TABLE_LOCKING = "db.tableLocking";
    public static final String DB_INCLUDE_LAST_UPDATE_USER = "db.includeLastUpdateUser";
    public static final String DB_SHOW_SQL = "db.showSQL";
    public static final String DB_SHOW_CONNECTIONS = "db.showConnections";
    public static final String DB_ALLOW_UPDATE_KEY_FIELDS = "db.allowUpdateKeyFields";
    public static final String DB_INACTIVE_TIMEOUT = "db.inactiveTimeout";
    public static final String DB_MYSQL_TBLEXIST_SEL_COUNT = "db.mysql.tableExistsSelectCount";
    public static final String DB_TYPESIZE_ = "db.typeSize.";
    public static final String DB_TYPEINT_ = "db.typeInt.";
    public static final String DB_IGNORE_COLUMN_ERROR_ = "db.ignoreColumnError.";
    public static final String _DB_LOG_MISSING_COLUMNS = ".logMissingColumns";
    public static final String OSTOOLS_MEMORY_CHECK_ENABLE = "OSTools.memoryCheckEnabled";
    public static final String OSTOOLS_MEMORY_TREND_WEIGHT = "OSTools.memoryTrendWeight";
    public static final String OSTOOLS_MEMORY_USAGE_WARN = "OSTools.memoryUsageWarning";
    public static final String ThreadPool_CronTask_ = "Cron.ThreadPool.";
    public static final String ThreadPool_SendMail_ = "SendMail.ThreadPool.";
    public static final String ThreadPool_EventRuleAction_ = "Rule.ThreadPool.EventRuleAction.";
    public static final String ThreadPool_DeviceEventUpdate_ = "Device.ThreadPool.DeviceEventUpdate.";
    public static final String CONSTANT_PREFIX = "%";
    public static final String VERSION = "%version";
    public static final String IS_WEBAPP = "%isWebApp";
    public static final String MAIN_COMMAND = "%mainCommand";
    public static final String MAIN_JAR = "%mainJar";
    public static final String MAIN_CLASS = "%mainClass";
    public static final String CONTEXT_NAME = "%contextName";
    public static final String CONTEXT_PATH = "%contextPath";
    public static final String HOST_NAME = "%hostName";
    public static final String HOST_IP = "%hostIP";
    public static final String OS_TYPE = "%osType";
    public static final String OS_SUBTYPE = "%osSubtype";
    public static final String PROCESS_ID = "%pid";
    public static final String NAME = "%name";
    public static final String CONFIG_URL = "%configURL";
    public static final String LOG = "%log";
    public static final String INCLUDE = "%include";
    public static final String INCLUDE_OPT = "%include?";
    protected static Entry NullEntry = new Entry("", null);
    protected static Entry[] runtimeKeys = new Entry[]{new Entry("General mode attributes"), new Entry("adminMode", false, "Admin mode enabled"), new Entry("debugMode", false, "Debug mode enabled"), new Entry("testMode", false, "Test mode enabled"), new Entry("%isWebApp", false, "IsWebApp"), new Entry("Runtime config file attributes"), new Entry("configFileDir", "/conf", "Runtime config file directory"), new Entry("configFile", "default.conf", "Default runtime config file"), new Entry("webappFile", "webapp.conf", "Default webapp config file"), new Entry("Web Session context attributes"), new Entry("session.name", null, "Session context name"), new Entry("session.locale", "en", "Session locale"), new Entry("session.user", null, "Session user"), new Entry("session.ipAddress", null, "Session IP address"), new Entry("HTTP/URL attributes"), new Entry("http.userAgent", null, "HTTP user agent"), new Entry("http.proxy.host", null, "HTTP proxy host"), new Entry("http.proxy.port", -1, "HTTP proxy port"), new Entry("url.connect.timeout", 60000L, "URL connection timeout (msec)"), new Entry("url.read.timeout", 60000L, "URL read timeout (msec)"), new Entry("Locale attributes"), new Entry("locale", "en", "Locale"), new Entry("locale.dateFormat", "yyyy/MM/dd", "Locale Date Format"), new Entry("locale.timeFormat", "HH:mm:ss", "Locale Time Format"), new Entry("SMTP (mail) attributes"), new Entry("smtp.host", "smtp.example.com", "SMTP server host"), new Entry("smtp.port", 25, "SMTP server port"), new Entry("smtp.user", null, "SMTP server user"), new Entry("smtp.user.emailAddress", null, "SMTP User Email address (if required)"), new Entry("smtp.password", null, "SMTP server password"), new Entry("smtp.enableSSL", false, "SMTP enable SSL"), new Entry("smtp.enableTLS", false, "SMTP enable TLS"), new Entry("smtp.threadModel", null, "Send-Mail thread model"), new Entry("smtp.threadModel.show", false, "Print/show Send-Mail thread model"), new Entry("smtp.ignoredEmail.file", null, "File containing ignored email addresses"), new Entry("smtp.debug", false, "Sendmail debug mode"), new Entry("smtp.sysadmin.emailAddress", null, "SMTP System Admin Email address"), new Entry("'Print' util attributes"), new Entry("log.name", null, "log name"), new Entry("log.level", 6, "log level"), new Entry("log.level.header", 6, "log header level"), new Entry("log.javaLogger", false, "log to java.util.Logger"), new Entry("log.redirectLog", null, "redirect logging to OutputStream"), new Entry("log.remoteLogging", null, "remote log 'host:port'"), new Entry("log.dir", null, "log directory"), new Entry("log.file", null, "log file name"), new Entry("log.file.enable", false, "log file enable"), new Entry("log.file.rotate.maxSize", 200000L, "log file rotate max size"), new Entry("log.file.rotate.dateFormatExtn", "yyyyMMddHHmmss'.log'", "log file rotate date format extension"), new Entry("log.file.rotate.deleteAge", "0", "log file rotate delete age (default days)"), new Entry("log.include.date", false, "include date in logs"), new Entry("log.include.frame", false, "include stackframe in logs"), new Entry("log.email.sendExceptions", false, "EMail exceptions"), new Entry("log.email.fromAddr", null, "Error email sender"), new Entry("log.email.toAddr", null, "Error email recipient"), new Entry("log.email.sendmailClass", RTKey.SENDMAIL_CLASS(), "Sendmail class name"), new Entry("DB attributes"), new Entry("db.dbConnectionPool", false, "DBConnection Pooling"), new Entry("db.dataSource.class", "", "DataSource class"), new Entry("db.dataSource.maxActive", 100, "DataSource maxActive"), new Entry("db.dataSource.maxIdle", 30, "DataSource maxIdle"), new Entry("db.dataSource.maxWait", 10000L, "DataSource maxWait"), new Entry("db.sql.provider", "mysql", "Database provider"), new Entry("db.sql.dbname", "?", "Database name"), new Entry("db.sql.url", "", "Database JDBC URL"), new Entry("db.sql.url.db", "", "Database JDBC URL (incl DB name)"), new Entry("db.sql.host", "127.0.0.1", "Database server host"), new Entry("db.sql.port", -1, "Database server port"), new Entry("db.sql.user", "", "Database server user"), new Entry("db.sql.password", "", "Database server password"), new Entry("db.sql.utf8", false, "Enable UTF8"), new Entry("db.tableNamePrefix", "", "Table name prefix"), new Entry("db.tableLocking", false, "Table locking enabled"), new Entry("db.includeLastUpdateUser", false, "Include 'lastUpdateUser'"), new Entry("db.showSQL", false, "Show insert/update SQL"), new Entry("db.showConnections", false, "Show connections"), new Entry("db.allowUpdateKeyFields", false, "Allow updating key fields"), new Entry("db.inactiveTimeout", 21600L, "Inactive connection timeout"), new Entry("db.mysql.tableExistsSelectCount", true, "MySQL tableExist use SELECT COUNT(*)"), new Entry("OSTools attributes"), new Entry("OSTools.memoryCheckEnabled", false, "Enable memory checks"), new Entry("OSTools.memoryTrendWeight", 0.15, "Memory Check Trend Weight"), new Entry("OSTools.memoryUsageWarning", 0.9, "Memory Usage Limit Warning")};
    protected static Map<String, Entry> globalEntryMap = null;
    protected static RTProperties defaultProperties = null;
    public String keyName = "";

    private static String SENDMAIL_CLASS() {
        return RTKey.class.getPackage().getName() + ".Send" + "Mail";
    }

    protected static Map<String, Entry> getRuntimeEntryMap() {
        if (globalEntryMap == null) {
            globalEntryMap = new OrderedMap<String, Entry>();
            for (int i = 0; i < runtimeKeys.length; ++i) {
                String rtKey = runtimeKeys[i].getKey();
                if (rtKey == null) continue;
                globalEntryMap.put(rtKey, runtimeKeys[i]);
            }
        }
        return globalEntryMap;
    }

    public static Iterator<String> getRuntimeKeyIterator() {
        return RTKey.getRuntimeEntryMap().keySet().iterator();
    }

    public static void addRuntimeEntries(Entry[] dftEntry) {
        if (dftEntry != null) {
            Map<String, Entry> gblmap = RTKey.getRuntimeEntryMap();
            for (int i = 0; i < dftEntry.length; ++i) {
                String rtKey = dftEntry[i].getKey();
                if (rtKey == null) continue;
                gblmap.put(rtKey, dftEntry[i]);
            }
            defaultProperties = null;
        }
    }

    public static void addRuntimeEntry(Entry dftEntry) {
        String rtKey;
        if (dftEntry != null && (rtKey = dftEntry.getKey()) != null) {
            RTKey.getRuntimeEntryMap().put(rtKey, dftEntry);
            defaultProperties = null;
        }
    }

    protected static Entry getRuntimeEntry(String key) {
        return key != null ? RTKey.getRuntimeEntryMap().get(key) : null;
    }

    public static boolean hasDefault(String key) {
        return RTKey.getRuntimeEntry(key) != null;
    }

    public static Object getDefaultProperty(String key, Object dft) {
        Entry rtKey = RTKey.getRuntimeEntry(key);
        return rtKey != null ? rtKey.getDefault() : dft;
    }

    public static void setDefaultProperty(String key, Object val) {
        Entry rtKey = RTKey.getRuntimeEntry(key);
        if (rtKey != null) {
            rtKey.setDefault(val);
        } else {
            RTKey.addRuntimeEntry(new Entry(key, val));
        }
    }

    public static RTProperties getDefaultProperties() {
        if (defaultProperties == null) {
            RTProperties rtp = new RTProperties();
            for (Entry rtk : RTKey.getRuntimeEntryMap().values()) {
                if (rtk.isHelp()) continue;
                String key = rtk.getKey();
                Object val = rtk.getDefault();
                rtp.setProperty((Object)key, val);
            }
            defaultProperties = rtp;
        }
        return defaultProperties;
    }

    public static void printDefaults(PrintStream out) {
        OrderedSet keyList = new OrderedSet();
        Object keyGrp = null;
        for (Entry rtk : RTKey.getRuntimeEntryMap().values()) {
            if (rtk.isHelp()) {
                out.println("");
                out.println("# ===== " + rtk.getHelp());
                continue;
            }
            Object dft = rtk.getDefault();
            out.println("# --- " + rtk.getHelp());
            out.println("# " + rtk.toString(dft));
            String key = rtk.getKey();
            keyList.add(key);
            if (key.equals(CONFIG_FILE) || !RTConfig.hasProperty(key)) continue;
            String val = RTConfig.getString(key, null);
            out.println(rtk.toString(val));
        }
        RTProperties cmdLineProps = RTConfig.getConfigFileProperties();
        if (cmdLineProps != null) {
            boolean orphanHeader = false;
            Iterator<?> i = cmdLineProps.keyIterator();
            while (i.hasNext()) {
                Object k = i.next();
                if (k.equals(COMMAND_LINE_CONF) || keyList.contains(k)) continue;
                if (!orphanHeader) {
                    out.println("");
                    out.println("# ===== Other entries");
                    orphanHeader = true;
                }
                Object v = cmdLineProps.getProperty(k, null);
                out.println(k + "=" + (v != null ? v : NULL_VALUE));
            }
        }
        out.println("");
    }

    public static boolean isBlank(RTKey key) {
        return key == null ? true : key.isBlank();
    }

    public static RTKey valueOf(String s) {
        return s == null ? null : new RTKey(s);
    }

    public RTKey(String key) {
        this.keyName = StringTools.trim(key);
    }

    public String getName() {
        return this.keyName;
    }

    public boolean isBlank() {
        return StringTools.isBlank(this.keyName);
    }

    public String suffix(String stSfx) {
        String rtk = this.getName();
        String sfx = StringTools.trim(stSfx);
        if (sfx.length() == 0) {
            return rtk;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(rtk);
        if (!rtk.endsWith(".")) {
            sb.append(".");
        }
        if (sfx.startsWith(".")) {
            sb.append(sfx.substring(1));
        } else {
            sb.append(sfx);
        }
        return sb.toString();
    }

    public RTKey rtSuffix(RTKey rtSfx) {
        String sfx = rtSfx != null ? rtSfx.toString() : "";
        return new RTKey(this.suffix(sfx));
    }

    public RTKey rtSuffix(String stSfx) {
        return new RTKey(this.suffix(stSfx));
    }

    public boolean equals(Object otherKey) {
        if (otherKey instanceof RTKey) {
            RTKey otherRTKey = (RTKey)otherKey;
            return this.getName().equals(otherRTKey.getName());
        }
        return false;
    }

    @Override
    public int compareTo(RTKey otherKey) {
        if (otherKey == null) {
            return 1;
        }
        return this.getName().compareTo(otherKey.getName());
    }

    public String toString() {
        return this.getName();
    }

    public String trim() {
        return this.getName();
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public static void main(String[] argv) {
        RTConfig.setCommandLineArgs(argv);
        RTKey.printDefaults(System.out);
    }

    public static class EntryReference {
        private String refKey = null;

        public EntryReference(String key) {
            this.refKey = key;
        }

        public String getKey() {
            return this.refKey;
        }

        public Entry getReferencedEntry() {
            Entry entry = RTKey.getRuntimeEntry(this.getKey());
            if (entry == null) {
                Print.logStackTrace("Entry reference not found: " + this.getKey());
            }
            return entry;
        }

        public String toString() {
            String k = this.getKey();
            return k != null ? k : "";
        }

        public boolean equals(Object other) {
            if (other instanceof EntryReference) {
                return this.toString().equals(other.toString());
            }
            return false;
        }
    }

    public static class Entry {
        private String key = null;
        private Object dft = null;
        private String hlp = null;
        private int ref = 0;

        public Entry(String key, Object dft, String help) {
            this.key = key;
            this.dft = dft;
            this.hlp = help;
        }

        public Entry(String key, Object dft) {
            this(key, dft, null);
        }

        public Entry(String help) {
            this(null, null, help);
        }

        public Entry(String key, int dft, String help) {
            this(key, new Integer(dft), help);
        }

        public Entry(String key, int dft) {
            this(key, dft, (String)null);
        }

        public Entry(String key, long dft, String help) {
            this(key, new Long(dft), help);
        }

        public Entry(String key, long dft) {
            this(key, dft, (String)null);
        }

        public Entry(String key, double dft, String help) {
            this(key, new Double(dft), help);
        }

        public Entry(String key, double dft) {
            this(key, dft, (String)null);
        }

        public Entry(String key, float dft, String help) {
            this(key, new Float(dft), help);
        }

        public Entry(String key, float dft) {
            this(key, dft, (String)null);
        }

        public Entry(String key, boolean dft, String help) {
            this(key, new Boolean(dft), help);
        }

        public Entry(String key, boolean dft) {
            this(key, dft, (String)null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Entry getRealEntry() {
            if (this.dft instanceof EntryReference) {
                Entry entry = null;
                if (this.ref > 0) {
                    Print.logStackTrace("Cyclical EntryReference: " + this.getKey());
                    entry = NullEntry;
                } else {
                    ++this.ref;
                    try {
                        EntryReference entryRef = (EntryReference)this.dft;
                        Entry nextEntry = entryRef.getReferencedEntry();
                        entry = nextEntry != null ? nextEntry.getRealEntry() : NullEntry;
                    }
                    finally {
                        --this.ref;
                    }
                }
                return entry;
            }
            return this;
        }

        public boolean isReference() {
            return this.dft instanceof EntryReference;
        }

        public String getKey() {
            return this.key;
        }

        public Object getDefault() {
            return this.isReference() ? this.getRealEntry().getDefault() : this.dft;
        }

        public void setDefault(Object val) {
            this.dft = val;
        }

        public boolean isHelp() {
            return this.key == null;
        }

        public String getHelp() {
            return this.hlp != null ? this.hlp : "";
        }

        public String toString(Object v) {
            StringBuffer sb = new StringBuffer();
            if (this.isHelp()) {
                sb.append("# --- ").append(this.getHelp());
            } else {
                sb.append(this.getKey()).append("=");
                sb.append(v != null ? v : RTKey.NULL_VALUE);
            }
            return sb.toString();
        }

        public String toString() {
            return this.toString(this.getDefault());
        }
    }
}

