/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.util;

import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Stack;
import java.util.Vector;
import org.opengts.util.FileTools;
import org.opengts.util.ListTools;
import org.opengts.util.OSTools;
import org.opengts.util.OrderedMap;
import org.opengts.util.OrderedSet;
import org.opengts.util.Print;
import org.opengts.util.RTKey;
import org.opengts.util.RTProperties;
import org.opengts.util.StringTools;
import org.opengts.util.ThreadLocalMap;

public class RTConfig {
    private static boolean ENABLE_ENVIRONMENT_VARIABLES = true;
    private static boolean verbose = false;
    private static boolean quiet = false;
    private static String localhostName = null;
    private static final int THREAD_LOCAL = 0;
    private static final int RUNTIME_CONSTANT = 1;
    private static final int SERVLET_CONTEXT = 2;
    private static final int COMMAND_LINE = 3;
    private static final int CONFIG_FILE = 4;
    private static final int SYSTEM_PROPS = 5;
    private static final int ENVIRONMENT = 6;
    private static RTProperties[] CFG_PROPERTIES = new RTProperties[7];
    private static ThreadLocal<Stack<RTProperties>> CFG_THREAD_TEMPORARY = null;
    private static int _didStartupInit = 0;
    private static boolean _allowSysPropChange = false;
    private static URL _foundConfigURL = null;
    private static File _foundConfigFile = null;
    private static Boolean isRunningAsWebApp = null;
    private static String[] WebAppClassNames = new String[]{"javax.servlet.http.HttpServlet", "org.apache.catalina.core.ApplicationFilterChain"};
    private static boolean Main_init = false;
    private static Class<?> Main_class = null;
    private static String SERVLET_CLASS = "javax.servlet.Servlet";
    private static boolean Servlet_init = false;
    private static Class<?> Servlet_class = null;

    public static PropertySetter getPropertySetter() {
        return new PropertySetter(){

            @Override
            public void setProperty(Object key, Object value) {
                if (key instanceof String) {
                    RTConfig.setProperty((String)key, value);
                } else {
                    RTConfig.setProperty(StringTools.trim(key), value);
                }
            }
        };
    }

    public static PropertyGetter getPropertyGetter() {
        return new PropertyGetter(){

            @Override
            public Object getProperty(Object key, Object value) {
                if (key instanceof String) {
                    return RTConfig.getProperty((String)key, value);
                }
                return RTConfig.getProperty(StringTools.trim(key), value);
            }
        };
    }

    public static void setEnvironmentVariablesEnabled(boolean enable) {
        ENABLE_ENVIRONMENT_VARIABLES = enable;
    }

    public static boolean getEnvironmentVariablesEnabled() {
        return ENABLE_ENVIRONMENT_VARIABLES;
    }

    public static String getHostName() {
        if (localhostName == null) {
            try {
                String hd = InetAddress.getLocalHost().getHostName();
                int p = hd.indexOf(".");
                localhostName = p >= 0 ? hd.substring(0, p) : hd;
            }
            catch (UnknownHostException uhe) {
                localhostName = "UNKNOWN";
            }
        }
        return localhostName;
    }

    public static String getConfigPropertiesIndexName(int ndx) {
        switch (ndx) {
            case 0: {
                return "Thread";
            }
            case 1: {
                return "RTConst";
            }
            case 2: {
                return "Servlet";
            }
            case 3: {
                return "CmdLine";
            }
            case 4: {
                return "CfgFile";
            }
            case 5: {
                return "SysProp";
            }
            case 6: {
                return "EnvVars";
            }
        }
        return "Unk(" + ndx + ")";
    }

    public static void printTemporaryProperties(String msg) {
        Stack<RTProperties> rtpStack;
        if (CFG_THREAD_TEMPORARY != null && (rtpStack = CFG_THREAD_TEMPORARY.get()) != null) {
            int level = 1;
            for (int r = rtpStack.size() - 1; r >= 0; --r) {
                RTProperties rtp = (RTProperties)rtpStack.get(r);
                rtp.printProperties(msg + " #" + level);
                ++level;
            }
        }
    }

    public static RTProperties getTemporaryProperties(String key) {
        Stack<RTProperties> rtpStack;
        if (CFG_THREAD_TEMPORARY != null && (rtpStack = CFG_THREAD_TEMPORARY.get()) != null) {
            for (int r = rtpStack.size() - 1; r >= 0; --r) {
                RTProperties rtp = (RTProperties)rtpStack.get(r);
                if (!rtp.hasProperty(key)) continue;
                return rtp;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static void pushTemporaryProperties(RTProperties props) {
        Stack<RTProperties> rtpStack;
        if (props == null) {
            Print.logStackTrace("**** Attempting to push a null RTProperties instance!");
            return;
        }
        if (CFG_THREAD_TEMPORARY == null) {
            RTProperties[] rTPropertiesArray = CFG_PROPERTIES;
            // MONITORENTER : CFG_PROPERTIES
            if (CFG_THREAD_TEMPORARY == null) {
                CFG_THREAD_TEMPORARY = new ThreadLocal();
            }
            // MONITOREXIT : rTPropertiesArray
        }
        if ((rtpStack = CFG_THREAD_TEMPORARY.get()) == null) {
            rtpStack = new Stack();
            CFG_THREAD_TEMPORARY.set(rtpStack);
        }
        rtpStack.push(props);
    }

    public static void popTemporaryProperties(RTProperties props) {
        if (CFG_THREAD_TEMPORARY != null) {
            Stack<RTProperties> rtpStack = CFG_THREAD_TEMPORARY.get();
            if (rtpStack != null && !rtpStack.empty()) {
                RTProperties rtp = rtpStack.pop();
                if (props != null && props != rtp) {
                    Print.logStackTrace("Unexpected RTProperties at top of stack");
                }
                if (rtpStack.empty()) {
                    CFG_THREAD_TEMPORARY.set(null);
                }
            } else if (props != null) {
                Print.logStackTrace("RTProperties Stack is already empty");
            }
        }
    }

    public static void popAllTemporaryProperties() {
        Stack<RTProperties> rtpStack;
        if (CFG_THREAD_TEMPORARY != null && (rtpStack = CFG_THREAD_TEMPORARY.get()) != null && !rtpStack.empty()) {
            rtpStack.clear();
            CFG_THREAD_TEMPORARY.set(null);
        }
    }

    public static int getTemporaryPropertiesStackSize() {
        if (CFG_THREAD_TEMPORARY != null) {
            Stack<RTProperties> rtpStack = CFG_THREAD_TEMPORARY.get();
            return rtpStack != null ? rtpStack.size() : 0;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RTProperties getThreadProperties() {
        if (CFG_PROPERTIES[0] != null) return CFG_PROPERTIES[0];
        RTProperties[] rTPropertiesArray = CFG_PROPERTIES;
        synchronized (CFG_PROPERTIES) {
            if (CFG_PROPERTIES[0] != null) return CFG_PROPERTIES[0];
            RTConfig.CFG_PROPERTIES[0] = new RTProperties(new ThreadLocalMap());
            // ** MonitorExit[var0] (shouldn't be in output)
            return CFG_PROPERTIES[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RTProperties getRuntimeConstantProperties() {
        if (CFG_PROPERTIES[1] != null) return CFG_PROPERTIES[1];
        RTProperties[] rTPropertiesArray = CFG_PROPERTIES;
        synchronized (CFG_PROPERTIES) {
            if (CFG_PROPERTIES[1] != null) return CFG_PROPERTIES[1];
            RTConfig.CFG_PROPERTIES[1] = new RTProperties();
            // ** MonitorExit[var0] (shouldn't be in output)
            return CFG_PROPERTIES[1];
        }
    }

    public static RTProperties getServletContextProperties() {
        return CFG_PROPERTIES[2];
    }

    public static RTProperties getCommandLineProperties() {
        return CFG_PROPERTIES[3];
    }

    public static RTProperties getConfigFileProperties() {
        if (CFG_PROPERTIES[4] == null) {
            if (verbose) {
                Print.logInfo("Late initialization!!!", new Object[0]);
            }
            RTConfig._startupInit(false);
        }
        if (CFG_PROPERTIES[4] != null) {
            return CFG_PROPERTIES[4];
        }
        Print.sysPrintln("'RTConfig.getConfigFileProperties()' returning temporary RTProperties", new Object[0]);
        return new RTProperties();
    }

    public static RTProperties getSystemProperties() {
        if (CFG_PROPERTIES[5] == null) {
            if (verbose) {
                Print.logInfo("Late initialization!!!", new Object[0]);
            }
            RTConfig._startupInit(false);
        }
        return CFG_PROPERTIES[5];
    }

    public static boolean isCommandLine() {
        return RTConfig.getCommandLineProperties() != null;
    }

    public static boolean isTrueServlet() {
        return !RTConfig.isCommandLine() && RTConfig.isWebApp();
    }

    public static RTProperties getPropertiesForKey(String key, boolean dftOk) {
        if (key != null) {
            RTProperties dftProps;
            RTProperties tempProps;
            if (!RTConfig.isInitialized()) {
                // empty if block
            }
            if ((tempProps = RTConfig.getTemporaryProperties(key)) != null) {
                return tempProps;
            }
            for (int i = 0; i < CFG_PROPERTIES.length; ++i) {
                RTProperties rtProps = CFG_PROPERTIES[i];
                if (rtProps == null || !rtProps.hasProperty(key)) continue;
                return rtProps;
            }
            if (dftOk && (dftProps = RTKey.getDefaultProperties()) != null && dftProps.hasProperty(key)) {
                return dftProps;
            }
        }
        return null;
    }

    public static RTProperties getPropertiesForKey(String[] key, boolean dftOk) {
        if (key != null) {
            for (int i = 0; i < key.length; ++i) {
                RTProperties rtp = RTConfig.getPropertiesForKey(key[i], dftOk);
                if (rtp == null) continue;
                return rtp;
            }
        }
        return null;
    }

    public static String findPropertiesForKey(String key) {
        if (key != null) {
            RTProperties tempProps = RTConfig.getTemporaryProperties(key);
            if (tempProps != null) {
                return "Temporary";
            }
            for (int i = 0; i < CFG_PROPERTIES.length; ++i) {
                RTProperties rtProps = CFG_PROPERTIES[i];
                if (rtProps == null || !rtProps.hasProperty(key)) continue;
                return RTConfig.getConfigPropertiesIndexName(i);
            }
            RTProperties dftProps = RTKey.getDefaultProperties();
            if (dftProps != null && dftProps.hasProperty(key)) {
                return "Defaults";
            }
        }
        return null;
    }

    public static String findPropertiesForKey(String[] key) {
        if (key != null) {
            for (int i = 0; i < key.length; ++i) {
                String name = RTConfig.findPropertiesForKey(key[i]);
                if (StringTools.isBlank(name)) continue;
                return name;
            }
        }
        return null;
    }

    public static int setCommandLineArgs(String[] argv) {
        return RTConfig.setCommandLineArgs(argv, null);
    }

    public static int setCommandLineArgs(String[] argv, String[] keyAttr) {
        RTProperties cmdArgs = argv != null ? new RTProperties(argv) : new RTProperties();
        RTConfig.setCommandLineArgs(cmdArgs, false);
        if (!ListTools.isEmpty(keyAttr) && !cmdArgs.validateKeyAttributes(keyAttr, true)) {
            throw new RuntimeException("Invalid arguments specified");
        }
        return cmdArgs.getNextCommandLineArgumentIndex();
    }

    public static void setCommandLineArgs(RTProperties cmdLineProps) {
        if (cmdLineProps != null) {
            RTConfig.setCommandLineArgs(cmdLineProps, false);
        } else {
            RTConfig.setCommandLineArgs(new RTProperties(), false);
        }
    }

    public static int setCommandLineArgs(String[] argv, boolean testMode) {
        RTProperties cmdArgs = argv != null ? new RTProperties(argv) : new RTProperties();
        RTConfig.setCommandLineArgs(cmdArgs, testMode);
        return cmdArgs.getNextCommandLineArgumentIndex();
    }

    public static void setCommandLineArgs(RTProperties cmdLineProps, boolean testMode) {
        if (cmdLineProps != null) {
            cmdLineProps.setIgnoreKeyCase(true);
            if (CFG_PROPERTIES[3] == null) {
                RTConfig.CFG_PROPERTIES[3] = cmdLineProps;
                RTConfig._startupInit(true);
            } else {
                CFG_PROPERTIES[3].setProperties(cmdLineProps);
            }
        } else {
            RTConfig._startupInit(true);
        }
    }

    private static Set<String> _parseArgs(Object argv, Set<String> set) {
        if (argv != null && set != null) {
            if (argv instanceof Object[]) {
                Object[] a = (Object[])argv;
                for (int i = 0; i < a.length; ++i) {
                    RTConfig._parseArgs(a[i], set);
                }
            } else {
                set.add(argv.toString());
            }
        }
        return set;
    }

    public static String[] validateCommandLineArgs(Object argv) {
        RTProperties cmdLineProps = RTConfig.getCommandLineProperties();
        if (cmdLineProps != null) {
            Vector<String> badArgs = new Vector<String>();
            HashSet<String> argSet = new HashSet<String>();
            RTConfig._parseArgs(argv, argSet);
            Iterator<?> keys = cmdLineProps.keyIterator();
            while (keys.hasNext()) {
                String k = (String)keys.next();
                if (RTKey.hasDefault(k) || "conf".equals(k) || argSet.contains(k)) continue;
                badArgs.add(k);
            }
            return badArgs.isEmpty() ? null : badArgs.toArray(new String[badArgs.size()]);
        }
        return null;
    }

    public static void _setServletContextProperties(RTProperties props) {
        RTConfig.CFG_PROPERTIES[2] = props;
    }

    public static void setServletContextProperties(Map<Object, Object> props) {
        RTConfig.setWebApp(true);
        RTConfig._setServletContextProperties(new RTProperties(props));
        RTConfig._startupInit(false);
    }

    public static void clearServletContextProperties(Object servlet) {
        RTConfig._setServletContextProperties(null);
    }

    public static boolean isInitializing() {
        return _didStartupInit == 1;
    }

    public static boolean isInitialized() {
        return _didStartupInit == 2;
    }

    public static URL getLoadedConfigURL() {
        return _foundConfigURL;
    }

    public static File getLoadedConfigFile() {
        if (_foundConfigFile == null && _foundConfigURL != null && _foundConfigURL.getProtocol().equalsIgnoreCase("file")) {
            try {
                _foundConfigFile = FileTools.toFile(_foundConfigURL);
            }
            catch (URISyntaxException use) {
                Print.logException("Unable to convert URL to File: " + _foundConfigURL, use);
            }
        }
        return _foundConfigFile;
    }

    public static File getLoadedConfigDir() {
        File cfgFile = RTConfig.getLoadedConfigFile();
        if (cfgFile != null) {
            return cfgFile.getParentFile();
        }
        return null;
    }

    protected static URL getConfigURL() {
        try {
            URL cfgURL = RTConfig._getConfigURL();
            if (cfgURL != null) {
                if (verbose) {
                    Print.logInfo("Config URL found at " + cfgURL, new Object[0]);
                }
                return cfgURL;
            }
            if (!quiet) {
                Print.logWarn("No valid config URL was found", new Object[0]);
            }
            return null;
        }
        catch (MalformedURLException mue) {
            Print.logError("Invalid URL: " + mue, new Object[0]);
        }
        catch (Throwable t) {
            Print.logException("Invalid URL", t);
        }
        return null;
    }

    protected static URL _getConfigURL() throws MalformedURLException {
        String cfgExtn;
        String cfgName;
        File rtCfgFile;
        File rtCfgDir;
        String hostName;
        block26: {
            Class<?> mainClass;
            File cfgFile;
            boolean isTrueServlet;
            hostName = RTConfig.getHostName();
            RTProperties cmdLineProps = RTConfig.getCommandLineProperties();
            RTProperties constantProps = RTConfig.getRuntimeConstantProperties();
            boolean isCommandLine = cmdLineProps != null;
            boolean bl = isTrueServlet = !isCommandLine && RTConfig.isWebApp();
            if (RTConfig.hasProperty("configFile", false)) {
                File cfgFile2 = RTConfig.getFile("configFile");
                if (RTConfig.hasProperty("configFileDir", false)) {
                    File cfgDir = RTConfig.getFile("configFileDir");
                    cfgFile2 = new File(cfgDir, cfgFile2.toString());
                }
                if (cfgFile2.isFile()) {
                    return FileTools.toURL(cfgFile2);
                }
                Print.logError("Explicitly specified config file does not exist: " + cfgFile2, new Object[0]);
                return null;
            }
            if (isCommandLine && (cfgFile = cmdLineProps.getFile("conf", null)) != null) {
                if (RTConfig.hasProperty("configFileDir", false)) {
                    File cfgDir = RTConfig.getFile("configFileDir");
                    cfgFile = new File(cfgDir, cfgFile.toString());
                }
                if (cfgFile.isFile()) {
                    URL fileURL = FileTools.toURL(cfgFile);
                    return fileURL;
                }
                Print.logError("Explicitly specified config file does not exist: " + cfgFile, new Object[0]);
                return null;
            }
            rtCfgDir = null;
            rtCfgFile = null;
            if (isTrueServlet) {
                rtCfgDir = RTConfig.getFile("configFileDir");
                rtCfgFile = RTConfig.getFile("webappFile");
            } else {
                rtCfgFile = RTConfig.getFile("configFile");
                if (rtCfgFile.isAbsolute()) {
                    rtCfgDir = rtCfgFile.getParentFile();
                    rtCfgFile = new File(rtCfgFile.getName());
                } else {
                    File cf = new File(RTConfig.getFile("configFileDir"), rtCfgFile.toString());
                    rtCfgDir = cf.getParentFile();
                    rtCfgFile = new File(cf.getName());
                }
            }
            String cfgFileName = rtCfgFile.toString();
            int cfgExtPos = cfgFileName.lastIndexOf(".");
            cfgName = cfgExtPos >= 0 ? cfgFileName.substring(0, cfgExtPos) : cfgFileName;
            String string = cfgExtn = cfgExtPos >= 0 ? cfgFileName.substring(cfgExtPos) : "";
            if (isTrueServlet) {
                String ctxPath;
                if (RTConfig.getServletContextProperties() == null) {
                    Print.logWarn("---------------------------------------------------------------------", new Object[0]);
                    Print.logWarn("** WebApp: " + RTConfig.getServletClassName(), new Object[0]);
                    Print.logWarn("** Appears to be missing the 'RTConfigContextListener' initialization", new Object[0]);
                    Print.logWarn("---------------------------------------------------------------------", new Object[0]);
                }
                if (!StringTools.isBlank(ctxPath = RTConfig.getContextPath())) {
                    File web_inf = new File(ctxPath, "WEB-INF");
                    File webInfHostFile = new File(web_inf, cfgName + "_" + hostName + cfgExtn);
                    if (webInfHostFile.isFile()) {
                        return FileTools.toURL(webInfHostFile);
                    }
                    File webInfFile = new File(web_inf, cfgFileName);
                    if (webInfFile.isFile()) {
                        return FileTools.toURL(webInfFile);
                    }
                    Print.logWarn("Config file not found in Servlet: " + RTConfig.getServletClassName(), new Object[0]);
                } else {
                    Print.logWarn("Servlet is missing 'CONTEXT_PATH' [1]: " + RTConfig.getServletClassName(), new Object[0]);
                }
            }
            if ((mainClass = RTConfig.getMainClass()) != null) {
                try {
                    ClassLoader mainClassLoader = mainClass.getClassLoader();
                    if (mainClassLoader == null) {
                        mainClassLoader = ClassLoader.getSystemClassLoader();
                    }
                    if (mainClassLoader != null) {
                        URL cfgHostRes = mainClassLoader.getResource(cfgName + "_" + hostName + cfgExtn);
                        if (cfgHostRes != null) {
                            return cfgHostRes;
                        }
                        URL cfgRes = mainClassLoader.getResource(cfgFileName);
                        if (cfgRes != null) {
                            return cfgRes;
                        }
                        break block26;
                    }
                    Print.logWarn("System class loader is null", new Object[0]);
                }
                catch (Throwable t) {
                    Print.logException("Error retrieving class loader", t);
                }
            } else {
                Print.logInfo("Main class not found ...", new Object[0]);
            }
        }
        File cfgDirHostFile = new File(rtCfgDir, cfgName + "_" + hostName + cfgExtn);
        if (cfgDirHostFile.isFile()) {
            return FileTools.toURL(cfgDirHostFile);
        }
        File cfgDirFile = new File(rtCfgDir, rtCfgFile.toString());
        if (cfgDirFile.isFile()) {
            return FileTools.toURL(cfgDirFile);
        }
        return null;
    }

    public static synchronized void reload() {
        if (_didStartupInit == 0) {
            Print.logWarn("Calling 'reload' when initialization was never called in the first place", new Object[0]);
        } else {
            Print.logInfo("Reloading RTConfig ...", new Object[0]);
        }
        _didStartupInit = 0;
        RTConfig._startupInit(_allowSysPropChange);
    }

    protected static synchronized void _startupInit(boolean allowChangeSystemProperties) {
        long urlReadTimeout;
        long urlConnectTimeout;
        Class<?> mainClass;
        String[] path;
        String[] cmds;
        String sun_java_command;
        String ctxPath;
        String ctxName;
        if (_didStartupInit == 2) {
            return;
        }
        if (_didStartupInit == 1) {
            Print.logError("_startupInit' is already initializing!", new Object[0]);
            Print.logStackTrace("_startupInit' is already initializing!");
            return;
        }
        _allowSysPropChange = allowChangeSystemProperties;
        _didStartupInit = 1;
        RTProperties cmdLineProps = RTConfig.getCommandLineProperties();
        RTProperties constantProps = RTConfig.getRuntimeConstantProperties();
        if (RTConfig.hasProperty("rtverbose", false)) {
            verbose = RTConfig.getBoolean("rtverbose", false);
        }
        if (RTConfig.hasProperty("rtquiet", false) && (quiet = RTConfig.getBoolean("rtquiet", false))) {
            verbose = false;
        }
        if (RTConfig.hasProperty("debug", false)) {
            boolean debug;
            RTProperties debugRTP = RTConfig.getPropertiesForKey("debug", false);
            if (!RTConfig.hasProperty("debugMode", false)) {
                debug = debugRTP.getBoolean("debug", false);
                debugRTP.setProperty("debugMode", debug);
            } else {
                debug = RTConfig.getBoolean("debugMode", true, false);
                debugRTP.setProperty("debug", debug);
            }
        }
        if (RTConfig.getBoolean("debugMode")) {
            if (cmdLineProps != null && !cmdLineProps.hasProperty("log.level")) {
                cmdLineProps.setString("log.level", "debug");
            }
            Print.setLogLevel(5);
        }
        _foundConfigFile = null;
        _foundConfigURL = RTConfig.getConfigURL();
        if (cmdLineProps != null && !RTConfig.hasContextName() && !StringTools.isBlank(ctxName = cmdLineProps.getString("%contextName", cmdLineProps.getString("rtcontext.name", null)))) {
            RTConfig.setContextName(ctxName);
        }
        if (cmdLineProps != null && !RTConfig.hasContextPath() && !StringTools.isBlank(ctxPath = cmdLineProps.getString("%contextPath", cmdLineProps.getString("rtcontext.path", null)))) {
            RTConfig.setContextPath(ctxPath);
        }
        if (!constantProps.hasProperty("%mainCommand")) {
            sun_java_command = System.getProperty("sun.java.command", null);
            String java_class_path = System.getProperty("java.class.path", null);
            cmds = StringTools.split(sun_java_command, ' ');
            path = StringTools.split(java_class_path, File.pathSeparatorChar);
            String mainCmd = cmds.length > 0 ? cmds[0] : "";
            constantProps.setProperty((Object)"%mainCommand", mainCmd);
        }
        if (!constantProps.hasProperty("%mainJar")) {
            sun_java_command = System.getProperty("sun.java.command", null);
            String java_class_path = System.getProperty("java.class.path", null);
            cmds = StringTools.split(sun_java_command, ' ');
            path = StringTools.split(java_class_path, File.pathSeparatorChar);
            String mainJar = null;
            mainJar = cmds.length > 0 && StringTools.endsWithIgnoreCase(cmds[0], ".jar") ? cmds[0] : (path.length == 1 && StringTools.endsWithIgnoreCase(path[0], ".jar") ? path[0] : "");
            constantProps.setProperty((Object)"%mainJar", mainJar);
        }
        if (!constantProps.hasProperty("%mainClass") && (mainClass = RTConfig.getMainClass()) != null) {
            constantProps.setProperty((Object)"%mainClass", mainClass);
            if (!RTConfig.hasContextName()) {
                String mainClassStr = StringTools.className(mainClass);
                int c = mainClassStr.lastIndexOf(".");
                if (c >= 0) {
                    String pkgName = mainClassStr.substring(0, c);
                    int p = pkgName.lastIndexOf(".");
                    if (p >= 0) {
                        String ctxName2 = pkgName.substring(p + 1);
                        RTConfig.setContextName(ctxName2);
                    } else {
                        RTConfig.setContextName(pkgName);
                    }
                } else {
                    RTConfig.setContextName(mainClassStr);
                }
            }
        }
        if (!RTConfig.hasContextPath() && _foundConfigURL != null && _foundConfigURL.getProtocol().equalsIgnoreCase("file")) {
            try {
                File cfgFile = FileTools.toFile(_foundConfigURL);
                String contextPath = null;
                try {
                    contextPath = cfgFile.getCanonicalFile().getParent();
                }
                catch (IOException ioe) {
                    contextPath = cfgFile.getParent();
                }
                RTConfig.setContextPath(contextPath);
            }
            catch (URISyntaxException use) {
                Print.logException("Unable to convert URL to File: " + _foundConfigURL, use);
            }
        }
        if (!constantProps.hasProperty("%hostName")) {
            try {
                String hostName = InetAddress.getLocalHost().getHostName();
                InetAddress hostIP = InetAddress.getByName(hostName);
                String hostIPStr = hostIP != null ? hostIP.toString() : "";
                int h = hostIPStr.indexOf("/");
                if (h >= 0) {
                    hostIPStr = hostIPStr.substring(h + 1);
                }
                constantProps.setProperty((Object)"%hostName", hostName);
                constantProps.setProperty((Object)"%hostIP", hostIPStr);
            }
            catch (UnknownHostException uhe) {
                Print.logException("Error obtaining local host name (name not specified in '/etc/hosts'?)", uhe);
            }
        }
        if (!constantProps.hasProperty("%osType")) {
            int osType = OSTools.getOSType();
            constantProps.setProperty((Object)"%osType", OSTools.getOSTypeName(osType, false));
            constantProps.setProperty((Object)"%osSubtype", OSTools.getOSTypeName(osType, true));
        }
        if (!constantProps.hasProperty("%pid")) {
            boolean ok;
            File pidFile;
            int pid = OSTools.getProcessID();
            constantProps.setProperty("%pid", pid);
            if (cmdLineProps != null && cmdLineProps.hasProperty("rtpidfile") && (pidFile = cmdLineProps.getFile("rtpidfile", null)) != null && !(ok = OSTools.writePidFile(pidFile, true))) {
                Print.logError("Unable to create PID file: " + pidFile, new Object[0]);
            }
        }
        Properties propMap = null;
        if (_allowSysPropChange) {
            try {
                propMap = System.getProperties();
            }
            catch (SecurityException se) {
                Print.sysPrintln("ERROR: Attempting to call 'System.getProperties()': " + se, new Object[0]);
            }
        } else {
            propMap = new Properties();
            Iterator<String> i = RTKey.getRuntimeKeyIterator();
            while (i.hasNext()) {
                String key = i.next();
                try {
                    String val = System.getProperty(key, null);
                    if (val == null) continue;
                    propMap.setProperty(key, val);
                }
                catch (SecurityException se) {
                    Print.sysPrintln("Attempting to get System property '" + key + "': " + se, new Object[0]);
                }
            }
        }
        RTConfig.CFG_PROPERTIES[5] = new RTProperties(propMap);
        if (RTConfig.getEnvironmentVariablesEnabled()) {
            try {
                Map<String, String> envMap = System.getenv();
                RTConfig.CFG_PROPERTIES[6] = new RTProperties(envMap);
            }
            catch (Throwable th) {
                RTConfig.CFG_PROPERTIES[6] = null;
            }
        }
        if (_foundConfigURL != null) {
            RTConfig.CFG_PROPERTIES[4] = new RTProperties(_foundConfigURL);
            if (verbose) {
                Print.logInfo("Loaded config URL: " + _foundConfigURL, new Object[0]);
            }
        } else {
            RTConfig.CFG_PROPERTIES[4] = new RTProperties();
            if (verbose) {
                Print.logWarn("No config file was found", new Object[0]);
            }
        }
        CFG_PROPERTIES[4].setKeyReplacementMode(2);
        String proxyHost = RTConfig.getString("http.proxy.host");
        int proxyPort = RTConfig.getInt("http.proxy.port");
        if (proxyHost != null && proxyPort > 1024) {
            String port = String.valueOf(proxyPort);
            System.setProperty("proxySet", "true");
            System.setProperty("proxyHost", proxyHost);
            System.setProperty("proxyPort", port);
            System.setProperty("http.proxyHost", proxyHost);
            System.setProperty("http.proxyPort", port);
            System.setProperty("firewallSet", "true");
            System.setProperty("firewallHost", proxyHost);
            System.setProperty("firewallPort", port);
        }
        if ((urlConnectTimeout = RTConfig.getLong("url.connect.timeout")) > 0L) {
            String timeout = String.valueOf(urlConnectTimeout);
            System.setProperty("sun.net.client.defaultConnectTimeout", timeout);
        }
        if ((urlReadTimeout = RTConfig.getLong("url.read.timeout")) > 0L) {
            String timeout = String.valueOf(urlReadTimeout);
            System.setProperty("sun.net.client.defaultReadTimeout", timeout);
        }
        _didStartupInit = 2;
        String remLogging = RTConfig.getString("log.remoteLogging");
        if (!StringTools.isBlank(remLogging)) {
            Print.setRemoteLogging(remLogging);
        }
        Print.resetVars();
    }

    public static URL getClassResourceURL(Class C) {
        if (C == null) {
            return null;
        }
        ClassLoader CL = C.getClassLoader();
        if (CL == null) {
            CL = ClassLoader.getSystemClassLoader();
        }
        if (CL == null) {
            return null;
        }
        return CL.getResource(C.getName().replace('.', '/') + ".class");
    }

    public static void printAllProperties(boolean merge) {
        if (merge) {
            OrderedMap<String, String[]> props = new OrderedMap<String, String[]>();
            for (int i = 0; i < CFG_PROPERTIES.length; ++i) {
                if (CFG_PROPERTIES[i] == null) continue;
                String cpName = RTConfig.getConfigPropertiesIndexName(i);
                Map<Object, Object> cp = CFG_PROPERTIES[i].getProperties();
                for (Object _cpKey : cp.keySet()) {
                    String cpKey = StringTools.trim(_cpKey);
                    if (props.containsKey(cpKey)) continue;
                    String cpVal = StringTools.trim(cp.get(_cpKey));
                    props.put(cpKey, new String[]{cpName, cpVal});
                }
            }
            Vector keyList = new Vector(props.keySet());
            ListTools.sort(keyList, null);
            Print.sysPrintln("", new Object[0]);
            for (String cpKey : keyList) {
                String[] v = (String[])props.get(cpKey);
                String cpName = v[0];
                String cpVal = v[1];
                StringBuffer sb = new StringBuffer();
                sb.append("[").append(StringTools.leftAlign(cpName, 7)).append("] ");
                sb.append(StringTools.leftAlign(cpKey, 44));
                sb.append("= ");
                sb.append(StringTools.leftAlign(cpVal, 50));
                Print.sysPrintln(sb.toString(), new Object[0]);
            }
        } else {
            for (int i = 0; i < CFG_PROPERTIES.length; ++i) {
                if (CFG_PROPERTIES[i] == null) continue;
                RTProperties rtp = CFG_PROPERTIES[i];
                String cpName = RTConfig.getConfigPropertiesIndexName(i);
                Print.sysPrintln("", new Object[0]);
                rtp.printProperties(cpName + ":");
            }
        }
    }

    public static String insertKeyValues(String text) {
        return RTConfig._insertKeyValues(null, text, "${", "}", "=", null, true);
    }

    public static String insertKeyValues(String text, Map<String, String> customMap) {
        return RTConfig._insertKeyValues(null, text, "${", "}", "=", customMap, true);
    }

    public static String insertKeyValues(String text, String startDelim, String endDelim, String dftDelim) {
        return RTConfig._insertKeyValues(null, text, startDelim, endDelim, dftDelim, null, true);
    }

    public static String _insertKeyValues(Object mainKey, String text) {
        return RTConfig._insertKeyValues(mainKey, text, "${", "}", "=", null, true);
    }

    private static String _insertKeyValues(final Object mainKey, String text, String startDelim, String endDelim, String dftDelim, final Map<String, String> customMap, final boolean rtOK) {
        if (text != null) {
            StringTools.KeyValueMap rm = new StringTools.KeyValueMap(){
                private Set<Object> thisKeySet = new HashSet<Object>();
                private Set<Object> fullKeySet = new HashSet<Object>();

                @Override
                public String getKeyValue(String k, String argNotUsed, String dft) {
                    String customVal;
                    if (k == null) {
                        this.fullKeySet.addAll(this.thisKeySet);
                        if (mainKey != null) {
                            this.fullKeySet.add(mainKey);
                        }
                        this.thisKeySet.clear();
                        return null;
                    }
                    String key = k;
                    if (this.fullKeySet.contains(key)) {
                        return null;
                    }
                    this.thisKeySet.add(key);
                    String string = customVal = customMap != null ? (String)customMap.get(key) : null;
                    if (rtOK) {
                        String rtnVal = customVal != null ? customVal : RTConfig._getString(key, dft, true);
                        return rtnVal;
                    }
                    return customMap != null ? customVal : dft;
                }
            };
            String s_old = text;
            for (int i = 0; i < 6; ++i) {
                rm.getKeyValue(null, null, null);
                String s_new = StringTools.insertKeyValues(s_old, startDelim, endDelim, dftDelim, rm, false);
                if (s_new.equals(s_old)) {
                    return s_new;
                }
                s_old = s_new;
            }
            return s_old;
        }
        return text;
    }

    public static Set<String> getPropertyKeys(String startsWith) {
        return RTConfig.getPropertyKeys(startsWith, true);
    }

    public static Set<String> getPropertyKeys(String startsWith, boolean inclDft) {
        RTProperties rtp;
        Stack<RTProperties> rtpStack;
        OrderedSet<String> keys = new OrderedSet<String>(true);
        if (!RTConfig.isInitialized()) {
            // empty if block
        }
        if (CFG_THREAD_TEMPORARY != null && (rtpStack = CFG_THREAD_TEMPORARY.get()) != null) {
            for (int r = rtpStack.size() - 1; r >= 0; --r) {
                RTProperties rtp2 = (RTProperties)rtpStack.get(r);
                keys.addAll((Collection<String>)rtp2.getPropertyKeys(startsWith));
            }
        }
        for (int i = 0; i < CFG_PROPERTIES.length; ++i) {
            RTProperties rtp3 = CFG_PROPERTIES[i];
            if (rtp3 == null) continue;
            keys.addAll((Collection<String>)rtp3.getPropertyKeys(startsWith));
        }
        if (inclDft && (rtp = RTKey.getDefaultProperties()) != null) {
            keys.addAll((Collection<String>)rtp.getPropertyKeys(startsWith));
        }
        return keys;
    }

    public static RTProperties getProperties(String startsWith, boolean inclDft) {
        Set<String> keys = RTConfig.getPropertyKeys(startsWith, inclDft);
        RTProperties rtProps = new RTProperties();
        for (String k : keys) {
            rtProps.setProperty((Object)k, RTConfig.getProperty(k, (Object)"", inclDft));
        }
        return rtProps;
    }

    public static boolean hasProperty(String key) {
        return RTConfig.hasProperty(key, true);
    }

    public static boolean hasProperty(String key, boolean dftOk) {
        RTProperties rtp = RTConfig.getPropertiesForKey(key, dftOk);
        return rtp != null;
    }

    public static boolean hasProperty(String[] key) {
        return RTConfig.hasProperty(key, true);
    }

    public static boolean hasProperty(String[] key, boolean dftOk) {
        if (key != null) {
            for (int i = 0; i < key.length; ++i) {
                RTProperties rtp = RTConfig.getPropertiesForKey(key[i], dftOk);
                if (rtp == null) continue;
                return true;
            }
        }
        return false;
    }

    public static Object getProperty(String key) {
        return RTConfig.getProperty(key, null, true);
    }

    public static Object getProperty(String[] key) {
        return RTConfig.getProperty(key, null, true);
    }

    public static Object getProperty(String key, Object dft) {
        return RTConfig.getProperty(key, dft, false);
    }

    public static Object getProperty(String[] key, Object dft) {
        return RTConfig.getProperty(key, dft, false);
    }

    public static Object getProperty(String key, Object dft, boolean dftOk) {
        RTProperties rtp = RTConfig.getPropertiesForKey(key, dftOk);
        return rtp != null ? rtp.getProperty(key, dft) : dft;
    }

    public static Object getProperty(String[] key, Object dft, boolean dftOk) {
        if (key != null) {
            for (int i = 0; i < key.length; ++i) {
                RTProperties rtp = RTConfig.getPropertiesForKey(key[i], dftOk);
                if (rtp == null) continue;
                Object obj = rtp._getProperty(key[i], dft);
                return obj != null ? obj : dft;
            }
        }
        return dft;
    }

    public static void setProperty(String key, Object value) {
        RTProperties cfgProps = RTConfig.getConfigFileProperties();
        cfgProps.setProperty((Object)key, value);
        if (key != null && value == null) {
            RTConfig.getSystemProperties().removeProperty(key);
        }
    }

    public static void setProperties(Properties props) {
        RTProperties cfgProps = RTConfig.getConfigFileProperties();
        cfgProps.setProperties(props);
    }

    public static void setProperties(RTProperties rtprops) {
        RTProperties cfgProps = RTConfig.getConfigFileProperties();
        cfgProps.setProperties(rtprops);
    }

    public static String _getString(String key, String dft, boolean dftOK) {
        RTProperties rtp = RTConfig.getPropertiesForKey(key, dftOK);
        if (rtp != null) {
            Object obj = rtp._getProperty(key, dft);
            return obj != null ? obj.toString() : dft;
        }
        return dft;
    }

    public static String _getString(String[] key, String dft, boolean dftOK) {
        if (key != null) {
            for (int i = 0; i < key.length; ++i) {
                RTProperties rtp = RTConfig.getPropertiesForKey(key[i], dftOK);
                if (rtp == null) continue;
                Object obj = rtp._getProperty(key[i], dft);
                return obj != null ? obj.toString() : dft;
            }
        }
        return dft;
    }

    public static String getString(String key) {
        return RTConfig.getString(key, null, true);
    }

    public static String getString(String[] key) {
        return RTConfig.getString(key, null, true);
    }

    public static String getString(String key, String dft) {
        return RTConfig.getString(key, dft, false);
    }

    public static String getString(String key, String dft, boolean dftOK) {
        RTProperties rtp = RTConfig.getPropertiesForKey(key, dftOK);
        return rtp != null ? rtp.getString(key, dft) : dft;
    }

    public static String getString(String[] key, String dft) {
        return RTConfig.getString(key, dft, false);
    }

    public static String getString(String[] key, String dft, boolean dftOK) {
        if (key != null) {
            for (int i = 0; i < key.length; ++i) {
                RTProperties rtp = RTConfig.getPropertiesForKey(key[i], dftOK);
                if (rtp == null) continue;
                return rtp.getString(key[i], dft);
            }
        }
        return dft;
    }

    public static void setString(String key, String value) {
        RTProperties cfgFileProps = RTConfig.getConfigFileProperties();
        cfgFileProps.setString(key, value);
    }

    public static String[] getStringArray(String key) {
        return RTConfig.getStringArray(key, null, true);
    }

    public static String[] getStringArray(String key, String[] dft) {
        return RTConfig.getStringArray(key, dft, false);
    }

    public static String[] getStringArray(String key, String[] dft, boolean dftOK) {
        RTProperties rtp = RTConfig.getPropertiesForKey(key, dftOK);
        return rtp != null ? rtp.getStringArray(key, dft) : dft;
    }

    public static String[] getStringArray(String[] key, String[] dft) {
        return RTConfig.getStringArray(key, dft, false);
    }

    public static String[] getStringArray(String[] key, String[] dft, boolean dftOK) {
        if (key != null) {
            for (int i = 0; i < key.length; ++i) {
                RTProperties rtp = RTConfig.getPropertiesForKey(key[i], dftOK);
                if (rtp == null) continue;
                return rtp.getStringArray(key[i], dft);
            }
        }
        return dft;
    }

    public static void setStringArray(String key, String[] val) {
        RTProperties cfgProps = RTConfig.getConfigFileProperties();
        cfgProps.setStringArray(key, val);
    }

    public static Class getClass(String key) {
        return RTConfig.getClass(key, null, true);
    }

    public static Class getClass(String key, Class dft) {
        return RTConfig.getClass(key, dft, false);
    }

    public static Class getClass(String key, Class dft, boolean dftOK) {
        RTProperties rtp = RTConfig.getPropertiesForKey(key, dftOK);
        return rtp != null ? rtp.getClass(key, dft) : dft;
    }

    public static Class getClass(String[] key, Class dft) {
        return RTConfig.getClass(key, dft, false);
    }

    public static Class getClass(String[] key, Class dft, boolean dftOK) {
        if (key != null) {
            for (int i = 0; i < key.length; ++i) {
                RTProperties rtp = RTConfig.getPropertiesForKey(key[i], dftOK);
                if (rtp == null) continue;
                return rtp.getClass(key[i], dft);
            }
        }
        return dft;
    }

    public static void setClass(String key, Class value) {
        RTProperties cfgProps = RTConfig.getConfigFileProperties();
        cfgProps.setClass(key, value);
    }

    public static File getFile(String key) {
        return RTConfig.getFile(key, null, true);
    }

    public static File getFile(String key, File dft) {
        return RTConfig.getFile(key, dft, false);
    }

    public static File getFile(String key, File dft, boolean dftOK) {
        RTProperties rtp = RTConfig.getPropertiesForKey(key, dftOK);
        return rtp != null ? rtp.getFile(key, dft) : dft;
    }

    public static File getFile(String[] key, File dft) {
        return RTConfig.getFile(key, dft, false);
    }

    public static File getFile(String[] key, File dft, boolean dftOK) {
        if (key != null) {
            for (int i = 0; i < key.length; ++i) {
                RTProperties rtp = RTConfig.getPropertiesForKey(key[i], dftOK);
                if (rtp == null) continue;
                return rtp.getFile(key[i], dft);
            }
        }
        return dft;
    }

    public static void setFile(String key, File value) {
        RTProperties cfgProps = RTConfig.getConfigFileProperties();
        cfgProps.setFile(key, value);
    }

    public static double getDouble(String key) {
        return RTConfig.getDouble(key, 0.0, true);
    }

    public static double getDouble(String key, double dft) {
        return RTConfig.getDouble(key, dft, false);
    }

    public static double getDouble(String key, double dft, boolean dftOK) {
        RTProperties rtp = RTConfig.getPropertiesForKey(key, dftOK);
        return rtp != null ? rtp.getDouble(key, dft) : dft;
    }

    public static double getDouble(String[] key, double dft) {
        return RTConfig.getDouble(key, dft, false);
    }

    public static double getDouble(String[] key, double dft, boolean dftOK) {
        if (key != null) {
            for (int i = 0; i < key.length; ++i) {
                RTProperties rtp = RTConfig.getPropertiesForKey(key[i], dftOK);
                if (rtp == null) continue;
                return rtp.getDouble(key[i], dft);
            }
        }
        return dft;
    }

    public static void setDouble(String key, double value) {
        RTProperties cfgProps = RTConfig.getConfigFileProperties();
        cfgProps.setDouble(key, value);
    }

    public static float getFloat(String key) {
        return RTConfig.getFloat(key, 0.0f, true);
    }

    public static float getFloat(String key, float dft) {
        return RTConfig.getFloat(key, dft, false);
    }

    public static float getFloat(String key, float dft, boolean dftOK) {
        RTProperties rtp = RTConfig.getPropertiesForKey(key, dftOK);
        return rtp != null ? rtp.getFloat(key, dft) : dft;
    }

    public static float getFloat(String[] key, float dft) {
        return RTConfig.getFloat(key, dft, false);
    }

    public static float getFloat(String[] key, float dft, boolean dftOK) {
        if (key != null) {
            for (int i = 0; i < key.length; ++i) {
                RTProperties rtp = RTConfig.getPropertiesForKey(key[i], dftOK);
                if (rtp == null) continue;
                return rtp.getFloat(key[i], dft);
            }
        }
        return dft;
    }

    public static void setFloat(String key, float value) {
        RTProperties cfgProps = RTConfig.getConfigFileProperties();
        cfgProps.setFloat(key, value);
    }

    public static BigInteger getBigInteger(String key) {
        return RTConfig.getBigInteger(key, BigInteger.ZERO, true);
    }

    public static BigInteger getBigInteger(String key, BigInteger dft) {
        return RTConfig.getBigInteger(key, dft, false);
    }

    public static BigInteger getBigInteger(String key, BigInteger dft, boolean dftOK) {
        RTProperties rtp = RTConfig.getPropertiesForKey(key, dftOK);
        return rtp != null ? rtp.getBigInteger(key, dft) : dft;
    }

    public static BigInteger getBigInteger(String[] key, BigInteger dft) {
        return RTConfig.getBigInteger(key, dft, false);
    }

    public static BigInteger getBigInteger(String[] key, BigInteger dft, boolean dftOK) {
        if (key != null) {
            for (int i = 0; i < key.length; ++i) {
                RTProperties rtp = RTConfig.getPropertiesForKey(key[i], dftOK);
                if (rtp == null) continue;
                return rtp.getBigInteger(key[i], dft);
            }
        }
        return dft;
    }

    public static void setBigInteger(String key, BigInteger value) {
        RTProperties cfgProps = RTConfig.getConfigFileProperties();
        cfgProps.setBigInteger(key, value);
    }

    public static long getLong(String key) {
        return RTConfig.getLong(key, 0L, true);
    }

    public static long getLong(String key, long dft) {
        return RTConfig.getLong(key, dft, false);
    }

    public static long getLong(String key, long dft, boolean dftOK) {
        RTProperties rtp = RTConfig.getPropertiesForKey(key, dftOK);
        return rtp != null ? rtp.getLong(key, dft) : dft;
    }

    public static long getLong(String[] key, long dft) {
        return RTConfig.getLong(key, dft, false);
    }

    public static long getLong(String[] key, long dft, boolean dftOK) {
        if (key != null) {
            for (int i = 0; i < key.length; ++i) {
                RTProperties rtp = RTConfig.getPropertiesForKey(key[i], dftOK);
                if (rtp == null) continue;
                return rtp.getLong(key[i], dft);
            }
        }
        return dft;
    }

    public static void setLong(String key, long value) {
        RTProperties cfgProps = RTConfig.getConfigFileProperties();
        cfgProps.setLong(key, value);
    }

    public static int getInt(String key) {
        return RTConfig.getInt(key, 0, true);
    }

    public static int getInt(String key, int dft) {
        return RTConfig.getInt(key, dft, false);
    }

    public static int getInt(String key, int dft, boolean dftOK) {
        RTProperties rtp = RTConfig.getPropertiesForKey(key, dftOK);
        return rtp != null ? rtp.getInt(key, dft) : dft;
    }

    public static int getInt(String[] key, int dft) {
        return RTConfig.getInt(key, dft, false);
    }

    public static int getInt(String[] key, int dft, boolean dftOK) {
        if (key != null) {
            for (int i = 0; i < key.length; ++i) {
                RTProperties rtp = RTConfig.getPropertiesForKey(key[i], dftOK);
                if (rtp == null) continue;
                return rtp.getInt(key[i], dft);
            }
        }
        return dft;
    }

    public static void setInt(String key, int value) {
        RTProperties cfgProps = RTConfig.getConfigFileProperties();
        cfgProps.setInt(key, value);
    }

    public static int[] getIntArray(String key) {
        return RTConfig.getIntArray(key, null, true);
    }

    public static int[] getIntArray(String key, int[] dft) {
        return RTConfig.getIntArray(key, dft, false);
    }

    public static int[] getIntArray(String key, int[] dft, boolean dftOK) {
        RTProperties rtp = RTConfig.getPropertiesForKey(key, dftOK);
        return rtp != null ? rtp.getIntArray(key, dft) : dft;
    }

    public static int[] getIntArray(String[] key, int[] dft) {
        return RTConfig.getIntArray(key, dft, false);
    }

    public static int[] getIntArray(String[] key, int[] dft, boolean dftOK) {
        if (key != null) {
            for (int i = 0; i < key.length; ++i) {
                RTProperties rtp = RTConfig.getPropertiesForKey(key[i], dftOK);
                if (rtp == null) continue;
                return rtp.getIntArray(key[i], dft);
            }
        }
        return dft;
    }

    public static void setIntArray(String key, int[] val) {
        RTProperties cfgProps = RTConfig.getConfigFileProperties();
        cfgProps.setIntArray(key, val);
    }

    public static long[] getLongArray(String key) {
        return RTConfig.getLongArray(key, null, true);
    }

    public static long[] getLongArray(String key, long[] dft) {
        return RTConfig.getLongArray(key, dft, false);
    }

    public static long[] getLongArray(String key, long[] dft, boolean dftOK) {
        RTProperties rtp = RTConfig.getPropertiesForKey(key, dftOK);
        return rtp != null ? rtp.getLongArray(key, dft) : dft;
    }

    public static long[] getLongArray(String[] key, long[] dft) {
        return RTConfig.getLongArray(key, dft, false);
    }

    public static long[] getLongArray(String[] key, long[] dft, boolean dftOK) {
        if (key != null) {
            for (int i = 0; i < key.length; ++i) {
                RTProperties rtp = RTConfig.getPropertiesForKey(key[i], dftOK);
                if (rtp == null) continue;
                return rtp.getLongArray(key[i], dft);
            }
        }
        return dft;
    }

    public static void setLongArray(String key, long[] val) {
        RTProperties cfgProps = RTConfig.getConfigFileProperties();
        cfgProps.setLongArray(key, val);
    }

    public static double[] getDoubleArray(String key) {
        return RTConfig.getDoubleArray(key, null, true);
    }

    public static double[] getDoubleArray(String key, double[] dft) {
        return RTConfig.getDoubleArray(key, dft, false);
    }

    public static double[] getDoubleArray(String key, double[] dft, boolean dftOK) {
        RTProperties rtp = RTConfig.getPropertiesForKey(key, dftOK);
        return rtp != null ? rtp.getDoubleArray(key, dft) : dft;
    }

    public static double[] getDoubleArray(String[] key, double[] dft) {
        return RTConfig.getDoubleArray(key, dft, false);
    }

    public static double[] getDoubleArray(String[] key, double[] dft, boolean dftOK) {
        if (key != null) {
            for (int i = 0; i < key.length; ++i) {
                RTProperties rtp = RTConfig.getPropertiesForKey(key[i], dftOK);
                if (rtp == null) continue;
                return rtp.getDoubleArray(key[i], dft);
            }
        }
        return dft;
    }

    public static void setDoubleArray(String key, double[] val) {
        RTProperties cfgProps = RTConfig.getConfigFileProperties();
        cfgProps.setDoubleArray(key, val);
    }

    public static boolean getBoolean(String key) {
        return RTConfig.getBoolean(key, RTConfig.hasProperty(key), true);
    }

    public static boolean getBoolean(String key, boolean dft) {
        return RTConfig.getBoolean(key, dft, false);
    }

    public static boolean getBoolean(String key, boolean dft, boolean dftOK) {
        RTProperties rtp = RTConfig.getPropertiesForKey(key, dftOK);
        if (rtp == null) {
            return dft;
        }
        String s = rtp.getString(key, "");
        if (s != null && s.equals("")) {
            return rtp.getBoolean(key, true);
        }
        return rtp.getBoolean(key, dft);
    }

    public static boolean getBoolean(String[] key, boolean dft) {
        return RTConfig.getBoolean(key, dft, false);
    }

    public static boolean getBoolean(String[] key, boolean dft, boolean dftOK) {
        if (key != null) {
            for (int i = 0; i < key.length; ++i) {
                RTProperties rtp = RTConfig.getPropertiesForKey(key[i], dftOK);
                if (rtp == null) continue;
                return rtp.getBoolean(key[i], dft);
            }
        }
        return dft;
    }

    public static void setBoolean(String key, boolean value) {
        RTProperties cfgProps = RTConfig.getConfigFileProperties();
        cfgProps.setBoolean(key, value);
    }

    public static void setAdminMode(boolean admin) {
        RTConfig.setBoolean("adminMode", admin);
    }

    public static boolean isAdminMode() {
        return RTConfig.getBoolean("adminMode");
    }

    public static void setDebugMode(boolean debug) {
        RTConfig.setBoolean("debugMode", debug);
    }

    public static boolean isDebugMode() {
        return !RTConfig.isInitialized() || RTConfig.getBoolean("debugMode");
    }

    public static void setTestMode(boolean test) {
        RTConfig.setBoolean("testMode", test);
    }

    public static boolean isTestMode() {
        return RTConfig.getBoolean("testMode");
    }

    public static void setContextName(String name) {
        RTProperties constantProps = RTConfig.getRuntimeConstantProperties();
        constantProps.setProperty((Object)"%contextName", StringTools.trim(name));
    }

    public static String getContextName(String dftName) {
        RTProperties constantProps = RTConfig.getRuntimeConstantProperties();
        String ctxName = constantProps.getString("%contextName", null);
        return StringTools.blankDefault(ctxName, dftName);
    }

    public static String getContextName() {
        return RTConfig.getContextName(null);
    }

    public static boolean hasContextName() {
        return !StringTools.isBlank(RTConfig.getContextName(null));
    }

    public static void setContextPath(String path) {
        RTProperties constantProps = RTConfig.getRuntimeConstantProperties();
        constantProps.setProperty((Object)"%contextPath", StringTools.trim(path));
    }

    public static String getContextPath(String dftPath) {
        RTProperties constantProps = RTConfig.getRuntimeConstantProperties();
        String ctxName = constantProps.getString("%contextPath", null);
        return StringTools.blankDefault(ctxName, dftPath);
    }

    public static String getContextPath() {
        return RTConfig.getContextPath(null);
    }

    public static boolean hasContextPath() {
        return !StringTools.isBlank(RTConfig.getContextPath(null));
    }

    public static File getServletContextPath() {
        if (RTConfig.isWebApp()) {
            String ctxPath = RTConfig.getContextPath();
            if (!StringTools.isBlank(ctxPath)) {
                File ctxPathFile = new File(ctxPath);
                if (ctxPathFile.isDirectory()) {
                    return ctxPathFile;
                }
                Print.logWarn("Servlet 'CONTEXT_PATH' is not a directory [2]: " + ctxPath, new Object[0]);
            } else {
                Print.logWarn("Servlet is missing 'CONTEXT_PATH' [2]: " + RTConfig.getServletClassName(), new Object[0]);
            }
        }
        return null;
    }

    public static void setWebApp(boolean webapp) {
        RTProperties constantProps = RTConfig.getRuntimeConstantProperties();
        constantProps.setProperty("%isWebApp", webapp);
        isRunningAsWebApp = null;
    }

    public static boolean isWebApp() {
        if (isRunningAsWebApp != null) {
            return isRunningAsWebApp;
        }
        RTProperties constantProps = RTConfig.getRuntimeConstantProperties();
        if (constantProps.hasProperty("%isWebApp")) {
            return constantProps.getBoolean("%isWebApp");
        }
        isRunningAsWebApp = new Boolean(RTConfig._isWebApp_2());
        return isRunningAsWebApp;
    }

    protected static boolean _isWebApp_1() {
        Throwable t = new Throwable();
        t.fillInStackTrace();
        StackTraceElement[] stackFrame = t.getStackTrace();
        for (int i = 0; i < stackFrame.length; ++i) {
            String cn = stackFrame[i].getClassName();
            for (int w = 0; w < WebAppClassNames.length; ++w) {
                if (!cn.equalsIgnoreCase(WebAppClassNames[w])) continue;
                return true;
            }
        }
        return false;
    }

    protected static boolean _isWebApp_2() {
        return RTConfig.getServletClass() != null;
    }

    public static Class<?> getMainClass() {
        if (!Main_init) {
            Main_init = true;
            if (OSTools.hasGetCallerClass()) {
                Class clz;
                Class lastClz = null;
                int sf = 2;
                while ((clz = OSTools.getCallerClass(sf)) != null) {
                    lastClz = clz;
                    ++sf;
                }
                Main_class = lastClz;
            } else {
                Print.logError("Not running with the Sun Microsystems version of Java.", new Object[0]);
                Print.logError("Cannot obtain main class.", new Object[0]);
            }
        }
        return Main_class;
    }

    public static Class<?> getServletClass() {
        if (!Servlet_init) {
            try {
                Servlet_class = Class.forName(SERVLET_CLASS);
            }
            catch (Throwable t) {
                // empty catch block
            }
            Servlet_init = true;
        }
        if (Servlet_class != null) {
            Class clz;
            int sf = 2;
            while ((clz = OSTools.getCallerClass(sf)) != null) {
                if (Servlet_class.isAssignableFrom(clz)) {
                    return clz;
                }
                ++sf;
            }
        }
        return null;
    }

    public static String getServletClassName() {
        Class<?> sc = RTConfig.getServletClass();
        return sc != null ? StringTools.className(sc) : "";
    }

    public static void main(String[] argv) {
        RTConfig.setCommandLineArgs(argv);
        Print.logDebug("DebugMode is true", new Object[0]);
        if (RTConfig.hasProperty("test")) {
            Print.sysPrintln("Value = " + RTConfig.getString("value", null), new Object[0]);
            String s = StringTools.blankDefault(RTConfig.getString("test", null), "Test String: ${value=a:b:c}");
            Print.sysPrintln("before " + s, new Object[0]);
            String r = RTConfig.insertKeyValues(s);
            Print.sysPrintln("after  " + r, new Object[0]);
            System.exit(0);
        }
        if (RTConfig.hasProperty("key")) {
            String key = RTConfig.getString("key");
            String val = RTConfig.getString(key, "");
            Print.sysPrintln("", new Object[0]);
            Print.sysPrintln("%s=%s", key, val);
            Print.sysPrintln("", new Object[0]);
            System.exit(0);
        }
        if (RTConfig.hasProperty("list")) {
            Print.sysPrintln("Context Name: " + RTConfig.getContextName(), new Object[0]);
            Print.sysPrintln("Context Path: " + RTConfig.getContextPath(), new Object[0]);
            Print.sysPrintln("", new Object[0]);
            boolean merge = RTConfig.getString("list", "").startsWith("m");
            RTConfig.printAllProperties(merge);
            System.exit(0);
        }
        if (RTConfig.getBoolean("reload", false)) {
            Print.sysPrintln("", new Object[0]);
            Print.sysPrintln("Starting Reload ...", new Object[0]);
            RTConfig.reload();
            Print.sysPrintln("Done Reloading ...", new Object[0]);
            System.exit(0);
        }
        if (RTConfig.hasProperty("merge")) {
            File intoFile;
            File mergeFile = RTConfig.getFile("merge", null);
            if (!FileTools.isFile(mergeFile)) {
                Print.sysPrintln("ERROR - 'merge' file does not exist: " + mergeFile, new Object[0]);
                System.exit(1);
            }
            if (!FileTools.isFile(intoFile = RTConfig.getFile("into", null))) {
                Print.sysPrintln("ERROR - 'into' file does not exist: " + intoFile, new Object[0]);
                System.exit(1);
            }
            RTProperties mergeP = new RTProperties();
            try {
                mergeP.setIncludesEnabled(false);
                mergeP.setProperties(mergeFile, true);
                mergeP.saveProperties(intoFile, true);
            }
            catch (IOException ioe) {
                Print.logException("Unable to save properties", ioe);
                System.exit(1);
            }
            System.exit(0);
        }
    }

    public static interface PropertyGetter {
        public Object getProperty(Object var1, Object var2);
    }

    public static interface PropertySetter {
        public void setProperty(Object var1, Object var2);
    }
}

