/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.opengts.util.CachedLogOutputStream;
import org.opengts.util.DateTime;
import org.opengts.util.ListTools;
import org.opengts.util.RTConfig;
import org.opengts.util.RemoteLogServer;
import org.opengts.util.StringTools;

public class Print {
    public static final int LOG_UNDEFINED = -1;
    public static final int LOG_OFF = 0;
    public static final int LOG_FATAL = 1;
    public static final int LOG_ERROR = 2;
    public static final int LOG_WARN = 3;
    public static final int LOG_INFO = 4;
    public static final int LOG_DEBUG = 5;
    public static final int LOG_ALL = 6;
    private static final String _JAVA = ".java";
    private static int toJavaLogger = -1;
    private static boolean logPrintStream_init = false;
    private static PrintStream logPrintStream = null;
    private static OutputStream redirectedOutputStream = null;
    private static RemoteLogServer remoteLogServer = null;
    private static boolean allOutputToStdout = false;
    private static PrintStream sysStdout = null;
    private static PrintStream sysStderr = null;
    private static int printLogLevel = -1;
    private static int printLogHeaderLevel = -1;
    private static int printLogIncludeFrame = -1;
    private static int printLogIncludeDate = -1;
    private static boolean printLogFile_init = false;
    private static File printLogFile = null;
    private static long printRotateLogFileSize = -1L;
    private static long printRotateDelAgeSec = -1L;
    private static String localhostName = null;
    private static String printEncoding = null;
    private static PrintStream sysOut = null;
    private static PrintStream sysErr = null;
    private static Object logLock = new Object();
    private static PrintStream logOutput = null;
    private static boolean logOutput_okToClose = false;
    private static long logRefCount = 0L;
    private static int openPrintStream_recursion = 0;

    public static void resetVars() {
        printLogLevel = -1;
        printLogHeaderLevel = -1;
        printLogIncludeFrame = -1;
        printLogIncludeDate = -1;
        printLogFile_init = false;
        printLogFile = null;
        printRotateLogFileSize = -1L;
        printRotateDelAgeSec = -1L;
    }

    public static int setIncludeStackFrame(int inclFrameState) {
        int oldInclFrame = printLogIncludeFrame;
        printLogIncludeFrame = inclFrameState;
        return oldInclFrame;
    }

    protected static boolean _includeStackFrame() {
        if (printLogIncludeFrame < 0) {
            printLogIncludeFrame = RTConfig.getBoolean("log.include.frame", false) || Print.isDebugLoggingLevel() ? 1 : 0;
        }
        return printLogIncludeFrame > 0;
    }

    protected static boolean _includeDate() {
        if (printLogIncludeDate < 0) {
            printLogIncludeDate = RTConfig.getBoolean("log.include.date", false) ? 1 : 0;
        }
        return printLogIncludeDate > 0;
    }

    protected static boolean _emailExceptions() {
        return RTConfig.getBoolean("log.email.sendExceptions", false);
    }

    public static String getHostName() {
        if (localhostName == null) {
            try {
                String hd = InetAddress.getLocalHost().getHostName();
                int p = hd.indexOf(".");
                localhostName = p >= 0 ? hd.substring(0, p) : hd;
            }
            catch (UnknownHostException uhe) {
                localhostName = "UNKNOWN";
            }
        }
        return localhostName;
    }

    public static String formatDate(String fmt) {
        return new DateTime().format(fmt, null);
    }

    public static void setEncoding(String enc) {
        printEncoding = enc != null && !enc.equals("") ? enc : null;
        sysOut = null;
        sysErr = null;
    }

    public static String getEncoding() {
        return printEncoding != null ? printEncoding : StringTools.getCharacterEncoding();
    }

    private static PrintStream _getSystemOut() {
        if (sysOut == null) {
            try {
                sysOut = new PrintStream((OutputStream)System.out, true, Print.getEncoding());
            }
            catch (UnsupportedEncodingException uee) {
                sysOut = System.out;
            }
        }
        return sysOut;
    }

    private static PrintStream _getSystemErr() {
        if (sysErr == null) {
            try {
                if (RTConfig.getBoolean("log.javaLogger", false)) {
                    String n = RTConfig.getString("log.name", "Print");
                    sysErr = new PrintStream((OutputStream)new LoggerOutputStream(n), true, "UTF-8");
                } else {
                    sysErr = new PrintStream((OutputStream)System.err, true, "UTF-8");
                }
            }
            catch (UnsupportedEncodingException uee) {
                sysErr = System.err;
            }
        }
        return sysErr;
    }

    public static String _getStackFrame(int frame) {
        int p;
        StackTraceElement sf;
        int nextFrame = frame >= 0 ? frame + 1 : 1;
        Throwable t = new Throwable();
        t.fillInStackTrace();
        StackTraceElement[] st = t.getStackTrace();
        StackTraceElement stackTraceElement = sf = st != null ? st[nextFrame] : null;
        if (sf == null) {
            return "?";
        }
        String clazz = sf.getClassName();
        String file = sf.getFileName();
        if (file == null) {
            for (p = 0; p < clazz.length() && !Character.isUpperCase(clazz.charAt(p)); ++p) {
            }
            if (p < clazz.length()) {
                clazz = clazz.substring(p);
            }
        } else if (file.toLowerCase().endsWith(_JAVA) && (p = clazz.indexOf(file = file.substring(0, file.length() - _JAVA.length()))) >= 0) {
            clazz = clazz.substring(p);
        }
        StringBuffer sb = new StringBuffer();
        sb.append(clazz);
        sb.append(".").append(sf.getMethodName());
        int lineNum = sf.getLineNumber();
        if (lineNum > 0) {
            sb.append(":").append(sf.getLineNumber());
        }
        return sb.toString();
    }

    public static void _println(String msg, Object ... args) {
        PrintStream out = Print._getSystemOut();
        Print._println(out, msg, args);
    }

    public static void _println(PrintStream ps, String msg, Object ... args) {
        Print._print(ps, 1, true, msg + "\n", args);
    }

    protected static void _println(PrintStream ps, int frame, boolean printFrame, String msg, Object ... args) {
        int nextFrame = frame >= 0 ? frame + 1 : frame;
        Print._print(ps, nextFrame, printFrame, msg + "\n", args);
    }

    protected static void _println(PrintStream ps, int frame, String msg, Object ... args) {
        int nextFrame = frame >= 0 ? frame + 1 : frame;
        Print._print(ps, nextFrame, Print._includeStackFrame(), msg + "\n", args);
    }

    protected static void _print(PrintStream ps, int frame, String msg, Object ... args) {
        int nextFrame = frame >= 0 ? frame + 1 : frame;
        Print._print(ps, nextFrame, Print._includeStackFrame(), msg, args);
    }

    protected static void _print(PrintStream ps, int frame, boolean printFrame, String msg, Object ... args) {
        int nextFrame = frame >= 0 ? frame + 1 : frame;
        PrintStream out = ps != null ? ps : Print._getSystemOut();
        StringBuffer sb = new StringBuffer();
        if (printFrame && nextFrame >= 0) {
            sb.append("[");
            sb.append(Print._getStackFrame(nextFrame));
            sb.append("] ");
        }
        if (msg != null) {
            if (args != null && args.length > 0) {
                try {
                    sb.append(String.format(msg, args));
                }
                catch (Throwable th) {
                    System.out.println("ERROR: [" + msg + "] " + th);
                    sb.append(msg);
                }
            } else {
                sb.append(msg);
            }
        }
        out.print(sb.toString());
        out.flush();
    }

    public static void setLogStream(PrintStream out) {
        logPrintStream = out;
        logPrintStream_init = true;
    }

    public static boolean hasLogPrintStream() {
        PrintStream out = Print._getLogPrintStream();
        return out != null;
    }

    private static PrintStream _getLogPrintStream() {
        if (!logPrintStream_init) {
            Print.getRedirectedOutputStream();
        }
        return logPrintStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeRedirectedOutputStream() {
        String msg = null;
        Object object = logLock;
        synchronized (object) {
            PrintStream out = logPrintStream;
            redirectedOutputStream = null;
            logPrintStream = null;
            if (out != null) {
                try {
                    ((OutputStream)out).close();
                    msg = "Closed current RedirectedOutputStream";
                }
                catch (IOException ioe) {
                    msg = "ERROR: Failed to close RedirectedOutputStream: " + ioe;
                }
            }
            logPrintStream_init = false;
        }
        if (msg != null) {
            Print.sysPrintln(msg, new Object[0]);
        }
    }

    public static OutputStream getRedirectedOutputStream() {
        if (!logPrintStream_init) {
            logPrintStream_init = true;
            redirectedOutputStream = null;
            logPrintStream = null;
            String rosClassName = RTConfig.getString("log.redirectLog");
            if (StringTools.isBlank(rosClassName)) {
                return null;
            }
            if (rosClassName.equalsIgnoreCase("CachedLogOutputStream")) {
                rosClassName = "org.opengts.util.CachedLogOutputStream";
            }
            OutputStream ros = null;
            try {
                ros = (OutputStream)Class.forName(rosClassName).newInstance();
            }
            catch (Throwable th) {
                System.err.println("Unable to create redirected OuputStream: " + rosClassName);
                th.printStackTrace(System.err);
                return null;
            }
            Print.setRedirectedOutput(ros);
        }
        return redirectedOutputStream;
    }

    public static void setRedirectedOutput(OutputStream os) {
        redirectedOutputStream = os;
        PrintStream ps = os != null ? new PrintStream(os) : null;
        Print.setRedirectedOutput(ps);
    }

    public static void setRedirectedOutput(PrintStream out) {
        Print.setLogStream(out);
    }

    public static boolean setRemoteLogging(String remLog) {
        if (!StringTools.isBlank(remLog)) {
            int p;
            String host = null;
            int port = 0;
            int size = -1;
            int b = remLog.indexOf("/");
            if (b >= 0) {
                size = StringTools.parseInt(remLog.substring(b + 1), -1);
                remLog = remLog.substring(0, b);
            }
            if ((p = remLog.indexOf(":")) >= 0) {
                host = remLog.substring(0, p);
                port = StringTools.parseInt(remLog.substring(p + 1), 0);
            } else {
                port = StringTools.parseInt(remLog, 0);
            }
            return Print.setRemoteLogging(host, port, size);
        }
        return false;
    }

    public static boolean setRemoteLogging(int port, int buffSize) {
        return Print.setRemoteLogging((InetAddress)null, port, buffSize);
    }

    public static boolean setRemoteLogging(String bindHost, int port, int buffSize) {
        return Print.setRemoteLogging(RemoteLogServer.GetLocalBindAddress(bindHost), port, buffSize);
    }

    public static boolean setRemoteLogging(InetAddress bindAddr, int port, int buffSize) {
        if (port > 0) {
            Print.closeRedirectedOutputStream();
            if (buffSize <= 0) {
                buffSize = 24000;
            }
            int maxSize = buffSize >= 1000 ? buffSize : 1000;
            int minSize = maxSize * 2 / 3;
            CachedLogOutputStream clos = new CachedLogOutputStream(minSize, maxSize);
            Print.setRedirectedOutput(clos);
            remoteLogServer = new RemoteLogServer(bindAddr, port, clos);
            boolean ok = remoteLogServer.startServer();
            if (ok) {
                String bindHost = bindAddr != null ? bindAddr.getHostName() : "";
                System.out.println("Remote logging to \"" + bindHost + ":" + port + "\", bufferSize=" + maxSize);
            }
            return ok;
        }
        return false;
    }

    public static boolean isRemoteLogging() {
        return remoteLogServer != null;
    }

    public static void setAllOutputToStdout(boolean state) {
        allOutputToStdout = state;
    }

    public static void setSysStdout(PrintStream out) {
        sysStdout = out;
    }

    public static void setSysStderr(PrintStream out) {
        sysStderr = out;
    }

    private static PrintStream _getSysStdout() {
        if (sysStdout != null) {
            return sysStdout;
        }
        return Print._getSystemOut();
    }

    private static PrintStream _getSysStderr() {
        if (allOutputToStdout) {
            return Print._getSysStdout();
        }
        if (sysStderr != null) {
            return sysStderr;
        }
        return Print._getSystemErr();
    }

    public static void sysPrint(String msg, Object ... args) {
        PrintStream out = Print._getSysStdout();
        Print._print(out, 1, false, msg, args);
    }

    public static void sysPrint(StringBuffer msg, Object ... args) {
        PrintStream out = Print._getSysStdout();
        Print._print(out, 1, false, msg.toString(), args);
    }

    public static void sysPrintln(String msg, Object ... args) {
        PrintStream ps = Print._getSysStdout();
        Print._println(ps, 1, false, msg, args);
    }

    public static void sysPrintln(StringBuffer msg, Object ... args) {
        PrintStream ps = Print._getSysStdout();
        Print._println(ps, 1, false, msg.toString(), args);
    }

    public static void sysStackTrace(String msg) {
        PrintStream ps = Print._getSysStdout();
        Print._printStackTrace(ps, 1, msg, null);
    }

    public static void errPrint(String msg, Object ... args) {
        PrintStream out = Print._getSysStderr();
        Print._print(out, 1, false, msg, args);
    }

    public static void errPrint(StringBuffer msg, Object ... args) {
        PrintStream out = Print._getSysStderr();
        Print._print(out, 1, false, msg.toString(), args);
    }

    public static void errPrintln(String msg, Object ... args) {
        PrintStream ps = Print._getSysStderr();
        Print._println(ps, 1, false, msg, args);
    }

    public static void errPrintln(StringBuffer msg, Object ... args) {
        String m = msg != null ? msg.toString() : "";
        PrintStream ps = Print._getSysStderr();
        Print._println(ps, 1, false, m, args);
    }

    public static void _debugProbe(String msg, Object ... args) {
        PrintStream ps = Print._getSysStderr();
        Print._println(ps, 1, true, msg, args);
    }

    public static void print(String msg, Object ... args) {
        PrintStream out = Print._getSystemOut();
        Print._print(out, 1, false, msg, args);
    }

    public static void print(StringBuffer msg, Object ... args) {
        PrintStream out = Print._getSystemOut();
        Print._print(out, 1, false, msg.toString(), args);
    }

    public static void println(String msg, Object ... args) {
        PrintStream ps = Print._getSystemOut();
        Print._println(ps, 1, false, msg, args);
    }

    public static void println(StringBuffer msg, Object ... args) {
        PrintStream out = Print._getSystemOut();
        Print._println(out, 1, false, msg.toString(), args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void _logStackTrace(int level, int frame, String msg, Throwable t) {
        int nextFrame;
        int n = nextFrame = frame >= 0 ? frame + 1 : frame;
        if (level > Print.getLogLevel()) {
            return;
        }
        Print._log(level, nextFrame, msg, new Object[0]);
        try {
            PrintStream out = Print.openPrintStream();
            Print._printStackTrace(out, nextFrame, null, t);
        }
        catch (Throwable loge) {
            Print._printStackTrace(null, nextFrame, null, t);
        }
        finally {
            Print.closePrintStream();
        }
        if (Print._emailExceptions()) {
            Print.sysPrintln("EMailing error...", new Object[0]);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            PrintStream bosOut = new PrintStream(bos);
            String host = Print.getHostName();
            bosOut.println("From host: " + host);
            Print._printStackTrace(bosOut, nextFrame, msg, t);
            bosOut.close();
        }
    }

    public static void _printStackTrace(PrintStream out, int frame, String msg, Throwable t) {
        int nextFrame;
        int n = nextFrame = frame >= 0 ? frame + 1 : 1;
        if (out == null) {
            out = Print._getSysStderr();
        }
        if (msg != null) {
            boolean printExceptionFrame = true;
            Print._println(out, nextFrame, printExceptionFrame, msg, new Object[0]);
        }
        if (t == null) {
            t = new Throwable();
            t.fillInStackTrace();
            StackTraceElement[] oldst = t.getStackTrace();
            StackTraceElement[] newst = new StackTraceElement[oldst.length - nextFrame];
            System.arraycopy(oldst, nextFrame, newst, 0, newst.length);
            t.setStackTrace(newst);
        }
        t.printStackTrace(out);
        if (t instanceof SQLException) {
            for (SQLException sqe = ((SQLException)t).getNextException(); sqe != null; sqe = sqe.getNextException()) {
                sqe.printStackTrace(out);
            }
        }
    }

    public static void logNotImplemented(String msg) {
        Print._logStackTrace(2, 1, "Feature Not Implemented: " + msg, null);
    }

    public static void logException(String msg, Throwable t) {
        Print._logStackTrace(2, 1, "Exception: " + msg, t);
    }

    public static void logStackTrace(String msg, Throwable t) {
        Print._logStackTrace(2, 1, "Stacktrace: " + msg, t);
    }

    public static void logStackTrace(Throwable t) {
        Print._logStackTrace(2, 1, "Stacktrace: ", t);
    }

    public static void logStackTrace(String msg) {
        Print._logStackTrace(3, 1, "Stacktrace: " + msg, null);
    }

    public static void logSQLError(int frame, String msg, SQLException sqe) {
        int nextFrame = frame >= 0 ? frame + 1 : frame;
        PrintStream ps = null;
        Print._log(2, nextFrame, "==> SQLException: " + msg, new Object[0]);
        while (sqe != null) {
            Print._log(2, nextFrame, "Message:   " + sqe.getMessage(), new Object[0]);
            Print._log(2, nextFrame, "SQLState:  " + sqe.getSQLState(), new Object[0]);
            Print._log(2, nextFrame, "ErrorCode: " + sqe.getErrorCode(), new Object[0]);
            Print._printStackTrace(ps, nextFrame, sqe.toString(), sqe);
            sqe = sqe.getNextException();
        }
    }

    public static void logSQLError(SQLException sqe) {
        Print.logSQLError(1, "", sqe);
    }

    public static void logSQLError(String msg, SQLException sqe) {
        Print.logSQLError(1, msg, sqe);
    }

    public static void setLogFile(File file) {
        Print.closePrintStream();
        printLogFile = file;
        printLogFile_init = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File getLogFile() {
        if (!printLogFile_init) {
            Object object = logLock;
            synchronized (object) {
                if (!printLogFile_init) {
                    String fileStr;
                    String string = fileStr = printLogFile != null ? printLogFile.toString() : null;
                    if (StringTools.isBlank(fileStr) && RTConfig.getBoolean("log.file.enable")) {
                        fileStr = RTConfig.insertKeyValues(RTConfig.getString("log.file"));
                    }
                    if (!StringTools.isBlank(fileStr)) {
                        File logPath = new File(fileStr);
                        File logDir = logPath.getParentFile();
                        if (!logDir.isDirectory()) {
                            String logDirStr = logDir.toString();
                            if (logDirStr.startsWith("/tmp")) {
                                if (logDir.mkdirs()) {
                                    printLogFile = logPath;
                                } else {
                                    Print.sysPrintln("Error: Unable to create parent log directory: " + logDir, new Object[0]);
                                }
                            } else {
                                Print.sysPrintln("Error: log file directory does not exist: " + logDir, new Object[0]);
                            }
                        } else {
                            printLogFile = logPath;
                        }
                    }
                    printLogFile_init = true;
                }
            }
        }
        return printLogFile;
    }

    public static void setRotateLogFileSize(long maxSize) {
        printRotateLogFileSize = maxSize < 0L ? -1L : (maxSize == 0L ? 0L : (maxSize < 5000L ? 5000L : maxSize));
    }

    public static long getRotateLogFileSize() {
        if (printRotateLogFileSize < 0L) {
            String maxSizeS = RTConfig.getString("log.file.rotate.maxSize", "");
            long maxSize = 0L;
            maxSize = StringTools.isBlank(maxSizeS) ? 0L : (maxSizeS.equalsIgnoreCase("default") ? 5000000L : (StringTools.endsWithIgnoreCase(maxSizeS, "m") || StringTools.endsWithIgnoreCase(maxSizeS, "mb") ? StringTools.parseLong(maxSizeS, 0L) * 1000000L : (StringTools.endsWithIgnoreCase(maxSizeS, "k") || StringTools.endsWithIgnoreCase(maxSizeS, "kb") ? StringTools.parseLong(maxSizeS, 0L) * 1000L : (StringTools.isLong(maxSizeS, true) ? StringTools.parseLong(maxSizeS, 0L) : StringTools.parseLong(maxSizeS, 0L)))));
            Print.setRotateLogFileSize(maxSize >= 0L ? maxSize : 0L);
        }
        return printRotateLogFileSize;
    }

    public static void setRotateDeleteAgeSec(long delAgeSec) {
        printRotateDelAgeSec = delAgeSec < 0L ? -1L : (delAgeSec == 0L ? 0L : delAgeSec);
    }

    public static long getRotateDeleteAgeSec() {
        if (printRotateDelAgeSec < 0L) {
            long delAgeVal;
            String delAgeStr = RTConfig.getString("log.file.rotate.deleteAge");
            printRotateDelAgeSec = StringTools.isBlank(delAgeStr) ? 0L : ((delAgeVal = StringTools.parseLong(delAgeStr, 0L)) > 0L ? (delAgeStr.endsWith("s") ? delAgeVal : (delAgeStr.endsWith("m") ? DateTime.MinuteSeconds(delAgeVal) : DateTime.DaySeconds(delAgeVal))) : 0L);
        }
        return printRotateDelAgeSec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected static PrintStream openPrintStream() {
        if (!RTConfig.isInitialized()) {
            return System.err;
        }
        out = null;
        okToClose = false;
        var2_2 = Print.logLock;
        synchronized (var2_2) {
            if (Print.openPrintStream_recursion > 0) {
                Print.sysPrintln("[Print.openPrintStream] Recursive call to 'openPrintStream'!!!", new Object[0]);
                t = new Throwable();
                t.fillInStackTrace();
                t.printStackTrace();
                out = Print._getSysStderr();
                okToClose = false;
                return out;
            }
            logPS = Print._getLogPrintStream();
            if (logPS != null) {
                out = logPS;
                okToClose = false;
                return out;
            }
            try {
                ++Print.openPrintStream_recursion;
                ++Print.logRefCount;
                if (Print.logOutput != null) {
                    out = Print.logOutput;
                    okToClose = Print.logOutput_okToClose;
                } else {
                    logFile = Print.getLogFile();
                    if (logFile == null) {
                        out = Print._getSysStderr();
                        okToClose = false;
                    } else {
                        logFilePath = logFile.toString();
                        if (logFilePath.equals("")) {
                            out = Print._getSysStderr();
                            okToClose = false;
                        } else if (logFile.isDirectory()) {
                            Print.setLogFile(null);
                            Print.sysPrintln("ERROR: Invalid Print log file specification: " + logFile, new Object[0]);
                            out = Print._getSysStderr();
                            okToClose = false;
                        } else {
                            maxSize = Print.getRotateLogFileSize();
                            if (maxSize > 0L && logFile.isFile() && logFile.length() > maxSize) {
                                rotExtnSep = ".";
                                nowMS = DateTime.getCurrentTimeMillis();
                                absPath = logFile.getAbsolutePath();
                                rotExtn = Print.formatDate(RTConfig.getString("log.file.rotate.dateFormatExtn"));
                                bkuName = absPath + rotExtnSep + rotExtn;
                                bkuFile = new File(bkuName);
                                i = 1;
                                while (bkuFile.exists()) {
                                    bkuName = absPath + rotExtnSep + rotExtn + "." + i;
                                    bkuFile = new File(bkuName);
                                    ++i;
                                }
                                didRename = false;
                                try {
                                    didRename = logFile.renameTo(bkuFile);
                                    if (didRename) {
                                        bkuFile.setLastModified(nowMS);
                                    }
                                }
                                catch (Throwable th) {
                                    didRename = false;
                                }
                                delAgeSec = Print.getRotateDeleteAgeSec();
                                if (delAgeSec > 0L) {
                                    delAgeMS = delAgeSec * 1000L;
                                    logName_ = logFile.getName() + rotExtnSep;
                                    delFiles = logFile.getParentFile().listFiles(new FileFilter(){

                                        @Override
                                        public boolean accept(File f) {
                                            if (!f.getName().startsWith(logName_)) {
                                                return false;
                                            }
                                            return nowMS - f.lastModified() >= delAgeMS;
                                        }
                                    });
                                    ** if (ListTools.isEmpty(delFiles)) goto lbl87
                                    for (i = 0; i < delFiles.length; ++i) {
                                        didDelete = false;
                                        try {
                                            didDelete = delFiles[i].delete();
                                        }
                                        catch (Throwable th) {
                                            didDelete = false;
                                        }
                                        if (!RTConfig.isDebugMode()) continue;
                                        if (didDelete) {
                                            Print.sysPrintln("Delete : " + delFiles[i], new Object[0]);
                                            continue;
                                        }
                                        Print.sysPrintln("Delete Failed: " + delFiles[i], new Object[0]);
lbl-1000:
                                        // 2 sources

                                        {
                                            continue;
                                        }
                                    }
                                }
                            }
lbl87:
                            // 6 sources

                            try {
                                out = new PrintStream(new FileOutputStream(logFile, true));
                                okToClose = true;
                            }
                            catch (IOException ioe) {
                                Print.setLogFile(null);
                                Print.sysPrintln("ERROR: Unable to open Print log file: " + logFile, new Object[0]);
                                ioe.printStackTrace();
                                out = Print._getSysStderr();
                                okToClose = false;
                            }
                        }
                    }
                }
                Print.logOutput = out;
                Print.logOutput_okToClose = okToClose;
            }
            catch (Throwable th) {
                Print.sysPrintln("[Print.openPrintStream] Exception Occurred!!!", new Object[0]);
                th.printStackTrace();
                out = Print._getSysStderr();
            }
            finally {
                --Print.openPrintStream_recursion;
            }
        }
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void closePrintStream() {
        Object object = logLock;
        synchronized (object) {
            if (--logRefCount < 0L) {
                logRefCount = 0L;
            }
            if (logRefCount == 0L && logOutput != null) {
                if (logOutput_okToClose) {
                    try {
                        logOutput.close();
                    }
                    catch (Throwable t) {
                        Print.sysPrintln("Unable to close log file: " + t, new Object[0]);
                    }
                }
                logOutput = null;
                logOutput_okToClose = false;
            }
        }
    }

    public static void setLogLevel(int level, boolean inclDate, boolean inclFrame) {
        Print.setLogLevel(level);
        printLogIncludeDate = inclDate ? 1 : 0;
        printLogIncludeFrame = inclFrame ? 1 : 0;
    }

    public static void setLogLevel(int level) {
        if (level <= -1) {
            level = -1;
        } else if (level > 6) {
            level = 6;
        }
        printLogLevel = level;
    }

    public static int getLogLevel() {
        if (printLogLevel <= -1) {
            printLogLevel = Print.parseLogLevel(RTConfig.getString("log.level", null), 4);
        }
        return printLogLevel;
    }

    public static boolean isDebugLoggingLevel() {
        return Print.getLogLevel() >= 5;
    }

    public static void setLogHeaderLevel(int level) {
        if (level <= -1) {
            level = -1;
        } else if (level > 6) {
            level = 6;
        }
        printLogHeaderLevel = level;
    }

    public static int getLogHeaderLevel() {
        if (printLogHeaderLevel <= -1) {
            printLogHeaderLevel = Print.parseLogLevel(RTConfig.getString("log.level.header", null), 6);
        }
        return printLogHeaderLevel;
    }

    public static String getLogLevelString(int level) {
        if (level <= 0) {
            return "OFF";
        }
        switch (level) {
            case 1: {
                return "FATAL";
            }
            case 2: {
                return "ERROR";
            }
            case 3: {
                return "WARN_";
            }
            case 4: {
                return "INFO_";
            }
            case 5: {
                return "DEBUG";
            }
        }
        return "ALL";
    }

    public static int parseLogLevel(String val, int dft) {
        String v;
        String string = v = val != null ? val.toUpperCase() : null;
        if (StringTools.isBlank(v)) {
            return dft;
        }
        if (Character.isDigit(v.charAt(0))) {
            int lvl = StringTools.parseInt(v.substring(0, 1), 6);
            if (lvl < 0) {
                return 0;
            }
            if (lvl > 6) {
                return 6;
            }
            return lvl;
        }
        if (v.startsWith("OFF")) {
            return 0;
        }
        if (v.startsWith("FAT")) {
            return 1;
        }
        if (v.startsWith("ERR")) {
            return 2;
        }
        if (v.startsWith("WAR")) {
            return 3;
        }
        if (v.startsWith("INF")) {
            return 4;
        }
        if (v.startsWith("DEB")) {
            return 5;
        }
        if (v.startsWith("ALL")) {
            return 6;
        }
        return dft;
    }

    public static void log(int level, String msg) {
        Print._log(level, 1, msg, new Object[0]);
    }

    public static void logFatal(String msg, Object ... args) {
        Print._log(1, 1, msg, args);
    }

    public static void logError(String msg, Object ... args) {
        Print._log(2, 1, msg, args);
    }

    public static void logWarn(String msg, Object ... args) {
        Print._log(3, 1, msg, args);
    }

    public static void logInfo(String msg, Object ... args) {
        Print._log(4, 1, msg, args);
    }

    public static void logDebug(String msg, Object ... args) {
        Print._log(5, 1, msg, args);
    }

    public static void _log(int level, int frame, String msg, Object ... args) {
        int nextFrame;
        int n = nextFrame = frame >= 0 ? frame + 1 : frame;
        if (level > Print.getLogLevel()) {
            return;
        }
        StringBuffer logMsg = new StringBuffer();
        if (level <= Print.getLogHeaderLevel()) {
            logMsg.append("[");
            logMsg.append(Print.getLogLevelString(level));
            if (Print._includeDate()) {
                logMsg.append("|");
                logMsg.append(Print.formatDate("MM/dd HH:mm:ss"));
            }
            if (Print._includeStackFrame() && nextFrame >= 0) {
                logMsg.append("|");
                logMsg.append(Print._getStackFrame(nextFrame));
            }
            logMsg.append("] ");
        }
        if (msg != null) {
            if (args != null && args.length > 0) {
                try {
                    logMsg.append(String.format(msg, args));
                }
                catch (Throwable th) {
                    System.out.println("ERROR: [" + msg + "] " + th);
                    logMsg.append(msg);
                }
            } else {
                logMsg.append(msg);
            }
            if (!msg.endsWith("\n")) {
                logMsg.append("\n");
            }
        } else {
            logMsg.append("\n");
        }
        Print._writeLog(level, logMsg.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void _writeLog(int level, String logMsg) {
        PrintStream out = Print.openPrintStream();
        if (out == null) {
            Print._print(Print._getSysStderr(), 0, false, logMsg, new Object[0]);
            return;
        }
        try {
            byte[] d = StringTools.getBytes(logMsg);
            out.write(d);
            out.flush();
        }
        catch (IOException ioe) {
            Print.setLogFile(null);
            Print.logError("Unable to open/write log file: " + ioe, new Object[0]);
            Print._print(Print._getSysStderr(), 0, false, logMsg, new Object[0]);
        }
        finally {
            Print.closePrintStream();
        }
    }

    public static class NullPrintStream
    extends PrintStream {
        public NullPrintStream() {
            super(new NullOutputStream());
        }
    }

    public static class NullOutputStream
    extends OutputStream {
        @Override
        public void write(int b) throws IOException {
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.write(b, 0, b.length);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
        }

        @Override
        public void flush() throws IOException {
        }

        @Override
        public void close() throws IOException {
        }
    }

    public static class RedirectStream
    extends PrintStream {
        public RedirectStream() {
            super(new NullOutputStream());
        }

        private void _print(byte[] b, int off, int len) {
            this.print(StringTools.toStringValue(b, off, len));
        }

        @Override
        public void print(String s) {
        }

        @Override
        public void println(String s) {
            this.print(s + "\n");
        }
    }

    private static class LoggerOutputStream
    extends ByteArrayOutputStream {
        private StringBuffer buffer = new StringBuffer();
        private Logger logger = null;
        private int level = 4;

        public LoggerOutputStream(String name) {
            this.logger = Logger.getLogger(name);
            this.logger.setLevel(Level.ALL);
        }

        public void setLevel(int level) {
            this.level = level;
        }

        @Override
        public void write(byte[] b) {
            for (int i = 0; i < b.length; ++i) {
                this.write(b[i] & 0xFF);
            }
        }

        @Override
        public void write(byte[] b, int off, int len) {
            for (int i = off; i < off + len && i < b.length; ++i) {
                this.write(b[i] & 0xFF);
            }
        }

        @Override
        public void write(int b) {
            super.write(b);
        }

        @Override
        public void flush() {
            this.flush(this.level);
        }

        public void flush(int lvl) {
            byte[] b = super.toByteArray();
            String s = StringTools.toStringValue(b);
            String[] a = StringTools.split(s, '\n');
            block6: for (int i = 0; i < a.length; ++i) {
                switch (lvl) {
                    case 1: 
                    case 2: {
                        this.logger.log(Level.SEVERE, a[i]);
                        continue block6;
                    }
                    case 3: {
                        this.logger.log(Level.WARNING, a[i]);
                        continue block6;
                    }
                    case 4: {
                        this.logger.log(Level.INFO, a[i]);
                        continue block6;
                    }
                    case 5: {
                        this.logger.log(Level.FINE, a[i]);
                    }
                }
            }
            super.reset();
        }

        @Override
        public void close() {
        }
    }
}

