/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.util;

import org.opengts.util.DateTime;
import org.opengts.util.ListTools;
import org.opengts.util.OSTools;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;
import org.opengts.util.StringTools;
import sun.misc.Signal;
import sun.misc.SignalHandler;

public class PosixSignalHandler {
    public static final String SIGNAL_HUP = "SIGHUP";
    public static final String SIGNAL_INT = "SIGINT";
    public static final String SIGNAL_TERM = "SIGTERM";
    public static final String SIGNAL_ABRT = "SIGABRT";
    public static final String[] SIGNAL_LIST = new String[]{"SIGHUP", "SIGINT", "SIGTERM", "SIGABRT"};
    private boolean sunSignalAvail = false;

    public static boolean isValidSignalNames(String ... sigs) {
        if (ListTools.isEmpty(sigs)) {
            return false;
        }
        for (int i = 0; i < sigs.length; ++i) {
            String sigName;
            String string = sigName = sigs[i] != null ? sigs[i].trim().toUpperCase() : null;
            if (sigName == null) {
                return false;
            }
            if (!sigName.startsWith("SIG")) {
                sigName = "SIG" + sigName;
            }
            if (ListTools.contains(SIGNAL_LIST, sigName)) continue;
            return false;
        }
        return true;
    }

    public PosixSignalHandler() {
        try {
            Class.forName("sun.misc.SignalHandler");
            this.sunSignalAvail = true;
        }
        catch (Throwable th) {
            Print.logWarn("'sun.misc.Signal' is not available", new Object[0]);
            this.sunSignalAvail = false;
        }
    }

    public PosixSignalHandler(String ... sigs) throws IllegalArgumentException {
        this();
        if (this.sunSignalAvail && sigs != null) {
            this.handleSignal(sigs);
        }
    }

    public boolean sunSignalHandlerAvailable() {
        return this.sunSignalAvail;
    }

    public boolean handleSignal(String ... sigNames) throws IllegalArgumentException {
        if (!this.sunSignalAvail) {
            return false;
        }
        if (!PosixSignalHandler.isValidSignalNames(sigNames)) {
            String sigStr = StringTools.join(sigNames, ",");
            throw new IllegalArgumentException("Invalid Signal names specified: " + sigStr);
        }
        for (int i = 0; i < sigNames.length; ++i) {
            this._handleSignal(sigNames[i]);
        }
        return true;
    }

    public boolean _handleSignal(String sigName) throws IllegalArgumentException {
        if (!this.sunSignalAvail) {
            return false;
        }
        if ((sigName = StringTools.trim(sigName).toUpperCase()).startsWith("SIG")) {
            sigName = sigName.substring(3).trim();
        }
        if (StringTools.isBlank(sigName)) {
            throw new IllegalArgumentException("Invalid blank signal name");
        }
        try {
            Signal.handle(new Signal(sigName), new SignalHandler(){

                @Override
                public void handle(Signal sig) {
                    String sigStr = sig != null ? sig.toString() : "unknown";
                    PosixSignalHandler.this.signal(sigStr);
                }
            });
            return true;
        }
        catch (Throwable th) {
            Print.logException("Unable to handle signal", th);
            return false;
        }
    }

    protected void signal(String sigName) {
        if (StringTools.isBlank(sigName)) {
            Print.logWarn("Received Signal: <blank>", new Object[0]);
            return;
        }
        if (!(sigName = sigName.trim().toUpperCase()).startsWith("SIG")) {
            sigName = "SIG" + sigName;
        }
        if (sigName.equalsIgnoreCase(SIGNAL_HUP)) {
            this.signal_HUP();
        } else if (sigName.equalsIgnoreCase(SIGNAL_INT)) {
            this.signal_INT();
        } else if (sigName.equalsIgnoreCase(SIGNAL_ABRT)) {
            this.signal_ABRT();
        } else if (sigName.equalsIgnoreCase(SIGNAL_TERM)) {
            this.signal_TERM();
        } else {
            Print.logInfo("Received Signal: " + sigName, new Object[0]);
        }
    }

    protected void signal_HUP() {
        Print.logInfo("Received HUP", new Object[0]);
    }

    protected void signal_INT() {
        Print.logInfo("Received INT", new Object[0]);
    }

    protected void signal_ABRT() {
        Print.logInfo("Received ABRT", new Object[0]);
    }

    protected void signal_TERM() {
        Print.logInfo("Received TERM", new Object[0]);
    }

    public static void main(String[] argv) {
        RTConfig.setCommandLineArgs(argv);
        String sigStr = RTConfig.getString("sig", "HUP");
        Print.sysPrintln("My PID: " + OSTools.getProcessID(), new Object[0]);
        try {
            PosixSignalHandler psh = new PosixSignalHandler(sigStr);
            Print.sysPrintln("Handling " + sigStr + " ...", new Object[0]);
            try {
                long startMS = DateTime.getCurrentTimeMillis();
                long waitMS = 120000L;
                long intervalMS = 3333L;
                while (true) {
                    Thread.sleep(intervalMS);
                    long nowMS = DateTime.getCurrentTimeMillis();
                    long deltaMS = nowMS - startMS;
                    if (deltaMS < waitMS) {
                        if (deltaMS < intervalMS) {
                            Print.sysPrint("*", new Object[0]);
                            continue;
                        }
                        Print.sysPrint(".", new Object[0]);
                        continue;
                    }
                    break;
                }
            }
            catch (Throwable throwable) {
            }
        }
        catch (IllegalArgumentException iae) {
            Print.logException("Invalid signal name", iae);
            System.exit(1);
        }
    }
}

