/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.util;

import org.opengts.util.Print;
import org.opengts.util.RTConfig;
import org.opengts.util.StringTools;

public class PixelPoint
implements Cloneable {
    private double dX = 0.0;
    private double dY = 0.0;
    private double dZ = 0.0;

    private static double SQ(double X) {
        return X * X;
    }

    public PixelPoint() {
        this(0.0, 0.0, 0.0);
    }

    public PixelPoint(int x, int y) {
        this(x, y, 0);
    }

    public PixelPoint(int x, int y, int z) {
        this.setX(x);
        this.setY(y);
        this.setZ(z);
    }

    public PixelPoint(double x, double y) {
        this(x, y, 0.0);
    }

    public PixelPoint(double x, double y, double z) {
        this.setX(x);
        this.setY(y);
        this.setZ(z);
    }

    public PixelPoint(PixelPoint pp) {
        this.setX(pp != null ? pp.getX() : 0.0);
        this.setY(pp != null ? pp.getY() : 0.0);
        this.setZ(pp != null ? pp.getZ() : 0.0);
    }

    public Object clone() {
        return new PixelPoint(this);
    }

    public void setX(int x) {
        this.dX = x;
    }

    public void setX(double x) {
        this.dX = x;
    }

    public double getX() {
        return this.dX;
    }

    public int getIntX() {
        return (int)Math.round(this.dX);
    }

    public void setY(int y) {
        this.dY = y;
    }

    public void setY(double y) {
        this.dY = y;
    }

    public double getY() {
        return this.dY;
    }

    public int getIntY() {
        return (int)Math.round(this.dY);
    }

    public void setZ(int z) {
        this.dZ = z;
    }

    public void setZ(double z) {
        this.dZ = z;
    }

    public double getZ() {
        return this.dZ;
    }

    public int getIntZ() {
        return (int)Math.round(this.dZ);
    }

    public double distanceToPixel(PixelPoint pp) {
        double deltaX = this.getX() - pp.getX();
        double deltaY = this.getY() - pp.getY();
        double deltaZ = this.getZ() - pp.getZ();
        return Math.sqrt(PixelPoint.SQ(deltaX) + PixelPoint.SQ(deltaY) + PixelPoint.SQ(deltaZ));
    }

    public PixelPoint toWorldCoordinates(double thetaDeg) {
        double X = this.getX();
        double Y = this.getY();
        double thetaRad = thetaDeg * (Math.PI / 180);
        double cosTheta = Math.cos(thetaRad);
        double sinTheta = Math.sin(thetaRad);
        double newX = X * cosTheta + Y * sinTheta;
        double newY = X * -sinTheta + Y * cosTheta;
        return new PixelPoint(newX, newY, this.getZ());
    }

    public PixelPoint fromWorldCoordinates(double thetaDeg) {
        return this.toWorldCoordinates(-thetaDeg);
    }

    private static String _format(double v, int d) {
        if (d < 0) {
            return String.valueOf(v);
        }
        if (d == 0) {
            return String.valueOf((int)Math.round(v));
        }
        String fmt = "0." + StringTools.replicateString("0", d);
        return StringTools.format(v, fmt);
    }

    public String toString(int dec) {
        StringBuffer sb = new StringBuffer();
        sb.append("[");
        sb.append(PixelPoint._format(this.getX(), dec));
        sb.append(",");
        sb.append(PixelPoint._format(this.getY(), dec));
        sb.append("]");
        return sb.toString();
    }

    public String toString() {
        return this.toString(-1);
    }

    public static void main(String[] argv) {
        RTConfig.setCommandLineArgs(argv);
        double X = RTConfig.getDouble("X", 0.0);
        double Y = RTConfig.getDouble("Y", 0.0);
        double T = RTConfig.getDouble("T", 0.0);
        PixelPoint pp = new PixelPoint(X, Y);
        Print.sysPrintln(pp.toWorldCoordinates(T).toString(1), new Object[0]);
    }
}

