/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.util;

import java.util.Random;
import org.opengts.util.Checksum;
import org.opengts.util.GeoPoint;
import org.opengts.util.Print;
import org.opengts.util.StringTools;

public class Payload {
    public static final int DEFAULT_MAX_PAYLOAD_LENGTH = 255;
    public static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private static final boolean DEFAULT_BIG_ENDIAN = true;
    private static boolean DebugLogging = false;
    private byte[] payload = null;
    private int size = 0;
    private int index = 0;
    private int indexSnapshot = -1;
    private boolean bigEndian = true;

    public static void SetDebugLogging(boolean debug) {
        DebugLogging = debug;
    }

    public static boolean GetDebugLogging() {
        return DebugLogging;
    }

    protected static void checkOverflow(int length, int maxLen, int frame, String msg) {
        if (maxLen < length) {
            String frameStr = Print._getStackFrame(frame + 1);
            if (msg != null) {
                Print.logWarn("Payload overflow at \"" + frameStr + "\": " + msg, new Object[0]);
            } else {
                Print.logWarn("Payload overflow at \"" + frameStr + "\"", new Object[0]);
            }
        }
    }

    public Payload() {
        this(255, true);
    }

    public Payload(int maxPayloadLen) {
        this(maxPayloadLen, true);
    }

    public Payload(boolean bigEndian) {
        this(255, bigEndian);
    }

    public Payload(int maxPayloadLen, boolean bigEndian) {
        this.payload = maxPayloadLen >= 0 ? new byte[maxPayloadLen] : null;
        this.size = 0;
        this.index = 0;
        this.setBigEndian(bigEndian);
    }

    public Payload(byte[] b) {
        this(1, b, 0, b != null ? b.length : 0, true);
    }

    public Payload(byte[] b, boolean bigEndian) {
        this(1, b, 0, b != null ? b.length : 0, bigEndian);
    }

    public Payload(byte[] b, int ofs, int len) {
        this(1, b, ofs, len, true);
    }

    public Payload(byte[] n, int ofs, int len, boolean bigEndian) {
        this(1, n, ofs, len, bigEndian);
    }

    protected Payload(int frame, byte[] n, int ofs, int len, boolean bigEndian) {
        this();
        if (n == null || ofs >= n.length) {
            this.payload = new byte[0];
            this.size = 0;
            this.index = 0;
        } else if (ofs == 0 && n.length == len) {
            this.payload = n;
            this.size = n.length;
            this.index = 0;
        } else {
            if (len > n.length - ofs) {
                len = n.length - ofs;
            }
            this.payload = new byte[len];
            System.arraycopy(n, ofs, this.payload, 0, len);
            this.index = 0;
            this.index = 0;
            this.size = len;
        }
        this.setBigEndian(bigEndian);
        if (DebugLogging) {
            this.printDebug_source(frame + 1);
        }
    }

    public void setBigEndian() {
        this.setBigEndian(true);
    }

    public void setLittleEndian() {
        this.setBigEndian(false);
    }

    public void setBigEndian(boolean bigEndFirst) {
        this.bigEndian = bigEndFirst;
    }

    public boolean getBigEndian() {
        return this.bigEndian;
    }

    public boolean isBigEndian() {
        return this.bigEndian;
    }

    public int getSize() {
        return this.size;
    }

    public void clear() {
        this.size = 0;
        this.index = 0;
    }

    private byte[] _payloadBytes() {
        return this.payload;
    }

    private int _zeroBytes(int zLen) {
        if (zLen > 0) {
            byte[] b = this._payloadBytes();
            if (b != null) {
                for (int z = 0; z < zLen; ++z) {
                    b[this.index + z] = 0;
                }
            }
            this.index += zLen;
            if (this.size < this.index) {
                this.size = this.index;
            }
            return zLen;
        }
        return 0;
    }

    private int _putBytes(byte[] n, int nOfs, int nLen) {
        if (nLen > 0) {
            byte[] b = this._payloadBytes();
            if (b != null) {
                System.arraycopy(n, nOfs, b, this.index, nLen);
            }
            this.index += nLen;
            if (this.size < this.index) {
                this.size = this.index;
            }
            return nLen;
        }
        return 0;
    }

    private byte[] _getBytes(int bOfs, int nLen) {
        byte[] b = this._payloadBytes();
        if (b == null) {
            return new byte[0];
        }
        if (nLen == b.length) {
            return b;
        }
        byte[] n = new byte[nLen];
        System.arraycopy(b, bOfs, n, 0, nLen);
        return n;
    }

    public byte[] getBytes() {
        byte[] b = this._getBytes(0, this.size);
        return b;
    }

    public int calcCrcCCITT(int bOfs, int bLen) {
        byte[] b = this._payloadBytes();
        int bSize = this.size;
        return Payload.CalcCrcCCITT(b, bSize, bOfs, bLen);
    }

    public static int CalcCrcCCITT(byte[] b, int bSize, int bOfs, int bLen) {
        int siz;
        if (b == null) {
            return 0;
        }
        int n = siz = bSize >= 0 && bSize <= b.length ? bSize : b.length;
        if (bOfs < 0 || bOfs > siz) {
            return 0;
        }
        int ofs = bOfs <= 0 ? 0 : (bOfs >= siz ? siz : bOfs);
        int len = bLen >= 0 && bLen <= siz - ofs ? bLen : siz - ofs;
        return Checksum.calcCrcCCITT(b, ofs, len);
    }

    public int calcCrc16(int bOfs, int bLen) {
        byte[] b = this._payloadBytes();
        int bSize = this.size;
        return Payload.CalcCrc16(b, bSize, bOfs, bLen);
    }

    public static int CalcCrc16(byte[] b, int bSize, int bOfs, int bLen) {
        int siz;
        if (b == null) {
            return 0;
        }
        int n = siz = bSize >= 0 && bSize <= b.length ? bSize : b.length;
        if (bOfs < 0 || bOfs > siz) {
            return 0;
        }
        int ofs = bOfs <= 0 ? 0 : (bOfs >= siz ? siz : bOfs);
        int len = bLen >= 0 && bLen <= siz - ofs ? bLen : siz - ofs;
        return Checksum.calcCrc16(b, ofs, len);
    }

    public int calcCrcSum8(int bOfs, int bLen) {
        byte[] b = this._payloadBytes();
        int bSize = this.size;
        return Payload.CalcCrcSum8(b, bSize, bOfs, bLen);
    }

    public static int CalcCrcSum8(byte[] b, int bSize, int bOfs, int bLen) {
        int siz;
        if (b == null) {
            return 0;
        }
        int n = siz = bSize >= 0 && bSize <= b.length ? bSize : b.length;
        if (bOfs < 0 || bOfs > siz) {
            return 0;
        }
        int ofs = bOfs <= 0 ? 0 : (bOfs >= siz ? siz : bOfs);
        int len = bLen >= 0 && bLen <= siz - ofs ? bLen : siz - ofs;
        return Checksum.calcCrcSum8(b, ofs, len);
    }

    public int getIndex() {
        return this.index;
    }

    public void resetIndex() {
        this.resetIndex(0);
    }

    public void resetIndex(int ndx) {
        this.index = ndx <= 0 ? 0 : ndx;
    }

    public boolean saveIndex() {
        this.indexSnapshot = this.getIndex();
        return true;
    }

    public boolean restoreIndex() {
        if (this.indexSnapshot >= 0) {
            this.resetIndex(this.indexSnapshot);
            return true;
        }
        return false;
    }

    public int getMaximumReadLength(int length) {
        return this.index + length <= this.size ? length : this.size - this.index;
    }

    public int getMaximumReadLength() {
        return this.size - this.index;
    }

    public int getAvailableReadLength() {
        return this.size - this.index;
    }

    public boolean isValidReadLength(int length) {
        return this.index + length <= this.size;
    }

    public boolean hasAvailableRead() {
        return this.getAvailableReadLength() > 0;
    }

    public int getMaximumWriteLength(int wrtLen) {
        byte[] b = this._payloadBytes();
        if (b == null) {
            return wrtLen;
        }
        return this.index + wrtLen <= b.length ? wrtLen : b.length - this.index;
    }

    public int getAvailableWriteLength() {
        byte[] b = this._payloadBytes();
        if (b == null) {
            return 20000;
        }
        return b.length - this.index;
    }

    public boolean isValidWriteLength(int length) {
        byte[] b = this._payloadBytes();
        if (b == null) {
            return true;
        }
        return this.index + length <= b.length;
    }

    public boolean hasAvailableWrite() {
        return this.getAvailableWriteLength() > 0;
    }

    public void readSkip(int length) {
        this._readSkip(length, 1, null);
    }

    public void readSkip(int length, String msg) {
        this._readSkip(length, 1, msg);
    }

    protected void _readSkip(int length, int frame, String msg) {
        int maxLen = this.getMaximumReadLength(length);
        Payload.checkOverflow(length, maxLen, frame + 1, msg);
        if (maxLen <= 0) {
            return;
        }
        if (DebugLogging) {
            this.printDebug(frame + 1, maxLen, (byte[])null, msg);
        }
        this.index += maxLen;
    }

    public int peekByte() {
        if (this.index < this.size) {
            byte[] b = this._payloadBytes();
            if (b == null) {
                return -1;
            }
            return b[this.index] & 0xFF;
        }
        return -1;
    }

    public byte[] peekBytes(int length) {
        int maxLen;
        int peekStart = this.index;
        int n = maxLen = length >= 0 && peekStart + length <= this.size ? length : this.size - peekStart;
        if (maxLen <= 0) {
            return new byte[0];
        }
        byte[] n2 = this._getBytes(peekStart, maxLen);
        return n2;
    }

    public byte[] peekBytes(int offset, int length) {
        int maxLen;
        if (offset < 0) {
            return new byte[0];
        }
        int peekStart = this.index + offset;
        int n = maxLen = length >= 0 && peekStart + length <= this.size ? length : this.size - peekStart;
        if (maxLen <= 0) {
            return new byte[0];
        }
        byte[] n2 = this._getBytes(peekStart, maxLen);
        return n2;
    }

    public int scanForPattern(byte[] p) {
        return this.scanForPattern(p, 0);
    }

    public int scanForPattern(byte[] p, int fromNdx) {
        if (p == null || p.length == 0) {
            return -1;
        }
        if (fromNdx < 0) {
            fromNdx = 0;
        }
        byte[] b = this._payloadBytes();
        int lastNdx = this.size - p.length;
        for (int ndx = this.index + fromNdx; ndx <= lastNdx; ++ndx) {
            int m;
            if (p[0] != b[ndx]) continue;
            for (m = 1; m < p.length && p[m] == b[ndx + m]; ++m) {
            }
            if (m != p.length) continue;
            return ndx - this.index;
        }
        return -1;
    }

    public byte[] readBytes(int length) {
        return this._readBytes(length, null, 1);
    }

    public byte[] readBytes(int length, String msg) {
        return this._readBytes(length, msg, 1);
    }

    protected byte[] _readBytes(int length, String msg, int frame) {
        int maxLen = length >= 0 ? this.getMaximumReadLength(length) : this.size - this.index;
        Payload.checkOverflow(length, maxLen, frame + 1, msg);
        if (maxLen <= 0) {
            return new byte[0];
        }
        byte[] n = this._getBytes(this.index, maxLen);
        if (DebugLogging) {
            this.printDebug(frame + 1, maxLen, n, msg);
        }
        this.index += maxLen;
        return n;
    }

    public static long reverseByteOrder(long value, int byteCount) {
        long accum = 0L;
        if (byteCount > 8) {
            byteCount = 8;
        }
        for (int i = 0; i < byteCount; ++i) {
            accum |= (value >> i * 8 & 0xFFL) << (byteCount - 1 - i) * 8;
        }
        return accum;
    }

    public static long decodeLong(byte[] data, int ofs, int len, boolean bigEndian, boolean signed, long dft) {
        if (data != null && data.length >= ofs + len) {
            if (bigEndian) {
                long n = signed && (data[ofs] & 0x80) != 0 ? -1L : 0L;
                for (int i = ofs; i < ofs + len; ++i) {
                    n = n << 8 | (long)data[i] & 0xFFL;
                }
                return n;
            }
            long n = signed && (data[ofs + len - 1] & 0x80) != 0 ? -1L : 0L;
            for (int i = ofs + len - 1; i >= ofs; --i) {
                n = n << 8 | (long)data[i] & 0xFFL;
            }
            return n;
        }
        return dft;
    }

    protected long _readLong(int length, long dft, boolean bigEndian, int frame, String msg) {
        int maxLen = this.getMaximumReadLength(length);
        Payload.checkOverflow(length, maxLen, frame + 1, msg);
        if (maxLen <= 0) {
            return dft;
        }
        byte[] b = this._payloadBytes();
        long val = Payload.decodeLong(b, this.index, maxLen, bigEndian, true, dft);
        if (DebugLogging) {
            this.printDebug(frame + 1, maxLen, bigEndian, true, val, msg);
        }
        this.index += maxLen;
        return val;
    }

    public long readLong(int length, long dft, boolean bigEndian) {
        return this._readLong(length, dft, bigEndian, 1, null);
    }

    public long readLong(int length, long dft, boolean bigEndian, String msg) {
        return this._readLong(length, dft, bigEndian, 1, msg);
    }

    public long readLong(int length, long dft) {
        return this._readLong(length, dft, this.bigEndian, 1, null);
    }

    public long readLong(int length, long dft, String msg) {
        return this._readLong(length, dft, this.bigEndian, 1, msg);
    }

    public int readInt(int length, int dft) {
        return (int)this._readLong(length, dft, this.bigEndian, 1, null);
    }

    public int readInt(int length, int dft, String msg) {
        return (int)this._readLong(length, dft, this.bigEndian, 1, msg);
    }

    protected long _readULong(int length, long dft, boolean bigEndian, int frame, String msg) {
        int maxLen = this.getMaximumReadLength(length);
        Payload.checkOverflow(length, maxLen, frame + 1, msg);
        if (maxLen <= 0) {
            return dft;
        }
        byte[] b = this._payloadBytes();
        long val = Payload.decodeLong(b, this.index, maxLen, bigEndian, false, dft);
        if (DebugLogging) {
            this.printDebug(frame + 1, maxLen, bigEndian, false, val, msg);
        }
        this.index += maxLen;
        return val;
    }

    public long readULong(int length, long dft, boolean bigEndian) {
        return this._readULong(length, dft, bigEndian, 1, null);
    }

    public long readULong(int length, long dft, boolean bigEndian, String msg) {
        return this._readULong(length, dft, bigEndian, 1, msg);
    }

    public long readULong(int length, long dft) {
        return this._readULong(length, dft, this.bigEndian, 1, null);
    }

    public long readULong(int length, long dft, String msg) {
        return this._readULong(length, dft, this.bigEndian, 1, msg);
    }

    public int readUInt(int length, int dft, boolean bigEndian) {
        return (int)this._readULong(length, dft, bigEndian, 1, null);
    }

    public int readUInt(int length, int dft, boolean bigEndian, String msg) {
        return (int)this._readULong(length, dft, bigEndian, 1, msg);
    }

    public int readUInt(int length, int dft) {
        return (int)this._readULong(length, dft, this.bigEndian, 1, null);
    }

    public int readUInt(int length, int dft, String msg) {
        return (int)this._readULong(length, dft, this.bigEndian, 1, msg);
    }

    public boolean isValidBCD(int length) {
        int maxLen = this.getMaximumReadLength(length);
        if (maxLen <= 0) {
            return false;
        }
        byte[] b = this._payloadBytes();
        for (int i = this.index; i < this.index + maxLen; ++i) {
            long N1 = (long)(b[i] >> 4) & 0xFL;
            long N2 = (long)(b[i] >> 0) & 0xFL;
            if (N1 <= 9L && N2 <= 9L) continue;
            return false;
        }
        return true;
    }

    public long readLongBCD(int length, long dft) {
        return this.readLongBCD(length, dft, null);
    }

    public long readLongBCD(int length, long dft, String msg) {
        int maxLen = this.getMaximumReadLength(length);
        Payload.checkOverflow(length, maxLen, 1, msg);
        if (maxLen <= 0) {
            return dft;
        }
        byte[] b = this._payloadBytes();
        long val = 0L;
        if (this.bigEndian) {
            for (int i = this.index; i < this.index + maxLen; ++i) {
                long N1 = (long)(b[i] >> 4) & 0xFL;
                long N2 = (long)(b[i] >> 0) & 0xFL;
                if (N1 > 9L || N2 > 9L) {
                    val = dft;
                    break;
                }
                val = val * 10L + N1;
                val = val * 10L + N2;
            }
        } else {
            for (int i = this.index + maxLen - 1; i >= this.index; --i) {
                long N1 = (long)(b[i] >> 4) & 0xFL;
                long N2 = (long)(b[i] >> 0) & 0xFL;
                if (N1 > 9L || N2 > 9L) {
                    val = dft;
                    break;
                }
                val = val * 10L + N1;
                val = val * 10L + N2;
            }
        }
        if (DebugLogging) {
            this.printDebug(1, maxLen, true, false, val, msg);
        }
        this.index += maxLen;
        return val;
    }

    public int readIntBCD(int length, int dft) {
        return (int)this.readLongBCD(length, dft, null);
    }

    public int readIntBCD(int length, int dft, String msg) {
        return (int)this.readLongBCD(length, dft, msg);
    }

    public static double decodeDouble(byte[] data, int ofs, int len, boolean bigEndian, double dft) {
        if (data != null && len >= 4 && data.length >= ofs + len) {
            int flen = len >= 8 ? 8 : 4;
            long n = 0L;
            if (bigEndian) {
                for (int i = ofs; i < ofs + flen; ++i) {
                    n = n << 8 | (long)data[i] & 0xFFL;
                }
            } else {
                for (int i = ofs + flen - 1; i >= ofs; --i) {
                    n = n << 8 | (long)data[i] & 0xFFL;
                }
            }
            if (flen == 8) {
                return Double.longBitsToDouble(n);
            }
            return Float.intBitsToFloat((int)n);
        }
        return dft;
    }

    protected double _readDouble(int length, double dft, boolean bigEndian, int frame, String msg) {
        int maxLen = this.getMaximumReadLength(length);
        Payload.checkOverflow(length, maxLen, frame + 1, msg);
        if (maxLen <= 0) {
            return dft;
        }
        byte[] b = this._payloadBytes();
        double val = Payload.decodeDouble(b, this.index, maxLen, bigEndian, dft);
        if (DebugLogging) {
            this.printDebug(frame + 1, maxLen, bigEndian, val, msg);
        }
        this.index += maxLen;
        return val;
    }

    public double readDouble(int length, double dft, boolean bigEndian) {
        return this._readDouble(length, dft, bigEndian, 1, null);
    }

    public double readDouble(int length, double dft, boolean bigEndian, String msg) {
        return this._readDouble(length, dft, bigEndian, 1, msg);
    }

    public double readDouble(int length, double dft) {
        return this._readDouble(length, dft, this.bigEndian, 1, null);
    }

    public double readDouble(int length, double dft, String msg) {
        return this._readDouble(length, dft, this.bigEndian, 1, msg);
    }

    protected String _readString(int length, boolean varLength, int frame, String msg) {
        String str;
        int maxLen = this.getMaximumReadLength(length);
        if (!varLength) {
            Payload.checkOverflow(length, maxLen, frame + 1, msg);
        }
        if (maxLen <= 0) {
            return "";
        }
        byte[] b = this._payloadBytes();
        if (b == null) {
            return "";
        }
        int st = 0;
        for (st = 0; st < maxLen && this.index + st < this.size && b[this.index + st] != 0; ++st) {
        }
        String string = str = st > 0 ? StringTools.toStringValue(b, this.index, st) : "";
        if (DebugLogging) {
            this.printDebug(frame + 1, varLength ? st + 1 : maxLen, str, msg);
        }
        if (varLength) {
            this.index += st;
            if (st < maxLen) {
                ++this.index;
            }
        } else {
            this.index += this.index + maxLen < this.size ? maxLen : this.size - this.index;
        }
        return str;
    }

    public String readString(int length, boolean varLength) {
        return this._readString(length, varLength, 1, null);
    }

    public String readString(int length, boolean varLength, String msg) {
        return this._readString(length, varLength, 1, msg);
    }

    public String readString(int length) {
        return this._readString(length, true, 1, null);
    }

    public String readString(int length, String msg) {
        return this._readString(length, true, 1, msg);
    }

    protected String _readStringHex(int length, int frame, String msg) {
        int maxLen = this.getMaximumReadLength(length);
        if (maxLen <= 0) {
            return "";
        }
        byte[] b = this._payloadBytes();
        if (b == null) {
            return "";
        }
        String str = StringTools.toHexString(b, this.index, maxLen);
        if (DebugLogging) {
            this.printDebug(frame + 1, maxLen, str, msg);
        }
        this.index += maxLen;
        return str;
    }

    public String readStringHex(int length) {
        return this._readStringHex(length, 1, null);
    }

    public String readStringHex(int length, String msg) {
        return this._readStringHex(length, 1, msg);
    }

    public GeoPoint readGPS(int length) {
        return this.readGPS(length, null);
    }

    public GeoPoint readGPS(int length, String msg) {
        int maxLen = this.getMaximumReadLength(length);
        Payload.checkOverflow(length, maxLen, 1, msg);
        if (maxLen < 6) {
            GeoPoint gp = new GeoPoint();
            if (maxLen > 0) {
                this.index += maxLen;
            }
            return gp;
        }
        if (maxLen < 8) {
            byte[] b = this._payloadBytes();
            GeoPoint gp = GeoPoint.decodeGeoPoint(b, this.index, maxLen);
            if (DebugLogging) {
                this.printDebug(1, maxLen, gp, msg);
            }
            this.index += maxLen;
            return gp;
        }
        byte[] b = this._payloadBytes();
        GeoPoint gp = GeoPoint.decodeGeoPoint(b, this.index, maxLen);
        if (DebugLogging) {
            this.printDebug(1, maxLen, gp, msg);
        }
        this.index += maxLen;
        return gp;
    }

    public static int encodeLong(byte[] data, int ofs, int len, boolean bigEndian, long val) {
        if (data != null && data.length >= ofs + len) {
            long n = val;
            if (bigEndian) {
                for (int i = ofs + len - 1; i >= ofs; --i) {
                    data[i] = (byte)(n & 0xFFL);
                    n >>>= 8;
                }
            } else {
                for (int i = ofs; i < ofs + len; ++i) {
                    data[i] = (byte)(n & 0xFFL);
                    n >>>= 8;
                }
            }
            return len;
        }
        return 0;
    }

    protected int _writeLong(long val, int wrtLen, boolean bigEndian, int frame) {
        if (wrtLen <= 0) {
            return 0;
        }
        int maxLen = this.getMaximumWriteLength(wrtLen);
        Payload.checkOverflow(wrtLen, maxLen, frame + 1, "_writeLong");
        if (maxLen < wrtLen) {
            return 0;
        }
        byte[] b = this._payloadBytes();
        Payload.encodeLong(b, this.index, maxLen, bigEndian, val);
        this.index += maxLen;
        if (this.size < this.index) {
            this.size = this.index;
        }
        return maxLen;
    }

    public int writeLong(long val, int length, boolean bigEndian) {
        return this._writeLong(val, length, bigEndian, 1);
    }

    public int writeLong(long val, int length) {
        return this._writeLong(val, length, this.bigEndian, 1);
    }

    public int writeULong(long val, int length, boolean bigEndian) {
        return this._writeLong(val, length, bigEndian, 1);
    }

    public int writeULong(long val, int length) {
        return this._writeLong(val, length, this.bigEndian, 1);
    }

    public int writeInt(int val, int length) {
        return this._writeLong(val, length, this.bigEndian, 1);
    }

    public int writeUInt(int val, int length) {
        return this._writeLong((long)val & 0xFFFFFFFFL, length, this.bigEndian, 1);
    }

    public int writeByte(byte val) {
        return this._writeLong((long)val & 0xFFL, 1, this.bigEndian, 1);
    }

    public static int encodeDouble(byte[] data, int ofs, int len, boolean bigEndian, double val) {
        if (data != null && len >= 4 && data.length >= ofs + len) {
            long n;
            int flen = len >= 8 ? 8 : 4;
            long l = n = flen == 8 ? Double.doubleToRawLongBits(val) : (long)Float.floatToRawIntBits((float)val);
            if (bigEndian) {
                for (int i = ofs + flen - 1; i >= ofs; --i) {
                    data[i] = (byte)(n & 0xFFL);
                    n >>>= 8;
                }
            } else {
                for (int i = ofs; i < ofs + flen; ++i) {
                    data[i] = (byte)(n & 0xFFL);
                    n >>>= 8;
                }
            }
            return len;
        }
        return 0;
    }

    protected int _writeDouble(double val, int wrtLen, boolean bigEndian, int frame) {
        if (wrtLen <= 0) {
            return 0;
        }
        int maxLen = this.getMaximumWriteLength(wrtLen);
        Payload.checkOverflow(wrtLen, maxLen, frame + 1, "_writeDouble");
        if (maxLen < 4) {
            return 0;
        }
        byte[] b = this._payloadBytes();
        int len = wrtLen < 8 ? (b == null ? 4 : Payload.encodeDouble(b, this.index, 4, bigEndian, val)) : (b == null ? 8 : Payload.encodeDouble(b, this.index, 8, bigEndian, val));
        this.index += len;
        if (this.size < this.index) {
            this.size = this.index;
        }
        return len;
    }

    public int writeDouble(double val, int wrtLen, boolean bigEndian) {
        return this._writeDouble(val, wrtLen, bigEndian, 1);
    }

    public int writeDouble(double val, int wrtLen) {
        return this._writeDouble(val, wrtLen, this.bigEndian, 1);
    }

    protected int _writeZeroFill(int wrtLen, int frame) {
        if (wrtLen <= 0) {
            return 0;
        }
        int maxLen = this.getMaximumWriteLength(wrtLen);
        Payload.checkOverflow(wrtLen, maxLen, frame + 1, "_writeZeroFill");
        if (maxLen <= 0) {
            return 0;
        }
        this._zeroBytes(maxLen);
        return maxLen;
    }

    public int writeZeroFill(int wrtLen) {
        return this._writeZeroFill(wrtLen, 1);
    }

    protected int _writeBytes(byte[] n, int nOfs, int nLen, int wrtLen, int frame) {
        if (wrtLen <= 0) {
            return 0;
        }
        if (nOfs < 0 || nLen <= 0 || n == null) {
            return this._writeZeroFill(wrtLen, frame + 1);
        }
        if (nOfs >= n.length) {
            return this._writeZeroFill(wrtLen, frame + 1);
        }
        if (nOfs + nLen > n.length) {
            nLen = n.length - nOfs;
        }
        int maxLen = this.getMaximumWriteLength(wrtLen);
        Payload.checkOverflow(wrtLen, maxLen, frame + 1, "_writeBytes");
        if (maxLen <= 0) {
            return 0;
        }
        int m = nLen < maxLen ? nLen : maxLen;
        this._putBytes(n, nOfs, m);
        if (m < maxLen) {
            this._zeroBytes(maxLen - m);
        }
        return maxLen;
    }

    public int writeBytes(byte[] n, int nOfs, int nLen, int wrtLen) {
        return this._writeBytes(n, nOfs, nLen, wrtLen, 1);
    }

    public int writeBytes(byte[] n, int wrtLen) {
        return n == null ? this._writeZeroFill(wrtLen, 1) : this._writeBytes(n, 0, n.length, wrtLen, 1);
    }

    public int writeBytes(byte[] n) {
        return n == null ? 0 : this._writeBytes(n, 0, n.length, n.length, 1);
    }

    public int writeRandomBytes(Random rand, int wrtLen) {
        if (wrtLen > 0) {
            Random r = rand != null ? rand : new Random();
            byte[] n = new byte[wrtLen];
            r.nextBytes(n);
            return this.writeBytes(n);
        }
        return 0;
    }

    public int writeString(String s, int wrtLen) {
        return this.writeString(s, wrtLen, true);
    }

    public int writeString(String s, int wrtLen, boolean varLength) {
        if (wrtLen <= 0) {
            return 0;
        }
        int maxLen = this.getMaximumWriteLength(wrtLen);
        Payload.checkOverflow(wrtLen, maxLen, 1, "writeString");
        if (maxLen <= 0) {
            return 0;
        }
        if (s == null || s.equals("")) {
            int m = 0;
            m = varLength ? (m += this._zeroBytes(1)) : (m += this._zeroBytes(maxLen - m));
            return m;
        }
        byte[] n = StringTools.getBytes(s);
        int m = n.length < maxLen ? n.length : maxLen;
        this._putBytes(n, 0, m);
        if (m < maxLen) {
            m = varLength ? (m += this._zeroBytes(1)) : (m += this._zeroBytes(maxLen - m));
        }
        return m;
    }

    public int writeGPS(double lat, double lon, int length) {
        return this.writeGPS(new GeoPoint(lat, lon), length);
    }

    public int writeGPS(GeoPoint gp, int wrtLen) {
        if (wrtLen <= 0) {
            return 0;
        }
        int maxLen = this.getMaximumWriteLength(wrtLen);
        Payload.checkOverflow(wrtLen, maxLen, 1, "writeGPS");
        if (maxLen != wrtLen) {
            return 0;
        }
        int len = wrtLen < 8 ? 6 : 8;
        byte[] b = this._payloadBytes();
        if (b != null) {
            GeoPoint.encodeGeoPoint(gp, b, this.index, len);
        }
        this.index += len;
        if (this.size < this.index) {
            this.size = this.index;
        }
        return len;
    }

    public String toString() {
        return StringTools.toHexString(this.payload, 0, this.size);
    }

    private void _printDebug(int frame, int maxLen, String valStr, String msg) {
        int iLen;
        String frameStr = Print._getStackFrame(frame + 1);
        StringBuffer sb = new StringBuffer();
        sb.append("[PayloadDebug:" + frameStr + "] ");
        int n = this.index < 10 ? 1 : (this.index < 100 ? 2 : (iLen = this.index < 1000 ? 3 : 4));
        int sLen = this.size < 10 ? 1 : (this.size < 100 ? 2 : (this.size < 1000 ? 3 : 4));
        sb.append("(").append(StringTools.replicateString(" ", sLen - iLen)).append(this.index).append(":").append(maxLen).append(") ");
        sb.append("0x").append(StringTools.leftAlign(StringTools.toHexString(this._payloadBytes(), this.index, maxLen), 16));
        sb.append(" ==> ").append(valStr);
        if (!StringTools.isBlank(msg)) {
            sb.append("  [").append(msg).append("]");
        }
        Print.sysPrintln(sb.toString(), new Object[0]);
    }

    private void printDebug(int frame, int maxLen, byte[] n, String msg) {
        String valStr = n != null ? "(bytes) 0x" + StringTools.toHexString(n) : "(bytes) ??";
        this._printDebug(frame + 1, maxLen, valStr, msg);
    }

    private void printDebug(int frame, int maxLen, boolean bigEndian, boolean signed, long val, String msg) {
        String valStr = (signed ? "(long) " : "(ulong) ") + String.valueOf(val);
        this._printDebug(frame + 1, maxLen, valStr, msg);
    }

    private void printDebug(int frame, int maxLen, boolean bigEndian, double val, String msg) {
        String valStr = "(double) " + String.valueOf(val);
        this._printDebug(frame + 1, maxLen, valStr, msg);
    }

    private void printDebug(int frame, int maxLen, String val, String msg) {
        String valStr = "(String) " + (val != null ? val : "null");
        this._printDebug(frame + 1, maxLen, valStr, msg);
    }

    private void printDebug(int frame, int maxLen, GeoPoint val, String msg) {
        String valStr = "(GeoPoint) " + (val != null ? "\"" + val.toString() + "\"" : "null");
        this._printDebug(frame + 1, maxLen, valStr, msg);
    }

    private void printDebug_source(int frame) {
        String frameStr = Print._getStackFrame(frame + 1);
        StringBuffer sb = new StringBuffer();
        sb.append("[PayloadDebug:" + frameStr + "] ");
        sb.append("S=0x");
        StringTools.toHexString(this._payloadBytes(), sb);
        Print.sysPrintln(sb.toString(), new Object[0]);
    }
}

