/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.Vector;
import org.opengts.util.Print;

public class OrderedSet<K>
implements Set<K>,
List<K>,
Cloneable {
    protected static final int ENTRY_ADDED = 1;
    protected static final int ENTRY_REMOVED = 2;
    private List<K> elements = null;
    private boolean retainOriginalValue = false;
    private List<ChangeListener> changeListeners = null;
    private int addChangeCount = 0;
    private int removeChangeCount = 0;

    public OrderedSet() {
    }

    public OrderedSet(boolean retainOriginalValue) {
        this.setRetainOriginalValue(retainOriginalValue);
    }

    public OrderedSet(Collection<? extends K> c, boolean retainOriginalValue) {
        this(retainOriginalValue);
        this.addAll(c);
    }

    public OrderedSet(Collection<? extends K> c) {
        this(c, false);
    }

    public OrderedSet(K[] a, boolean retainOriginalValue) {
        this(retainOriginalValue);
        this.addAll(a);
    }

    public OrderedSet(K[] a) {
        this(a, false);
    }

    public OrderedSet(OrderedSet<K> os) {
        this.setRetainOriginalValue(os.getRetainOriginalValue());
        this.getBackingList().addAll(os.getBackingList());
    }

    public Object clone() {
        return new OrderedSet<K>(this);
    }

    protected List<ChangeListener> getChangeListeners(boolean create) {
        if (this.changeListeners == null && create) {
            this.changeListeners = new Vector<ChangeListener>();
        }
        return this.changeListeners;
    }

    protected boolean hasChangeListeners() {
        return this.getChangeListeners(false) != null;
    }

    public void addChangeListener(ChangeListener cl) {
        List<ChangeListener> listeners;
        if (cl != null && !(listeners = this.getChangeListeners(true)).contains(cl)) {
            listeners.add(cl);
        }
    }

    public void removeChangeListener(ChangeListener cl) {
        List<ChangeListener> listeners;
        if (cl != null && (listeners = this.getChangeListeners(false)) != null) {
            listeners.remove(cl);
        }
    }

    protected void notifyChangeListeners(int action, Object obj) {
        List<ChangeListener> listeners = this.getChangeListeners(false);
        if (listeners != null) {
            for (ChangeListener cl : listeners) {
                if (action == 1) {
                    cl.entryAdded(this, obj);
                    ++this.addChangeCount;
                    continue;
                }
                if (action == 2) {
                    cl.entryRemoved(this, obj);
                    ++this.removeChangeCount;
                    continue;
                }
                Print.logError("Unrecognized action: " + action, new Object[0]);
            }
        }
    }

    protected List<K> getBackingList() {
        if (this.elements == null) {
            this.elements = new Vector<K>();
        }
        return this.elements;
    }

    public List<K> getList() {
        return this.getBackingList();
    }

    public boolean getRetainOriginalValue() {
        return this.retainOriginalValue;
    }

    public void setRetainOriginalValue(boolean state) {
        this.retainOriginalValue = state;
    }

    @Override
    public K get(int ndx) {
        return this.getBackingList().get(ndx);
    }

    @Override
    public K set(int ndx, K obj) {
        throw new UnsupportedOperationException();
    }

    protected void _add(int ndx, K obj) {
        if (ndx < 0 || ndx >= this.getBackingList().size()) {
            this.getBackingList().add(obj);
        } else {
            this.getBackingList().add(ndx, obj);
        }
        this.notifyChangeListeners(1, obj);
    }

    @Override
    public boolean add(K obj) {
        if (this.getRetainOriginalValue()) {
            boolean contained = this.contains(obj);
            if (!contained) {
                this._add(-1, obj);
            }
            return !contained;
        }
        boolean contained = this.remove(obj);
        this._add(-1, obj);
        return !contained;
    }

    @Override
    public boolean addAll(Collection<? extends K> c) {
        if (c != null && c.size() > 0) {
            Iterator<K> i = c.iterator();
            while (i.hasNext()) {
                this.add(i.next());
            }
            return true;
        }
        return false;
    }

    public boolean addAll(K[] a) {
        if (a != null && a.length > 0) {
            for (int i = 0; i < a.length; ++i) {
                this.add(a[i]);
            }
            return true;
        }
        return false;
    }

    @Override
    public void add(int ndx, K obj) {
        if (this.getRetainOriginalValue()) {
            boolean contained = this.contains(obj);
            if (!contained) {
                this._add(ndx, obj);
            }
        } else {
            boolean contained = this.remove(obj);
            this._add(ndx, obj);
        }
    }

    @Override
    public boolean addAll(int ndx, Collection<? extends K> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean contains(Object obj) {
        return this.getBackingList().contains(obj);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.getBackingList().containsAll(c);
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof OrderedSet) {
            OrderedSet os = (OrderedSet)other;
            List<K> L1 = this.getBackingList();
            List<K> L2 = os.getBackingList();
            boolean eq = ((Object)L1).equals(L2);
            return eq;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return ((Object)this.getBackingList()).hashCode();
    }

    protected boolean _remove(Object obj) {
        if (this.getBackingList().remove(obj)) {
            this.notifyChangeListeners(2, obj);
            return true;
        }
        return false;
    }

    protected boolean _remove(Object obj, Iterator i) {
        i.remove();
        this.notifyChangeListeners(2, obj);
        return true;
    }

    @Override
    public K remove(int ndx) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object obj) {
        return this._remove(obj);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        if (!this.hasChangeListeners()) {
            return this.getBackingList().removeAll(c);
        }
        if (c == this) {
            if (this.size() > 0) {
                this.clear();
                return true;
            }
            return false;
        }
        if (c != null && c.size() > 0) {
            boolean changed = false;
            Iterator<?> i = c.iterator();
            while (i.hasNext()) {
                if (!this.remove(i.next())) continue;
                changed = true;
            }
            return changed;
        }
        return false;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        if (!this.hasChangeListeners()) {
            return this.getBackingList().retainAll(c);
        }
        if (c == this) {
            return false;
        }
        if (c != null && c.size() > 0) {
            boolean changed = false;
            Iterator<K> i = this.getBackingList().iterator();
            while (i.hasNext()) {
                K obj = i.next();
                if (c.contains(obj)) continue;
                this._remove(obj, i);
                changed = true;
            }
            return changed;
        }
        return false;
    }

    @Override
    public void clear() {
        if (!this.hasChangeListeners()) {
            this.getBackingList().clear();
        } else {
            Iterator<K> i = this.getBackingList().iterator();
            while (i.hasNext()) {
                K obj = i.next();
                this._remove(obj, i);
            }
        }
    }

    @Override
    public int size() {
        return this.getBackingList().size();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public int indexOf(Object obj) {
        return this.getBackingList().indexOf(obj);
    }

    @Override
    public int lastIndexOf(Object obj) {
        return this.getBackingList().lastIndexOf(obj);
    }

    @Override
    public Iterator<K> iterator() {
        if (!this.hasChangeListeners()) {
            return this.getBackingList().iterator();
        }
        return new Iterator<K>(){
            private K thisObject = null;
            private Iterator<K> i = OrderedSet.this.getBackingList().iterator();

            @Override
            public boolean hasNext() {
                return this.i.hasNext();
            }

            @Override
            public K next() {
                this.thisObject = this.i.next();
                return this.thisObject;
            }

            @Override
            public void remove() {
                OrderedSet.this._remove(this.thisObject, this.i);
                this.thisObject = null;
            }
        };
    }

    @Override
    public ListIterator<K> listIterator() {
        return this.listIterator(-1);
    }

    @Override
    public ListIterator<K> listIterator(final int ndx) {
        if (!this.hasChangeListeners()) {
            return ndx >= 0 ? this.getBackingList().listIterator(ndx) : this.getBackingList().listIterator();
        }
        return new ListIterator<K>(){
            private K thisObject = null;
            private ListIterator<K> i = ndx >= 0 ? OrderedSet.this.getBackingList().listIterator(ndx) : OrderedSet.this.getBackingList().listIterator();

            @Override
            public boolean hasNext() {
                return this.i.hasNext();
            }

            @Override
            public boolean hasPrevious() {
                return this.i.hasPrevious();
            }

            @Override
            public K next() {
                this.thisObject = this.i.next();
                return this.thisObject;
            }

            @Override
            public int nextIndex() {
                return this.i.nextIndex();
            }

            @Override
            public K previous() {
                this.thisObject = this.i.previous();
                return this.thisObject;
            }

            @Override
            public int previousIndex() {
                return this.i.previousIndex();
            }

            @Override
            public void remove() {
                OrderedSet.this._remove(this.thisObject, this.i);
                this.thisObject = null;
            }

            @Override
            public void add(K obj) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void set(K obj) {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public List<K> subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object[] toArray() {
        return this.getBackingList().toArray(new Object[this.size()]);
    }

    @Override
    public <K> K[] toArray(K[] a) {
        return this.getBackingList().toArray(a);
    }

    public void printContents() {
        int n = 0;
        Iterator<K> i = this.iterator();
        while (i.hasNext()) {
            Print.logInfo("" + n++ + "] " + i.next(), new Object[0]);
        }
    }

    public static class ChangeListenerAdapter
    implements ChangeListener {
        @Override
        public void entryAdded(OrderedSet set, Object obj) {
        }

        @Override
        public void entryRemoved(OrderedSet set, Object obj) {
        }
    }

    public static interface ChangeListener {
        public void entryAdded(OrderedSet var1, Object var2);

        public void entryRemoved(OrderedSet var1, Object var2);
    }
}

