/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.util;

import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.opengts.util.ListTools;
import org.opengts.util.OrderedSet;
import org.opengts.util.Print;

public class OrderedMap<K, V>
extends HashMap<K, V>
implements Map<K, V> {
    private OrderedSet<K> keyOrder = null;
    private Map<String, String> ignoredCaseMap = null;

    public OrderedMap() {
        this.keyOrder = new OrderedSet(true);
    }

    public OrderedMap(boolean retainOriginalValue) {
        this.keyOrder = new OrderedSet(retainOriginalValue);
    }

    public OrderedMap(Map<K, V> map) {
        this();
        this.putAll(map);
    }

    public boolean isIgnoreCase() {
        return this.ignoredCaseMap != null;
    }

    public void setIgnoreCase(boolean ignoreCase) {
        if (ignoreCase) {
            if (this.ignoredCaseMap == null) {
                this.ignoredCaseMap = new HashMap<String, String>();
                for (K key : this.keyOrder) {
                    if (!(key instanceof String)) continue;
                    this.ignoredCaseMap.put(((String)key).toLowerCase(), (String)key);
                }
            }
        } else if (this.ignoredCaseMap != null) {
            this.ignoredCaseMap = null;
        }
    }

    public Object keyCaseFilter(Object key) {
        String k;
        if (this.ignoredCaseMap != null && key instanceof String && (k = this.ignoredCaseMap.get(((String)key).toLowerCase())) != null) {
            return k;
        }
        return key;
    }

    @Override
    public void clear() {
        super.clear();
        this.keyOrder.clear();
        if (this.ignoredCaseMap != null) {
            this.ignoredCaseMap.clear();
        }
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        Set es = super.entrySet();
        HashMap meMap = new HashMap();
        for (Map.Entry me : es) {
            Object key = me.getKey();
            meMap.put(key, me);
        }
        OrderedSet<Map.Entry<Map.Entry, V>> entSet = new OrderedSet<Map.Entry<Map.Entry, V>>();
        for (Object key : this.keyOrder) {
            Map.Entry me = (Map.Entry)meMap.get(key);
            if (me == null) {
                Print.logError("Map.Entry is null!!!", new Object[0]);
            }
            entSet.add(me);
        }
        return entSet;
    }

    @Override
    public Set<K> keySet() {
        return new OrderedSet<K>(this.keyOrder);
    }

    public OrderedSet<K> orderedKeySet() {
        return this.keyOrder;
    }

    public K[] keyArray(Class<K> arrayType) {
        return ListTools.toArray(this.keyOrder, arrayType);
    }

    public Iterator<K> keyIterator() {
        return new Iterator<K>(){
            private Iterator<K> i;
            {
                this.i = OrderedMap.this.keyOrder.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.i.hasNext();
            }

            @Override
            public K next() {
                return this.i.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public void sortKeys(Comparator<K> comp) {
        ListTools.sort(this.keyOrder, comp);
    }

    public Set<V> valueSet() {
        OrderedSet valSet = new OrderedSet();
        Iterator<K> i = this.keyOrder.iterator();
        while (i.hasNext()) {
            valSet.add(super.get(i.next()));
        }
        return valSet;
    }

    public V[] valueArray(Class<V> arrayType) {
        return ListTools.toArray(this.valueSet(), arrayType);
    }

    public Iterator<V> valueIterator() {
        return new Iterator<V>(){
            private Iterator<V> i;
            {
                this.i = OrderedMap.this.values().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.i.hasNext();
            }

            @Override
            public V next() {
                return this.i.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public Collection<V> values() {
        return new ListTools.CollectionProxy<V>(super.values()){

            @Override
            public Iterator<V> iterator() {
                return new Iterator<V>(){
                    private Iterator<K> i;
                    {
                        this.i = OrderedMap.this.keySet().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i.hasNext();
                    }

                    @Override
                    public V next() {
                        return OrderedMap.this.get(this.i.next());
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("'remove' not supported here");
                    }
                };
            }

            @Override
            public Object[] toArray() {
                return ListTools.toList(this.iterator()).toArray();
            }

            @Override
            public <T> T[] toArray(T[] a) {
                return ListTools.toList(this.iterator()).toArray(a);
            }
        };
    }

    public V put(int ndx, K key, V value) {
        if (this.ignoredCaseMap != null && key instanceof String) {
            this.ignoredCaseMap.put(((String)key).toLowerCase(), (String)key);
        }
        this.keyOrder.add(ndx, key);
        return super.put(key, value);
    }

    @Override
    public V put(K key, V value) {
        if (this.ignoredCaseMap != null && key instanceof String) {
            this.ignoredCaseMap.put(((String)key).toLowerCase(), (String)key);
        }
        this.keyOrder.add(key);
        return super.put(key, value);
    }

    public V setProperty(K key, V value) {
        return this.put(key, value);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        if (map != null) {
            for (K key : map.keySet()) {
                V val = map.get(key);
                this.put(key, val);
            }
        }
    }

    public boolean containsKeyIgnoreCase(String key) {
        if (key != null) {
            for (K k : this.keyOrder) {
                if (!(k instanceof String) || !key.equalsIgnoreCase((String)k)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean containsKey(Object key) {
        return super.containsKey(this.keyCaseFilter(key));
    }

    public int indexOfKey(Object key) {
        return this.keyOrder.indexOf(this.keyCaseFilter(key));
    }

    @Override
    public V remove(Object key) {
        Object k = this.keyCaseFilter(key);
        if (this.ignoredCaseMap != null && key instanceof String) {
            this.ignoredCaseMap.remove(((String)key).toLowerCase());
        }
        this.keyOrder.remove(k);
        return super.remove(k);
    }

    @Override
    public V get(Object key) {
        return super.get(this.keyCaseFilter(key));
    }

    public String getProperty(String key, String dft) {
        if (this.containsKey(key)) {
            V val = this.get(key);
            return val != null ? val.toString() : null;
        }
        return dft;
    }

    public String getProperty(String key) {
        return this.getProperty(key, null);
    }

    public K getFirstKey() {
        return this.getKey(0);
    }

    public K getKey(int ndx) {
        return ndx >= 0 && ndx < this.keyOrder.size() ? (K)this.keyOrder.get(ndx) : null;
    }

    public V getFirstValue() {
        return this.getValue(0);
    }

    public V getValue(int ndx) {
        K key = this.getKey(ndx);
        return key != null ? (V)super.get(key) : null;
    }

    public void remove(int ndx) {
        this.remove(this.getKey(ndx));
    }
}

