/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.util;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.lang.management.OperatingSystemMXBean;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Vector;
import org.opengts.util.DateTime;
import org.opengts.util.FileTools;
import org.opengts.util.ListTools;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;
import org.opengts.util.StringTools;
import sun.reflect.Reflection;

public class OSTools {
    private static final Object LockObject = new Object();
    private static final Object MemoryLock = new Object();
    private static final Object DiskLock = new Object();
    private static final Object CpuLock = new Object();
    private static final int OS_INITIALIZE = -1;
    public static final int OS_TYPE_MASK = 0xFFFF00;
    public static final int OS_SUBTYPE_MASK = 255;
    public static final int OS_UNKNOWN = 0;
    public static final int OS_LINUX = 65792;
    public static final int OS_LINUX_FEDORA = 1;
    public static final int OS_LINUX_CENTOS = 2;
    public static final int OS_LINUX_UBUNTU = 3;
    public static final int OS_LINUX_DEBIAN = 4;
    public static final int OS_UNIX = 66048;
    public static final int OS_UNIX_SOLARIS = 1;
    public static final int OS_UNIX_SUNOS = 2;
    public static final int OS_UNIX_AIX = 4;
    public static final int OS_UNIX_DIGITAL = 5;
    public static final int OS_UNIX_HPUX = 6;
    public static final int OS_UNIX_IRIX = 7;
    public static final int OS_BSD = 66304;
    public static final int OS_BSD_FREEBSD = 1;
    public static final int OS_MACOS = 66816;
    public static final int OS_MACOS_X = 1;
    public static final int OS_WINDOWS = 1792;
    public static final int OS_WINDOWS_9X = 1;
    public static final int OS_WINDOWS_XP = 2;
    public static final int OS_WINDOWS_VISTA = 3;
    public static final int OS_WINDOWS_7 = 4;
    public static final int OS_WINDOWS_CE = 16;
    public static final int OS_WINDOWS_NT = 17;
    public static final int OS_WINDOWS_2000 = 18;
    public static final int OS_WINDOWS_2003 = 19;
    public static final int OS_WINDOWS_CYGWIN = 192;
    private static int OSType = -1;
    public static final long K_BYTES = 1024L;
    public static final long M_BYTES = 0x100000L;
    public static final long G_BYTES = 0x40000000L;
    private static Object memoryCheckLock = new Object();
    private static long firstMem_maxB = 0L;
    private static long firstMem_usedB = 0L;
    private static long firstMem_time = 0L;
    private static long memoryCheckCount = 0L;
    private static long averMem_usedB = 0L;
    private static long lastMem_usedB = 0L;
    public static final String PROPERTY_JAVA_HOME = "java.home";
    public static final String PROPERTY_JAVA_VENDOR = "java.vendor";
    public static final String PROPERTY_JAVA_SPECIFICATION_VERSION = "java.specification.version";
    private static final String[] ARG_WAIT = new String[]{"wait", "sleep"};

    public static int getOSType() {
        if (OSType == -1) {
            String osName = System.getProperty("os.name").toLowerCase();
            if (osName.startsWith("windows")) {
                OSType = 1792;
                if (osName.startsWith("windows xp")) {
                    OSType |= 2;
                } else if (osName.startsWith("windows 9") || osName.startsWith("windows m")) {
                    OSType |= 1;
                } else if (osName.startsWith("windows 7")) {
                    OSType |= 4;
                } else if (osName.startsWith("windows vista")) {
                    OSType |= 3;
                } else if (osName.startsWith("windows nt")) {
                    OSType |= 0x11;
                } else if (osName.startsWith("windows 2000")) {
                    OSType |= 0x12;
                } else if (osName.startsWith("windows 2003")) {
                    OSType |= 0x13;
                } else if (osName.startsWith("windows ce")) {
                    OSType |= 0x10;
                }
            } else if (osName.startsWith("mac")) {
                OSType = 66816;
                if (osName.startsWith("mac os x")) {
                    OSType |= 1;
                }
            } else {
                OSType = osName.startsWith("linux") ? 65792 : (osName.startsWith("solaris") ? 66049 : (osName.startsWith("sunos") ? 66050 : (osName.startsWith("hp ux") || osName.startsWith("hp-ux") ? 66054 : (osName.startsWith("digital unix") ? 66053 : (osName.startsWith("aix") ? 66052 : (osName.startsWith("irix") ? 66055 : (osName.startsWith("freebsd") ? 66305 : (osName.indexOf("unix") >= 0 ? 66048 : (osName.indexOf("linux") >= 0 ? 65792 : (File.separatorChar == '/' ? 65792 : 0))))))))));
            }
        }
        return OSType;
    }

    public static String getOSTypeName(int type, boolean inclSubtype) {
        switch (type & 0xFFFF00) {
            case 65792: {
                if (inclSubtype) {
                    switch (type & 0xFF) {
                        case 1: {
                            return "LINUX_FEDORA";
                        }
                        case 2: {
                            return "LINUX_CENTOS";
                        }
                        case 3: {
                            return "LINUX_CENTOS";
                        }
                        case 4: {
                            return "LINUX_DEBIAN";
                        }
                    }
                    return "LINUX";
                }
                return "LINUX";
            }
            case 66048: {
                if (inclSubtype) {
                    switch (type & 0xFF) {
                        case 1: {
                            return "UNIX_SOLARIS";
                        }
                        case 2: {
                            return "UNIX_SUNOS";
                        }
                        case 4: {
                            return "UNIX_AIX";
                        }
                        case 5: {
                            return "UNIX_DIGITAL";
                        }
                        case 6: {
                            return "UNIX_HPUX";
                        }
                        case 7: {
                            return "UNIX_IRIX";
                        }
                    }
                    return "UNIX";
                }
                return "UNIX";
            }
            case 66304: {
                if (inclSubtype) {
                    switch (type & 0xFF) {
                        case 1: {
                            return "BSD_FREEBSD";
                        }
                    }
                    return "BSD";
                }
                return "BSD";
            }
            case 66816: {
                if (inclSubtype) {
                    switch (type & 0xFF) {
                        case 1: {
                            return "MACOS_X";
                        }
                    }
                    return "MACOS";
                }
                return "MACOS";
            }
            case 1792: {
                if (inclSubtype) {
                    switch (type & 0xFF) {
                        case 1: {
                            return "WINDOWS_9X";
                        }
                        case 2: {
                            return "WINDOWS_XP";
                        }
                        case 3: {
                            return "WINDOWS_VISTA";
                        }
                        case 4: {
                            return "WINDOWS_7";
                        }
                        case 18: {
                            return "WINDOWS_2000";
                        }
                        case 17: {
                            return "WINDOWS_NT";
                        }
                    }
                    return "WINDOWS";
                }
                return "WINDOWS";
            }
        }
        return "UNKNOWN";
    }

    public static boolean isOSType(int type) {
        int osType = OSTools.getOSType();
        return (osType & 0xFFFF00) == type;
    }

    public static boolean isOSType(int type, int subType) {
        int osType = OSTools.getOSType();
        if ((osType & 0xFFFF00) != type) {
            return false;
        }
        if (subType <= 0) {
            return true;
        }
        return (osType & 0xFF & subType) != 0;
    }

    public static boolean isUnknown() {
        return OSTools.getOSType() == 0;
    }

    public static boolean isWindows() {
        return OSTools.isOSType(1792);
    }

    public static boolean isWindowsXP() {
        return OSTools.isOSType(1792, 2);
    }

    public static boolean isWindows9X() {
        return OSTools.isOSType(1792, 1);
    }

    public static boolean isLinux() {
        return OSTools.isOSType(65792) || OSTools.isOSType(66048);
    }

    public static boolean isMacOS() {
        return OSTools.isOSType(66816);
    }

    public static boolean isMacOSX() {
        return OSTools.isOSType(66816, 1);
    }

    public static String getHostName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException uhe) {
            return "";
        }
    }

    public static String getHostIP() {
        try {
            String ip = StringTools.trim(InetAddress.getByName(InetAddress.getLocalHost().getHostName()));
            int h = ip.indexOf("/");
            return h >= 0 ? ip.substring(h + 1) : ip;
        }
        catch (UnknownHostException uhe) {
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CpuUsage getCpuUsage(CpuUsage cpu) {
        Object object = CpuLock;
        synchronized (object) {
            try {
                OperatingSystemMXBean opSysMXBean = ManagementFactory.getOperatingSystemMXBean();
                int numCores = Runtime.getRuntime().availableProcessors();
                Method pcl = opSysMXBean.getClass().getDeclaredMethod("getProcessCpuLoad", new Class[0]);
                pcl.setAccessible(true);
                double procCpuLoad = StringTools.parseDouble(pcl.invoke((Object)opSysMXBean, new Object[0]), 0.0);
                Method pct = opSysMXBean.getClass().getDeclaredMethod("getProcessCpuTime", new Class[0]);
                pct.setAccessible(true);
                long procCpuTimeNS = StringTools.parseLong(pct.invoke((Object)opSysMXBean, new Object[0]), 0L);
                Method scl = opSysMXBean.getClass().getDeclaredMethod("getSystemCpuLoad", new Class[0]);
                scl.setAccessible(true);
                double sysCpuLoad = StringTools.parseDouble(scl.invoke((Object)opSysMXBean, new Object[0]), 0.0);
                Method scla = opSysMXBean.getClass().getDeclaredMethod("getSystemLoadAverage", new Class[0]);
                scla.setAccessible(true);
                double sysCpuLoadAvg = StringTools.parseDouble(scla.invoke((Object)opSysMXBean, new Object[0]), 0.0);
                if (cpu == null) {
                    cpu = new CpuUsage();
                }
                cpu.setAvailableProcessors(numCores);
                cpu.setProcessCpuLoad(procCpuLoad);
                cpu.setProcessCpuTimeNS(procCpuTimeNS);
                cpu.setSystemCpuLoad(sysCpuLoad);
                cpu.setSystemLoadAverage(sysCpuLoadAvg);
            }
            catch (Throwable th) {
                Print.logError("Unable to obtain system cpu usage- " + th, new Object[0]);
                cpu = null;
            }
        }
        return cpu;
    }

    public static String getCpuUsageString(boolean longFmt) {
        CpuUsage cpu = OSTools.getCpuUsage(null);
        if (cpu != null) {
            return cpu.toString(longFmt);
        }
        return longFmt ? "Cpu: n/a" : "";
    }

    public static String getCpuUsageString() {
        return OSTools.getCpuUsageString(true);
    }

    public static String getMemoryUnits(long D) {
        if (D == 1L) {
            return "bytes";
        }
        if (D == 1000L) {
            return "(Kb)";
        }
        if (D == 1024L) {
            return "Kb";
        }
        if (D == 1000000L) {
            return "(Mb)";
        }
        if (D == 0x100000L) {
            return "Mb";
        }
        if (D == 1000000000L) {
            return "(Gb)";
        }
        if (D == 0x40000000L) {
            return "Gb";
        }
        return "(" + D + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MemoryUsage getSystemMemoryUsage(MemoryUsage mu) {
        Object object = MemoryLock;
        synchronized (object) {
            try {
                OperatingSystemMXBean opSysMXBean = ManagementFactory.getOperatingSystemMXBean();
                Method tpms = opSysMXBean.getClass().getDeclaredMethod("getTotalPhysicalMemorySize", new Class[0]);
                tpms.setAccessible(true);
                long totalB = StringTools.parseLong(tpms.invoke((Object)opSysMXBean, new Object[0]), 0L);
                Method fpms = opSysMXBean.getClass().getDeclaredMethod("getFreePhysicalMemorySize", new Class[0]);
                fpms.setAccessible(true);
                long freeB = StringTools.parseLong(fpms.invoke((Object)opSysMXBean, new Object[0]), 0L);
                if (totalB >= 0L || freeB >= 0L) {
                    if (mu == null) {
                        mu = new MemoryUsage();
                    }
                    mu.set(totalB, freeB);
                } else {
                    Print.logWarn("Setting MemoryUsage to null", new Object[0]);
                    mu = null;
                }
            }
            catch (Throwable th) {
                Print.logError("Unable to obtain system memory usage - " + th, new Object[0]);
                mu = null;
            }
        }
        return mu;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DiskUsage getSystemDiskUsage(File dir, DiskUsage du) {
        File partitionDir = null;
        if (dir != null && dir.isDirectory()) {
            partitionDir = dir;
        } else {
            partitionDir = RTConfig.getLoadedConfigDir();
            if (partitionDir == null) {
                return null;
            }
        }
        Object object = DiskLock;
        synchronized (object) {
            try {
                long totalB = partitionDir.getTotalSpace();
                long freeB = partitionDir.getUsableSpace();
                if (totalB >= 0L || freeB >= 0L) {
                    if (du == null) {
                        du = new DiskUsage();
                    }
                    du.set(totalB, freeB);
                } else {
                    Print.logWarn("Setting MemoryUsage to null", new Object[0]);
                    du = null;
                }
            }
            catch (Throwable th) {
                Print.logError("Unable to obtain system disk usage - " + th, new Object[0]);
                du = null;
            }
        }
        return du;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MemoryUsage getMemoryUsage(MemoryUsage mu) {
        Runtime rt = Runtime.getRuntime();
        Object object = MemoryLock;
        synchronized (object) {
            long max = rt.maxMemory();
            long total = rt.totalMemory();
            long free = rt.freeMemory();
            if (max >= 0L || total >= 0L || free >= 0L) {
                if (mu == null) {
                    mu = new MemoryUsage();
                }
                mu.set(max, total, free);
            } else {
                Print.logWarn("Setting MemoryUsage to null", new Object[0]);
                mu = null;
            }
        }
        return mu;
    }

    public static String getMemoryUsageStringMb() {
        return OSTools.getMemoryUsageStringMb(true);
    }

    public static String getMemoryUsageStringMb(boolean longFmt) {
        MemoryUsage mem = OSTools.getMemoryUsage(null);
        return mem != null ? mem.toString(0x100000L, longFmt) : "Memory: n/a";
    }

    public static void printMemoryUsage() {
        Print.logInfo(OSTools.getMemoryUsageStringMb(), new Object[0]);
    }

    public static void printMemoryUsageMXBean() {
        MemoryMXBean memory = ManagementFactory.getMemoryMXBean();
        java.lang.management.MemoryUsage heapUsage = memory.getHeapMemoryUsage();
        java.lang.management.MemoryUsage nonHeapUsage = memory.getNonHeapMemoryUsage();
        Print.logInfo("Heap Memory Usage    : " + OSTools._formatMemoryUsage(heapUsage), new Object[0]);
        Print.logInfo("Non-Heap Memory Usage: " + OSTools._formatMemoryUsage(nonHeapUsage), new Object[0]);
        List<MemoryPoolMXBean> memPool = ManagementFactory.getMemoryPoolMXBeans();
        for (MemoryPoolMXBean mp : memPool) {
            String name = mp.getName();
            MemoryType type = mp.getType();
            java.lang.management.MemoryUsage estUsage = mp.getUsage();
            java.lang.management.MemoryUsage peakUsage = mp.getPeakUsage();
            java.lang.management.MemoryUsage collUsage = mp.getCollectionUsage();
            Print.logInfo("Pool Usage: " + name + " [" + (Object)((Object)type) + "]", new Object[0]);
            Print.logInfo("  Estimate  : " + OSTools._formatMemoryUsage(estUsage), new Object[0]);
            Print.logInfo("  Peak      : " + OSTools._formatMemoryUsage(peakUsage), new Object[0]);
            Print.logInfo("  Collection: " + OSTools._formatMemoryUsage(collUsage), new Object[0]);
        }
    }

    private static String _formatMemoryUsage(java.lang.management.MemoryUsage u) {
        if (u != null) {
            long comm = u.getCommitted() / 1024L;
            long init = u.getInit() / 1024L;
            long max = u.getMax() / 1024L;
            long used = u.getUsed() / 1024L;
            StringBuffer sb = new StringBuffer();
            sb.append("[K]");
            sb.append(" Committed=").append(comm);
            sb.append(" Init=").append(init);
            sb.append(" Max=").append(max);
            sb.append(" Used=").append(used);
            return sb.toString();
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkMemoryUsage(boolean reset) {
        long usedB;
        long maxB;
        if (!RTConfig.getBoolean("OSTools.memoryCheckEnabled")) {
            return;
        }
        long nowTime = DateTime.getCurrentTimeSec();
        long averUsedB = 0L;
        long firstUsedB = 0L;
        long firstTime = 0L;
        long count = 0L;
        Runtime rt = Runtime.getRuntime();
        Object object = memoryCheckLock;
        synchronized (object) {
            if (reset) {
                firstMem_maxB = 0L;
                firstMem_usedB = 0L;
                firstMem_time = 0L;
                memoryCheckCount = 0L;
                averMem_usedB = 0L;
                lastMem_usedB = 0L;
            }
            maxB = rt.maxMemory();
            usedB = rt.totalMemory() - rt.freeMemory();
            if (usedB <= 0L) {
                Print.logWarn("Memory usage <= 0? " + usedB + " bytes", new Object[0]);
            } else {
                Print.sysPrintln("UsedB=" + usedB + ", lastUsedB=" + lastMem_usedB, new Object[0]);
                if (usedB < lastMem_usedB) {
                    if (firstMem_time <= 0L || usedB < firstMem_usedB) {
                        firstMem_maxB = maxB;
                        firstMem_usedB = usedB;
                        firstMem_time = nowTime;
                        memoryCheckCount = 0L;
                        averMem_usedB = 0L;
                    }
                    firstUsedB = firstMem_usedB;
                    firstTime = firstMem_time;
                    if (averMem_usedB <= 0L) {
                        averMem_usedB = usedB;
                    } else if (usedB <= averMem_usedB) {
                        averMem_usedB = usedB;
                    } else {
                        double trendWeight = RTConfig.getDouble("OSTools.memoryTrendWeight");
                        averMem_usedB += (long)((double)(usedB - averMem_usedB) * trendWeight);
                    }
                    averUsedB = averMem_usedB;
                    count = ++memoryCheckCount;
                }
                lastMem_usedB = usedB;
            }
        }
        if (count <= 0L) {
            return;
        }
        double deltaHours = (double)(nowTime - firstTime) / 3600.0;
        long deltaUsedB = averUsedB - firstUsedB;
        long grwBPH = deltaHours > 0.0 ? (long)((double)deltaUsedB / deltaHours) : 0L;
        long grwBPC = deltaUsedB / count;
        long maxK = maxB / 1024L;
        long usedK = usedB / 1024L;
        long averK = averUsedB / 1024L;
        String s = "[" + count + "] Memory-K max " + maxK + ", used " + usedK + " (trend " + averK + " K " + grwBPH + " b/h " + grwBPC + " b/c)";
        double maxPercent = RTConfig.getDouble("OSTools.memoryUsageWarning");
        if (usedB >= (long)((double)maxB * maxPercent)) {
            Print.logWarn("**** More than " + maxPercent * 100.0 + "% of max memory has been used!! ****", new Object[0]);
            Print.logWarn(s, new Object[0]);
        } else {
            Print.logInfo(s, new Object[0]);
        }
    }

    public static boolean isBrokenToFront() {
        return OSTools.isWindows();
    }

    public static boolean isSunJava() {
        String javaVendVal = System.getProperty(PROPERTY_JAVA_VENDOR);
        return javaVendVal != null && (javaVendVal.indexOf("Sun Microsystems") >= 0 || javaVendVal.indexOf("Oracle") >= 0 || javaVendVal.indexOf("Apple") >= 0);
    }

    private static Class _getCallerClass(int frame) throws Throwable {
        return Reflection.getCallerClass((int)(frame + 1));
    }

    public static Class getCallerClass(int frame) {
        try {
            Class clz = OSTools._getCallerClass(frame + 1);
            return clz;
        }
        catch (Throwable th) {
            Print.logException("Sun Microsystems version of Java is not in use", th);
            return null;
        }
    }

    public static boolean hasGetCallerClass() {
        try {
            OSTools._getCallerClass(0);
            return true;
        }
        catch (Throwable th) {
            return false;
        }
    }

    public static void printCallerClasses() {
        try {
            int i = 0;
            while (true) {
                Class clz = OSTools._getCallerClass(i);
                Print.logInfo("" + i + "] class " + StringTools.className(clz), new Object[0]);
                if (clz != null) {
                    ++i;
                    continue;
                }
                break;
            }
        }
        catch (Throwable th) {
            Print.logException("Sun Microsystems version of Java is not in use", th);
        }
    }

    public static int getProcessID() {
        if (OSTools.isSunJava()) {
            try {
                String n = ManagementFactory.getRuntimeMXBean().getName();
                int pid = StringTools.parseInt(n, -1);
                return pid;
            }
            catch (Throwable th) {
                Print.logException("Unable to obtain Process ID", th);
                return -1;
            }
        }
        return -1;
    }

    private static int _getProcessID() {
        try {
            String line;
            String[] cmd = new String[]{"bash", "-c", "echo $PPID"};
            Process ppidExec = Runtime.getRuntime().exec(cmd);
            BufferedReader ppidReader = new BufferedReader(new InputStreamReader(ppidExec.getInputStream()));
            StringBuffer sb = new StringBuffer();
            while ((line = ppidReader.readLine()) != null) {
                sb.append(StringTools.trim(line));
            }
            int pid = StringTools.parseInt(sb.toString(), -1);
            int exitVal = ppidExec.waitFor();
            Print.logDebug("Exit value: %d [%s]", exitVal, sb.toString());
            ppidReader.close();
            return pid;
        }
        catch (Throwable th) {
            Print.logException("Unable to obtain PID", th);
            return -1;
        }
    }

    public static boolean writePidFile(File pidFile, boolean overwrite) {
        int pid;
        if (pidFile == null) {
            return false;
        }
        if (pidFile.exists()) {
            if (!overwrite) {
                return false;
            }
            if (!pidFile.isFile()) {
                return false;
            }
            if (!FileTools.getExtension(pidFile).equalsIgnoreCase("pid")) {
                return false;
            }
        }
        if ((pid = OSTools.getProcessID()) <= 0) {
            return false;
        }
        try {
            byte[] pidB = (String.valueOf(pid) + "\n").getBytes();
            boolean ok = FileTools.writeFile(pidB, pidFile, false);
            return ok;
        }
        catch (IOException ioe) {
            Print.logError("Unable to write pid file: " + ioe, new Object[0]);
            return false;
        }
    }

    public static String[] createJavaCommand(String[] classpath, String className, String[] args) {
        Vector<String> execCmd = new Vector<String>();
        execCmd.add(System.getProperty(PROPERTY_JAVA_HOME) + File.separator + "bin" + File.separator + "java");
        execCmd.add("-classpath");
        if (ListTools.isEmpty(classpath)) {
            execCmd.add(System.getProperty("java.class.path"));
        } else {
            StringBuffer sb = new StringBuffer();
            for (String p : classpath) {
                if (sb.length() > 0) {
                    sb.append(File.pathSeparator);
                }
                sb.append(p);
            }
            execCmd.add(sb.toString());
        }
        if (StringTools.endsWithIgnoreCase(className, ".jar")) {
            execCmd.add("-jar");
            execCmd.add(className);
        } else if (!StringTools.isBlank(className)) {
            execCmd.add(className);
        } else {
            execCmd.add("Main");
        }
        if (!ListTools.isEmpty(args)) {
            for (String a : args) {
                execCmd.add(a);
            }
        }
        return execCmd.toArray(new String[execCmd.size()]);
    }

    private static boolean _readOutput(InputStream in, StringBuffer sb) throws IOException {
        int avail;
        boolean didRead = false;
        while ((avail = in.available()) > 0) {
            didRead = true;
            while (avail > 0) {
                int b = in.read();
                if (b < 0) {
                    return didRead;
                }
                sb.append((char)b);
                --avail;
            }
        }
        return didRead;
    }

    public static int exec(String[] cmdArgs, StringBuffer outSB, StringBuffer errSB) {
        int exitStat = -1;
        if (!ListTools.isEmpty(cmdArgs)) {
            Process process = null;
            try {
                if (cmdArgs.length > 1) {
                    process = Runtime.getRuntime().exec(cmdArgs);
                } else {
                    String cmd = StringTools.join(cmdArgs, ' ');
                    process = Runtime.getRuntime().exec(cmd);
                }
                BufferedInputStream stdout = new BufferedInputStream(process.getInputStream());
                StringBuffer stdoutSB = outSB != null ? outSB : new StringBuffer();
                BufferedInputStream stderr = new BufferedInputStream(process.getErrorStream());
                StringBuffer stderrSB = errSB != null ? errSB : new StringBuffer();
                while (true) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (Throwable th) {
                        // empty catch block
                    }
                    boolean didReadOut = OSTools._readOutput(stdout, stdoutSB);
                    boolean didReadErr = OSTools._readOutput(stderr, stderrSB);
                    if (didReadOut || didReadErr) continue;
                    try {
                        process.exitValue();
                    }
                    catch (Throwable th) {
                        continue;
                    }
                    break;
                }
                while (true) {
                    try {
                        process.waitFor();
                        return process.exitValue();
                    }
                    catch (InterruptedException ie) {
                        continue;
                    }
                    break;
                }
            }
            catch (Throwable th) {
                Print.logException("Job process failed", th);
                if (process != null) {
                    process.destroy();
                }
                return -1;
            }
        }
        return -1;
    }

    public static boolean instanceOf(Object obj, String className) {
        if (obj == null || StringTools.isBlank(className)) {
            return false;
        }
        return StringTools.className(obj).equals(className);
    }

    public static boolean sleepMS(long ms) {
        if (ms < 0L) {
            return false;
        }
        if (ms == 0L) {
            return true;
        }
        try {
            Thread.sleep(ms);
            return true;
        }
        catch (Throwable th) {
            return false;
        }
    }

    public static boolean sleepSec(long sec) {
        if (sec < 0L) {
            return false;
        }
        if (sec == 0L) {
            return true;
        }
        try {
            Thread.sleep(sec * 1000L);
            return true;
        }
        catch (Throwable th) {
            return false;
        }
    }

    public static void main(String[] argv) {
        MemoryUsage sysMem;
        RTConfig.setCommandLineArgs(argv);
        RTConfig.setBoolean("log.file.enable", false);
        Print.setAllOutputToStdout(true);
        Print.sysPrintln("", new Object[0]);
        Print.sysPrintln("Host ...", new Object[0]);
        Print.sysPrintln("Host Name   : " + OSTools.getHostName(), new Object[0]);
        Print.sysPrintln("Host IP     : " + OSTools.getHostIP(), new Object[0]);
        Print.sysPrintln("", new Object[0]);
        Print.sysPrintln("OS Type ...", new Object[0]);
        Print.sysPrintln("Is Windows  : " + OSTools.isWindows(), new Object[0]);
        Print.sysPrintln("Is Windows9X: " + OSTools.isWindows9X(), new Object[0]);
        Print.sysPrintln("Is WindowsXP: " + OSTools.isWindowsXP(), new Object[0]);
        Print.sysPrintln("Is Linux    : " + OSTools.isLinux(), new Object[0]);
        Print.sysPrintln("Is MacOS    : " + OSTools.isMacOS(), new Object[0]);
        Print.sysPrintln("Is MacOSX   : " + OSTools.isMacOSX(), new Object[0]);
        Print.sysPrintln("", new Object[0]);
        Print.sysPrintln("PID ...", new Object[0]);
        Print.sysPrintln("PID #1      : " + OSTools.getProcessID() + " (using Java ManagementFactory)", new Object[0]);
        Print.sysPrintln("PID #2      : " + OSTools._getProcessID() + " (using subprocess 'echo $PPID')", new Object[0]);
        Print.sysPrintln("", new Object[0]);
        Print.sysPrintln("Memory (K=1024) ...", new Object[0]);
        MemoryUsage jvmMem = OSTools.getMemoryUsage(null);
        if (jvmMem != null) {
            Print.sysPrintln("JVM Memory:", new Object[0]);
            Print.sysPrintln("   Max   : " + StringTools.rightAlign(StringTools.format(jvmMem.getMaximum_Mb(), "0.000"), 8) + " Mb", new Object[0]);
            Print.sysPrintln("   Total : " + StringTools.rightAlign(StringTools.format(jvmMem.getTotal_Mb(), "0.000"), 8) + " Mb", new Object[0]);
            Print.sysPrintln("   Free  : " + StringTools.rightAlign(StringTools.format(jvmMem.getFree_Mb(), "0.000"), 8) + " Mb", new Object[0]);
        }
        if ((sysMem = OSTools.getSystemMemoryUsage(null)) != null) {
            Print.sysPrintln("System Memoy:", new Object[0]);
            Print.sysPrintln("   Total : " + StringTools.rightAlign(StringTools.format(sysMem.getTotal_Mb(), "0.000"), 8) + " Mb", new Object[0]);
            Print.sysPrintln("   Free  : " + StringTools.rightAlign(StringTools.format(sysMem.getFree_Mb(), "0.000"), 8) + " Mb", new Object[0]);
        }
        RTConfig.setBoolean("OSTools.memoryCheckEnabled", true);
        lastMem_usedB = 99999999L;
        Print.sysPrintln("MemoryCheck : " + RTConfig.getBoolean("OSTools.memoryCheckEnabled"), new Object[0]);
        OSTools.checkMemoryUsage(false);
        Print.sysPrintln("", new Object[0]);
        if (RTConfig.hasProperty(ARG_WAIT)) {
            long MS = RTConfig.getLong(ARG_WAIT, 0L) * 1000L;
            Print.sysPrintln("Sleeping for " + MS + " milliseconds before terminating ...", new Object[0]);
            try {
                Thread.sleep(MS);
            }
            catch (Throwable th) {
                // empty catch block
            }
        }
    }

    public static class DiskUsage
    extends MemoryUsage {
        public DiskUsage() {
        }

        public DiskUsage(long max, long total, long free) {
            super(max, total, free);
        }

        public DiskUsage(long total, long free) {
            super(total, free);
        }

        @Override
        public String getName() {
            return "Disk";
        }
    }

    public static class MemoryUsage {
        private long memMax = 0L;
        private long memTotal = 0L;
        private long memFree = 0L;

        public MemoryUsage() {
        }

        public MemoryUsage(long max, long total, long free) {
            this.set(max, total, free);
        }

        public MemoryUsage(long total, long free) {
            this.set(total, free);
        }

        public String getName() {
            return "Memory";
        }

        public void set(long max, long total, long free) {
            this.memMax = max;
            this.memTotal = total;
            this.memFree = free;
        }

        public void set(long total, long free) {
            this.set(total, total, free);
        }

        public long getMaximum() {
            return this.memMax;
        }

        public long getTotal() {
            return this.memTotal;
        }

        public long getFree() {
            return this.memFree;
        }

        public long getUsed() {
            if (this.memTotal >= 0L && this.memFree >= 0L) {
                return this.memTotal - this.memFree;
            }
            return -1L;
        }

        public double getMaximum(double D) {
            double M = this.memMax;
            return M >= 0.0 && D > 0.0 ? M / D : -1.0;
        }

        public double getTotal(double D) {
            double M = this.memTotal;
            return M >= 0.0 && D > 0.0 ? M / D : -1.0;
        }

        public double getFree(double D) {
            double M = this.memFree;
            return M >= 0.0 && D > 0.0 ? M / D : -1.0;
        }

        public double getUsed(double D) {
            double T = this.getTotal(D);
            double F = this.getFree(D);
            return T >= 0.0 && T >= F ? T - F : -1.0;
        }

        public double getMaximum(long D) {
            return this.getMaximum((double)D);
        }

        public double getTotal(long D) {
            return this.getTotal((double)D);
        }

        public double getFree(long D) {
            return this.getFree((double)D);
        }

        public double getUsed(long D) {
            return this.getUsed((double)D);
        }

        public double getMaximum_Kb() {
            return this.getMaximum(1024L);
        }

        public double getTotal_Kb() {
            return this.getTotal(1024L);
        }

        public double getFree_Kb() {
            return this.getFree(1024L);
        }

        public double getUsed_Kb() {
            return this.getUsed(1024L);
        }

        public double getMaximum_Mb() {
            return this.getMaximum(0x100000L);
        }

        public double getTotal_Mb() {
            return this.getTotal(0x100000L);
        }

        public double getFree_Mb() {
            return this.getFree(0x100000L);
        }

        public double getUsed_Mb() {
            return this.getUsed(0x100000L);
        }

        public double getMaximum_Gb() {
            return this.getMaximum(0x40000000L);
        }

        public double getTotal_Gb() {
            return this.getTotal(0x40000000L);
        }

        public double getFree_Gb() {
            return this.getFree(0x40000000L);
        }

        public double getUsed_Gb() {
            return this.getUsed(0x40000000L);
        }

        public double getUtilization() {
            long max = Math.max(this.getMaximum(), this.getTotal());
            long used = this.getUsed();
            if (max > 0L && used >= 0L) {
                return (double)used / (double)max;
            }
            return -1.0;
        }

        public double getUsage() {
            return this.getUtilization();
        }

        public String getUsagePercent() {
            return Math.round(this.getUtilization() * 100.0) + "%";
        }

        public int getTotalFieldLength(long D) {
            long val = (long)Math.ceil(this.getTotal(D));
            int digLen = String.valueOf(val).length();
            return digLen;
        }

        public int getTotalFieldLength(long D, MemoryUsage mainMu) {
            return mainMu != null ? mainMu.getTotalFieldLength(D) : this.getTotalFieldLength(D);
        }

        public String toString(long D, boolean longFmt) {
            String Used;
            StringBuffer sb = new StringBuffer();
            String fmt = longFmt ? "0.0" : "0";
            String Max = D == 1L ? String.valueOf(this.getMaximum()) : StringTools.format(this.getMaximum(D), fmt);
            String Total = D == 1L ? String.valueOf(this.getTotal()) : StringTools.format(this.getTotal(D), fmt);
            String Free = D == 1L ? String.valueOf(this.getFree()) : StringTools.format(this.getFree(D), fmt);
            String string = Used = D == 1L ? String.valueOf(this.getUsed()) : StringTools.format(this.getUsed(D), fmt);
            if (longFmt) {
                sb.append(this.getName());
                sb.append("-");
                sb.append(OSTools.getMemoryUnits(D)).append(": ");
            }
            sb.append("Max=").append(Max).append(", ");
            sb.append("Total=").append(Total).append(", ");
            sb.append("Free=").append(Free).append(", ");
            sb.append("Used=").append(Used).append(" ");
            sb.append("[").append(this.getUsagePercent()).append("]");
            return sb.toString();
        }

        public String toString(long D) {
            return this.toString(D, true);
        }

        public String toString(boolean longFmt) {
            return this.toString(0x100000L, longFmt);
        }

        public String toString() {
            return this.toString(0x100000L, true);
        }
    }

    public static class CpuUsage {
        private int availCores = -1;
        private double procCpuLoad = -1.0;
        private long procCpuTime = -1L;
        private double sysCpuLoad = -1.0;
        private double sysCpuLoadAvg = -1.0;

        public void setAvailableProcessors(int v) {
            this.availCores = v;
        }

        public int getAvailableProcessors() {
            return this.availCores;
        }

        public void setProcessCpuLoad(double v) {
            this.procCpuLoad = v;
        }

        public double getProcessCpuLoad() {
            return this.procCpuLoad;
        }

        public void setProcessCpuTimeNS(long v) {
            this.procCpuTime = v;
        }

        public long getProcessCpuTimeNS() {
            return this.procCpuTime;
        }

        public void setSystemCpuLoad(double v) {
            this.sysCpuLoad = v;
        }

        public double getSystemCpuLoad() {
            return this.sysCpuLoad;
        }

        public void setSystemLoadAverage(double v) {
            this.sysCpuLoadAvg = v;
        }

        public double getSystemLoadAverage() {
            return this.sysCpuLoadAvg;
        }

        public String toString(boolean longFmt) {
            StringBuffer sb = new StringBuffer();
            String fmt = longFmt ? "0.0" : "0";
            String AP = String.valueOf(this.getAvailableProcessors());
            String PCL = StringTools.format(this.getProcessCpuLoad() * 100.0, fmt);
            String PCT = String.valueOf(this.getProcessCpuTimeNS());
            String SCL = StringTools.format(this.getSystemCpuLoad() * 100.0, fmt);
            String SLA = StringTools.format(this.getSystemLoadAverage() * 100.0, fmt);
            if (longFmt) {
                sb.append("CPU Usage: ");
            }
            sb.append("Cores=").append(AP).append(", ");
            sb.append("ProcLoad=").append(PCL).append("%, ");
            sb.append("SysLoad/Avg=").append(SCL).append("%/").append(SLA).append("%, ");
            return sb.toString();
        }
    }
}

