/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.util;

import java.util.TimeZone;
import org.opengts.util.DateTime;
import org.opengts.util.GeoPoint;
import org.opengts.util.ListTools;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;
import org.opengts.util.StringTools;

public class Nmea0183 {
    public static final String NAME_NONE = "NONE";
    public static final String NAME_GPRMC = "GPRMC";
    public static final String NAME_GPGGA = "GPGGA";
    public static final String NAME_GPVTG = "GPVTG";
    public static final String NAME_GPZDA = "GPZDA";
    public static final String DNAME_GPRMC = "$GPRMC";
    public static final String DNAME_GPGGA = "$GPGGA";
    public static final String DNAME_GPVTG = "$GPVTG";
    public static final String DNAME_GPZDA = "$GPZDA";
    public static final long TYPE_NONE = 0L;
    public static final long TYPE_GPRMC = 1L;
    public static final long TYPE_GPGGA = 2L;
    public static final long TYPE_GPVTG = 4L;
    public static final long TYPE_GPZDA = 8L;
    public static final long FIELD_RECORD_TYPE = 1L;
    public static final long FIELD_VALID_FIX = 2L;
    public static final long FIELD_DDMMYY = 4L;
    public static final long FIELD_HHMMSS = 8L;
    public static final long FIELD_LATITUDE = 16L;
    public static final long FIELD_LONGITUDE = 32L;
    public static final long FIELD_SPEED = 64L;
    public static final long FIELD_HEADING = 128L;
    public static final long FIELD_HDOP = 256L;
    public static final long FIELD_NUMBER_SATS = 512L;
    public static final long FIELD_ALTITUDE = 1024L;
    public static final long FIELD_FIX_TYPE = 2048L;
    public static final double KILOMETERS_PER_KNOT = 1.852;
    public static final double KNOTS_PER_KILOMETER = 0.5399568034557235;
    private boolean validChecksum = false;
    private long parsedRcdTypes = 0L;
    private String lastRcdType = "";
    private long fieldMask = 0L;
    private long ddmmyy = 0L;
    private long hhmmss = 0L;
    private long fixtime = 0L;
    private boolean ignoreGpsFlag = false;
    private boolean ignoredInvalidGPS = false;
    private boolean isValidGPS = false;
    private double latitude = 0.0;
    private double longitude = 0.0;
    private GeoPoint geoPoint = null;
    private double speedKnots = 0.0;
    private double heading = 0.0;
    private double hdop = 0.0;
    private int numSats = 0;
    private double altitudeM = 0.0;
    private int fixType = 0;
    private double magVariation = 0.0;
    private String[] extraData = null;

    public static String GetTypeNames(long type) {
        String sep = ",";
        StringBuffer sb = new StringBuffer();
        if ((type & 1L) != 0L) {
            if (sb.length() > 0) {
                sb.append(sep);
            }
            sb.append(NAME_GPRMC);
        }
        if ((type & 2L) != 0L) {
            if (sb.length() > 0) {
                sb.append(sep);
            }
            sb.append(NAME_GPGGA);
        }
        if ((type & 4L) != 0L) {
            if (sb.length() > 0) {
                sb.append(sep);
            }
            sb.append(NAME_GPVTG);
        }
        if ((type & 8L) != 0L) {
            if (sb.length() > 0) {
                sb.append(sep);
            }
            sb.append(NAME_GPZDA);
        }
        return sb.length() > 0 ? sb.toString() : NAME_NONE;
    }

    public Nmea0183() {
    }

    public Nmea0183(String rcd) {
        this();
        this.parse(rcd, false);
    }

    public Nmea0183(String[] rcds) {
        this();
        this.parse(rcds, false);
    }

    public Nmea0183(String rcd, boolean ignoreChecksum) {
        this();
        this.parse(rcd, ignoreChecksum);
    }

    public Nmea0183(String[] rcds, boolean ignoreChecksum) {
        this();
        this.parse(rcds, ignoreChecksum);
    }

    public long getFieldMask() {
        return this.fieldMask;
    }

    public boolean hasField(long fld) {
        return (this.fieldMask & fld) != 0L;
    }

    public long getParsedRecordTypes() {
        return this.parsedRcdTypes;
    }

    public String getLastRecordType() {
        return this.lastRcdType;
    }

    public boolean isValidChecksum() {
        return this.validChecksum;
    }

    public void setDDMMYY(long ddmmyy) {
        if (ddmmyy >= 10100L && ddmmyy <= 311299L) {
            this.ddmmyy = ddmmyy;
            this.fieldMask |= 4L;
        } else {
            this.ddmmyy = 0L;
            this.fieldMask &= 0xFFFFFFFFFFFFFFFBL;
        }
    }

    public long getDDMMYY() {
        return this.ddmmyy;
    }

    public long getHHMMSS() {
        return this.hhmmss;
    }

    public boolean hasFixtime() {
        return this.hasField(4L) && this.hasField(8L);
    }

    public long getFixtime() {
        return this.getFixtime(false);
    }

    public long getFixtime(boolean dftToCurrentTOD) {
        if (this.fixtime <= 0L) {
            long DMY = this.hasField(4L) ? this.ddmmyy : 0L;
            long HMS = this.hasField(8L) ? this.hhmmss : 0L;
            this.fixtime = Nmea0183.parseFixtime(DMY, HMS, dftToCurrentTOD);
        }
        return this.fixtime;
    }

    public void setIgnoreInvalidGpsFlag(boolean ignore) {
        this.ignoreGpsFlag = ignore;
        this.ignoredInvalidGPS = false;
    }

    public boolean getIgnoreInvalidGpsFlag() {
        return this.ignoreGpsFlag;
    }

    public boolean didIgnoreInvalidGPS() {
        return this.isValidGPS() && this.ignoredInvalidGPS;
    }

    public boolean isValidGPS() {
        return this.isValidGPS;
    }

    public boolean hasLatitude() {
        return this.hasField(16L);
    }

    public double getLatitude() {
        return this.latitude;
    }

    public boolean hasLongitude() {
        return this.hasField(32L);
    }

    public double getLongitude() {
        return this.longitude;
    }

    public boolean hasGeoPoint() {
        return this.hasField(16L) && this.hasField(32L);
    }

    public GeoPoint getGeoPoint() {
        if (this.geoPoint == null) {
            this.geoPoint = new GeoPoint(this.getLatitude(), this.getLongitude());
        }
        return this.geoPoint;
    }

    public void setGeoPoint(GeoPoint gp) {
        if (gp != null && gp.isValid()) {
            this.latitude = gp.getLatitude();
            this.longitude = gp.getLongitude();
            this.geoPoint = gp;
            this.isValidGPS = true;
        } else {
            this.latitude = 0.0;
            this.longitude = 0.0;
            this.geoPoint = null;
            this.isValidGPS = false;
        }
    }

    public boolean hasSpeed() {
        return this.hasField(64L);
    }

    public double getSpeedKnots() {
        return this.speedKnots;
    }

    public double getSpeedKPH() {
        return this.speedKnots * 1.852;
    }

    public boolean hasHeading() {
        return this.hasField(128L);
    }

    public double getHeading() {
        return this.heading;
    }

    public int getFixType() {
        return this.fixType;
    }

    public int getNumberOfSatellites() {
        return this.numSats;
    }

    public double getHDOP() {
        return this.hdop;
    }

    public boolean hasAltitude() {
        return this.hasField(1024L);
    }

    public double getAltitudeMeters() {
        return this.altitudeM;
    }

    public double getMagneticVariation() {
        return this.magVariation;
    }

    public String[] getExtraData() {
        return this.extraData;
    }

    public String toString() {
        long types = this.getParsedRecordTypes();
        StringBuffer sb = new StringBuffer();
        sb.append("RcdType  : ").append(Nmea0183.GetTypeNames(types)).append(" [0x").append(StringTools.toHexString(types, 16)).append("]\n");
        sb.append("Checksum : ").append(this.isValidChecksum() ? "ok" : "failed").append("\n");
        sb.append("Fixtime  : ").append(this.getFixtime()).append(" [").append(new DateTime(this.getFixtime()).toString()).append("]\n");
        sb.append("GPS      : ").append(this.isValidGPS() ? "valid " : "invalid ").append(this.getGeoPoint().toString()).append("\n");
        sb.append("SpeedKPH : ").append(this.getSpeedKPH()).append(" kph, heading ").append(this.getHeading()).append("\n");
        sb.append("Altitude : ").append(this.getAltitudeMeters()).append(" meters\n");
        return sb.toString();
    }

    public String toGPRMC() {
        DateTime ft = new DateTime(this.getFixtime(), DateTime.GMT);
        GeoPoint gp = this.getGeoPoint();
        StringBuffer sb = new StringBuffer();
        sb.append("$").append(NAME_GPRMC);
        sb.append(",");
        sb.append(ft.format("HHmmss")).append(".00");
        sb.append(",");
        sb.append(this.isValidGPS() ? "A" : "V");
        sb.append(",");
        sb.append(gp.getLatitudeString("NMEA", null));
        sb.append(",");
        sb.append(gp.getLongitudeString("NMEA", null));
        sb.append(",");
        sb.append(StringTools.format(this.getSpeedKnots(), "0.0"));
        sb.append(",");
        sb.append(StringTools.format(this.getHeading(), "0.0"));
        sb.append(",");
        sb.append(ft.format("ddMMyy"));
        sb.append(",");
        double magDeg = this.getMagneticVariation();
        if (magDeg != 0.0) {
            sb.append(StringTools.format(Math.abs(magDeg), "0.0")).append(magDeg >= 0.0 ? ",E" : ",W");
        } else {
            sb.append(",");
        }
        sb.append(",A");
        int cksum = Nmea0183.calcXORChecksum(sb.toString(), false);
        sb.append("*");
        sb.append(StringTools.toHexString(cksum, 8));
        return sb.toString();
    }

    public boolean parse(String[] rcds) {
        return this.parse(rcds, false);
    }

    public boolean parse(String rcd) {
        return this.parse(rcd, false);
    }

    public boolean parse(String[] rcds, boolean ignoreChecksum) {
        if (!ListTools.isEmpty(rcds)) {
            boolean rtn = true;
            for (int i = 0; i < rcds.length; ++i) {
                if (this.parse(rcds[i], ignoreChecksum)) continue;
                rtn = false;
            }
            return rtn;
        }
        return false;
    }

    public boolean parse(String rcd, boolean ignoreChecksum) {
        if (rcd == null) {
            Print.logError("Null record specified", new Object[0]);
            return false;
        }
        if (!rcd.startsWith("$")) {
            Print.logError("Invalid record (must begin with '$'): " + rcd, new Object[0]);
            return false;
        }
        if (ignoreChecksum) {
            this.validChecksum = true;
        } else {
            this.validChecksum = this._hasValidChecksum(rcd);
            if (!this.validChecksum) {
                Print.logError("Invalid Checksum: " + rcd, new Object[0]);
                return false;
            }
        }
        String[] fld = StringTools.parseStringArray(rcd, ',');
        if (fld == null || fld.length < 1) {
            Print.logError("Insufficient fields: " + rcd, new Object[0]);
            return false;
        }
        this.fieldMask = 0L;
        if (fld[0].equals(DNAME_GPRMC)) {
            this.parsedRcdTypes |= 1L;
            this.lastRcdType = fld[0];
            this.fieldMask |= 1L;
            return this._parse_GPRMC(fld);
        }
        if (fld[0].equals(DNAME_GPGGA)) {
            this.parsedRcdTypes |= 2L;
            this.lastRcdType = fld[0];
            this.fieldMask |= 1L;
            return this._parse_GPGGA(fld);
        }
        if (fld[0].equals(DNAME_GPVTG)) {
            this.parsedRcdTypes |= 4L;
            this.lastRcdType = fld[0];
            this.fieldMask |= 1L;
            return this._parse_GPVTG(fld);
        }
        if (fld[0].equals(DNAME_GPZDA)) {
            this.parsedRcdTypes |= 8L;
            this.lastRcdType = fld[0];
            this.fieldMask |= 1L;
            return this._parse_GPZDA(fld);
        }
        Print.logError("Record not supported: " + rcd, new Object[0]);
        return false;
    }

    public boolean hasGPRMC() {
        return (this.parsedRcdTypes | 1L) != 0L;
    }

    private boolean _parse_GPRMC(String[] fld) {
        if (fld.length < 10) {
            return false;
        }
        boolean validGPS = false;
        if (fld[2].equals("A")) {
            validGPS = true;
        } else if (this.getIgnoreInvalidGpsFlag()) {
            this.ignoredInvalidGPS = true;
            validGPS = true;
        } else if (fld[2].equals("V")) {
            validGPS = false;
        } else if (fld[2].equals("L")) {
            Print.logWarn("Unexpected valid GPS fix indicator: " + fld[2], new Object[0]);
            validGPS = true;
        } else {
            Print.logWarn("Unexpected valid GPS fix indicator: " + fld[2], new Object[0]);
            validGPS = true;
        }
        this.fieldMask |= 2L;
        this.fixtime = 0L;
        boolean hasDate = false;
        if (!fld[9].equals("000000")) {
            this.ddmmyy = StringTools.parseLong(fld[9], 0L);
            this.fieldMask |= 4L;
            hasDate = true;
        }
        if (hasDate || !fld[1].equals("000000.000")) {
            this.hhmmss = StringTools.parseLong(fld[1], 0L);
            this.fieldMask |= 8L;
        }
        if (validGPS) {
            this.latitude = Nmea0183.ParseLatitude(fld[3], fld[4], 90.0);
            this.longitude = Nmea0183.ParseLongitude(fld[5], fld[6], 180.0);
            if (!GeoPoint.isValid(this.latitude, this.longitude)) {
                validGPS = false;
                this.latitude = 0.0;
                this.longitude = 0.0;
                this.ignoredInvalidGPS = false;
            } else {
                this.fieldMask |= 0x30L;
                this.speedKnots = StringTools.parseDouble(fld[7], -1.0);
                this.heading = StringTools.parseDouble(fld[8], -1.0);
                this.fieldMask |= 0xC0L;
            }
        } else {
            this.latitude = 0.0;
            this.longitude = 0.0;
            this.speedKnots = 0.0;
            this.heading = 0.0;
        }
        this.isValidGPS = validGPS;
        if (fld.length > 11) {
            double magDeg = StringTools.parseDouble(fld[10], 0.0);
            this.magVariation = fld[11].equalsIgnoreCase("W") ? -magDeg : magDeg;
        }
        this.extraData = null;
        if (fld.length > 12) {
            int ePos = fld[11].indexOf(42) >= 0 ? 12 : (fld.length > 13 && fld[12].indexOf(42) >= 0 ? 13 : 12);
            this.extraData = new String[fld.length - ePos];
            System.arraycopy(fld, ePos, this.extraData, 0, this.extraData.length);
        }
        return validGPS;
    }

    private boolean _parse_GPGGA(String[] fld) {
        if (fld.length < 14) {
            return false;
        }
        boolean validGPS = !fld[6].equals("0");
        this.fieldMask |= 2L;
        this.fixtime = 0L;
        this.ddmmyy = 0L;
        this.hhmmss = StringTools.parseLong(fld[1], 0L);
        this.fieldMask |= 8L;
        if (validGPS) {
            this.latitude = Nmea0183.ParseLatitude(fld[2], fld[3], 90.0);
            this.longitude = Nmea0183.ParseLongitude(fld[4], fld[5], 180.0);
            if (!GeoPoint.isValid(this.latitude, this.longitude)) {
                validGPS = false;
                this.latitude = 0.0;
                this.longitude = 0.0;
            } else {
                this.fieldMask |= 0x30L;
                this.fixType = StringTools.parseInt(fld[6], 1);
                this.numSats = StringTools.parseInt(fld[7], 0);
                this.hdop = StringTools.parseDouble(fld[8], 0.0);
                this.altitudeM = StringTools.parseDouble(fld[9], 0.0);
                this.fieldMask |= 0xF00L;
            }
        } else {
            this.latitude = 0.0;
            this.longitude = 0.0;
            this.fixType = 0;
            this.numSats = 0;
            this.hdop = 0.0;
            this.altitudeM = 0.0;
        }
        this.isValidGPS = validGPS;
        if (fld.length > 15) {
            int ePos = 15;
            this.extraData = new String[fld.length - ePos];
            System.arraycopy(fld, ePos, this.extraData, 0, this.extraData.length);
        } else {
            this.extraData = null;
        }
        return validGPS;
    }

    private boolean _parse_GPVTG(String[] fld) {
        if (fld.length < 3) {
            return false;
        }
        int i = 1;
        while (i + 1 < fld.length) {
            if (fld[i + 1].equals("T")) {
                this.heading = StringTools.parseDouble(fld[i], -1.0);
                this.fieldMask |= 0x80L;
            } else if (fld[i + 1].equals("N")) {
                this.speedKnots = StringTools.parseDouble(fld[i], -1.0);
                this.fieldMask |= 0x40L;
            } else if (fld[i + 1].equals("K")) {
                double kph = StringTools.parseDouble(fld[i], -1.0);
                this.speedKnots = kph >= 0.0 ? kph * 0.5399568034557235 : -1.0;
                this.fieldMask |= 0x40L;
            }
            i += 2;
        }
        return true;
    }

    private boolean _parse_GPZDA(String[] fld) {
        if (fld.length < 5) {
            return false;
        }
        this.fixtime = 0L;
        long day = StringTools.parseLong(fld[2], 0L) % 100L;
        long month = StringTools.parseLong(fld[3], 0L) % 100L;
        long year = StringTools.parseLong(fld[4], 0L) % 10000L;
        this.ddmmyy = day * 10000L + month * 100L + year % 100L;
        this.fieldMask |= 4L;
        this.hhmmss = StringTools.parseLong(fld[1], 0L);
        this.fieldMask |= 8L;
        return true;
    }

    public static long getCurrentHHMMSS(TimeZone tz) {
        if (tz == null) {
            tz = DateTime.GMT;
        }
        DateTime nowDT = new DateTime(tz);
        int HH = nowDT.getHour24(tz);
        int MM = nowDT.getMinute(tz);
        int SS = nowDT.getSecond(tz);
        return (long)HH * 10000L + (long)MM * 100L + (long)SS;
    }

    public static long parseFixtime(String DDMMYY, String HHMMSS, boolean dftToCurrentTOD) {
        long ddmmyy = StringTools.parseLong(DDMMYY, 0L);
        long hhmmss = StringTools.parseLong(HHMMSS, 0L);
        return Nmea0183.parseFixtime(ddmmyy, hhmmss, dftToCurrentTOD);
    }

    public static long parseFixtime(long ddmmyy, long hhmmss, boolean dftToCurrentTOD) {
        long DMY;
        boolean hasHMS;
        boolean hasDMY = ddmmyy > 0L;
        boolean bl = hasHMS = hhmmss > 0L;
        if (!hasDMY && !hasHMS) {
            return DateTime.getCurrentTimeSec();
        }
        long l = DMY = hasDMY ? ddmmyy : 0L;
        long HMS = hasHMS ? hhmmss : (dftToCurrentTOD ? Nmea0183.getCurrentHHMMSS(null) : 0L);
        return Nmea0183._getUTCSeconds(DMY, HMS);
    }

    private static long _getUTCSeconds(long dmy, long hms) {
        long DAY;
        int HH = (int)(hms / 10000L % 100L);
        int MM = (int)(hms / 100L % 100L);
        int SS = (int)(hms / 1L % 100L);
        long TOD = (long)HH * 3600L + (long)MM * 60L + (long)SS;
        if (dmy > 0L) {
            int dd = (int)(dmy / 10000L % 100L);
            int mm = (int)(dmy / 100L % 100L);
            int yy = (int)(dmy / 1L % 100L) + 2000;
            long yr = (long)yy * 1000L + (long)((mm - 3) * 1000 / 12);
            DAY = (367L * yr + 625L) / 1000L - 2L * (yr / 1000L) + yr / 4000L - yr / 100000L + yr / 400000L + (long)dd - 719469L;
        } else {
            long dif;
            long utc = DateTime.getCurrentTimeSec();
            long tod = utc % DateTime.DaySeconds(1L);
            DAY = utc / DateTime.DaySeconds(1L);
            long l = dif = tod >= TOD ? tod - TOD : TOD - tod;
            if (dif > DateTime.HourSeconds(12L)) {
                DAY = tod > TOD ? ++DAY : --DAY;
            }
        }
        long sec = DateTime.DaySeconds(DAY) + TOD;
        return sec;
    }

    public static double ParseLatitude(String s, String d) {
        return Nmea0183.ParseLatitude(s, d, 90.0);
    }

    public static double ParseLatitude(String s, String d, double dft) {
        double _lat = StringTools.parseDouble(s, 99999.0);
        if (_lat < 99999.0) {
            double lat = (long)_lat / 100L;
            lat += (_lat - lat * 100.0) / 60.0;
            return d.equalsIgnoreCase("S") ? -lat : lat;
        }
        return 90.0;
    }

    public static double ParseLongitude(String s, String d) {
        return Nmea0183.ParseLongitude(s, d, 180.0);
    }

    public static double ParseLongitude(String s, String d, double dft) {
        double _lon = StringTools.parseDouble(s, 99999.0);
        if (_lon < 99999.0) {
            double lon = (long)_lon / 100L;
            lon += (_lon - lon * 100.0) / 60.0;
            return d.equalsIgnoreCase("W") ? -lon : lon;
        }
        return dft;
    }

    private boolean _hasValidChecksum(String str) {
        boolean isValid;
        int c = str.indexOf("*");
        if (c < 0) {
            return false;
        }
        String chkSum = str.substring(c + 1);
        byte[] cs = StringTools.parseHex(chkSum, null);
        if (cs == null || cs.length != 1) {
            return false;
        }
        int calcSum = Nmea0183.calcXORChecksum(str, false);
        boolean bl = isValid = calcSum == (cs[0] & 0xFF);
        if (!isValid) {
            Print.logWarn("Expected checksum: 0x" + StringTools.toHexString(calcSum, 8), new Object[0]);
        }
        return isValid;
    }

    public static int calcXORChecksum(String str, boolean includeAll) {
        byte[] b = StringTools.getBytes(str);
        if (b == null) {
            return -1;
        }
        int cksum = 0;
        int s = 0;
        if (!includeAll && b.length > 0 && b[0] == 36) {
            ++s;
        }
        while (s < b.length && (includeAll || b[s] != 42) && b[s] != 13 && b[s] != 10) {
            cksum = (cksum ^ b[s]) & 0xFF;
            ++s;
        }
        return cksum;
    }

    public static void main(String[] argv) {
        RTConfig.setCommandLineArgs(argv);
        if (RTConfig.hasProperty("parse")) {
            String gprmc = RTConfig.getString("parse", "");
            if (!gprmc.startsWith("$")) {
                gprmc = "$" + gprmc;
            }
            Nmea0183 n = new Nmea0183(gprmc, true);
            Print.sysPrintln("NMEA-0183: \n" + n, new Object[0]);
            System.exit(0);
        }
        if (RTConfig.hasProperty("xor")) {
            String cksumStr = RTConfig.getString("xor", "");
            int cksum = Nmea0183.calcXORChecksum(cksumStr, true);
            Print.sysPrintln("Checksum: " + StringTools.toHexString(cksum, 8), new Object[0]);
            System.exit(0);
        }
        if (RTConfig.hasProperty("test")) {
            String gprmc = "$GPRMC,080701.00,A,3128.7540,N,14257.6714,W,27.6,107.5,180607,13.1,E,A*2D";
            Nmea0183 n = new Nmea0183(gprmc);
            Print.sysPrintln("$GPRMC   : " + gprmc, new Object[0]);
            Print.sysPrintln("      ==>: " + n.toGPRMC(), new Object[0]);
            Print.sysPrintln("NMEA-0183: \n" + n, new Object[0]);
            String gpgga = "$GPGGA,025425.494,3509.0743,N,14207.6314,W,1,04,2.3,530.3,M,-21.9,M,0.0,0000*45";
            n = new Nmea0183(gpgga);
            Print.sysPrintln("NMEA-0183: \n" + n, new Object[0]);
            n = new Nmea0183("$GPGGA,125653.00,3845.165,N,14228.961,W,1,05,,102.1331,M,,M,,*75");
            n.parse("$GPVTG,229.86,T,,M,0.00,N,0.0046,K*55");
            n.parse("$GPZDA,125653.00,13,09,2007,00,00*6E");
            Print.sysPrintln("NMEA-0183: \n" + n, new Object[0]);
        }
    }
}

