/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.util;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.swing.Timer;
import org.opengts.util.Print;
import org.opengts.util.StringTools;

public class MethodAction
implements ActionListener,
Runnable {
    public static final String CONSTRUCTOR = "<init>";
    private Class targetClass = null;
    private Object target = null;
    private AccessibleObject method = null;
    private Class[] argClass = null;
    private Object[] args = null;
    private Object rtnValue = null;
    private Throwable error = null;

    public MethodAction(Object targ) throws NoSuchMethodException, ClassNotFoundException {
        this(targ, CONSTRUCTOR, (Class[])null, (Object[])null);
    }

    public MethodAction(Object targ, String methName) throws NoSuchMethodException, ClassNotFoundException {
        this(targ, methName, (Class[])null, (Object[])null);
    }

    public MethodAction(Object targ, Class ... argClass) throws NoSuchMethodException, ClassNotFoundException {
        this(targ, CONSTRUCTOR, argClass, (Object[])null);
    }

    public MethodAction(Object targ, String methName, Class ... argClass) throws NoSuchMethodException, ClassNotFoundException {
        this(targ, methName, argClass, (Object[])null);
    }

    public MethodAction(Object targ, Class[] argClass, Object[] args) throws NoSuchMethodException, ClassNotFoundException {
        this(targ, CONSTRUCTOR, argClass, args);
    }

    public MethodAction(Object targ, String methName, Class[] argClass, Object[] args) throws NoSuchMethodException, ClassNotFoundException {
        this.target = targ instanceof String ? Class.forName((String)((Object)targ)) : targ;
        this.targetClass = this.target instanceof Class ? (Class<?>)this.target : this.target.getClass();
        Class[] classArray = this.argClass = argClass != null ? argClass : new Class[]{};
        this.method = methName == null ? this.targetClass.getConstructor(this.argClass) : (methName.equals(CONSTRUCTOR) ? this.targetClass.getConstructor(this.argClass) : this.targetClass.getMethod(methName, this.argClass));
        this.setArgs(args);
    }

    protected static String _beanMethodName(String prefix, String fieldName) {
        if (prefix != null && fieldName != null) {
            StringBuffer sb = new StringBuffer(prefix);
            sb.append(fieldName.substring(0, 1).toUpperCase());
            sb.append(fieldName.substring(1));
            return sb.toString();
        }
        return "";
    }

    public static String getterMethodName(String fieldName) {
        return MethodAction._beanMethodName("get", fieldName);
    }

    public static String setterMethodName(String fieldName) {
        return MethodAction._beanMethodName("set", fieldName);
    }

    public static MethodAction GetterMethod(Object targ, String fieldName) throws NoSuchMethodException, ClassNotFoundException {
        String mn = MethodAction._beanMethodName("get", fieldName);
        return new MethodAction(targ, mn, (Class[])null);
    }

    public static Object InvokeGetter(Object targ, String fieldName) throws NoSuchMethodException, ClassNotFoundException, Throwable {
        return MethodAction.GetterMethod(targ, fieldName).invoke();
    }

    public static MethodAction SetterMethod(Object targ, String fieldName, Class ... argType) throws NoSuchMethodException, ClassNotFoundException {
        String mn = MethodAction._beanMethodName("set", fieldName);
        if (argType == null) {
            argType = new Class[]{Object.class};
        }
        return new MethodAction(targ, mn, argType);
    }

    public static void InvokeSetter(Object targ, String fieldName, Class valClass, Object value) throws NoSuchMethodException, ClassNotFoundException, Throwable {
        Class<Object> clz = valClass != null ? valClass : (value != null ? value.getClass() : Object.class);
        MethodAction.SetterMethod(targ, fieldName, clz).invoke(value);
    }

    public static void InvokeSetter(Object targ, String fieldName, String value) throws NoSuchMethodException, ClassNotFoundException, Throwable {
        MethodAction.SetterMethod(targ, fieldName, String.class).invoke(value);
    }

    public static void InvokeSetter(Object targ, String fieldName, boolean value) throws NoSuchMethodException, ClassNotFoundException, Throwable {
        MethodAction.SetterMethod(targ, fieldName, Boolean.TYPE).invoke(new Boolean(value));
    }

    public static void InvokeSetter(Object targ, String fieldName, int value) throws NoSuchMethodException, ClassNotFoundException, Throwable {
        MethodAction.SetterMethod(targ, fieldName, Integer.TYPE).invoke(new Integer(value));
    }

    public static void InvokeSetter(Object targ, String fieldName, long value) throws NoSuchMethodException, ClassNotFoundException, Throwable {
        MethodAction.SetterMethod(targ, fieldName, Long.TYPE).invoke(new Long(value));
    }

    public static void InvokeSetter(Object targ, String fieldName, float value) throws NoSuchMethodException, ClassNotFoundException, Throwable {
        MethodAction.SetterMethod(targ, fieldName, Float.TYPE).invoke(new Float(value));
    }

    public static void InvokeSetter(Object targ, String fieldName, double value) throws NoSuchMethodException, ClassNotFoundException, Throwable {
        MethodAction.SetterMethod(targ, fieldName, Double.TYPE).invoke(new Double(value));
    }

    public Object getTarget() {
        return this.target;
    }

    public void setArgs(Object ... args) {
        this.args = args;
    }

    public Object[] getArgs() {
        return this.args;
    }

    public Object invoke(Object ... args) throws Throwable {
        this.setArgs(args);
        return this.invoke();
    }

    public Object invoke() throws Throwable {
        this.error = null;
        this.rtnValue = null;
        try {
            if (this.method instanceof Constructor) {
                this.rtnValue = ((Constructor)this.method).newInstance(this.getArgs());
            } else if (this.method instanceof Method) {
                this.rtnValue = ((Method)this.method).invoke(this.getTarget(), this.getArgs());
            }
            return this.rtnValue;
        }
        catch (InvocationTargetException ite) {
            this.error = ite.getCause();
            if (this.error == null) {
                this.error = ite;
            }
            throw this.error;
        }
        catch (Throwable t) {
            this.error = t;
            throw this.error;
        }
    }

    public Object getReturnValue() {
        return this.rtnValue;
    }

    public static void invokeDelayed(int delayMillis, final Runnable r) {
        if (r != null) {
            if (delayMillis <= 0) {
                MethodAction.invokeLater(r);
            } else {
                Timer delay = new Timer(delayMillis, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        r.run();
                    }
                });
                delay.setRepeats(false);
                delay.start();
            }
        }
    }

    public void invokeDelayed(int delayMillis) {
        Timer delay = new Timer(delayMillis, this);
        delay.setRepeats(false);
        delay.start();
    }

    public static void invokeLater(final ActionListener al, final ActionEvent ae) {
        MethodAction.invokeLater(new Runnable(){

            @Override
            public void run() {
                al.actionPerformed(ae);
            }
        });
    }

    public static void invokeLater(Runnable r) {
        if (r != null) {
            EventQueue.invokeLater(r);
        }
    }

    public static void invokeAndWait(Runnable r) throws InterruptedException, InvocationTargetException {
        if (r != null) {
            EventQueue.invokeAndWait(r);
        }
    }

    public void invokeLater() {
        MethodAction.invokeLater(this);
    }

    public void invokeAndWait() throws InterruptedException, InvocationTargetException {
        MethodAction.invokeAndWait(this);
    }

    @Override
    public void run() {
        try {
            this.invoke();
        }
        catch (Throwable t) {
            Print.logError("'invoke' error " + t, new Object[0]);
        }
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        try {
            this.invoke();
        }
        catch (Throwable t) {
            Print.logError("'invoke' error " + t, new Object[0]);
        }
    }

    public static boolean isDispatchThread() {
        return EventQueue.isDispatchThread();
    }

    public static Object newInstance(String className) throws NoSuchMethodException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        if (!StringTools.isBlank(className)) {
            return Class.forName(className).newInstance();
        }
        throw new ClassNotFoundException("Class name is null/blank");
    }
}

