/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.lang.reflect.Array;
import java.math.BigInteger;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import org.opengts.util.MethodAction;
import org.opengts.util.OrderedMap;
import org.opengts.util.Print;

public class ListTools {
    public static long RANDOM_SEED_MASK = 0xFFFFFFFFFFFFL;

    private static int _constrainOffset(int ofs, int length) {
        if (ofs < 0 || length <= 0) {
            return 0;
        }
        if (ofs > length) {
            return length;
        }
        return ofs;
    }

    private static int _constrainLength(int ofs, int len, int length) {
        if (len < 0) {
            return length - ofs;
        }
        if (len > length - ofs) {
            return length - ofs;
        }
        return len;
    }

    public static int size(ByteArrayOutputStream B) {
        return B != null ? B.size() : 0;
    }

    public static int size(ByteArrayInputStream B) {
        return B != null ? B.available() : 0;
    }

    public static int size(Map<?, ?> M) {
        return M != null ? M.size() : 0;
    }

    public static int size(Collection<?> C) {
        return C != null ? C.size() : 0;
    }

    public static <T> int size(T[] A) {
        return A != null ? A.length : 0;
    }

    public static int size(char[] C) {
        return C != null ? C.length : 0;
    }

    public static int size(byte[] B) {
        return B != null ? B.length : 0;
    }

    public static int size(short[] S) {
        return S != null ? S.length : 0;
    }

    public static int size(int[] I) {
        return I != null ? I.length : 0;
    }

    public static int size(long[] L) {
        return L != null ? L.length : 0;
    }

    public static int size(float[] F) {
        return F != null ? F.length : 0;
    }

    public static int size(double[] D) {
        return D != null ? D.length : 0;
    }

    public static boolean isEmpty(ByteArrayOutputStream B) {
        return B == null || B.size() <= 0;
    }

    public static boolean isEmpty(ByteArrayInputStream B) {
        return B == null || B.available() <= 0;
    }

    public static boolean isEmpty(Map<?, ?> M) {
        return M == null || M.isEmpty();
    }

    public static boolean isEmpty(Collection<?> C) {
        return C == null || C.isEmpty();
    }

    public static <T> boolean isEmpty(T[] A) {
        return A == null || A.length == 0;
    }

    public static boolean isEmpty(boolean[] B) {
        return B == null || B.length == 0;
    }

    public static boolean isEmpty(char[] C) {
        return C == null || C.length == 0;
    }

    public static boolean isEmpty(byte[] B) {
        return B == null || B.length == 0;
    }

    public static boolean isEmpty(int[] I) {
        return I == null || I.length == 0;
    }

    public static boolean isEmpty(long[] L) {
        return L == null || L.length == 0;
    }

    public static boolean isEmpty(double[] D) {
        return D == null || D.length == 0;
    }

    public static int diff(boolean[] a1, boolean[] a2) {
        return ListTools.diff(a1, a2, -1);
    }

    public static int diff(boolean[] a1, boolean[] a2, int len) {
        if (a1 == null && a2 == null) {
            return -1;
        }
        if (a1 == null || a2 == null) {
            return 0;
        }
        int n1 = a1.length;
        int n2 = a2.length;
        int i = 0;
        if (len < 0) {
            len = n1 >= n2 ? n1 : n2;
        }
        for (i = 0; i < n1 && i < n2 && i < len; ++i) {
            if (a1[i] == a2[i]) continue;
            return i;
        }
        return i < len ? i : -1;
    }

    public static int diff(char[] a1, char[] a2) {
        return ListTools.diff(a1, a2, -1);
    }

    public static int diff(char[] a1, char[] a2, int len) {
        if (a1 == null && a2 == null) {
            return -1;
        }
        if (a1 == null || a2 == null) {
            return 0;
        }
        int n1 = a1.length;
        int n2 = a2.length;
        int i = 0;
        if (len < 0) {
            len = n1 >= n2 ? n1 : n2;
        }
        for (i = 0; i < n1 && i < n2 && i < len; ++i) {
            if (a1[i] == a2[i]) continue;
            return i;
        }
        return i < len ? i : -1;
    }

    public static int diff(byte[] a1, byte[] a2) {
        return ListTools.diff(a1, a2, -1);
    }

    public static int diff(byte[] a1, byte[] a2, int len) {
        if (a1 == null && a2 == null) {
            return -1;
        }
        if (a1 == null || a2 == null) {
            return 0;
        }
        int n1 = a1.length;
        int n2 = a2.length;
        int i = 0;
        if (len < 0) {
            len = n1 >= n2 ? n1 : n2;
        }
        for (i = 0; i < n1 && i < n2 && i < len; ++i) {
            if (a1[i] == a2[i]) continue;
            return i;
        }
        return i < len ? i : -1;
    }

    public static int diff(int[] a1, int[] a2) {
        return ListTools.diff(a1, a2, -1);
    }

    public static int diff(int[] a1, int[] a2, int len) {
        if (a1 == null && a2 == null) {
            return -1;
        }
        if (a1 == null || a2 == null) {
            return 0;
        }
        int n1 = a1.length;
        int n2 = a2.length;
        int i = 0;
        if (len < 0) {
            len = n1 >= n2 ? n1 : n2;
        }
        for (i = 0; i < n1 && i < n2 && i < len; ++i) {
            if (a1[i] == a2[i]) continue;
            return i;
        }
        return i < len ? i : -1;
    }

    public static int diff(long[] a1, long[] a2) {
        return ListTools.diff(a1, a2, -1);
    }

    public static int diff(long[] a1, long[] a2, int len) {
        if (a1 == null && a2 == null) {
            return -1;
        }
        if (a1 == null || a2 == null) {
            return 0;
        }
        int n1 = a1.length;
        int n2 = a2.length;
        int i = 0;
        if (len < 0) {
            len = n1 >= n2 ? n1 : n2;
        }
        for (i = 0; i < n1 && i < n2 && i < len; ++i) {
            if (a1[i] == a2[i]) continue;
            return i;
        }
        return i < len ? i : -1;
    }

    public static int diff(double[] a1, double[] a2) {
        return ListTools.diff(a1, a2, -1);
    }

    public static int diff(double[] a1, double[] a2, int len) {
        if (a1 == null && a2 == null) {
            return -1;
        }
        if (a1 == null || a2 == null) {
            return 0;
        }
        int n1 = a1.length;
        int n2 = a2.length;
        int i = 0;
        if (len < 0) {
            len = n1 >= n2 ? n1 : n2;
        }
        for (i = 0; i < n1 && i < n2 && i < len; ++i) {
            if (a1[i] == a2[i]) continue;
            return i;
        }
        return i < len ? i : -1;
    }

    public static <T> int diff(T[] a1, T[] a2) {
        return ListTools.diff(a1, a2, -1);
    }

    public static <T> int diff(T[] a1, T[] a2, int len) {
        if (a1 == null && a2 == null) {
            return -1;
        }
        if (a1 == null || a2 == null) {
            return 0;
        }
        int n1 = a1.length;
        int n2 = a2.length;
        int i = 0;
        if (len < 0) {
            len = n1 >= n2 ? n1 : n2;
        }
        for (i = 0; i < n1 && i < n2 && i < len; ++i) {
            if (a1[i].equals(a2[i])) continue;
            return i;
        }
        return i < len ? i : -1;
    }

    public static <T> T itemAt(Collection<T> c, int ndx, T dft) {
        if (c == null || ndx < 0 || ndx >= c.size()) {
            return dft;
        }
        if (c instanceof List) {
            return (T)((List)c).get(ndx);
        }
        for (T obj : c) {
            if (ndx-- != 0) continue;
            return obj;
        }
        return dft;
    }

    public static <T> T itemAt(T[] arry, int ndx, T dft) {
        if (arry == null || ndx < 0 || ndx >= arry.length) {
            return dft;
        }
        return arry[ndx];
    }

    public static byte itemAt(byte[] arry, int ndx, byte dft) {
        if (arry == null || ndx < 0 || ndx >= arry.length) {
            return dft;
        }
        return arry[ndx];
    }

    public static int itemAt(int[] arry, int ndx, int dft) {
        if (arry == null || ndx < 0 || ndx >= arry.length) {
            return dft;
        }
        return arry[ndx];
    }

    public static long itemAt(long[] arry, int ndx, long dft) {
        if (arry == null || ndx < 0 || ndx >= arry.length) {
            return dft;
        }
        return arry[ndx];
    }

    public static double itemAt(double[] arry, int ndx, double dft) {
        if (arry == null || ndx < 0 || ndx >= arry.length) {
            return dft;
        }
        return arry[ndx];
    }

    public static <T> int indexOf(Collection<T> list, T item) {
        if (list == null) {
            return -1;
        }
        if (list instanceof AbstractList) {
            return ((AbstractList)list).indexOf(item);
        }
        int index = 0;
        for (T listItem : list) {
            if (listItem == item) {
                return index;
            }
            if (listItem != null && listItem.equals(item)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public static int indexOfIgnoreCase(Collection<String> list, String item) {
        if (list == null) {
            return -1;
        }
        int index = 0;
        for (String listObj : list) {
            String listStr;
            String string = listStr = listObj != null ? listObj.toString() : null;
            if (listStr == item) {
                return index;
            }
            if (listStr != null && listStr.equalsIgnoreCase(item)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public static int indexOfIgnoreCase(String[] list, String item) {
        if (list == null) {
            return -1;
        }
        for (int i = 0; i < list.length; ++i) {
            if (list[i] == item) {
                return i;
            }
            if (list[i] == null || !list[i].equalsIgnoreCase(item)) continue;
            return i;
        }
        return -1;
    }

    public static <T> int indexOf(T[] list, T item) {
        return ListTools.indexOf(list, 0, -1, item);
    }

    public static <T> int indexOf(T[] list, int ofs, int len, T item) {
        if (list == null) {
            return -1;
        }
        int alen = list != null ? list.length : 0;
        ofs = ListTools._constrainOffset(ofs, alen);
        len = ListTools._constrainLength(ofs, len, alen);
        for (int i = ofs; i < ofs + len; ++i) {
            if (list[i] == item) {
                return i;
            }
            if (list[i] == null || !list[i].equals(item)) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(char[] list, char item) {
        if (list != null) {
            for (int i = 0; i < list.length; ++i) {
                if (list[i] != item) continue;
                return i;
            }
        }
        return -1;
    }

    public static int indexOf(byte[] list, byte item) {
        if (list != null) {
            for (int i = 0; i < list.length; ++i) {
                if (list[i] != item) continue;
                return i;
            }
        }
        return -1;
    }

    public static int indexOf(int[] list, int item) {
        if (list != null) {
            for (int i = 0; i < list.length; ++i) {
                if (list[i] != item) continue;
                return i;
            }
        }
        return -1;
    }

    public static int indexOf(long[] list, long item) {
        if (list != null) {
            for (int i = 0; i < list.length; ++i) {
                if (list[i] != item) continue;
                return i;
            }
        }
        return -1;
    }

    public static int indexOf(double[] list, double item, double epsilon) {
        if (list != null) {
            for (int i = 0; i < list.length; ++i) {
                if (!(item >= list[i] - epsilon) || !(item <= list[i] + epsilon)) continue;
                return i;
            }
        }
        return -1;
    }

    public static <T> boolean contains(Collection<T> list, T item) {
        return ListTools.indexOf(list, item) >= 0;
    }

    public static boolean containsIgnoreCase(Collection<String> list, String item) {
        return ListTools.indexOfIgnoreCase(list, item) >= 0;
    }

    public static boolean containsIgnoreCase(String[] list, String item) {
        return ListTools.indexOfIgnoreCase(list, item) >= 0;
    }

    public static <T> boolean contains(T[] list, T item) {
        return ListTools.indexOf(list, 0, -1, item) >= 0;
    }

    public static <T> boolean contains(T[] list, int ofs, int len, T item) {
        return ListTools.indexOf(list, ofs, len, item) >= 0;
    }

    public static boolean contains(char[] list, char item) {
        return ListTools.indexOf(list, item) >= 0;
    }

    public static boolean contains(byte[] list, byte item) {
        return ListTools.indexOf(list, item) >= 0;
    }

    public static boolean contains(int[] list, int item) {
        return ListTools.indexOf(list, item) >= 0;
    }

    public static boolean contains(long[] list, long item) {
        return ListTools.indexOf(list, item) >= 0;
    }

    public static boolean contains(double[] list, double item, double epsilon) {
        return ListTools.indexOf(list, item, epsilon) >= 0;
    }

    public static <K, V> boolean containsKey(Map<K, V> map, K key) {
        return map != null && map.containsKey(key);
    }

    public static <T> boolean isClassType(Collection<?> list, Class<T> type) {
        if (type == null || type == Object.class) {
            return true;
        }
        if (list == null) {
            return false;
        }
        for (Object obj : list) {
            if (obj == null || type.isAssignableFrom(obj.getClass())) continue;
            return false;
        }
        return true;
    }

    public static <T> AbstractList<T> toListWrapper(final T[] a) {
        return new AbstractList<T>(){

            @Override
            public T get(int ndx) {
                if (a == null || ndx < 0 || ndx >= a.length) {
                    throw new IndexOutOfBoundsException();
                }
                return a[ndx];
            }

            @Override
            public T set(int ndx, T item) {
                if (a == null || ndx < 0 || ndx >= a.length) {
                    throw new IndexOutOfBoundsException();
                }
                Object oldObj = a[ndx];
                a[ndx] = item;
                return oldObj;
            }

            @Override
            public int size() {
                return a != null ? a.length : 0;
            }
        };
    }

    public static <T> List<T> toList(T ... a) {
        return ListTools.toList(a, (List)null);
    }

    public static <T> List<T> toList(List<T> target, T ... a) {
        return ListTools.toList(a, target);
    }

    public static <T> List<T> toList(T[] a, List<T> target) {
        Vector<T> v = target != null ? target : new Vector<T>();
        int len = a != null ? a.length : 0;
        for (int i = 0; i < len; ++i) {
            v.add(a[i]);
        }
        return v;
    }

    public static <T> List<T> toList(T[] a, int ofs, int len, List<T> target) {
        Vector<T> v = target != null ? target : new Vector<T>();
        int alen = a != null ? a.length : 0;
        ofs = ListTools._constrainOffset(ofs, alen);
        len = ListTools._constrainLength(ofs, len, alen);
        for (int i = ofs; i < ofs + len; ++i) {
            v.add(a[i]);
        }
        return v;
    }

    public static <T> List<T> toList(Enumeration<T> e) {
        return ListTools.toList(e, (List)null);
    }

    public static <T> List<T> toList(Enumeration<T> e, List<T> target) {
        Vector<T> v;
        Vector<T> vector = v = target != null ? target : new Vector<T>();
        if (e != null) {
            while (e.hasMoreElements()) {
                v.add(e.nextElement());
            }
        }
        return v;
    }

    public static <T> List<T> toList(Iterator<T> i) {
        return ListTools.toList(i, (List)null);
    }

    public static <T> List<T> toList(Iterator<T> i, List<T> target) {
        Vector<T> v;
        Vector<T> vector = v = target != null ? target : new Vector<T>();
        if (i != null) {
            while (i.hasNext()) {
                v.add(i.next());
            }
        }
        return v;
    }

    public static <T> List<T> toList(Iterable<T> i) {
        return ListTools.toList(i, (List)null);
    }

    public static <T> List<T> toList(Iterable<T> i, List<T> target) {
        return ListTools.toList(i != null ? i.iterator() : null, target);
    }

    public static <T> List<T> toList(Set<T> s) {
        return ListTools.toList(s, (List)null);
    }

    public static <T> List<T> toList(Set<T> s, List<T> target) {
        return ListTools.toList(s != null ? s.iterator() : null, target);
    }

    public static List<String> toList(StringTokenizer st) {
        return ListTools.toList(st, (List<String>)null);
    }

    public static List<String> toList(StringTokenizer st, List<String> target) {
        Vector<String> v;
        Vector<String> vector = v = target != null ? target : new Vector<String>();
        if (st != null) {
            while (st.hasMoreTokens()) {
                v.add(st.nextToken());
            }
        }
        return v;
    }

    public static <T> List<T> toList(List<T> ls) {
        return ListTools.toList(ls, (List)null);
    }

    public static <T> List<T> toList(List<T> ls, List<T> target) {
        Vector<T> v;
        Vector<T> vector = v = target != null ? target : new Vector<T>();
        if (ls != null) {
            v.addAll(ls);
        }
        return v;
    }

    public static <T> T[] toArray(Enumeration<?> e, Class<T> type) {
        return ListTools.toArray(ListTools.toList(e), type);
    }

    public static Object[] toArray(Collection<?> list) {
        return ListTools.toArray(list, (Class)null);
    }

    public static <T> T[] toArray(Collection<?> list, Class<T> type) {
        if (type == null) {
            type = Object.class;
        }
        if (list != null) {
            Object[] array = (Object[])Array.newInstance(type, list.size());
            return list.toArray(array);
        }
        return (Object[])Array.newInstance(type, 0);
    }

    public static <T> T[] toArray(T[] arry, int ofs, int len) {
        if (arry != null) {
            int alen = arry.length;
            ofs = ListTools._constrainOffset(ofs, alen);
            len = ListTools._constrainLength(ofs, len, alen);
            Class<?> type = arry.getClass().getComponentType();
            Object[] newArry = (Object[])Array.newInstance(type, len);
            if (ofs < alen) {
                System.arraycopy(arry, ofs, newArry, 0, len);
            }
            return newArry;
        }
        return null;
    }

    public static byte[] toArray(byte[] arry, int ofs, int len) {
        if (arry != null) {
            int alen = arry.length;
            ofs = ListTools._constrainOffset(ofs, alen);
            len = ListTools._constrainLength(ofs, len, alen);
            byte[] newArry = new byte[len];
            if (ofs < alen) {
                System.arraycopy(arry, ofs, newArry, 0, len);
            }
            return newArry;
        }
        return null;
    }

    public static int[] toArray(int[] arry, int ofs, int len) {
        if (arry != null) {
            int alen = arry.length;
            ofs = ListTools._constrainOffset(ofs, alen);
            len = ListTools._constrainLength(ofs, len, alen);
            int[] newArry = new int[len];
            if (ofs < alen) {
                System.arraycopy(arry, ofs, newArry, 0, len);
            }
            return newArry;
        }
        return null;
    }

    public static long[] toArray(long[] arry, int ofs, int len) {
        if (arry != null) {
            int alen = arry.length;
            ofs = ListTools._constrainOffset(ofs, alen);
            len = ListTools._constrainLength(ofs, len, alen);
            long[] newArry = new long[len];
            if (ofs < alen) {
                System.arraycopy(arry, ofs, newArry, 0, len);
            }
            return newArry;
        }
        return null;
    }

    public static double[] toArray(double[] arry, int ofs, int len) {
        if (arry != null) {
            int alen = arry.length;
            ofs = ListTools._constrainOffset(ofs, alen);
            len = ListTools._constrainLength(ofs, len, alen);
            double[] newArry = new double[len];
            if (ofs < alen) {
                System.arraycopy(arry, ofs, newArry, 0, len);
            }
            return newArry;
        }
        return null;
    }

    public static <N extends Number> int[] toIntArray(Collection<N> list) {
        if (list != null) {
            int i = 0;
            int len = list.size();
            int[] arry = new int[len];
            for (Number n : list) {
                arry[i++] = n.intValue();
            }
            return arry;
        }
        return null;
    }

    public static <N extends Number> long[] toLongArray(Collection<N> list) {
        if (list != null) {
            int i = 0;
            int len = list.size();
            long[] arry = new long[len];
            for (Number n : list) {
                arry[i++] = n.longValue();
            }
            return arry;
        }
        return null;
    }

    public static <N extends Number> double[] toDoubleArray(Collection<N> list) {
        if (list != null) {
            int i = 0;
            int len = list.size();
            double[] arry = new double[len];
            for (Number n : list) {
                arry[i++] = n.doubleValue();
            }
            return arry;
        }
        return null;
    }

    public static String[] toStringArray(Object[] a) {
        if (a != null) {
            String[] v = new String[a.length];
            for (int i = 0; i < v.length; ++i) {
                v[i] = a[i] != null ? a[i].toString() : null;
            }
            return v;
        }
        return new String[0];
    }

    public static String[] toStringArray(Collection<?> list) {
        if (list != null) {
            String[] v = new String[list.size()];
            int i = 0;
            for (Object obj : list) {
                if (i >= v.length) break;
                v[i++] = obj != null ? obj.toString() : null;
            }
            return v;
        }
        return new String[0];
    }

    public static <T> Set<T> toSet(T ... a) {
        return ListTools.toSet(a, (Set)null);
    }

    public static <T> Set<T> toSet(Set<T> set, T ... a) {
        return ListTools.toSet(a, set);
    }

    public static <T> Set<T> toSet(T[] a, Set<T> set) {
        HashSet<T> v = set != null ? set : new HashSet<T>();
        int len = a != null ? a.length : 0;
        for (int i = 0; i < len; ++i) {
            v.add(a[i]);
        }
        return v;
    }

    public static <T> Set<T> toSet(T[] a, int ofs, int len, Set<T> set) {
        HashSet<T> v = set != null ? set : new HashSet<T>();
        int alen = a != null ? a.length : 0;
        ofs = ListTools._constrainOffset(ofs, alen);
        len = ListTools._constrainLength(ofs, len, alen);
        for (int i = ofs; i < ofs + len; ++i) {
            v.add(a[i]);
        }
        return v;
    }

    public static <T> Set<T> toSet(Collection<T> c) {
        return ListTools.toSet(c, (Set)null);
    }

    public static <T> Set<T> toSet(Collection<T> c, Set<T> set) {
        HashSet<T> v;
        HashSet<T> hashSet = v = set != null ? set : new HashSet<T>();
        if (c != null) {
            v.addAll(c);
        }
        return v;
    }

    public static Map<Object, Object> toMap(Object[][] arry) {
        return ListTools.toMap(arry, (Map<Object, Object>)null);
    }

    public static Map<Object, Object> toMap(Object[][] arry, Map<Object, Object> map) {
        OrderedMap<Object, Object> m;
        OrderedMap<Object, Object> orderedMap = m = map != null ? map : new OrderedMap<Object, Object>();
        if (arry != null) {
            for (int i = 0; i < arry.length; ++i) {
                if (arry[i].length < 2) continue;
                Object key = arry[i][0];
                Object val = arry[i][1];
                if (key == null || val == null) continue;
                m.put(key, val);
            }
        }
        return m;
    }

    public static Map<Object, Object> toMap(String keyMethod, Object[] arry) {
        return ListTools.toMap(keyMethod, arry, null);
    }

    public static Map<Object, Object> toMap(String keyMethod, Object[] arry, Map<Object, Object> map) {
        OrderedMap<Object, Object> m;
        OrderedMap<Object, Object> orderedMap = m = map != null ? map : new OrderedMap<Object, Object>();
        if (arry != null && keyMethod != null && !keyMethod.equals("")) {
            for (int i = 0; i < arry.length; ++i) {
                Object val = arry[i];
                if (val == null) continue;
                try {
                    MethodAction ma = new MethodAction(arry[i], keyMethod);
                    Object key = ma.invoke();
                    if (key == null) continue;
                    m.put(key, val);
                    continue;
                }
                catch (Throwable th) {
                    Print.logError("Error creating map: " + th, new Object[0]);
                }
            }
        }
        return m;
    }

    public static <T> List<T> add(List<T> list, T obj) {
        return ListTools.insert(list, obj, -1);
    }

    public static <T> T[] add(T[] list, T obj) {
        return ListTools.insert(list, obj, -1);
    }

    public static int[] add(int[] list, int obj) {
        return ListTools.insert(list, obj, -1);
    }

    public static long[] add(long[] list, long obj) {
        return ListTools.insert(list, obj, -1);
    }

    public static double[] add(double[] list, double obj) {
        return ListTools.insert(list, obj, -1);
    }

    public static <T> T[] joinArrays(T[] a1, T[] a2, T[] a3, T[] a4) {
        Object[] aa = new Object[]{a1, a2, a3, a4};
        Class<?> type = null;
        int size = 0;
        for (int i = 0; i < aa.length; ++i) {
            if (aa[i] == null) continue;
            Object[] A = (Object[])aa[i];
            size += A.length;
            if (type != null) continue;
            type = A.getClass().getComponentType();
        }
        if (type == null) {
            return null;
        }
        Object[] array = (Object[])Array.newInstance(type, size);
        int ndx = 0;
        for (int i = 0; i < aa.length; ++i) {
            if (aa[i] == null) continue;
            Object[] A = (Object[])aa[i];
            System.arraycopy(A, 0, array, ndx, A.length);
            ndx += A.length;
        }
        return array;
    }

    public static <T> T[] joinArrays(T[] a1, T[] a2, T[] a3) {
        return ListTools.joinArrays(a1, a2, a3, (Object[])null);
    }

    public static <T> T[] joinArrays(T[] a1, T[] a2) {
        return ListTools.joinArrays(a1, a2, (Object[])null, (Object[])null);
    }

    public static double[] joinArrays(double[] a1, double[] a2, double[] a3, double[] a4) {
        Object[] aa = new Object[]{a1, a2, a3, a4};
        Class<?> type = null;
        int size = 0;
        for (int i = 0; i < aa.length; ++i) {
            if (aa[i] == null) continue;
            double[] A = (double[])aa[i];
            size += A.length;
            if (type != null) continue;
            type = A.getClass().getComponentType();
        }
        if (type == null) {
            return null;
        }
        double[] array = (double[])Array.newInstance(type, size);
        int ndx = 0;
        for (int i = 0; i < aa.length; ++i) {
            if (aa[i] == null) continue;
            double[] A = (double[])aa[i];
            System.arraycopy(A, 0, array, ndx, A.length);
            ndx += A.length;
        }
        return array;
    }

    public static double[] joinArrays(double[] a1, double[] a2, double[] a3) {
        return ListTools.joinArrays(a1, a2, a3, (double[])null);
    }

    public static double[] joinArrays(double[] a1, double[] a2) {
        return ListTools.joinArrays(a1, a2, (double[])null, (double[])null);
    }

    public static long[] joinArrays(long[] a1, long[] a2, long[] a3, long[] a4) {
        Object[] aa = new Object[]{a1, a2, a3, a4};
        Class<?> type = null;
        int size = 0;
        for (int i = 0; i < aa.length; ++i) {
            if (aa[i] == null) continue;
            long[] A = (long[])aa[i];
            size += A.length;
            if (type != null) continue;
            type = A.getClass().getComponentType();
        }
        if (type == null) {
            return null;
        }
        long[] array = (long[])Array.newInstance(type, size);
        int ndx = 0;
        for (int i = 0; i < aa.length; ++i) {
            if (aa[i] == null) continue;
            long[] A = (long[])aa[i];
            System.arraycopy(A, 0, array, ndx, A.length);
            ndx += A.length;
        }
        return array;
    }

    public static long[] joinArrays(long[] a1, long[] a2, long[] a3) {
        return ListTools.joinArrays(a1, a2, a3, (long[])null);
    }

    public static long[] joinArrays(long[] a1, long[] a2) {
        return ListTools.joinArrays(a1, a2, (long[])null, (long[])null);
    }

    public static int[] joinArrays(int[] a1, int[] a2, int[] a3, int[] a4) {
        Object[] aa = new Object[]{a1, a2, a3, a4};
        Class<?> type = null;
        int size = 0;
        for (int i = 0; i < aa.length; ++i) {
            if (aa[i] == null) continue;
            int[] A = (int[])aa[i];
            size += A.length;
            if (type != null) continue;
            type = A.getClass().getComponentType();
        }
        if (type == null) {
            return null;
        }
        int[] array = (int[])Array.newInstance(type, size);
        int ndx = 0;
        for (int i = 0; i < aa.length; ++i) {
            if (aa[i] == null) continue;
            int[] A = (int[])aa[i];
            System.arraycopy(A, 0, array, ndx, A.length);
            ndx += A.length;
        }
        return array;
    }

    public static int[] joinArrays(int[] a1, int[] a2, int[] a3) {
        return ListTools.joinArrays(a1, a2, a3, null);
    }

    public static int[] joinArrays(int[] a1, int[] a2) {
        return ListTools.joinArrays(a1, a2, null, null);
    }

    public static <T> List<T> insert(List<T> list, T obj, int ndx) {
        if (list != null) {
            list.add(ndx, obj);
        }
        return list;
    }

    public static <T> T[] insert(T[] list, T obj, int index) {
        if (list != null) {
            int maxLen;
            int ndx = index > list.length || index < 0 ? list.length : index;
            Class<?> type = list.getClass().getComponentType();
            int size = list.length > ndx ? list.length + 1 : ndx + 1;
            Object[] array = (Object[])Array.newInstance(type, size);
            if (ndx > 0) {
                maxLen = list.length >= ndx ? ndx : list.length;
                System.arraycopy(list, 0, array, 0, maxLen);
            }
            array[ndx] = obj;
            if (ndx < list.length) {
                maxLen = list.length - ndx;
                System.arraycopy(list, ndx, array, ndx + 1, maxLen);
            }
            return array;
        }
        return null;
    }

    public static int[] insert(int[] list, int obj, int index) {
        if (list != null) {
            int maxLen;
            int ndx = index > list.length || index < 0 ? list.length : index;
            int size = list.length > ndx ? list.length + 1 : ndx + 1;
            int[] array = new int[size];
            if (ndx > 0) {
                maxLen = list.length >= ndx ? ndx : list.length;
                System.arraycopy(list, 0, array, 0, maxLen);
            }
            array[ndx] = obj;
            if (ndx < list.length) {
                maxLen = list.length - ndx;
                System.arraycopy(list, ndx, array, ndx + 1, maxLen);
            }
            return array;
        }
        return null;
    }

    public static long[] insert(long[] list, long obj, int index) {
        if (list != null) {
            int maxLen;
            int ndx = index > list.length || index < 0 ? list.length : index;
            int size = list.length > ndx ? list.length + 1 : ndx + 1;
            long[] array = new long[size];
            if (ndx > 0) {
                maxLen = list.length >= ndx ? ndx : list.length;
                System.arraycopy(list, 0, array, 0, maxLen);
            }
            array[ndx] = obj;
            if (ndx < list.length) {
                maxLen = list.length - ndx;
                System.arraycopy(list, ndx, array, ndx + 1, maxLen);
            }
            return array;
        }
        return null;
    }

    public static double[] insert(double[] list, double obj, int index) {
        if (list != null) {
            int maxLen;
            int ndx = index > list.length || index < 0 ? list.length : index;
            int size = list.length > ndx ? list.length + 1 : ndx + 1;
            double[] array = new double[size];
            if (ndx > 0) {
                maxLen = list.length >= ndx ? ndx : list.length;
                System.arraycopy(list, 0, array, 0, maxLen);
            }
            array[ndx] = obj;
            if (ndx < list.length) {
                maxLen = list.length - ndx;
                System.arraycopy(list, ndx, array, ndx + 1, maxLen);
            }
            return array;
        }
        return null;
    }

    public static <T> List<T> remove(List<T> list, int ndx) {
        if (list != null) {
            list.remove(ndx);
        }
        return list;
    }

    public static <T> T[] remove(T[] list, int ndx) {
        if (list != null && ndx >= 0 && ndx < list.length) {
            Class<?> type = list.getClass().getComponentType();
            Object[] array = (Object[])Array.newInstance(type, list.length - 1);
            if (ndx > 0) {
                System.arraycopy(list, 0, array, 0, ndx);
            }
            if (ndx < list.length - 1) {
                System.arraycopy(list, ndx + 1, array, ndx, list.length - ndx - 1);
            }
            return array;
        }
        return null;
    }

    public static int[] remove(int[] list, int ndx) {
        if (list != null && ndx >= 0 && ndx < list.length) {
            int[] array = new int[list.length - 1];
            if (ndx > 0) {
                System.arraycopy(list, 0, array, 0, ndx);
            }
            if (ndx < list.length - 1) {
                System.arraycopy(list, ndx + 1, array, ndx, list.length - ndx - 1);
            }
            return array;
        }
        return null;
    }

    public static long[] remove(long[] list, int ndx) {
        if (list != null && ndx >= 0 && ndx < list.length) {
            long[] array = new long[list.length - 1];
            if (ndx > 0) {
                System.arraycopy(list, 0, array, 0, ndx);
            }
            if (ndx < list.length - 1) {
                System.arraycopy(list, ndx + 1, array, ndx, list.length - ndx - 1);
            }
            return array;
        }
        return null;
    }

    public static double[] remove(double[] list, int ndx) {
        if (list != null && ndx >= 0 && ndx < list.length) {
            double[] array = new double[list.length - 1];
            if (ndx > 0) {
                System.arraycopy(list, 0, array, 0, ndx);
            }
            if (ndx < list.length - 1) {
                System.arraycopy(list, ndx + 1, array, ndx, list.length - ndx - 1);
            }
            return array;
        }
        return null;
    }

    public static <T> Iterator<T> toIterator(Iterable<T> i) {
        if (i != null) {
            return i.iterator();
        }
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return false;
            }

            @Override
            public T next() {
                throw new NoSuchElementException("Null Iterable");
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static <T> Iterator<T> toIterator(final Enumeration<T> e) {
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return e != null ? e.hasMoreElements() : false;
            }

            @Override
            public T next() {
                if (e != null) {
                    return e.nextElement();
                }
                throw new NoSuchElementException("Null Enumeration");
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static <T> Iterator<T> toIterator(final T[] list) {
        return new Iterator<T>(){
            private int ndx = 0;

            @Override
            public boolean hasNext() {
                return list != null && this.ndx < list.length;
            }

            @Override
            public T next() {
                if (list != null && this.ndx < list.length) {
                    return list[this.ndx++];
                }
                throw new NoSuchElementException("end of array");
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static <T> List<T> sort(List<T> list, Comparator<? super T> comp) {
        return ListTools.sort(list, comp, true);
    }

    public static <T> List<T> sort(List<T> list, Comparator<? super T> comp, boolean forwardOrder) {
        if (list != null) {
            Comparator<? super T> c = comp;
            c = c == null ? (list.size() > 0 && list.get(0) instanceof Number ? new NumberComparator<T>(forwardOrder) : new StringComparator<T>(forwardOrder)) : (forwardOrder ? comp : new ReverseOrderComparator<T>(comp));
            Collections.sort(list, c);
        }
        return list;
    }

    public static <T> T[] sort(T[] list, Comparator<? super T> comp) {
        return ListTools.sort(list, comp, true);
    }

    public static <T> T[] sort(T[] list, Comparator<? super T> comp, boolean forwardOrder) {
        if (list != null) {
            Comparator<? super T> c = comp;
            c = c == null ? (list.length > 0 && list[0] instanceof Number ? new NumberComparator<T>(forwardOrder) : new StringComparator<T>(forwardOrder)) : (forwardOrder ? comp : new ReverseOrderComparator<T>(comp));
            Arrays.sort(list, c);
        }
        return list;
    }

    public static String[] sort(String[] list) {
        return ListTools.sort(list, new StringComparator(), true);
    }

    public static String[] sort(String[] list, boolean forwardOrder) {
        return ListTools.sort(list, new StringComparator(), forwardOrder);
    }

    public static <T> T[] reverseOrder(T[] list) {
        if (list != null && list.length > 1) {
            int len = list.length / 2;
            for (int i = 0; i < len; ++i) {
                int i2 = list.length - 1 - i;
                T obj = list[i];
                list[i] = list[i2];
                list[i2] = obj;
            }
        }
        return list;
    }

    public static <T> List<T> reverseOrder(List<T> list) {
        if (list != null) {
            Collections.reverse(list);
        }
        return list;
    }

    public static <T> void swap(List<T> list, int x, int y) {
        if (x != y) {
            T temp = list.set(x, list.get(y));
            list.set(y, temp);
        }
    }

    public static <T> void randomSwap(List<T> list, int x, Random r) {
        if (r != null) {
            int y = r.nextInt(x + 1);
            ListTools.swap(list, x, y);
        }
    }

    public static <T> void swap(T[] list, int x, int y) {
        if (x != y) {
            T temp = list[x];
            list[x] = list[y];
            list[y] = temp;
        }
    }

    public static <T> void randomSwap(T[] list, int x, Random r) {
        if (r != null) {
            int y = r.nextInt(x + 1);
            ListTools.swap(list, x, y);
        }
    }

    public static void swap(char[] list, int x, int y) {
        if (x != y) {
            char temp = list[x];
            list[x] = list[y];
            list[y] = temp;
        }
    }

    public static void randomSwap(char[] list, int x, Random r) {
        if (r != null) {
            int y = r.nextInt(x + 1);
            ListTools.swap(list, x, y);
        }
    }

    public static void swap(byte[] list, int x, int y) {
        if (x != y) {
            byte temp = list[x];
            list[x] = list[y];
            list[y] = temp;
        }
    }

    public static void randomSwap(byte[] list, int x, Random r) {
        if (r != null) {
            int y = r.nextInt(x + 1);
            ListTools.swap(list, x, y);
        }
    }

    public static void swap(int[] list, int x, int y) {
        if (x != y) {
            int temp = list[x];
            list[x] = list[y];
            list[y] = temp;
        }
    }

    public static void randomSwap(int[] list, int x, Random r) {
        if (r != null) {
            int y = r.nextInt(x + 1);
            ListTools.swap(list, x, y);
        }
    }

    public static <T> T[] shuffle(T[] list, BigInteger bigSeed) {
        if (list != null && bigSeed != null) {
            while (bigSeed.compareTo(BigInteger.ZERO) != 0) {
                ListTools.shuffle(list, bigSeed.longValue() & RANDOM_SEED_MASK);
                bigSeed = bigSeed.shiftRight(48);
            }
        }
        return list;
    }

    public static <T> T[] shuffle(T[] list, long seed) {
        if (list != null && seed != 0L) {
            ListTools.shuffle(list, new Random(seed & RANDOM_SEED_MASK));
            if ((seed & (RANDOM_SEED_MASK ^ 0xFFFFFFFFFFFFFFFFL)) != 0L) {
                ListTools.shuffle(list, new Random(seed >> 48 & 0xFFFFL));
            }
        }
        return list;
    }

    public static <T> T[] shuffle(T[] list, Random rand) {
        if (list != null && rand != null) {
            for (int x = list.length - 1; x > 0; --x) {
                ListTools.randomSwap(list, x, rand);
            }
        }
        return list;
    }

    public static char[] shuffle(char[] list, BigInteger bigSeed) {
        if (list != null && bigSeed != null) {
            while (bigSeed.compareTo(BigInteger.ZERO) != 0) {
                ListTools.shuffle(list, bigSeed.longValue() & RANDOM_SEED_MASK);
                bigSeed = bigSeed.shiftRight(48);
            }
        }
        return list;
    }

    public static char[] shuffle(char[] list, long seed) {
        if (list != null && seed != 0L) {
            ListTools.shuffle(list, new Random(seed & RANDOM_SEED_MASK));
            if ((seed & (RANDOM_SEED_MASK ^ 0xFFFFFFFFFFFFFFFFL)) != 0L) {
                ListTools.shuffle(list, new Random(seed >> 48 & 0xFFFFL));
            }
        }
        return list;
    }

    public static char[] shuffle(char[] list, Random rand) {
        if (list != null && rand != null) {
            for (int x = list.length - 1; x > 0; --x) {
                ListTools.randomSwap(list, x, rand);
            }
        }
        return list;
    }

    public static String shuffle(String list, BigInteger bigSeed) {
        if (list != null && bigSeed != null) {
            list = new String(ListTools.shuffle(list.toCharArray(), bigSeed));
        }
        return list;
    }

    public static String shuffle(String list, long seed) {
        if (list != null && seed != 0L) {
            list = new String(ListTools.shuffle(list.toCharArray(), seed));
        }
        return list;
    }

    public static String shuffle(String list, Random rand) {
        if (list != null && rand != null) {
            list = new String(ListTools.shuffle(list.toCharArray(), rand));
        }
        return list;
    }

    public static byte[] shuffle(byte[] list, BigInteger bigSeed) {
        if (list != null && bigSeed != null) {
            while (bigSeed.compareTo(BigInteger.ZERO) != 0) {
                ListTools.shuffle(list, bigSeed.longValue() & RANDOM_SEED_MASK);
                bigSeed = bigSeed.shiftRight(48);
            }
        }
        return list;
    }

    public static byte[] shuffle(byte[] list, long seed) {
        if (list != null && seed != 0L) {
            ListTools.shuffle(list, new Random(seed & RANDOM_SEED_MASK));
            if ((seed & (RANDOM_SEED_MASK ^ 0xFFFFFFFFFFFFFFFFL)) != 0L) {
                ListTools.shuffle(list, new Random(seed >> 48 & 0xFFFFL));
            }
        }
        return list;
    }

    public static byte[] shuffle(byte[] list, Random rand) {
        if (list != null && rand != null) {
            for (int x = list.length - 1; x > 0; --x) {
                ListTools.randomSwap(list, x, rand);
            }
        }
        return list;
    }

    public static int[] shuffle(int[] list, BigInteger bigSeed) {
        if (list != null && bigSeed != null) {
            while (bigSeed.compareTo(BigInteger.ZERO) != 0) {
                ListTools.shuffle(list, bigSeed.longValue() & RANDOM_SEED_MASK);
                bigSeed = bigSeed.shiftRight(48);
            }
        }
        return list;
    }

    public static int[] shuffle(int[] list, long seed) {
        if (list != null && seed != 0L) {
            ListTools.shuffle(list, new Random(seed & RANDOM_SEED_MASK));
            if ((seed & (RANDOM_SEED_MASK ^ 0xFFFFFFFFFFFFFFFFL)) != 0L) {
                ListTools.shuffle(list, new Random(seed >> 48 & 0xFFFFL));
            }
        }
        return list;
    }

    public static int[] shuffle(int[] list, Random rand) {
        if (list != null && rand != null) {
            for (int x = list.length - 1; x > 0; --x) {
                ListTools.randomSwap(list, x, rand);
            }
        }
        return list;
    }

    public static class CollectionProxy<E>
    implements Collection<E> {
        private Collection<E> delegate = null;

        public CollectionProxy(Collection<E> c) {
            this.delegate = c;
        }

        @Override
        public boolean add(E o) {
            return this.delegate.add(o);
        }

        @Override
        public boolean addAll(Collection<? extends E> c) {
            return this.delegate.addAll(c);
        }

        @Override
        public void clear() {
            this.delegate.clear();
        }

        @Override
        public boolean contains(Object o) {
            return this.delegate.contains(o);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.delegate.containsAll(c);
        }

        @Override
        public boolean equals(Object o) {
            if (o instanceof CollectionProxy) {
                return ((Object)this.delegate).equals(((CollectionProxy)o).delegate);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return ((Object)this.delegate).hashCode();
        }

        @Override
        public boolean isEmpty() {
            return this.delegate.isEmpty();
        }

        @Override
        public Iterator<E> iterator() {
            return this.delegate.iterator();
        }

        @Override
        public boolean remove(Object o) {
            return this.delegate.remove(o);
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            return this.delegate.removeAll(c);
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            return this.delegate.retainAll(c);
        }

        @Override
        public int size() {
            return this.delegate.size();
        }

        @Override
        public Object[] toArray() {
            return this.delegate.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.delegate.toArray(a);
        }
    }

    public static class ReverseOrderComparator<T>
    implements Comparator<T> {
        private Comparator<? super T> otherComp = null;

        public ReverseOrderComparator(Comparator<? super T> comp) {
            this.otherComp = comp != null ? comp : new StringComparator<T>();
        }

        @Override
        public int compare(T o1, T o2) {
            int compVal = this.otherComp.compare(o1, o2);
            if (compVal > 0) {
                return -1;
            }
            if (compVal < 0) {
                return 1;
            }
            return 0;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof ReverseOrderComparator) {
                ReverseOrderComparator descComp = (ReverseOrderComparator)obj;
                return ((Object)this.otherComp).equals(descComp.otherComp);
            }
            return false;
        }
    }

    public static class NameComparator<T>
    extends StringComparator<T> {
        public NameComparator() {
        }

        public NameComparator(boolean ascending) {
            super(ascending);
        }

        public NameComparator(boolean ascending, boolean ignoreCase) {
            super(ascending, ignoreCase);
        }

        @Override
        public String getObjectString(Object obj) {
            if (obj != null) {
                try {
                    MethodAction ma = new MethodAction(obj, "getName");
                    return (String)ma.invoke();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return this.getDefaultString(obj);
        }
    }

    public static class StringComparator<T>
    implements Comparator<T> {
        private boolean ascending = true;
        private boolean ignoreCase = false;

        public StringComparator() {
            this(true, false);
        }

        public StringComparator(boolean ascending) {
            this(ascending, false);
        }

        public StringComparator(boolean ascending, boolean ignoreCase) {
            this.ascending = ascending;
            this.ignoreCase = ignoreCase;
        }

        @Override
        public int compare(T o1, T o2) {
            String s1 = this.getObjectString(o1);
            String s2 = this.getObjectString(o2);
            if (this.ignoreCase) {
                s1 = s1.toLowerCase();
                s2 = s2.toLowerCase();
            }
            return this.ascending ? s1.compareTo(s2) : s2.compareTo(s1);
        }

        public String getObjectString(Object obj) {
            return obj != null ? obj.toString() : this.getDefaultString(obj);
        }

        public String getDefaultString(Object obj) {
            return "";
        }

        @Override
        public boolean equals(Object other) {
            if (other instanceof StringComparator) {
                StringComparator sc = (StringComparator)other;
                return this.ascending == sc.ascending && this.ignoreCase == sc.ignoreCase;
            }
            return false;
        }
    }

    public static class NumberComparator<T>
    implements Comparator<T> {
        private boolean ascending = true;
        private boolean ignoreCase = false;

        public NumberComparator() {
            this(true, false);
        }

        public NumberComparator(boolean ascending) {
            this(ascending, false);
        }

        public NumberComparator(boolean ascending, boolean ignoreCaseIfString) {
            this.ascending = ascending;
            this.ignoreCase = ignoreCaseIfString;
        }

        @Override
        public int compare(T o1, T o2) {
            String s2;
            if (o1 instanceof Number && o2 instanceof Number) {
                double n2;
                double n1 = ((Number)o1).doubleValue();
                if (n1 == (n2 = ((Number)o2).doubleValue())) {
                    return 0;
                }
                if (this.ascending) {
                    return n1 < n2 ? -1 : 1;
                }
                return n2 < n1 ? -1 : 1;
            }
            if (o1 instanceof Number != o2 instanceof Number) {
                return o1 instanceof Number ? -1 : 1;
            }
            String s1 = o1 != null ? o1.toString() : "";
            String string = s2 = o2 != null ? o2.toString() : "";
            if (this.ignoreCase) {
                s1 = s1.toLowerCase();
                s2 = s2.toLowerCase();
            }
            return this.ascending ? s1.compareTo(s2) : s2.compareTo(s1);
        }

        @Override
        public boolean equals(Object other) {
            if (other instanceof NumberComparator) {
                NumberComparator sc = (NumberComparator)other;
                return this.ascending == sc.ascending && this.ignoreCase == sc.ignoreCase;
            }
            return false;
        }
    }
}

