/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Vector;
import org.opengts.util.FileTools;
import org.opengts.util.ListTools;
import org.opengts.util.Print;
import org.opengts.util.StringTools;

public class JSON {
    private static final String INDENT = "   ";
    private static final boolean CASE_SENSITIVE = false;
    private _Object object = null;

    private static boolean NameEquals(String n1, String n2) {
        if (n1 == null || n2 == null) {
            return false;
        }
        return n1.equalsIgnoreCase(n2);
    }

    public static String parse_Comment(String v, JSONParsingContext context) throws JSONParsingException {
        char ch;
        if (context == null) {
            context = new JSONParsingContext();
        }
        int len = StringTools.length(v);
        String val = null;
        while (context.getIndex() < len && Character.isWhitespace(ch = v.charAt(context.getIndex()))) {
            context.incrementIndex();
            if (ch != '\n') continue;
            context.incrementLine();
        }
        int startLine = context.getLine();
        int startIndex = context.getIndex();
        if (startIndex + 2 >= len) {
            throw new JSONParsingException("Overflow", context);
        }
        if (v.charAt(startIndex) != '/' || v.charAt(startIndex + 1) != '*') {
            throw new JSONParsingException("Invalid beginning of comment", context);
        }
        context.incrementIndex(2);
        StringBuffer comment = new StringBuffer();
        while (context.getIndex() < len) {
            char ch2 = v.charAt(context.getIndex());
            if (Character.isWhitespace(ch2)) {
                context.incrementIndex();
                if (ch2 == '\n') {
                    context.incrementLine();
                }
                comment.append(ch2);
                continue;
            }
            if (ch2 == '*') {
                context.incrementIndex();
                int ndx = context.getIndex();
                if (ndx >= len) {
                    throw new JSONParsingException("Overflow", context);
                }
                if (v.charAt(ndx) == '/') {
                    context.incrementIndex();
                    break;
                }
                comment.append(ch2);
                continue;
            }
            comment.append(ch2);
            context.incrementIndex();
        }
        val = comment.toString().trim();
        return val;
    }

    public static _Object parse_Object(String v) throws JSONParsingException {
        return JSON.parse_Object(v, new JSONParsingContext());
    }

    public static _Object parse_Object(String v, JSONParsingContext context) throws JSONParsingException {
        if (context == null) {
            context = new JSONParsingContext();
        }
        int len = StringTools.length(v);
        _Object obj = null;
        while (context.getIndex() < len) {
            char ch = v.charAt(context.getIndex());
            if (Character.isWhitespace(ch)) {
                context.incrementIndex();
                if (ch != '\n') continue;
                context.incrementLine();
                continue;
            }
            if (ch == '/') {
                String comment = JSON.parse_Comment(v, context);
                continue;
            }
            if (ch == '{') {
                if (obj != null) {
                    throw new JSONParsingException("Object already started", context);
                }
                context.incrementIndex();
                obj = new _Object();
                continue;
            }
            if (ch == '\"') {
                if (obj == null) {
                    throw new JSONParsingException("No start of Object", context);
                }
                _KeyValue kv = JSON.parse_KeyValue(v, context);
                if (kv == null) {
                    throw new JSONParsingException("Invalid KeyValue ...", context);
                }
                obj.add(kv);
                continue;
            }
            if (ch == ',') {
                context.incrementIndex();
                continue;
            }
            if (ch == '}') {
                context.incrementIndex();
                break;
            }
            throw new JSONParsingException("Invalid JSON syntax ...", context);
        }
        return obj;
    }

    public static _KeyValue parse_KeyValue(String v, JSONParsingContext context) throws JSONParsingException {
        if (context == null) {
            context = new JSONParsingContext();
        }
        int len = StringTools.length(v);
        _KeyValue kv = null;
        String key = null;
        boolean colon = false;
        while (context.getIndex() < len) {
            char ch = v.charAt(context.getIndex());
            if (Character.isWhitespace(ch)) {
                context.incrementIndex();
                if (ch != '\n') continue;
                context.incrementLine();
                continue;
            }
            if (ch == '/') {
                String comment = JSON.parse_Comment(v, context);
                continue;
            }
            if (!colon && ch == '\"') {
                key = JSON.parse_String(v, context);
                if (key != null) continue;
                throw new JSONParsingException("Invalid key String", context);
            }
            if (ch == ':') {
                if (colon) {
                    throw new JSONParsingException("More than one ':'", context);
                }
                if (key == null) {
                    throw new JSONParsingException("Key not defined", context);
                }
                context.incrementIndex();
                colon = true;
                continue;
            }
            _Value val = JSON.parse_Value(v, context);
            if (val == null) {
                throw new JSONParsingException("Invalid value", context);
            }
            kv = new _KeyValue(key, val);
            break;
        }
        return kv;
    }

    public static _Value parse_Value(String v, JSONParsingContext context) throws JSONParsingException {
        if (context == null) {
            context = new JSONParsingContext();
        }
        int len = StringTools.length(v);
        _Value val = null;
        while (context.getIndex() < len) {
            char ch = v.charAt(context.getIndex());
            if (Character.isWhitespace(ch)) {
                context.incrementIndex();
                if (ch != '\n') continue;
                context.incrementLine();
                continue;
            }
            if (ch == '/') {
                String comment = JSON.parse_Comment(v, context);
                continue;
            }
            if (ch == '\"') {
                String sval = JSON.parse_String(v, context);
                if (sval == null) {
                    throw new JSONParsingException("Invalid String value", context);
                }
                val = new _Value(sval);
                break;
            }
            if (ch == '-' || ch == '+' || Character.isDigit(ch)) {
                Number num = JSON.parse_Number(v, context);
                if (num == null) {
                    throw new JSONParsingException("Invalid Number value", context);
                }
                if (num instanceof Double) {
                    val = new _Value((Double)num);
                    break;
                }
                if (num instanceof Integer) {
                    val = new _Value((Integer)num);
                    break;
                }
                if (num instanceof Long) {
                    val = new _Value((Long)num);
                    break;
                }
                throw new JSONParsingException("Unsupported Number type: " + StringTools.className(num), context);
            }
            if (ch == 't') {
                context.incrementIndex();
                int ndx = context.getIndex();
                if (ndx + 2 >= len) {
                    throw new JSONParsingException("Overflow", context);
                }
                if (v.charAt(ndx) == 'r' && v.charAt(ndx + 1) == 'u' && v.charAt(ndx + 2) == 'e') {
                    context.incrementIndex(3);
                    val = new _Value(Boolean.TRUE);
                    break;
                }
                throw new JSONParsingException("Invalid Boolean 'true'", context);
            }
            if (ch == 'f') {
                context.incrementIndex();
                int ndx = context.getIndex();
                if (ndx + 3 >= len) {
                    throw new JSONParsingException("Overflow", context);
                }
                if (v.charAt(ndx) == 'a' && v.charAt(ndx + 1) == 'l' && v.charAt(ndx + 2) == 's' && v.charAt(ndx + 3) == 'e') {
                    context.incrementIndex(4);
                    val = new _Value(Boolean.FALSE);
                    break;
                }
                throw new JSONParsingException("Invalid Boolean 'false'", context);
            }
            if (ch == 'n') {
                context.incrementIndex();
                int ndx = context.getIndex();
                if (ndx + 2 >= len) {
                    throw new JSONParsingException("Overflow", context);
                }
                if (v.charAt(ndx) == 'u' && v.charAt(ndx + 1) == 'l' && v.charAt(ndx + 2) == 'l') {
                    context.incrementIndex(3);
                    val = new _Value((_Object)null);
                    break;
                }
                throw new JSONParsingException("Invalid 'null'", context);
            }
            if (ch == '[') {
                _Array array = JSON.parse_Array(v, context);
                if (array == null) {
                    throw new JSONParsingException("Invalid array", context);
                }
                val = new _Value(array);
                break;
            }
            if (ch == '{') {
                _Object obj = JSON.parse_Object(v, context);
                if (obj == null) {
                    throw new JSONParsingException("Invalid object", context);
                }
                val = new _Value(obj);
                break;
            }
            throw new JSONParsingException("Invalid character", context);
        }
        return val;
    }

    public static _Array parse_Array(String v, JSONParsingContext context) throws JSONParsingException {
        if (context == null) {
            context = new JSONParsingContext();
        }
        int len = StringTools.length(v);
        _Array array = null;
        while (context.getIndex() < len) {
            _Value val;
            char ch = v.charAt(context.getIndex());
            if (Character.isWhitespace(ch)) {
                context.incrementIndex();
                if (ch != '\n') continue;
                context.incrementLine();
                continue;
            }
            if (ch == '/') {
                String comment = JSON.parse_Comment(v, context);
                continue;
            }
            if (ch == '[') {
                if (array == null) {
                    context.incrementIndex();
                    array = new _Array();
                    continue;
                }
                val = JSON.parse_Value(v, context);
                if (val == null) {
                    throw new JSONParsingException("Invalid Value", context);
                }
                array.add(val);
                continue;
            }
            if (ch == ',') {
                context.incrementIndex();
                continue;
            }
            if (ch == ']') {
                context.incrementIndex();
                break;
            }
            val = JSON.parse_Value(v, context);
            if (val == null) {
                throw new JSONParsingException("Invalid Value", context);
            }
            array.add(val);
        }
        return array;
    }

    public static String parse_String(String v, JSONParsingContext context) throws JSONParsingException {
        if (context == null) {
            context = new JSONParsingContext();
        }
        int len = StringTools.length(v);
        String val = null;
        while (context.getIndex() < len) {
            char ch = v.charAt(context.getIndex());
            if (Character.isWhitespace(ch)) {
                context.incrementIndex();
                if (ch != '\n') continue;
                context.incrementLine();
                continue;
            }
            if (ch == '/') {
                String comment = JSON.parse_Comment(v, context);
                continue;
            }
            if (ch == '\"') {
                context.incrementIndex();
                StringBuffer sb = new StringBuffer();
                block12: while (true) {
                    if ((ch = v.charAt(context.getIndex())) == '\\') {
                        context.incrementIndex();
                        if (context.getIndex() >= len) {
                            throw new JSONParsingException("Overflow", context);
                        }
                        ch = v.charAt(context.getIndex());
                        context.incrementIndex();
                        switch (ch) {
                            case '\"': {
                                sb.append('\"');
                                continue block12;
                            }
                            case '\\': {
                                sb.append('\\');
                                continue block12;
                            }
                            case '/': {
                                sb.append('/');
                                continue block12;
                            }
                            case 'b': {
                                sb.append('\b');
                                continue block12;
                            }
                            case 'f': {
                                sb.append('\f');
                                continue block12;
                            }
                            case 'n': {
                                sb.append('\n');
                                continue block12;
                            }
                            case 'r': {
                                sb.append('\r');
                                continue block12;
                            }
                            case 't': {
                                sb.append('\t');
                                continue block12;
                            }
                            case 'u': {
                                int ndx = context.getIndex();
                                if (ndx + 4 >= len) {
                                    throw new JSONParsingException("Overflow", context);
                                }
                                String hex = v.substring(ndx, ndx + 4);
                                context.incrementIndex(4);
                                continue block12;
                            }
                        }
                        sb.append(ch);
                        continue;
                    }
                    if (ch == '\"') break;
                    sb.append(ch);
                    context.incrementIndex();
                }
                context.incrementIndex();
                val = sb.toString();
                break;
            }
            throw new JSONParsingException("Missing initial String quote", context);
        }
        return val;
    }

    public static Number parse_Number(String v, JSONParsingContext context) throws JSONParsingException {
        if (context == null) {
            context = new JSONParsingContext();
        }
        int len = StringTools.length(v);
        Number val = null;
        while (context.getIndex() < len) {
            char ch = v.charAt(context.getIndex());
            if (Character.isWhitespace(ch)) {
                context.incrementIndex();
                if (ch != '\n') continue;
                context.incrementLine();
                continue;
            }
            if (ch == '/') {
                String comment = JSON.parse_Comment(v, context);
                continue;
            }
            if (ch == '-' || ch == '+' || Character.isDigit(ch)) {
                StringBuffer num = new StringBuffer();
                num.append(ch);
                context.incrementIndex();
                int intDig = Character.isDigit(ch) ? 1 : 0;
                int frcDig = 0;
                int expDig = 0;
                boolean frcCh = false;
                boolean esnCh = false;
                boolean expCh = false;
                while (true) {
                    char d;
                    if (Character.isDigit(d = v.charAt(context.getIndex()))) {
                        if (expCh) {
                            ++expDig;
                        } else if (frcCh) {
                            ++frcDig;
                        } else {
                            ++intDig;
                        }
                        num.append(d);
                        context.incrementIndex();
                        continue;
                    }
                    if (d == '.') {
                        if (frcCh) {
                            throw new JSONParsingException("Invalid numeric value (multiple '.')", context);
                        }
                        if (intDig == 0) {
                            throw new JSONParsingException("Invalid numeric value (no digits before '.')", context);
                        }
                        frcCh = true;
                        num.append(d);
                        context.incrementIndex();
                        continue;
                    }
                    if (d == 'e' || d == 'E') {
                        if (frcCh && frcDig == 0) {
                            throw new JSONParsingException("Invalid numeric value (no digits after '.')", context);
                        }
                        if (expCh) {
                            throw new JSONParsingException("Invalid numeric value (multiple 'E')", context);
                        }
                        expCh = true;
                        num.append(d);
                        context.incrementIndex();
                        continue;
                    }
                    if (d != '-' && d != '+') break;
                    if (!expCh) {
                        throw new JSONParsingException("Invalid numeric value (no 'E')", context);
                    }
                    if (esnCh) {
                        throw new JSONParsingException("Invalid numeric value (more than one '+/-')", context);
                    }
                    esnCh = true;
                    num.append(d);
                    context.incrementIndex();
                }
                String numStr = num.toString();
                if (frcCh || expCh) {
                    val = new Double(StringTools.parseDouble(numStr, 0.0));
                    break;
                }
                val = new Long(StringTools.parseLong(numStr, 0L));
                break;
            }
            throw new JSONParsingException("Missing initial Numeric +/-/0", context);
        }
        return val;
    }

    public JSON() {
    }

    public JSON(_Object obj) {
        this.object = obj;
    }

    public JSON(String json) throws JSONParsingException {
        this.object = JSON.parse_Object(json);
    }

    public JSON(InputStream input) throws JSONParsingException, IOException {
        String json = StringTools.toStringValue(FileTools.readStream(input));
        this.object = JSON.parse_Object(json);
    }

    public boolean hasObject() {
        return this.object != null;
    }

    public _Object getObject() {
        return this.object;
    }

    public void getObject(_Object obj) {
        this.object = obj;
    }

    public String toString() {
        if (this.object != null) {
            return this.object.toString();
        }
        return "";
    }

    public void debugDisplayObject() {
        if (this.object != null) {
            this.object.debugDisplayObject(0);
        } else {
            Print.sysPrintln("n/a", new Object[0]);
        }
    }

    public static class _Array
    extends Vector<_Value> {
        private boolean formatIndent = true;

        public _Array() {
        }

        public _Array(_Value ... array) {
            if (array != null) {
                for (int i = 0; i < array.length; ++i) {
                    this.add(array[i]);
                }
            }
        }

        public _Array(String ... array) {
            if (array != null) {
                for (int i = 0; i < array.length; ++i) {
                    this.addValue(array[i]);
                }
            }
        }

        public _Array(long ... array) {
            if (array != null) {
                for (int i = 0; i < array.length; ++i) {
                    this.addValue(array[i]);
                }
            }
        }

        public _Array(double ... array) {
            if (array != null) {
                for (int i = 0; i < array.length; ++i) {
                    this.addValue(array[i]);
                }
            }
        }

        public _Array(boolean ... array) {
            if (array != null) {
                for (int i = 0; i < array.length; ++i) {
                    this.addValue(array[i]);
                }
            }
        }

        public _Array(_Object ... array) {
            if (array != null) {
                for (int i = 0; i < array.length; ++i) {
                    this.addValue(array[i]);
                }
            }
        }

        public _Array(_Array ... array) {
            if (array != null) {
                for (int i = 0; i < array.length; ++i) {
                    this.addValue(array[i]);
                }
            }
        }

        @Override
        public boolean add(_Value value) {
            return super.add(value);
        }

        public boolean addValue(_Value value) {
            return this.add(value);
        }

        public boolean addValue(String value) {
            return this.add(new _Value(value));
        }

        public boolean addValue(long value) {
            return this.add(new _Value(value));
        }

        public boolean addValue(double value) {
            return this.add(new _Value(value));
        }

        public boolean addValue(boolean value) {
            return this.add(new _Value(value));
        }

        public boolean addValue(_Object value) {
            return this.add(new _Value(value));
        }

        public boolean addValue(_Array value) {
            return this.add(new _Value(value));
        }

        public _Value getValueAt(int ndx) {
            if (ndx >= 0 && ndx < this.size()) {
                return (_Value)this.get(ndx);
            }
            return null;
        }

        public _Object getObjectValueAt(int ndx, _Object dft) {
            if (ndx >= 0 && ndx < this.size()) {
                _Value jv = (_Value)this.get(ndx);
                return jv != null ? jv.getObjectValue(dft) : dft;
            }
            return dft;
        }

        public String getStringValueAt(int ndx, String dft) {
            if (ndx >= 0 && ndx < this.size()) {
                _Value jv = (_Value)this.get(ndx);
                return jv != null ? jv.getStringValue(dft) : dft;
            }
            return dft;
        }

        public int getIntValueAt(int ndx, int dft) {
            if (ndx >= 0 && ndx < this.size()) {
                _Value jv = (_Value)this.get(ndx);
                return jv != null ? jv.getIntValue(dft) : dft;
            }
            return dft;
        }

        public long getLongValueAt(int ndx, long dft) {
            if (ndx >= 0 && ndx < this.size()) {
                _Value jv = (_Value)this.get(ndx);
                return jv != null ? jv.getLongValue(dft) : dft;
            }
            return dft;
        }

        public double getDoubleValueAt(int ndx, double dft) {
            if (ndx >= 0 && ndx < this.size()) {
                _Value jv = (_Value)this.get(ndx);
                return jv != null ? jv.getDoubleValue(dft) : dft;
            }
            return dft;
        }

        public boolean getBooleanValueAt(int ndx, boolean dft) {
            if (ndx >= 0 && ndx < this.size()) {
                _Value jv = (_Value)this.get(ndx);
                return jv != null ? jv.getBooleanValue(dft) : dft;
            }
            return dft;
        }

        public String[] getStringArray() {
            String[] v = new String[this.size()];
            for (int i = 0; i < v.length; ++i) {
                v[i] = this.getStringValueAt(i, "");
            }
            return v;
        }

        public int[] getIntArray() {
            int[] v = new int[this.size()];
            for (int i = 0; i < v.length; ++i) {
                v[i] = this.getIntValueAt(i, 0);
            }
            return v;
        }

        public long[] getLongArray() {
            long[] v = new long[this.size()];
            for (int i = 0; i < v.length; ++i) {
                v[i] = this.getLongValueAt(i, 0L);
            }
            return v;
        }

        public double[] getDoubleArray() {
            double[] v = new double[this.size()];
            for (int i = 0; i < v.length; ++i) {
                v[i] = this.getDoubleValueAt(i, 0.0);
            }
            return v;
        }

        @Override
        public int size() {
            return super.size();
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty();
        }

        public _Array setFormatIndent(boolean indent) {
            this.formatIndent = indent;
            return this;
        }

        public StringBuffer toStringBuffer(int prefix, StringBuffer sb) {
            if (sb == null) {
                sb = new StringBuffer();
            }
            boolean fullFormat = this.formatIndent && prefix >= 0;
            String pfx0 = fullFormat ? StringTools.replicateString(JSON.INDENT, prefix) : "";
            String pfx1 = fullFormat ? StringTools.replicateString(JSON.INDENT, prefix + 1) : "";
            sb.append("[");
            if (fullFormat) {
                sb.append("\n");
            }
            int size = this.size();
            for (int i = 0; i < this.size(); ++i) {
                _Value v = (_Value)this.get(i);
                sb.append(pfx1);
                v.toStringBuffer(fullFormat ? prefix + 1 : -1, sb);
                if (i + 1 < size) {
                    sb.append(",");
                }
                if (!fullFormat) continue;
                sb.append("\n");
            }
            sb.append(pfx0).append("]");
            return sb;
        }

        @Override
        public String toString() {
            return this.toStringBuffer(1, null).toString();
        }
    }

    public static class _Value {
        private Object value = null;

        public _Value() {
            this.value = null;
        }

        public _Value(String v) {
            this.value = v;
        }

        public _Value(Integer v) {
            this.value = v != null ? new Long(v.longValue()) : null;
        }

        public _Value(int v) {
            this.value = new Long(v);
        }

        public _Value(Long v) {
            this.value = v;
        }

        public _Value(long v) {
            this.value = new Long(v);
        }

        public _Value(Double v) {
            this.value = v;
        }

        public _Value(double v) {
            this.value = new Double(v);
        }

        public _Value(Boolean v) {
            this.value = v;
        }

        public _Value(boolean v) {
            this.value = new Boolean(v);
        }

        public _Value(_Array v) {
            this.value = v;
        }

        public _Value(_Object v) {
            this.value = v;
        }

        public Object getObjectValue() {
            return this.value;
        }

        public boolean isNullValue() {
            return this.value == null;
        }

        public boolean isStringValue() {
            return this.value instanceof String;
        }

        public String getStringValue(String dft) {
            if (this.value instanceof String) {
                return (String)this.value;
            }
            if (this.value instanceof Number) {
                return this.value.toString();
            }
            if (this.value instanceof Boolean) {
                return this.value.toString();
            }
            return dft;
        }

        public boolean isIntValue() {
            return this.value instanceof Integer;
        }

        public int getIntValue(int dft) {
            if (this.value instanceof Number) {
                return ((Number)this.value).intValue();
            }
            if (this.value instanceof String) {
                return StringTools.parseInt(this.value, dft);
            }
            if (this.value instanceof Boolean) {
                return (Boolean)this.value != false ? 1 : 0;
            }
            return dft;
        }

        public boolean isLongValue() {
            return this.value instanceof Long;
        }

        public long getLongValue(long dft) {
            if (this.value instanceof Number) {
                return ((Number)this.value).longValue();
            }
            if (this.value instanceof String) {
                return StringTools.parseLong(this.value, dft);
            }
            if (this.value instanceof Boolean) {
                return (Boolean)this.value != false ? 1L : 0L;
            }
            return dft;
        }

        public boolean isDoubleValue() {
            return this.value instanceof Double;
        }

        public double getDoubleValue(double dft) {
            if (this.value instanceof Number) {
                return ((Number)this.value).doubleValue();
            }
            if (this.value instanceof String) {
                return StringTools.parseDouble(this.value, dft);
            }
            if (this.value instanceof Boolean) {
                return (Boolean)this.value != false ? 1.0 : 0.0;
            }
            return dft;
        }

        public boolean isBooleanValue() {
            return this.value instanceof Boolean;
        }

        public boolean getBooleanValue(boolean dft) {
            if (this.value instanceof Boolean) {
                return (Boolean)this.value;
            }
            if (this.value instanceof String) {
                return StringTools.parseBoolean(this.value, dft);
            }
            if (this.value instanceof Number) {
                return ((Number)this.value).longValue() != 0L;
            }
            return dft;
        }

        public boolean isArrayValue() {
            return this.value instanceof _Array;
        }

        public _Array getArrayValue(_Array dft) {
            if (this.value instanceof _Array) {
                return (_Array)this.value;
            }
            return dft;
        }

        public boolean isObjectValue() {
            return this.value instanceof _Object;
        }

        public _Object getObjectValue(_Object dft) {
            if (this.value instanceof _Object) {
                return (_Object)this.value;
            }
            return dft;
        }

        public Class getValueClass() {
            return this.value != null ? this.value.getClass() : null;
        }

        public StringBuffer toStringBuffer(int prefix, StringBuffer sb) {
            if (sb == null) {
                sb = new StringBuffer();
            }
            if (this.value == null) {
                sb.append("null");
            } else if (this.value instanceof String) {
                sb.append("\"");
                sb.append(StringTools.escapeJSON((String)this.value));
                sb.append("\"");
            } else if (this.value instanceof Number) {
                sb.append(this.value.toString());
            } else if (this.value instanceof Boolean) {
                sb.append(this.value.toString());
            } else if (this.value instanceof _Object) {
                ((_Object)this.value).toStringBuffer(prefix, sb);
            } else if (this.value instanceof _Array) {
                ((_Array)this.value).toStringBuffer(prefix, sb);
            }
            return sb;
        }

        public String toString() {
            return this.toStringBuffer(0, null).toString();
        }
    }

    public static class _KeyValue {
        private String key = null;
        private _Value value = null;

        public _KeyValue(String key, _Value value) {
            this.key = key;
            this.value = value;
        }

        public _KeyValue(String key, String value) {
            this.key = key;
            this.value = new _Value(value);
        }

        public _KeyValue(String key, long value) {
            this.key = key;
            this.value = new _Value(value);
        }

        public _KeyValue(String key, double value) {
            this.key = key;
            this.value = new _Value(value);
        }

        public _KeyValue(String key, boolean value) {
            this.key = key;
            this.value = new _Value(value);
        }

        public _KeyValue(String key, _Array value) {
            this.key = key;
            this.value = new _Value(value);
        }

        public _KeyValue(String key, _Object value) {
            this.key = key;
            this.value = new _Value(value);
        }

        public String getKey() {
            return this.key;
        }

        public _Value getValue() {
            return this.value;
        }

        public StringBuffer toStringBuffer(int prefix, StringBuffer sb) {
            if (sb == null) {
                sb = new StringBuffer();
            }
            sb.append("\"").append(this.key).append("\"");
            sb.append(":");
            if (prefix >= 0) {
                sb.append(" ");
            }
            if (this.value != null) {
                this.value.toStringBuffer(prefix, sb);
            } else {
                sb.append("null");
            }
            return sb;
        }

        public String toString() {
            return this.toStringBuffer(1, null).toString();
        }
    }

    public static class _Object
    extends Vector<_KeyValue> {
        private boolean formatIndent = true;

        public _Object() {
        }

        public _Object(Vector<_KeyValue> list) {
            this();
            this.addAll(list);
        }

        public _Object(_KeyValue ... kv) {
            this();
            if (!ListTools.isEmpty(kv)) {
                for (int i = 0; i < kv.length; ++i) {
                    this.add(kv[i]);
                }
            }
        }

        public boolean addKeyValue(_KeyValue kv) {
            return super.add(kv);
        }

        @Override
        public boolean add(_KeyValue kv) {
            return super.add(kv);
        }

        public boolean addKeyValue(String key, String value) {
            return this.add(new _KeyValue(key, value));
        }

        public boolean addKeyValue(String key, int value) {
            return this.add(new _KeyValue(key, value));
        }

        public boolean addKeyValue(String key, long value) {
            return this.add(new _KeyValue(key, value));
        }

        public boolean addKeyValue(String key, double value) {
            return this.add(new _KeyValue(key, value));
        }

        public boolean addKeyValue(String key, boolean value) {
            return this.add(new _KeyValue(key, value));
        }

        public boolean addKeyValue(String key, _Array value) {
            return this.add(new _KeyValue(key, value));
        }

        public boolean addKeyValue(String key, _Object value) {
            return this.add(new _KeyValue(key, value));
        }

        public boolean addKeyValue(String key, _Value value) {
            return this.add(new _KeyValue(key, value));
        }

        public int getKeyValueCount() {
            return super.size();
        }

        public _KeyValue getKeyValueAt(int ndx) {
            if (ndx >= 0 && ndx < this.size()) {
                return (_KeyValue)this.get(ndx);
            }
            return null;
        }

        public _KeyValue getKeyValue(String n) {
            if (n != null) {
                for (_KeyValue kv : this) {
                    String kvn = kv.getKey();
                    if (!JSON.NameEquals(n, kvn)) continue;
                    return kv;
                }
            }
            return null;
        }

        public _Value getValueForName(String n) {
            _KeyValue kv = this.getKeyValue(n);
            return kv != null ? kv.getValue() : null;
        }

        public _Value getValueForName(String[] name) {
            if (!ListTools.isEmpty(name)) {
                for (String n : name) {
                    _Value jv = this.getValueForName(n);
                    if (jv == null) continue;
                    return jv;
                }
            }
            return null;
        }

        public _Array getArrayForName(String name, _Array dft) {
            _Value jv = this.getValueForName(name);
            return jv != null ? jv.getArrayValue(dft) : dft;
        }

        public _Array getArrayForName(String[] name, _Array dft) {
            _Value jv = this.getValueForName(name);
            return jv != null ? jv.getArrayValue(dft) : dft;
        }

        public String[] getStringArrayForName(String name, String[] dft) {
            _Value jv = this.getValueForName(name);
            _Array ar = jv != null ? jv.getArrayValue(null) : null;
            return ar != null ? ar.getStringArray() : dft;
        }

        public String[] getStringArrayForName(String[] name, String[] dft) {
            _Value jv = this.getValueForName(name);
            _Array ar = jv != null ? jv.getArrayValue(null) : null;
            return ar != null ? ar.getStringArray() : dft;
        }

        public _Object getObjectForName(String name, _Object dft) {
            _Value jv = this.getValueForName(name);
            return jv != null ? jv.getObjectValue(dft) : dft;
        }

        public _Object getObjectForName(String[] name, _Object dft) {
            _Value jv = this.getValueForName(name);
            return jv != null ? jv.getObjectValue(dft) : dft;
        }

        public String getStringForName(String name, String dft) {
            _Value jv = this.getValueForName(name);
            return jv != null ? jv.getStringValue(dft) : dft;
        }

        public String getStringForName(String[] name, String dft) {
            _Value jv = this.getValueForName(name);
            return jv != null ? jv.getStringValue(dft) : dft;
        }

        public int getIntForName(String name, int dft) {
            _Value jv = this.getValueForName(name);
            return jv != null ? jv.getIntValue(dft) : dft;
        }

        public int getIntForName(String[] name, int dft) {
            _Value jv = this.getValueForName(name);
            return jv != null ? jv.getIntValue(dft) : dft;
        }

        public long getLongForName(String name, long dft) {
            _Value jv = this.getValueForName(name);
            return jv != null ? jv.getLongValue(dft) : dft;
        }

        public long getLongForName(String[] name, long dft) {
            _Value jv = this.getValueForName(name);
            return jv != null ? jv.getLongValue(dft) : dft;
        }

        public double getDoubleForName(String name, double dft) {
            _Value jv = this.getValueForName(name);
            return jv != null ? jv.getDoubleValue(dft) : dft;
        }

        public double getDoubleForName(String[] name, double dft) {
            _Value jv = this.getValueForName(name);
            return jv != null ? jv.getDoubleValue(dft) : dft;
        }

        public boolean getBooleanForName(String name, boolean dft) {
            _Value jv = this.getValueForName(name);
            return jv != null ? jv.getBooleanValue(dft) : dft;
        }

        public boolean getBooleanForName(String[] name, boolean dft) {
            _Value jv = this.getValueForName(name);
            return jv != null ? jv.getBooleanValue(dft) : dft;
        }

        public Collection<String> getKeyNames() {
            Vector<String> keyList = new Vector<String>();
            for (_KeyValue kv : this) {
                keyList.add(kv.getKey());
            }
            return keyList;
        }

        public void debugDisplayObject(int level) {
            String pfx0 = StringTools.replicateString(JSON.INDENT, level);
            String pfx1 = StringTools.replicateString(JSON.INDENT, level + 1);
            for (String key : this.getKeyNames()) {
                _KeyValue kv = this.getKeyValue(key);
                Object val = kv.getValue().getObjectValue();
                Print.sysPrintln(pfx0 + key + " ==> " + StringTools.className(val), new Object[0]);
                if (val instanceof _Object) {
                    _Object obj = (_Object)val;
                    obj.debugDisplayObject(level + 1);
                    continue;
                }
                if (!(val instanceof _Array)) continue;
                _Array array = (_Array)val;
                for (_Value jv : array) {
                    Object av = jv.getObjectValue();
                    Print.sysPrintln(pfx1 + " ==> " + StringTools.className(av), new Object[0]);
                    if (!(av instanceof _Object)) continue;
                    _Object obj = (_Object)av;
                    obj.debugDisplayObject(level + 2);
                }
            }
        }

        public _Object setFormatIndent(boolean indent) {
            this.formatIndent = indent;
            return this;
        }

        public StringBuffer toStringBuffer(int prefix, StringBuffer sb) {
            if (sb == null) {
                sb = new StringBuffer();
            }
            boolean fullFormat = this.formatIndent && prefix >= 0;
            String pfx0 = fullFormat ? StringTools.replicateString(JSON.INDENT, prefix) : "";
            String pfx1 = fullFormat ? StringTools.replicateString(JSON.INDENT, prefix + 1) : "";
            sb.append("{");
            if (fullFormat) {
                sb.append("\n");
            }
            if (!ListTools.isEmpty(this)) {
                int size = this.size();
                for (int i = 0; i < size; ++i) {
                    _KeyValue kv = (_KeyValue)this.get(i);
                    sb.append(pfx1);
                    kv.toStringBuffer(fullFormat ? prefix + 1 : -1, sb);
                    if (i + 1 < size) {
                        sb.append(",");
                    }
                    if (!fullFormat) continue;
                    sb.append("\n");
                }
            }
            sb.append(pfx0).append("}");
            if (fullFormat && prefix == 0) {
                sb.append("\n");
            }
            return sb;
        }

        @Override
        public String toString() {
            return this.toStringBuffer(0, null).toString();
        }

        public String toString(boolean inclPrefix) {
            return this.toStringBuffer(inclPrefix ? 0 : -1, null).toString();
        }
    }

    public static class JSONParsingException
    extends Exception {
        private int index = 0;
        private int line = 0;

        public JSONParsingException(String msg, JSONParsingContext context) {
            super(msg);
            this.index = context != null ? context.getIndex() : -1;
            this.line = context != null ? context.getLine() : -1;
        }

        public int getIndex() {
            return this.index;
        }

        public int getLine() {
            return this.line;
        }

        @Override
        public String toString() {
            String s = super.toString();
            return s + " [" + this.line + "/" + this.index + "]";
        }
    }

    public static class JSONParsingContext {
        private int index = 0;
        private int line = 1;

        public int getIndex() {
            return this.index;
        }

        public void incrementIndex(int val) {
            this.index += val;
        }

        public void incrementIndex() {
            ++this.index;
        }

        public int getLine() {
            return this.line;
        }

        public void incrementLine() {
            ++this.line;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(this.line);
            sb.append("/");
            sb.append(this.index);
            return sb.toString();
        }
    }
}

