/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.util;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.opengts.util.ListTools;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;
import org.opengts.util.StringTools;

public class IPTools {
    public static final String HOST_UNKNOWN = "UNKNOWN";
    public static final String IP_ADDR_ALL = "*";
    public static final char IPAddressSeparatorChar = ',';
    public static final String IPAddressSeparator = String.valueOf(',');
    protected static final int IP_ADDR_SIZE = 32;
    protected static final long IP_ADDR_MASK = 0xFFFFFFFFL;
    public static final IPAddressList PrivateIPAddresses = new IPAddressList(new IPAddress[]{new IPAddress("10.0.0.0/8"), new IPAddress("172.16.0.0/12"), new IPAddress("192.168.0.0/16")});
    private static String localhostName = null;

    public static String getHostName() {
        if (localhostName == null) {
            try {
                String hd = InetAddress.getLocalHost().getHostName();
                int p = hd.indexOf(".");
                localhostName = p >= 0 ? hd.substring(0, p) : hd;
            }
            catch (UnknownHostException uhe) {
                localhostName = HOST_UNKNOWN;
            }
        }
        return localhostName;
    }

    public static String getIPAddress(String hostName) {
        try {
            InetAddress addr = InetAddress.getByName(hostName);
            return addr.getHostAddress();
        }
        catch (Throwable t) {
            Print.logException("DNS lookup", t);
            return "";
        }
    }

    public static boolean isLocalhost(String hostName) {
        if (StringTools.isBlank(hostName)) {
            return false;
        }
        if (hostName.equalsIgnoreCase("localhost") || hostName.equals("127.0.0.1")) {
            return true;
        }
        String hostIP = IPTools.getIPAddress(hostName);
        return hostIP.equals("127.0.0.1");
    }

    public static boolean isValidIPAddress(String ipAddr) {
        if (StringTools.isBlank(ipAddr)) {
            return false;
        }
        if (ipAddr.indexOf(" ") >= 0) {
            return false;
        }
        String[] ipList = StringTools.parseStringArray(ipAddr, '.');
        if (ipList.length != 4) {
            return false;
        }
        for (int i = 0; i < ipList.length; ++i) {
            if (!StringTools.isInt(ipList[i], true)) {
                return false;
            }
            int x = StringTools.parseInt(ipList[i], -1);
            if (x >= 0 && x <= 255) continue;
            return false;
        }
        return true;
    }

    public static boolean isPrivateIPAddress(String ipAddr) {
        if (!IPTools.isValidIPAddress(ipAddr)) {
            return false;
        }
        return PrivateIPAddresses.isMatch(ipAddr);
    }

    protected static long _parseIPAddress(String ipAddr) {
        if (!StringTools.isBlank(ipAddr)) {
            int p = ipAddr.indexOf("/");
            if (p >= 0) {
                ipAddr = ipAddr.substring(0, p);
            }
            String[] ipList = StringTools.parseStringArray(ipAddr, '.');
            long ip = 0L;
            for (int i = 0; i < 4; ++i) {
                ip <<= 8;
                if (i >= ipList.length) continue;
                ip |= (long)(StringTools.parseInt(ipList[i], 0) & 0xFF);
            }
            return ip;
        }
        return 0L;
    }

    protected static long _parseIPMask(int m) {
        if (m > 32) {
            m = 32;
        }
        long x = (long)Math.pow(2.0, m) - 1L;
        long mask = x << 32 - m;
        return mask;
    }

    public static long[] parseIPAddress(String ipAddr) {
        if (StringTools.isBlank(ipAddr)) {
            return null;
        }
        if (ipAddr.equals(IP_ADDR_ALL)) {
            return new long[]{0L, 0L};
        }
        int p = ipAddr.indexOf("/");
        if (p >= 0) {
            long[] ipm = new long[]{IPTools._parseIPAddress(ipAddr.substring(0, p)), 0xFFFFFFFFL};
            String mask = ipAddr.substring(p + 1);
            ipm[1] = mask.indexOf(".") >= 0 ? IPTools._parseIPAddress(mask) : IPTools._parseIPMask(StringTools.parseInt(mask, 32));
            return ipm;
        }
        return new long[]{IPTools._parseIPAddress(ipAddr), 0xFFFFFFFFL};
    }

    public static void main(String[] argv) {
        RTConfig.setCommandLineArgs(argv);
        Print.logInfo("Hostname: " + IPTools.getHostName(), new Object[0]);
        String ipMask = RTConfig.getString("ipMask", "10.0.0.0/13,10.8.0.0/16,10.9.0.0/16");
        String ipTarg = RTConfig.getString("ip", "");
        if (StringTools.isBlank(ipTarg)) {
            Print.sysPrintln("Usage: %s -ipMask=X.X.X.X/X[,X.X.X.X/X] -ip=X.X.X.X", new Object[0]);
            System.exit(99);
        }
        if (ipMask.indexOf(",") >= 0) {
            IPAddressList ipList = new IPAddressList(ipMask);
            Print.sysPrintln("'" + ipTarg + "' Match = " + ipList.contains(ipTarg), new Object[0]);
            System.exit(0);
        } else {
            IPAddress ipAddr = new IPAddress(ipMask);
            Print.sysPrintln("'" + ipTarg + "' Match = " + ipAddr.isMatch(ipTarg), new Object[0]);
            System.exit(0);
        }
    }

    public static class IPAddressList {
        private Vector<IPAddress> ipList = null;

        public IPAddressList() {
        }

        public IPAddressList(IPAddress[] list) {
            ListTools.toList(list, this.getIPList());
        }

        public IPAddressList(String ipListStr) {
            this.addIPAddress(ipListStr);
        }

        public List<IPAddress> getIPList() {
            if (this.ipList == null) {
                this.ipList = new Vector();
            }
            return this.ipList;
        }

        public void addIPAddress(IPAddress ipAddr) {
            List<IPAddress> v = this.getIPList();
            if (ipAddr != null && !v.contains(ipAddr)) {
                v.add(ipAddr);
            }
        }

        public void addIPAddress(IPAddress[] ipAddr) {
            if (ipAddr != null) {
                for (int i = 0; i < ipAddr.length; ++i) {
                    this.addIPAddress(ipAddr[i]);
                }
            }
        }

        public void addIPAddress(String ipAddr) {
            String[] ipArray = StringTools.parseStringArray(ipAddr, ',');
            for (int i = 0; i < ipArray.length; ++i) {
                String ipm = ipArray[i].trim();
                if (ipm.equals("")) continue;
                this.addIPAddress(new IPAddress(ipm));
            }
        }

        public boolean contains(String ipAddr) {
            for (IPAddress ipa : this.getIPList()) {
                if (!ipa.isMatch(ipAddr)) continue;
                return true;
            }
            return false;
        }

        public boolean isMatch(String ipAddr) {
            return this.contains(ipAddr);
        }

        public boolean isEmpty() {
            return this.ipList == null || this.ipList.size() <= 0;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            List<IPAddress> v = this.getIPList();
            Iterator<IPAddress> i = v.iterator();
            while (i.hasNext()) {
                if (sb.length() > 0) {
                    sb.append(',');
                }
                sb.append(i.next().toString());
            }
            return sb.toString();
        }

        public boolean equals(Object other) {
            if (other instanceof IPAddressList) {
                return this.toString().equals(other.toString());
            }
            return false;
        }
    }

    public static class IPAddress {
        private long ip = 0L;
        private long mask = 0L;

        public IPAddress(long[] ip) {
            this.mask = ip != null && ip.length > 1 ? ip[1] & 0xFFFFFFFFL : 0xFFFFFFFFL;
            this.ip = ip != null && ip.length > 0 ? ip[0] & this.mask : 0L;
        }

        public IPAddress(long ip, long mask) {
            this(new long[]{ip, mask});
        }

        public IPAddress(String ipAddr, int mask) {
            this(IPTools._parseIPAddress(ipAddr), IPTools._parseIPMask(mask));
        }

        public IPAddress(String ipAddr, long mask) {
            this(IPTools._parseIPAddress(ipAddr), mask);
        }

        public IPAddress(String ipAddr) {
            this(IPTools.parseIPAddress(ipAddr));
        }

        public long getMask() {
            return this.mask;
        }

        public long getIP() {
            return this.ip;
        }

        public boolean isZero() {
            return this.getIP() == 0L;
        }

        public boolean isMatch(String ipAddr) {
            long ip2;
            long ip1 = IPTools._parseIPAddress(ipAddr) & this.mask;
            return ip1 == (ip2 = this.ip & this.mask);
        }

        protected String _ipToString(long p) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i <= 3; ++i) {
                if (i > 0) {
                    sb.append(".");
                }
                int b = (int)(p >>> (3 - i) * 8) & 0xFF;
                sb.append(b);
            }
            return sb.toString();
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(this._ipToString(this.ip));
            if (this.mask != 0xFFFFFFFFL) {
                sb.append("/");
                long m = this.mask;
                int i = 0;
                while (i < 32 && (m & 1L) == 0L) {
                    ++i;
                    m >>>= 1;
                }
                int j = i;
                while (j < 32 && (m & 1L) == 1L) {
                    ++j;
                    m >>>= 1;
                }
                if (j == 32) {
                    sb.append(32 - i);
                } else {
                    sb.append(this._ipToString(this.mask));
                }
            }
            return sb.toString();
        }

        public boolean equals(Object other) {
            if (other instanceof IPAddress) {
                IPAddress ipa = (IPAddress)other;
                return ipa.ip == this.ip && ipa.mask == this.mask;
            }
            return false;
        }
    }
}

