/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.util;

import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;
import org.opengts.util.RTProperties;
import org.opengts.util.StringTools;

public class I18N {
    public static final String LOCAL_STRINGS = "LocalStrings";
    public static final String _LOCAL_STRINGS = ".LocalStrings";
    private static Map<Locale, Map<String, I18N>> localeMap = new HashMap<Locale, Map<String, I18N>>();
    private ResourceBundle resBundle = null;
    private Locale locale = null;
    protected static final String I18N_KEY_STARTE = "[$I18N=";
    protected static final String I18N_KEY_STARTC = "[$I18N:";
    protected static final String I18N_KEY_END = "]";
    private static final String[] ARG_PACKAGE = new String[]{"pkg", "package"};
    private static final String[] ARG_LOCALE = new String[]{"loc", "locale"};
    private static final String[] ARG_KEY = new String[]{"key"};
    private static String mainStr = "Cow";

    public static I18N getI18N(Class pkgClz, Locale loc) {
        return I18N.getI18N(pkgClz.getPackage().getName(), loc);
    }

    public static I18N getI18N(Package pkg, Locale loc) {
        return I18N.getI18N(pkg.getName(), loc);
    }

    public static I18N getI18N(String pkgName, Locale loc) {
        if (pkgName != null) {
            I18N i18n;
            Map<String, I18N> packageMap = localeMap.get(loc = I18N.getLocale(loc));
            if (packageMap == null) {
                packageMap = new HashMap<String, I18N>();
                localeMap.put(loc, packageMap);
            }
            if ((i18n = packageMap.get(pkgName)) == null) {
                i18n = new I18N(pkgName, loc);
                packageMap.put(pkgName, i18n);
            }
            return i18n;
        }
        return null;
    }

    public static Locale getLocale(String loc) {
        Locale locale = I18N.getLocale(loc, null);
        return locale != null ? locale : I18N.getDefaultLocale();
    }

    public static Locale getLocale(String loc, Locale dft) {
        String locale;
        String string = locale = !StringTools.isBlank(loc) ? loc : RTConfig.getString("locale", "");
        if (StringTools.isBlank(locale)) {
            return dft;
        }
        int p = locale.indexOf("_");
        try {
            if (p < 0) {
                String language = locale;
                return new Locale(language);
            }
            String language = locale.substring(0, p);
            String country = locale.substring(p + 1);
            return new Locale(language, country);
        }
        catch (Throwable th) {
            return dft;
        }
    }

    public static Locale getLocale(Locale loc) {
        if (loc != null) {
            return loc;
        }
        return I18N.getDefaultLocale();
    }

    public static Locale getDefaultLocale() {
        return Locale.getDefault();
    }

    private I18N(String pkgName, Locale loc) {
        String bundleName = null;
        try {
            this.locale = I18N.getLocale(loc);
            bundleName = pkgName == null || pkgName.equals("") ? LOCAL_STRINGS : pkgName + _LOCAL_STRINGS;
            this.resBundle = ResourceBundle.getBundle(bundleName, this.locale);
        }
        catch (Throwable th) {
            if (loc != null) {
                Print.logInfo("Bundle not found: " + bundleName + " [" + th, new Object[0]);
            }
            this.resBundle = null;
        }
    }

    private I18N(String pkgName) {
        this(pkgName, null);
    }

    public Locale getLocale() {
        return this.locale;
    }

    public Enumeration getKeys() {
        return this.resBundle != null ? this.resBundle.getKeys() : null;
    }

    public void printKeyValues() {
        Enumeration e = this.getKeys();
        if (e != null) {
            while (e.hasMoreElements()) {
                String k = (String)e.nextElement();
                String v = this.getString(k, "?");
                Print.logInfo("Key:" + k + " Value:" + v, new Object[0]);
            }
        }
    }

    public String getString(String key, String dft) {
        RTProperties cfgProps;
        if (!(StringTools.isBlank(key) || this.resBundle == null || (cfgProps = RTConfig.getConfigFileProperties()).hasProperty(key) && !cfgProps.getBoolean(key, true))) {
            try {
                String s = this.resBundle.getString(key);
                if (s != null) {
                    return I18N.decodeNewLine(s);
                }
            }
            catch (Throwable th) {
                // empty catch block
            }
        }
        return I18N.decodeNewLine(dft);
    }

    public String getString(String key, String dft, Object[] args) {
        String val = this.getString(key, dft);
        if (args != null && args.length > 0 && val != null) {
            try {
                MessageFormat mf = new MessageFormat(val);
                mf.setLocale(this.locale);
                StringBuffer sb = mf.format(args, new StringBuffer(), (FieldPosition)null);
                return I18N.decodeNewLine(sb).toString();
            }
            catch (Throwable th) {
                Print.logInfo("Exception: " + key + " ==> " + val, new Object[0]);
            }
        }
        return I18N.decodeNewLine(val);
    }

    public String getString(String key, String dft, Object arg) {
        return this.getString(key, dft, new Object[]{I18N.NonNull(arg)});
    }

    public String getString(String key, String dft, Object arg0, Object arg1) {
        return this.getString(key, dft, new Object[]{I18N.NonNull(arg0), I18N.NonNull(arg1)});
    }

    public String getString(String key, String dft, Object arg0, Object arg1, Object arg2) {
        return this.getString(key, dft, new Object[]{I18N.NonNull(arg0), I18N.NonNull(arg1), I18N.NonNull(arg2)});
    }

    public String getString(String key, String dft, Object arg0, Object arg1, Object arg2, Object arg3) {
        return this.getString(key, dft, new Object[]{I18N.NonNull(arg0), I18N.NonNull(arg1), I18N.NonNull(arg2), I18N.NonNull(arg3)});
    }

    protected static Object NonNull(Object obj) {
        return obj != null ? obj : "";
    }

    protected static String decodeNewLine(String s) {
        return StringTools.replace(s, "\\n", "\n");
    }

    protected static StringBuffer decodeNewLine(StringBuffer s) {
        return StringTools.replace(s, "\\n", "\n");
    }

    public static Text parseText(String pkg, String key, String dft) {
        return I18N.parseText(pkg, key, dft, true);
    }

    public static Text parseText(String pkg, String key, String dft, boolean showError) {
        if (dft == null) {
            Print.logStackTrace("Default value is null!");
            return new Text(pkg, key, "");
        }
        if (!StringTools.isBlank(key)) {
            return new Text(pkg, key, dft);
        }
        if (!StringTools.startsWithIgnoreCase(dft, I18N_KEY_STARTE) && !StringTools.startsWithIgnoreCase(dft, I18N_KEY_STARTC)) {
            if (showError) {
                Print.logStackTrace("Invalid/missing key definition!\nPackage: " + pkg + "\n" + "Key    : " + key + "\n" + "Default: " + dft);
            }
            return new Text(pkg, null, dft);
        }
        int ks = I18N_KEY_STARTE.length();
        int ke = dft.indexOf(I18N_KEY_END, ks);
        if (ke < ks) {
            return new Text(pkg, null, dft);
        }
        String k = dft.substring(ks, ke).trim();
        String v = dft.substring(ke + I18N_KEY_END.length()).trim();
        return new Text(pkg, k, v);
    }

    public static Text _getString(Class clazz, String key, String dft) {
        String pkg = clazz != null ? clazz.getPackage().getName() : null;
        return I18N.parseText(pkg, key, dft);
    }

    public static Text getString(Class clazz, String key, String dft) {
        String pkg = clazz != null ? clazz.getPackage().getName() : null;
        return I18N.parseText(pkg, key, dft);
    }

    public static void main(String[] argv) {
        RTConfig.setCommandLineArgs(argv);
        if (RTConfig.hasProperty(ARG_PACKAGE)) {
            String pkg = RTConfig.getString(ARG_PACKAGE, "org.opengts.util");
            String loc = RTConfig.getString(ARG_LOCALE, "en");
            String key = RTConfig.getString(ARG_KEY, "");
            Locale locale = I18N.getLocale(loc);
            Print.sysPrintln("Package: " + pkg, new Object[0]);
            Print.sysPrintln("Locale : " + locale + " [" + loc + I18N_KEY_END, new Object[0]);
            Print.sysPrintln("Key    : " + key, new Object[0]);
            I18N i18n = I18N.getI18N(pkg, locale);
            if (i18n != null) {
                Print.sysPrintln("String : " + i18n.getString(key, "Undefined"), new Object[0]);
            } else {
                Print.sysPrintln("Package resource not found", new Object[0]);
            }
            System.exit(0);
        }
        if (RTConfig.hasProperty("test")) {
            I18N i18n = I18N.getI18N(I18N.class, null);
            i18n.printKeyValues();
            String m3 = i18n.getString("m.m3", "{0}", new Object(){

                public String toString() {
                    return mainStr;
                }
            });
            String m2 = i18n.getString("m.m2", "How Now Brown {0}", m3);
            String m1 = i18n.getString("m.m1", "Message: \\n{0}", m2);
            Print.sysPrintln(m1, new Object[0]);
            mainStr = "Horse";
            Print.sysPrintln(m1, new Object[0]);
        }
    }

    public static class Text {
        private String pkg = null;
        private String key = "";
        private String dft = "";

        public Text() {
            this((String)null, null, null);
        }

        public Text(String dft) {
            this((String)null, null, dft);
        }

        public Text(String pkg, String key, String dft) {
            this.pkg = pkg != null && !pkg.equals("") ? pkg : null;
            this.key = key != null ? key : "";
            this.dft = dft != null ? dft : "";
        }

        public Text(Class clazz, String key, String dft) {
            this.pkg = clazz != null ? clazz.getPackage().getName() : null;
            this.key = key != null ? key : "";
            this.dft = dft != null ? dft : "";
        }

        public boolean hasPackage() {
            return !StringTools.isBlank(this.getPackage());
        }

        public String getPackage() {
            return this.pkg;
        }

        public boolean hasKey() {
            return !StringTools.isBlank(this.getKey());
        }

        public String getKey() {
            return this.key;
        }

        public String getDefault() {
            return I18N.decodeNewLine(this.dft);
        }

        public String getDefault(boolean decodeNewLine) {
            return decodeNewLine ? I18N.decodeNewLine(this.dft) : this.dft;
        }

        public String toString() {
            String locStr = RTConfig.getString("session.locale", null);
            if (StringTools.isBlank(locStr)) {
                return this.getDefault();
            }
            Locale loc = I18N.getLocale(locStr);
            return this.toString(loc);
        }

        public String toString(I18N i18n) {
            return this.toString(i18n, this.dft);
        }

        public String toString(I18N i18n, String dftVal) {
            String dv;
            String string = dv = dftVal != null ? dftVal : this.dft;
            if (i18n != null) {
                return i18n.getString(this.getKey(), dv);
            }
            return I18N.decodeNewLine(dv);
        }

        public String toString(Locale loc) {
            return this.toString(loc, this.dft);
        }

        public String toString(Locale loc, String dftVal) {
            String dv;
            String string = dv = dftVal != null ? dftVal : this.dft;
            if (loc != null && this.pkg != null) {
                return this.toString(I18N.getI18N(this.pkg, loc), dv);
            }
            return I18N.decodeNewLine(dv);
        }

        public boolean equals(Object other) {
            if (!(other instanceof Text)) {
                return false;
            }
            Text that = (Text)other;
            if (!this.getKey().equals(that.getKey())) {
                return false;
            }
            if (!this.getDefault(false).equals(that.getDefault(false))) {
                return true;
            }
            if (this.hasPackage() != that.hasPackage()) {
                return false;
            }
            return !this.hasPackage() || this.getPackage().equals(that.getPackage());
        }
    }
}

