/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.util;

import java.awt.Color;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.NoRouteToHostException;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Properties;
import org.opengts.util.ColorTools;
import org.opengts.util.FileTools;
import org.opengts.util.PixelDimension;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;
import org.opengts.util.StringTools;
import org.opengts.util.URIArg;

public class HTMLTools {
    public static final String PROP_HTMLTools_MIME_ = "HTMLTools.MIME.";
    public static final String SP = "&nbsp;";
    public static final String LT = "&lt;";
    public static final String GT = "&gt;";
    public static final String AMP = "&amp;";
    public static final String QUOTE = "&quote;";
    public static final String BR = "<BR>";
    public static final String HR = "<HR>";
    public static final String HTML = "<html>";
    public static final String REQUEST_GET = "GET";
    public static final String REQUEST_POST = "POST";
    public static final byte[] MAGIC_GIF_87a = new byte[]{71, 73, 70, 56, 55, 97};
    public static final byte[] MAGIC_GIF_89a = new byte[]{71, 73, 70, 56, 57, 97};
    public static final byte[] MAGIC_JPEG = new byte[]{-1, -40, -1, -32};
    public static final byte[] MAGIC_JPEG_C = new byte[]{-1, -40, -1, -2};
    public static final byte[] MAGIC_PNG = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
    public static final byte[] MAGIC_TIFF_II = new byte[]{73, 73, 42, 0};
    public static final byte[] MAGIC_TIFF_MM = new byte[]{77, 77, 0, 42};
    public static final byte[] MAGIC_BMP = new byte[]{66, 77};
    public static final byte[] MAGIC_JAVA_CLASS = new byte[]{-54, -2, -70, -66};
    public static final String CHARSET_UTF8 = "charset=UTF-8";
    public static final String HEADER_CONTENT_TYPE = "Content-Type";
    public static final String HEADER_CONTENT_DISPOSITION = "Content-Disposition";
    public static final String HEADER_CONTENT_LENGTH = "Content-Length";
    public static final String HEADER_USER_AGENT = "User-Agent";
    public static final String HEADER_REFERER = "Referer";
    public static final String HEADER_HOST = "Host";
    public static final String HEADER_SOAPACTION = "SOAPAction";
    public static final String HEADER_ACCESS_CONTROL_ALLOW_ORIGIN = "Access-Control-Allow-Origin";
    public static final String PROP_User_Agent = "User-Agent";
    public static final String DEFAULT_USER_AGENT = "HTMLTools/1.4";
    private static String HTTPUserAgent = null;
    public static final String CONTENT_FORM_MULTIPART = "multipart/form-data";
    public static final String CONTENT_FORM_URLENCODED = "application/x-www-form-urlencoded";
    public static final String CONTENT_TYPE_PLAIN = "text/plain";
    public static final String CONTENT_TYPE_TEXT = "text/plain";
    public static final String CONTENT_TYPE_XML = "text/xml";
    public static final String CONTENT_TYPE_HTML = "text/html";
    public static final String CONTENT_TYPE_GIF = "image/gif";
    public static final String CONTENT_TYPE_JPEG = "image/jpeg";
    public static final String CONTENT_TYPE_PNG = "image/png";
    public static final String CONTENT_TYPE_TIFF = "image/tiff";
    public static final String CONTENT_TYPE_BMP = "image/bmp";
    public static final String CONTENT_TYPE_OCTET = "application/octet-stream";
    public static final String CONTENT_TYPE_BINARY = "application/binary";
    public static final String CONTENT_TYPE_DOC = "application/msword";
    public static final String CONTENT_TYPE_XLS = "application/vnd.ms-excel";
    public static final String CONTENT_TYPE_XLSX = "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet";
    public static final String CONTENT_TYPE_CSV_OLD = "text/comma-separated-values";
    public static final String CONTENT_TYPE_CSV = "text/csv";
    public static final String CONTENT_TYPE_PDF = "application/pdf";
    public static final String CONTENT_TYPE_PS = "application/postscript";
    public static final String CONTENT_TYPE_ZIP = "application/x-zip-compressed";
    public static final String CONTENT_TYPE_JAD = "text/vnd.sun.j2me.app-descriptor";
    public static final String CONTENT_TYPE_JAR = "application/java-archive";
    public static final String CONTENT_TYPE_KML_XML = "application/vnd.google-earth.kml+xml kml";
    public static final String CONTENT_TYPE_KML = "application/vnd.google-earth.kml+xml";
    public static final String CONTENT_TYPE_KMZ = "application/vnd.google-earth.kmz";
    public static final String CONTENT_TYPE_JSON = "application/jsonrequest";
    public static final String CONTENT_TYPE_MOV = "video/quicktime";
    public static final String CONTENT_TYPE_MPEG = "video/mpeg";
    public static final String CONTENT_TYPE_ENTITY_CSV = "gts/entity-csv";
    public static final TagBlock TAG_HTML = new TagBlock("<html>", "</html>");
    public static final TagBlock TAG_H1 = new TagBlock("<h1>", "</h1>");
    public static final TagBlock TAG_H2 = new TagBlock("<h2>", "</h2>");
    public static final TagBlock TAG_H3 = new TagBlock("<h3>", "</h3>");
    public static final TagBlock TAG_CENTER = new TagBlock("<center>", "</center>");
    public static final TagBlock TAG_BLOCKQUOTE = new TagBlock("<blockquote>", "</blockquote>");
    public static final TagBlock TAG_RIGHT = new TagBlock("<div align=right>", "</div>");
    public static final TagBlock TAG_BOLD = new TagBlock("<B>", "</B>");
    public static final TagBlock TAG_ITALIC = new TagBlock("<I>", "</I>");
    public static final TagBlock TAG_MONOSPACE = new TagBlock("<tt>", "</tt>");
    public static final TagBlock TAG_MONORIGHT = new TagBlock(TAG_MONOSPACE, TAG_RIGHT);
    public static final TagBlock TAG_MONOCENTER = new TagBlock(TAG_MONOSPACE, TAG_CENTER);
    public static final TagBlock TAG_RED = HTMLTools.TAG_COLOR("#FF0000");
    public static final TagBlock TAG_REDBOLD = new TagBlock(TAG_BOLD, TAG_RED);
    public static final TagBlock TAG_GREEN = HTMLTools.TAG_COLOR("#007700");
    public static final TagBlock TAG_GREENBOLD = new TagBlock(TAG_BOLD, TAG_GREEN);
    public static final TagBlock TAG_BLUE = HTMLTools.TAG_COLOR("#0000FF");
    public static final TagBlock TAG_BLUEBOLD = new TagBlock(TAG_BOLD, TAG_BLUE);
    public static final TagBlock TAG_SMALLFONT = new TagBlock("<font size=-1>", "</font>");
    public static final TagBlock TAG_SMALLCENTER = new TagBlock(TAG_SMALLFONT, TAG_CENTER);
    public static final TagBlock TAG_NUMBERLIST = new TagBlock("<ol>", "</ol>");
    public static final TagBlock TAG_BULLETLIST = new TagBlock("<ul>", "</ul>");
    public static final TagBlock TAG_LISTITEM = new TagBlock("<li>", "</li>");
    private static final String ENC_CHARS = " %=<>&'\"";
    private static final String[] ARG_GET = new String[]{"get"};
    private static final String[] ARG_POST = new String[]{"post"};
    private static final String[] ARG_POSTDATA = new String[]{"postData"};
    private static final String[] ARG_DECODE = new String[]{"decode", "dec"};
    private static final String[] ARG_IMAGE_DIM = new String[]{"imageDim", "dim"};

    public static void setHttpUserAgent(String userAgent) {
        HTTPUserAgent = userAgent;
    }

    public static String getHttpUserAgent() {
        if (!StringTools.isBlank(HTTPUserAgent)) {
            return HTTPUserAgent;
        }
        return RTConfig.getString("http.userAgent", DEFAULT_USER_AGENT);
    }

    public static boolean isContentMultipartForm(String ct) {
        return ct != null ? ct.toLowerCase().startsWith(CONTENT_FORM_MULTIPART) : false;
    }

    public static String getContentMultipartBoundary(String ct) {
        int p;
        int n = p = ct != null ? ct.indexOf("boundary=") : -1;
        if (p < 0) {
            return null;
        }
        String b = ct.substring(p + 9);
        if (b.startsWith("\"")) {
            int q = b.lastIndexOf("\"");
            b = q > 0 ? b.substring(1, q) : b.substring(1);
        }
        return b;
    }

    public static String MIME_ZIP() {
        return HTMLTools.getMimeType("zip", CONTENT_TYPE_ZIP);
    }

    public static String MIME_PLAIN() {
        return HTMLTools.getMimeType("plain", "text/plain");
    }

    public static String MIME_HTML() {
        return HTMLTools.getMimeType("html", CONTENT_TYPE_HTML);
    }

    public static String MIME_XML() {
        return HTMLTools.getMimeType("xml", CONTENT_TYPE_XML);
    }

    public static String MIME_XML(String charSet) {
        return HTMLTools.getMimeTypeCharset(HTMLTools.MIME_XML(), charSet);
    }

    public static String MIME_CSV() {
        return HTMLTools.getMimeType("csv", CONTENT_TYPE_CSV);
    }

    public static String MIME_XLS() {
        return HTMLTools.getMimeType("xls", CONTENT_TYPE_XLS);
    }

    public static String MIME_XLSX() {
        return HTMLTools.getMimeType("xlsx", CONTENT_TYPE_XLSX);
    }

    public static String MIME_KML() {
        return HTMLTools.getMimeType("kml", CONTENT_TYPE_KML);
    }

    public static String MIME_JSON() {
        return HTMLTools.getMimeType("json", CONTENT_TYPE_JSON);
    }

    public static String MIME_BINARY() {
        return HTMLTools.getMimeType("binary", CONTENT_TYPE_BINARY);
    }

    public static String MIME_PNG() {
        return HTMLTools.getMimeType("png", CONTENT_TYPE_PNG);
    }

    public static String MIME_GIF() {
        return HTMLTools.getMimeType("gif", CONTENT_TYPE_GIF);
    }

    public static String MIME_JPEG() {
        return HTMLTools.getMimeType("jpeg", CONTENT_TYPE_JPEG);
    }

    public static String MIME_TIFF() {
        return HTMLTools.getMimeType("tiff", CONTENT_TYPE_TIFF);
    }

    public static String MIME_BMP() {
        return HTMLTools.getMimeType("bmp", CONTENT_TYPE_BMP);
    }

    public static String MIME_MOV() {
        return HTMLTools.getMimeType("mov", CONTENT_TYPE_MOV);
    }

    public static String MIME_MPEG() {
        return HTMLTools.getMimeType("mpeg", CONTENT_TYPE_MPEG);
    }

    public static String getMimeType(String name, String dftType) {
        String mimeKey = PROP_HTMLTools_MIME_ + name;
        String mimeType = RTConfig.getString(mimeKey, null);
        if (!StringTools.isBlank(mimeType)) {
            return mimeType;
        }
        if (!StringTools.isBlank(dftType)) {
            return dftType;
        }
        return HTMLTools.getMimeTypeFromExtension(name, dftType);
    }

    public static String getMimeTypeCharset(String type) {
        return HTMLTools.getMimeTypeCharset(type, StringTools.getCharacterEncoding());
    }

    public static String getMimeTypeCharset(String type, String charSet) {
        if (StringTools.isBlank(type) || StringTools.isBlank(charSet)) {
            return type;
        }
        return type + "; charset=" + charSet;
    }

    public static String getMimeTypeFromExtension(String extn) {
        return HTMLTools.getMimeTypeFromExtension(extn, CONTENT_TYPE_OCTET);
    }

    public static String getMimeTypeFromExtension(String extn, String dft) {
        if (extn == null) {
            return dft;
        }
        if (extn.equalsIgnoreCase("gif")) {
            return CONTENT_TYPE_GIF;
        }
        if (extn.equalsIgnoreCase("jpeg") || extn.equalsIgnoreCase("jpg")) {
            return CONTENT_TYPE_JPEG;
        }
        if (extn.equalsIgnoreCase("png")) {
            return CONTENT_TYPE_PNG;
        }
        if (extn.equalsIgnoreCase("mov")) {
            return CONTENT_TYPE_MOV;
        }
        if (extn.equalsIgnoreCase("mpeg") || extn.equalsIgnoreCase("mpg")) {
            return CONTENT_TYPE_MPEG;
        }
        if (extn.equalsIgnoreCase("js")) {
            return "text/plain";
        }
        if (extn.equalsIgnoreCase("plain") || extn.equalsIgnoreCase("txt") || extn.equalsIgnoreCase("text")) {
            return "text/plain";
        }
        if (extn.equalsIgnoreCase("out") || extn.equalsIgnoreCase("conf")) {
            return "text/plain";
        }
        if (extn.equalsIgnoreCase("xml") || extn.equalsIgnoreCase("dtd")) {
            return CONTENT_TYPE_XML;
        }
        if (extn.equalsIgnoreCase("xls")) {
            return CONTENT_TYPE_XLS;
        }
        if (extn.equalsIgnoreCase("kml")) {
            return CONTENT_TYPE_KML;
        }
        if (extn.equalsIgnoreCase("kmz")) {
            return CONTENT_TYPE_KMZ;
        }
        if (extn.equalsIgnoreCase("json")) {
            return CONTENT_TYPE_JSON;
        }
        if (extn.equalsIgnoreCase("html") || extn.equalsIgnoreCase("htm")) {
            return CONTENT_TYPE_HTML;
        }
        if (extn.equalsIgnoreCase("pdf")) {
            return CONTENT_TYPE_PDF;
        }
        if (extn.equalsIgnoreCase("ps")) {
            return CONTENT_TYPE_PS;
        }
        if (extn.equalsIgnoreCase("doc")) {
            return CONTENT_TYPE_DOC;
        }
        if (extn.equalsIgnoreCase("csv")) {
            return CONTENT_TYPE_CSV;
        }
        if (extn.equalsIgnoreCase("xls")) {
            return CONTENT_TYPE_XLS;
        }
        if (extn.equalsIgnoreCase("xlsx")) {
            return CONTENT_TYPE_XLSX;
        }
        if (extn.equalsIgnoreCase("zip")) {
            return CONTENT_TYPE_ZIP;
        }
        if (extn.equalsIgnoreCase("jad")) {
            return CONTENT_TYPE_JAD;
        }
        if (extn.equalsIgnoreCase("jar")) {
            return CONTENT_TYPE_JAR;
        }
        if (extn.equalsIgnoreCase("binary") || extn.equalsIgnoreCase("bin")) {
            return CONTENT_TYPE_BINARY;
        }
        if (extn.equalsIgnoreCase("octet")) {
            return CONTENT_TYPE_OCTET;
        }
        return dft;
    }

    public static String getMimeTypeFromData(byte[] data) {
        return HTMLTools.getMimeTypeFromData(data, CONTENT_TYPE_OCTET);
    }

    public static String getMimeTypeFromData(byte[] data, String dft) {
        if (data == null) {
            return dft;
        }
        if (StringTools.compareEquals(data, MAGIC_GIF_87a, MAGIC_GIF_87a.length)) {
            return CONTENT_TYPE_GIF;
        }
        if (StringTools.compareEquals(data, MAGIC_GIF_89a, MAGIC_GIF_89a.length)) {
            return CONTENT_TYPE_GIF;
        }
        if (StringTools.compareEquals(data, MAGIC_JPEG, MAGIC_JPEG.length)) {
            return CONTENT_TYPE_JPEG;
        }
        if (StringTools.compareEquals(data, MAGIC_JPEG_C, MAGIC_JPEG_C.length)) {
            return CONTENT_TYPE_JPEG;
        }
        if (StringTools.compareEquals(data, MAGIC_PNG, MAGIC_PNG.length)) {
            return CONTENT_TYPE_PNG;
        }
        if (StringTools.compareEquals(data, MAGIC_TIFF_II, MAGIC_TIFF_II.length)) {
            return CONTENT_TYPE_TIFF;
        }
        if (StringTools.compareEquals(data, MAGIC_TIFF_MM, MAGIC_TIFF_MM.length)) {
            return CONTENT_TYPE_TIFF;
        }
        if (StringTools.compareEquals(data, MAGIC_BMP, MAGIC_BMP.length)) {
            return CONTENT_TYPE_BMP;
        }
        return dft;
    }

    public static String getExtensionFromMimeType(String mime, String dft) {
        String me;
        if (StringTools.isBlank(mime)) {
            return dft;
        }
        String m = mime.trim().toLowerCase();
        int mp = m.indexOf("/");
        String mt = mp >= 0 ? m.substring(0, mp).trim() : "";
        String string = me = mp >= 0 ? m.substring(mp + 1).trim() : m;
        if (StringTools.isBlank(me)) {
            return dft;
        }
        if (mt.equals("image")) {
            return !StringTools.isBlank(me) ? me : dft;
        }
        if (mt.equals("text")) {
            if (me.equals("plain") || me.equals("txt") || me.equals("text")) {
                return "txt";
            }
            if (me.equals("xml")) {
                return "xml";
            }
            if (me.equals("cvs") || me.startsWith("comma-")) {
                return "csv";
            }
            if (me.equals("html")) {
                return "html";
            }
            if (me.equals("jad") || me.startsWith("vnd.sun.j2me")) {
                return "jad";
            }
            return me;
        }
        if (mt.equals("application")) {
            if (me.startsWith("octet-")) {
                return "bin";
            }
            if (me.startsWith("bin")) {
                return "bin";
            }
            if (me.equals("doc") || me.equals("msword")) {
                return "doc";
            }
            if (me.equals("xls") || me.equals("vnd.ms-excel")) {
                return "xls";
            }
            if (me.equals("xlsx") || me.startsWith("vnd.openxmlformats-")) {
                return "xlsx";
            }
            if (me.equals("pdf")) {
                return "pdf";
            }
            if (me.equals("ps") || me.equals("postscript")) {
                return "ps";
            }
            if (me.equals("zip") || me.startsWith("x-zip")) {
                return "zip";
            }
            if (me.equals("jar") || me.startsWith("java-arch")) {
                return "jar";
            }
            if (me.equals("kml") || me.startsWith("vnd.google-earth.kml")) {
                return "kml";
            }
            if (me.equals("kmz") || me.startsWith("vnd.google-earth.kmz")) {
                return "kmz";
            }
            if (me.startsWith("json")) {
                return "json";
            }
            return me;
        }
        return me;
    }

    public static PixelDimension getImageDimension(byte[] D) {
        if (D == null || D.length < 16) {
            Print.logError("Invalid file/data length", new Object[0]);
            return null;
        }
        if (StringTools.compareEquals(D, MAGIC_GIF_87a, MAGIC_GIF_87a.length)) {
            if (D.length < 10) {
                Print.logWarn("Invalid image data length: " + D.length, new Object[0]);
                return null;
            }
            int W = (D[7] & 0xFF) << 8 | D[6] & 0xFF;
            int H = (D[9] & 0xFF) << 8 | D[8] & 0xFF;
            return new PixelDimension(W, H);
        }
        if (StringTools.compareEquals(D, MAGIC_GIF_89a, MAGIC_GIF_89a.length)) {
            if (D.length < 10) {
                Print.logWarn("Invalid image data length: " + D.length, new Object[0]);
                return null;
            }
            int W = (D[7] & 0xFF) << 8 | D[6] & 0xFF;
            int H = (D[9] & 0xFF) << 8 | D[8] & 0xFF;
            return new PixelDimension(W, H);
        }
        if (StringTools.compareEquals(D, MAGIC_JPEG, MAGIC_JPEG.length) || StringTools.compareEquals(D, MAGIC_JPEG_C, MAGIC_JPEG_C.length)) {
            int i = 4;
            if (D[3] == -32 && (D[i + 2] != 74 || D[i + 3] != 70 || D[i + 4] != 73 || D[i + 5] != 70 || D[i + 6] != 0)) {
                Print.logWarn("JPEG: 'JFIF' not found", new Object[0]);
                return null;
            }
            int blockLen = (D[i] & 0xFF) << 8 | D[i + 1] & 0xFF;
            while (i < D.length) {
                if ((i += blockLen) >= D.length) {
                    Print.logWarn("JPEG: beyond EOF @" + i, new Object[0]);
                    return null;
                }
                if (D[i] != -1) {
                    Print.logWarn("JPEG: expecting 0xFF @" + i, new Object[0]);
                    return null;
                }
                if (D[i + 1] == -64) {
                    int H = (D[i + 5] & 0xFF) << 8 | D[i + 6] & 0xFF;
                    int W = (D[i + 7] & 0xFF) << 8 | D[i + 8] & 0xFF;
                    return new PixelDimension(W, H);
                }
                blockLen = (D[i += 2] & 0xFF) << 8 | D[i + 1] & 0xFF;
            }
            Print.logWarn("JPEG: dimension not found", new Object[0]);
            return null;
        }
        if (StringTools.compareEquals(D, MAGIC_PNG, MAGIC_PNG.length)) {
            if (D.length < 24) {
                Print.logWarn("Invalid image data length: " + D.length, new Object[0]);
                return null;
            }
            int W = (D[16] & 0xFF) << 24 | (D[17] & 0xFF) << 16 | (D[18] & 0xFF) << 8 | D[19] & 0xFF;
            int H = (D[20] & 0xFF) << 24 | (D[21] & 0xFF) << 16 | (D[22] & 0xFF) << 8 | D[23] & 0xFF;
            return new PixelDimension(W, H);
        }
        if (StringTools.compareEquals(D, MAGIC_TIFF_II, MAGIC_TIFF_II.length)) {
            Print.logWarn("TIFF: not supported", new Object[0]);
            return null;
        }
        if (StringTools.compareEquals(D, MAGIC_TIFF_MM, MAGIC_TIFF_MM.length)) {
            Print.logWarn("TIFF: not supported", new Object[0]);
            return null;
        }
        if (StringTools.compareEquals(D, MAGIC_BMP, MAGIC_BMP.length)) {
            Print.logWarn("BMP: not supported", new Object[0]);
            return null;
        }
        Print.logWarn("Image type not found: 0x" + StringTools.toHexString(D, 0, 20) + " ...", new Object[0]);
        return null;
    }

    public static TagBlock TAG_COLOR(Color c) {
        return HTMLTools.TAG_COLOR(ColorTools.toHexString(c));
    }

    public static TagBlock TAG_COLOR(String cs) {
        if (cs != null && !cs.startsWith("#")) {
            cs = "#" + cs;
        }
        return new TagBlock("<font color=\"" + cs + "\">", "</font>");
    }

    public static TagBlock TAG_TOOLTIP(String tip) {
        String t = StringTools.quoteString(tip);
        return new TagBlock("<span title=" + t + ">", "</span>");
    }

    public static TagBlock TAG_LINK(String url) {
        return new TagBlock("<a href=\"" + url + "\">", "</a>");
    }

    public static TagBlock TAG_LINK(String url, boolean newWindow) {
        StringBuffer a = new StringBuffer();
        a.append("<a href=\"").append(url).append("\"");
        if (newWindow) {
            a.append(" target='_blank'");
        }
        a.append(">");
        return new TagBlock(a.toString(), "</a>");
    }

    public static String encodeParameter(Object text) {
        String s = text.toString();
        char[] ch = new char[s.length()];
        s.getChars(0, s.length(), ch, 0);
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < ch.length; ++i) {
            if (ENC_CHARS.indexOf(ch[i]) >= 0) {
                int x = ch[i] + 256;
                sb.append("%" + Integer.toHexString(x).substring(1).toUpperCase());
                continue;
            }
            sb.append(ch[i]);
        }
        return sb.toString();
    }

    public static String decodeParameter(String text) {
        StringBuffer sb = new StringBuffer();
        if (!StringTools.isBlank(text)) {
            for (int i = 0; i < text.length(); ++i) {
                char ch = text.charAt(i);
                if (ch == '%' && i + 2 < text.length()) {
                    int h1 = StringTools.hexIndex(text.charAt(i + 1));
                    int h2 = StringTools.hexIndex(text.charAt(i + 2));
                    if (h1 >= 0 && h2 >= 0) {
                        sb.append((char)(h1 * 16 + h2));
                        i += 2;
                        continue;
                    }
                }
                sb.append(ch);
            }
        }
        return sb.toString();
    }

    public static String color(Color color) {
        int ci = 0;
        ci |= color.getRed() << 16 & 0xFF0000;
        ci |= color.getGreen() << 8 & 0xFF00;
        String cs = Integer.toHexString((ci |= color.getBlue() << 0 & 0xFF) | 0x1000000).substring(1).toUpperCase();
        return "#" + cs;
    }

    public static String createLink(String ref, Object text) {
        return HTMLTools.createLink(ref, true, text, true);
    }

    public static String createLink(String ref, boolean newWindow, Object text) {
        return HTMLTools.createLink(ref, newWindow, text, true);
    }

    public static String createLink(String ref, boolean newWindow, Object text, boolean filterText) {
        String t = text != null ? text.toString() : "";
        StringBuffer sb = new StringBuffer();
        sb.append("<a href='").append(ref).append("'");
        if (newWindow) {
            sb.append(" target='_blank'");
        }
        sb.append(">");
        sb.append(filterText ? StringTools.htmlFilterText(t) : t);
        sb.append("</a>");
        return sb.toString();
    }

    public static String font(String family, String style, String variant, String weight, int ptsize) {
        StringBuffer sb = new StringBuffer();
        sb.append("<span style='");
        if (family != null && !family.equals("")) {
            sb.append("font-family:").append(family).append(";");
        }
        if (style != null && !style.equals("")) {
            sb.append("font-style:").append(style).append(";");
        }
        if (variant != null && !variant.equals("")) {
            sb.append("font-variant:").append(variant).append(";");
        }
        if (weight != null && !weight.equals("")) {
            sb.append("font-weight:").append(weight).append(";");
        }
        if (ptsize > 0) {
            sb.append("font-size:").append(ptsize).append("pt;");
        }
        sb.append("'>");
        return sb.toString();
    }

    public static String _font() {
        return "</span>";
    }

    public static String startJavaScript() {
        return "<script language='JavaScript'><!--";
    }

    public static String endJavaScript() {
        return "// --></script>";
    }

    public static String autoRefresh(int delay, String url) {
        StringBuffer sb = new StringBuffer();
        sb.append("<meta http-equiv='Refresh' ");
        sb.append("content='").append(delay).append(";URL=").append(url).append("'>");
        return sb.toString();
    }

    public static byte[] readPage_POST(String pageURLStr, String contentType, byte[] postData, int timeoutMS) throws IOException {
        URL pageURL = new URL(pageURLStr);
        return HTMLTools.readPage_POST(pageURL, contentType, postData, timeoutMS);
    }

    public static byte[] readPage_POST(URL pageURL, String contentType, byte[] postData, int timeoutMS) throws IOException {
        if (!StringTools.isBlank(contentType)) {
            Properties hp = new Properties();
            hp.setProperty(HEADER_CONTENT_TYPE, contentType);
            return HTMLTools.readPage_POST(pageURL, hp, postData, timeoutMS);
        }
        return HTMLTools.readPage_POST(pageURL, (Properties)null, postData, timeoutMS);
    }

    public static byte[] readPage_POST(String pageURLStr, Properties headerProps, byte[] postData, int timeoutMS) throws IOException {
        URL pageURL = new URL(pageURLStr);
        return HTMLTools.readPage_POST(pageURL, headerProps, postData, timeoutMS);
    }

    public static byte[] readPage_POST(URL pageURL, Properties headerProps, byte[] postData, int timeoutMS) throws IOException {
        if (pageURL == null) {
            return null;
        }
        byte[] data = null;
        HttpURLConnection httpConnect = null;
        OutputStream postOutput = null;
        InputStream postInput = null;
        try {
            httpConnect = (HttpURLConnection)pageURL.openConnection();
            httpConnect.setRequestMethod(REQUEST_POST);
            httpConnect.setAllowUserInteraction(false);
            httpConnect.setDoInput(true);
            httpConnect.setDoOutput(true);
            httpConnect.setUseCaches(false);
            httpConnect.setRequestProperty("User-Agent", HTMLTools.getHttpUserAgent());
            if (timeoutMS >= 0) {
                httpConnect.setConnectTimeout(timeoutMS);
            }
            if (headerProps != null) {
                Enumeration<?> pe = headerProps.propertyNames();
                while (pe.hasMoreElements()) {
                    String hk = (String)pe.nextElement();
                    String hv = headerProps.getProperty(hk);
                    httpConnect.setRequestProperty(hk, hv);
                }
            }
            if (postData != null) {
                httpConnect.setRequestProperty(HEADER_CONTENT_LENGTH, String.valueOf(postData.length));
                postOutput = httpConnect.getOutputStream();
                postOutput.write(postData);
                postOutput.flush();
            }
            httpConnect.connect();
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            postInput = new HttpBufferedInputStream(httpConnect);
            FileTools.copyStreams(postInput, output);
            data = output.toByteArray();
        }
        catch (IOException ioe) {
            if (httpConnect != null) {
                throw new HttpIOException(ioe, httpConnect);
            }
            throw ioe;
        }
        finally {
            if (postOutput != null) {
                postOutput.close();
            }
            if (postInput != null) {
                postInput.close();
            }
            if (httpConnect != null) {
                httpConnect.disconnect();
            }
        }
        return data;
    }

    public static byte[] readPage_GET(String pageURLStr, int timeoutMS) throws Throwable {
        URL pageURL = new URL(pageURLStr);
        return HTMLTools.readPage_GET(pageURL, timeoutMS);
    }

    public static byte[] readPage_GET(URL pageURL, int timeoutMS) throws Throwable {
        byte[] data = null;
        HttpURLConnection httpConnect = null;
        try {
            httpConnect = (HttpURLConnection)pageURL.openConnection();
            httpConnect.setAllowUserInteraction(false);
            httpConnect.setRequestMethod(REQUEST_GET);
            httpConnect.setRequestProperty("User-Agent", HTMLTools.getHttpUserAgent());
            if (timeoutMS >= 0) {
                httpConnect.setConnectTimeout(timeoutMS);
            }
            httpConnect.connect();
            int contentLen = httpConnect.getContentLength();
            if (contentLen > 0 || contentLen == -1) {
                HttpBufferedInputStream hbis = new HttpBufferedInputStream(httpConnect);
                data = FileTools.readStream(hbis);
            } else {
                data = new byte[]{};
            }
        }
        catch (IOException ioe) {
            if (httpConnect != null) {
                throw new HttpIOException(ioe, httpConnect);
            }
            throw ioe;
        }
        finally {
            if (httpConnect != null) {
                httpConnect.disconnect();
            }
        }
        return data;
    }

    public static byte[] readPage_GET_LogError(String pageURLStr, int timeoutMS) {
        try {
            URL pageURL = new URL(pageURLStr);
            return HTMLTools.readPage_GET_LogError(pageURL, timeoutMS);
        }
        catch (MalformedURLException mue) {
            Print.logError(mue.toString(), new Object[0]);
            return null;
        }
    }

    public static byte[] readPage_GET_LogError(URL pageURL, int timeoutMS) {
        try {
            return HTMLTools.readPage_GET(pageURL, timeoutMS);
        }
        catch (UnknownHostException uhe) {
            Print.logError(uhe.toString(), new Object[0]);
        }
        catch (NoRouteToHostException nrthe) {
            Print.logError(nrthe.toString(), new Object[0]);
        }
        catch (ConnectException ce) {
            Print.logError(ce.toString(), new Object[0]);
        }
        catch (SocketException se) {
            Print.logError(se.toString(), new Object[0]);
        }
        catch (FileNotFoundException fnfe) {
            Print.logError(fnfe.toString(), new Object[0]);
        }
        catch (Throwable t) {
            Print.logStackTrace("Read page", t);
        }
        return null;
    }

    public static HttpBufferedInputStream inputStream_GET(String pageURLStr, int timeoutMS) throws IOException {
        URL pageURL = new URL(pageURLStr);
        return HTMLTools.inputStream_GET(pageURL, timeoutMS);
    }

    public static HttpBufferedInputStream inputStream_GET(URL pageURL, int timeoutMS) throws IOException {
        HttpURLConnection httpConnect = (HttpURLConnection)pageURL.openConnection();
        httpConnect.setAllowUserInteraction(false);
        httpConnect.setRequestMethod(REQUEST_GET);
        httpConnect.setRequestProperty("User-Agent", HTMLTools.getHttpUserAgent());
        if (timeoutMS >= 0) {
            httpConnect.setConnectTimeout(timeoutMS);
        }
        try {
            httpConnect.connect();
            int contentLen = httpConnect.getContentLength();
            if (contentLen > 0 || contentLen == -1) {
                return new HttpBufferedInputStream(httpConnect);
            }
            httpConnect.disconnect();
            return null;
        }
        catch (IOException ioe) {
            throw new HttpIOException(ioe, httpConnect);
        }
    }

    public static StringBuffer createIFrameTemplate(String srcURL, StringBuffer sb) {
        return HTMLTools.createIFrameTemplate(-1, -1, srcURL, sb);
    }

    public static String createIFrameTemplate(String srcURL) {
        return HTMLTools.createIFrameTemplate(-1, -1, srcURL, null).toString();
    }

    public static String createIFrameTemplate(int w, int h, String srcURL) {
        return HTMLTools.createIFrameTemplate(w, h, srcURL, null).toString();
    }

    public static StringBuffer createIFrameTemplate(int w, int h, String srcURL, StringBuffer sb) {
        if (sb == null) {
            sb = new StringBuffer();
        }
        String id = "id.iframe";
        String ws = w > 0 ? String.valueOf(w) : "100%";
        String hs = h > 0 ? String.valueOf(h) : "100%";
        sb.append("<IFRAME WIDTH='" + ws + "' HEIGHT='" + hs + "' FRAMEBORDER='0' ID='" + id + "' SRC='" + srcURL + "'>\n");
        sb.append("<ILAYER WIDTH='" + ws + "' HEIGHT='" + hs + "' FRAMEBORDER='0' ID='" + id + "' SRC='" + srcURL + "'>\n");
        sb.append("InternetExplorer or Netscape is required to view this page\n");
        sb.append("</ILAYER>\n");
        sb.append("</IFRAME>\n");
        return sb;
    }

    public static void main(String[] argv) {
        RTConfig.setCommandLineArgs(argv);
        if (RTConfig.hasProperty(ARG_DECODE)) {
            String s = RTConfig.getString(ARG_DECODE, "");
            Print.sysPrintln("Decoded: " + HTMLTools.decodeParameter(s), new Object[0]);
            System.exit(0);
        }
        if (RTConfig.hasProperty(ARG_GET)) {
            try {
                URIArg uri = new URIArg(RTConfig.getString(ARG_GET, ""));
                byte[] data = HTMLTools.readPage_GET(uri.toString(), -1);
                String s = StringTools.toStringValue(data);
                Print.sysPrintln("Response:\n", new Object[0]);
                Print.sysPrintln(s, new Object[0]);
                System.exit(0);
            }
            catch (Throwable th) {
                Print.logException("Error", th);
                System.exit(99);
            }
        }
        if (RTConfig.hasProperty(ARG_POST)) {
            try {
                String postURL = RTConfig.getString(ARG_POST, "");
                URIArg uri = new URIArg(postURL);
                String postDataS = RTConfig.getString(ARG_POSTDATA, uri.getArgString());
                Print.sysPrintln("Post URL : " + postURL, new Object[0]);
                Print.sysPrintln("Post Data: " + postDataS, new Object[0]);
                byte[] postData = postDataS.startsWith("0x") ? StringTools.parseHex(postDataS, new byte[0]) : postDataS.getBytes();
                String postMime = StringTools.isPrintableASCII(postData) ? "text/plain" : CONTENT_TYPE_BINARY;
                byte[] respData = HTMLTools.readPage_POST(uri.toString(), postMime, postData, -1);
                String resp = StringTools.toStringValue(respData);
                Print.sysPrintln("Response :\n", new Object[0]);
                Print.sysPrintln(resp, new Object[0]);
                System.exit(0);
            }
            catch (Throwable th) {
                Print.logException("Error", th);
                System.exit(99);
            }
        }
        if (RTConfig.hasProperty(ARG_IMAGE_DIM)) {
            File imageFile = RTConfig.getFile(ARG_IMAGE_DIM, null);
            byte[] imageData = FileTools.readFile(imageFile);
            PixelDimension dim = HTMLTools.getImageDimension(imageData);
            Print.sysPrintln("Image Dimension: " + dim, new Object[0]);
            System.exit(0);
        }
        Print.logWarn("Missing options ...", new Object[0]);
    }

    public static class TagWrap {
        private Object text = null;
        private TagBlock[] tags = null;

        public TagWrap(Object text, TagBlock[] tags) {
            this.text = text;
            this.tags = tags;
        }

        public TagWrap(Object text, TagBlock tag) {
            this(text, new TagBlock[]{tag});
        }

        public String toString(boolean html) {
            if (this.text != null) {
                if (html) {
                    String v;
                    String string = v = this.text instanceof TagWrap ? ((TagWrap)this.text).toString(html) : StringTools.htmlFilterText(this.text);
                    if (this.tags != null && this.tags.length > 0) {
                        for (int i = 0; i < this.tags.length; ++i) {
                            if (this.tags[i] == null) continue;
                            v = this.tags[i].wrap(v);
                        }
                    }
                    return v;
                }
                return this.text.toString();
            }
            return "";
        }

        public String toString() {
            return this.toString(false);
        }
    }

    public static class TagBlock {
        private String startTag = null;
        private String endTag = null;
        private TagBlock[] tagGroup = null;

        public TagBlock(String startTag, String endTag) {
            this.startTag = startTag;
            this.endTag = endTag;
        }

        public TagBlock(TagBlock[] group) {
            this((String)null, (String)null);
            this.tagGroup = group;
        }

        public TagBlock(TagBlock tb1, TagBlock tb2) {
            this(new TagBlock[]{tb1, tb2});
        }

        public TagBlock(TagBlock tb1, TagBlock tb2, TagBlock tb3) {
            this(new TagBlock[]{tb1, tb2, tb3});
        }

        public String getStartTag() {
            StringBuffer sb = new StringBuffer();
            if (this.tagGroup != null) {
                for (int i = 0; i < this.tagGroup.length; ++i) {
                    if (this.tagGroup[i] == null) continue;
                    sb.append(this.tagGroup[i].getStartTag());
                }
            }
            if (this.startTag != null) {
                sb.append(this.startTag);
            }
            return sb.toString();
        }

        public String getEndTag() {
            StringBuffer sb = new StringBuffer();
            if (this.endTag != null) {
                sb.append(this.endTag);
            }
            if (this.tagGroup != null) {
                for (int i = this.tagGroup.length - 1; i >= 0; --i) {
                    if (this.tagGroup[i] == null) continue;
                    sb.append(this.tagGroup[i].getEndTag());
                }
            }
            return sb.toString();
        }

        public StringBuffer wrap(Object text, boolean htmlFilter, StringBuffer sb) {
            if (sb == null) {
                sb = new StringBuffer();
            }
            if (text != null) {
                String v = text.toString();
                sb.append(this.getStartTag());
                sb.append(htmlFilter ? StringTools.htmlFilterText(v) : v);
                sb.append(this.getEndTag());
            }
            return sb;
        }

        public String wrap(Object text, boolean htmlFilter) {
            return this.wrap(text, htmlFilter, new StringBuffer()).toString();
        }

        public String wrap(Object text) {
            return this.wrap(text, false);
        }
    }

    public static class HttpIOException
    extends IOException {
        private int responseCode = -1;
        private String responseMessage = null;

        public HttpIOException(IOException cause, int respCode) {
            super(cause);
            this.responseCode = respCode;
            this.responseMessage = null;
        }

        public HttpIOException(IOException cause, int respCode, String respMsg) {
            super(cause);
            this.responseCode = respCode;
            this.responseMessage = respMsg;
        }

        public HttpIOException(IOException cause, HttpURLConnection httpConnect) {
            super(cause);
            if (httpConnect != null) {
                try {
                    this.responseCode = httpConnect.getResponseCode();
                    this.responseMessage = httpConnect.getResponseMessage();
                }
                catch (Throwable th) {
                    this.responseCode = -1;
                    this.responseMessage = th.getMessage();
                }
            } else {
                this.responseCode = -1;
                this.responseMessage = null;
            }
        }

        public int getResponseCode() {
            return this.responseCode;
        }

        public String getResponseMessage() {
            return this.responseMessage;
        }

        @Override
        public Throwable getCause() {
            return super.getCause();
        }

        @Override
        public String getMessage() {
            Throwable th = this.getCause();
            return th != null ? th.getMessage() : super.getMessage();
        }
    }

    public static class HttpBufferedInputStream
    extends BufferedInputStream {
        private HttpURLConnection httpConnect = null;

        public HttpBufferedInputStream(HttpURLConnection httpConnect) throws IOException {
            super(httpConnect.getInputStream());
            this.httpConnect = httpConnect;
        }

        public HttpURLConnection getHttpURLConnection() {
            return this.httpConnect;
        }

        @Override
        public void close() throws IOException {
            this.httpConnect.disconnect();
            super.close();
        }
    }
}

