/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.util;

import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import org.opengts.util.GeoBounds;
import org.opengts.util.GeoPoint;
import org.opengts.util.GeoPointProvider;
import org.opengts.util.GeozoneChecker;
import org.opengts.util.ListTools;
import org.opengts.util.Print;
import org.opengts.util.StringTools;

public class GeoPolygon
implements Cloneable {
    private String name = null;
    private GeoPoint[] boundary = null;
    private Vector<GeoPolygon> negRings = null;
    private static GeozoneChecker geozoneCheck = null;

    public static GeoPolygon parseGeoPolygon(String polyStr) {
        GeoPolygon outerRing = null;
        GeoPolygon innerRing = null;
        Vector<GeoPolygon> innerRings = new Vector<GeoPolygon>();
        boolean topLevelParent = false;
        int state = 0;
        boolean level = false;
        boolean ringCount = false;
        double latitude = 360.0;
        double longitude = 360.0;
        StringTokenizer st = new StringTokenizer(polyStr, "()/ ,", true);
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.equals(" ") || token.equals("/")) continue;
            if (token.equals("(")) {
                int oldState = state;
                if (state == 0) {
                    state = 10;
                    continue;
                }
                if (state == 10) {
                    topLevelParent = true;
                    outerRing = new GeoPolygon();
                    innerRing = null;
                    state = 11;
                    continue;
                }
                if (state == 20) {
                    innerRing = new GeoPolygon();
                    if (innerRings == null) {
                        innerRings = new Vector();
                    }
                    innerRings.add(innerRing);
                    state = 21;
                    continue;
                }
                Print.logError("Invalid Polygon state: " + state, new Object[0]);
                return null;
            }
            if (token.equals(")")) {
                int oldState = state;
                if (state == 10) {
                    state = -1;
                    continue;
                }
                if (state == 11) {
                    state = 20;
                    continue;
                }
                if (state == 13) {
                    state = 20;
                    continue;
                }
                if (state == 20) {
                    if (!topLevelParent) {
                        Print.logWarn("Found unexpected final ')'", new Object[0]);
                    }
                    state = -1;
                    continue;
                }
                if (state == 21) {
                    state = 20;
                    continue;
                }
                if (state == 23) {
                    state = 20;
                    continue;
                }
                Print.logError("Invalid Polygon state: " + state, new Object[0]);
                return null;
            }
            if (token.equals(",")) {
                int oldState = state;
                if (state == 11) {
                    Print.logWarn("Empty Outer latitude/longitude specification", new Object[0]);
                    state = 11;
                    continue;
                }
                if (state == 13) {
                    state = 11;
                    continue;
                }
                if (state == 23) {
                    state = 21;
                    continue;
                }
                Print.logError("Invalid Polygon state: " + state, new Object[0]);
                return null;
            }
            if (state == 10) {
                char ch = token.charAt(0);
                if (ch == '-' || ch == '+' || Character.isDigit(ch)) {
                    outerRing = new GeoPolygon();
                    innerRing = null;
                    latitude = StringTools.parseDouble(token, 360.0);
                    state = 12;
                    continue;
                }
                Print.logError("Invalid Polygon state: " + state, new Object[0]);
                return null;
            }
            if (state == 11) {
                latitude = StringTools.parseDouble(token, 360.0);
                state = 12;
                continue;
            }
            if (state == 21) {
                latitude = StringTools.parseDouble(token, 360.0);
                state = 22;
                continue;
            }
            if (state == 12) {
                longitude = StringTools.parseDouble(token, 360.0);
                GeoPoint gp = new GeoPoint(latitude, longitude);
                if (gp.isValid()) {
                    outerRing.addGeoPoint(gp);
                } else {
                    Print.logError("Invalid Outer GeoPoint: " + gp, new Object[0]);
                }
                state = 13;
                continue;
            }
            if (state == 22) {
                longitude = StringTools.parseDouble(token, 360.0);
                GeoPoint gp = new GeoPoint(latitude, longitude);
                if (gp.isValid()) {
                    innerRing.addGeoPoint(gp);
                } else {
                    Print.logError("Invalid Inner GeoPoint: " + gp, new Object[0]);
                }
                state = 23;
                continue;
            }
            Print.logError("Invalid Polygon state: " + state, new Object[0]);
            return null;
        }
        if (state == 20) {
            state = -1;
        } else if (state != -1) {
            Print.logError("Invalid Polygon state: " + state, new Object[0]);
            return null;
        }
        if (outerRing == null || outerRing.isEmpty()) {
            Print.logError("Empty GeoPolygon", new Object[0]);
            return null;
        }
        if (innerRings != null) {
            for (GeoPolygon negPoly : innerRings) {
                if (negPoly.isEmpty()) continue;
                outerRing.addNegativeRing(negPoly);
            }
        }
        return outerRing;
    }

    private GeoPolygon() {
    }

    public GeoPolygon(GeoPoint ... gp) {
        this.boundary = gp;
    }

    public GeoPolygon(GeoPointProvider ... gpp) {
        if (gpp != null) {
            this.boundary = new GeoPoint[gpp.length];
            for (int i = 0; i < this.boundary.length; ++i) {
                this.boundary[i] = gpp[i].getGeoPoint();
            }
        } else {
            this.boundary = null;
        }
    }

    public GeoPolygon(List<GeoPoint> gpList) {
        this.boundary = ListTools.toArray(gpList, GeoPoint.class);
    }

    public GeoPolygon(float[][] gp) {
        this.boundary = new GeoPoint[gp.length];
        for (int i = 0; i < gp.length; ++i) {
            this.boundary[i] = new GeoPoint(gp[i][0], gp[i][1]);
        }
    }

    public GeoPolygon(double[][] gp) {
        this.boundary = new GeoPoint[gp.length];
        for (int i = 0; i < gp.length; ++i) {
            this.boundary[i] = new GeoPoint(gp[i][0], gp[i][1]);
        }
    }

    public GeoPolygon(String name, GeoPoint ... gp) {
        this(gp);
        this.name = name;
    }

    public GeoPolygon(String name, List<GeoPoint> gpList) {
        this(gpList);
        this.name = name;
    }

    public GeoPolygon(String name, float[][] gp) {
        this(gp);
        this.name = name;
    }

    public GeoPolygon(String name, double[][] gp) {
        this(gp);
        this.name = name;
    }

    public GeoPolygon(GeoPolygon other) {
        if (other != null) {
            this.name = other.getName();
            this.boundary = other.getGeoPoints();
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isEmpty() {
        return ListTools.isEmpty(this.boundary);
    }

    public boolean isValid() {
        if (this.boundary == null) {
            return false;
        }
        if (GeoPolygon.isClosed(this.boundary)) {
            return this.boundary.length >= 4;
        }
        return this.boundary.length >= 3;
    }

    public static GeoPoint[] getGeoPoints(GeoPolygon geoPoly) {
        return geoPoly != null ? geoPoly.getGeoPoints() : null;
    }

    public GeoPoint[] getGeoPoints() {
        return this.boundary;
    }

    public GeoPoint getGeoPoint(int gpi) {
        if (this.boundary == null) {
            return null;
        }
        if (gpi < 0 || gpi >= this.boundary.length) {
            return null;
        }
        return this.boundary[gpi];
    }

    public void insertGeoPoint(GeoPoint gp, int ndx) {
        if (gp != null) {
            if (!gp.isValid()) {
                Print.logError("Invalid GeoPoint: " + gp, new Object[0]);
            } else {
                this.boundary = this.boundary == null ? new GeoPoint[]{gp} : ListTools.insert(this.boundary, gp, ndx);
            }
        }
    }

    public void addGeoPoint(GeoPoint gp) {
        if (gp != null) {
            if (!gp.isValid()) {
                Print.logError("Invalid GeoPoint: " + gp, new Object[0]);
            } else {
                this.boundary = this.boundary == null ? new GeoPoint[]{gp} : ListTools.insert(this.boundary, gp, -1);
            }
        }
    }

    public static boolean isClosed(GeoPoint[] gp) {
        if (gp == null) {
            return false;
        }
        if (gp.length < 3) {
            return false;
        }
        GeoPoint gp0 = gp[0];
        GeoPoint gpN = gp[gp.length - 1];
        return gp0.equals(gpN);
    }

    public boolean isClosed() {
        return GeoPolygon.isClosed(this.boundary);
    }

    public static GeoPoint[] closePolygon(GeoPoint[] gp) {
        if (ListTools.isEmpty(gp)) {
            return gp;
        }
        if (gp.length < 3) {
            return gp;
        }
        GeoPoint gp0 = gp[0];
        GeoPoint gpN = gp[gp.length - 1];
        if (gp0.equals(gpN)) {
            return gp;
        }
        return ListTools.add(gp, gp0);
    }

    public boolean closePolygon() {
        if (this.boundary != null && this.boundary.length >= 3) {
            this.boundary = GeoPolygon.closePolygon(this.boundary);
            return true;
        }
        return false;
    }

    public GeoBounds getGeoBounds() {
        return new GeoBounds(this.getGeoPoints());
    }

    public int getSize() {
        return this.boundary != null ? this.boundary.length : 0;
    }

    public int size() {
        return this.getSize();
    }

    public boolean containsPoint(GeoPoint gp) {
        return GeoPolygon.isPointInside(gp, this.getGeoPoints());
    }

    public boolean isPointInside(GeoPoint gp) {
        return GeoPolygon.isPointInside(gp, this.getGeoPoints());
    }

    public static boolean containsPoint(GeoPoint gp, GeoPoint ... pp) {
        return GeoPolygon.isPointInside(gp, pp);
    }

    public static boolean isPointInside(GeoPoint gp, GeoPoint ... pp) {
        if (gp == null || pp == null) {
            return false;
        }
        pp = GeoPolygon.closePolygon(pp);
        int wn = 0;
        for (int i = 0; i < pp.length - 1; ++i) {
            if (pp[i].getY() <= gp.getY()) {
                if (!(pp[i + 1].getY() > gp.getY()) || !(GeoPolygon._isLeft(pp[i], pp[i + 1], gp) > 0.0)) continue;
                ++wn;
                continue;
            }
            if (!(pp[i + 1].getY() <= gp.getY()) || !(GeoPolygon._isLeft(pp[i], pp[i + 1], gp) < 0.0)) continue;
            --wn;
        }
        return wn != 0;
    }

    private static double _isLeft(GeoPoint gp0, GeoPoint gp1, GeoPoint gpC) {
        double val = (gp1.getX() - gp0.getX()) * (gpC.getY() - gp0.getY()) - (gpC.getX() - gp0.getX()) * (gp1.getY() - gp0.getY());
        return val;
    }

    public boolean isClockwise() {
        return GeoPolygon.isClockwise(this.getGeoPoints());
    }

    public static boolean isClockwise(GeoPoint ... pp) {
        if (pp == null || pp.length < 3) {
            return false;
        }
        pp = GeoPolygon.closePolygon(pp);
        double area = 0.0;
        for (int i = 0; i < pp.length; ++i) {
            int j = (i + 1) % pp.length;
            area += (pp[i].getLongitude() + pp[j].getLongitude()) * (pp[i].getLatitude() - pp[j].getLatitude());
        }
        return area >= 0.0;
    }

    public Object clone() {
        return new GeoPolygon(this);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.size());
        if (!ListTools.isEmpty(this.negRings)) {
            sb.append("(");
            for (int i = 0; i < this.negRings.size(); ++i) {
                GeoPolygon gp = this.negRings.get(i);
                if (i > 0) {
                    sb.append(",");
                }
                sb.append(gp.toString());
            }
            sb.append(")");
        }
        return sb.toString();
    }

    public void addNegativeRings(Collection<GeoPolygon> geoPolyList) {
        if (!ListTools.isEmpty(geoPolyList)) {
            if (this.negRings == null) {
                this.negRings = new Vector();
            }
            this.negRings.addAll(geoPolyList);
        }
    }

    public void addNegativeRing(GeoPolygon geoPoly) {
        if (geoPoly != null) {
            if (this.negRings == null) {
                this.negRings = new Vector();
            }
            this.negRings.add(geoPoly);
        }
    }

    public List<GeoPolygon> getNegativeRings() {
        return this.negRings;
    }

    public static GeozoneChecker getGeozoneChecker() {
        if (geozoneCheck == null) {
            geozoneCheck = new GeozoneChecker(){

                @Override
                public boolean containsPoint(GeoPoint gpTest, GeoPoint[] gpList, double radiusKM) {
                    return GeoPolygon.isPointInside(gpTest, gpList);
                }
            };
        }
        return geozoneCheck;
    }
}

