/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.util;

import java.util.Locale;
import org.opengts.util.EnumTools;
import org.opengts.util.GeoBounds;
import org.opengts.util.GeoOffset;
import org.opengts.util.GeoPointProvider;
import org.opengts.util.GeozoneChecker;
import org.opengts.util.I18N;
import org.opengts.util.ListTools;
import org.opengts.util.PixelDimension;
import org.opengts.util.PixelPoint;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;
import org.opengts.util.StringTools;

public class GeoPoint
implements Cloneable,
GeoPointProvider {
    private static boolean UseHaversineDistanceFormula = true;
    public static final double EPSILON = 1.0E-7;
    public static final double MAX_LATITUDE = 90.0;
    public static final double MIN_LATITUDE = -90.0;
    public static final double MAX_LONGITUDE = 180.0;
    public static final double MIN_LONGITUDE = -180.0;
    public static final String PointSeparator = "/";
    public static final char PointSeparatorChar = '/';
    public static final char[] PointSeparatorChars = new char[]{'/', ','};
    private static final int FORMAT_DEC_MASK = 15;
    private static final int FORMAT_DEC_0 = 1;
    private static final int FORMAT_DEC_1 = 1;
    private static final int FORMAT_DEC_2 = 2;
    private static final int FORMAT_DEC_3 = 3;
    private static final int FORMAT_DEC_4 = 4;
    private static final int FORMAT_DEC_5 = 5;
    private static final int FORMAT_DEC_6 = 6;
    private static final int FORMAT_DEC_7 = 7;
    private static final int FORMAT_TYPE_MASK = 240;
    public static final int FORMAT_DEC = 16;
    public static final int FORMAT_DMS = 32;
    public static final int FORMAT_DM = 48;
    public static final int FORMAT_NMEA = 64;
    public static final String SFORMAT_DEC_1 = "1";
    public static final String SFORMAT_DEC_2 = "2";
    public static final String SFORMAT_DEC_3 = "3";
    public static final String SFORMAT_DEC_4 = "4";
    public static final String SFORMAT_DEC_5 = "5";
    public static final String SFORMAT_DEC_6 = "6";
    public static final String SFORMAT_DEC_7 = "7";
    public static final String SFORMAT_DMS = "DMS";
    public static final String SFORMAT_DM = "DM";
    public static final String SFORMAT_NMEA = "NMEA";
    private static final int FORMAT_AXIS_MASK = 3840;
    private static final int FORMAT_LATITUDE = 256;
    private static final int FORMAT_LONGITUDE = 512;
    public static final char DegreeChar = '\u00b0';
    public static final String[] DMS_HTML_SEPARATORS = new String[]{"&deg;", "'", "&quot;"};
    public static final String[] DMS_TEXT_SEPARATORS = new String[]{"\u00b0", "'", "\""};
    public static final String DECIMAL_FORMAT_0 = "#0";
    public static final String DECIMAL_FORMAT_1 = "#0.0";
    public static final String DECIMAL_FORMAT_2 = "#0.00";
    public static final String DECIMAL_FORMAT_3 = "#0.000";
    public static final String DECIMAL_FORMAT_4 = "#0.0000";
    public static final String DECIMAL_FORMAT_5 = "#0.00000";
    public static final String DECIMAL_FORMAT_6 = "#0.000000";
    public static final String DECIMAL_FORMAT_7 = "#0.0000000";
    private static final int DEFAULT_DEG_DECIMAL = 5;
    private static final int DEFAULT_MIN_DECIMAL = 2;
    public static final GeoPoint INVALID_GEOPOINT = new GeoPoint(0.0, 0.0).setImmutable();
    public static final double PI = Math.PI;
    public static final double RADIANS = Math.PI / 180;
    public static final double EARTH_EQUATORIAL_RADIUS_KM = 6378.137;
    public static final double EARTH_POLOR_RADIUS_KM = 6356.752314;
    public static final double EARTH_MEAN_RADIUS_KM = 6371.0088;
    public static final double EARTH_MEAN_RADIUS_METERS = 6371008.8;
    public static final double EARTH_CIRCUMFERENCE_KM = 40030.22888407185;
    public static final double EARTH_ANTIPODAL_KM = 20015.114442035923;
    public static final double FEET_PER_MILE = 5280.0;
    public static final double KILOMETERS_PER_MILE = 1.609344;
    public static final double CENTIMETERS_PER_METER = 100.0;
    public static final double METERS_PER_CENTIMETER = 0.01;
    public static final double METERS_PER_KILOMETER = 1000.0;
    public static final double CENTIMETERS_PER_KILOMETER = 100000.0;
    public static final double KILOMETERS_PER_CENTIMETER = 1.0E-5;
    public static final double KILOMETERS_PER_METER = 0.001;
    public static final double MILES_PER_KILOMETER = 0.621371192237334;
    public static final double METERS_PER_MILE = 1609.344;
    public static final double MILES_PER_METER = 6.213711922373339E-4;
    public static final double METERS_PER_FOOT = 0.3048;
    public static final double FEET_PER_METER = 3.280839895013123;
    public static final double FEET_PER_KILOMETER = 3280.839895013123;
    public static final double KILOMETERS_PER_NAUTICAL_MILE = 1.852;
    public static final double NAUTICAL_MILES_PER_KILOMETER = 0.5399568034557235;
    public static final double NAUTICAL_MILES_PER_METER = 5.399568034557235E-4;
    public static final double MILES_PER_NAUTICAL_MILE = 1.1507794480235425;
    public static final double NAUTICAL_MILES_PER_MILE = 0.8689762419006479;
    public static final double MM_PER_INCH = 25.4;
    public static final double INCHES_PER_MM = 0.03937007874015748;
    public static final double SQUARE_METERS_PER_SQUARE_FOOT = 0.09290304;
    public static final double SQUARE_YARDS_PER_ACRE = 4840.0;
    public static final double SQUARE_FEET_PER_ACRE = 43560.0;
    public static final double SQUARE_METERS_PER_ACRE = 4046.8564224;
    public static final double METERS_PER_ACRE_SIDE = Math.sqrt(4046.8564224);
    public static final double FEET_PER_ACRE_SIDE = Math.sqrt(43560.0);
    private boolean immutable = false;
    private double latitude = 0.0;
    private double longitude = 0.0;
    public static final int ENCODE_HIRES_LEN = 8;
    public static final int ENCODE_LORES_LEN = 6;
    private static final double POW_24 = 1.6777216E7;
    private static final double POW_28 = 2.68435456E8;
    private static final double POW_32 = 4.294967296E9;
    private static GeozoneChecker geozoneCheck = null;

    public static int GetFormatMask(String fmt, boolean isLat) {
        int f;
        int n = f = isLat ? 256 : 512;
        if (StringTools.isBlank(fmt)) {
            return f | 0x10 | 5;
        }
        if (fmt.equalsIgnoreCase(SFORMAT_DMS)) {
            return f | 0x20;
        }
        if (fmt.equalsIgnoreCase(SFORMAT_DM)) {
            return f | 0x30 | 2;
        }
        if (fmt.equalsIgnoreCase(SFORMAT_NMEA)) {
            return f | 0x40;
        }
        if (Character.isDigit(fmt.charAt(0))) {
            int decFmt;
            switch (fmt.charAt(0)) {
                case '0': {
                    decFmt = 5;
                    break;
                }
                case '1': {
                    decFmt = 1;
                    break;
                }
                case '2': {
                    decFmt = 2;
                    break;
                }
                case '3': {
                    decFmt = 3;
                    break;
                }
                case '4': {
                    decFmt = 4;
                    break;
                }
                case '5': {
                    decFmt = 5;
                    break;
                }
                case '6': {
                    decFmt = 6;
                    break;
                }
                case '7': {
                    decFmt = 7;
                    break;
                }
                default: {
                    decFmt = 7;
                }
            }
            return f | 0x10 | decFmt;
        }
        return f | 0x10 | 5;
    }

    public static String GetDecimalFormat(int fmt) {
        if ((fmt & 0xF0) == 48) {
            switch (fmt & 0xF) {
                case 0: {
                    return "00.00";
                }
                case 1: {
                    return "00.0";
                }
                case 2: {
                    return "00.00";
                }
                case 3: {
                    return "00.000";
                }
                case 4: {
                    return "00.0000";
                }
                case 5: {
                    return "00.00000";
                }
            }
            return "00.000000";
        }
        if ((fmt & 0xF0) == 16) {
            switch (fmt & 0xF) {
                case 0: {
                    return DECIMAL_FORMAT_5;
                }
                case 1: {
                    return DECIMAL_FORMAT_1;
                }
                case 2: {
                    return DECIMAL_FORMAT_2;
                }
                case 3: {
                    return DECIMAL_FORMAT_3;
                }
                case 4: {
                    return DECIMAL_FORMAT_4;
                }
                case 5: {
                    return DECIMAL_FORMAT_5;
                }
                case 6: {
                    return DECIMAL_FORMAT_6;
                }
                case 7: {
                    return DECIMAL_FORMAT_7;
                }
            }
            return DECIMAL_FORMAT_7;
        }
        return "";
    }

    private static double SQ(double X) {
        return X * X;
    }

    public static String GetHeadingTitle(Locale locale) {
        I18N i18n = I18N.getI18N(GeoPoint.class, locale);
        return i18n.getString("GeoPoint.heading", "Heading");
    }

    public static boolean isOrigin(GeoPoint gp) {
        if (gp == null) {
            return false;
        }
        double latAbs = Math.abs(gp.getLatitude());
        double lonAbs = Math.abs(gp.getLongitude());
        return latAbs <= 1.0E-4 && lonAbs <= 1.0E-4;
    }

    public static boolean isOrigin(double lat, double lon) {
        double latAbs = Math.abs(lat);
        double lonAbs = Math.abs(lon);
        return latAbs <= 1.0E-4 && lonAbs <= 1.0E-4;
    }

    public static boolean isValidBounds(double lat, double lon) {
        if (lat >= 90.0 || lat <= -90.0) {
            return false;
        }
        return !(lon >= 180.0) && !(lon <= -180.0);
    }

    public static boolean isValid(double lat, double lon) {
        double latAbs = Math.abs(lat);
        double lonAbs = Math.abs(lon);
        if (latAbs >= 90.0) {
            return false;
        }
        if (lonAbs >= 180.0) {
            return false;
        }
        return !(latAbs <= 1.0E-4) || !(lonAbs <= 1.0E-4);
    }

    public static boolean isValid(GeoPoint gp) {
        return gp != null ? gp.isValid() : false;
    }

    public static boolean isValid(GeoPointProvider gpp) {
        return gpp != null ? gpp.getGeoPoint().isValid() : false;
    }

    public static double parseLatitude(String lat, double dft) {
        return GeoPoint.parseCoordinate(lat, true, dft);
    }

    public static double parseLongitude(String lon, double dft) {
        return GeoPoint.parseCoordinate(lon, false, dft);
    }

    public static double parseCoordinate(String loc, boolean isLat, double dft) {
        String H;
        if (StringTools.isBlank(loc)) {
            return dft;
        }
        double range = isLat ? 90.0 : 180.0;
        String negHem = isLat ? "S" : "W";
        int degChar = loc.indexOf(176);
        if (degChar < 0) {
            degChar = loc.indexOf(94);
        }
        if (degChar < 0) {
            double val = StringTools.parseDouble(loc, dft);
            if (val > range || val < -range) {
                return dft;
            }
            return val;
        }
        int locLen = loc.length();
        int nextChar = degChar;
        double deg = 0.0;
        double min = 0.0;
        double sec = 0.0;
        double hem = 1.0;
        deg = StringTools.parseDouble(loc.substring(0, nextChar).trim(), 999.0);
        if (deg > range || deg < -range) {
            return dft;
        }
        nextChar = degChar + 1;
        if (nextChar < locLen) {
            int minChar = loc.indexOf("'", nextChar);
            if (minChar < 0) {
                min = StringTools.parseDouble(loc.substring(nextChar).trim(), 0.0);
                nextChar = locLen;
            } else {
                min = StringTools.parseDouble(loc.substring(nextChar, minChar).trim(), 0.0);
                nextChar = minChar + 1;
                if (nextChar < locLen) {
                    int secChar = loc.indexOf("\"", nextChar);
                    if (secChar < 0) {
                        sec = StringTools.parseDouble(loc.substring(nextChar).trim(), 0.0);
                        nextChar = locLen;
                    } else {
                        sec = StringTools.parseDouble(loc.substring(nextChar, secChar).trim(), 0.0);
                        nextChar = secChar + 1;
                    }
                }
            }
        }
        hem = nextChar < locLen ? ((H = loc.substring(nextChar).trim().toUpperCase()).startsWith(negHem) ? -1.0 : 1.0) : ((H = loc.substring(locLen - 1).trim().toUpperCase()).startsWith(negHem) ? -1.0 : 1.0);
        return (deg + (min + sec / 60.0) / 60.0) * hem;
    }

    public static double getLatitude(GeoPointProvider gpp, double dft) {
        if (gpp instanceof GeoPoint) {
            return ((GeoPoint)gpp).getLatitude();
        }
        GeoPoint gp = gpp.getGeoPoint();
        return gp != null ? gp.getLatitude() : dft;
    }

    public static double getLongitude(GeoPointProvider gpp, double dft) {
        if (gpp instanceof GeoPoint) {
            return ((GeoPoint)gpp).getLongitude();
        }
        GeoPoint gp = gpp.getGeoPoint();
        return gp != null ? gp.getLongitude() : dft;
    }

    public GeoPoint() {
    }

    public GeoPoint(GeoPoint gp) {
        this();
        this.setLatitude(gp.getLatitude());
        this.setLongitude(gp.getLongitude());
    }

    public GeoPoint(double latitude, double longitude) {
        this();
        this.setLatitude(latitude);
        this.setLongitude(longitude);
    }

    public GeoPoint(double latDeg, double latMin, double latSec, double lonDeg, double lonMin, double lonSec) {
        this();
        this.setLatitude(latDeg, latMin, latSec);
        this.setLongitude(lonDeg, lonMin, lonSec);
    }

    public GeoPoint(String gp) {
        this(gp, '/');
    }

    public GeoPoint(String gp, char sep) {
        this();
        int p;
        if (gp != null && (p = gp.indexOf(sep)) >= 0) {
            this.setLatitude(GeoPoint.parseLatitude(gp.substring(0, p), 0.0));
            this.setLongitude(GeoPoint.parseLongitude(gp.substring(p + 1), 0.0));
        }
    }

    public GeoPoint(String gp, char[] sep) {
        this();
        if (gp != null) {
            int p = -1;
            if (ListTools.isEmpty(sep)) {
                sep = PointSeparatorChars;
            }
            for (int i = 0; i < sep.length && p < 0; ++i) {
                p = gp.indexOf(sep[i]);
            }
            if (p >= 0) {
                this.setLatitude(GeoPoint.parseLatitude(gp.substring(0, p), 0.0));
                this.setLongitude(GeoPoint.parseLongitude(gp.substring(p + 1), 0.0));
            }
        }
    }

    public Object clone() {
        return new GeoPoint(this);
    }

    public GeoPoint setImmutable() {
        this.immutable = true;
        return this;
    }

    public boolean isImmutable() {
        return this.immutable;
    }

    @Override
    public GeoPoint getGeoPoint() {
        return this;
    }

    public boolean isValid() {
        return GeoPoint.isValid(this.getLatitude(), this.getLongitude());
    }

    public void setLatitude(double deg, double min, double sec) {
        this.setLatitude(GeoPoint.convertDmsToDec(deg, min, sec));
    }

    public void setLatitude(double lat) {
        if (this.isImmutable()) {
            Print.logError("This GeoPoint is immutable, changing Latitude denied!", new Object[0]);
        } else {
            this.latitude = lat;
        }
    }

    public double getLatitude() {
        return this.latitude;
    }

    public double getY() {
        return this.latitude;
    }

    public double getLatitudeRadians() {
        return this.getLatitude() * (Math.PI / 180);
    }

    public String getLatitudeString(String type, Locale locale) {
        return GeoPoint._formatCoord(this.getLatitude(), GeoPoint.GetFormatMask(type, true), locale);
    }

    public String getLatitudeString() {
        return this.getLatitudeString(null, null);
    }

    public static String formatLatitude(double lat, String type, Locale locale) {
        return GeoPoint._formatCoord(lat, GeoPoint.GetFormatMask(type, true), locale);
    }

    public static String formatLatitude(double lat) {
        return GeoPoint._formatCoord(lat, GeoPoint.GetFormatMask(null, true), null);
    }

    public void setLongitude(double deg, double min, double sec) {
        this.setLongitude(GeoPoint.convertDmsToDec(deg, min, sec));
    }

    public void setLongitude(double lon) {
        if (this.isImmutable()) {
            Print.logError("This GeoPoint is immutable, changing Longitude denied!", new Object[0]);
        } else {
            this.longitude = lon;
        }
    }

    public double getLongitude() {
        return this.longitude;
    }

    public double getX() {
        return this.longitude;
    }

    public double getLongitudeRadians() {
        return this.getLongitude() * (Math.PI / 180);
    }

    public String getLongitudeString(String type, Locale locale) {
        return GeoPoint._formatCoord(this.getLongitude(), GeoPoint.GetFormatMask(type, false), locale);
    }

    public String getLongitudeString() {
        return this.getLongitudeString(null, null);
    }

    public static String formatLongitude(double lon, String type, Locale locale) {
        return GeoPoint._formatCoord(lon, GeoPoint.GetFormatMask(type, false), locale);
    }

    public static String formatLongitude(double lon) {
        return GeoPoint._formatCoord(lon, GeoPoint.GetFormatMask(null, false), null);
    }

    public static byte[] encodeGeoPoint(GeoPoint gp, byte[] enc, int ofs, int len) {
        if (enc == null) {
            return null;
        }
        if (len < 0) {
            len = enc.length;
        }
        if (ofs + len > enc.length) {
            return null;
        }
        if (len < 6) {
            return null;
        }
        double lat = gp.getLatitude();
        double lon = gp.getLongitude();
        if (len >= 6 && len < 8) {
            long rawLat24 = lat != 0.0 ? Math.round((lat - 90.0) * -93206.75555555556) : 0L;
            long rawLon24 = lon != 0.0 ? Math.round((lon + 180.0) * 46603.37777777778) : 0L;
            long rawAccum = rawLat24 << 24 & 0xFFFFFF000000L | rawLon24 & 0xFFFFFFL;
            enc[ofs + 0] = (byte)(rawAccum >> 40 & 0xFFL);
            enc[ofs + 1] = (byte)(rawAccum >> 32 & 0xFFL);
            enc[ofs + 2] = (byte)(rawAccum >> 24 & 0xFFL);
            enc[ofs + 3] = (byte)(rawAccum >> 16 & 0xFFL);
            enc[ofs + 4] = (byte)(rawAccum >> 8 & 0xFFL);
            enc[ofs + 5] = (byte)(rawAccum & 0xFFL);
            return enc;
        }
        if (len >= 8) {
            long rawLat32 = lat != 0.0 ? Math.round((lat - 90.0) * -2.3860929422222223E7) : 0L;
            long rawLon32 = lon != 0.0 ? Math.round((lon + 180.0) * 1.1930464711111112E7) : 0L;
            long rawAccum = rawLat32 << 32 & 0xFFFFFFFF00000000L | rawLon32 & 0xFFFFFFFFL;
            enc[ofs + 0] = (byte)(rawAccum >> 56 & 0xFFL);
            enc[ofs + 1] = (byte)(rawAccum >> 48 & 0xFFL);
            enc[ofs + 2] = (byte)(rawAccum >> 40 & 0xFFL);
            enc[ofs + 3] = (byte)(rawAccum >> 32 & 0xFFL);
            enc[ofs + 4] = (byte)(rawAccum >> 24 & 0xFFL);
            enc[ofs + 5] = (byte)(rawAccum >> 16 & 0xFFL);
            enc[ofs + 6] = (byte)(rawAccum >> 8 & 0xFFL);
            enc[ofs + 7] = (byte)(rawAccum & 0xFFL);
            return enc;
        }
        return null;
    }

    public static GeoPoint decodeGeoPoint(byte[] enc, int ofs, int len) {
        if (enc == null) {
            return null;
        }
        if (len < 0) {
            len = enc.length;
        }
        if (ofs + len > enc.length) {
            return null;
        }
        if (len < 6) {
            return null;
        }
        if (len >= 6 && len < 8) {
            long rawLat24 = ((long)enc[ofs + 0] & 0xFFL) << 16 | ((long)enc[ofs + 1] & 0xFFL) << 8 | (long)enc[ofs + 2] & 0xFFL;
            long rawLon24 = ((long)enc[ofs + 3] & 0xFFL) << 16 | ((long)enc[ofs + 4] & 0xFFL) << 8 | (long)enc[ofs + 5] & 0xFFL;
            double lat = rawLat24 != 0L ? ((double)rawLat24 + 0.5) * -1.0728836059570312E-5 + 90.0 : 0.0;
            double lon = rawLon24 != 0L ? ((double)rawLon24 + 0.5) * 2.1457672119140625E-5 - 180.0 : 0.0;
            return new GeoPoint(lat, lon);
        }
        if (len >= 8) {
            long rawLat32 = ((long)enc[ofs + 0] & 0xFFL) << 24 | ((long)enc[ofs + 1] & 0xFFL) << 16 | ((long)enc[ofs + 2] & 0xFFL) << 8 | (long)enc[ofs + 3] & 0xFFL;
            long rawLon32 = ((long)enc[ofs + 4] & 0xFFL) << 24 | ((long)enc[ofs + 5] & 0xFFL) << 16 | ((long)enc[ofs + 6] & 0xFFL) << 8 | (long)enc[ofs + 7] & 0xFFL;
            double lat = rawLat32 != 0L ? ((double)rawLat32 + 0.5) * -4.190951585769653E-8 + 90.0 : 0.0;
            double lon = rawLon32 != 0L ? ((double)rawLon32 + 0.5) * 8.381903171539307E-8 - 180.0 : 0.0;
            return new GeoPoint(lat, lon);
        }
        return null;
    }

    public double radiansToPoint(GeoPoint dest) {
        if (dest == null) {
            return Double.NaN;
        }
        if (this.equals(dest)) {
            return 0.0;
        }
        try {
            double lat1 = this.getLatitudeRadians();
            double lon1 = this.getLongitudeRadians();
            double lat2 = dest.getLatitudeRadians();
            double lon2 = dest.getLongitudeRadians();
            double rad = 0.0;
            if (UseHaversineDistanceFormula) {
                double dlat = lat2 - lat1;
                double dlon = lon2 - lon1;
                double a = GeoPoint.SQ(Math.sin(dlat / 2.0)) + Math.cos(lat1) * Math.cos(lat2) * GeoPoint.SQ(Math.sin(dlon / 2.0));
                rad = 2.0 * Math.atan2(Math.sqrt(a), Math.sqrt(1.0 - a));
            } else {
                double dlon = lon2 - lon1;
                rad = Math.acos(Math.sin(lat1) * Math.sin(lat2) + Math.cos(lat1) * Math.cos(lat2) * Math.cos(dlon));
            }
            return rad;
        }
        catch (Throwable t) {
            return Double.NaN;
        }
    }

    public double kilometersToPoint(GeoPoint gp) {
        double radians = this.radiansToPoint(gp);
        return !Double.isNaN(radians) ? 6371.0088 * radians : Double.NaN;
    }

    public double metersToPoint(GeoPoint gp) {
        double radians = this.radiansToPoint(gp);
        return !Double.isNaN(radians) ? 6371008.8 * radians : Double.NaN;
    }

    public GeoOffset getRadiusDeltaPoint(double radiusMeters) {
        double a = 6378137.0;
        double b = 6356752.314;
        double lat = this.getLatitudeRadians();
        double r = GeoPoint.SQ(a) / Math.sqrt(GeoPoint.SQ(a) * GeoPoint.SQ(Math.cos(lat)) + GeoPoint.SQ(b) * GeoPoint.SQ(Math.sin(lat)));
        double dlat = 180.0 * radiusMeters / (Math.PI * r);
        double dlon = dlat / Math.cos(lat);
        return new GeoOffset(dlat, dlon);
    }

    public static String GetHeadingString(double heading, Locale locale) {
        if (!Double.isNaN(heading) && heading >= 0.0) {
            int h = (int)Math.round(heading / 45.0) % 8;
            switch (h) {
                case 0: {
                    return CompassHeading.N.toString(locale);
                }
                case 1: {
                    return CompassHeading.NE.toString(locale);
                }
                case 2: {
                    return CompassHeading.E.toString(locale);
                }
                case 3: {
                    return CompassHeading.SE.toString(locale);
                }
                case 4: {
                    return CompassHeading.S.toString(locale);
                }
                case 5: {
                    return CompassHeading.SW.toString(locale);
                }
                case 6: {
                    return CompassHeading.W.toString(locale);
                }
                case 7: {
                    return CompassHeading.NW.toString(locale);
                }
            }
            return CompassHeading.N.toString(locale);
        }
        return "";
    }

    public static String GetHeadingDescription(double heading, Locale locale) {
        if (!Double.isNaN(heading) && heading >= 0.0) {
            int h = (int)Math.round(heading / 45.0) % 8;
            switch (h) {
                case 0: {
                    return CompassHeading.N.getDescription(locale);
                }
                case 1: {
                    return CompassHeading.NE.getDescription(locale);
                }
                case 2: {
                    return CompassHeading.E.getDescription(locale);
                }
                case 3: {
                    return CompassHeading.SE.getDescription(locale);
                }
                case 4: {
                    return CompassHeading.S.getDescription(locale);
                }
                case 5: {
                    return CompassHeading.SW.getDescription(locale);
                }
                case 6: {
                    return CompassHeading.W.getDescription(locale);
                }
                case 7: {
                    return CompassHeading.NW.getDescription(locale);
                }
            }
            return CompassHeading.N.getDescription(locale);
        }
        return "";
    }

    public double headingToPoint(GeoPoint dest) {
        try {
            double lat1 = this.getLatitudeRadians();
            double lon1 = this.getLongitudeRadians();
            double lat2 = dest.getLatitudeRadians();
            double lon2 = dest.getLongitudeRadians();
            double dist = this.radiansToPoint(dest);
            double rad = Math.acos((Math.sin(lat2) - Math.sin(lat1) * Math.cos(dist)) / (Math.sin(dist) * Math.cos(lat1)));
            if (Math.sin(lon2 - lon1) < 0.0) {
                rad = Math.PI * 2 - rad;
            }
            double deg = rad / (Math.PI / 180);
            return deg;
        }
        catch (Throwable t) {
            Print.logException("headingToPoint", t);
            return 0.0;
        }
    }

    public GeoPoint getHeadingPoint(double distM, double heading) {
        double crLat = this.getLatitudeRadians();
        double crLon = this.getLongitudeRadians();
        double d = distM / 6371008.8;
        double xrad = heading * (Math.PI / 180);
        double rrLat = Math.asin(Math.sin(crLat) * Math.cos(d) + Math.cos(crLat) * Math.sin(d) * Math.cos(xrad));
        double rrLon = crLon + Math.atan2(Math.sin(xrad) * Math.sin(d) * Math.cos(crLat), Math.cos(d) - Math.sin(crLat) * Math.sin(rrLat));
        return new GeoPoint(rrLat / (Math.PI / 180), rrLon / (Math.PI / 180));
    }

    public String toString() {
        return this.toString('/');
    }

    public String toString(char sep) {
        return this.getLatitudeString(null, null) + sep + this.getLongitudeString(null, null);
    }

    public String toString(String type, Locale locale) {
        return this.toString(type, '/', locale);
    }

    public String toString(String type, char sep, Locale locale) {
        return this.getLatitudeString(type, locale) + sep + this.getLongitudeString(type, locale);
    }

    public boolean equals(Object other) {
        if (other instanceof GeoPoint) {
            GeoPoint gp = (GeoPoint)other;
            double deltaLat = Math.abs(gp.getLatitude() - this.getLatitude());
            double deltaLon = Math.abs(gp.getLongitude() - this.getLongitude());
            return deltaLat < 1.0E-7 && deltaLon < 1.0E-7;
        }
        return false;
    }

    public static PixelPoint geoPointToPixel(GeoPoint gg, GeoBounds bb, PixelDimension mapDim) {
        if (gg != null && bb != null && mapDim != null) {
            double geoDeltaW = bb.getRight() - bb.getLeft();
            double geoDeltaH = bb.getTop() - bb.getBottom();
            double geoOffsetX = gg.getX() - bb.getLeft();
            double geoOffsetY = bb.getTop() - gg.getY();
            double pixOffsetX = (double)mapDim.getWidth() * (geoOffsetX / geoDeltaW);
            double pixOffsetY = (double)mapDim.getHeight() * (geoOffsetY / geoDeltaH);
            return new PixelPoint(pixOffsetX, pixOffsetY);
        }
        return null;
    }

    public static GeoPoint pixelToGeoPoint(PixelPoint xx, GeoBounds bb, PixelDimension mapDim) {
        if (xx != null && bb != null && mapDim != null) {
            double geoDeltaW = bb.getRight() - bb.getLeft();
            double geoDeltaH = bb.getTop() - bb.getBottom();
            double latitude = bb.getLeft() + xx.getX() / (double)mapDim.getWidth() * geoDeltaW;
            double longitude = bb.getTop() - xx.getY() / (double)mapDim.getHeight() * geoDeltaH;
            return new GeoPoint(latitude, longitude);
        }
        return null;
    }

    public static double convertDmsToDec(int deg, int min, int sec) {
        return GeoPoint.convertDmsToDec((double)deg, (double)min, (double)sec);
    }

    public static double convertDmsToDec(double deg, double min, double sec) {
        double sign = deg >= 0.0 ? 1.0 : -1.0;
        double d = Math.abs(deg);
        double m = Math.abs(min / 60.0);
        double s = Math.abs(sec / 3600.0);
        return sign * (d + m + s);
    }

    protected static String _formatCoord(double loc, int fmt, Locale locale) {
        boolean html = false;
        if ((fmt & 0xF0) == 32) {
            String[] SEP = html ? DMS_HTML_SEPARATORS : DMS_TEXT_SEPARATORS;
            int sgn = loc >= 0.0 ? 1 : -1;
            double degD = Math.abs(loc);
            int deg = (int)degD;
            double minD = (degD - (double)deg) * 60.0;
            int min = (int)minD;
            double secD = (minD - (double)min) * 60.0;
            int sec = (int)Math.round(secD);
            StringBuffer sb = new StringBuffer();
            sb.append(StringTools.format(deg, "0")).append(SEP[0]);
            sb.append(StringTools.format(min, "00")).append(SEP[1]);
            sb.append(StringTools.format(sec, "00")).append(SEP[2]);
            if ((fmt & 0xF00) == 256) {
                sb.append(sgn >= 0 ? CompassHeading.N.toString(locale) : CompassHeading.S.toString(locale));
            } else if ((fmt & 0xF00) == 512) {
                sb.append(sgn >= 0 ? CompassHeading.E.toString(locale) : CompassHeading.W.toString(locale));
            }
            return sb.toString();
        }
        if ((fmt & 0xF0) == 48) {
            String[] SEP = html ? DMS_HTML_SEPARATORS : DMS_TEXT_SEPARATORS;
            int sgn = loc >= 0.0 ? 1 : -1;
            double degD = Math.abs(loc);
            int deg = (int)degD;
            double minD = (degD - (double)deg) * 60.0;
            StringBuffer sb = new StringBuffer();
            sb.append(StringTools.format(deg, "0")).append(SEP[0]);
            sb.append(StringTools.format(minD, GeoPoint.GetDecimalFormat(fmt))).append(SEP[1]);
            if ((fmt & 0xF00) == 256) {
                sb.append(sgn >= 0 ? CompassHeading.N.toString(locale) : CompassHeading.S.toString(locale));
            } else if ((fmt & 0xF00) == 512) {
                sb.append(sgn >= 0 ? CompassHeading.E.toString(locale) : CompassHeading.W.toString(locale));
            }
            return sb.toString();
        }
        if ((fmt & 0xF0) == 64) {
            StringBuffer sb = new StringBuffer();
            int sgn = loc >= 0.0 ? 1 : -1;
            double degD = Math.abs(loc);
            int deg = (int)degD;
            double minD = (degD - (double)deg) * 60.0;
            long lfm = (fmt & 0xF00) == 256 ? 100L : 1000L;
            sb.append(String.valueOf(lfm + (long)deg).substring(1));
            sb.append(StringTools.format(100.0 + minD, "0.0000").substring(1));
            sb.append(",");
            if ((fmt & 0xF00) == 256) {
                sb.append(sgn >= 0 ? "N" : "S");
            } else if ((fmt & 0xF00) == 512) {
                sb.append(sgn >= 0 ? "E" : "W");
            }
            return sb.toString();
        }
        return StringTools.format(loc, GeoPoint.GetDecimalFormat(fmt));
    }

    public static GeozoneChecker getGeozoneChecker() {
        if (geozoneCheck == null) {
            geozoneCheck = new GeozoneChecker(){

                @Override
                public boolean containsPoint(GeoPoint gpTest, GeoPoint[] gpList, double radiusKM) {
                    if (gpList != null && gpTest != null) {
                        for (int i = 0; i < gpList.length; ++i) {
                            double km = gpList[i].kilometersToPoint(gpTest);
                            if (!(km <= radiusKM)) continue;
                            return true;
                        }
                    }
                    return false;
                }
            };
        }
        return geozoneCheck;
    }

    private static void printGeoPoint(String gpStr) {
        Print.sysPrintln("Input String      : " + gpStr, new Object[0]);
        GeoPoint gp = new GeoPoint(gpStr);
        GeoPoint.printGeoPoint(gp, false);
    }

    private static void printGeoPoint(GeoPoint gp) {
        GeoPoint.printGeoPoint(gp, false);
    }

    private static void printGeoPoint(GeoPoint gp, boolean inclEncDec) {
        if (gp != null && gp.isValid()) {
            Print.sysPrintln("Default format    : " + gp.toString(), new Object[0]);
            Print.sysPrintln("Deg:Min format    : " + gp.toString(SFORMAT_DM, ',', null), new Object[0]);
            Print.sysPrintln("Deg:Min:Sec format: " + gp.toString(SFORMAT_DMS, ',', null), new Object[0]);
            Print.sysPrintln("NMEA-0183 format  : " + gp.toString(SFORMAT_NMEA, ',', null), new Object[0]);
            if (inclEncDec) {
                byte[] gpEnc = new byte[8];
                GeoPoint.encodeGeoPoint(gp, gpEnc, 0, 8);
                GeoPoint gp8 = GeoPoint.decodeGeoPoint(gpEnc, 0, 8);
                Print.sysPrintln("8-byte enc/dec    : " + gp8, new Object[0]);
                GeoPoint.encodeGeoPoint(gp, gpEnc, 0, 6);
                GeoPoint gp6 = GeoPoint.decodeGeoPoint(gpEnc, 0, 6);
                Print.sysPrintln("6-byte enc/dec    : " + gp6, new Object[0]);
            }
        } else {
            Print.sysPrintln("Invalid GeoPoint  : " + gp, new Object[0]);
        }
        Print.sysPrintln("", new Object[0]);
    }

    public static void main(String[] argv) {
        RTConfig.setCommandLineArgs(argv);
        if (RTConfig.getBoolean("test", false)) {
            GeoPoint.printGeoPoint("21^57'32\"S/120^08'05\"E");
        }
        if (RTConfig.hasProperty("gp")) {
            GeoPoint gp;
            StringBuffer sb;
            String gpStr = RTConfig.getString("gp", "");
            String[] g = StringTools.split(gpStr, ',');
            if (g.length == 4) {
                sb = new StringBuffer();
                if (g[0].length() > 4) {
                    sb.append(g[0].substring(0, 2));
                    sb.append("^");
                    sb.append(g[0].substring(2));
                }
                sb.append(g[1]);
                sb.append(PointSeparator);
                if (g[2].length() > 4) {
                    sb.append(g[2].substring(0, 3));
                    sb.append("^");
                    sb.append(g[2].substring(3));
                }
                sb.append(g[3]);
                gpStr = sb.toString();
            }
            if (gpStr.indexOf(":") >= 0) {
                String[] DMS;
                sb = new StringBuffer();
                String[] LL = StringTools.split(gpStr, '/');
                if (LL.length > 0) {
                    DMS = StringTools.split(LL[0], ':');
                    if (DMS.length == 3) {
                        sb.append(DMS[0]).append("^");
                        sb.append(DMS[1]).append("'");
                        sb.append(DMS[2]);
                    } else if (DMS.length == 2) {
                        sb.append(DMS[0]).append("^");
                        sb.append(DMS[1]);
                    } else if (DMS.length == 1) {
                        sb.append(DMS[0]);
                    } else {
                        sb.append(LL[0]);
                    }
                }
                sb.append(PointSeparator);
                if (LL.length > 1) {
                    DMS = StringTools.split(LL[1], ':');
                    if (DMS.length == 3) {
                        sb.append(DMS[0]).append("^");
                        sb.append(DMS[1]).append("'");
                        sb.append(DMS[2]);
                    } else if (DMS.length == 2) {
                        sb.append(DMS[0]).append("^");
                        sb.append(DMS[1]);
                    } else if (DMS.length == 1) {
                        sb.append(DMS[0]);
                    } else {
                        sb.append(LL[1]);
                    }
                }
                gpStr = sb.toString();
            }
            if ((gp = new GeoPoint(gpStr)).isValid()) {
                GeoPoint.printGeoPoint(gp, true);
                System.exit(0);
            } else {
                Print.sysPrintln("Invalid point: " + gpStr, new Object[0]);
                System.exit(1);
            }
        }
        GeoPoint gp1 = new GeoPoint(RTConfig.getString("gp1", ""));
        GeoPoint gp2 = new GeoPoint(RTConfig.getString("gp2", ""));
        if (gp1.isValid() && gp2.isValid()) {
            double km = gp1.kilometersToPoint(gp2);
            String kmFmt = StringTools.format(km, "0.00000");
            double mi = km * 0.621371192237334;
            String miFmt = StringTools.format(mi, "0.00000");
            Print.sysPrintln("Distance = " + kmFmt + " km [" + miFmt + " miles]", new Object[0]);
            long deltaSec = RTConfig.getLong("deltaSec", 0L);
            if (deltaSec > 0L) {
                double kph = km / ((double)deltaSec / 3600.0);
                Print.sysPrintln("Speed = " + kph + " kph [" + kph * 0.621371192237334 + " mph]", new Object[0]);
            }
            System.exit(0);
        }
    }

    public static enum CompassHeading implements EnumTools.StringLocale,
    EnumTools.IntValue
    {
        N(0, I18N.getString(GeoPoint.class, "GeoPoint.compass.N", "N"), I18N.getString(GeoPoint.class, "GeoPoint.compass.north", "North")),
        NE(1, I18N.getString(GeoPoint.class, "GeoPoint.compass.NE", "NE"), I18N.getString(GeoPoint.class, "GeoPoint.compass.northeast", "NorthEast")),
        E(2, I18N.getString(GeoPoint.class, "GeoPoint.compass.E", "E"), I18N.getString(GeoPoint.class, "GeoPoint.compass.east", "East")),
        SE(3, I18N.getString(GeoPoint.class, "GeoPoint.compass.SE", "SE"), I18N.getString(GeoPoint.class, "GeoPoint.compass.southeast", "SouthEast")),
        S(4, I18N.getString(GeoPoint.class, "GeoPoint.compass.S", "S"), I18N.getString(GeoPoint.class, "GeoPoint.compass.south", "South")),
        SW(5, I18N.getString(GeoPoint.class, "GeoPoint.compass.SW", "SW"), I18N.getString(GeoPoint.class, "GeoPoint.compass.southwest", "SouthWest")),
        W(6, I18N.getString(GeoPoint.class, "GeoPoint.compass.W", "W"), I18N.getString(GeoPoint.class, "GeoPoint.compass.west", "West")),
        NW(7, I18N.getString(GeoPoint.class, "GeoPoint.compass.NW", "NW"), I18N.getString(GeoPoint.class, "GeoPoint.compass.northwest", "NorthWest"));

        private int vv = 0;
        private I18N.Text aa = null;
        private I18N.Text dd = null;

        private CompassHeading(int v, I18N.Text a, I18N.Text d) {
            this.vv = v;
            this.aa = a;
            this.dd = d;
        }

        @Override
        public int getIntValue() {
            return this.vv;
        }

        public String toString() {
            return this.aa.toString();
        }

        @Override
        public String toString(Locale loc) {
            return this.aa.toString(loc);
        }

        public String getDescription(Locale loc) {
            return this.dd.toString(loc);
        }
    }

    public static enum DistanceUnits implements EnumTools.StringLocale,
    EnumTools.IntValue
    {
        KILOMETERS(0, I18N.getString(GeoPoint.class, "GeoPoint.distance.km", "km"), I18N.getString(GeoPoint.class, "GeoPoint.speed.kph", "km/h"), 1.0),
        METERS(1, I18N.getString(GeoPoint.class, "GeoPoint.distance.meters", "meters"), null, 1000.0),
        MILES(2, I18N.getString(GeoPoint.class, "GeoPoint.distance.miles", "miles"), I18N.getString(GeoPoint.class, "GeoPoint.speed.mph", "mph"), 0.621371192237334),
        FEET(3, I18N.getString(GeoPoint.class, "GeoPoint.distance.feet", "feet"), null, 3280.839895013123),
        NAUTICAL_MILES(4, I18N.getString(GeoPoint.class, "GeoPoint.distance.knots", "knots "), I18N.getString(GeoPoint.class, "GeoPoint.speed.knots", "knots"), 0.5399568034557235);

        private int vv = -1;
        private I18N.Text nn = null;
        private I18N.Text ss = null;
        private double mm = 1.0;

        private DistanceUnits(int v, I18N.Text n2, I18N.Text s, double m) {
            this.vv = v;
            this.nn = n2;
            this.ss = s;
            this.mm = m;
        }

        @Override
        public int getIntValue() {
            return this.vv;
        }

        public String toDistanceAbbr() {
            return this.nn.toString();
        }

        public String toDistanceAbbr(Locale loc) {
            return this.nn.toString(loc);
        }

        public String toSpeedAbbr() {
            return this.ss != null ? this.ss.toString() : "";
        }

        public String toSpeedAbbr(Locale loc) {
            return this.ss != null ? this.ss.toString(loc) : "";
        }

        public String toString() {
            return this.toDistanceAbbr();
        }

        @Override
        public String toString(Locale loc) {
            return this.toDistanceAbbr(loc);
        }

        public double convertFromKM(double v) {
            return v * this.mm;
        }

        public double convertToKM(double v) {
            return v / this.mm;
        }
    }
}

