/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.util;

import java.util.Collection;
import org.opengts.util.GeoPoint;
import org.opengts.util.GeoPointProvider;
import org.opengts.util.GeoPolygon;
import org.opengts.util.ListTools;
import org.opengts.util.PixelPoint;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;
import org.opengts.util.StringTools;

public class GeoBounds
implements Cloneable {
    private double maxLat = -90.0;
    private double maxLon = -180.0;
    private double minLat = 90.0;
    private double minLon = 180.0;
    private static final String[] ARG_GEOPOINT = new String[]{"geopoint", "gp"};
    private static final String[] ARG_RADIUS = new String[]{"radius", "r"};

    public GeoBounds() {
    }

    public GeoBounds(GeoPointProvider ... gpp) {
        this.extendByPoint(gpp);
    }

    public GeoBounds(GeoPolygon gp) {
        if (gp != null) {
            this.extendByPoint(gp.getGeoPoints());
        }
    }

    public GeoBounds(Collection<GeoPointProvider> gppList) {
        this.extendByPoint(gppList);
    }

    public GeoBounds(double radiusM, GeoPointProvider ... gpp) {
        this.extendByCircle(radiusM, gpp);
    }

    public GeoBounds(String gbs, char sep) {
        this();
        String[] L;
        if (gbs != null && (L = StringTools.split(gbs, sep)).length == 4) {
            this.setMinLatitude(GeoPoint.parseLatitude(L[0], 0.0));
            this.setMaxLatitude(GeoPoint.parseLatitude(L[1], 0.0));
            this.setMinLongitude(GeoPoint.parseLongitude(L[2], 0.0));
            this.setMaxLongitude(GeoPoint.parseLongitude(L[3], 0.0));
        }
    }

    public GeoBounds(GeoBounds gb) {
        if (gb != null) {
            this.setMinLatitude(gb.getMinLatitude());
            this.setMaxLatitude(gb.getMaxLatitude());
            this.setMinLongitude(gb.getMinLongitude());
            this.setMaxLongitude(gb.getMaxLongitude());
        }
    }

    public Object clone() {
        return new GeoBounds(this);
    }

    public void setMaxLatitude(double maxLat) {
        this.maxLat = maxLat;
    }

    public double getMaxLatitude() {
        return this.maxLat;
    }

    public double getMaxY() {
        return this.getMaxLatitude();
    }

    public double getTop() {
        return this.getMaxLatitude();
    }

    public void setMinLatitude(double minLat) {
        this.minLat = minLat;
    }

    public double getMinLatitude() {
        return this.minLat;
    }

    public double getMinY() {
        return this.getMinLatitude();
    }

    public double getBottom() {
        return this.getMinLatitude();
    }

    public void setMaxLongitude(double maxLon) {
        this.maxLon = maxLon;
    }

    public double getMaxLongitude() {
        return this.maxLon;
    }

    public double getMaxX() {
        return this.getMaxLongitude();
    }

    public double getRight() {
        return this.getMaxLongitude();
    }

    public void setMinLongitude(double minLon) {
        this.minLon = minLon;
    }

    public double getMinLongitude() {
        return this.minLon;
    }

    public double getMinX() {
        return this.getMinLongitude();
    }

    public double getLeft() {
        return this.getMinLongitude();
    }

    public boolean isValid() {
        if (!GeoPoint.isValid(this.getMinLatitude(), this.getMinLongitude())) {
            return false;
        }
        if (!GeoPoint.isValid(this.getMaxLatitude(), this.getMaxLongitude())) {
            return false;
        }
        if (this.getMinLatitude() > this.getMaxLatitude()) {
            return false;
        }
        return !(this.getMinLongitude() > this.getMaxLongitude());
    }

    public void extendByPoint(GeoPointProvider gpp) {
        if (gpp != null) {
            GeoPoint gp = gpp.getGeoPoint();
            double lat = gp.getLatitude();
            double lon = gp.getLongitude();
            if (lat > this.getMaxLatitude()) {
                this.setMaxLatitude(lat);
            }
            if (lat < this.getMinLatitude()) {
                this.setMinLatitude(lat);
            }
            if (lon > this.getMaxLongitude()) {
                this.setMaxLongitude(lon);
            }
            if (lon < this.getMinLongitude()) {
                this.setMinLongitude(lon);
            }
        }
    }

    public void extendByPoint(GeoPointProvider ... gpp) {
        if (!ListTools.isEmpty(gpp)) {
            for (int i = 0; i < gpp.length; ++i) {
                this.extendByPoint(gpp[i]);
            }
        }
    }

    public void extendByPoint(Collection<GeoPointProvider> gppList) {
        if (!ListTools.isEmpty(gppList)) {
            for (GeoPointProvider gpp : gppList) {
                this.extendByPoint(gpp);
            }
        }
    }

    public void extendByCircle(double radiusM, GeoPointProvider gpp) {
        GeoPoint gp;
        if (radiusM > 0.0 && gpp != null && (gp = gpp.getGeoPoint()).isValid()) {
            this.extendByPoint((GeoPointProvider)gp.getHeadingPoint(radiusM, 0.0));
            this.extendByPoint((GeoPointProvider)gp.getHeadingPoint(radiusM, 90.0));
            this.extendByPoint((GeoPointProvider)gp.getHeadingPoint(radiusM, 180.0));
            this.extendByPoint((GeoPointProvider)gp.getHeadingPoint(radiusM, 270.0));
        }
    }

    public void extendByCircle(double radiusM, GeoPointProvider ... gpp) {
        if (radiusM > 0.0 && !ListTools.isEmpty(gpp)) {
            for (int i = 0; i < gpp.length; ++i) {
                this.extendByCircle(radiusM, gpp[i]);
            }
        }
    }

    public boolean extendByRadius(double radiusM) {
        if (this.isValid() && radiusM > 0.0) {
            GeoPoint topLeftGP = new GeoPoint(this.getTop(), this.getLeft());
            this.extendByPoint((GeoPointProvider)topLeftGP.getHeadingPoint(radiusM, 0.0));
            this.extendByPoint((GeoPointProvider)topLeftGP.getHeadingPoint(radiusM, 270.0));
            GeoPoint botRghtGP = new GeoPoint(this.getBottom(), this.getRight());
            this.extendByPoint((GeoPointProvider)botRghtGP.getHeadingPoint(radiusM, 180.0));
            this.extendByPoint((GeoPointProvider)botRghtGP.getHeadingPoint(radiusM, 90.0));
            return true;
        }
        return false;
    }

    public GeoPoint getCenter() {
        double avgLat = (this.getMinLatitude() + this.getMaxLatitude()) / 2.0;
        double avgLon = (this.getMinLongitude() + this.getMaxLongitude()) / 2.0;
        return new GeoPoint(avgLat, avgLon);
    }

    public double getDeltaLongitudeMeters() {
        if (Math.abs(this.getMinLatitude()) < Math.abs(this.getMaxLatitude())) {
            GeoPoint gp1 = new GeoPoint(this.getMinLatitude(), this.getMinLongitude());
            GeoPoint gp2 = new GeoPoint(this.getMinLatitude(), this.getMaxLongitude());
            return gp1.metersToPoint(gp2);
        }
        GeoPoint gp1 = new GeoPoint(this.getMaxLatitude(), this.getMinLongitude());
        GeoPoint gp2 = new GeoPoint(this.getMaxLatitude(), this.getMaxLongitude());
        return gp1.metersToPoint(gp2);
    }

    public double getDeltaLatitudeMeters() {
        GeoPoint gp1 = new GeoPoint(this.getMinLatitude(), this.getMinLongitude());
        GeoPoint gp2 = new GeoPoint(this.getMaxLatitude(), this.getMinLongitude());
        return gp1.metersToPoint(gp2);
    }

    public double getDiagonalMeters() {
        GeoPoint gp1 = new GeoPoint(this.getMinLatitude(), this.getMaxLongitude());
        GeoPoint gp2 = new GeoPoint(this.getMaxLatitude(), this.getMinLongitude());
        return gp1.metersToPoint(gp2);
    }

    public double getMetersPerPixel(int W, int H) {
        if (W > 0 && H > 0) {
            double hMPP;
            double wMPP = this.getDeltaLongitudeMeters() / (double)W;
            return wMPP > (hMPP = this.getDeltaLatitudeMeters() / (double)H) ? wMPP : hMPP;
        }
        return 0.0;
    }

    public PixelPoint getPixelLocation(GeoPoint gp, int W, int H) {
        if (gp == null || !gp.isValid()) {
            return null;
        }
        double lat = gp.getLatitude();
        double lon = gp.getLongitude();
        if (lat < this.getMinLatitude() && lat > this.getMaxLatitude()) {
            return null;
        }
        if (lon < this.getMinLongitude() && lon > this.getMaxLongitude()) {
            return null;
        }
        double dX = (lon - this.getMinLongitude()) / this.getDeltaLatitude();
        double dY = (this.getMaxLatitude() - lat) / this.getDeltaLongitude();
        return new PixelPoint((int)Math.round(dY * (double)H), (int)Math.round(dX * (double)W));
    }

    public double getDeltaLatitude() {
        return this.getMaxLatitude() - this.getMinLatitude();
    }

    public double getDeltaLongitude() {
        return this.getMaxLongitude() - this.getMinLongitude();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("MaxLat/Lon:");
        sb.append(this.getMaxLatitude()).append("/").append(this.getMaxLongitude());
        sb.append(",");
        sb.append("MinLat/Lon:");
        sb.append(this.getMinLatitude()).append("/").append(this.getMinLongitude());
        return sb.toString();
    }

    public static void main(String[] argv) {
        RTConfig.setCommandLineArgs(argv);
        String gpStr = RTConfig.getString(ARG_GEOPOINT, null);
        GeoPoint gp = new GeoPoint(gpStr);
        if (!gp.isValid()) {
            gp = new GeoPoint(39.0, -142.0);
        }
        double radiusM = RTConfig.getDouble(ARG_RADIUS, 1000.0);
        GeoBounds gb = new GeoBounds();
        gb.extendByCircle(radiusM, (GeoPointProvider)gp);
        Print.logInfo("GeoBounds: " + gb, new Object[0]);
    }
}

