/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.util;

import org.opengts.util.Print;
import org.opengts.util.RTConfig;
import org.opengts.util.StringTools;

public class FletcherChecksum {
    private int[] C = new int[]{0, 0};

    public FletcherChecksum() {
        this.reset();
    }

    public FletcherChecksum(byte[] b) {
        this();
        this.runningChecksum(b);
    }

    public void reset() {
        this.C[0] = 0;
        this.C[1] = 0;
    }

    public int[] getValues() {
        int[] F = new int[]{this.C[0] & 0xFF, this.C[1] & 0xFF};
        return F;
    }

    public boolean isValid() {
        byte[] F = this.getChecksum();
        return F[0] == 0 && F[1] == 0;
    }

    public byte[] getChecksum() {
        byte[] F = new byte[]{(byte)(this.C[0] - this.C[1] & 0xFF), (byte)(this.C[1] - (this.C[0] << 1) & 0xFF)};
        return F;
    }

    public int getChecksumAsInt() {
        byte[] cs = this.getChecksum();
        return (cs[0] & 0xFF) << 8 | cs[1] & 0xFF;
    }

    public void runningChecksum(byte b) {
        this.C[0] = this.C[0] + (b & 0xFF);
        this.C[1] = this.C[1] + this.C[0];
    }

    public void runningChecksum(byte[] b) {
        if (b != null) {
            for (int i = 0; i < b.length; ++i) {
                this.runningChecksum(b[i]);
            }
        }
    }

    public void runningChecksum(String s) {
        if (s != null) {
            this.runningChecksum(s.getBytes());
        }
    }

    public static void main(String[] argv) {
        RTConfig.setCommandLineArgs(argv);
        String val = RTConfig.getString("val", "");
        FletcherChecksum fc = new FletcherChecksum();
        fc.runningChecksum(val.getBytes());
        Print.sysPrintln("0x" + StringTools.toHexString(fc.getChecksumAsInt(), 16), new Object[0]);
        fc.runningChecksum(new byte[]{0, 0});
        Print.sysPrintln("0x" + StringTools.toHexString(fc.getChecksumAsInt(), 16), new Object[0]);
        byte[] cksm = fc.getChecksum();
        fc.reset();
        fc.runningChecksum(val.getBytes());
        fc.runningChecksum(cksm);
        Print.sysPrintln("0x" + StringTools.toHexString(fc.getChecksumAsInt(), 16), new Object[0]);
    }
}

