/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.util;

import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.opengts.util.DateTime;
import org.opengts.util.HTMLTools;
import org.opengts.util.ListTools;
import org.opengts.util.MethodAction;
import org.opengts.util.OSTools;
import org.opengts.util.Payload;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;
import org.opengts.util.StringTools;
import org.opengts.util.URIArg;

public class FileTools {
    private static int COPY_STREAMS_BLOCK_SIZE = 204800;
    private static final String[] ARG_WGET = new String[]{"wget", "url"};
    private static final String[] ARG_FROM_HEX = new String[]{"fromHex", "hexFile"};
    private static final String[] ARG_TODIR = new String[]{"dir", "todir"};
    private static final String[] ARG_TOFILE = new String[]{"to", "tofile"};
    private static final String[] ARG_WHERE = new String[]{"where"};
    private static final String[] ARG_WIDTH = new String[]{"width", "w"};
    private static final String[] ARG_DUMP = new String[]{"dump"};
    private static final String[] ARG_STRINGS = new String[]{"strings"};
    private static final String[] ARG_UNI_ENCODE = new String[]{"uniencode", "ue"};
    private static final String[] ARG_UNI_DECODE = new String[]{"unidecode", "ud"};
    private static final String[] ARG_FIND = new String[]{"find"};
    private static final String[] ARG_COUNTUNIQUE = new String[]{"countUnique"};
    private static final String[] ARG_FILTERLOG = new String[]{"filterLog", "flog"};
    private static final String[] ARG_NO_HEADER = new String[]{"noHeader", "nh"};
    private static final String[] ARG_SEARCH = new String[]{"search", "grep"};
    private static final String[] ARG_MATCH = new String[]{"match"};
    private static final String[] ARG_COPY_CSV = new String[]{"copyCSV"};
    private static final String[] ARG_MD5 = new String[]{"md5"};
    private static final String[] ARG_SHA1 = new String[]{"sha1"};
    private static final String[] ARG_SHA256 = new String[]{"sha256"};
    private static final String[] ARG_IS_LINK = new String[]{"isLink"};
    private static final String[] ARG_PATTERN = new String[]{"pattern"};

    public static URL toURL(File file) throws MalformedURLException {
        if (file == null) {
            return null;
        }
        return file.toURI().toURL();
    }

    public static File toFile(URL url) throws URISyntaxException {
        if (url == null) {
            return null;
        }
        if (!url.getProtocol().equalsIgnoreCase("file")) {
            throw new URISyntaxException(url.toString(), "Invalid protocol (expecting 'file')");
        }
        try {
            return new File(url.toURI());
        }
        catch (IllegalArgumentException iae) {
            return new File(HTMLTools.decodeParameter(url.getPath()));
        }
    }

    public static File toFile(File base, String[] path) {
        if (base == null) {
            return null;
        }
        if (ListTools.isEmpty(path)) {
            return base;
        }
        File b = base;
        for (int i = 0; i < path.length; ++i) {
            b = new File(b, path[i]);
        }
        return b;
    }

    public static File toFile(String[] path) {
        if (ListTools.isEmpty(path)) {
            return null;
        }
        File b = new File(path[0]);
        for (int i = 1; i < path.length; ++i) {
            b = new File(b, path[i]);
        }
        return b;
    }

    public static File getRealFile(File file) {
        if (file != null && file.exists()) {
            try {
                return file.getCanonicalFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    public static File getRealFile(File dir, String file) {
        if (dir != null && dir.isDirectory()) {
            if (file == null) {
                return FileTools.getRealFile(dir);
            }
            return FileTools.getRealFile(new File(dir, file));
        }
        return null;
    }

    public static int copyFile(URL inpURL, File outFile) throws IOException {
        return FileTools.copyFile(inpURL, outFile, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int copyFile(URL inpURL, File outFile, boolean progress) throws IOException {
        if (inpURL == null || outFile == null) {
            return 0;
        }
        String outName = outFile.toString();
        if (outName.equalsIgnoreCase("stdout")) {
            return FileTools.copyFile(inpURL, System.out, false);
        }
        if (outName.equalsIgnoreCase("stderr")) {
            return FileTools.copyFile(inpURL, System.err, false);
        }
        int cnt = 0;
        InputStream uis = null;
        FileOutputStream out = null;
        try {
            URLConnection urlConnect = inpURL.openConnection();
            urlConnect.setConnectTimeout(5000);
            urlConnect.setReadTimeout(5000);
            uis = urlConnect.getInputStream();
            int len = urlConnect.getContentLength();
            out = new FileOutputStream(outFile, false);
            cnt = FileTools.copyStreams(uis, out, null, len, progress);
        }
        catch (Throwable throwable) {
            FileTools.closeStream(uis);
            FileTools.closeStream(out);
            throw throwable;
        }
        FileTools.closeStream(uis);
        FileTools.closeStream(out);
        return cnt;
    }

    public static int copyFile(URL inpURL, OutputStream out) throws IOException {
        return FileTools.copyFile(inpURL, out, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int copyFile(URL inpURL, OutputStream out, boolean progress) throws IOException {
        if (inpURL == null || out == null) {
            return 0;
        }
        int cnt = 0;
        InputStream uis = null;
        try {
            URLConnection urlConnect = inpURL.openConnection();
            urlConnect.setConnectTimeout(5000);
            urlConnect.setReadTimeout(5000);
            uis = urlConnect.getInputStream();
            int len = urlConnect.getContentLength();
            cnt = FileTools.copyStreams(uis, out, null, len, progress);
        }
        catch (Throwable throwable) {
            FileTools.closeStream(uis);
            throw throwable;
        }
        FileTools.closeStream(uis);
        return cnt;
    }

    public static int copyStreams(InputStream input, OutputStream output) throws IOException {
        return FileTools.copyStreams(input, output, null, -1, false);
    }

    public static int copyStreams(InputStream input, OutputStream output, int maxLen) throws IOException {
        return FileTools.copyStreams(input, output, null, maxLen, false);
    }

    public static int copyStreams(InputStream input, OutputStream output, byte[] pattern, int maxLen) throws IOException {
        return FileTools.copyStreams(input, output, pattern, maxLen, false);
    }

    public static int copyStreams(InputStream input, OutputStream output, byte[] pattern, int maxLen, boolean progress) throws EOFException, IOException {
        if (input == null || output == null || maxLen == 0) {
            return 0;
        }
        boolean hasPattern = false;
        int pndx = 0;
        int plen = 0;
        if (pattern != null && pattern.length > 0) {
            hasPattern = true;
            plen = pattern.length;
        }
        int stopType = 0;
        long startMS = DateTime.getCurrentTimeMillis();
        long lastMS = 0L;
        int length = 0;
        byte[] tmpBuff = new byte[COPY_STREAMS_BLOCK_SIZE + plen];
        byte[] ch = new byte[1];
        while (true) {
            long nowMS;
            int cnt;
            block23: {
                int readLen;
                if (!hasPattern && maxLen > 0) {
                    readLen = maxLen - length;
                    if (readLen <= 0) break;
                    if (readLen > COPY_STREAMS_BLOCK_SIZE) {
                        readLen = COPY_STREAMS_BLOCK_SIZE;
                    }
                } else {
                    readLen = COPY_STREAMS_BLOCK_SIZE;
                }
                if (hasPattern) {
                    cnt = 0;
                    block1: while (cnt < readLen) {
                        int c = input.read(ch, 0, 1);
                        if (c < 0) {
                            if (cnt <= 0) {
                                cnt = c;
                            }
                            break;
                        }
                        if (c == 0) break;
                        while (true) {
                            if (ch[0] == pattern[pndx]) {
                                if (++pndx < plen) continue block1;
                                break block23;
                            }
                            if (pndx <= 0) break;
                            System.arraycopy(pattern, 0, tmpBuff, cnt, pndx);
                            cnt += pndx;
                            pndx = 0;
                        }
                        tmpBuff[cnt++] = ch[0];
                    }
                } else {
                    cnt = input.read(tmpBuff, 0, readLen);
                }
            }
            if (cnt < 0) {
                stopType = 1;
                if (hasPattern) {
                    throw new EOFException("Pattern not found");
                }
                if (!progress || maxLen <= 0 || length == maxLen) break;
                Print.logError("Copy size mismatch: " + maxLen + " --> " + length, new Object[0]);
                break;
            }
            if (cnt > 0) {
                if (maxLen < 0) {
                    output.write(tmpBuff, 0, cnt);
                    length += cnt;
                } else if (length < maxLen) {
                    int wrtLen = length + cnt > maxLen ? maxLen - length : cnt;
                    output.write(tmpBuff, 0, wrtLen);
                    if (!hasPattern && (length += wrtLen) >= maxLen) {
                        stopType = 2;
                        break;
                    }
                }
            }
            if (hasPattern && pndx >= plen) {
                stopType = 3;
                break;
            }
            if (!progress || (nowMS = DateTime.getCurrentTimeMillis()) - lastMS < 1000L) continue;
            lastMS = nowMS;
            double elapseMS = nowMS - startMS;
            if (maxLen > 0) {
                double p = (double)length / (double)maxLen;
                double totalMS = elapseMS / p;
                Print.sysPrint("Copying - %7d/%d bytes (%2.0f/%.0f sec, %2.0f%%)\r", length, maxLen, elapseMS / 1000.0, totalMS / 1000.0, p * 100.0);
                continue;
            }
            Print.sysPrint("Copying - %7d bytes (%2.0f sec)\r", length, elapseMS / 1000.0);
        }
        output.flush();
        if (progress) {
            double elapseMS = DateTime.getCurrentTimeMillis() - startMS;
            Print.sysPrintln("Copied - %7d bytes (%.0f sec)                                     ", length, elapseMS / 1000.0);
        }
        return length;
    }

    public static InputStream openInputFile(String file) {
        if (file != null && !file.equals("")) {
            return FileTools.openInputFile(new File(file));
        }
        return null;
    }

    public static InputStream openInputFile(File file) {
        try {
            return new FileInputStream(file);
        }
        catch (IOException ioe) {
            Print.logError("Unable to open file: " + file + " [" + ioe + "]", new Object[0]);
            return null;
        }
    }

    public static void closeStream(InputStream in) {
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void closeStream(OutputStream out) {
        if (out != null) {
            if (out == System.out) {
                Print.logWarn("Ignoring close on 'stdout'", new Object[0]);
            } else if (out == System.err) {
                Print.logWarn("Ignoring close on 'stderr'", new Object[0]);
            } else {
                try {
                    out.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    public static byte[] readStream(InputStream input) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        FileTools.copyStreams(input, output, null, -1, false);
        return output.toByteArray();
    }

    public static byte[] readStream(InputStream input, int maxLen) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        FileTools.copyStreams(input, output, null, maxLen, false);
        return output.toByteArray();
    }

    public static void writeStream(OutputStream output, String dataStr) throws IOException {
        byte[] data = dataStr.getBytes();
        output.write(data, 0, data.length);
    }

    public static byte[] readFile(String file) {
        if (file != null && !file.equals("")) {
            return FileTools.readFile(new File(file));
        }
        return null;
    }

    public static byte[] readFile(File file) {
        return FileTools.readFile(file, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readFile(File file, int maxLen) {
        if (file == null) {
            return null;
        }
        if (!file.exists()) {
            Print.logError("File does not exist: " + file, new Object[0]);
            return null;
        }
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            byte[] byArray = FileTools.readStream(fis, maxLen);
            return byArray;
        }
        catch (IOException ioe) {
            Print.logError("Unable to read file: " + file + " [" + ioe + "]", new Object[0]);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    public static String readLine(InputStream input, char eol) throws IOException {
        StringBuffer sb = new StringBuffer();
        while (true) {
            int ch;
            if ((ch = input.read()) < 0) {
                throw new EOFException("End of InputStream");
            }
            if (ch == eol) {
                return sb.toString();
            }
            sb.append((char)ch);
        }
    }

    public static String readLine(InputStream input) throws IOException {
        StringBuffer sb = new StringBuffer();
        while (true) {
            int ch;
            if ((ch = input.read()) < 0) {
                throw new EOFException("End of InputStream");
            }
            if (ch == 13 || ch == 10) {
                return sb.toString();
            }
            sb.append((char)ch);
        }
    }

    public static String readLineNL(InputStream input) throws IOException {
        StringBuffer sb = new StringBuffer();
        while (true) {
            int ch;
            if ((ch = input.read()) < 0) {
                throw new EOFException("End of InputStream");
            }
            if (ch == 13) continue;
            if (ch == 10) {
                return sb.toString();
            }
            sb.append((char)ch);
        }
    }

    public static String readLine_stdin() throws IOException {
        while (System.in.available() > 0) {
            System.in.read();
        }
        return FileTools.readLine(System.in);
    }

    public static String readString_stdin(String msg, String dft) throws IOException {
        String line;
        if (msg == null) {
            msg = "";
        }
        Print.sysPrintln(msg + "    [String: default='" + dft + "'] ", new Object[0]);
        while (true) {
            Print.sysPrint("?", new Object[0]);
            line = FileTools.readLine_stdin();
            if (!line.equals("")) break;
            if (dft != null) {
                return dft;
            }
            Print.sysPrint("String required, please re-enter] ", new Object[0]);
        }
        return line;
    }

    public static boolean readBoolean_stdin(String msg, boolean dft) throws IOException {
        String line;
        if (msg == null) {
            msg = "";
        }
        Print.sysPrintln(msg + "    [Boolean: default='" + dft + "'] ", new Object[0]);
        while (true) {
            Print.sysPrint("?", new Object[0]);
            line = FileTools.readLine_stdin().trim();
            if (line.equals("")) {
                return dft;
            }
            if (StringTools.isBoolean(line, true)) break;
            Print.sysPrint("Boolean required, please re-enter] ", new Object[0]);
        }
        return StringTools.parseBoolean(line, dft);
    }

    public static long readLong_stdin(String msg, long dft) throws IOException {
        String line;
        if (msg == null) {
            msg = "";
        }
        Print.sysPrintln(msg + "    [Long: default='" + dft + "'] ", new Object[0]);
        while (true) {
            Print.sysPrint("?", new Object[0]);
            line = FileTools.readLine_stdin().trim();
            if (line.equals("")) {
                return dft;
            }
            if (Character.isDigit(line.charAt(0)) || line.charAt(0) == '-') break;
            Print.sysPrint("Long required, please re-enter] ", new Object[0]);
        }
        return StringTools.parseLong(line, dft);
    }

    public static double readDouble_stdin(String msg, double dft) throws IOException {
        String line;
        if (msg == null) {
            msg = "";
        }
        Print.sysPrintln(msg + "    [Double: default='" + dft + "'] ", new Object[0]);
        while (true) {
            Print.sysPrint("?", new Object[0]);
            line = FileTools.readLine_stdin().trim();
            if (line.equals("")) {
                return dft;
            }
            if (Character.isDigit(line.charAt(0)) || line.charAt(0) == '-' || line.charAt(0) == '.') break;
            Print.sysPrint("Double required, please re-enter] ", new Object[0]);
        }
        return StringTools.parseDouble(line, dft);
    }

    public static boolean writeFile(byte[] data, File file) throws IOException {
        return FileTools.writeFile(data, file, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writeFile(byte[] data, File file, boolean append) throws IOException {
        if (data != null && file != null) {
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(file, append);
                fos.write(data, 0, data.length);
                boolean bl = true;
                return bl;
            }
            finally {
                try {
                    fos.close();
                }
                catch (Throwable t) {}
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writeEscapedUnicode(String dataStr, File file) throws IOException {
        boolean append = false;
        if (dataStr != null && file != null) {
            FileOutputStream fos = new FileOutputStream(file, append);
            BufferedWriter fbw = null;
            try {
                fbw = new BufferedWriter(new OutputStreamWriter((OutputStream)fos, "8859_1"));
                int len = dataStr.length();
                for (int i = 0; i < len; ++i) {
                    char ch = dataStr.charAt(i);
                    if (ch == '\n' || ch == '\r') {
                        fbw.write(ch);
                        continue;
                    }
                    if (ch == '\t' || ch == '\f') {
                        fbw.write(ch);
                        continue;
                    }
                    if (ch < ' ' || ch > '~') {
                        fbw.write(92);
                        fbw.write(117);
                        fbw.write(StringTools.hexNybble(ch >> 12 & 0xF));
                        fbw.write(StringTools.hexNybble(ch >> 8 & 0xF));
                        fbw.write(StringTools.hexNybble(ch >> 4 & 0xF));
                        fbw.write(StringTools.hexNybble(ch & 0xF));
                        continue;
                    }
                    fbw.write(ch);
                }
                boolean bl = true;
                return bl;
            }
            finally {
                try {
                    fbw.close();
                }
                catch (Throwable t) {}
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> findPatternInFile(File file, String pattern, boolean ignoreCase) {
        if (file == null || !file.isFile()) {
            return null;
        }
        if (pattern == null || pattern.equals("")) {
            return null;
        }
        String p = ignoreCase ? pattern.toLowerCase() : pattern;
        Vector<String> matchList = new Vector<String>();
        FileInputStream fis = null;
        try {
            String line;
            fis = new FileInputStream(file);
            while ((line = FileTools.readLine(fis)) != null) {
                if (ignoreCase) {
                    if (line.toLowerCase().indexOf(p) < 0) continue;
                    matchList.add(line);
                    continue;
                }
                if (line.indexOf(p) < 0) continue;
                matchList.add(line);
            }
        }
        catch (FileNotFoundException fnfe) {
            List<String> list = null;
            return list;
        }
        catch (EOFException eofe) {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Throwable th) {}
            }
        }
        catch (IOException ioe) {
            Print.logError("Error reading file: " + file + " [" + ioe + "]", new Object[0]);
            List<String> list = null;
            return list;
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Throwable th) {}
            }
        }
        return matchList.size() > 0 ? matchList : null;
    }

    public static String getExtension(String filePath) {
        if (filePath != null) {
            return FileTools.getExtension(new File(filePath));
        }
        return "";
    }

    public static String getExtension(File file) {
        String fileName;
        int p;
        if (file != null && (p = (fileName = file.getName()).lastIndexOf(".")) >= 0 && p < fileName.length() - 1) {
            return fileName.substring(p + 1);
        }
        return "";
    }

    public static boolean hasExtension(String filePath, String[] extn) {
        if (filePath != null) {
            return FileTools.hasExtension(new File(filePath), extn);
        }
        return false;
    }

    public static boolean hasExtension(File file, String[] extn) {
        if (file != null && extn != null) {
            String e = FileTools.getExtension(file);
            for (int i = 0; i < extn.length; ++i) {
                if (!e.equalsIgnoreCase(extn[i])) continue;
                return true;
            }
        }
        return false;
    }

    public static String removeExtension(String filePath) {
        if (filePath != null) {
            return FileTools.removeExtension(new File(filePath));
        }
        return filePath;
    }

    public static String removeExtension(File file) {
        if (file != null) {
            String fileName = file.getName();
            int p = fileName.indexOf(".");
            if (p > 0) {
                file = new File(file.getParentFile(), fileName.substring(0, p));
            }
            return file.getPath();
        }
        return null;
    }

    public static boolean isFileSeparatorChar(char ch) {
        if (ch == File.separatorChar) {
            return true;
        }
        return OSTools.isWindows() && ch == '/';
    }

    public static boolean hasFileSeparator(String fn) {
        if (fn == null) {
            return false;
        }
        if (fn.indexOf(File.separator) >= 0) {
            return true;
        }
        return OSTools.isWindows() && fn.indexOf(47) >= 0;
    }

    public static File resolveCommand(String cmd) {
        if (StringTools.isBlank(cmd)) {
            return null;
        }
        File cmdFile = new File(cmd);
        if (cmdFile.isAbsolute()) {
            return cmdFile;
        }
        String envPath = System.getenv("PATH");
        String[] path = StringTools.split(envPath, File.pathSeparatorChar);
        for (int i = 0; i < path.length; ++i) {
            File cmdf = new File(path[i], cmd);
            if (!cmdf.isFile()) continue;
            Print.logInfo("Found: " + cmdf, new Object[0]);
            return cmdf;
        }
        return null;
    }

    public static boolean isAbsolute(File f) {
        if (f == null) {
            return false;
        }
        if (f.isAbsolute()) {
            return true;
        }
        String path = f.toString();
        return path.length() > 1 && path.charAt(1) == ':';
    }

    public static boolean isFile(String f) {
        return !StringTools.isBlank(f) && FileTools.isFile(new File(f));
    }

    public static boolean isFile(File f) {
        return f != null && f.isFile();
    }

    public static boolean isFile(File f, String ext) {
        if (f == null || !f.isFile()) {
            return false;
        }
        if (ext != null) {
            String fe = FileTools.getExtension(f);
            return ext.equalsIgnoreCase(fe);
        }
        return true;
    }

    public static boolean isDirectory(String d) {
        return !StringTools.isBlank(d) && FileTools.isDirectory(new File(d));
    }

    public static boolean isDirectory(File d) {
        return d != null && d.isDirectory();
    }

    public static boolean isWindowsShortcut(File link) {
        byte[] b;
        if (FileTools.isFile(link) && FileTools.getExtension(link).equalsIgnoreCase("lnk") && ListTools.size(b = FileTools.readFile(link, 4)) >= 4) {
            long val = Payload.decodeLong(b, 0, 4, false, false, 0L);
            return val == 76L;
        }
        return false;
    }

    public static File getWindowsShortcutFile(File link, boolean makeAbsolute) {
        int dLen;
        if (!FileTools.isFile(link)) {
            return null;
        }
        File parentDir = link.getParentFile();
        Payload p = new Payload(FileTools.readFile(link, 1000), false);
        long header = p.readULong(4, 0L, "header");
        byte[] GUID = p.readBytes(16, "GUID");
        long flags = p.readULong(4, 0L, "HeaderFlags");
        long attr = p.readULong(4, 0L, "Attributes");
        long time_1 = p.readLong(8, 0L, "CreateTime");
        long time_2 = p.readLong(8, 0L, "ModTime");
        long time_3 = p.readLong(8, 0L, "AccessTime");
        long fileLen = p.readULong(4, 0L, "FileLength");
        long iconNdx = p.readULong(4, 0L, "IconNum");
        long showWnd = p.readULong(4, 0L, "ShowWnd");
        long hotKey = p.readULong(4, 0L, "HotKey");
        long zero_1 = p.readULong(4, 0L, "Zero-1");
        long zero_2 = p.readULong(4, 0L, "Zero-2");
        if ((flags & 1L) != 0L) {
            int siLen = p.readUInt(2, 0, "ShellItemID");
            p.readSkip(siLen);
        }
        String path = null;
        if ((flags & 2L) != 0L) {
            p.saveIndex();
            int fileLocLen = p.readInt(4, 0, "FileLocLen");
            if (fileLocLen > 0) {
                p.restoreIndex();
                byte[] L = p.readBytes(fileLocLen, "FileLocTable");
                Payload f = new Payload(L, false);
                f.readSkip(4);
                int ofsStart = f.readInt(4, 0, "OfsStart");
                int flFlags = f.readInt(4, 0, "Volume");
                int ofsLocVolTbl = f.readInt(4, 0, "OfsLocVolTbl");
                int ofsBasePath = f.readInt(4, 0, "OfsBasePath");
                int ofsNetVol = f.readInt(4, 0, "OfsNetVolTbl");
                int ofsFinalPath = f.readInt(4, 0, "OfsFinalPath");
                if ((flFlags & 1) != 0) {
                    String bPath = ofsBasePath >= 28 ? StringTools.parseString(L, ofsBasePath, "") : "";
                    String fPath = ofsFinalPath >= 28 ? StringTools.parseString(L, ofsFinalPath, "") : "";
                    path = bPath + fPath;
                }
            }
        }
        if ((flags & 4L) != 0L) {
            dLen = p.readInt(2, 0, "DescLen");
            String desc = p.readString(dLen, false, "Desc");
        }
        if ((flags & 8L) != 0L) {
            dLen = p.readInt(2, 0, "RelPathLen");
            String relPath = p.readString(dLen, false, "RelPath");
            if (StringTools.isBlank(path)) {
                path = relPath;
            }
        }
        if ((flags & 0x10L) != 0L) {
            dLen = p.readInt(2, 0, "WorkDirLen");
            String workDir = p.readString(dLen, false, "WorkDir");
        }
        File file = null;
        if (!StringTools.isBlank(path)) {
            file = new File(path);
            if (makeAbsolute && !FileTools.isAbsolute(file) && !path.startsWith("\\") && !path.startsWith("/")) {
                file = new File(parentDir, file.toString());
            }
        }
        return file;
    }

    public static boolean isCygwinSymlink(File link) {
        byte[] b;
        if (FileTools.isFile(link) && ListTools.size(b = FileTools.readFile(link, 10)) >= 10) {
            String s = StringTools.toStringValue(b);
            return s.equalsIgnoreCase("!<symlink>");
        }
        return false;
    }

    public static File getCygwinSymlinkFile(File link, boolean makeAbsolute) {
        StringBuffer sb;
        if (!FileTools.isFile(link)) {
            return null;
        }
        File parentDir = link.getParentFile();
        Payload p = new Payload(FileTools.readFile(link, 300));
        String s = p.readString(10, false);
        if (!s.equalsIgnoreCase("!<symlink>")) {
            return null;
        }
        byte[] BOM = p.peekBytes(2);
        int utf16 = 0;
        if (BOM.length == 2) {
            if (BOM[0] == -1 && BOM[1] == -2) {
                utf16 = 1;
            } else if (BOM[0] == -2 && BOM[1] == -1) {
                utf16 = 2;
            }
        }
        String path = null;
        if (utf16 > 0) {
            p.readSkip(2);
            sb = new StringBuffer();
            while (p.hasAvailableRead()) {
                char ch;
                int ich = p.readUInt(2, 0);
                char c = ch = utf16 == 1 ? (char)(ich >> 8 & 0xFF) : (char)(ich & 0xFF);
                if (ch == '\u0000') break;
                sb.append(ch);
            }
            path = sb.toString();
        } else {
            int ich;
            char ch;
            sb = new StringBuffer();
            while (p.hasAvailableRead() && (ch = (char)((ich = p.readUInt(2, 0)) >> 8 & 0xFF)) != '\u0000') {
                sb.append(ch);
            }
            path = sb.toString();
        }
        File file = null;
        if (!StringTools.isBlank(path)) {
            file = new File(path);
            if (makeAbsolute && !FileTools.isAbsolute(file) && !path.startsWith("\\") && !path.startsWith("/")) {
                file = new File(parentDir, file.toString());
            }
        }
        return file;
    }

    public static boolean canExecute(File f) throws UnsupportedOperationException {
        if (f == null) {
            return false;
        }
        try {
            MethodAction canExecMeth = new MethodAction((Object)f, "canExecute");
            return (Boolean)canExecMeth.invoke();
        }
        catch (NoSuchMethodException nsme) {
            UnsupportedOperationException usoe = new UnsupportedOperationException("'canExecute' not supported");
            usoe.initCause(nsme);
            throw usoe;
        }
        catch (Throwable th) {
            UnsupportedOperationException usoe = new UnsupportedOperationException("Exception thrown during 'canExecute'");
            usoe.initCause(th);
            throw usoe;
        }
    }

    public static boolean canRead(File f) throws UnsupportedOperationException {
        if (f == null) {
            return false;
        }
        try {
            MethodAction canReadMeth = new MethodAction((Object)f, "canRead");
            return (Boolean)canReadMeth.invoke();
        }
        catch (NoSuchMethodException nsme) {
            UnsupportedOperationException usoe = new UnsupportedOperationException("'canRead' not supported");
            usoe.initCause(nsme);
            throw usoe;
        }
        catch (Throwable th) {
            UnsupportedOperationException usoe = new UnsupportedOperationException("Exception thrown during 'canRead'");
            usoe.initCause(th);
            throw usoe;
        }
    }

    public static boolean canWrite(File f) throws UnsupportedOperationException {
        if (f == null) {
            return false;
        }
        try {
            MethodAction canWriteMeth = new MethodAction((Object)f, "canWrite");
            return (Boolean)canWriteMeth.invoke();
        }
        catch (NoSuchMethodException nsme) {
            UnsupportedOperationException usoe = new UnsupportedOperationException("'canWrite' not supported");
            usoe.initCause(nsme);
            throw usoe;
        }
        catch (Throwable th) {
            UnsupportedOperationException usoe = new UnsupportedOperationException("Exception thrown during 'canWrite'");
            usoe.initCause(th);
            throw usoe;
        }
    }

    public static File findFile(File parentDir, String[] fileNames) {
        if (!FileTools.isDirectory(parentDir)) {
            return null;
        }
        if (fileNames == null || fileNames.length <= 0) {
            return null;
        }
        for (String fn : fileNames) {
            File file = new File(parentDir, fn);
            if (!file.isFile()) continue;
            return file;
        }
        return null;
    }

    public static File[] getFilesystemRoots() {
        return File.listRoots();
    }

    public static File[] getDirectories(File dir) {
        if (dir == null || !dir.isDirectory()) {
            return null;
        }
        return dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory();
            }
        });
    }

    public static File[] getFiles(File dir) {
        if (dir == null || !dir.isDirectory()) {
            return null;
        }
        return dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isFile();
            }
        });
    }

    private static boolean _getAllFiles(Collection<File> fileList, File dir, final Set<String> extnSet, final FileFilter filter) {
        File[] fileDirs;
        if (dir == null || !dir.isDirectory()) {
            return false;
        }
        for (File fd : fileDirs = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                if (extnSet != null && !extnSet.contains(FileTools.getExtension(file))) {
                    return false;
                }
                return filter == null || filter.accept(file);
            }
        })) {
            if (!fd.isFile()) continue;
            fileList.add(fd);
        }
        for (File fd : fileDirs) {
            if (!fd.isDirectory()) continue;
            FileTools._getAllFiles(fileList, fd, extnSet, filter);
        }
        return true;
    }

    public static File[] getFiles(File dir, final Set<String> extnSet, boolean recursiveDecent) {
        if (dir == null || !dir.isDirectory()) {
            return null;
        }
        if (!recursiveDecent) {
            return dir.listFiles(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    if (!file.isFile()) {
                        return false;
                    }
                    if (extnSet == null) {
                        return true;
                    }
                    String extn = FileTools.getExtension(file);
                    return extnSet.contains(extn);
                }
            });
        }
        Vector<File> fileList = new Vector<File>();
        FileTools._getAllFiles(fileList, dir, extnSet, null);
        return fileList.toArray(new File[fileList.size()]);
    }

    public static File[] getFiles(File dir, String[] extnList, boolean recursiveDecent) {
        if (dir == null || !dir.isDirectory()) {
            return null;
        }
        if (extnList == null) {
            return FileTools.getFiles(dir, (Set<String>)null, recursiveDecent);
        }
        Set<String> extnSet = ListTools.toSet(extnList, new HashSet());
        return FileTools.getFiles(dir, extnSet, recursiveDecent);
    }

    public static File[] getFiles(File dir, final Pattern regex, boolean recursiveDecent) {
        if (dir == null || !dir.isDirectory()) {
            return null;
        }
        FileFilter filter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (!file.isFile()) {
                    return false;
                }
                if (regex == null) {
                    return true;
                }
                return regex.matcher(file.getName()).matches();
            }
        };
        if (!recursiveDecent) {
            return dir.listFiles(filter);
        }
        Vector<File> fileList = new Vector<File>();
        FileTools._getAllFiles(fileList, dir, null, filter);
        return fileList.toArray(new File[fileList.size()]);
    }

    public static File[] getFiles(File dir, String fileGlob, boolean recursiveDecent) {
        if (dir == null || !dir.isDirectory()) {
            return null;
        }
        Pattern pattern = null;
        if (fileGlob != null) {
            StringBuffer fileRegex = new StringBuffer();
            fileRegex.append("^");
            block10: for (int c = 0; c < fileGlob.length(); ++c) {
                char ch = fileGlob.charAt(c);
                switch (ch) {
                    case '^': {
                        fileRegex.append("\\^");
                        continue block10;
                    }
                    case '$': {
                        fileRegex.append("\\$");
                        continue block10;
                    }
                    case '.': {
                        fileRegex.append("\\.");
                        continue block10;
                    }
                    case '?': {
                        fileRegex.append(".");
                        continue block10;
                    }
                    case '*': {
                        fileRegex.append(".*");
                        continue block10;
                    }
                    case '\\': {
                        fileRegex.append("\\\\");
                        continue block10;
                    }
                    default: {
                        fileRegex.append(ch);
                    }
                }
            }
            fileRegex.append("$");
            try {
                pattern = Pattern.compile(fileRegex.toString());
            }
            catch (PatternSyntaxException pse) {
                Print.logError("Invalid fileName regular expression: " + fileRegex, new Object[0]);
                return null;
            }
        }
        return FileTools.getFiles(dir, pattern, recursiveDecent);
    }

    public static boolean traverseAllFiles(File dir, FileFilter filter) {
        if (dir == null || !dir.isDirectory()) {
            return false;
        }
        File[] fileDirs = dir.listFiles();
        if (fileDirs != null) {
            for (File fd : fileDirs) {
                filter.accept(fd);
                if (!fd.isDirectory()) continue;
                FileTools.traverseAllFiles(fd, filter);
            }
            return true;
        }
        return false;
    }

    public static String getHash_MD5(File file) {
        if (file == null || !file.isFile()) {
            return null;
        }
        byte[] data = FileTools.readFile(file);
        if (data == null) {
            return null;
        }
        return FileTools.getHash_MD5(data);
    }

    public static String getHash_MD5(byte[] data) {
        if (!ListTools.isEmpty(data)) {
            try {
                MessageDigest msgDigest = MessageDigest.getInstance("MD5");
                msgDigest.reset();
                msgDigest.update(data);
                return StringTools.toHexString(msgDigest.digest()).toLowerCase();
            }
            catch (NoSuchAlgorithmException nsae) {
                return null;
            }
        }
        return null;
    }

    public static String getHash_SHA1(File file) {
        if (file == null || !file.isFile()) {
            return null;
        }
        byte[] data = FileTools.readFile(file);
        if (data == null) {
            return null;
        }
        return FileTools.getHash_SHA1(data);
    }

    public static String getHash_SHA1(byte[] data) {
        if (!ListTools.isEmpty(data)) {
            try {
                MessageDigest msgDigest = MessageDigest.getInstance("SHA-1");
                msgDigest.reset();
                msgDigest.update(data);
                return StringTools.toHexString(msgDigest.digest()).toLowerCase();
            }
            catch (NoSuchAlgorithmException nsae) {
                return null;
            }
        }
        return null;
    }

    public static String getHash_SHA256(File file) {
        if (file == null || !file.isFile()) {
            return null;
        }
        byte[] data = FileTools.readFile(file);
        if (data == null) {
            return null;
        }
        return FileTools.getHash_SHA256(data);
    }

    public static String getHash_SHA256(byte[] data) {
        if (!ListTools.isEmpty(data)) {
            try {
                MessageDigest msgDigest = MessageDigest.getInstance("SHA-256");
                msgDigest.reset();
                msgDigest.update(data);
                return StringTools.toHexString(msgDigest.digest()).toLowerCase();
            }
            catch (NoSuchAlgorithmException nsae) {
                return null;
            }
        }
        return null;
    }

    private static byte[] deNullify(byte[] data) {
        byte[] nonull = new byte[data.length];
        int n = 0;
        for (int d = 0; d < data.length; ++d) {
            if (data[d] == 0) continue;
            nonull[n++] = data[d];
        }
        if (n < data.length) {
            byte[] x = new byte[n];
            System.arraycopy(nonull, 0, x, 0, n);
            nonull = x;
        }
        return nonull;
    }

    private static void usage() {
        Print.sysPrintln("Usage:", new Object[0]);
        Print.sysPrintln("  java ... " + FileTools.class.getName() + " {options}", new Object[0]);
        Print.sysPrintln("Options:", new Object[0]);
        Print.sysPrintln("  -dump=<file>                  Print hex dump", new Object[0]);
        Print.sysPrintln("  -strings=<file>               Display all contained strings", new Object[0]);
        Print.sysPrintln("  -where=<cmd>                  Find location of file in path", new Object[0]);
        Print.sysPrintln("  -wget=<url> [-todir=<dir>]    Read file from URL and copy to current dir", new Object[0]);
        Print.sysPrintln("  -wget=<url> [-tofile=<file>]  Read file from URL and copy to specified file", new Object[0]);
        Print.sysPrintln("  -flog=<logFile>               Filter log file", new Object[0]);
        Print.sysPrintln("  -grep=<file> -match=pattern   Search for A\\B\\C patterns in file", new Object[0]);
        System.exit(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] argv) {
        File logFile;
        byte[] data;
        File file;
        RTConfig.setCommandLineArgs(argv);
        boolean quiet = RTConfig.getBoolean("quiet", false);
        if (RTConfig.hasProperty(ARG_WGET)) {
            Print.sysPrintln("", new Object[0]);
            String urlStr = RTConfig.getString(ARG_WGET, "");
            URIArg url = new URIArg(urlStr);
            File outFile = null;
            File toDir = RTConfig.getFile(ARG_TODIR, new File("."));
            File toFile = RTConfig.getFile(ARG_TOFILE, null);
            if (toFile == null) {
                int p;
                String urlFile = url.getFile();
                int n = p = urlFile != null ? urlFile.lastIndexOf(47) : -1;
                if (p > 0) {
                    String name = urlFile.substring(p + 1);
                    outFile = new File(toDir, name);
                    if (outFile.exists()) {
                        Print.sysPrintln("Output file already exists: " + outFile, new Object[0]);
                        System.exit(1);
                    }
                } else {
                    Print.sysPrintln("Output filename required for this URL: " + urlStr, new Object[0]);
                    System.exit(1);
                }
            } else if (toFile.toString().equalsIgnoreCase("stdout")) {
                outFile = new File("stdout");
                quiet = true;
            } else if (toFile.toString().equalsIgnoreCase("stderr")) {
                outFile = new File("stderr");
                quiet = true;
            } else {
                File file2 = outFile = toFile.isAbsolute() ? toFile : new File(toDir, toFile.toString());
                if (outFile.exists()) {
                    Print.sysPrintln("Output file already exists: " + outFile, new Object[0]);
                    System.exit(1);
                }
            }
            URL inpURL = null;
            try {
                inpURL = new URL(urlStr);
            }
            catch (MalformedURLException mue) {
                Print.sysPrintln("ERROR: Invalid URL: " + urlStr, new Object[0]);
            }
            if (!quiet) {
                Print.sysPrintln("Copy from: " + inpURL, new Object[0]);
                Print.sysPrintln("Copy to  : " + outFile, new Object[0]);
            }
            try {
                FileTools.copyFile(inpURL, outFile, !quiet);
            }
            catch (FileNotFoundException fnfe) {
                Print.sysPrintln("ERROR: File does not exist: " + urlStr, new Object[0]);
                System.exit(99);
            }
            catch (SocketTimeoutException ste) {
                Print.sysPrintln("ERROR: Unable to read URL (timeout): " + urlStr, new Object[0]);
                System.exit(99);
            }
            catch (Throwable th) {
                Print.logException("Copying URL", th);
                System.exit(99);
            }
            Print.sysPrintln("", new Object[0]);
            System.exit(0);
        }
        if (RTConfig.hasProperty(ARG_WHERE)) {
            file = RTConfig.getFile(ARG_WHERE, null);
            Print.sysPrintln("Where: " + FileTools.resolveCommand(file.toString()), new Object[0]);
            System.exit(0);
        }
        if (RTConfig.hasProperty(ARG_DUMP)) {
            file = RTConfig.getFile(ARG_DUMP, null);
            data = FileTools.readFile(file);
            System.out.println("Size " + (data != null ? data.length : -1));
            int width = RTConfig.getInt(ARG_WIDTH, 16);
            System.out.println(StringTools.formatHexString(data, width));
            System.exit(0);
        }
        if (RTConfig.hasProperty(ARG_UNI_DECODE)) {
            file = RTConfig.getFile(ARG_UNI_DECODE, null);
            data = FileTools.readFile(file);
            String dataStr = StringTools.unescapeUnicode(StringTools.toStringValue(data));
            Print.sysPrintln(dataStr, new Object[0]);
            System.exit(0);
        }
        if (RTConfig.hasProperty(ARG_FROM_HEX)) {
            File hexFile = RTConfig.getFile(ARG_FROM_HEX, null);
            String asciiHex = StringTools.toStringValue(FileTools.readFile(hexFile));
            byte[] bin = StringTools.parseHex(asciiHex, null);
            File toFile = RTConfig.getFile(ARG_TOFILE, null);
            try {
                FileTools.writeFile(bin, toFile, false);
                Print.sysPrintln("Data written to: " + toFile, new Object[0]);
                System.exit(0);
            }
            catch (IOException ioe) {
                Print.logException("Error writing to: " + toFile, ioe);
                System.exit(99);
            }
        }
        if (RTConfig.hasProperty(ARG_STRINGS)) {
            file = RTConfig.getFile(ARG_STRINGS, null);
            data = FileTools.readFile(file);
            int len = RTConfig.getInt(ARG_WIDTH, 4);
            if (len < 0) {
                len = -len;
                data = FileTools.deNullify(data);
            }
            int s = -1;
            int n = 0;
            for (int b = 0; b < data.length; ++b) {
                if (data[b] >= 32 && data[b] <= 127) {
                    if (s < 0) {
                        s = b;
                    }
                    ++n;
                    continue;
                }
                if (s < 0) continue;
                if (b - s >= len) {
                    String x = StringTools.toStringValue(data, s, b - s);
                    Print.sysPrintln(x, new Object[0]);
                }
                s = -1;
            }
            if (s >= 0) {
                if (data.length - s >= len) {
                    String x = StringTools.toStringValue(data, s, data.length - s);
                    Print.sysPrintln(x, new Object[0]);
                }
                s = -1;
            }
            System.exit(0);
        }
        if (RTConfig.hasProperty(ARG_FIND)) {
            String glob = RTConfig.getString(ARG_FIND, "");
            File[] files = FileTools.getFiles(new File("."), glob, true);
            if (ListTools.size(files) > 0) {
                for (File f : files) {
                    Print.sysPrintln(f.toString(), new Object[0]);
                }
            }
            System.exit(0);
        }
        if (RTConfig.hasProperty(ARG_COUNTUNIQUE)) {
            logFile = RTConfig.getFile(ARG_COUNTUNIQUE, null);
            if (!FileTools.isFile(logFile)) {
                Print.sysPrintln("ERROR: not a file: " + logFile, new Object[0]);
                System.exit(99);
            }
            int width = RTConfig.getInt(ARG_WIDTH, 22);
            int exit = 0;
            int count = 0;
            String lastUniq = "";
            FileInputStream fis = null;
            try {
                String s;
                fis = new FileInputStream(logFile);
                while ((s = FileTools.readLine(fis)) != null) {
                    String uniq;
                    String string = uniq = s.length() <= width ? s : s.substring(0, width);
                    if (lastUniq == null) {
                        lastUniq = uniq;
                        count = 1;
                        continue;
                    }
                    if (uniq.equals(lastUniq)) {
                        ++count;
                        continue;
                    }
                    Print.sysPrintln("\"" + lastUniq + "\" count " + count, new Object[0]);
                    lastUniq = uniq;
                    count = 1;
                }
                exit = 0;
            }
            catch (EOFException eof) {
                exit = 0;
            }
            catch (IOException ioe) {
                Print.logException("File error", ioe);
                exit = 1;
            }
            finally {
                try {
                    fis.close();
                }
                catch (Throwable th) {}
            }
            System.exit(exit);
        }
        if (RTConfig.hasProperty(ARG_FILTERLOG)) {
            logFile = RTConfig.getFile(ARG_FILTERLOG, null);
            if (!FileTools.isFile(logFile)) {
                Print.sysPrintln("ERROR: not a file: " + logFile, new Object[0]);
                System.exit(99);
            }
            boolean noHeader = RTConfig.getBoolean(ARG_NO_HEADER, false);
            int exit = 0;
            FileInputStream fis = null;
            try {
                String s;
                fis = new FileInputStream(logFile);
                while ((s = FileTools.readLine(fis)) != null) {
                    int fc = s.indexOf("[");
                    if (fc >= 0) {
                        int ec = s.indexOf("]", fc);
                        if (noHeader) {
                            if ((s = s.substring(ec + 1)).startsWith(" ")) {
                                s = s.substring(1);
                            }
                        } else {
                            int vb = s.indexOf("|", fc + 10);
                            if (ec >= 0 && vb >= 0 && fc < ec && vb < ec) {
                                s = s.substring(fc, vb) + s.substring(ec);
                            }
                        }
                    }
                    Print.sysPrintln(s, new Object[0]);
                }
                exit = 0;
            }
            catch (EOFException eof) {
                exit = 0;
            }
            catch (IOException ioe) {
                Print.logException("File error", ioe);
                exit = 1;
            }
            finally {
                try {
                    fis.close();
                }
                catch (Throwable th) {}
            }
            System.exit(exit);
        }
        if (RTConfig.hasProperty(ARG_SEARCH)) {
            File grepDir = RTConfig.getFile(ARG_SEARCH, null);
            File[] grepFile = null;
            if (grepDir.isFile()) {
                grepFile = new File[]{grepDir};
            } else if (grepDir.isDirectory()) {
                grepFile = FileTools.getFiles(grepDir);
            } else {
                Print.sysPrintln("ERROR: invalid file specification: " + grepDir, new Object[0]);
                System.exit(99);
            }
            String matchStr = RTConfig.getString(ARG_MATCH, null);
            if (StringTools.isBlank(matchStr)) {
                Print.sysPrintln("ERROR: Search string not specified", new Object[0]);
                System.exit(99);
            }
            String[] match = StringTools.split(matchStr, '\\');
            block80: for (File f : grepFile) {
                FileInputStream fis = null;
                try {
                    Print.sysPrintln("-----------------------------------------------", new Object[0]);
                    Print.sysPrintln("File: " + f, new Object[0]);
                    fis = new FileInputStream(f);
                    int m = 0;
                    String[] matchLines = new String[match.length];
                    while (true) {
                        int i;
                        String s;
                        if ((s = FileTools.readLine(fis)) == null) {
                            continue block80;
                        }
                        for (i = 0; i < m; ++i) {
                            if (StringTools.indexOfIgnoreCase(s, match[i]) < 0) continue;
                            matchLines[i] = s;
                            m = i + 1;
                        }
                        if (StringTools.indexOfIgnoreCase(s, match[m]) < 0) continue;
                        matchLines[m] = s;
                        if (++m < match.length) continue;
                        Print.sysPrintln("---------", new Object[0]);
                        for (i = 0; i < matchLines.length; ++i) {
                            Print.sysPrintln(matchLines[i], new Object[0]);
                        }
                        m = 0;
                    }
                }
                catch (EOFException eof) {
                }
                catch (IOException ioe) {
                    Print.logException("File error", ioe);
                    System.exit(1);
                }
                finally {
                    try {
                        fis.close();
                    }
                    catch (Throwable th) {}
                }
            }
            System.exit(0);
        }
        if (RTConfig.hasProperty(ARG_COPY_CSV)) {
            File toFile;
            File csvFile = RTConfig.getFile(ARG_COPY_CSV, null);
            if (!FileTools.isFile(csvFile)) {
                Print.sysPrintln("ERROR: not a file: " + csvFile, new Object[0]);
                System.exit(99);
            }
            if ((toFile = RTConfig.getFile(ARG_TOFILE, null)) != null && toFile.exists()) {
                Print.sysPrintln("ERROR: 'toFile' already exists: " + toFile, new Object[0]);
                System.exit(99);
            }
            int exit = 0;
            FileInputStream fis = null;
            FileOutputStream fos = null;
            char[] STRIP_CR = new char[]{'\r'};
            try {
                String s;
                fis = new FileInputStream(csvFile);
                fos = toFile != null ? new FileOutputStream(toFile) : null;
                String p = null;
                int actualRow = 0;
                int virtualRow = 0;
                while ((s = FileTools.readLine(fis, '\n')) != null) {
                    ++actualRow;
                    if (p != null) {
                        s = p + s;
                        p = null;
                    }
                    if (s.endsWith("\\")) {
                        Print.sysPrintln("Found continuation line at " + actualRow, new Object[0]);
                        p = s.substring(0, s.length() - 1);
                        continue;
                    }
                    String r = s.replace('\r', ' ');
                    if (!s.equals(r)) {
                        Print.sysPrintln("** Stripped CR at " + actualRow, new Object[0]);
                    }
                    ++virtualRow;
                    if (fos != null) {
                        byte[] b = r.getBytes();
                        fos.write(b, 0, b.length);
                        fos.write(10);
                        continue;
                    }
                    Print.sysPrintln(r, new Object[0]);
                }
                exit = 0;
            }
            catch (EOFException eof) {
                exit = 0;
            }
            catch (IOException ioe) {
                Print.logException("File error", ioe);
                exit = 1;
            }
            finally {
                try {
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (Throwable th) {}
                try {
                    if (fos != null) {
                        fos.close();
                    }
                }
                catch (Throwable th) {}
            }
            System.exit(exit);
        }
        if (RTConfig.hasProperty(ARG_MD5)) {
            file = RTConfig.getFile(ARG_MD5, null);
            if (!FileTools.isFile(file)) {
                Print.sysPrintln("ERROR: not a file: " + file, new Object[0]);
                System.exit(99);
            }
            Print.sysPrintln("MD5(" + file + ")= " + FileTools.getHash_MD5(file), new Object[0]);
            System.exit(0);
        }
        if (RTConfig.hasProperty(ARG_SHA1)) {
            file = RTConfig.getFile(ARG_SHA1, null);
            if (!FileTools.isFile(file)) {
                Print.sysPrintln("ERROR: not a file: " + file, new Object[0]);
                System.exit(99);
            }
            Print.sysPrintln("SHA1(" + file + ")= " + FileTools.getHash_SHA1(file), new Object[0]);
            System.exit(0);
        }
        if (RTConfig.hasProperty(ARG_SHA256)) {
            file = RTConfig.getFile(ARG_SHA256, null);
            if (!FileTools.isFile(file)) {
                Print.sysPrintln("ERROR: not a file: " + file, new Object[0]);
                System.exit(99);
            }
            Print.sysPrintln("SHA256(" + file + ")= " + FileTools.getHash_SHA256(file), new Object[0]);
            System.exit(0);
        }
        if (RTConfig.hasProperty(ARG_IS_LINK)) {
            file = RTConfig.getFile(ARG_IS_LINK, null);
            if (!FileTools.isFile(file)) {
                Print.sysPrintln("ERROR: not a file: " + file, new Object[0]);
                System.exit(99);
            }
            if (FileTools.isCygwinSymlink(file)) {
                Print.sysPrintln("Cygwin symlink: " + FileTools.getCygwinSymlinkFile(file, true), new Object[0]);
            } else if (FileTools.isWindowsShortcut(file)) {
                Print.sysPrintln("Windows shortcut: " + FileTools.getWindowsShortcutFile(file, true), new Object[0]);
            } else {
                Print.sysPrintln("Unable to determine if file is a symlink/shortcut", new Object[0]);
            }
            System.exit(0);
        }
        FileTools.usage();
    }
}

