/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.PrintSetup;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.opengts.util.EnumTools;
import org.opengts.util.ExcelAPI;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;
import org.opengts.util.StringTools;

public class ExcelTools {
    public static final String PROP_ExcelTools_debug = "ExcelTools.debug";
    public static final int IndexColor_NONE = -1;
    public static final int IndexColor_WHITE = IndexedColors.WHITE.getIndex();
    public static final int IndexColor_BLACK = IndexedColors.BLACK.getIndex();
    public static final int IndexColor_GRAY25 = IndexedColors.GREY_25_PERCENT.getIndex();
    public static final int IndexColor_GRAY50 = IndexedColors.GREY_50_PERCENT.getIndex();
    public static final String STYLE_TITLE = "title";
    public static final String STYLE_SUBTITLE = "subtitle";
    public static final String STYLE_HEADER = "header";
    public static final String STYLE_BODY = "body";
    public static final String STYLE_SUBTOTAL = "subtotal";
    public static final String STYLE_TOTAL = "total";
    public static final String STYLE_BLANK = "blank";
    public static String[] ARG_XLS = new String[]{"xls"};
    public static String[] ARG_XLSX = new String[]{"xlsx"};

    public static int getColorIndex(String name) {
        if (StringTools.isBlank(name) || name.equalsIgnoreCase("NONE")) {
            return -1;
        }
        IndexedColors color = (IndexedColors)EnumTools.getValueOf(IndexedColors.class, name);
        if (color != null) {
            return color.getIndex();
        }
        return -1;
    }

    public static CellStyle createStyle(Workbook wb, int fontPoint, int boldWeight, int fontColor, int horzAlign, int vertAlign, boolean wrapText, int fillColor, int fillPattern, int borderTopColor, int borderRightColor, int borderBottomColor, int borderLeftColor) {
        CellStyle style = wb.createCellStyle();
        Font font = wb.createFont();
        if (fontPoint >= 0) {
            font.setFontHeightInPoints((short)fontPoint);
        }
        if (boldWeight >= 0) {
            font.setBoldweight((short)boldWeight);
        }
        if (fontColor >= 0) {
            font.setColor((short)fontColor);
        }
        style.setFont(font);
        style.setWrapText(wrapText);
        if (horzAlign >= 0) {
            style.setAlignment((short)horzAlign);
        }
        if (vertAlign >= 0) {
            style.setVerticalAlignment((short)vertAlign);
        }
        if (fillColor >= 0) {
            style.setFillForegroundColor((short)fillColor);
        }
        if (fillPattern >= 0) {
            style.setFillPattern((short)fillPattern);
        }
        if (borderTopColor >= 0) {
            style.setBorderTop((short)1);
            style.setTopBorderColor((short)borderTopColor);
        }
        if (borderRightColor >= 0) {
            style.setBorderRight((short)1);
            style.setRightBorderColor((short)borderRightColor);
        }
        if (borderBottomColor >= 0) {
            style.setBorderBottom((short)1);
            style.setBottomBorderColor((short)borderBottomColor);
        }
        if (borderLeftColor >= 0) {
            style.setBorderLeft((short)1);
            style.setLeftBorderColor((short)borderLeftColor);
        }
        return style;
    }

    private static Map<String, CellStyle> createStyleMap(Workbook wb) {
        HashMap<String, CellStyle> styleMap = new HashMap<String, CellStyle>();
        CellStyle style = ExcelTools.createStyle(wb, 18, 700, IndexColor_BLACK, 2, 1, true, IndexColor_WHITE, 1, -1, IndexColor_BLACK, -1, IndexColor_BLACK);
        styleMap.put(STYLE_TITLE, style);
        style = ExcelTools.createStyle(wb, 12, 400, IndexColor_BLACK, 2, 1, true, IndexColor_WHITE, 1, -1, IndexColor_BLACK, -1, IndexColor_BLACK);
        styleMap.put(STYLE_SUBTITLE, style);
        style = ExcelTools.createStyle(wb, 11, 400, IndexColor_WHITE, 2, 1, true, IndexColor_GRAY50, 1, -1, -1, -1, -1);
        styleMap.put(STYLE_HEADER, style);
        style = ExcelTools.createStyle(wb, 11, 400, IndexColor_BLACK, 2, 1, true, IndexColor_WHITE, 1, IndexColor_BLACK, IndexColor_BLACK, IndexColor_BLACK, IndexColor_BLACK);
        styleMap.put(STYLE_BODY, style);
        style = ExcelTools.createStyle(wb, 11, 700, IndexColor_BLACK, 2, 1, true, IndexColor_GRAY25, 1, IndexColor_BLACK, -1, IndexColor_BLACK, -1);
        styleMap.put(STYLE_SUBTOTAL, style);
        style = ExcelTools.createStyle(wb, 11, 700, IndexColor_BLACK, 2, 1, true, IndexColor_GRAY25, 1, IndexColor_BLACK, -1, IndexColor_BLACK, -1);
        styleMap.put(STYLE_TOTAL, style);
        style = ExcelTools.createStyle(wb, 11, 400, IndexColor_BLACK, 2, 1, true, IndexColor_WHITE, 1, -1, -1, -1, -1);
        styleMap.put(STYLE_BLANK, style);
        return styleMap;
    }

    public static void main(String[] argv) {
        int i;
        RTConfig.setCommandLineArgs(argv);
        boolean xls = RTConfig.getBoolean(ARG_XLS, false);
        boolean xlsx = RTConfig.getBoolean(ARG_XLSX, false);
        Print.logInfo("XLS  = " + xls, new Object[0]);
        Print.logInfo("XLSX = " + xlsx, new Object[0]);
        if (!xls) {
            xlsx = true;
        }
        Print.logInfo("XLSX = " + xlsx, new Object[0]);
        Spreadsheet ss = new Spreadsheet();
        ss.init(xlsx, "reportSampe3");
        String[] columns = new String[]{"Date\nTime", "Device", "Latitude", "Longitude"};
        ss.setTitle(0, "Sample Report", columns.length);
        for (int hc = 0; hc < columns.length; ++hc) {
            ss.addHeaderColumn(1, hc, columns[hc], 15);
        }
        Object[] value = null;
        value = new Object[]{"2013/01/03", "mydevice", new Double(38.1234), new Double(-142.1234)};
        for (i = 0; i < value.length; ++i) {
            ss.addBodyColumn(2, i, value[i]);
        }
        value = new Object[]{"2013/01/04", "yourdevice", new Double(38.4321), new Double(-142.4321)};
        for (i = 0; i < value.length; ++i) {
            ss.addBodyColumn(3, i, value[i]);
        }
        ss.write((File)null);
    }

    public static class Spreadsheet
    implements ExcelAPI {
        private boolean debug = false;
        private String name = null;
        private Workbook wb = null;
        private Sheet sheet = null;
        private Map<String, CellStyle> styleMap = null;
        private String extn = null;
        private int maxColNdx = -1;
        private Map<Integer, Row> headerRowMap = new HashMap<Integer, Row>();
        private Map<Integer, Row> bodyRowMap = new HashMap<Integer, Row>();

        public Spreadsheet() {
            this.debug = RTConfig.getBoolean(ExcelTools.PROP_ExcelTools_debug, false);
            if (this.debug) {
                Print.logInfo("ExcelTools: Debug Logging Enabled", new Object[0]);
            }
        }

        public boolean isDebugLogging() {
            return this.debug;
        }

        @Override
        public void init(boolean xlsx, String name) {
            if (xlsx) {
                Print.logInfo("ExcelTools: Initializing 'XLSX' Workbook ... " + name, new Object[0]);
                try {
                    this.wb = (Workbook)Class.forName("org.apache.poi.xssf.usermodel.XSSFWorkbook").newInstance();
                    this.extn = "xlsx";
                }
                catch (Throwable th) {
                    Print.logError("ExcelTools: 'xlsx' not supported", new Object[0]);
                    return;
                }
            } else {
                Print.logInfo("ExcelTools: Initializing 'XLS' Workbook ... " + name, new Object[0]);
                this.wb = new HSSFWorkbook();
                this.extn = "xls";
            }
            this.name = name;
            this.sheet = this.wb.createSheet(this.name);
            PrintSetup printSetup = this.sheet.getPrintSetup();
            printSetup.setLandscape(true);
            this.sheet.setFitToPage(true);
            this.sheet.setHorizontallyCenter(true);
            this.styleMap = ExcelTools.createStyleMap(this.wb);
            if (this.debug) {
                Print.logInfo("ExcelTools: ... Workbook Initialized", new Object[0]);
            }
        }

        @Override
        public void setTitle(int rowIndex, String title, int colSpan) {
            if (this.debug) {
                Print.logInfo("ExcelTools: Setting Title ... " + title, new Object[0]);
            }
            Row titleRow = this.sheet.createRow(rowIndex);
            titleRow.setHeightInPoints(30.0f);
            Cell titleCell = titleRow.createCell(0);
            titleCell.setCellValue(title);
            titleCell.setCellStyle(this.styleMap.get(ExcelTools.STYLE_TITLE));
            this.sheet.addMergedRegion(new CellRangeAddress(rowIndex, rowIndex, 0, colSpan - 1));
        }

        @Override
        public void setSubtitle(int rowIndex, String title, int colSpan) {
            if (this.debug) {
                Print.logInfo("ExcelTools: Setting Subtitle ... " + title, new Object[0]);
            }
            Row titleRow = this.sheet.createRow(rowIndex);
            titleRow.setHeightInPoints(30.0f);
            Cell titleCell = titleRow.createCell(0);
            titleCell.setCellValue(title);
            titleCell.setCellStyle(this.styleMap.get(ExcelTools.STYLE_SUBTITLE));
            this.sheet.addMergedRegion(new CellRangeAddress(rowIndex, rowIndex, 0, colSpan - 1));
        }

        @Override
        public void setBlankRow(int rowIndex, int colSpan) {
            if (this.debug) {
                Print.logInfo("ExcelTools: Setting Blank Row ...", new Object[0]);
            }
            Row blankRow = this.sheet.createRow(rowIndex);
            blankRow.setHeightInPoints(14.0f);
            Cell blankCell = blankRow.createCell(0);
            blankCell.setCellValue("");
            blankCell.setCellStyle(this.styleMap.get(ExcelTools.STYLE_BLANK));
            this.sheet.addMergedRegion(new CellRangeAddress(rowIndex, rowIndex, 0, colSpan - 1));
        }

        @Override
        public void addHeaderColumn(int rowIndex, int colIndex, String colTitle, int charWidth) {
            this.addHeaderColumn(rowIndex, colIndex, 1, colTitle, charWidth);
        }

        @Override
        public void addHeaderColumn(int rowIndex, int colIndex, int colSpan, String colTitle, int charWidth) {
            int hc;
            Integer rowNdxI;
            Row headerRow;
            if (this.debug) {
                Print.logInfo("ExcelTools: Adding Header Column ... " + colTitle, new Object[0]);
            }
            if ((headerRow = this.headerRowMap.get(rowNdxI = new Integer(rowIndex))) == null) {
                headerRow = this.sheet.createRow(rowIndex);
                headerRow.setHeightInPoints(36.0f);
                this.headerRowMap.put(rowNdxI, headerRow);
            }
            if ((hc = colIndex) > this.maxColNdx) {
                this.maxColNdx = hc;
            }
            Cell headerCell = headerRow.createCell(hc);
            headerCell.setCellStyle(this.styleMap.get(ExcelTools.STYLE_HEADER));
            headerCell.setCellValue(colTitle);
            if (colSpan > 1) {
                int toColNdx = colIndex + colSpan - 1;
                this.sheet.addMergedRegion(new CellRangeAddress(rowIndex, rowIndex, colIndex, toColNdx));
            }
        }

        private void _addBodyColumn(int rowIndex, int colIndex, String style, int ptHeight, Object value) {
            int bc;
            Integer rowNdxI;
            Row bodyRow;
            if (this.debug) {
                Print.logInfo("ExcelTools: Adding Body Column ... " + value, new Object[0]);
            }
            if ((bodyRow = this.bodyRowMap.get(rowNdxI = new Integer(rowIndex))) == null) {
                bodyRow = this.sheet.createRow(rowIndex);
                bodyRow.setHeightInPoints((float)ptHeight);
                this.bodyRowMap.put(rowNdxI, bodyRow);
            }
            if ((bc = colIndex) > this.maxColNdx) {
                this.maxColNdx = bc;
            }
            Cell bodyCell = bodyRow.createCell(bc);
            bodyCell.setCellStyle(this.styleMap.get(style));
            if (value instanceof Double) {
                bodyCell.setCellValue(((Double)value).doubleValue());
            } else if (value instanceof Float) {
                bodyCell.setCellValue((double)((Float)value).floatValue());
            } else if (value instanceof Long) {
                bodyCell.setCellValue((double)((Long)value).longValue());
            } else if (value instanceof Integer) {
                bodyCell.setCellValue((double)((Integer)value).intValue());
            } else if (value instanceof Short) {
                bodyCell.setCellValue((double)((Short)value).shortValue());
            } else {
                bodyCell.setCellValue(StringTools.trim(value));
            }
        }

        @Override
        public void addBodyColumn(int rowIndex, int colIndex, Object value) {
            this._addBodyColumn(rowIndex, colIndex, ExcelTools.STYLE_BODY, 12, value);
        }

        @Override
        public void addSubtotalColumn(int rowIndex, int colIndex, Object value) {
            this._addBodyColumn(rowIndex, colIndex, ExcelTools.STYLE_SUBTOTAL, 16, value);
        }

        @Override
        public void addTotalColumn(int rowIndex, int colIndex, Object value) {
            this._addBodyColumn(rowIndex, colIndex, ExcelTools.STYLE_TOTAL, 16, value);
        }

        public void autoSizeColumns() {
            Print.logInfo("ExcelTools: Autosizing columns ... ", new Object[0]);
            for (int c = 0; c <= this.maxColNdx; ++c) {
                this.sheet.autoSizeColumn(c);
            }
        }

        public Workbook getWorkbook() {
            return this.wb;
        }

        public String getExtension() {
            return this.extn;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean write(File dir) {
            this.autoSizeColumns();
            boolean ok = false;
            FileOutputStream fout = null;
            try {
                String outName = this.name + "." + this.getExtension();
                File outFile = dir != null ? new File(dir, outName) : new File(outName);
                Print.logInfo("ExcelTools: Saving Spreadsheet to File: " + outFile, new Object[0]);
                fout = new FileOutputStream(outFile);
                this.wb.write((OutputStream)fout);
                ok = true;
            }
            catch (IOException ioe) {
                Print.logException("XLS save error", ioe);
                ok = false;
            }
            finally {
                try {
                    fout.close();
                }
                catch (Throwable th) {}
            }
            return ok;
        }

        @Override
        public boolean write(OutputStream out) {
            this.autoSizeColumns();
            boolean ok = false;
            try {
                Print.logInfo("ExcelTools: Saving Spreadsheet to OutputStream", new Object[0]);
                this.wb.write(out);
                ok = true;
            }
            catch (IOException ioe) {
                Print.logException("XLS save error", ioe);
                ok = false;
            }
            return ok;
        }
    }
}

