/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.util;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import org.opengts.util.I18N;
import org.opengts.util.ListTools;
import org.opengts.util.OrderedMap;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;
import org.opengts.util.StringTools;

public class EnumTools {
    private static Map<String, Class<? extends Enum>> enumRegistry = null;

    public static <T extends Enum<T>> Map<String, String> getValueMap(Class<T> enumClass, T[] list, Locale loc) {
        T[] e;
        OrderedMap<String, String> m = new OrderedMap<String, String>();
        if (enumClass != null && (e = list) != null) {
            for (int n = 0; n < e.length; ++n) {
                String k;
                String d = k = ((Enum)e[n]).name();
                if (loc != null && e[n] instanceof StringLocale) {
                    d = ((StringLocale)e[n]).toString(loc);
                }
                m.put(k, d);
            }
        }
        return m;
    }

    public static <T extends Enum<T>> Map<String, String> getValueMap(Class<T> enumClass, Locale loc) {
        Enum[] e;
        OrderedMap<String, String> m = new OrderedMap<String, String>();
        if (enumClass != null && (e = (Enum[])enumClass.getEnumConstants()) != null) {
            for (int n = 0; n < e.length; ++n) {
                String k;
                String d = k = e[n].name();
                if (loc != null && e[n] instanceof StringLocale) {
                    d = ((StringLocale)((Object)e[n])).toString(loc);
                }
                m.put(k, d);
            }
        }
        return m;
    }

    public static <T extends Enum<T>> Map<String, String> getValueMap(Class<T> enumClass) {
        return EnumTools.getValueMap(enumClass, null);
    }

    public static <T extends Enum<T>> Map<Integer, String> getIntValueMap(Class<T> enumClass, Locale loc) {
        Enum[] e;
        OrderedMap<Integer, String> m = new OrderedMap<Integer, String>();
        if (enumClass != null && (e = (Enum[])enumClass.getEnumConstants()) != null) {
            for (int n = 0; n < e.length; ++n) {
                if (!(e[n] instanceof IntValue)) continue;
                int i = ((IntValue)((Object)e[n])).getIntValue();
                String d = e[n].name();
                if (loc != null && e[n] instanceof StringLocale) {
                    d = ((StringLocale)((Object)e[n])).toString(loc);
                }
                m.put(new Integer(i), d);
            }
        }
        return m;
    }

    public static <T extends Enum<T>> Map<Integer, String> getIntValueMap(Class<T> enumClass) {
        return EnumTools.getIntValueMap(enumClass, null);
    }

    public static <T extends Enum<T>> String[] getValueNames(Class<T> enumClass, T[] list, Locale loc) {
        T[] e;
        if (enumClass != null && (e = list) != null) {
            String[] s = new String[e.length];
            for (int n = 0; n < e.length; ++n) {
                s[n] = loc != null && e[n] instanceof StringLocale ? ((StringLocale)e[n]).toString(loc) : ((Enum)e[n]).toString();
            }
            return s;
        }
        return new String[0];
    }

    public static <T extends Enum<T>> String[] getValueNames(Class<T> enumClass, Locale loc) {
        Enum[] e;
        if (enumClass != null && (e = (Enum[])enumClass.getEnumConstants()) != null) {
            String[] s = new String[e.length];
            for (int n = 0; n < e.length; ++n) {
                s[n] = loc != null && e[n] instanceof StringLocale ? ((StringLocale)((Object)e[n])).toString(loc) : e[n].toString();
            }
            return s;
        }
        return new String[0];
    }

    public static <T extends Enum<T>> String[] getValueNames(Class<T> enumClass) {
        return EnumTools.getValueNames(enumClass, null);
    }

    public static <T extends Enum<T>> T getDefault(Class<T> enumClass) {
        Enum[] e;
        if (enumClass != null && (e = (Enum[])enumClass.getEnumConstants()) != null && e.length > 0) {
            if (e[0] instanceof IsDefault) {
                for (int n = 0; n < e.length; ++n) {
                    if (!((IsDefault)((Object)e[n])).isDefault()) continue;
                    return (T)e[n];
                }
            }
            return (T)e[0];
        }
        return null;
    }

    public static <T extends Enum<T>> T getValueOf(Class<T> enumClass, String name) {
        return EnumTools.getValueOf(enumClass, name, null, null, true);
    }

    public static <T extends Enum<T>> T getValueOf(Class<T> enumClass, String name, T dft) {
        return EnumTools.getValueOf(enumClass, name, null, dft, false);
    }

    public static <T extends Enum<T>> T getValueOf(Class<T> enumClass, String name, Locale loc) {
        return EnumTools.getValueOf(enumClass, name, loc, null, true);
    }

    protected static <T extends Enum<T>> T getValueOf(Class<T> enumClass, String name, Locale loc, T dft, boolean rtnDefault) {
        if (enumClass != null && name != null) {
            name = StringTools.trim(name);
            try {
                return Enum.valueOf(enumClass, name);
            }
            catch (Throwable th) {
                Enum[] e = (Enum[])enumClass.getEnumConstants();
                if (e != null && e.length > 0) {
                    int intVal = StringTools.parseInt(name, Integer.MIN_VALUE);
                    long longVal = StringTools.parseLong(name, Long.MIN_VALUE);
                    for (int n = 0; n < e.length; ++n) {
                        if (e[n].toString().equalsIgnoreCase(name)) {
                            return (T)e[n];
                        }
                        if (e[n] instanceof StringValue && ((StringValue)((Object)e[n])).getStringValue().equalsIgnoreCase(name)) {
                            return (T)e[n];
                        }
                        if (loc != null && e[n] instanceof StringLocale && ((StringLocale)((Object)e[n])).toString(loc).equalsIgnoreCase(name)) {
                            return (T)e[n];
                        }
                        if (e[n] instanceof IntValue && ((IntValue)((Object)e[n])).getIntValue() == intVal) {
                            return (T)e[n];
                        }
                        if (!(e[n] instanceof LongValue) || ((LongValue)((Object)e[n])).getLongValue() != longVal) continue;
                        return (T)e[n];
                    }
                    if (rtnDefault && dft == null) {
                        return EnumTools.getDefault(enumClass);
                    }
                    return dft;
                }
                return dft;
            }
        }
        return dft;
    }

    public static <T extends Enum<T>> T getValueOf(Class<T> enumClass, int value) {
        return EnumTools.getValueOf(enumClass, value, null, true);
    }

    public static <T extends Enum<T>> T getValueOf(Class<T> enumClass, int value, T dft) {
        return EnumTools.getValueOf(enumClass, value, dft, false);
    }

    public static <T extends Enum<T>> T getValueOf(Class<T> enumClass, int value, T dft, boolean rtnDefault) {
        if (enumClass != null) {
            Enum[] e = (Enum[])enumClass.getEnumConstants();
            if (e != null && e.length > 0 && (e[0] instanceof IntValue || e[0] instanceof LongValue)) {
                for (int n = 0; n < e.length; ++n) {
                    if (e[n] instanceof IntValue && ((IntValue)((Object)e[n])).getIntValue() == value) {
                        return (T)e[n];
                    }
                    if (!(e[n] instanceof LongValue) || ((LongValue)((Object)e[n])).getLongValue() != (long)value) continue;
                    return (T)e[n];
                }
                if (rtnDefault && dft == null) {
                    return EnumTools.getDefault(enumClass);
                }
                return dft;
            }
            return dft;
        }
        return dft;
    }

    public static <T extends Enum<T>> T getValueOf(Class<T> enumClass, T value) {
        return EnumTools.getValueOf(enumClass, value, null, true);
    }

    public static <T extends Enum<T>> T getValueOf(Class<T> enumClass, T value, T dft) {
        return EnumTools.getValueOf(enumClass, value, dft, false);
    }

    public static <T extends Enum<T>> T getValueOf(Class<T> enumClass, T value, T dft, boolean rtnDefault) {
        if (value != null) {
            return value;
        }
        if (enumClass != null && rtnDefault && dft == null) {
            return EnumTools.getDefault(enumClass);
        }
        return dft;
    }

    public static <T extends Enum<T>> T[] getValuesForMask(Class<T> enumClass, long mask) {
        if (enumClass != null && BitMask.class.isAssignableFrom(enumClass)) {
            Vector<Enum> list = new Vector<Enum>();
            Enum[] e = (Enum[])enumClass.getEnumConstants();
            if (e != null) {
                for (int n = 0; n < e.length; ++n) {
                    long val = ((BitMask)((Object)e[n])).getLongValue();
                    if (val == 0L) {
                        if (mask != 0L) continue;
                        list.add(e[n]);
                        continue;
                    }
                    if ((val & mask) != val) continue;
                    list.add(e[n]);
                }
            }
            return (Enum[])ListTools.toArray(list, enumClass);
        }
        return null;
    }

    public static <T extends Enum<T>> long getValueMask(Class<T> enumClass) {
        if (enumClass != null && BitMask.class.isAssignableFrom(enumClass)) {
            long mask = 0L;
            Enum[] e = (Enum[])enumClass.getEnumConstants();
            if (e != null) {
                for (int n = 0; n < e.length; ++n) {
                    mask |= ((BitMask)((Object)e[n])).getLongValue();
                }
            }
            return mask;
        }
        return -1L;
    }

    public static void registerPublicEnumClasses(Class<?> enumContainerClass) {
        if (enumContainerClass != null) {
            if (enumContainerClass.isEnum()) {
                EnumTools.registerEnumClass(enumContainerClass);
            } else {
                Class<?>[] classList = enumContainerClass.getClasses();
                for (int i = 0; i < classList.length; ++i) {
                    if (!classList[i].isEnum()) continue;
                    EnumTools.registerEnumClass(classList[i]);
                }
            }
        }
    }

    public static <T extends Enum> void registerEnumClass(Class<T> enumClass) {
        EnumTools.registerEnumClass(null, enumClass);
    }

    public static <T extends Enum> void registerEnumClass(String name, Class<T> enumClass) {
        if (enumClass != null && enumClass.isEnum()) {
            if (enumRegistry == null) {
                enumRegistry = new HashMap<String, Class<? extends Enum>>();
            }
            if (StringTools.isBlank(name)) {
                String cn = enumClass.getName();
                int p = cn.lastIndexOf(".");
                String string = name = p >= 0 ? cn.substring(p + 1) : cn;
            }
            if (enumRegistry.containsKey(name)) {
                Class<? extends Enum> eclz = enumRegistry.get(name);
                if (eclz != null && !eclz.equals(enumClass)) {
                    Print.logStackTrace("Duplicate registered Enum names: " + name + " ==> (" + eclz.getName() + " != " + enumClass.getName() + ")");
                }
            } else {
                enumRegistry.put(name, enumClass);
            }
        }
    }

    public static Class<? extends Enum> getEnumClass(String name) {
        return EnumTools.getEnumClass(null, name);
    }

    public static Class<? extends Enum> getEnumClass(Class enumContainerClass, String name) {
        if (enumRegistry != null && name != null) {
            String eccn;
            int p;
            String n;
            if (enumContainerClass != null && enumRegistry.containsKey(n = ((p = (eccn = StringTools.className(enumContainerClass)).lastIndexOf(".")) >= 0 ? eccn.substring(p + 1) : eccn) + "$" + name)) {
                return enumRegistry.get(n);
            }
            if (enumRegistry.containsKey(name)) {
                return enumRegistry.get(name);
            }
        }
        return null;
    }

    public static void main(String[] argv) {
        RTConfig.setCommandLineArgs(argv);
        Print.logInfo("Referencing TestEnum.ONE ...", new Object[0]);
        EnumTools.registerPublicEnumClasses(EnumTools.class);
        Print.logInfo("Done referencing TestEnum.ONE ...", new Object[0]);
        String enumName = RTConfig.getString("enum", StringTools.className(TestEnum.class));
        Class<Enum> enumClass = EnumTools.getEnumClass(enumName);
        if (enumClass != null) {
            Print.logInfo("Found registered enum class: " + StringTools.className(enumClass), new Object[0]);
        } else {
            try {
                enumClass = Class.forName(enumName);
                Print.logInfo("Found Enum Class.forName: " + enumName, new Object[0]);
            }
            catch (Throwable th) {
                Print.logException("Unable to locate Enum Class.forName: " + enumName, th);
                System.exit(1);
            }
        }
        Enum[] e = enumClass.getEnumConstants();
        if (e != null) {
            for (int n = 0; n < e.length; ++n) {
                StringBuffer sb = new StringBuffer();
                sb.append(e[n].ordinal()).append(": ");
                sb.append(e[n].toString());
                if (e[n] instanceof IntValue) {
                    sb.append(" [").append(((IntValue)((Object)e[n])).getIntValue()).append("]");
                }
                Print.sysPrintln(sb.toString(), new Object[0]);
            }
        } else {
            Print.logError("Not an Enum type? " + StringTools.className(enumClass), new Object[0]);
        }
    }

    public static enum TestEnum implements StringLocale,
    IntValue
    {
        ONE(1, I18N._getString(EnumTools.class, "EnumTools.type.one", "One")),
        TWO(2, I18N._getString(EnumTools.class, "EnumTools.type.two", "Two")),
        THREE(3, I18N._getString(EnumTools.class, "EnumTools.type.three", "Three")),
        FOUR(4, I18N._getString(EnumTools.class, "EnumTools.type.four", "Four")),
        FIVE(5, I18N._getString(EnumTools.class, "EnumTools.type.five", "Five"));

        private int vv = 0;
        private I18N.Text aa = null;

        private TestEnum(int v, I18N.Text a) {
            this.vv = v;
            this.aa = a;
        }

        @Override
        public int getIntValue() {
            return this.vv;
        }

        public String toString() {
            return this.aa.toString();
        }

        @Override
        public String toString(Locale loc) {
            return this.aa.toString(loc);
        }
    }

    public static interface IsDefault {
        public boolean isDefault();
    }

    public static interface BitMask
    extends LongValue {
    }

    public static interface LongValue {
        public long getLongValue();
    }

    public static interface IntValue {
        public int getIntValue();
    }

    public static interface DoubleValue {
        public double getDoubleValue();
    }

    public static interface StringValue {
        public String getStringValue();
    }

    public static interface StringLocale {
        public String toString(Locale var1);
    }
}

