/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.util;

import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.opengts.util.DateTime;
import org.opengts.util.StringTools;

public class DayNumber
implements Comparable,
Cloneable {
    public static final String DATE_FORMAT_YMD_1 = "yyyy/MM/dd";
    public static final String DATE_FORMAT_YMD_2 = "yyyy-MM-dd";
    public static final String DEFAULT_DATE_FORMAT = "yyyy/MM/dd";
    private long dayNumber = 0L;
    private int year = 0;
    private int month1 = 0;
    private int dayOfMonth = 0;

    public static DayNumber parseDayNumber(String ymdStr) {
        int delim;
        if (StringTools.isBlank(ymdStr)) {
            return null;
        }
        if (ymdStr.indexOf("/") >= 0) {
            delim = 47;
        } else if (ymdStr.indexOf("-") >= 0) {
            delim = 45;
        } else {
            return null;
        }
        String[] YMD = StringTools.split(ymdStr, (char)delim);
        if (YMD.length != 3) {
            return null;
        }
        int yy = StringTools.parseInt(YMD[0], 0);
        int mm = StringTools.parseInt(YMD[1], 0);
        int dd = StringTools.parseInt(YMD[2], 0);
        if (yy < 1600 || yy > 2200) {
            return null;
        }
        if (mm >= 1 && mm <= 12) {
            if (dd <= 0 || dd > 31) {
                return null;
            }
            if (dd > DateTime.getDaysInMonth(null, mm, yy)) {
                return null;
            }
        }
        return new DayNumber(yy, mm, dd);
    }

    public DayNumber(long dayNumber) {
        this.dayNumber = dayNumber;
        DateTime.ParsedDateTime pdt = DateTime.getDateFromDayNumber(this.dayNumber);
        this.year = pdt.year;
        this.month1 = pdt.month1;
        this.dayOfMonth = pdt.day;
    }

    public DayNumber(int year, int month1, int day) {
        this.year = year;
        this.month1 = month1;
        this.dayOfMonth = day;
        this.dayNumber = DateTime.getDayNumberFromDate(year, month1, day);
    }

    public DayNumber(DayNumber other) {
        this.dayNumber = other != null ? other.dayNumber : 0L;
        this.year = other != null ? other.year : 0;
        this.month1 = other != null ? other.month1 : 0;
        this.dayOfMonth = other != null ? other.dayOfMonth : 0;
    }

    public long getDayNumber() {
        return this.dayNumber;
    }

    public int getYear() {
        return this.year;
    }

    public int getMonth() {
        return this.month1;
    }

    public int getMonth0() {
        return this.getMonth() - 1;
    }

    public int getDayOfMonth() {
        return this.dayOfMonth;
    }

    public int getDayOfWeek() {
        return DateTime.getDayOfWeek(this.getYear(), this.getMonth(), this.getDayOfMonth());
    }

    public boolean isLeapYear() {
        return DateTime.isLeapYear(this.getYear());
    }

    public DateTime getDateTime(TimeZone tmz, int hour24, int minute, int second) {
        DateTime.ParsedDateTime pdt = DateTime.getDateFromDayNumber(this.getDayNumber(), tmz);
        int year = pdt.getYear();
        int month1 = pdt.getMonth1();
        int day = pdt.getDayOfMonth();
        return new DateTime(tmz, year, month1, day, hour24, minute, second);
    }

    public DateTime getDayStart(TimeZone tmz) {
        return this.getDateTime(tmz, 0, 0, 0);
    }

    public DateTime getDayEnd(TimeZone tmz) {
        return this.getDateTime(tmz, 23, 59, 59);
    }

    public String format(String fmt) {
        String dtFMT = StringTools.blankDefault(fmt, "yyyy/MM/dd");
        if (this.getDayNumber() <= 0L) {
            String zz = dtFMT;
            zz = zz.replace('y', '0');
            zz = zz.replace('M', '0');
            zz = zz.replace('d', '0');
            return zz;
        }
        int year = this.getYear();
        int mon0 = this.getMonth() - 1;
        int day = this.getDayOfMonth();
        GregorianCalendar gc = new GregorianCalendar(year, mon0, day);
        return DateTime.format(gc.getTime(), null, dtFMT);
    }

    public String toString() {
        return this.format("yyyy/MM/dd");
    }

    public boolean equals(Object obj) {
        if (obj instanceof DayNumber) {
            return this.getDayNumber() == ((DayNumber)obj).getDayNumber();
        }
        return false;
    }

    public int compareTo(Object other) {
        if (other instanceof DayNumber) {
            long otherDN = ((DayNumber)other).getDayNumber();
            long thisDN = this.getDayNumber();
            if (thisDN < otherDN) {
                return -1;
            }
            if (thisDN > otherDN) {
                return 1;
            }
            return 0;
        }
        return -1;
    }

    public Object clone() {
        return new DayNumber(this);
    }
}

