/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.Vector;
import org.opengts.util.EnumTools;
import org.opengts.util.ListTools;
import org.opengts.util.OrderedMap;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;
import org.opengts.util.StringTools;

public class DateTime
implements Comparable,
Cloneable {
    public static final String GMT_TIMEZONE = "GMT";
    public static final TimeZone GMT = DateTime.getGMTTimeZone();
    public static final boolean LOWERCASE_TIMEZONE_LOOKUP = true;
    public static final String DEFAULT_DATE_FORMAT = "yyyy/MM/dd";
    public static final String DEFAULT_TIME_FORMAT = "HH:mm:ss";
    public static final String DEFAULT_TIMEZONE_FORMAT = "zzz";
    public static final String ISO8601_DATETIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ssZ";
    public static final String DEFAULT_DATETIME_FORMAT = "yyyy/MM/dd HH:mm:ss";
    public static final String DEFAULT_DATETIME_TZ_FORMAT = "yyyy/MM/dd HH:mm:ss zzz";
    public static final DateTime INVALID_DATETIME = new DateTime(0L);
    public static final DateTime MIN_DATETIME = DateTime.getMinDate();
    public static final DateTime MAX_DATETIME = DateTime.getMaxDate();
    public static final long MIN_TIMESEC = MIN_DATETIME.getTimeSec();
    public static final long MAX_TIMESEC = MAX_DATETIME.getTimeSec();
    public static final long HOURS_PER_DAY = 24L;
    public static final long SECONDS_PER_MINUTE = 60L;
    public static final long MINUTES_PER_HOUR = 60L;
    public static final long DAYS_PER_WEEK = 7L;
    public static final long SECONDS_PER_HOUR = 3600L;
    public static final long MINUTES_PER_DAY = 1440L;
    public static final long SECONDS_PER_DAY = 86400L;
    public static final long MINUTES_PER_WEEK = 10080L;
    public static final long SECONDS_PER_WEEK = 604800L;
    public static final double MINUTES_PER_SECOND = 0.016666666666666666;
    public static final double HOURS_PER_MINUTE = 0.016666666666666666;
    public static final double HOURS_PER_SECOND = 2.777777777777778E-4;
    public static final int MONTHS_PER_YEAR = 12;
    public static final int JAN = 0;
    public static final int FEB = 1;
    public static final int MAR = 2;
    public static final int APR = 3;
    public static final int MAY = 4;
    public static final int JUN = 5;
    public static final int JUL = 6;
    public static final int AUG = 7;
    public static final int SEP = 8;
    public static final int OCT = 9;
    public static final int NOV = 10;
    public static final int DEC = 11;
    public static final int JANUARY = 0;
    public static final int FEBRUARY = 1;
    public static final int MARCH = 2;
    public static final int APRIL = 3;
    public static final int JUNE = 5;
    public static final int JULY = 6;
    public static final int AUGUST = 7;
    public static final int SEPTEMBER = 8;
    public static final int OCTOBER = 9;
    public static final int NOVEMBER = 10;
    public static final int DECEMBER = 11;
    private static final String[][] MONTH_NAME = new String[][]{{"January", "Jan"}, {"February", "Feb"}, {"March", "Mar"}, {"April", "Apr"}, {"May", "May"}, {"June", "Jun"}, {"July", "Jul"}, {"August", "Aug"}, {"September", "Sep"}, {"October", "Oct"}, {"November", "Nov"}, {"December", "Dec"}};
    private static final int[] MONTH_DAYS = new int[]{31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    public static final int SUN = 0;
    public static final int MON = 1;
    public static final int TUE = 2;
    public static final int WED = 3;
    public static final int THU = 4;
    public static final int FRI = 5;
    public static final int SAT = 6;
    public static final int SUNDAY = 0;
    public static final int MONDAY = 1;
    public static final int TUESDAY = 2;
    public static final int WEDNESDAY = 3;
    public static final int THURSDAY = 4;
    public static final int FRIDAY = 5;
    public static final int SATURDAY = 6;
    private static final String[][] DAY_NAME = new String[][]{{"Sunday", "Sun", "Su"}, {"Monday", "Mon", "Mo"}, {"Tuesday", "Tue", "Tu"}, {"Wednesday", "Wed", "We"}, {"Thursday", "Thu", "Th"}, {"Friday", "Fri", "Fr"}, {"Saturday", "Sat", "Sa"}};
    private TimeZone timeZone = null;
    private long timeMillis = 0L;
    private static Object TimeZoneDSTMap_initLock = new Object();
    private static Map<String, String> TimeZoneDSTMap = null;
    private static SimpleDateFormat simpleFormatter = null;
    private static final String ARG_NOW_SEC = "-now_sec";
    private static final String ARG_NOW_MS = "-now_ms";
    private static final String ARG_COMPILE_TIME = "-compileTime";
    private static final String[] ARG_TIMEZONE_NAME = new String[]{"tzname", "tmzname"};
    private static final String[] ARG_TIMEZONE_LIST = new String[]{"tzlist", "timezones"};
    private static final String[] ARG_TIMEZONE_FILE = new String[]{"tmzfile"};
    private static final String[] ARG_TIMEZONE_TIME = new String[]{"tmztime"};
    private static final String[] ARG_TO_YMD = new String[]{"toymd"};
    private static final String[] ARG_TIMEZONE = new String[]{"tmz", "tz"};
    private static final String[] ARG_TIME = new String[]{"time"};
    private static final String[] ARG_PLUS = new String[]{"plus"};
    private static final String[] ARG_FORMAT = new String[]{"format"};

    public static String CompactDateTimeFormat(String sep) {
        String s = sep != null ? sep : "|";
        StringBuffer sb = new StringBuffer();
        sb.append(DEFAULT_DATE_FORMAT);
        sb.append(sep);
        sb.append(DEFAULT_TIME_FORMAT);
        sb.append(sep);
        sb.append(DEFAULT_TIMEZONE_FORMAT);
        return sb.toString();
    }

    public static String CompactDateTimeFormat(char sep) {
        return DateTime.CompactDateTimeFormat(String.valueOf(sep));
    }

    public static char[] GetDateSeparatorChars(String dateFormat) {
        char[] sep = new char[]{'/', '/'};
        if (dateFormat != null) {
            int c = 0;
            for (int i = 0; i < dateFormat.length() && c < sep.length; ++i) {
                char ch = dateFormat.charAt(i);
                if (Character.isLetterOrDigit(ch)) continue;
                sep[c++] = ch;
            }
        }
        return sep;
    }

    public static DateStringFormat getDateStringFormat(String dsfStr) {
        DateStringFormat dsf = null;
        if (dsfStr == null) {
            dsf = EnumTools.getDefault(DateStringFormat.class);
        } else {
            String fmt = dsfStr.toUpperCase();
            dsf = (DateStringFormat)((Object)EnumTools.getValueOf(DateStringFormat.class, fmt));
            Print.logInfo("Looking for: " + fmt + " [Found " + dsf, new Object[0]);
        }
        return dsf;
    }

    public static long DaySeconds(long days) {
        return days * 86400L;
    }

    public static long DaySeconds(double days) {
        return Math.round(days * 86400.0);
    }

    public static long HourSeconds(long hours) {
        return hours * 3600L;
    }

    public static long MinuteSeconds(long minutes) {
        return minutes * 60L;
    }

    public static int getMonthIndex0(String month, int dft) {
        String m;
        String string = m = month != null ? month.toLowerCase().trim() : null;
        if (m != null && !m.equals("")) {
            if (Character.isDigit(m.charAt(0))) {
                int v = StringTools.parseInt(m, -1);
                if (v >= 0 && v < 12) {
                    return v;
                }
            } else {
                for (int i = 0; i < MONTH_NAME.length; ++i) {
                    if (!m.startsWith(MONTH_NAME[i][1].toLowerCase())) continue;
                    return i;
                }
            }
        }
        return dft;
    }

    public static int getMonthIndex1(String month, int dft) {
        return DateTime.getMonthIndex0(month, dft - 1) + 1;
    }

    public static String getMonthName(int mon1, boolean abbrev) {
        int mon0 = mon1 - 1;
        if (mon0 >= 0 && mon0 <= 11) {
            return abbrev ? MONTH_NAME[mon0][1] : MONTH_NAME[mon0][0];
        }
        return "";
    }

    public static String[] getMonthNames(boolean abbrev) {
        String[] mo = new String[MONTH_NAME.length];
        for (int i = 0; i < MONTH_NAME.length; ++i) {
            mo[i] = DateTime.getMonthName(i, abbrev);
        }
        return mo;
    }

    public static Map<String, Integer> getMonthNameMap(boolean abbrev) {
        OrderedMap<String, Integer> map = new OrderedMap<String, Integer>();
        for (int i = 0; i < MONTH_NAME.length; ++i) {
            map.put(DateTime.getMonthName(i, abbrev), new Integer(i));
        }
        return map;
    }

    public static int getDaysInMonth(TimeZone tz, int mon1, int year) {
        int yy = year > mon1 ? year : mon1;
        int mm = year > mon1 ? mon1 : year;
        return DateTime.getMaxMonthDayCount(mm, DateTime.isLeapYear(yy));
    }

    public static int getMaxMonthDayCount(int mon1, boolean isLeapYear) {
        int m0 = mon1 - 1;
        int d = m0 >= 0 && m0 < MONTH_DAYS.length ? MONTH_DAYS[m0] : 31;
        return m0 != 1 || isLeapYear ? d : 28;
    }

    public static boolean isLeapYear(int year) {
        return new GregorianCalendar().isLeapYear(year);
    }

    public static int getDayIndex(String day, int dft) {
        String d;
        String string = d = day != null ? day.toLowerCase().trim() : null;
        if (!StringTools.isBlank(d)) {
            if (Character.isDigit(d.charAt(0))) {
                int v = StringTools.parseInt(d, -1);
                if (v >= 0 && v < 7) {
                    return v;
                }
            } else {
                for (int i = 0; i < DAY_NAME.length; ++i) {
                    if (!d.startsWith(DAY_NAME[i][2].toLowerCase())) continue;
                    return i;
                }
            }
        }
        return dft;
    }

    public static String getDayName(int day, int abbrev) {
        if (day >= 0 && day <= 6 && abbrev >= 0 && abbrev <= 2) {
            return DAY_NAME[day][abbrev];
        }
        return "";
    }

    public static String getDayName(int day, boolean abbrev) {
        return DateTime.getDayName(day, abbrev ? 1 : 0);
    }

    public static String[] getDayNames(int abbrev) {
        String[] dy = new String[DAY_NAME.length];
        for (int i = 0; i < DAY_NAME.length; ++i) {
            dy[i] = DateTime.getDayName(i, abbrev);
        }
        return dy;
    }

    public static String[] getDayNames(boolean abbrev) {
        return DateTime.getDayNames(abbrev ? 1 : 0);
    }

    public static Map<String, Integer> getDayNameMap(int abbrev) {
        OrderedMap<String, Integer> map = new OrderedMap<String, Integer>();
        for (int i = 0; i < DAY_NAME.length; ++i) {
            map.put(DateTime.getDayName(i, abbrev), new Integer(i));
        }
        return map;
    }

    public static Map<String, Integer> getDayNameMap(boolean abbrev) {
        return DateTime.getDayNameMap(abbrev ? 1 : 0);
    }

    public static int getDayOfWeek(int year, int mon1, int day) {
        int mon0 = mon1 - 1;
        GregorianCalendar cal = new GregorianCalendar(year, mon0, day);
        return cal.get(7) - 1;
    }

    public static int getDayOfYear(int year, int mon1, int day) {
        int mon0 = mon1 - 1;
        GregorianCalendar cal = new GregorianCalendar(year, mon0, day);
        return cal.get(6);
    }

    public static String[] getHours(boolean hr24) {
        String[] hrs = new String[hr24 ? 24 : 12];
        for (int i = 0; i < hrs.length; ++i) {
            hrs[i] = String.valueOf(i);
        }
        return hrs;
    }

    public static String[] getMinutes() {
        String[] min = new String[60];
        for (int i = 0; i < min.length; ++i) {
            min[i] = String.valueOf(i);
        }
        return min;
    }

    public static String toString(long timeSec) {
        return new Date(timeSec * 1000L).toString();
    }

    public static long getCurrentTimeSec() {
        return DateTime.getCurrentTimeMillis() / 1000L;
    }

    public static long getCurrentTimeMillis() {
        return System.currentTimeMillis();
    }

    public static boolean isRecentSec(long timeSec, long lapseSec) {
        Print.logDebug("timeSec: " + timeSec, new Object[0]);
        Print.logDebug("getCurrentTimeSec: " + DateTime.getCurrentTimeSec(), new Object[0]);
        return timeSec >= DateTime.getCurrentTimeSec() - lapseSec;
    }

    public static boolean isValid(DateTime dt) {
        long tm;
        long l = tm = dt != null ? dt.getTimeSec() : -1L;
        if (tm < MIN_TIMESEC) {
            return false;
        }
        return tm <= MAX_TIMESEC;
    }

    public static DateTime getMinDate() {
        return DateTime.getMinDate(null);
    }

    public static DateTime getMinDate(TimeZone tz) {
        return new DateTime(1L, tz);
    }

    public static DateTime getMaxDate() {
        return DateTime.getMaxDate(null);
    }

    public static DateTime getMaxDate(TimeZone tz) {
        int YYYY = 2050;
        int MM1 = 12;
        int DD = 31;
        return new DateTime(tz, YYYY, MM1, DD);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ParsedDateTime parseDateTime(String dateStr, TimeZone dftTZ, DefaultParsedTime dftTime) throws DateParseException {
        int ss;
        int mm;
        int hh;
        String tmzs;
        int dlen;
        if (dftTime == null) {
            dftTime = DefaultParsedTime.CurrentTime;
        }
        boolean useCurrTime = DefaultParsedTime.CurrentTime.equals((Object)dftTime);
        boolean useDayStart = DefaultParsedTime.DayStart.equals((Object)dftTime);
        boolean useDayEnd = DefaultParsedTime.DayEnd.equals((Object)dftTime);
        boolean useCtxStart = DefaultParsedTime.ContextStart.equals((Object)dftTime);
        boolean useCtxEnd = DefaultParsedTime.ContextEnd.equals((Object)dftTime);
        if (StringTools.isBlank(dateStr = StringTools.trim(dateStr))) {
            throw new DateParseException("'dateStr' argument is null/empty");
        }
        String[] dateGrp = StringTools.parseStringArray(dateStr, ", |");
        if (dateGrp.length == 1 && (dlen = dateStr.length()) >= 20 && dateStr.charAt(10) == 'T') {
            String ds = dateStr.substring(0, 10);
            String ts = dateStr.substring(11, 19);
            String tz = dateStr.substring(19);
            dateGrp = new String[]{ds, ts, tz};
        }
        int grpLen = dateGrp.length;
        if (dateGrp.length < 1 || dateGrp.length > 3) {
            throw new DateParseException("Invalid number of ',' separated groups: " + dateStr);
        }
        if (dateGrp[0].length() == 0) {
            throw new DateParseException("Invalid Date/Time specification[#1]: " + dateStr);
        }
        TimeZone timeZone = dftTZ;
        if (grpLen == 3) {
            tmzs = dateGrp[2];
            if (StringTools.isBlank(tmzs)) {
                --grpLen;
            } else {
                if (Character.isDigit(tmzs.charAt(0))) throw new DateParseException("Invalid TimeZone[#3]: [" + tmzs + "] " + dateStr);
                timeZone = DateTime.getTimeZone(tmzs, null);
                if (timeZone == null) {
                    throw new DateParseException("Invalid TimeZone[#2]: [" + tmzs + "] " + dateStr);
                }
                --grpLen;
            }
        } else if (grpLen == 2) {
            tmzs = dateGrp[1];
            if (StringTools.isBlank(tmzs)) {
                --grpLen;
            } else if (!Character.isDigit(tmzs.charAt(0))) {
                timeZone = DateTime.getTimeZone(tmzs, null);
                if (timeZone == null) {
                    throw new DateParseException("Invalid TimeZone[#4]: [" + tmzs + "] " + dateStr);
                }
                --grpLen;
            }
        }
        DateTime now = new DateTime(timeZone);
        char s = dateGrp[0].charAt(0);
        String[] dateFld = null;
        if (grpLen == 1) {
            if (s == '+' || s == '-') {
                String D = dateGrp[0];
                int DLen = D.length();
                if (!(DLen != 4 && DLen != 3 || Character.isDigit(D.charAt(1)))) {
                    int deltaDays;
                    int prsDOW = DateTime.getDayIndex(D.substring(1), -1);
                    if (prsDOW < 0) {
                        throw new DateParseException("Invalid DOW specified: " + D);
                    }
                    int nowDOW = now.getDayOfWeek();
                    long ofsSec = s == '-' ? -DateTime.DaySeconds((deltaDays = (nowDOW + 7 - prsDOW) % 7) <= 0 ? 7L : (long)deltaDays) : DateTime.DaySeconds((deltaDays = (prsDOW + 7 - nowDOW) % 7) <= 0 ? 7L : (long)deltaDays);
                    DateTime dt = new DateTime(now.getTimeSec() + ofsSec, timeZone);
                    int YYYY = dt.getYear();
                    int MM0 = dt.getMonth0();
                    int DD = dt.getDayOfMonth();
                    int hh2 = now.getHour24();
                    int mm2 = now.getMinute();
                    int ss2 = now.getSecond();
                    if (useCtxStart || useDayStart) {
                        hh2 = 0;
                        mm2 = 1;
                        ss2 = 1;
                    } else if (useCtxEnd || useDayEnd) {
                        hh2 = 23;
                        mm2 = 59;
                        ss2 = 59;
                    }
                    DateTime pdt = new DateTime(timeZone, YYYY, MM0 + 1, DD, hh2, mm2, ss2);
                    return new ParsedDateTime(timeZone, pdt.getTimeSec());
                }
                char lastCh = Character.toLowerCase(D.charAt(DLen - 1));
                switch (lastCh) {
                    case 'd': 
                    case 'h': 
                    case 'm': 
                    case 's': 
                    case 'y': {
                        D = D.substring(0, DLen - 1);
                        break;
                    }
                }
                if (!StringTools.isInt(D, true)) {
                    throw new DateParseException("Non-numeric Delta time: " + dateStr);
                }
                long delta = StringTools.parseLong(D, 0L);
                switch (lastCh) {
                    case 's': {
                        DateTime dt = new DateTime(now.getTimeSec() + delta, timeZone);
                        int YYYY = dt.getYear();
                        int MM0 = dt.getMonth0();
                        int DD = dt.getDayOfMonth();
                        int hh3 = dt.getHour24();
                        int mm3 = dt.getMinute();
                        int ss3 = dt.getSecond();
                        DateTime pdt = new DateTime(timeZone, YYYY, MM0 + 1, DD, hh3, mm3, ss3);
                        return new ParsedDateTime(timeZone, pdt.getTimeSec());
                    }
                    case 'h': {
                        int mm4;
                        DateTime dt = new DateTime(now.getTimeSec() + DateTime.HourSeconds(delta), timeZone);
                        int YYYY = dt.getYear();
                        int MM0 = dt.getMonth0();
                        int DD = dt.getDayOfMonth();
                        int hh4 = dt.getHour24();
                        int n = useDayStart || useCtxStart ? 1 : (mm4 = useDayEnd || useCtxEnd ? 59 : dt.getMinute());
                        int ss4 = useDayStart || useCtxStart ? 1 : (useDayEnd || useCtxEnd ? 59 : dt.getSecond());
                        DateTime pdt = new DateTime(timeZone, YYYY, MM0 + 1, DD, hh4, mm4, ss4);
                        return new ParsedDateTime(timeZone, pdt.getTimeSec());
                    }
                    case 'd': {
                        int mm5;
                        int hh5;
                        DateTime dt = new DateTime(now.getTimeSec() + DateTime.DaySeconds(delta), timeZone);
                        int YYYY = dt.getYear();
                        int MM0 = dt.getMonth0();
                        int DD = dt.getDayOfMonth();
                        int n = useDayStart || useCtxStart ? 0 : (hh5 = useDayEnd || useCtxEnd ? 23 : dt.getHour24());
                        int n2 = useDayStart || useCtxStart ? 1 : (mm5 = useDayEnd || useCtxEnd ? 59 : dt.getMinute());
                        int ss5 = useDayStart || useCtxStart ? 1 : (useDayEnd || useCtxEnd ? 59 : dt.getSecond());
                        DateTime pdt = new DateTime(timeZone, YYYY, MM0 + 1, DD, hh5, mm5, ss5);
                        return new ParsedDateTime(timeZone, pdt.getTimeSec());
                    }
                    case 'm': {
                        int mm6;
                        int hh6;
                        int DD;
                        int YYYY = now.getYear();
                        int MM0 = now.getMonth0() + (int)delta;
                        if (MM0 < 0) {
                            YYYY -= Math.abs(MM0) / 12 + 1;
                            MM0 = (12 - Math.abs(MM0) % 12) % 12;
                        } else if (MM0 >= 12) {
                            YYYY += MM0 / 12;
                            MM0 %= 12;
                        }
                        if (useCtxStart) {
                            DD = 1;
                        } else if (useCtxEnd) {
                            DD = DateTime.getDaysInMonth(timeZone, MM0 + 1, YYYY);
                        } else {
                            int maxDD;
                            DD = now.getDayOfMonth();
                            if (DD > (maxDD = DateTime.getDaysInMonth(timeZone, MM0 + 1, YYYY))) {
                                DD = maxDD;
                            }
                        }
                        int n = useDayStart || useCtxStart ? 0 : (hh6 = useDayEnd || useCtxEnd ? 23 : now.getHour24());
                        int n3 = useDayStart || useCtxStart ? 1 : (mm6 = useDayEnd || useCtxEnd ? 59 : now.getMinute());
                        int ss6 = useDayStart || useCtxStart ? 1 : (useDayEnd || useCtxEnd ? 59 : now.getSecond());
                        DateTime pdt = new DateTime(timeZone, YYYY, MM0 + 1, DD, hh6, mm6, ss6);
                        return new ParsedDateTime(timeZone, pdt.getTimeSec());
                    }
                    case 'y': {
                        int mm7;
                        int hh7;
                        int DD;
                        int MM0;
                        int YYYY = now.getYear() + (int)delta;
                        if (useCtxStart) {
                            MM0 = 0;
                            DD = 1;
                        } else if (useCtxEnd) {
                            MM0 = 11;
                            DD = DateTime.getDaysInMonth(timeZone, MM0 + 1, YYYY);
                        } else {
                            int maxDD;
                            MM0 = now.getMonth0();
                            DD = now.getDayOfMonth();
                            if (DD > (maxDD = DateTime.getDaysInMonth(timeZone, MM0 + 1, YYYY))) {
                                DD = maxDD;
                            }
                        }
                        int n = useDayStart || useCtxStart ? 0 : (hh7 = useDayEnd || useCtxEnd ? 23 : now.getHour24());
                        int n4 = useDayStart || useCtxStart ? 1 : (mm7 = useDayEnd || useCtxEnd ? 59 : now.getMinute());
                        int ss7 = useDayStart || useCtxStart ? 1 : (useDayEnd || useCtxEnd ? 59 : now.getSecond());
                        DateTime pdt = new DateTime(timeZone, YYYY, MM0 + 1, DD, hh7, mm7, ss7);
                        return new ParsedDateTime(timeZone, pdt.getTimeSec());
                    }
                }
                DateTime dt = new DateTime(now.getTimeSec() + delta, timeZone);
                int YYYY = dt.getYear();
                int MM0 = dt.getMonth0();
                int DD = dt.getDayOfMonth();
                int hh8 = dt.getHour24();
                int mm8 = dt.getMinute();
                int ss8 = dt.getSecond();
                DateTime pdt = new DateTime(timeZone, YYYY, MM0 + 1, DD, hh8, mm8, ss8);
                return new ParsedDateTime(timeZone, pdt.getTimeSec());
            }
            String[] d = StringTools.parseStringArray(dateGrp[0], "/:-");
            if (d.length < 1 || d.length > 6) {
                throw new DateParseException("Invalid number of Date/Time fields: " + dateStr);
            }
            if (d.length == 1) {
                int d0len = d[0].length();
                if (d0len <= 13) {
                    if (!StringTools.isLong(d[0], true)) {
                        throw new DateParseException("Non-numeric Epoch time: " + dateStr);
                    }
                    long epoch = StringTools.parseLong(d[0], DateTime.getCurrentTimeSec());
                    return new ParsedDateTime(timeZone, epoch);
                }
                if (d0len != 14 || d[0].charAt(0) != '2' || !StringTools.isNumeric(d[0])) throw new DateParseException("Invalid Epoch time specification: " + dateStr);
                int YYYY = StringTools.parseInt(d[0].substring(0, 4), 0);
                int MM = StringTools.parseInt(d[0].substring(4, 6), 0);
                int DD = StringTools.parseInt(d[0].substring(6, 8), 0);
                int hh9 = StringTools.parseInt(d[0].substring(8, 10), 0);
                int mm9 = StringTools.parseInt(d[0].substring(10, 12), 0);
                int ss9 = StringTools.parseInt(d[0].substring(12, 14), 0);
                long epoch = new DateTime(timeZone, YYYY, MM, DD, hh9, mm9, ss9).getTimeSec();
                return new ParsedDateTime(timeZone, epoch);
            }
            dateFld = d;
        } else {
            int tss;
            if (grpLen != 2) throw new DateParseException("Invalid number of Date/Time/TMZ groups: " + dateStr);
            String[] t = StringTools.parseStringArray(dateGrp[1], "/:-");
            if (t.length < 1 || t.length > 3) {
                throw new DateParseException("Invalid number of Time fields: " + dateStr);
            }
            for (String n : t) {
                if (StringTools.isInt(n, true)) continue;
                throw new DateParseException("Non-numeric Time specification: " + dateStr);
            }
            int thh = StringTools.parseInt(t[0], 0);
            int tmm = t.length > 1 ? StringTools.parseInt(t[1], 1) : -1;
            int n = tss = t.length > 2 ? StringTools.parseInt(t[2], 1) : -1;
            if (s == '+' || s == '-') {
                String D = dateGrp[0];
                int DLen = D.length();
                if (!(DLen != 4 && DLen != 3 || Character.isDigit(D.charAt(1)))) {
                    int mm10;
                    int deltaDays;
                    int prsDOW = DateTime.getDayIndex(D.substring(1), -1);
                    if (prsDOW < 0) {
                        throw new DateParseException("Invalid DOW specified: " + D);
                    }
                    int nowDOW = now.getDayOfWeek();
                    long ofsSec = s == '-' ? -DateTime.DaySeconds((deltaDays = (nowDOW + 7 - prsDOW) % 7) <= 0 ? 7L : (long)deltaDays) : DateTime.DaySeconds((deltaDays = (prsDOW + 7 - nowDOW) % 7) <= 0 ? 7L : (long)deltaDays);
                    DateTime dt = new DateTime(now.getTimeSec() + ofsSec, timeZone);
                    int YYYY = dt.getYear();
                    int MM0 = dt.getMonth0();
                    int DD = dt.getDayOfMonth();
                    int hh10 = thh;
                    int n5 = tmm >= 1 ? tmm : (useCtxStart || useDayStart ? 1 : (mm10 = useCtxEnd || useDayEnd ? 59 : dt.getMinute()));
                    int ss10 = tss >= 1 ? tss : (useCtxStart || useDayStart ? 1 : (useCtxEnd || useDayEnd ? 59 : dt.getSecond()));
                    DateTime pdt = new DateTime(timeZone, YYYY, MM0 + 1, DD, hh10, mm10, ss10);
                    return new ParsedDateTime(timeZone, pdt.getTimeSec());
                }
                char lastCh = Character.toLowerCase(D.charAt(DLen - 1));
                switch (lastCh) {
                    case 'd': 
                    case 'm': 
                    case 'y': {
                        D = D.substring(0, DLen - 1);
                        break;
                    }
                    default: {
                        throw new DateParseException("Missing 'd|m|y' on delta days|months|years: " + dateStr);
                    }
                }
                if (!StringTools.isInt(D, true)) {
                    throw new DateParseException("Non-numeric Delta time: " + dateStr);
                }
                long delta = StringTools.parseLong(D, 0L);
                switch (lastCh) {
                    case 'd': {
                        int mm11;
                        DateTime dt = new DateTime(now.getTimeSec() + DateTime.DaySeconds(delta), timeZone);
                        int YYYY = dt.getYear();
                        int MM0 = dt.getMonth0();
                        int DD = dt.getDayOfMonth();
                        int hh11 = thh;
                        int n6 = tmm >= 1 ? tmm : (useCtxStart || useDayStart ? 1 : (mm11 = useCtxEnd || useDayEnd ? 59 : dt.getMinute()));
                        int ss11 = tss >= 1 ? tss : (useCtxStart || useDayStart ? 1 : (useCtxEnd || useDayEnd ? 59 : dt.getSecond()));
                        DateTime pdt = new DateTime(timeZone, YYYY, MM0 + 1, DD, hh11, mm11, ss11);
                        return new ParsedDateTime(timeZone, pdt.getTimeSec());
                    }
                    case 'm': {
                        int mm12;
                        int DD;
                        int YYYY = now.getYear();
                        int MM0 = now.getMonth0() + (int)delta;
                        if (MM0 < 0) {
                            YYYY -= Math.abs(MM0) / 12 + 1;
                            MM0 = (12 - Math.abs(MM0) % 12) % 12;
                        } else if (MM0 >= 12) {
                            YYYY += MM0 / 12;
                            MM0 %= 12;
                        }
                        if (useCtxStart) {
                            DD = 1;
                        } else if (useCtxEnd) {
                            DD = DateTime.getDaysInMonth(timeZone, MM0 + 1, YYYY);
                        } else {
                            int maxDD;
                            DD = now.getDayOfMonth();
                            if (DD > (maxDD = DateTime.getDaysInMonth(timeZone, MM0 + 1, YYYY))) {
                                DD = maxDD;
                            }
                        }
                        int hh12 = thh;
                        int n7 = tmm >= 1 ? tmm : (useCtxStart || useDayStart ? 1 : (mm12 = useCtxEnd || useDayEnd ? 59 : now.getMinute()));
                        int ss12 = tss >= 1 ? tss : (useCtxStart || useDayStart ? 1 : (useCtxEnd || useDayEnd ? 59 : now.getSecond()));
                        DateTime pdt = new DateTime(timeZone, YYYY, MM0 + 1, DD, hh12, mm12, ss12);
                        return new ParsedDateTime(timeZone, pdt.getTimeSec());
                    }
                    case 'y': {
                        int mm13;
                        int DD;
                        int MM0;
                        int YYYY = now.getYear() + (int)delta;
                        if (useCtxStart) {
                            MM0 = 0;
                            DD = 1;
                        } else if (useCtxEnd) {
                            MM0 = 11;
                            DD = DateTime.getDaysInMonth(timeZone, MM0 + 1, YYYY);
                        } else {
                            int maxDD;
                            MM0 = now.getMonth0();
                            DD = now.getDayOfMonth();
                            if (DD > (maxDD = DateTime.getDaysInMonth(timeZone, MM0 + 1, YYYY))) {
                                DD = maxDD;
                            }
                        }
                        int hh13 = thh;
                        int n8 = tmm >= 1 ? tmm : (useCtxStart || useDayStart ? 1 : (mm13 = useCtxEnd || useDayEnd ? 59 : now.getMinute()));
                        int ss13 = tss >= 1 ? tss : (useCtxStart || useDayStart ? 1 : (useCtxEnd || useDayEnd ? 59 : now.getSecond()));
                        DateTime pdt = new DateTime(timeZone, YYYY, MM0 + 1, DD, hh13, mm13, ss13);
                        return new ParsedDateTime(timeZone, pdt.getTimeSec());
                    }
                }
                throw new DateParseException("Missing 'd|m|y' on delta days|months|years: " + dateStr);
            }
            String[] d = StringTools.parseStringArray(dateGrp[0], "/:-");
            if (d.length != 3) {
                throw new DateParseException("Invalid number of Date fields: " + dateStr);
            }
            for (String n9 : d) {
                if (StringTools.isInt(n9, true)) continue;
                throw new DateParseException("Non-numeric Date specification: " + dateStr);
            }
            dateFld = new String[d.length + t.length];
            System.arraycopy(d, 0, dateFld, 0, d.length);
            System.arraycopy(t, 0, dateFld, d.length, t.length);
        }
        int YY = StringTools.parseInt(dateFld[0], now.getYear());
        int MM = StringTools.parseInt(dateFld[1], now.getMonth1());
        int maxDD = DateTime.getDaysInMonth(timeZone, MM, YY);
        int DD = 0;
        int n = useDayStart || useCtxStart ? 0 : (hh = useDayEnd || useCtxEnd ? 23 : now.getHour24());
        int n10 = useDayStart || useCtxStart ? 1 : (mm = useDayEnd || useCtxEnd ? 59 : now.getMinute());
        int n11 = useDayStart || useCtxStart ? 1 : (ss = useDayEnd || useCtxEnd ? 59 : now.getSecond());
        if (dateFld.length >= 3) {
            DD = StringTools.parseInt(dateFld[2], now.getDayOfMonth());
            if (DD > maxDD) {
                DD = maxDD;
            }
            if (dateFld.length >= 4) {
                hh = StringTools.parseInt(dateFld[3], hh);
            }
            if (dateFld.length >= 5) {
                mm = StringTools.parseInt(dateFld[4], mm);
            }
            if (dateFld.length < 6) return new ParsedDateTime(timeZone, YY, MM, DD, hh, mm, ss);
            ss = StringTools.parseInt(dateFld[5], ss);
            return new ParsedDateTime(timeZone, YY, MM, DD, hh, mm, ss);
        } else {
            int n12 = useDayStart || useCtxStart ? 1 : (DD = useDayEnd || useCtxEnd ? maxDD : now.getDayOfMonth());
            if (DD <= maxDD) return new ParsedDateTime(timeZone, YY, MM, DD, hh, mm, ss);
            DD = maxDD;
        }
        return new ParsedDateTime(timeZone, YY, MM, DD, hh, mm, ss);
    }

    public static DateTime parseArgumentDate(String dateStr, TimeZone dftTZ, DefaultParsedTime dftTime) throws DateParseException {
        return DateTime.parseDateTime(dateStr, dftTZ, dftTime).createDateTime();
    }

    public static DateTime parseArgumentDate(String dateStr, TimeZone dftTZ, boolean isToDate) throws DateParseException {
        DefaultParsedTime dftTime = isToDate ? DefaultParsedTime.DayEnd : DefaultParsedTime.DayStart;
        return DateTime.parseDateTime(dateStr, dftTZ, dftTime).createDateTime();
    }

    public static DateTime parseArgumentDate(String dateStr, TimeZone dftTZ) throws DateParseException {
        DefaultParsedTime dftTime = DefaultParsedTime.DayStart;
        return DateTime.parseDateTime(dateStr, dftTZ, dftTime).createDateTime();
    }

    public static DateTime parseArgumentDate(String dateStr) throws DateParseException {
        DefaultParsedTime dftTime = DefaultParsedTime.DayStart;
        return DateTime.parseDateTime(dateStr, DateTime.getGMTTimeZone(), dftTime).createDateTime();
    }

    public static long getDayNumberFromDate(int year, int month1, int day) {
        long yr = (long)year * 1000L + (long)((month1 - 3) * 1000 / 12);
        return (367L * yr + 625L) / 1000L - 2L * (yr / 1000L) + yr / 4000L - yr / 100000L + yr / 400000L + (long)day - 578042L;
    }

    public static long getDayNumberFromDate(ParsedDateTime pdt) {
        if (pdt == null) {
            return 0L;
        }
        if (pdt.epoch >= 0L) {
            DateTime dt = pdt.createDateTime();
            return DateTime.getDayNumberFromDate(dt.getYear(), dt.getMonth1(), dt.getDayOfMonth());
        }
        return DateTime.getDayNumberFromDate(pdt.year, pdt.month1, pdt.day);
    }

    public static long getDayNumberFromDate(DateTime dt, TimeZone tz) {
        if (dt == null) {
            return 0L;
        }
        return DateTime.getDayNumberFromDate(dt.getYear(tz), dt.getMonth1(tz), dt.getDayOfMonth(tz));
    }

    public static long getDayNumberFromDate(DateTime dt) {
        if (dt == null) {
            return 0L;
        }
        return DateTime.getDayNumberFromDate(dt.getYear(), dt.getMonth1(), dt.getDayOfMonth());
    }

    public static long getCurrentDayNumber(TimeZone tz) {
        DateTime dt = new DateTime(tz);
        return DateTime.getDayNumberFromDate(dt, tz);
    }

    public static ParsedDateTime getDateFromDayNumber(long dayNumber) {
        return DateTime.getDateFromDayNumber(dayNumber, null);
    }

    public static ParsedDateTime getDateFromDayNumber(long dayNumber, TimeZone tmz) {
        long N = dayNumber + 578042L;
        long C = (N * 1000L - 200L) / 36524250L;
        long N1 = N + C - C / 4L;
        long Y1 = (N1 * 1000L - 200L) / 365250L;
        long N2 = N1 - 365250L * Y1 / 1000L;
        long M1 = (N2 * 1000L - 500L) / 30600L;
        int day = (int)((N2 * 1000L - 30600L * M1 + 500L) / 1000L);
        int month1 = (int)(M1 <= 9L ? M1 + 3L : M1 - 9L);
        int year = (int)(M1 <= 9L ? Y1 : Y1 + 1L);
        return new ParsedDateTime(tmz, year, month1, day);
    }

    public DateTime() {
        this.setTimeMillis(DateTime.getCurrentTimeMillis());
    }

    public DateTime(TimeZone tz) {
        this();
        this.setTimeZone(tz);
    }

    public DateTime(Date date) {
        this.setTimeMillis(date != null ? date.getTime() : 0L);
    }

    public DateTime(Date date, TimeZone tz) {
        this.setTimeMillis(date != null ? date.getTime() : 0L);
        this.setTimeZone(tz);
    }

    public DateTime(TimeZone tz, int year, int month1, int day) {
        this(tz, year, month1, day, 12, 0, 0);
    }

    public DateTime(TimeZone tz, int year, int month1, int day, int hour24, int minute, int second) {
        this.setDate(tz, year, month1, day, hour24, minute, second);
    }

    public DateTime(long timeSec) {
        if (timeSec > 9000000000L) {
            this.setTimeMillis(timeSec);
        } else {
            this.setTimeSec(timeSec);
        }
    }

    public DateTime(long timeSec, TimeZone tz) {
        this(timeSec);
        this.setTimeZone(tz);
    }

    public DateTime(String d) throws DateParseException {
        this.setDate(d);
    }

    public DateTime(DateTime dt) {
        this.timeMillis = dt.timeMillis;
        this.timeZone = dt.timeZone;
    }

    public DateTime(DateTime dt, long deltaOffsetSec) {
        this.timeMillis = dt.timeMillis + deltaOffsetSec * 1000L;
        this.timeZone = dt.timeZone;
    }

    public Date getDate() {
        return new Date(this.getTimeMillis());
    }

    public void setDate(TimeZone tz, int year, int month1, int day) {
        int hour24 = this.getHour24(tz);
        int minute = this.getMinute(tz);
        int second = this.getSecond(tz);
        this.setDate(tz, year, month1, day, hour24, minute, second);
    }

    public void setDate(TimeZone tz, int year, int month1, int day, int hour24, int minute, int second) {
        int month0 = month1 - 1;
        if (year < 0) {
            year = 1970;
        }
        if (month0 < 0) {
            month0 = 0;
        }
        if (day < 1) {
            day = 1;
        }
        if (hour24 < 0) {
            hour24 = 0;
            minute = 0;
            second = 0;
        } else if (minute < 0) {
            minute = 0;
            second = 0;
        } else if (second < 0) {
            second = 0;
        }
        this.setTimeZone(tz);
        GregorianCalendar cal = new GregorianCalendar(this._timeZone(tz));
        cal.set(year, month0, day, hour24, minute, second);
        Date date = cal.getTime();
        this.setTimeMillis(date.getTime());
    }

    public void setDate(String d) throws DateParseException {
        this.setDate(d, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setDate(String d, TimeZone dftTMZ) throws DateParseException {
        int d2;
        String[] ds = StringTools.parseStringArray(d, " _");
        String dt = ds.length > 0 ? ds[0] : "";
        String tm = ds.length > 1 ? ds[1] : "";
        String tz = ds.length > 2 ? ds[2] : "";
        TimeZone timeZone = null;
        if (ds.length > 2) {
            if (tz.equals("+0000") || tz.equals("-0000") || tz.equals("+00:00")) {
                timeZone = DateTime.getGMTTimeZone();
            } else {
                if (!DateTime.isValidTimeZone(tz)) throw new DateParseException("Invalid TimeZone[#1]: " + tz);
                timeZone = DateTime.getTimeZone(tz);
            }
        } else if (ds.length > 1 && DateTime.isValidTimeZone(tm)) {
            tz = tm;
            tm = "";
            timeZone = DateTime.getTimeZone(tz);
        } else {
            timeZone = dftTMZ != null ? dftTMZ : this.getTimeZone();
        }
        this.setTimeZone(timeZone);
        GregorianCalendar calendar = new GregorianCalendar(timeZone);
        int yr = -1;
        int mo = -1;
        int dy = -1;
        int d1 = dt.indexOf(47);
        int n = d2 = d1 > 0 ? dt.indexOf(47, d1 + 1) : -1;
        if (d1 <= 0 || d2 <= d1) throw new DateParseException("Invalid date format (Y/M/D): " + dt);
        String YR = dt.substring(0, d1);
        yr = StringTools.parseInt(YR, -1);
        if (yr >= 0 && yr <= 49) {
            yr += 2000;
        } else if (yr >= 50 && yr <= 99) {
            yr += 1900;
        }
        if (yr < 1900 || yr > 2100) {
            throw new DateParseException("Date/Year out of range: " + YR);
        }
        String MO = dt.substring(d1 + 1, d2);
        mo = StringTools.parseInt(MO, -1) - 1;
        if (mo < 0 || mo > 11) {
            throw new DateParseException("Date/Month out of range: " + MO);
        }
        String DY = dt.substring(d2 + 1);
        dy = StringTools.parseInt(DY, -1);
        if (dy < 1 || dy > 31) {
            throw new DateParseException("Date/Day out of range: " + DY);
        }
        if (tm.equals("")) {
            calendar.set(yr, mo, dy);
        } else {
            int t2;
            int hr = -1;
            int mn = -1;
            int sc = -1;
            int t1 = tm.indexOf(58);
            int n2 = t2 = t1 > 0 ? tm.indexOf(58, t1 + 1) : -1;
            if (t1 <= 0) throw new DateParseException("Invalid time format (H:M:S): " + tm);
            String HR = tm.substring(0, t1);
            hr = StringTools.parseInt(HR, -1);
            if (hr < 0 || hr > 23) {
                throw new DateParseException("Time/Hour out of range: " + HR);
            }
            if (t2 > t1) {
                String MN = tm.substring(t1 + 1, t2);
                mn = StringTools.parseInt(MN, -1);
                if (mn < 0 || mn > 59) {
                    throw new DateParseException("Time/Minute out of range: " + MN);
                }
                String SC = tm.substring(t2 + 1);
                sc = StringTools.parseInt(SC, -1);
                if (sc < 0 || sc > 59) {
                    throw new DateParseException("Time/Second out of range: " + SC);
                }
                calendar.set(yr, mo, dy, hr, mn, sc);
            } else {
                String MN = tm.substring(t1 + 1);
                mn = StringTools.parseInt(MN, -1);
                if (mn < 0 || mn > 59) {
                    throw new DateParseException("Time/Minute out of range: " + MN);
                }
                calendar.set(yr, mo, dy, hr, mn);
            }
        }
        this.setTimeMillis(calendar.getTime().getTime());
    }

    private boolean setParsedDate_formatted(String d) {
        try {
            Date date = DateFormat.getDateInstance().parse(d);
            this.setTimeMillis(date.getTime());
            return true;
        }
        catch (ParseException pe) {
            Print.logStackTrace("Unable to parse date: " + d, pe);
            this.setTimeMillis(0L);
            return false;
        }
    }

    private int _get(TimeZone tz, int value) {
        return this.getCalendar(tz).get(value);
    }

    public Calendar getCalendar(TimeZone tz) {
        GregorianCalendar c = new GregorianCalendar(this._timeZone(tz));
        c.setTimeInMillis(this.getTimeMillis());
        return c;
    }

    public Calendar getCalendar() {
        return this.getCalendar(null);
    }

    public int getMonth0(TimeZone tz) {
        return this._get(tz, 2);
    }

    public int getMonth0() {
        return this.getMonth0(null);
    }

    public int getMonth1(TimeZone tz) {
        return this.getMonth0(tz) + 1;
    }

    public int getMonth1() {
        return this.getMonth1(null);
    }

    public int getDayOfMonth(TimeZone tz) {
        return this._get(tz, 5);
    }

    public int getDayOfMonth() {
        return this.getDayOfMonth(null);
    }

    public int getDaysInMonth(TimeZone tz) {
        return DateTime.getDaysInMonth(tz, this.getMonth1(tz), this.getYear(tz));
    }

    public int getDaysInMonth() {
        return this.getDaysInMonth(null);
    }

    public int getDayOfWeek(TimeZone tz) {
        return this._get(tz, 7) - 1;
    }

    public int getDayOfWeek() {
        return this.getDayOfWeek(null);
    }

    public int getYear(TimeZone tz) {
        return this._get(tz, 1);
    }

    public int getYear() {
        return this.getYear(null);
    }

    public boolean isLeapYear(TimeZone tz) {
        GregorianCalendar gc = (GregorianCalendar)this.getCalendar(tz);
        return gc.isLeapYear(gc.get(1));
    }

    public boolean isLeapYear() {
        return this.isLeapYear(null);
    }

    public int getHour24(TimeZone tz) {
        return this._get(tz, 11);
    }

    public int getHour24() {
        return this.getHour24(null);
    }

    public int getHour12(TimeZone tz) {
        return this._get(tz, 10);
    }

    public int getHour12() {
        return this.getHour12(null);
    }

    public boolean isAM(TimeZone tz) {
        return this._get(tz, 9) == 0;
    }

    public boolean isAM() {
        return this.isAM(null);
    }

    public boolean isPM(TimeZone tz) {
        return this._get(tz, 9) == 1;
    }

    public boolean isPM() {
        return this.isPM(null);
    }

    public int getMinute(TimeZone tz) {
        return this._get(tz, 12);
    }

    public int getMinute() {
        return this.getMinute(null);
    }

    public int getSecond(TimeZone tz) {
        return this._get(tz, 13);
    }

    public int getSecond() {
        return this.getSecond(null);
    }

    public int getSecondOfDay(TimeZone tz) {
        int H = this.getHour24(tz);
        int M = this.getMinute(tz);
        int S = this.getSecond(tz);
        return H * 3600 + M * 60 + S;
    }

    public int getSecondOfDay() {
        return this.getSecondOfDay(null);
    }

    public boolean isDaylightSavings(TimeZone tz) {
        return this._timeZone(tz).inDaylightTime(this.getDate());
    }

    public boolean isDaylightSavings() {
        return this.isDaylightSavings(null);
    }

    public long getDayNumber(TimeZone tz) {
        return DateTime.getDayNumberFromDate(this, tz);
    }

    public long getDayNumber() {
        return this.getDayNumber(null);
    }

    public long getTimeSec() {
        return this.getTimeMillis() / 1000L;
    }

    public void setTimeSec(long timeSec) {
        this.timeMillis = timeSec * 1000L;
    }

    public long getTimeMillis() {
        return this.timeMillis;
    }

    public void setTimeMillis(long timeMillis) {
        this.timeMillis = timeMillis;
    }

    public long getDayStart(TimeZone tz) {
        if (tz == null) {
            tz = this._timeZone(tz);
        }
        Calendar c = this.getCalendar(tz);
        GregorianCalendar nc = new GregorianCalendar(tz);
        nc.set(c.get(1), c.get(2), c.get(5), 0, 0, 0);
        return nc.getTime().getTime() / 1000L;
    }

    public long getDayStart() {
        return this.getDayStart(null);
    }

    public long getDayEnd(TimeZone tz) {
        if (tz == null) {
            tz = this._timeZone(tz);
        }
        Calendar c = this.getCalendar(tz);
        GregorianCalendar nc = new GregorianCalendar(tz);
        nc.set(c.get(1), c.get(2), c.get(5), 23, 59, 59);
        return nc.getTime().getTime() / 1000L;
    }

    public long getDayEnd() {
        return this.getDayEnd(null);
    }

    public long getMonthStart(TimeZone tz, int deltaMo) {
        if (tz == null) {
            tz = this._timeZone(tz);
        }
        Calendar c = this.getCalendar(tz);
        int YY = c.get(1);
        int MM = c.get(2);
        if (deltaMo != 0) {
            if ((MM += deltaMo) < 0) {
                YY += (MM - 11) / 12;
                if ((MM %= 12) < 0) {
                    MM += 12;
                }
            } else {
                YY += MM / 12;
                MM %= 12;
            }
        }
        int DD = 1;
        GregorianCalendar nc = new GregorianCalendar(tz);
        nc.set(YY, MM, DD, 0, 0, 0);
        return nc.getTime().getTime() / 1000L;
    }

    public long getMonthStart(TimeZone tz) {
        return this.getMonthStart(tz, 0);
    }

    public long getMonthStart(int deltaMo) {
        return this.getMonthStart(null, deltaMo);
    }

    public long getMonthStart() {
        return this.getMonthStart(null, 0);
    }

    public long getMonthEnd(TimeZone tz, int deltaMo) {
        if (tz == null) {
            tz = this._timeZone(tz);
        }
        Calendar c = this.getCalendar(tz);
        int YY = c.get(1);
        int MM = c.get(2);
        if (deltaMo != 0) {
            if ((MM += deltaMo) < 0) {
                YY += (MM - 11) / 12;
                if ((MM %= 12) < 0) {
                    MM += 12;
                }
            } else {
                YY += MM / 12;
                MM %= 12;
            }
        }
        int DD = DateTime.getDaysInMonth(tz, MM + 1, YY);
        GregorianCalendar nc = new GregorianCalendar(tz);
        nc.set(YY, MM, DD, 23, 59, 59);
        return nc.getTime().getTime() / 1000L;
    }

    public long getMonthEnd(TimeZone tz) {
        return this.getMonthEnd(tz, 0);
    }

    public long getMonthEnd(int deltaMo) {
        return this.getMonthEnd(null, deltaMo);
    }

    public long getMonthEnd() {
        return this.getMonthEnd(null, 0);
    }

    public long getMonthDelta(TimeZone tz, int deltaMo) {
        int maxDays;
        int DD;
        if (tz == null) {
            tz = this._timeZone(tz);
        }
        Calendar c = this.getCalendar(tz);
        int YY = c.get(1);
        int MM = c.get(2);
        if (deltaMo != 0) {
            if ((MM += deltaMo) < 0) {
                YY += (MM - 11) / 12;
                if ((MM %= 12) < 0) {
                    MM += 12;
                }
            } else {
                YY += MM / 12;
                MM %= 12;
            }
        }
        if ((DD = c.get(5)) > (maxDays = DateTime.getDaysInMonth(tz, MM + 1, YY))) {
            DD = maxDays;
        }
        GregorianCalendar nc = new GregorianCalendar(tz);
        if (deltaMo <= 0) {
            nc.set(YY, MM, DD, 0, 0, 0);
        } else {
            nc.set(YY, MM, DD, 23, 59, 59);
        }
        return nc.getTime().getTime() / 1000L;
    }

    public long getDayStartGMT() {
        return this.getTimeSec() / 86400L * 86400L;
    }

    public long getDayEndGMT() {
        return this.getDayStartGMT() + 86400L - 1L;
    }

    public boolean isAfter(DateTime dt) {
        return this.isAfter(dt, false);
    }

    public boolean isAfter(DateTime dt, boolean inclusive) {
        if (dt == null) {
            return true;
        }
        if (inclusive) {
            return this.getTimeMillis() >= dt.getTimeMillis();
        }
        return this.getTimeMillis() > dt.getTimeMillis();
    }

    public boolean isBefore(DateTime dt) {
        return this.isBefore(dt, false);
    }

    public boolean isBefore(DateTime dt, boolean inclusive) {
        if (dt == null) {
            return false;
        }
        if (inclusive) {
            return this.getTimeMillis() <= dt.getTimeMillis();
        }
        return this.getTimeMillis() < dt.getTimeMillis();
    }

    public double getYearsSince(DateTime priorDate) {
        return this.getYearsSince(priorDate, null);
    }

    public double getYearsSince(DateTime priorDate, TimeZone tz) {
        long priorDayNumber = DateTime.getDayNumberFromDate(priorDate, tz);
        return this.getYearsSince(priorDayNumber);
    }

    public double getYearsSince(int year, int month1, int day) {
        long priorDayNumber = DateTime.getDayNumberFromDate(year, month1, day);
        return this.getYearsSince(priorDayNumber, null);
    }

    public double getYearsSince(long priorDayNumber) {
        return this.getYearsSince(priorDayNumber, null);
    }

    public double getYearsSince(long priorDayNumber, TimeZone tz) {
        long thatDayNumber;
        boolean reverse = false;
        long thisDayNumber = DateTime.getDayNumberFromDate(this, tz);
        if (thisDayNumber == (thatDayNumber = priorDayNumber)) {
            return 0.0;
        }
        if (thisDayNumber < thatDayNumber) {
            long x = thisDayNumber;
            thisDayNumber = thatDayNumber;
            thatDayNumber = x;
            reverse = true;
        }
        ParsedDateTime thisPDT = DateTime.getDateFromDayNumber(thisDayNumber, tz);
        ParsedDateTime thatPDT = DateTime.getDateFromDayNumber(thatDayNumber, tz);
        int daysInYear = 365;
        int deltaYear = thisPDT.year - thatPDT.year;
        int thisDOY = DateTime.getDayOfYear(thisPDT.year, thisPDT.month1, thisPDT.day);
        int thatDOY = DateTime.getDayOfYear(thatPDT.year, thatPDT.month1, thatPDT.day);
        boolean thisLeap = DateTime.isLeapYear(thisPDT.year);
        boolean thatLeap = DateTime.isLeapYear(thatPDT.year);
        if (thisLeap && thatLeap) {
            daysInYear = 366;
        } else if (thisLeap && !thatLeap) {
            if (thatDOY > 59) {
                ++thatDOY;
                daysInYear = 366;
            }
        } else if (!thisLeap && thatLeap && thisDOY > 59) {
            ++thisDOY;
            daysInYear = 366;
        }
        double ageYears = thisDOY >= thatDOY ? (double)deltaYear + (double)(thisDOY - thatDOY) / (double)daysInYear : (double)deltaYear - 1.0 + ((double)thisDOY + (double)daysInYear - (double)thatDOY) / (double)daysInYear;
        return reverse ? -ageYears : ageYears;
    }

    public boolean equals(Object obj) {
        if (obj instanceof DateTime) {
            return this.getTimeMillis() == ((DateTime)obj).getTimeMillis();
        }
        return false;
    }

    public int compareTo(Object other) {
        if (other instanceof DateTime) {
            long otherTime = ((DateTime)other).getTimeMillis();
            long thisTime = this.getTimeMillis();
            if (thisTime < otherTime) {
                return -1;
            }
            if (thisTime > otherTime) {
                return 1;
            }
            return 0;
        }
        return -1;
    }

    protected TimeZone _timeZone(TimeZone tz) {
        return tz != null ? tz : this.getTimeZone();
    }

    public TimeZone getTimeZone() {
        return this.timeZone != null ? this.timeZone : DateTime.getDefaultTimeZone();
    }

    public String getTimeZoneID() {
        return this.getTimeZone().getID();
    }

    public String getTimeZoneShortName() {
        boolean dst = this.isDaylightSavings();
        return this.getTimeZone().getDisplayName(dst, 0);
    }

    public void setTimeZone(TimeZone tz) {
        this.timeZone = tz;
    }

    public void setTimeZone(String tz) {
        this.setTimeZone(DateTime.getTimeZone(tz, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] readTimeZones(File tmzFile) {
        if (tmzFile != null && tmzFile.exists()) {
            Vector<String> tzList = new Vector<String>();
            BufferedReader br = null;
            try {
                String[] rline;
                br = new BufferedReader(new FileReader(tmzFile));
                while ((rline = br.readLine()) != null) {
                    String tline = rline.trim();
                    if (tline.equals("") || tline.startsWith("#")) continue;
                    tzList.add(tline);
                }
                rline = tzList.toArray(new String[tzList.size()]);
                return rline;
            }
            catch (IOException ioe) {
                Print.logError("Unable to read file: " + tmzFile + " [" + ioe + "]", new Object[0]);
                String[] stringArray = null;
                return stringArray;
            }
            finally {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException ioe) {}
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, String> _GetTimeZoneDSTMap() {
        if (TimeZoneDSTMap == null) {
            Object object = TimeZoneDSTMap_initLock;
            synchronized (object) {
                if (TimeZoneDSTMap == null) {
                    HashMap<String, String> dstMap = new HashMap<String, String>();
                    for (String tzi : TimeZone.getAvailableIDs()) {
                        TimeZone tz = TimeZone.getTimeZone(tzi);
                        String dst = tz.getDisplayName(true, 0);
                        if (!StringTools.isBlank(dst)) {
                            String dstName = dst.toLowerCase();
                            dstMap.put(dstName, tzi);
                        }
                        dstMap.put(tzi.toLowerCase(), tzi);
                        String sdn = tz.getDisplayName(false, 0);
                        if (StringTools.isBlank(sdn)) continue;
                        dstMap.put(sdn.toLowerCase(), tzi);
                    }
                    TimeZoneDSTMap = dstMap;
                }
            }
        }
        return TimeZoneDSTMap;
    }

    private static TimeZone _lookupTimeZone(String tzid, TimeZone dft) {
        if (StringTools.isBlank(tzid)) {
            return dft;
        }
        if (tzid.equalsIgnoreCase(GMT_TIMEZONE) || tzid.equalsIgnoreCase("UTC") || tzid.equalsIgnoreCase("Zulu")) {
            return TimeZone.getTimeZone(tzid);
        }
        if (tzid.equalsIgnoreCase("Z")) {
            return TimeZone.getTimeZone("Zulu");
        }
        if (tzid.startsWith("+")) {
            if (tzid.equals("+0") || tzid.equals("+0000") || tzid.equals("+00:00")) {
                return TimeZone.getTimeZone(GMT_TIMEZONE);
            }
            tzid = GMT_TIMEZONE + tzid;
        } else if (tzid.startsWith("-")) {
            if (tzid.equals("-0") || tzid.equals("-0000") || tzid.equals("-00:00")) {
                return TimeZone.getTimeZone(GMT_TIMEZONE);
            }
            tzid = GMT_TIMEZONE + tzid;
        }
        TimeZone tmz = TimeZone.getTimeZone(tzid);
        if (tmz.getRawOffset() != 0) {
            return tmz;
        }
        if (!tmz.getID().equals(GMT_TIMEZONE)) {
            return tmz;
        }
        String dstTmzID = DateTime._GetTimeZoneDSTMap().get(tzid.toLowerCase());
        TimeZone dstTmz = dstTmzID != null ? TimeZone.getTimeZone(dstTmzID) : null;
        return dstTmz != null && dstTmz.getRawOffset() != 0 ? dstTmz : dft;
    }

    public static boolean isValidTimeZone(String tzid) {
        if (StringTools.isBlank(tzid)) {
            return false;
        }
        if (tzid.equalsIgnoreCase(GMT_TIMEZONE) || tzid.equalsIgnoreCase("UTC") || tzid.equalsIgnoreCase("Zulu")) {
            return true;
        }
        TimeZone tmz = DateTime._lookupTimeZone(tzid, null);
        return tmz != null;
    }

    public static TimeZone getTimeZone(String tzid, TimeZone dft) {
        if (StringTools.isBlank(tzid)) {
            return dft;
        }
        if (tzid.equalsIgnoreCase(GMT_TIMEZONE) || tzid.equalsIgnoreCase("UTC") || tzid.equalsIgnoreCase("Zulu")) {
            return TimeZone.getTimeZone(tzid);
        }
        return DateTime._lookupTimeZone(tzid, dft);
    }

    public static TimeZone getTimeZone(String tzid) {
        if (StringTools.isBlank(tzid)) {
            return TimeZone.getDefault();
        }
        TimeZone tmz = DateTime._lookupTimeZone(tzid, null);
        return tmz != null ? tmz : TimeZone.getDefault();
    }

    public static TimeZone getDefaultTimeZone() {
        return DateTime.getTimeZone(null);
    }

    public static TimeZone getGMTTimeZone() {
        return TimeZone.getTimeZone(GMT_TIMEZONE);
    }

    public String toString() {
        return this.toString(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString(TimeZone tmz) {
        if (simpleFormatter == null) {
            simpleFormatter = new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy", Locale.US);
        }
        SimpleDateFormat simpleDateFormat = simpleFormatter;
        synchronized (simpleDateFormat) {
            simpleFormatter.setTimeZone(this._timeZone(tmz));
            return simpleFormatter.format(this.getDate());
        }
    }

    public static String format(Date date, TimeZone tz, String dtFmt) {
        StringBuffer sb = new StringBuffer();
        SimpleDateFormat sdf = null;
        try {
            String f = dtFmt != null ? dtFmt : DEFAULT_DATETIME_FORMAT;
            sdf = new SimpleDateFormat(f);
        }
        catch (IllegalArgumentException iae) {
            Print.logException("Invalid date/time format: " + dtFmt, iae);
            sdf = new SimpleDateFormat(DEFAULT_DATETIME_FORMAT);
        }
        sdf.setTimeZone(tz != null ? tz : DateTime.getDefaultTimeZone());
        sdf.format(date, sb, new FieldPosition(0));
        return sb.toString();
    }

    public String format(String dtFmt, TimeZone tz, StringBuffer sb) {
        if (sb == null) {
            sb = new StringBuffer();
        }
        SimpleDateFormat sdf = null;
        try {
            String f = dtFmt != null ? dtFmt : DEFAULT_DATETIME_FORMAT;
            sdf = new SimpleDateFormat(f);
        }
        catch (IllegalArgumentException iae) {
            Print.logException("Invalid date/time format: " + dtFmt, iae);
            sdf = new SimpleDateFormat(DEFAULT_DATETIME_FORMAT);
        }
        sdf.setTimeZone(this._timeZone(tz));
        sdf.format(this.getDate(), sb, new FieldPosition(0));
        return sb.toString();
    }

    public String format(String fmt, TimeZone tz) {
        return this.format(fmt, tz, null);
    }

    public String shortFormat(TimeZone tz) {
        return this.format(DEFAULT_DATETIME_TZ_FORMAT, tz, null);
    }

    public String format(TimeZone tz) {
        return this.format("MMM dd, yyyy HH:mm:ss z", tz, null);
    }

    public String format(String fmt) {
        return this.format(fmt, null, null);
    }

    public String gmtFormat(String fmt) {
        return this.format(fmt, DateTime.getGMTTimeZone(), null);
    }

    public String gmtFormat() {
        return this.gmtFormat("yyyy/MM/dd HH:mm:ss 'GMT'");
    }

    public String gmtFormat(String fmt, StringBuffer sb) {
        return this.format(fmt, DateTime.getGMTTimeZone(), sb);
    }

    public Object clone() {
        return new DateTime(this);
    }

    public static String encodeHourMinuteSecond(long tod, String fmt) {
        StringBuffer sb = new StringBuffer();
        int h = (int)(tod / 3600L);
        int m = (int)(tod / 60L % 60L);
        int s = (int)(tod % 60L);
        if (fmt != null) {
            String[] f = StringTools.parseStringArray(fmt, ':');
            if (f.length > 0) {
                sb.append(StringTools.format(h, f[0]));
            }
            if (f.length > 1) {
                sb.append(':').append(StringTools.format(m, f[1]));
            }
            if (f.length > 2) {
                sb.append(':').append(StringTools.format(s, f[2]));
            }
        } else {
            sb.append(h);
            sb.append(':').append(StringTools.format(m, "00"));
            if (s > 0) {
                sb.append(':').append(StringTools.format(s, "00"));
            }
        }
        return sb.toString();
    }

    public static int parseHourMinuteSecond(String hms) {
        return DateTime.parseHourMinuteSecond(hms, 0);
    }

    public static int parseHourMinuteSecond(String hms, int dft) {
        String[] a = StringTools.parseStringArray(hms, ":");
        if (a.length <= 1) {
            return StringTools.parseInt(hms, dft);
        }
        if (a.length == 2) {
            int h = StringTools.parseInt(a[0], -1);
            int m = StringTools.parseInt(a[1], -1);
            return h >= 0 && m >= 0 ? (h * 60 + m) * 60 : dft;
        }
        int h = StringTools.parseInt(a[0], -1);
        int m = StringTools.parseInt(a[1], -1);
        int s = StringTools.parseInt(a[2], -1);
        return h >= 0 && m >= 0 && s >= 0 ? (h * 60 + m) * 60 + s : dft;
    }

    private static void usage() {
        Print.sysPrintln("Usage:", new Object[0]);
        Print.sysPrintln("  java ... " + DateTime.class.getName() + " {options}", new Object[0]);
        Print.sysPrintln("Options:", new Object[0]);
        Print.sysPrintln("  -now_sec                           Current time in seconds", new Object[0]);
        Print.sysPrintln("  -now_ms                            Current time in milliseconds", new Object[0]);
        Print.sysPrintln("  -compileTime                       Output 'CompileTime.java' source", new Object[0]);
        Print.sysPrintln("  -timezones                         List available TimeZones", new Object[0]);
        Print.sysPrintln("  -time=<epoch> [-plus=#{d|h|m|s}]   Print time", new Object[0]);
        System.exit(1);
    }

    public static void main(String[] argv) {
        String tmz;
        File tmzFile;
        if (argv.length > 0) {
            if (argv[0].equals(ARG_NOW_SEC)) {
                System.out.println(String.valueOf(DateTime.getCurrentTimeSec()));
                System.exit(0);
            } else if (argv[0].equals(ARG_NOW_MS)) {
                System.out.println(String.valueOf(DateTime.getCurrentTimeMillis()));
                System.exit(0);
            } else if (argv[0].startsWith(ARG_COMPILE_TIME)) {
                int p = argv[0].indexOf("=");
                String pkg = "";
                DateTime now = new DateTime();
                StringBuffer sb = new StringBuffer();
                if (p > 0) {
                    sb.append("package " + argv[0].substring(p + 1) + ";\n");
                }
                sb.append("public class CompileTime {\n");
                sb.append("    public static final long   COMPILE_TIMESTAMP = " + now.getTimeSec() + "L;\n");
                sb.append("    public static final String COMPILE_DATETIME  = \"" + now.format(DEFAULT_DATETIME_TZ_FORMAT) + "\";\n");
                sb.append("}\n");
                System.out.println(sb.toString());
                System.exit(0);
            }
        }
        RTConfig.setCommandLineArgs(argv);
        if (RTConfig.hasProperty(ARG_TIMEZONE_NAME)) {
            String tmzName = RTConfig.getString(ARG_TIMEZONE_NAME, "");
            TimeZone tz = TimeZone.getTimeZone(tmzName);
            Print.sysPrintln("Timezone: " + tz, new Object[0]);
            System.exit(0);
        }
        if (RTConfig.getBoolean(ARG_TIMEZONE_LIST, false)) {
            String[] tzid = ListTools.sort(TimeZone.getAvailableIDs(), null);
            for (int i = 0; i < tzid.length; ++i) {
                TimeZone tz = TimeZone.getTimeZone(tzid[i]);
                String id = tz.getID();
                String name = tz.getDisplayName();
                String shortName = tz.getDisplayName(false, 0);
                String shortNameDST = tz.getDisplayName(true, 0);
                String longName = tz.getDisplayName(false, 1);
                Print.sysPrintln(tzid[i] + " ID=" + id + ", SHORT=" + shortName + "/" + shortNameDST + ", LONG=" + longName, new Object[0]);
            }
            System.exit(0);
        }
        if ((tmzFile = RTConfig.getFile(ARG_TIMEZONE_FILE, null)) != null) {
            long nowTime = DateTime.getCurrentTimeSec();
            String[] TMZ_NAME = DateTime.readTimeZones(tmzFile);
            if (!ListTools.isEmpty(TMZ_NAME)) {
                Print.sysPrintln("TimeZone name                 GMT Offset: ID, Short , Long Name", new Object[0]);
                for (int i = 0; i < TMZ_NAME.length; ++i) {
                    String tzname = StringTools.leftJustify(TMZ_NAME[i], 28);
                    TimeZone tz = TimeZone.getTimeZone(TMZ_NAME[i]);
                    boolean isGMT = tz.getRawOffset() == 0;
                    String idName = tz.getID().equals(TMZ_NAME[i]) ? "*" : tz.getID();
                    String shortName = StringTools.leftJustify(tz.getDisplayName(false, 0), 5);
                    String longName = tz.getDisplayName(false, 1);
                    int rawOfsMIN = tz.getOffset(nowTime) / 60000;
                    int rawOfsHH = Math.abs(rawOfsMIN) / 60;
                    int rawOfsMM = Math.abs(rawOfsMIN) % 60;
                    String gmtStr = GMT_TIMEZONE + (rawOfsMIN >= 0 ? "+" : "-") + StringTools.format(rawOfsHH, "00") + ":" + StringTools.format(rawOfsMM, "00");
                    StringBuffer sb = new StringBuffer();
                    sb.append(tzname).append(" ").append(isGMT ? "*" : " ");
                    sb.append("[").append(gmtStr).append("]: ");
                    sb.append(idName).append(" , ").append(shortName).append(" , ").append(longName);
                    Print.sysPrintln(sb.toString(), new Object[0]);
                }
            } else {
                Print.sysPrintln("ERROR: Unable to read file - " + tmzFile, new Object[0]);
            }
            System.exit(0);
        }
        if (!StringTools.isBlank(tmz = RTConfig.getString(ARG_TIMEZONE_TIME, null))) {
            long nowTime = DateTime.getCurrentTimeSec();
            TimeZone tz = TimeZone.getTimeZone(tmz);
            int rawOfsMIN = (tz.getOffset(nowTime) + tz.getDSTSavings()) / 60000;
            int rawOfsHH = Math.abs(rawOfsMIN) / 60;
            int rawOfsMM = Math.abs(rawOfsMIN) % 60;
            String gmtStr = GMT_TIMEZONE + (rawOfsMIN >= 0 ? "+" : "-") + StringTools.format(rawOfsHH, "00") + ":" + StringTools.format(rawOfsMM, "00");
            Print.sysPrintln(tmz + " [" + gmtStr + "]: " + tz, new Object[0]);
            Print.sysPrintln("Time : " + new DateTime(nowTime, tz), new Object[0]);
            Print.sysPrintln("GMT  : " + new DateTime(nowTime, DateTime.getGMTTimeZone()), new Object[0]);
            System.exit(0);
        }
        String tzStr = RTConfig.getString(ARG_TIMEZONE, null);
        TimeZone tz = null;
        tz = StringTools.isBlank(tzStr) ? DateTime.getDefaultTimeZone() : DateTime.getTimeZone(tzStr);
        TimeZone pstTZ = DateTime.getTimeZone("US/Pacific");
        TimeZone gmtTZ = DateTime.getGMTTimeZone();
        if (RTConfig.hasProperty(ARG_TO_YMD)) {
            Print.sysPrintln("", new Object[0]);
            String dateStr = RTConfig.getString(ARG_TO_YMD, null);
            int p = dateStr.indexOf(":");
            if (p <= 0) {
                Print.sysPrintln("Missing 'from' date format (ie. 'mdy:12/23/2012')", new Object[0]);
                System.exit(99);
            }
            String fmt = dateStr.substring(0, p).trim();
            String vvv = dateStr.substring(p + 1).trim();
            DateStringFormat dsf = DateTime.getDateStringFormat(fmt);
            Print.sysPrintln("Converting from " + dsf + " to YMD ==> " + dsf.convertToYMD(vvv), new Object[0]);
            System.exit(0);
        }
        Print.sysPrintln("", new Object[0]);
        DateTime timeDT = new DateTime(tz);
        String argTime = null;
        if (RTConfig.hasProperty(ARG_TIME)) {
            argTime = RTConfig.getString(ARG_TIME, null);
            try {
                timeDT = DateTime.parseArgumentDate(argTime, tz, DefaultParsedTime.CurrentTime);
                Print.sysPrintln("Custom Time: " + argTime, new Object[0]);
            }
            catch (DateParseException dpe) {
                Print.logError("Unable to parse date: " + argTime + " [" + dpe.getMessage() + "]", new Object[0]);
                Print.logWarn("Using current time", new Object[0]);
            }
        } else {
            Print.sysPrintln("Current Time:", new Object[0]);
        }
        String plusStr = RTConfig.getString(ARG_PLUS, null);
        if (!StringTools.isBlank(plusStr) && StringTools.isLong(plusStr, false)) {
            long ofs = StringTools.parseLong(plusStr, 0L);
            if (StringTools.endsWithIgnoreCase(plusStr, "d")) {
                ofs *= DateTime.DaySeconds(1L);
            } else if (StringTools.endsWithIgnoreCase(plusStr, "h")) {
                ofs *= DateTime.HourSeconds(1L);
            } else if (StringTools.endsWithIgnoreCase(plusStr, "m")) {
                ofs *= DateTime.MinuteSeconds(1L);
            } else if (!StringTools.endsWithIgnoreCase(plusStr, "s") && StringTools.endsWithIgnoreCase(plusStr, "ms")) {
                ofs /= 1000L;
            }
            timeDT = new DateTime(timeDT.getTimeSec() + ofs, tz);
            Print.sysPrintln("(Plus " + ofs + " seconds)", new Object[0]);
        }
        String fmt = RTConfig.getString(ARG_FORMAT, null);
        DateTime tmzTimeDt = timeDT;
        long timeSec = timeDT.getTimeSec();
        DateTime gmtTimeDt = new DateTime(timeSec, gmtTZ);
        DateTime pstTimeDt = new DateTime(timeSec, pstTZ);
        Print.sysPrintln("GMT time     : " + gmtTimeDt + " [" + timeSec + ":0x" + StringTools.toHexString(timeSec, 32) + "]", new Object[0]);
        Print.sysPrintln("TZ  time     : " + tmzTimeDt, new Object[0]);
        Print.sysPrintln("PST time     : " + pstTimeDt, new Object[0]);
        if (RTConfig.isDebugMode()) {
            Print.sysPrintln("ISO-8601     : " + gmtTimeDt.format(ISO8601_DATETIME_FORMAT), new Object[0]);
            Print.sysPrintln("PST format 1 : " + pstTimeDt.format("yyyy/MM/dd HH:mm:ss z"), new Object[0]);
            Print.sysPrintln("PST format 2 : " + pstTimeDt.format("yyyy/MM/dd HH:mm:ss zz"), new Object[0]);
            Print.sysPrintln("PST format 3 : " + pstTimeDt.format(DEFAULT_DATETIME_TZ_FORMAT), new Object[0]);
            Print.sysPrintln("PST format 4 : " + pstTimeDt.format("yyyy/MM/dd HH:mm:ss zzzz"), new Object[0]);
            Print.sysPrintln("PST format 5 : " + pstTimeDt.format("yyyy/MM/dd HH:mm:ss zzzzzzzzzzz"), new Object[0]);
            Print.sysPrintln("PST format 6 : " + pstTimeDt.format("yyyy/MM/dd HH:mm:ss Z"), new Object[0]);
        }
        if (!StringTools.isBlank(argTime)) {
            try {
                DateTime tmzStrDt = DateTime.parseArgumentDate(argTime, tz, DefaultParsedTime.DayStart);
                DateTime tmzEndDt = DateTime.parseArgumentDate(argTime, tz, DefaultParsedTime.DayEnd);
                DateTime tmzStrTm = DateTime.parseArgumentDate(argTime, tz, DefaultParsedTime.ContextStart);
                DateTime tmzEndTm = DateTime.parseArgumentDate(argTime, tz, DefaultParsedTime.ContextEnd);
                Print.sysPrintln("Default DayS : " + tmzStrDt + " [" + tmzStrDt.getTimeSec() + "]", new Object[0]);
                Print.sysPrintln("Default DayE : " + tmzEndDt + " [" + tmzEndDt.getTimeSec() + "]", new Object[0]);
                Print.sysPrintln("Default CtxS : " + tmzStrTm + " [" + tmzStrTm.getTimeSec() + "]", new Object[0]);
                Print.sysPrintln("Default CtxE : " + tmzEndTm + " [" + tmzEndTm.getTimeSec() + "]", new Object[0]);
            }
            catch (DateParseException dpe) {
                // empty catch block
            }
        }
        DateTime tmzDayStart = new DateTime(tmzTimeDt.getDayStart(), tmzTimeDt.getTimeZone());
        DateTime tmzDayEnd = new DateTime(tmzTimeDt.getDayEnd(), tmzTimeDt.getTimeZone());
        Print.sysPrintln("TZ DayStart  : " + tmzDayStart + " [" + tmzDayStart.getTimeSec() + "]", new Object[0]);
        Print.sysPrintln("TZ DayEnd    : " + tmzDayEnd + " [" + tmzDayEnd.getTimeSec() + "]", new Object[0]);
        if (!StringTools.isBlank(fmt)) {
            Print.sysPrintln("Formatted : " + tmzTimeDt.format(fmt), new Object[0]);
        }
        long tzDayN = DateTime.getDayNumberFromDate(tmzTimeDt);
        long tzNowDayN = new DateTime(tz).getDayNumber();
        long tzDOW = (tzDayN + 5L) % 7L;
        long deltaDN = tzDayN - tzNowDayN;
        Print.sysPrintln("TZ DayNumber : " + tzDayN + " [DOW=" + tzDOW + "] DeltaDays=" + deltaDN + " DeltaSec=" + DateTime.DaySeconds(deltaDN), new Object[0]);
        Print.sysPrintln("", new Object[0]);
    }

    public static interface TimeZoneProvider {
        public TimeZone getTimeZone();
    }

    public static class ParsedDateTime {
        public TimeZone timeZone = null;
        public long epoch = -1L;
        public int year = -1;
        public int month1 = -1;
        public int day = -1;
        public int hour24 = -1;
        public int minute = -1;
        public int second = -1;

        public ParsedDateTime(TimeZone tz, long epoch) {
            this.timeZone = tz;
            this.epoch = epoch;
        }

        public ParsedDateTime(TimeZone tz, int year, int month1, int day) {
            this.timeZone = tz;
            this.year = year;
            this.month1 = month1;
            this.day = day;
        }

        public ParsedDateTime(TimeZone tz, int year, int month1, int day, int hour, int minute, int second) {
            this(tz, year, month1, day);
            this.hour24 = hour;
            this.minute = minute;
            this.second = second;
        }

        public int getYear() {
            return this.year;
        }

        public int getMonth1() {
            return this.month1;
        }

        public int getDayOfMonth() {
            return this.day;
        }

        public int getHour24() {
            return this.hour24;
        }

        public int getMinute() {
            return this.minute;
        }

        public int getSecond() {
            return this.second;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            if (this.epoch >= 0L) {
                sb.append(this.epoch);
            } else {
                sb.append(StringTools.format(this.year, "%04d")).append("/");
                sb.append(StringTools.format(this.month1, "%02d")).append("/");
                sb.append(StringTools.format(this.day, "%02d"));
                if (this.hour24 >= 0) {
                    sb.append(",");
                    sb.append(StringTools.format(this.hour24, "%02d")).append(":");
                    sb.append(StringTools.format(this.minute, "%02d"));
                    if (this.second >= 0) {
                        sb.append(":");
                        sb.append(StringTools.format(this.second, "%02d"));
                    }
                }
            }
            return sb.toString();
        }

        public DateTime createDateTime(TimeZone tzone) {
            TimeZone tmz;
            TimeZone timeZone = tmz = tzone != null ? tzone : this.timeZone;
            if (this.epoch >= 0L) {
                return new DateTime(this.epoch, tmz);
            }
            return new DateTime(tmz, this.year, this.month1, this.day, this.hour24, this.minute, this.second);
        }

        public DateTime createDateTime() {
            return this.createDateTime(null);
        }

        public long getEpochTime() {
            if (this.epoch >= 0L) {
                return this.epoch;
            }
            return this.createDateTime().getTimeSec();
        }

        public long getDayNumber() {
            return DateTime.getDayNumberFromDate(this);
        }
    }

    public static enum DefaultParsedTime {
        CurrentTime,
        ContextStart,
        ContextEnd,
        DayStart,
        DayEnd;

    }

    public static enum DateStringFormat implements EnumTools.StringLocale,
    EnumTools.IntValue
    {
        YMD(0, "yyyy/mm/dd"),
        MDY(1, "mm/dd/yyyy"),
        DMY(1, "dd/mm/yyyy");

        private int vv = 0;
        private String dd = null;

        private DateStringFormat(int v, String d) {
            this.vv = v;
            this.dd = d;
        }

        @Override
        public int getIntValue() {
            return this.vv;
        }

        public String toString() {
            return this.dd;
        }

        @Override
        public String toString(Locale loc) {
            return this.dd;
        }

        public String convertToYMD(String vvv) {
            if (this.equals(YMD)) {
                return vvv;
            }
            if (vvv == null) {
                return vvv;
            }
            int c = vvv.indexOf(",");
            String d = c >= 0 ? vvv.substring(0, c) : vvv;
            String t = c >= 0 ? vvv.substring(c) : "";
            String[] f = StringTools.split(d, '/');
            if (f.length != 3) {
                return vvv;
            }
            switch (this) {
                case MDY: {
                    return f[2] + "/" + f[0] + "/" + f[1] + t;
                }
                case DMY: {
                    return f[2] + "/" + f[1] + "/" + f[0] + t;
                }
            }
            return vvv;
        }

        public String convertFromYMD(String ymd) {
            String[] f;
            if (this.equals(YMD)) {
                return ymd;
            }
            if (ymd == null) {
                return ymd;
            }
            int c = ymd.indexOf(",");
            if (c < 0) {
                c = ymd.indexOf("T");
            }
            String d = c >= 0 ? ymd.substring(0, c) : ymd;
            String t = c >= 0 ? ymd.substring(c) : "";
            String[] stringArray = f = d.indexOf(47) >= 0 ? StringTools.split(d, '/') : StringTools.split(d, '-');
            if (f.length != 3) {
                return ymd;
            }
            switch (this) {
                case MDY: {
                    return f[1] + "/" + f[2] + "/" + f[0] + t;
                }
                case DMY: {
                    return f[2] + "/" + f[1] + "/" + f[0] + t;
                }
            }
            return ymd;
        }
    }

    public static class DateParseException
    extends Exception {
        public DateParseException(String msg) {
            super(msg);
        }

        public DateParseException(String msg, Throwable cause) {
            super(msg, cause);
        }
    }
}

