/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.util;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;
import org.opengts.util.StringTools;

public class DatagramMessage {
    protected DatagramSocket datagramSocket = null;
    protected DatagramPacket sendPacket = null;
    protected DatagramPacket recvPacket = null;
    private static final int DEFAULT_PACKET_SIZE = 1024;
    private static final String[] ARG_HOST = new String[]{"host", "h"};
    private static final String[] ARG_PORT = new String[]{"port", "p"};
    private static final String[] ARG_BINDADDR = new String[]{"bindAddr"};
    private static final String[] ARG_BINDPORT = new String[]{"bindPort"};
    private static final String[] ARG_SEND = new String[]{"send"};
    private static final String[] ARG_RECEIVE = new String[]{"recv", "receive"};
    private static final String[] ARG_ECHO = new String[]{"echo"};

    protected DatagramMessage() {
    }

    public DatagramMessage(int port) throws IOException, UnknownHostException {
        this.datagramSocket = new DatagramSocket(port);
    }

    public DatagramMessage(String destHost, int destPort) throws IOException, UnknownHostException {
        this(InetAddress.getByName(destHost), destPort);
    }

    public DatagramMessage(InetAddress destHost, int destPort) throws IOException {
        this.datagramSocket = new DatagramSocket();
        this.setRemoteHost(destHost, destPort);
    }

    public DatagramMessage(String destHost, int destPort, int bindPort) throws IOException, UnknownHostException {
        this(InetAddress.getByName(destHost), destPort, bindPort, null);
    }

    public DatagramMessage(String destHost, int destPort, int bindPort, String bindAddr) throws IOException, UnknownHostException {
        this(InetAddress.getByName(destHost), destPort, bindPort, !StringTools.isBlank(bindAddr) ? InetAddress.getByName(bindAddr) : null);
    }

    public DatagramMessage(InetAddress destHost, int destPort, int bindPort) throws IOException {
        this(destHost, destPort, bindPort, null);
    }

    public DatagramMessage(InetAddress destHost, int destPort, int bindPort, InetAddress bindAddr) throws IOException {
        this.datagramSocket = bindPort <= 0 ? new DatagramSocket() : (bindAddr == null ? new DatagramSocket(bindPort) : new DatagramSocket(bindPort, bindAddr));
        this.setRemoteHost(destHost, destPort);
    }

    public void close() throws IOException {
        this.datagramSocket.close();
    }

    public void setRemoteHost(String host, int port) throws IOException {
        this.setRemoteHost(InetAddress.getByName(host), port);
    }

    public void setRemoteHost(InetAddress host, int port) throws IOException {
        if (this.sendPacket != null) {
            this.sendPacket.setAddress(host);
            this.sendPacket.setPort(port);
        } else {
            this.sendPacket = new DatagramPacket(new byte[0], 0, host, port);
        }
    }

    public DatagramPacket getSendPacket() {
        return this.sendPacket;
    }

    public void send(String msg) throws IOException {
        this.send(StringTools.getBytes(msg));
    }

    public void send(byte[] data) throws IOException {
        if (data == null) {
            throw new IOException("Nothing to send");
        }
        this.send(data, data.length);
    }

    public void send(byte[] data, int len) throws IOException {
        this.send(data, len, 1);
    }

    public void send(byte[] data, int len, int count) throws IOException {
        if (this.sendPacket == null) {
            throw new IOException("'setRemoteHost' not specified");
        }
        if (data == null || len <= 0 || count <= 0) {
            throw new IOException("Nothing to send");
        }
        this.sendPacket.setData(data);
        this.sendPacket.setLength(len);
        while (count > 0) {
            this.datagramSocket.send(this.sendPacket);
            --count;
        }
    }

    public byte[] receive(int maxBuffSize) throws IOException {
        byte[] dbuff = new byte[maxBuffSize > 0 ? maxBuffSize : 1024];
        this.recvPacket = new DatagramPacket(dbuff, dbuff.length);
        this.datagramSocket.receive(this.recvPacket);
        byte[] newBuff = new byte[this.recvPacket.getLength()];
        System.arraycopy(this.recvPacket.getData(), 0, newBuff, 0, this.recvPacket.getLength());
        return newBuff;
    }

    public DatagramPacket getReceivePacket() {
        return this.recvPacket;
    }

    private static void usage() {
        Print.logInfo("Usage:", new Object[0]);
        Print.logInfo("  java ... " + DatagramMessage.class.getName() + " {options}", new Object[0]);
        Print.logInfo("'Send' Options:", new Object[0]);
        Print.logInfo("  -bindAddr=<ip>    The local bind address", new Object[0]);
        Print.logInfo("  -bindPort=<port>  The local bind port", new Object[0]);
        Print.logInfo("  -host=<host>      The destination host", new Object[0]);
        Print.logInfo("  -port=<port>      The destination port", new Object[0]);
        Print.logInfo("  -send=<data>      The data to send (prefix with '0x' for hex data)", new Object[0]);
        Print.logInfo("  -recv             Set to 'receive' mode after sending", new Object[0]);
        Print.logInfo("'Receive' Options:", new Object[0]);
        Print.logInfo("  -port=<port>      The port on which to listen for incoming data", new Object[0]);
        Print.logInfo("  -recv             Set to 'receive' mode", new Object[0]);
        Print.logInfo("  -echo             Echo received packet back to sender (implies '-recv')", new Object[0]);
        System.exit(1);
    }

    public static void main(String[] argv) {
        boolean cmdRecv;
        RTConfig.setCommandLineArgs(argv);
        String host = RTConfig.getString(ARG_HOST, null);
        int port = RTConfig.getInt(ARG_PORT, 0);
        boolean cmdEcho = RTConfig.hasProperty(ARG_ECHO);
        boolean bl = cmdRecv = cmdEcho || RTConfig.hasProperty(ARG_RECEIVE);
        if (RTConfig.hasProperty(ARG_SEND)) {
            if (StringTools.isBlank(host)) {
                Print.logError("Target host not specified", new Object[0]);
                DatagramMessage.usage();
            }
            if (port <= 0) {
                Print.logError("Target port not specified", new Object[0]);
                DatagramMessage.usage();
            }
            try {
                int bindPort = RTConfig.getInt(ARG_BINDPORT, -1);
                String bindAddr = RTConfig.getString(ARG_BINDADDR, null);
                DatagramMessage dgm = new DatagramMessage(host, port, bindPort, bindAddr);
                String dataStr = RTConfig.getString(ARG_SEND, "Hello World");
                byte[] send = dataStr.startsWith("0x") ? StringTools.parseHex(dataStr, null) : dataStr.getBytes();
                dgm.send(send);
                Print.logInfo("Datagram sent to %s:%d", host, port);
                if (cmdRecv) {
                    if (bindPort <= 0) {
                        Print.logWarn("'-recv' requires '-bindPort', receive ignored.", new Object[0]);
                    } else {
                        Print.sysPrintln("Waiting for incoming data on port %d ...", bindPort);
                        byte[] recv = dgm.receive(1000);
                        SocketAddress sa = dgm.getReceivePacket().getSocketAddress();
                        if (sa instanceof InetSocketAddress) {
                            int recvPort = dgm.getReceivePacket().getPort();
                            InetAddress hostAddr = ((InetSocketAddress)sa).getAddress();
                            Print.logInfo("Received from '" + hostAddr + ":" + recvPort + "' - 0x" + StringTools.toHexString(recv), new Object[0]);
                        }
                    }
                }
                dgm.close();
                System.exit(0);
            }
            catch (Throwable th) {
                Print.logException("Error", th);
                System.exit(99);
            }
        }
        if (cmdRecv) {
            if (port <= 0) {
                Print.logError("Target port not specified", new Object[0]);
                DatagramMessage.usage();
            }
            if (!StringTools.isBlank(host)) {
                Print.logWarn("Specified 'host' will be ignored", new Object[0]);
            }
            try {
                DatagramMessage dgm = new DatagramMessage(port);
                Print.sysPrintln("Waiting for incoming data on port %d ...", port);
                byte[] recv = dgm.receive(1000);
                SocketAddress sa = dgm.getReceivePacket().getSocketAddress();
                if (sa instanceof InetSocketAddress) {
                    InetAddress hostAddr = ((InetSocketAddress)sa).getAddress();
                    int recvPort = dgm.getReceivePacket().getPort();
                    Print.logInfo("Received from host " + hostAddr + "[" + recvPort + "]: 0x" + StringTools.toHexString(recv), new Object[0]);
                    if (cmdEcho) {
                        try {
                            Thread.sleep(500L);
                        }
                        catch (Throwable th) {
                            // empty catch block
                        }
                        Print.sysPrintln("Echoing packet back to sender ...", new Object[0]);
                        dgm.setRemoteHost(hostAddr, recvPort);
                        dgm.send(recv);
                    }
                }
                dgm.close();
                System.exit(0);
            }
            catch (Throwable th) {
                Print.logException("Error", th);
                System.exit(99);
            }
        }
        DatagramMessage.usage();
    }
}

