/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.util;

import org.opengts.util.ColorTools;
import org.opengts.util.StringTools;

public class CssStyle {
    public static final String TEXT_DECORATION_UNDERLINE = "underline";
    public static final String TEXT_DECORATION_OVERLINE = "overline";
    public static final String TEXT_DECORATION_BLINK = "blink";
    public static final String FONT_WEIGHT_BOLD = "bold";
    public static final String FONT_STYLE_ITALIC = "italic";
    private String foreground = null;
    private String background = null;
    private String fontWeight = null;
    private String fontStyle = null;
    private String textDecoration = null;

    public CssStyle() {
        this.clear();
    }

    public CssStyle(CssStyle other) {
        this();
        if (other != null) {
            this.foreground = other.foreground;
            this.background = other.background;
            this.fontWeight = other.fontWeight;
            this.fontStyle = other.fontStyle;
            this.textDecoration = other.textDecoration;
        }
    }

    public void clear() {
        this.foreground = null;
        this.background = null;
        this.fontWeight = null;
        this.fontStyle = null;
        this.textDecoration = null;
    }

    public CssStyle setForegroundColor(ColorTools.RGB rgb) {
        if (rgb != null) {
            this.setForegroundColor(rgb.toString(true));
        } else {
            this.setForegroundColor((String)null);
        }
        return this;
    }

    public CssStyle setForegroundColor(String color) {
        this.foreground = color;
        return this;
    }

    public boolean hasForegroundColor() {
        return !StringTools.isBlank(this.foreground);
    }

    public String getForegroundColor() {
        return this.hasForegroundColor() ? this.foreground : null;
    }

    public CssStyle setBackgroundColor(String color) {
        this.background = color;
        return this;
    }

    public boolean hasBackgroundColor() {
        return !StringTools.isBlank(this.background);
    }

    public String getBackgroundColor() {
        return this.hasBackgroundColor() ? this.background : null;
    }

    public CssStyle setTextDecoration(String decor) {
        this.textDecoration = decor;
        return this;
    }

    public CssStyle setTextDecorationUnderline() {
        return this.setTextDecoration(TEXT_DECORATION_UNDERLINE);
    }

    public CssStyle setTextDecorationOverline() {
        return this.setTextDecoration(TEXT_DECORATION_OVERLINE);
    }

    public CssStyle setTextDecorationBlink() {
        return this.setTextDecoration(TEXT_DECORATION_BLINK);
    }

    public boolean hasTextDecoration() {
        return !StringTools.isBlank(this.textDecoration);
    }

    public String getTextDecoration() {
        return this.hasTextDecoration() ? this.textDecoration : null;
    }

    public CssStyle setFontWeight(String fw) {
        this.fontWeight = fw;
        return this;
    }

    public CssStyle setFontWeightBold() {
        return this.setFontWeight(FONT_WEIGHT_BOLD);
    }

    public boolean hasFontWeight() {
        return !StringTools.isBlank(this.fontWeight);
    }

    public String getFontWeight() {
        return this.hasFontWeight() ? this.fontWeight : null;
    }

    public CssStyle setFontStyle(String fs) {
        this.fontStyle = fs;
        return this;
    }

    public CssStyle setFontStyleItalic() {
        return this.setFontStyle(FONT_STYLE_ITALIC);
    }

    public boolean hasFontStyle() {
        return !StringTools.isBlank(this.fontStyle);
    }

    public String getFontStyle() {
        return this.hasFontStyle() ? this.fontStyle : null;
    }

    public boolean hasStyle() {
        return this.hasForegroundColor() || this.hasBackgroundColor() || this.hasTextDecoration() || this.hasFontWeight() || this.hasFontStyle();
    }

    public String getStyleString() {
        if (!this.hasStyle()) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        if (this.hasForegroundColor()) {
            sb.append("color:").append(this.getForegroundColor()).append(";");
        }
        if (this.hasBackgroundColor()) {
            sb.append("background-color:").append(this.getBackgroundColor()).append(";");
        }
        if (this.hasTextDecoration()) {
            sb.append("text-decoration:").append(this.getTextDecoration()).append(";");
        }
        if (this.hasFontStyle()) {
            sb.append("font-style:").append(this.getFontStyle()).append(";");
        }
        if (this.hasFontWeight()) {
            sb.append("font-weight:").append(this.getFontWeight()).append(";");
        }
        return sb.toString();
    }

    public String toString() {
        return this.getStyleString();
    }

    protected String _wrapText_TAG(String TAG, String text) {
        StringBuffer sb = new StringBuffer();
        sb.append("<").append(TAG).append(" style=\"").append(this.getStyleString()).append("\">");
        sb.append(StringTools.htmlFilterText(StringTools.trim(text)));
        sb.append("</").append(TAG).append(">");
        return sb.toString();
    }

    public String wrapText_span(String text) {
        return this._wrapText_TAG("span", text);
    }

    public String wrapText_div(String text) {
        return this._wrapText_TAG("div", text);
    }
}

