/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.util;

import java.io.File;
import java.io.IOException;
import java.util.Set;
import java.util.TimeZone;
import org.opengts.util.DateTime;
import org.opengts.util.FileTools;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;
import org.opengts.util.RTProperties;
import org.opengts.util.StringTools;

public class CompiletimeVars {
    private static final String TEMPLATE_DEFAULT = "@default";
    private static final String STR_DELIM = "%{";
    private static final String END_DELIM = "}";
    private static final String DFT_DELIM = "=";
    private static final String JAVA_PACKAGE = "package";
    private static final String JAVA_PACKAGE_ = "package ";
    private static final String[] ARG_HELP = new String[]{"help", "h"};
    private static final String[] ARG_EXTRA = new String[]{"extra", "args"};
    private static final String[] ARG_OPTIONAL = new String[]{"template?", "t?"};
    private static final String[] ARG_TEMPLATE = new String[]{"template", "t"};
    private static final String[] ARG_PACKAGE = new String[]{"package", "p"};
    private static final String[] ARG_OUTPUT = new String[]{"output", "o"};
    private static final String[] ARG_OVERWRITE = new String[]{"overwrite", "w"};

    private static String packageLine(String pkgName) {
        if (StringTools.isBlank(pkgName)) {
            return "// no package";
        }
        if (pkgName.startsWith(JAVA_PACKAGE_)) {
            return pkgName + ";";
        }
        return JAVA_PACKAGE_ + pkgName + ";";
    }

    private static String standardTemplate(String tn, String pkg) {
        if (StringTools.isBlank(tn) || tn.equals("@") || tn.equalsIgnoreCase(TEMPLATE_DEFAULT)) {
            StringBuffer sb = new StringBuffer();
            sb.append(CompiletimeVars.packageLine(pkg)).append("\n");
            sb.append("public class CompileTime\n");
            sb.append("{\n");
            sb.append("    // %{datetime=0000/00/00 00:00:00 GMT}\n");
            sb.append("    public static final long   COMPILE_TIMESTAMP    = %{timestamp=0}L;\n");
            sb.append("    public static final String COMPILE_DATETIME     = \"%{date=0000/00/00} %{time=00:00:00} %{timezone=GMT}\";\n");
            sb.append("    public static final String SERVICE_ACCOUNT_ID   = \"%{ServiceAccount.ID=}\";\n");
            sb.append("    public static final String SERVICE_ACCOUNT_NAME = \"%{ServiceAccount.Name=}\";\n");
            sb.append("    public static final String SERVICE_ACCOUNT_KEY  = \"%{ServiceAccount.Key=}\";\n");
            sb.append("}\n");
            return sb.toString();
        }
        Print.errPrintln("Standard Template name not found: " + tn, new Object[0]);
        return null;
    }

    private static String readTemplate(File tf, String pkg) {
        byte[] templData = FileTools.readFile(tf);
        if (templData == null) {
            Print.errPrintln("Unable to read Input/Template file: " + tf, new Object[0]);
            return null;
        }
        if (templData.length == 0) {
            Print.errPrintln("Input/Template file is empty: " + tf, new Object[0]);
            return null;
        }
        String templateText = StringTools.toStringValue(templData);
        if (!StringTools.isBlank(pkg) && !StringTools.isBlank(templateText)) {
            String[] lines = StringTools.split(templateText, '\n', false);
            for (int i = 0; i < lines.length; ++i) {
                if (!lines[i].trim().startsWith(JAVA_PACKAGE_)) continue;
                lines[i] = CompiletimeVars.packageLine(pkg);
                return StringTools.join(lines, '\n') + "\n";
            }
            StringBuffer sb = new StringBuffer();
            sb.append(CompiletimeVars.packageLine(pkg)).append("\n");
            sb.append(templateText);
            return sb.toString();
        }
        return templateText;
    }

    private static String getTemplate(String templateName, boolean optional, String pkgName) {
        if (templateName.startsWith("@")) {
            String template = CompiletimeVars.standardTemplate(templateName, pkgName);
            if (StringTools.isBlank(template) && optional) {
                template = CompiletimeVars.standardTemplate(null, pkgName);
            }
            return template;
        }
        File templateFile = new File(templateName);
        if (!templateFile.isFile()) {
            if (RTConfig.hasProperty(ARG_OPTIONAL)) {
                return CompiletimeVars.standardTemplate(null, pkgName);
            }
            Print.errPrintln("Input/Template file does not exist: " + templateFile, new Object[0]);
            return null;
        }
        return CompiletimeVars.readTemplate(templateFile, pkgName);
    }

    private static void _usage() {
        Print.sysPrintln("Usage:", new Object[0]);
        Print.sysPrintln("  java ... " + CompiletimeVars.class.getName() + " {options}", new Object[0]);
        Print.sysPrintln("Options:", new Object[0]);
        Print.sysPrintln("  -template=@default      Create default 'CompileTime' template", new Object[0]);
        Print.sysPrintln("  -template=<file>        Input Java 'template' file (must exist)", new Object[0]);
        Print.sysPrintln("  -template?=<file>       Optional input Java 'template' file (may exist)", new Object[0]);
        Print.sysPrintln("  -package=<packageName>  Optional package name", new Object[0]);
        Print.sysPrintln("  -output=<file>          Output Java file", new Object[0]);
        Print.sysPrintln("  -overwrite=true         Overwrite output file, if it exists", new Object[0]);
        System.exit(1);
    }

    public static void main(String[] argv) {
        String templateText;
        String ARG_EXPIRE;
        RTProperties expireRTP;
        String extraArgs;
        RTConfig.setCommandLineArgs(argv);
        if (RTConfig.hasProperty(ARG_HELP)) {
            CompiletimeVars._usage();
        }
        if (!StringTools.isBlank(extraArgs = RTConfig.getString(ARG_EXTRA, ""))) {
            RTProperties cfgProps = RTConfig.getConfigFileProperties();
            if (extraArgs.indexOf(",") > 0) {
                cfgProps.setProperties(extraArgs, ',');
            } else {
                cfgProps.setProperties(extraArgs);
            }
        }
        String templateName = StringTools.trim(RTConfig.getString(ARG_OPTIONAL, RTConfig.getString(ARG_TEMPLATE, "")));
        String packageName = StringTools.trim(RTConfig.getString(ARG_PACKAGE, null));
        File outputFile = RTConfig.getFile(ARG_OUTPUT, null);
        boolean overwrite = RTConfig.getBoolean(ARG_OVERWRITE, false);
        String tzStr = RTConfig.getString("timezone", null);
        TimeZone tz = !StringTools.isBlank(tzStr) ? DateTime.getTimeZone(tzStr) : DateTime.getDefaultTimeZone();
        DateTime now = new DateTime(tz);
        if (!RTConfig.hasProperty("timetamp")) {
            RTConfig.setLong("timestamp", now.getTimeSec());
        }
        if (!RTConfig.hasProperty("datetime")) {
            RTConfig.setString("datetime", now.format("yyyy/MM/dd HH:mm:ss z"));
        }
        if (!RTConfig.hasProperty("date")) {
            RTConfig.setString("date", now.format("yyyy/MM/dd"));
        }
        if (!RTConfig.hasProperty("time")) {
            RTConfig.setString("time", now.format("HH:mm:ss"));
        }
        if (!RTConfig.hasProperty("timezone")) {
            RTConfig.setString("timezone", now.format("z"));
        }
        if ((expireRTP = RTConfig.getPropertiesForKey(ARG_EXPIRE = "expire", false)) != null) {
            Print.errPrintln("'expire' cannot be defined.", new Object[0]);
            System.exit(1);
        }
        String ARG_daysUntil_ = "daysUntil";
        Set<String> daysUntil_keys = RTConfig.getPropertyKeys(ARG_daysUntil_, false);
        for (String daysUntil_key : daysUntil_keys) {
            String daysUntil_key_date = daysUntil_key + ".date";
            RTProperties daysUntilRTP = RTConfig.getPropertiesForKey(daysUntil_key, false);
            if (daysUntilRTP == null) continue;
            String daysUntil = daysUntilRTP.getString(daysUntil_key, "");
            if (StringTools.isBlank(daysUntil)) {
                daysUntilRTP.removeProperty(daysUntil_key);
                daysUntilRTP.removeProperty(daysUntil_key_date);
                continue;
            }
            if (daysUntil.indexOf("/") >= 0 || daysUntil.indexOf(":") >= 0) {
                if (daysUntil.startsWith("'") || daysUntil.startsWith("\"")) {
                    daysUntil = daysUntil.substring(1);
                }
                if (daysUntil.endsWith("'") || daysUntil.endsWith("\"")) {
                    daysUntil = daysUntil.substring(0, daysUntil.length() - 1);
                }
                try {
                    DateTime nowDT = new DateTime(DateTime.getGMTTimeZone());
                    DateTime futDT = DateTime.parseArgumentDate(daysUntil, null, true);
                    long nowDay = DateTime.getDayNumberFromDate(nowDT);
                    long futDay = DateTime.getDayNumberFromDate(futDT);
                    long deltaD = futDay - nowDay;
                    if (deltaD == 0L) {
                        deltaD = 1L;
                    } else if (deltaD >= 0L) {
                        ++deltaD;
                    }
                    daysUntilRTP.setString(daysUntil_key, String.valueOf(deltaD));
                    daysUntilRTP.setString(daysUntil_key_date, futDT.format("yyyy/MM/dd"));
                }
                catch (DateTime.DateParseException dpe) {
                    Print.logException("Unable to parse Date: " + daysUntil, dpe);
                    System.exit(1);
                }
                Print.sysPrintln(daysUntil_key + " ==> " + daysUntilRTP.getString(daysUntil_key, "?"), new Object[0]);
                Print.sysPrintln(daysUntil_key_date + " ==> " + daysUntilRTP.getString(daysUntil_key_date, "?"), new Object[0]);
                continue;
            }
            long futSec = DateTime.getCurrentTimeSec() + DateTime.DaySeconds(StringTools.parseLong(daysUntil, 0L));
            daysUntilRTP.setString(daysUntil_key_date, new DateTime(futSec).format("yyyy/MM/dd"));
            Print.sysPrintln(daysUntil_key + " ==> " + daysUntilRTP.getString(daysUntil_key, "?"), new Object[0]);
            Print.sysPrintln(daysUntil_key_date + " ==> " + daysUntilRTP.getString(daysUntil_key_date, "?"), new Object[0]);
        }
        String ARG_secondsUntil_ = "secondsUntil";
        Set<String> secUntil_keys = RTConfig.getPropertyKeys(ARG_secondsUntil_, false);
        for (String secUntil_key : secUntil_keys) {
            String secUntil_key_date = secUntil_key + ".date";
            RTProperties secUntilRTP = RTConfig.getPropertiesForKey(secUntil_key, false);
            if (secUntilRTP == null) continue;
            String secUntil = secUntilRTP.getString(secUntil_key, "");
            if (StringTools.isBlank(secUntil)) {
                secUntilRTP.removeProperty(secUntil_key);
                secUntilRTP.removeProperty(secUntil_key_date);
                continue;
            }
            if (secUntil.indexOf("/") >= 0 || secUntil.indexOf(":") >= 0) {
                if (secUntil.startsWith("'") || secUntil.startsWith("\"")) {
                    secUntil = secUntil.substring(1);
                }
                if (secUntil.endsWith("'") || secUntil.endsWith("\"")) {
                    secUntil = secUntil.substring(0, secUntil.length() - 1);
                }
                try {
                    long nowSec = DateTime.getCurrentTimeSec();
                    DateTime futDT = DateTime.parseArgumentDate(secUntil, null, true);
                    long futSec = futDT.getTimeSec();
                    long deltaS = futSec - nowSec;
                    if (deltaS == 0L) {
                        deltaS = 1L;
                    } else if (deltaS >= 0L) {
                        ++deltaS;
                    }
                    secUntilRTP.setString(secUntil_key, String.valueOf(deltaS));
                    secUntilRTP.setString(secUntil_key_date, futDT.toString());
                }
                catch (DateTime.DateParseException dpe) {
                    Print.logException("Unable to parse Date: " + secUntil, dpe);
                    System.exit(1);
                }
                Print.sysPrintln(secUntil_key + " ==> " + secUntilRTP.getString(secUntil_key, "?"), new Object[0]);
                Print.sysPrintln(secUntil_key_date + " ==> " + secUntilRTP.getString(secUntil_key_date, "?"), new Object[0]);
                continue;
            }
            long futSec = DateTime.getCurrentTimeSec() + StringTools.parseLong(secUntil, 0L);
            secUntilRTP.setString(secUntil_key_date, new DateTime(futSec).toString());
            Print.sysPrintln(secUntil_key + " ==> " + secUntilRTP.getString(secUntil_key, "?"), new Object[0]);
            Print.sysPrintln(secUntil_key_date + " ==> " + secUntilRTP.getString(secUntil_key_date, "?"), new Object[0]);
        }
        String ARG_limit_ = "limit";
        Set<String> limit_keys = RTConfig.getPropertyKeys(ARG_limit_, false);
        for (String limit_key : limit_keys) {
            RTProperties limitRTP = RTConfig.getPropertiesForKey(limit_key, false);
            if (limitRTP == null) continue;
            String limit = limitRTP.getString(limit_key, "");
            if (StringTools.isBlank(limit)) {
                limitRTP.removeProperty(limit_key);
                continue;
            }
            Print.sysPrintln(limit_key + " ==> " + limit, new Object[0]);
        }
        if (outputFile != null && outputFile.exists()) {
            if (!overwrite) {
                Print.errPrintln("Output file already exists (overwrite not specified).", new Object[0]);
                System.exit(0);
            } else if (!outputFile.isFile()) {
                Print.errPrintln("Overwrite specified, but specified existing output is not a file.", new Object[0]);
                System.exit(1);
            }
        }
        if (packageName.equals(JAVA_PACKAGE)) {
            Print.errPrintln("Warning: 'package' argument cannot equal \"package\" (setting to empty string).", new Object[0]);
            packageName = "";
        }
        if (StringTools.isBlank(templateText = CompiletimeVars.getTemplate(templateName, RTConfig.hasProperty(ARG_OPTIONAL), packageName))) {
            CompiletimeVars._usage();
        }
        String outputText = RTConfig.insertKeyValues(templateText, STR_DELIM, END_DELIM, DFT_DELIM);
        if (outputFile != null) {
            try {
                boolean didWrite = FileTools.writeFile(outputText.getBytes(), outputFile);
                if (!didWrite) {
                    Print.errPrintln("Unable to write output file.", new Object[0]);
                    System.exit(1);
                }
            }
            catch (IOException ioe) {
                Print.errPrintln("Unable to write output file.", new Object[0]);
                System.exit(1);
            }
        } else {
            Print.sysPrintln(outputText, new Object[0]);
        }
        System.exit(0);
    }
}

