/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.util;

import java.awt.Color;
import java.awt.color.ColorSpace;
import org.opengts.util.StringTools;

public class ColorTools {
    public static RGB BLACK = new RGB(0);
    public static RGB BROWN = new RGB(0xA52A2A);
    public static RGB RED = new RGB(0xDD0000);
    public static RGB ORANGE = new RGB(16753920);
    public static RGB YELLOW = new RGB(16766720);
    public static RGB DARK_YELLOW = new RGB(11179776);
    public static RGB GREEN = new RGB(52224);
    public static RGB BLUE = new RGB(238);
    public static RGB PURPLE = new RGB(9699539);
    public static RGB GRAY = new RGB(0x808080);
    public static RGB DARK_GRAY = new RGB(0x505050);
    public static RGB LIGHT_GRAY = new RGB(0xC0C0C0);
    public static RGB WHITE = new RGB(0xFFFFFF);
    public static RGB CYAN = new RGB(65535);
    public static RGB PINK = new RGB(16716947);
    public static RGB MAGENTA = new RGB(0x8B008B);
    public static RGB COLOR_BLACK = BLACK;
    public static RGB COLOR_BROWN = BROWN;
    public static RGB COLOR_RED = RED;
    public static RGB COLOR_ORANGE = ORANGE;
    public static RGB COLOR_YELLOW = YELLOW;
    public static RGB COLOR_GREEN = GREEN;
    public static RGB COLOR_BLUE = BLUE;
    public static RGB COLOR_PURPLE = PURPLE;
    public static RGB COLOR_GRAY = GRAY;
    public static RGB COLOR_WHITE = WHITE;

    public static RGB parseColor(String color, RGB dft) {
        if (StringTools.isBlank(color)) {
            return dft;
        }
        if (color.equalsIgnoreCase("black")) {
            return BLACK;
        }
        if (color.equalsIgnoreCase("blue")) {
            return BLUE;
        }
        if (color.equalsIgnoreCase("cyan")) {
            return CYAN;
        }
        if (color.equalsIgnoreCase("darkGray")) {
            return DARK_GRAY;
        }
        if (color.equalsIgnoreCase("gray")) {
            return GRAY;
        }
        if (color.equalsIgnoreCase("green")) {
            return GREEN;
        }
        if (color.equalsIgnoreCase("lightGray")) {
            return LIGHT_GRAY;
        }
        if (color.equalsIgnoreCase("magenta")) {
            return MAGENTA;
        }
        if (color.equalsIgnoreCase("orange")) {
            return ORANGE;
        }
        if (color.equalsIgnoreCase("pink")) {
            return PINK;
        }
        if (color.equalsIgnoreCase("red")) {
            return RED;
        }
        if (color.equalsIgnoreCase("white")) {
            return WHITE;
        }
        if (color.equalsIgnoreCase("yellow")) {
            return YELLOW;
        }
        String c = color.startsWith("#") ? color.substring(1) : color;
        byte[] rgb = StringTools.parseHex(c, null);
        if (rgb != null) {
            int R = rgb.length > 0 ? rgb[0] & 0xFF : 0;
            int G = rgb.length > 1 ? rgb[1] & 0xFF : 0;
            int B = rgb.length > 2 ? rgb[2] & 0xFF : 0;
            return new RGB(R, G, B);
        }
        return dft;
    }

    public static boolean isColor(String color) {
        return ColorTools.parseColor(color, (Color)null) != null;
    }

    public static Color lighter(Color c, float percent) {
        float p = ColorTools._bound(percent);
        float[] comp = c.getColorComponents(null);
        for (int i = 0; i < comp.length; ++i) {
            comp[i] = ColorTools._bound(comp[i] + (1.0f - comp[i]) * p);
        }
        ColorSpace cs = c.getColorSpace();
        return new Color(cs, comp, ColorTools._toFloat(c.getAlpha()));
    }

    public static Color darker(Color c, float percent) {
        float p = ColorTools._bound(percent);
        float[] comp = c.getColorComponents(null);
        for (int i = 0; i < comp.length; ++i) {
            comp[i] = ColorTools._bound(comp[i] - comp[i] * p);
        }
        return new Color(c.getColorSpace(), comp, ColorTools._toFloat(c.getAlpha()));
    }

    public static Color mix(Color color1, Color color2) {
        if (color1 == null) {
            return color2;
        }
        if (color2 == null) {
            return color1;
        }
        float[] rgb1 = color1.getRGBColorComponents(null);
        float[] rgb2 = color2.getRGBColorComponents(null);
        float[] rgb = new float[3];
        for (int i = 0; i < 3; ++i) {
            rgb[i] = (rgb1[i] + rgb2[i]) / 2.0f;
        }
        return new Color(rgb[0], rgb[1], rgb[2]);
    }

    public static Color mix(Color color1, Color color2, float weight) {
        if (color1 == null) {
            return color2;
        }
        if (color2 == null) {
            return color1;
        }
        float[] rgb1 = color1.getRGBColorComponents(null);
        float[] rgb2 = color2.getRGBColorComponents(null);
        float[] rgb = new float[3];
        for (int i = 0; i < 3; ++i) {
            rgb[i] = ColorTools._bound(rgb1[i] + (rgb2[i] - rgb1[i]) * weight);
        }
        return new Color(rgb[0], rgb[1], rgb[2]);
    }

    public static Color mix(Color color1, Color color2, double weight) {
        return ColorTools.mix(color1, color2, (float)weight);
    }

    public static Color parseColor(String color, Color dft) {
        if (StringTools.isBlank(color)) {
            return dft;
        }
        if (color.equalsIgnoreCase("black")) {
            return Color.black;
        }
        if (color.equalsIgnoreCase("blue")) {
            return Color.blue;
        }
        if (color.equalsIgnoreCase("cyan")) {
            return Color.cyan;
        }
        if (color.equalsIgnoreCase("darkGray")) {
            return Color.darkGray;
        }
        if (color.equalsIgnoreCase("gray")) {
            return Color.gray;
        }
        if (color.equalsIgnoreCase("green")) {
            return Color.green;
        }
        if (color.equalsIgnoreCase("lightGray")) {
            return Color.lightGray;
        }
        if (color.equalsIgnoreCase("magenta")) {
            return Color.magenta;
        }
        if (color.equalsIgnoreCase("orange")) {
            return Color.orange;
        }
        if (color.equalsIgnoreCase("pink")) {
            return Color.pink;
        }
        if (color.equalsIgnoreCase("red")) {
            return Color.red;
        }
        if (color.equalsIgnoreCase("white")) {
            return Color.white;
        }
        if (color.equalsIgnoreCase("yellow")) {
            return Color.yellow;
        }
        String c = color.startsWith("#") ? color.substring(1) : color;
        byte[] rgb = StringTools.parseHex(c, null);
        if (rgb != null) {
            int r = rgb.length > 0 ? rgb[0] & 0xFF : 0;
            int g = rgb.length > 1 ? rgb[1] & 0xFF : 0;
            int b = rgb.length > 2 ? rgb[2] & 0xFF : 0;
            int a = rgb.length > 3 ? rgb[3] & 0xFF : 0;
            return rgb.length > 3 ? new Color(r, g, b, a) : new Color(r, g, b);
        }
        return dft;
    }

    public static String toHexString(Color color) {
        return ColorTools.toHexString(color, true);
    }

    public static String toHexString(Color color, boolean inclHash) {
        if (color != null) {
            return ColorTools.toHexString(color.getRGB(), inclHash);
        }
        return "";
    }

    public static String toHexString(int color, boolean inclHash) {
        String v = Integer.toHexString(color | 0xFF000000).substring(2);
        return inclHash ? "#" + v : v;
    }

    private static float _toFloat(int colorVal) {
        return ColorTools._bound((float)colorVal / 255.0f);
    }

    private static int _bound(int colorVal) {
        if (colorVal < 0) {
            colorVal = 0;
        }
        if (colorVal > 255) {
            colorVal = 255;
        }
        return colorVal;
    }

    private static double _bound(double colorVal) {
        if (colorVal < 0.0) {
            colorVal = 0.0;
        }
        if (colorVal > 1.0) {
            colorVal = 1.0;
        }
        return colorVal;
    }

    private static float _bound(float colorVal) {
        if (colorVal < 0.0f) {
            colorVal = 0.0f;
        }
        if (colorVal > 1.0f) {
            colorVal = 1.0f;
        }
        return colorVal;
    }

    public static class RGB {
        private int R = 0;
        private int G = 0;
        private int B = 0;
        private int A = -1;

        public RGB(int R, int G, int B) {
            this.R = R & 0xFF;
            this.G = G & 0xFF;
            this.B = B & 0xFF;
        }

        public RGB(int[] RGB2) {
            if (RGB2 != null && RGB2.length >= 3) {
                this.R = RGB2[0];
                this.G = RGB2[1];
                this.B = RGB2[2];
            }
        }

        public RGB(int RGB2) {
            this.R = RGB2 >> 16 & 0xFF;
            this.G = RGB2 >> 8 & 0xFF;
            this.B = RGB2 >> 0 & 0xFF;
        }

        public RGB(float R, float G, float B) {
            this.R = (int)Math.round((double)R * 256.0);
            this.G = (int)Math.round((double)G * 256.0);
            this.B = (int)Math.round((double)B * 256.0);
        }

        public RGB(float[] RGB2) {
            if (RGB2 != null && RGB2.length >= 3) {
                this.R = (int)Math.round((double)RGB2[0] * 256.0);
                this.G = (int)Math.round((double)RGB2[1] * 256.0);
                this.B = (int)Math.round((double)RGB2[2] * 256.0);
            }
        }

        public RGB(double R, double G, double B) {
            this.R = (int)Math.round(R * 256.0);
            this.G = (int)Math.round(G * 256.0);
            this.B = (int)Math.round(B * 256.0);
        }

        public RGB(double[] RGB2) {
            if (RGB2 != null && RGB2.length >= 3) {
                this.R = (int)Math.round(RGB2[0] * 256.0);
                this.G = (int)Math.round(RGB2[1] * 256.0);
                this.B = (int)Math.round(RGB2[2] * 256.0);
            }
        }

        public int getRGB() {
            return this.R << 16 | this.G << 8 | this.B << 0;
        }

        public float[] getRGBColorComponents() {
            return new float[]{ColorTools._toFloat(this.R), ColorTools._toFloat(this.G), ColorTools._toFloat(this.B)};
        }

        public RGB lighter(double percent) {
            float p = ColorTools._bound((float)percent);
            float[] C = this.getRGBColorComponents();
            for (int i = 0; i < C.length; ++i) {
                C[i] = ColorTools._bound(C[i] + (1.0f - C[i]) * p);
            }
            return new RGB(C);
        }

        public RGB darker(double percent) {
            float p = ColorTools._bound((float)percent);
            float[] C = this.getRGBColorComponents();
            for (int i = 0; i < C.length; ++i) {
                C[i] = ColorTools._bound(C[i] - C[i] * p);
            }
            return new RGB(C);
        }

        public RGB mixWith(RGB color) {
            if (color == null) {
                return this;
            }
            float[] rgb1 = this.getRGBColorComponents();
            float[] rgb2 = color.getRGBColorComponents();
            float[] rgb = new float[3];
            for (int i = 0; i < 3; ++i) {
                rgb[i] = (rgb1[i] + rgb2[i]) / 2.0f;
            }
            return new RGB(rgb[0], rgb[1], rgb[2]);
        }

        public RGB mixWith(RGB color, float weight) {
            if (color == null) {
                return this;
            }
            float[] rgb1 = this.getRGBColorComponents();
            float[] rgb2 = color.getRGBColorComponents();
            float[] rgb = new float[3];
            for (int i = 0; i < 3; ++i) {
                rgb[i] = ColorTools._bound(rgb1[i] + (rgb2[i] - rgb1[i]) * weight);
            }
            return new RGB(rgb[0], rgb[1], rgb[2]);
        }

        public RGB mixWith(RGB color, double weight) {
            return this.mixWith(color, (float)weight);
        }

        public String toString() {
            return this.toString(false);
        }

        public String toString(boolean inclHash) {
            return ColorTools.toHexString(this.getRGB(), inclHash);
        }
    }
}

