/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.util;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.NoRouteToHostException;
import java.net.Socket;
import java.net.SocketException;
import java.util.List;
import java.util.Vector;
import javax.net.ssl.SSLSocketFactory;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;
import org.opengts.util.StringTools;

public class ClientSocketThread
extends Thread {
    private static final int THREAD_STOPPED = -1;
    private static final int THREAD_CHANGING = 0;
    private static final int THREAD_RUNNING = 1;
    private static char LineTerminatorChar = (char)10;
    private static String LineTerminator = String.valueOf(LineTerminatorChar);
    private boolean useSSL = false;
    private String host = null;
    private int port = 0;
    private long readTimeout = 5000L;
    private Socket socket = null;
    private InputThread inputThread = null;
    private OutputThread outputThread = null;
    private Object ioThreadLock = null;
    private Vector<ActionListener> actionListeners = null;
    private int runStatus = -1;
    private static final String[] ARG_HOST = new String[]{"host", "h"};
    private static final String[] ARG_PORT = new String[]{"port", "p"};
    private static final String[] ARG_SEND = new String[]{"send"};
    private static final String[] ARG_RECEIVE = new String[]{"recv", "receive"};

    public ClientSocketThread(String host, int port) {
        this(host, port, false);
    }

    public ClientSocketThread(String host, int port, boolean useSSL) {
        this.host = host != null ? host : "localhost";
        this.port = port;
        this.useSSL = useSSL;
        this.ioThreadLock = new Object();
    }

    public long getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(long ms) {
        this.readTimeout = ms;
    }

    public void setSocketReadTimeout() throws SocketException {
        if (this.socket != null && this.readTimeout > 0L) {
            this.socket.setSoTimeout((int)this.readTimeout);
        }
    }

    public void openSocket() throws IOException {
        this.openSocket(-1L);
    }

    public void openSocket(long timeoutMS) throws IOException {
        if (this.useSSL) {
            this.socket = timeoutMS > 0L ? SSLSocketFactory.getDefault().createSocket(this.host, this.port) : SSLSocketFactory.getDefault().createSocket(this.host, this.port);
        } else if (timeoutMS > 0L) {
            this.socket = new Socket();
            this.socket.connect(new InetSocketAddress(this.host, this.port), (int)timeoutMS);
        } else {
            this.socket = new Socket(this.host, this.port);
        }
    }

    public void closeSocket() {
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void socketWriteBytes(byte[] b) throws IOException {
        ClientSocketThread.socketWriteBytes(this.socket, b, 0, -1);
    }

    public void socketWriteBytes(byte[] b, int offset, int length) throws IOException {
        ClientSocketThread.socketWriteBytes(this.socket, b, offset, length);
    }

    protected static void socketWriteBytes(Socket socket, byte[] b, int offset, int length) throws IOException {
        if (socket != null && b != null) {
            int bofs = offset;
            int blen = length >= 0 ? length : b.length;
            OutputStream output = socket.getOutputStream();
            output.write(b, bofs, blen);
            output.flush();
        }
    }

    protected static void socketWriteBytes(Socket socket, byte[] b) throws IOException {
        if (socket != null && b != null) {
            OutputStream output = socket.getOutputStream();
            output.write(b);
            output.flush();
        }
    }

    public void socketWriteString(StringBuffer val) throws IOException {
        ClientSocketThread.socketWriteString(this.socket, val);
    }

    protected static void socketWriteString(Socket socket, StringBuffer val) throws IOException {
        if (val != null) {
            ClientSocketThread.socketWriteBytes(socket, StringTools.getBytes(val), 0, -1);
        }
    }

    public void socketWriteString(String val) throws IOException {
        ClientSocketThread.socketWriteString(this.socket, val);
    }

    protected static void socketWriteString(Socket socket, String val) throws IOException {
        if (val != null) {
            ClientSocketThread.socketWriteBytes(socket, StringTools.getBytes(val), 0, -1);
        }
    }

    public void socketWriteLine(String val) throws IOException {
        ClientSocketThread.socketWriteLine(this.socket, val);
    }

    protected static void socketWriteLine(Socket socket, String val) throws IOException {
        if (val != null) {
            String lineTerm = ClientSocketThread.getLineTerminator();
            String v = val.endsWith(lineTerm) ? val : val + lineTerm;
            ClientSocketThread.socketWriteBytes(socket, StringTools.getBytes(v), 0, -1);
        }
    }

    public static String getLineTerminator() {
        return LineTerminator;
    }

    public static char getLineTerminatorChar() {
        return LineTerminatorChar;
    }

    public static void setLineTerminatorChar(char lt) {
        LineTerminatorChar = lt;
        LineTerminator = String.valueOf(LineTerminatorChar);
    }

    public byte[] socketReadBytes(int length) throws IOException {
        return ClientSocketThread.socketReadBytes(this.socket, length);
    }

    protected static byte[] socketReadBytes(Socket socket, int length) throws IOException {
        if (socket == null) {
            return null;
        }
        if (length <= 0) {
            return new byte[0];
        }
        byte[] data = new byte[length];
        InputStream input = socket.getInputStream();
        for (int dataLen = 0; dataLen < length; ++dataLen) {
            int ch = input.read();
            if (ch < 0) {
                throw new IOException("End of input");
            }
            data[dataLen] = (byte)ch;
        }
        return data;
    }

    public int socketReadBytes(ByteArrayOutputStream baos, int maxLength) throws IOException {
        return ClientSocketThread.socketReadBytes(this.socket, baos, maxLength);
    }

    protected static int socketReadBytes(Socket socket, ByteArrayOutputStream baos, int maxLength) throws IOException {
        int dataLen;
        if (socket == null) {
            return 0;
        }
        if (maxLength == 0) {
            return 0;
        }
        InputStream input = socket.getInputStream();
        for (dataLen = 0; maxLength < 0 || dataLen < maxLength; ++dataLen) {
            int ch = input.read();
            if (ch < 0) {
                return dataLen;
            }
            if (baos == null) continue;
            baos.write(ch);
        }
        return dataLen;
    }

    public String socketReadLine() throws IOException {
        return this.socketReadLine(-1);
    }

    public String socketReadLine(int maxLen) throws IOException {
        return ClientSocketThread.socketReadLine(this.socket, maxLen, null);
    }

    public String socketReadLine(StringBuffer sb) throws IOException {
        return this.socketReadLine(-1, sb);
    }

    public String socketReadLine(int maxLen, StringBuffer sb) throws IOException {
        return ClientSocketThread.socketReadLine(this.socket, maxLen, sb);
    }

    protected static String socketReadLine(Socket socket, int maxLen, StringBuffer sb) throws IOException {
        if (socket != null) {
            StringBuffer data = sb != null ? sb : new StringBuffer();
            InputStream input = socket.getInputStream();
            for (int dataLen = 0; maxLen < 0 || maxLen > dataLen; ++dataLen) {
                int ch = input.read();
                if (ch < 0) {
                    throw new IOException("End of input");
                }
                if (ch == LineTerminatorChar) {
                    data.append((char)ch);
                    ++dataLen;
                    break;
                }
                data.append((char)ch);
            }
            return data.toString();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.setRunStatus(1);
        this.threadStarted();
        try {
            this.openSocket();
            this.inputThread = new InputThread(this.socket, this.readTimeout, this.ioThreadLock);
            this.outputThread = new OutputThread(this.socket, this.ioThreadLock);
            this.inputThread.start();
            this.outputThread.start();
            Object object = this.ioThreadLock;
            synchronized (object) {
                while (this.inputThread.isRunning() || this.outputThread.isRunning()) {
                    try {
                        this.ioThreadLock.wait();
                    }
                    catch (Throwable throwable) {}
                }
            }
        }
        catch (NoRouteToHostException nrthe) {
            Print.logInfo("Client:ControlThread - Unable to reach " + this.host + ":" + this.port, new Object[0]);
            nrthe.printStackTrace();
        }
        catch (Throwable t) {
            Print.logInfo("Client:ControlThread - " + t, new Object[0]);
            t.printStackTrace();
        }
        finally {
            this.closeSocket();
        }
        this.setRunStatus(-1);
        this.threadStopped();
    }

    protected void threadStarted() {
        Print.logDebug("Client:ControlThread started ...", new Object[0]);
    }

    protected void threadStopped() {
        Print.logDebug("Client:ControlThread stopped ...", new Object[0]);
    }

    public void stopThread() {
        this.setRunStatus(0);
    }

    public void startThread() {
        this.start();
    }

    private int getRunStatus() {
        return this.runStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setRunStatus(int state) {
        Object object = this.ioThreadLock;
        synchronized (object) {
            this.runStatus = state;
        }
    }

    public boolean isRunning() {
        return this.getRunStatus() == 1;
    }

    public void sendMessage(String msg) {
        if (this.outputThread == null || !this.isRunning()) {
            throw new RuntimeException("ClientSocketThread must be running to send queued message");
        }
        this.outputThread.addCommand(msg);
    }

    public void addActionListener(ActionListener al) {
        if (al != null) {
            if (this.actionListeners == null) {
                this.actionListeners = new Vector();
            }
            if (!this.actionListeners.contains(al)) {
                this.actionListeners.add(al);
            }
        }
    }

    public void removeActionListener(ActionListener al) {
        if (this.actionListeners != null) {
            this.actionListeners.remove(al);
        }
    }

    protected void invokeListeners(String r) {
        if (this.actionListeners != null) {
            for (ActionListener al : this.actionListeners) {
                ActionEvent ae = new ActionEvent(this, 1001, r);
                try {
                    al.actionPerformed(ae);
                }
                catch (Throwable t) {
                    Print.logError("Exception: " + t.getMessage(), new Object[0]);
                }
            }
        }
    }

    protected void handleMessage(String msg) {
        this.invokeListeners(msg);
    }

    private static void usage() {
        Print.logInfo("Usage:", new Object[0]);
        Print.logInfo("  java ... " + ClientSocketThread.class.getName() + " {options}", new Object[0]);
        Print.logInfo("'Send' Options:", new Object[0]);
        Print.logInfo("  -host=<host>    The destination host", new Object[0]);
        Print.logInfo("  -port=<port>    The destination port", new Object[0]);
        Print.logInfo("  -send=<data>    The data to send (prefix with '0x' for hex data)", new Object[0]);
        Print.logInfo("'Receive' Options (not yet implemented):", new Object[0]);
        Print.logInfo("  -port=<port>    The port on which to listen for incoming data", new Object[0]);
        Print.logInfo("  -recv           Set to 'receive' mode", new Object[0]);
        System.exit(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] argv) {
        RTConfig.setCommandLineArgs(argv);
        String host = RTConfig.getString(ARG_HOST, null);
        int port = RTConfig.getInt(ARG_PORT, 0);
        if (RTConfig.hasProperty(ARG_SEND)) {
            String dataStr;
            if (StringTools.isBlank(host)) {
                Print.logError("Target host not specified", new Object[0]);
                ClientSocketThread.usage();
            }
            if (port <= 0) {
                Print.logError("Target port not specified", new Object[0]);
                ClientSocketThread.usage();
            }
            byte[] data = (dataStr = RTConfig.getString(ARG_SEND, "hello")).startsWith("0x") ? StringTools.parseHex(dataStr, null) : dataStr.getBytes();
            ClientSocketThread cst = new ClientSocketThread(host, port);
            try {
                cst.openSocket();
                cst.socketWriteBytes(data);
            }
            catch (Throwable t) {
                Print.logException("Error", t);
            }
            finally {
                cst.closeSocket();
            }
            System.exit(0);
        }
        if (RTConfig.hasProperty(ARG_RECEIVE)) {
            if (port <= 0) {
                Print.logError("Target port not specified", new Object[0]);
                ClientSocketThread.usage();
            }
            if (!StringTools.isBlank(host)) {
                Print.logWarn("Specified 'host' will be ignored", new Object[0]);
            }
            Print.logError("Receive not yet implemented ...", new Object[0]);
            System.exit(99);
        }
        ClientSocketThread.usage();
    }

    private class InputThread
    extends Thread {
        private boolean isRunning = false;
        private Socket socket = null;
        private long readTimeout = 5000L;
        private Object threadLock = null;

        public InputThread(Socket sock, long timeout, Object threadLock) {
            this.socket = sock;
            this.readTimeout = timeout;
            this.threadLock = threadLock;
        }

        @Override
        public void start() {
            this.isRunning = true;
            super.start();
        }

        public boolean isRunning() {
            return this.isRunning;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            StringBuffer data = new StringBuffer();
            Print.logDebug("Client:InputThread started", new Object[0]);
            while (true) {
                data.setLength(0);
                boolean timeout = false;
                try {
                    if (this.readTimeout > 0L) {
                        this.socket.setSoTimeout((int)this.readTimeout);
                    }
                    ClientSocketThread.socketReadLine(this.socket, -1, data);
                }
                catch (InterruptedIOException ee) {
                    if (ClientSocketThread.this.getRunStatus() != 1) break;
                    timeout = true;
                }
                catch (Throwable t) {
                    Print.logError("Client:InputThread - " + t, new Object[0]);
                    t.printStackTrace();
                    break;
                }
                if (timeout && data.length() <= 0) continue;
                ClientSocketThread.this.handleMessage(data.toString());
            }
            Object object = this.threadLock;
            synchronized (object) {
                this.isRunning = false;
                Print.logDebug("Client:InputThread stopped", new Object[0]);
                this.threadLock.notify();
            }
        }
    }

    private class OutputThread
    extends Thread {
        private boolean isRunning = false;
        private Socket socket = null;
        private Object threadLock = null;
        private List<String> cmdList = null;

        public OutputThread(Socket sock, Object threadLock) {
            this.socket = sock;
            this.threadLock = threadLock;
            this.cmdList = new Vector<String>();
        }

        @Override
        public void start() {
            this.isRunning = true;
            super.start();
        }

        public boolean isRunning() {
            return this.isRunning;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addCommand(String cmd) {
            List<String> list = this.cmdList;
            synchronized (list) {
                this.cmdList.add(cmd);
                this.cmdList.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object;
            String command = null;
            Print.logInfo("Client:OutputThread started", new Object[0]);
            while (true) {
                object = this.cmdList;
                synchronized (object) {
                    while (this.cmdList.size() <= 0 && ClientSocketThread.this.getRunStatus() == 1) {
                        try {
                            this.cmdList.wait(5000L);
                        }
                        catch (Throwable throwable) {}
                    }
                    if (ClientSocketThread.this.getRunStatus() != 1) {
                        break;
                    }
                    command = this.cmdList.remove(0).toString();
                }
                try {
                    ClientSocketThread.socketWriteLine(this.socket, command);
                }
                catch (Throwable t) {
                    Print.logError("Client:OutputThread - " + t, new Object[0]);
                    t.printStackTrace();
                    break;
                }
            }
            if (ClientSocketThread.this.getRunStatus() == 1) {
                Print.logWarn("Client:OutputThread stopped due to error", new Object[0]);
            } else {
                Print.logInfo("Client:OutputThread stopped", new Object[0]);
            }
            object = this.threadLock;
            synchronized (object) {
                this.isRunning = false;
                Print.logInfo("Client:OutputThread stopped", new Object[0]);
                this.threadLock.notify();
            }
        }
    }
}

