/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.util;

import java.util.zip.CRC32;
import org.opengts.util.ListTools;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;
import org.opengts.util.StringTools;

public class Checksum {
    private static int[] crc_CCITT_Table;
    private static int[] CRCtab16;
    private static int[] CRCtab16_1;

    public static byte TwosCompliment(byte b) {
        return (byte)((~b & 0xFF) + 1);
    }

    private static void initCrcCCITT() {
        if (crc_CCITT_Table == null) {
            crc_CCITT_Table = new int[256];
            for (int c = 0; c < 256; ++c) {
                int fcs = 0;
                int x = c << 8;
                for (int j = 0; j < 8; ++j) {
                    fcs = ((fcs ^ x) & 0x8000) != 0 ? fcs << 1 ^ 0x1021 : (fcs <<= 1);
                    x <<= 1;
                    fcs &= 0xFFFF;
                }
                Checksum.crc_CCITT_Table[c] = fcs;
            }
        }
    }

    public static int calcCrcCCITT(byte[] b) {
        return Checksum.calcCrcCCITT(b, 0, -1);
    }

    public static int calcCrcCCITT(byte[] b, int bLen) {
        return Checksum.calcCrcCCITT(b, 0, bLen);
    }

    public static int calcCrcCCITT(byte[] b, int bOfs, int bLen) {
        int W = 65535;
        if (b != null) {
            if (crc_CCITT_Table == null) {
                Checksum.initCrcCCITT();
            }
            int ofs = bOfs <= 0 ? 0 : (bOfs >= b.length ? b.length : bOfs);
            int len = bLen >= 0 && bLen <= b.length - ofs ? bLen : b.length - ofs;
            for (int c = 0; c < len; ++c) {
                W = (crc_CCITT_Table[(b[c + ofs] ^ W >>> 8) & 0xFF] ^ W << 8) & 0xFFFF;
            }
        }
        return W;
    }

    public static int calcCrc16(byte[] b) {
        if (!ListTools.isEmpty(b)) {
            return Checksum.calcCrc16(b, 0, b.length);
        }
        return 0;
    }

    public static int calcCrc16(byte[] b, int bOfs, int bLen) {
        int crc = 0;
        if (b != null) {
            int ofs = bOfs <= 0 ? 0 : (bOfs >= b.length ? b.length : bOfs);
            int len = bLen >= 0 && bLen <= b.length - ofs ? bLen : b.length - ofs;
            for (int c = 0; c < len; ++c) {
                crc = crc >>> 8 ^ CRCtab16[(crc ^ b[c + ofs]) & 0xFF];
            }
        }
        return crc & 0xFFFF;
    }

    public static int calcCrc16_1(byte[] b) {
        if (!ListTools.isEmpty(b)) {
            return Checksum.calcCrc16_1(b, 0, b.length);
        }
        return 0;
    }

    public static int calcCrc16_1(byte[] b, int bOfs, int bLen) {
        int crc = 0;
        if (b != null) {
            int ofs = bOfs <= 0 ? 0 : (bOfs >= b.length ? b.length : bOfs);
            int len = bLen >= 0 && bLen <= b.length - ofs ? bLen : b.length - ofs;
            for (int c = 0; c < len; ++c) {
                crc = crc >> 8 ^ CRCtab16_1[(crc ^ b[c + ofs]) & 0xFF];
            }
        }
        return ~crc & 0xFFFF;
    }

    public static long calcCrc32(byte[] b) {
        if (!ListTools.isEmpty(b)) {
            return Checksum.calcCrc32(b, 0, b.length);
        }
        return 0L;
    }

    public static long calcCrc32(byte[] b, int bOfs, int bLen) {
        int crc = 0;
        if (b != null) {
            int ofs = bOfs <= 0 ? 0 : (bOfs >= b.length ? b.length : bOfs);
            int len = bLen >= 0 && bLen <= b.length - ofs ? bLen : b.length - ofs;
            CRC32 crc32 = new CRC32();
            crc32.update(b, ofs, len);
            return crc32.getValue();
        }
        return crc;
    }

    public static byte calcCrcXOR8(byte[] b) {
        if (!ListTools.isEmpty(b)) {
            return Checksum.calcCrcXOR8(b, 0, b.length);
        }
        return 0;
    }

    public static byte calcCrcXOR8(byte[] b, int bOfs, int bLen) {
        int crc = 0;
        if (b != null) {
            int ofs = bOfs <= 0 ? 0 : (bOfs >= b.length ? b.length : bOfs);
            int len = bLen >= 0 && bLen <= b.length - ofs ? bLen : b.length - ofs;
            for (int s = ofs; s < ofs + len; ++s) {
                crc = (crc ^ b[s]) & 0xFF;
            }
        }
        return (byte)crc;
    }

    public static byte calcCrcSum8(byte[] b) {
        if (!ListTools.isEmpty(b)) {
            return Checksum.calcCrcSum8(b, 0, b.length);
        }
        return 0;
    }

    public static byte calcCrcSum8(byte[] b, int bOfs, int bLen) {
        int crc = 0;
        if (b != null) {
            int ofs = bOfs <= 0 ? 0 : (bOfs >= b.length ? b.length : bOfs);
            int len = bLen >= 0 && bLen <= b.length - ofs ? bLen : b.length - ofs;
            for (int s = ofs; s < ofs + len; ++s) {
                crc = crc + b[s] & 0xFF;
            }
        }
        return (byte)crc;
    }

    public static void main(String[] args) {
        RTConfig.setCommandLineArgs(args);
        String data = RTConfig.getString("data", "");
        byte[] dataB = data.startsWith("0x") ? StringTools.parseHex(data, null) : data.getBytes();
        Print.sysPrintln("ASCII     : " + data, new Object[0]);
        Print.sysPrintln("Hex       : 0x" + StringTools.toHexString(dataB), new Object[0]);
        byte crcSum8 = Checksum.calcCrcSum8(dataB);
        Print.sysPrintln("CRC Sum-8 : 0x" + StringTools.toHexString(crcSum8), new Object[0]);
        byte crcXOR8 = Checksum.calcCrcXOR8(dataB);
        Print.sysPrintln("CRC XOR-8 : 0x" + StringTools.toHexString(crcXOR8), new Object[0]);
        int crcCCITT = Checksum.calcCrcCCITT(dataB);
        Print.sysPrintln("CRC CCITT : 0x" + StringTools.toHexString(crcCCITT, 16), new Object[0]);
        int crc16 = Checksum.calcCrc16(dataB);
        Print.sysPrintln("CRC 16    : 0x" + StringTools.toHexString(crc16, 16), new Object[0]);
        int crc16_1 = Checksum.calcCrc16_1(dataB);
        Print.sysPrintln("CRC 16(1) : 0x" + StringTools.toHexString(crc16_1, 16), new Object[0]);
        long crc32 = Checksum.calcCrc32(dataB);
        Print.sysPrintln("CRC 32    : 0x" + StringTools.toHexString(crc32, 32), new Object[0]);
    }

    static {
        Checksum.initCrcCCITT();
        crc_CCITT_Table = null;
        CRCtab16 = new int[]{0, 49345, 49537, 320, 49921, 960, 640, 49729, 50689, 1728, 1920, 51009, 1280, 50625, 50305, 1088, 52225, 3264, 3456, 52545, 3840, 53185, 52865, 3648, 2560, 51905, 52097, 2880, 51457, 2496, 2176, 51265, 55297, 6336, 6528, 55617, 6912, 56257, 55937, 6720, 7680, 57025, 57217, 8000, 56577, 7616, 7296, 56385, 5120, 54465, 54657, 5440, 55041, 6080, 5760, 54849, 53761, 4800, 4992, 54081, 4352, 53697, 53377, 4160, 61441, 12480, 12672, 61761, 13056, 62401, 62081, 12864, 13824, 63169, 63361, 14144, 62721, 13760, 13440, 62529, 15360, 64705, 64897, 15680, 65281, 16320, 16000, 65089, 64001, 15040, 15232, 64321, 14592, 63937, 63617, 14400, 10240, 59585, 59777, 10560, 60161, 11200, 10880, 59969, 60929, 11968, 12160, 61249, 11520, 60865, 60545, 11328, 58369, 9408, 9600, 58689, 9984, 59329, 59009, 9792, 8704, 58049, 58241, 9024, 57601, 8640, 8320, 57409, 40961, 24768, 24960, 41281, 25344, 41921, 41601, 25152, 26112, 42689, 42881, 26432, 42241, 26048, 25728, 42049, 27648, 44225, 44417, 27968, 44801, 28608, 28288, 44609, 43521, 27328, 27520, 43841, 26880, 43457, 43137, 26688, 30720, 47297, 47489, 31040, 47873, 31680, 31360, 47681, 48641, 32448, 32640, 48961, 32000, 48577, 48257, 31808, 46081, 29888, 30080, 46401, 30464, 47041, 46721, 30272, 29184, 45761, 45953, 29504, 45313, 29120, 28800, 45121, 20480, 37057, 37249, 20800, 37633, 21440, 21120, 37441, 38401, 22208, 22400, 38721, 21760, 38337, 38017, 21568, 39937, 23744, 23936, 40257, 24320, 40897, 40577, 24128, 23040, 39617, 39809, 23360, 39169, 22976, 22656, 38977, 34817, 18624, 18816, 35137, 19200, 35777, 35457, 19008, 19968, 36545, 36737, 20288, 36097, 19904, 19584, 35905, 17408, 33985, 34177, 17728, 34561, 18368, 18048, 34369, 33281, 17088, 17280, 33601, 16640, 33217, 32897, 16448};
        CRCtab16_1 = new int[]{0, 4489, 8978, 12955, 17956, 22445, 25910, 29887, 35912, 40385, 44890, 48851, 51820, 56293, 59774, 63735, 4225, 264, 13203, 8730, 22181, 18220, 30135, 25662, 40137, 36160, 49115, 44626, 56045, 52068, 63999, 59510, 8450, 12427, 528, 5017, 26406, 30383, 17460, 21949, 44362, 48323, 36440, 40913, 60270, 64231, 51324, 55797, 12675, 8202, 4753, 792, 30631, 26158, 21685, 17724, 48587, 44098, 40665, 36688, 64495, 60006, 55549, 51572, 16900, 21389, 24854, 28831, 1056, 5545, 10034, 14011, 52812, 57285, 60766, 64727, 34920, 39393, 43898, 47859, 21125, 17164, 29079, 24606, 5281, 1320, 14259, 9786, 57037, 53060, 64991, 60502, 39145, 35168, 48123, 43634, 25350, 29327, 16404, 20893, 9506, 13483, 1584, 6073, 61262, 65223, 52316, 56789, 43370, 47331, 35448, 39921, 29575, 25102, 20629, 16668, 13731, 9258, 5809, 1848, 65487, 60998, 56541, 52564, 47595, 43106, 39673, 35696, 33800, 38273, 42778, 46739, 49708, 54181, 57662, 61623, 2112, 6601, 11090, 15067, 20068, 24557, 28022, 31999, 38025, 34048, 47003, 42514, 53933, 49956, 61887, 57398, 6337, 2376, 15315, 10842, 24293, 20332, 32247, 27774, 42250, 46211, 34328, 38801, 58158, 62119, 49212, 53685, 10562, 14539, 2640, 7129, 28518, 32495, 19572, 24061, 46475, 41986, 38553, 34576, 62383, 57894, 53437, 49460, 14787, 10314, 6865, 2904, 32743, 28270, 23797, 19836, 50700, 55173, 58654, 62615, 32808, 37281, 41786, 45747, 19012, 23501, 26966, 30943, 3168, 7657, 12146, 16123, 54925, 50948, 62879, 58390, 37033, 33056, 46011, 41522, 23237, 19276, 31191, 26718, 7393, 3432, 16371, 11898, 59150, 63111, 50204, 54677, 41258, 45219, 33336, 37809, 27462, 31439, 18516, 23005, 11618, 15595, 3696, 8185, 63375, 58886, 54429, 50452, 45483, 40994, 37561, 33584, 31687, 27214, 22741, 18780, 15843, 11370, 7921, 3960};
    }
}

