/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.util;

import java.io.ByteArrayOutputStream;

public class CachedLogOutputStream
extends ByteArrayOutputStream {
    public static final int DEFAULT_MINIMUM_LENGTH = 16000;
    public static final int DEFAULT_MAXIMUM_LENGTH = 24000;
    private static final byte[] NEWLINE = new byte[]{10};
    private int minSize = 16000;
    private int maxSize = 24000;
    private long discardID = 0L;

    public CachedLogOutputStream() {
        this(16000, 24000);
    }

    public CachedLogOutputStream(int minSize, int maxSize) {
        super(maxSize);
        this.maxSize = maxSize;
        this.minSize = minSize <= 0 || minSize > maxSize ? this.maxSize / 2 : minSize;
    }

    @Override
    public synchronized void reset() {
        super.reset();
        this.discardID = 0L;
    }

    @Override
    public synchronized int size() {
        return super.size();
    }

    public synchronized long getDiscardID() {
        return this.discardID;
    }

    private static boolean IsNL(byte c) {
        return c == 10 || c == 13;
    }

    @Override
    public synchronized void write(int b) {
        int len = 1;
        int ofs = 0;
        int newcount = this.count + len;
        if (newcount > this.buf.length) {
            if (len >= this.minSize) {
                this.count = 0;
                ofs = len - this.minSize;
                len = this.minSize;
            } else {
                int bufLen = this.minSize - len;
                int bufPos = this.count - bufLen;
                while (bufLen > 0 && !CachedLogOutputStream.IsNL(this.buf[bufPos])) {
                    --bufLen;
                    ++bufPos;
                }
                while (bufLen > 0 && CachedLogOutputStream.IsNL(this.buf[bufPos])) {
                    --bufLen;
                    ++bufPos;
                }
                System.arraycopy(this.buf, bufPos, this.buf, 0, bufLen);
                this.count = bufLen;
            }
            newcount = this.count + len;
            ++this.discardID;
        }
        this.buf[this.count] = (byte)b;
        this.count = newcount;
        this.notifyAll();
    }

    @Override
    public synchronized void write(byte[] b, int ofs, int len) {
        if (b == null || len == 0) {
            return;
        }
        if (ofs < 0 || ofs > b.length || len < 0 || ofs + len > b.length || ofs + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        int newcount = this.count + len;
        if (newcount > this.buf.length) {
            if (len >= this.minSize) {
                this.count = 0;
                ofs = len - this.minSize;
                len = this.minSize;
            } else {
                int bufLen = this.minSize - len;
                int bufPos = this.count - bufLen;
                while (bufLen > 0 && !CachedLogOutputStream.IsNL(this.buf[bufPos])) {
                    --bufLen;
                    ++bufPos;
                }
                while (bufLen > 0 && CachedLogOutputStream.IsNL(this.buf[bufPos])) {
                    --bufLen;
                    ++bufPos;
                }
                System.arraycopy(this.buf, bufPos, this.buf, 0, bufLen);
                this.count = bufLen;
            }
            newcount = this.count + len;
            ++this.discardID;
        }
        System.arraycopy(b, ofs, this.buf, this.count, len);
        this.count = newcount;
        this.notifyAll();
    }

    public synchronized void write(String s) {
        if (s != null && s.length() > 0) {
            byte[] b = s.getBytes();
            this.write(b, 0, b.length);
        }
    }

    public synchronized void writeln(String s) {
        this.write(s);
        this.write(NEWLINE, 0, NEWLINE.length);
    }

    protected synchronized String _readLine(boolean removeLine) {
        int p;
        for (p = 0; p < this.count && !CachedLogOutputStream.IsNL(this.buf[p]); ++p) {
        }
        if (p < this.count && CachedLogOutputStream.IsNL(this.buf[p])) {
            ++p;
        }
        if (p == 0) {
            return null;
        }
        int ofs = 0;
        String s = new String(this.buf, ofs, p);
        if (removeLine) {
            int newcount = this.count - p;
            System.arraycopy(this.buf, p, this.buf, 0, newcount);
            this.count = newcount;
        }
        return s;
    }

    public String readLine() {
        return this._readLine(true);
    }

    public String peekLine() {
        return this._readLine(false);
    }
}

