/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.util;

import java.math.BigInteger;
import org.opengts.util.ListTools;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;
import org.opengts.util.StringTools;

public class Base64 {
    public static final char Base64Pad = '=';
    public static final char[] Base64Alphabet = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
    public static final char[] Base64HttpAlpha = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '-', '_'};
    private static final String[] ARG_DECODE = new String[]{"decode", "d"};
    private static final String[] ARG_ENCODE = new String[]{"encode", "e"};
    private static final String[] ARG_SEED = new String[]{"seed", "s"};

    public static char[] shuffleAlphabet(long seed) {
        return Base64.shuffleAlphabet(seed, Base64Alphabet);
    }

    public static char[] shuffleAlphabet(long seed, char[] alpha) {
        char[] newAlpha = new char[Base64Alphabet.length];
        System.arraycopy(alpha, 0, newAlpha, 0, newAlpha.length);
        return ListTools.shuffle(newAlpha, seed);
    }

    public static char[] shuffleAlphabet(BigInteger seed) {
        return Base64.shuffleAlphabet(seed, Base64Alphabet);
    }

    public static char[] shuffleAlphabet(BigInteger seed, char[] alpha) {
        char[] newAlpha = new char[Base64Alphabet.length];
        System.arraycopy(alpha, 0, newAlpha, 0, newAlpha.length);
        return ListTools.shuffle(newAlpha, seed);
    }

    protected static char _encodeChar(int ndx, char[] alpha) {
        return alpha[ndx];
    }

    public static String encode(String str) {
        return str != null ? Base64.encode(str.getBytes()) : "";
    }

    public static String encode(String str, long seed) {
        return str != null ? Base64.encode(str.getBytes(), seed) : "";
    }

    public static String encode(String str, long seed, char pad) {
        return str != null ? Base64.encode(str.getBytes(), seed, pad) : "";
    }

    public static String encode(String str, BigInteger seed) {
        return str != null ? Base64.encode(str.getBytes(), seed) : "";
    }

    public static String encode(String str, BigInteger seed, char pad) {
        return str != null ? Base64.encode(str.getBytes(), seed, pad) : "";
    }

    public static String encode(byte[] buff) {
        return Base64.encode(buff, Base64Alphabet, '=');
    }

    public static String encode(byte[] buff, char[] alpha) {
        return Base64.encode(buff, alpha, '=');
    }

    public static String encode(byte[] buff, char[] alpha, char pad) {
        if (buff == null || buff.length == 0) {
            return "";
        }
        if (alpha == null) {
            alpha = Base64Alphabet;
        }
        StringBuffer sb = new StringBuffer();
        int len = buff.length;
        for (int i = 0; i < len; i += 3) {
            int reg24 = buff[i] << 16 & 0xFF0000;
            if (i + 1 < len) {
                reg24 |= buff[i + 1] << 8 & 0xFF00;
            }
            if (i + 2 < len) {
                reg24 |= buff[i + 2] & 0xFF;
            }
            sb.append(alpha[reg24 >>> 18 & 0x3F]);
            sb.append(alpha[reg24 >>> 12 & 0x3F]);
            sb.append(i + 1 < len ? alpha[reg24 >>> 6 & 0x3F] : pad);
            sb.append(i + 2 < len ? alpha[reg24 & 0x3F] : pad);
        }
        return sb.toString();
    }

    public static String encode(byte[] buff, long seed) {
        char[] alpha = Base64.shuffleAlphabet(seed);
        return Base64.encode(buff, alpha, '=');
    }

    public static String encode(byte[] buff, long seed, char pad) {
        char[] alpha = Base64.shuffleAlphabet(seed);
        return Base64.encode(buff, alpha, pad);
    }

    public static String encode(byte[] buff, BigInteger seed) {
        char[] alpha = Base64.shuffleAlphabet(seed);
        return Base64.encode(buff, alpha, '=');
    }

    public static String encode(byte[] buff, BigInteger seed, char pad) {
        char[] alpha = Base64.shuffleAlphabet(seed);
        return Base64.encode(buff, alpha, pad);
    }

    protected static int _decodeChar(char ch, char[] alpha) throws Base64DecodeException {
        for (int i = 0; i < alpha.length; ++i) {
            if (ch != alpha[i]) continue;
            return i;
        }
        throw new Base64DecodeException("Invalid char: " + ch);
    }

    public static byte[] decode(String b64Str) throws Base64DecodeException {
        return Base64.decode(b64Str, Base64Alphabet, '=');
    }

    public static byte[] decode(String b64Str, char[] alpha) throws Base64DecodeException {
        return Base64.decode(b64Str, alpha, '=');
    }

    public static byte[] decode(String b64Str, char[] alpha, char pad) throws Base64DecodeException {
        int len;
        if (alpha == null) {
            alpha = Base64Alphabet;
        }
        if (b64Str == null || b64Str.equals("")) {
            return new byte[0];
        }
        for (len = b64Str.length(); len > 0 && b64Str.charAt(len - 1) == pad; --len) {
        }
        int b = 0;
        int blen = (len - 1) / 4 * 3 + (len - 1) % 4;
        if ((len - 1) % 4 == 0) {
            ++blen;
        }
        byte[] buff = new byte[blen];
        for (int i = 0; i < len; i += 4) {
            int reg24 = Base64._decodeChar(b64Str.charAt(i), alpha) << 18 & 0xFC0000;
            if (i + 1 < len) {
                reg24 |= Base64._decodeChar(b64Str.charAt(i + 1), alpha) << 12 & 0x3F000;
            }
            if (i + 2 < len) {
                reg24 |= Base64._decodeChar(b64Str.charAt(i + 2), alpha) << 6 & 0xFC0;
            }
            if (i + 3 < len) {
                reg24 |= Base64._decodeChar(b64Str.charAt(i + 3), alpha) & 0x3F;
            }
            buff[b++] = (byte)(reg24 >>> 16 & 0xFF);
            if (i + 2 < len) {
                buff[b++] = (byte)(reg24 >>> 8 & 0xFF);
            }
            if (i + 3 >= len) continue;
            buff[b++] = (byte)(reg24 & 0xFF);
        }
        return buff;
    }

    public static byte[] decode(String b64Str, long seed) throws Base64DecodeException {
        char[] alpha = Base64.shuffleAlphabet(seed);
        return Base64.decode(b64Str, alpha, '=');
    }

    public static byte[] decode(String b64Str, BigInteger seed) throws Base64DecodeException {
        char[] alpha = Base64.shuffleAlphabet(seed);
        return Base64.decode(b64Str, alpha, '=');
    }

    private static void usage() {
        Print.logInfo("Usage:", new Object[0]);
        Print.logInfo("  java ... " + Base64.class.getName() + " {options}", new Object[0]);
        Print.logInfo("Options:", new Object[0]);
        Print.logInfo("  -decode=<Base64>   Decode Base64 string to ASCII", new Object[0]);
        Print.logInfo("  -encode=<ASCII>    Encode ASCII string to Base64", new Object[0]);
        System.exit(1);
    }

    public static void main(String[] argv) {
        byte[] b;
        RTConfig.setCommandLineArgs(argv);
        long seed = RTConfig.getLong(ARG_SEED, 0L);
        if (RTConfig.hasProperty(ARG_DECODE)) {
            String b64 = RTConfig.getString(ARG_DECODE, "");
            try {
                b = seed > 0L ? Base64.decode(b64, seed) : Base64.decode(b64);
                Print.sysPrintln("Hex  : 0x" + StringTools.toHexString(b), new Object[0]);
                Print.sysPrintln("ASCII: " + StringTools.toStringValue(b, '.'), new Object[0]);
                System.exit(0);
            }
            catch (Base64DecodeException bde) {
                Print.logException("Invalid data", bde);
                System.exit(1);
            }
        }
        if (RTConfig.hasProperty(ARG_ENCODE)) {
            String ascii = RTConfig.getString(ARG_ENCODE, "");
            b = ascii.startsWith("0x") ? StringTools.parseHex(ascii, new byte[0]) : ascii.getBytes();
            String b64 = seed > 0L ? Base64.encode(b, seed) : Base64.encode(b);
            Print.sysPrintln("Base64: " + b64, new Object[0]);
            System.exit(0);
        }
        Base64.usage();
    }

    public static class Base64DecodeException
    extends Exception {
        public Base64DecodeException(String msg) {
            super(msg);
        }
    }
}

