/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.util;

import org.opengts.util.StringTools;

public class Accelerometer {
    private double xAxis = 0.0;
    private double yAxis = 0.0;
    private double zAxis = 0.0;

    public Accelerometer() {
        this(0.0, 0.0, 0.0);
    }

    public Accelerometer(double x, double y, double z) {
        this.xAxis = x;
        this.yAxis = y;
        this.zAxis = z;
    }

    public Accelerometer(String xyz) {
        if (StringTools.isBlank(xyz)) {
            this.xAxis = 0.0;
            this.yAxis = 0.0;
            this.zAxis = 0.0;
        } else {
            String[] A = xyz.indexOf(",") >= 0 ? StringTools.split(xyz, ',') : (xyz.indexOf("/") >= 0 ? StringTools.split(xyz, '/') : (xyz.indexOf("|") >= 0 ? StringTools.split(xyz, '|') : new String[]{xyz}));
            this.xAxis = A.length > 0 ? StringTools.parseDouble(A[0], 0.0) : 0.0;
            this.yAxis = A.length > 1 ? StringTools.parseDouble(A[1], 0.0) : 0.0;
            this.zAxis = A.length > 2 ? StringTools.parseDouble(A[2], 0.0) : 0.0;
        }
    }

    public double getXAxis() {
        return this.xAxis;
    }

    public double getYAxis() {
        return this.yAxis;
    }

    public double getZAxis() {
        return this.zAxis;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(StringTools.format(this.getXAxis(), "0.00000"));
        sb.append(",");
        sb.append(StringTools.format(this.getYAxis(), "0.00000"));
        sb.append(",");
        sb.append(StringTools.format(this.getZAxis(), "0.00000"));
        return sb.toString();
    }
}

