/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.util;

import java.net.InetAddress;
import java.util.TimeZone;
import org.opengts.util.ClientPacketHandler;
import org.opengts.util.DateTime;
import org.opengts.util.Print;
import org.opengts.util.ServerSocketThread;
import org.opengts.util.StringTools;

public abstract class AbstractClientPacketHandler
implements ClientPacketHandler {
    public static final int PACKET_LEN_LINE_TERMINATOR = -1;
    public static final int PACKET_LEN_END_OF_STREAM = -2;
    public static final TimeZone GMT_Timezone = DateTime.getGMTTimeZone();
    private static boolean DebugMode = false;
    private static long SequenceCount = 1L;
    private static Object SequenceLock = new Object();
    private long sequenceID = 0L;
    private long sessStartTime = 0L;
    private InetAddress inetAddr = null;
    private String hostAddress = null;
    private boolean isTCP = true;
    private boolean isTextPackets = false;
    private boolean promptEnabled = true;
    private boolean terminateSess = true;
    private ServerSocketThread.SessionInfo sessionInfo = null;
    private int savedEventCount = 0;

    public static void SetDebugMode(boolean debug) {
        DebugMode = debug;
    }

    public static boolean GetDebugMode() {
        return DebugMode;
    }

    public static boolean IsDebugMode() {
        return DebugMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractClientPacketHandler() {
        Object object = SequenceLock;
        synchronized (object) {
            this.sequenceID = SequenceCount++;
        }
    }

    public long getSequenceID() {
        return this.sequenceID;
    }

    public boolean equals(Object other) {
        if (other instanceof AbstractClientPacketHandler) {
            return this.getSequenceID() == ((AbstractClientPacketHandler)other).getSequenceID();
        }
        return false;
    }

    @Override
    public void setSessionInfo(ServerSocketThread.SessionInfo sessionInfo) {
        this.sessionInfo = sessionInfo;
    }

    @Override
    public ServerSocketThread.SessionInfo getSessionInfo() {
        return this.sessionInfo;
    }

    public String getThreadName() {
        ServerSocketThread.SessionInfo si = this.getSessionInfo();
        Thread st = si != null ? si.getSessionThread() : null;
        return st != null ? st.getName() : null;
    }

    public int getLocalPort() {
        ServerSocketThread.SessionInfo si = this.getSessionInfo();
        return si != null ? si.getLocalPort() : -1;
    }

    public int getRemotePort() {
        ServerSocketThread.SessionInfo si = this.getSessionInfo();
        return si != null ? si.getRemotePort() : -1;
    }

    @Override
    public void setPromptEnabled(boolean enable) {
        this.promptEnabled = enable;
    }

    @Override
    public boolean getPromptEnabled() {
        return this.promptEnabled;
    }

    @Override
    public boolean tcpWrite(byte[] data) {
        ServerSocketThread.SessionInfo si = this.getSessionInfo();
        return si != null ? si.tcpWrite(data) : false;
    }

    @Override
    public void sessionStarted(InetAddress inetAddr, boolean isTCP, boolean isText) {
        this.sessStartTime = DateTime.getCurrentTimeSec();
        this.inetAddr = inetAddr;
        this.isTCP = isTCP;
        this.isTextPackets = isText;
        this.clearSavedEventCount();
        this.printSessionStart();
    }

    protected void printSessionStart() {
        String sessType = this.getSessionType();
        String host = StringTools.trim(this.getHostAddress());
        String name = StringTools.blankDefault(this.getThreadName(), "?");
        Print.logInfo("Begin " + sessType + " session (" + name + "): " + host, new Object[0]);
    }

    @Override
    public boolean equalsSessionID(String sessionID) {
        if (sessionID == null) {
            Print.logWarn("No target SessionID", new Object[0]);
            return false;
        }
        String thisSessID = this.getSessionID();
        if (thisSessID == null) {
            return false;
        }
        return thisSessID.equals(sessionID);
    }

    protected String getSessionID() {
        return null;
    }

    public long getSessionStartTime() {
        return this.sessStartTime;
    }

    protected boolean isTextPackets() {
        return this.isTextPackets;
    }

    public boolean isDuplex() {
        return this.isTCP;
    }

    public boolean isTCP() {
        ServerSocketThread.SessionInfo si = this.getSessionInfo();
        return si != null ? si.isTCP() : this.isTCP;
    }

    public boolean isUDP() {
        ServerSocketThread.SessionInfo si = this.getSessionInfo();
        return si != null ? si.isUDP() : !this.isTCP();
    }

    public boolean isInputStream() {
        ServerSocketThread.SessionInfo si = this.getSessionInfo();
        return si != null ? si.isInputStream() : false;
    }

    public String getSessionType() {
        if (this.isTCP()) {
            return "TCP";
        }
        if (this.isUDP()) {
            return "UDP";
        }
        if (this.isInputStream()) {
            return "InputStream";
        }
        return "UNKNOWN";
    }

    public InetAddress getInetAddress() {
        return this.inetAddr;
    }

    public String getHostAddress() {
        if (this.hostAddress == null && this.inetAddr != null) {
            this.hostAddress = this.inetAddr.getHostAddress();
        }
        return this.hostAddress;
    }

    public boolean hasHostAddress() {
        return this.getHostAddress() != null;
    }

    public String getIPAddress() {
        return this.getHostAddress();
    }

    public boolean hasIPAddress() {
        return this.getHostAddress() != null;
    }

    public void setSavedEventCount(int count) {
        this.savedEventCount = count;
    }

    public void clearSavedEventCount() {
        this.setSavedEventCount(0);
    }

    public void incrementSavedEventCount() {
        ++this.savedEventCount;
    }

    public boolean hasSavedEvents() {
        return this.savedEventCount > 0;
    }

    public int getSavedEventCount() {
        return this.savedEventCount;
    }

    @Override
    public int getResponsePort() {
        return 0;
    }

    @Override
    public int getMinimumPacketLength() {
        return -1;
    }

    @Override
    public int getMaximumPacketLength() {
        return -1;
    }

    @Override
    public byte[] getInitialPacket() throws Exception {
        return null;
    }

    @Override
    public byte[] getFinalPacket(boolean hasError) throws Exception {
        return null;
    }

    @Override
    public int getActualPacketLength(byte[] packet, int packetLen) {
        return this.isTextPackets ? -1 : packetLen;
    }

    @Override
    public abstract byte[] getHandlePacket(byte[] var1) throws Exception;

    @Override
    public void idleTimeoutInterrupt() {
    }

    @Override
    public void forceCloseTCPSession() {
        this.setTerminateSession();
        ServerSocketThread.SessionInfo si = this.getSessionInfo();
        if (si != null) {
            si.forceCloseTCPSession();
        }
    }

    public void setTerminateSession(boolean term) {
        this.terminateSess = term;
    }

    @Override
    public void setTerminateSession() {
        this.setTerminateSession(true);
    }

    public void clearTerminateSession() {
        this.setTerminateSession(false);
    }

    @Override
    public boolean getTerminateSession() {
        return this.terminateSess;
    }

    @Override
    public boolean terminateSession() {
        return this.getTerminateSession();
    }

    @Override
    public void sessionTerminated(Throwable err, long readCount, long writeCount) {
        this.printSessionTerminated();
    }

    protected void printSessionTerminated() {
        String sessType = this.getSessionType();
        String host = StringTools.trim(this.getHostAddress());
        String name = StringTools.blankDefault(this.getThreadName(), "?");
        Print.logInfo("End " + sessType + " session (" + name + "): " + host, new Object[0]);
    }
}

