/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.google;

import java.util.List;
import java.util.Vector;
import org.opengts.util.ColorTools;
import org.opengts.util.GeoBounds;
import org.opengts.util.GeoPoint;
import org.opengts.util.GeoPointProvider;
import org.opengts.util.HTMLTools;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;
import org.opengts.util.StringTools;
import org.opengts.util.URIArg;

public class GoogleStaticMap {
    public static String GOOGLE_MAP_URL = "http://maps.google.com/staticmap";
    public static String MAPTYPE_MOBILE = "mobile";
    public static String MAPTYPE_ROADMAP = "roadmap";
    public static String MAPTYPE_SATELLITE = "satellite";
    public static String MAPTYPE_HYBRID = "hybrid";
    public static String MAPTYPE_TERRAIN = "terrain";
    public static String PUSHPIN_SIZE_TINY = "tiny";
    public static String PUSHPIN_SIZE_MID = "mid";
    public static String PUSHPIN_SIZE_SMALL = "small";
    public static String[] PUSHPIN_SIZE = new String[]{PUSHPIN_SIZE_TINY, PUSHPIN_SIZE_MID, PUSHPIN_SIZE_SMALL};
    public static String PUSHPIN_COLOR_BLACK = "black";
    public static String PUSHPIN_COLOR_BROWN = "brown";
    public static String PUSHPIN_COLOR_RED = "red";
    public static String PUSHPIN_COLOR_ORANGE = "orange";
    public static String PUSHPIN_COLOR_YELLOW = "yellow";
    public static String PUSHPIN_COLOR_GREEN = "green";
    public static String PUSHPIN_COLOR_BLUE = "blue";
    public static String PUSHPIN_COLOR_PURPLE = "purple";
    public static String PUSHPIN_COLOR_GRAY = "gray";
    public static String PUSHPIN_COLOR_WHITE = "white";
    public static String[] PUSHPIN_COLOR = new String[]{PUSHPIN_COLOR_BLACK, PUSHPIN_COLOR_BROWN, PUSHPIN_COLOR_RED, PUSHPIN_COLOR_ORANGE, PUSHPIN_COLOR_YELLOW, PUSHPIN_COLOR_GREEN, PUSHPIN_COLOR_BLUE, PUSHPIN_COLOR_PURPLE, PUSHPIN_COLOR_GRAY, PUSHPIN_COLOR_WHITE};
    public static String DEFAULT_PUSHPIN = GoogleStaticMap.CreatePushpinIcon(PUSHPIN_SIZE_MID, PUSHPIN_COLOR_RED, "o");
    private List<String> pushpins = new Vector<String>();
    private List<String> pathLine = new Vector<String>();
    private GeoBounds bounds = new GeoBounds();
    private GeoPoint center = null;
    private int width = 200;
    private int height = 250;
    private String googleKey = "";
    private String mapType = MAPTYPE_MOBILE;
    private int zoom = 8;
    private boolean sensor = false;
    private ColorTools.RGB pathColor = null;
    private int pathWeight = 2;

    public static String CreatePushpinIcon(String size, String color, String tag) {
        String S = StringTools.blankDefault(size, PUSHPIN_SIZE_MID);
        String C = StringTools.blankDefault(color, PUSHPIN_COLOR_RED);
        if (PUSHPIN_SIZE_TINY.equals(S)) {
            return S + C;
        }
        String L = StringTools.blankDefault(tag, "").toLowerCase();
        return S + C + L;
    }

    public GoogleStaticMap() {
    }

    public GoogleStaticMap(int width, int height, String key) {
        this.setSize(width, height);
        this.setGoogleKey(key);
    }

    public void setSize(int W, int H) {
        this.width = W;
        this.height = H;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public boolean hasGoogleKey() {
        return !StringTools.isBlank(this.googleKey);
    }

    public String getGoogleKey() {
        return this.googleKey;
    }

    public void setGoogleKey(String key) {
        this.googleKey = StringTools.trim(key);
    }

    public void setMapType(String mapType) {
        this.mapType = StringTools.trim(mapType);
        if (StringTools.isBlank(this.mapType)) {
            this.mapType = MAPTYPE_MOBILE;
        }
    }

    public String getMapType() {
        return this.mapType;
    }

    public void setZoom(int zoom) {
        this.zoom = zoom;
    }

    public int getZoom() {
        return this.zoom;
    }

    public int calculateZoom() {
        double ppd_lat = (double)this.getHeight() / this.bounds.getDeltaLatitude();
        double ppd_lon = (double)this.getWidth() / this.bounds.getDeltaLongitude();
        double ppd = ppd_lon < ppd_lat ? ppd_lon : ppd_lat;
        double zoom = Math.log(ppd_lon / 0.7111111111111111) / Math.log(2.0);
        int z = (int)Math.floor(zoom - 1.95);
        return z >= 0 ? z : 0;
    }

    public void setCenter(GeoPoint cp) {
        this.center = cp != null && cp.isValid() ? cp : null;
    }

    public GeoPoint getCenter() {
        return this.center;
    }

    public GeoPoint calculateCenter() {
        return this.bounds.getCenter();
    }

    public void setSensorState(boolean sensor) {
        this.sensor = sensor;
    }

    public boolean getSensorState() {
        return this.sensor;
    }

    public void setPath(ColorTools.RGB rgb, int weight) {
        this.pathColor = rgb;
        this.pathWeight = weight < 1 ? 1 : (weight > 10 ? 10 : weight);
    }

    public void addPushpin(GeoPoint gp, String icon) {
        if (gp != null && gp.isValid()) {
            String lat = GeoPoint.formatLatitude(gp.getLatitude());
            String lon = GeoPoint.formatLongitude(gp.getLongitude());
            String pp = lat + "," + lon + "," + StringTools.trim(icon);
            this.pushpins.add(pp);
            String rt = lat + "," + lon;
            this.pathLine.add(rt);
            this.bounds.extendByCircle(200.0, (GeoPointProvider)gp);
        }
    }

    public int getPushpinCount() {
        return this.pushpins.size();
    }

    public String toString() {
        StringBuffer sb;
        URIArg url = new URIArg(GOOGLE_MAP_URL);
        if (this.center != null) {
            url.addArg("center", this.center.getLatitude() + "," + this.center.getLongitude());
        }
        url.addArg("zoom", this.getZoom());
        url.addArg("size", this.getWidth() + "x" + this.getHeight());
        url.addArg("maptype", this.getMapType());
        url.addArg("sensor", String.valueOf(this.getSensorState()));
        if (this.pathColor != null && this.pathLine.size() >= 2) {
            sb = new StringBuffer();
            sb.append("rgb:0x").append(this.pathColor.toString());
            sb.append(",weight:").append(this.pathWeight);
            for (String pt : this.pathLine) {
                sb.append("|");
                sb.append(pt);
            }
            url.addArg("path", sb.toString());
        }
        if (!this.pushpins.isEmpty()) {
            sb = new StringBuffer();
            for (String pp : this.pushpins) {
                if (sb.length() > 0) {
                    sb.append("|");
                }
                sb.append(pp);
            }
            url.addArg("markers", sb.toString());
        }
        if (this.hasGoogleKey()) {
            url.addArg("key", this.getGoogleKey());
        }
        return url.toString();
    }

    public byte[] getMap() {
        String url = this.toString();
        try {
            int timeoutMS = -1;
            return HTMLTools.readPage_GET(url, timeoutMS);
        }
        catch (Throwable th) {
            Print.logError("Unable to retrieve map", th);
            return null;
        }
    }

    public static void main(String[] argv) {
        String[] gps;
        RTConfig.setCommandLineArgs(argv);
        GoogleStaticMap gsm = new GoogleStaticMap();
        gsm.setPath(ColorTools.COLOR_RED, 2);
        gsm.setSize(640, 480);
        for (String g : gps = StringTools.parseStringArray(RTConfig.getString("gp", ""), ',')) {
            GeoPoint gp = new GeoPoint(g);
            if (!gp.isValid()) continue;
            gsm.addPushpin(gp, "red");
        }
        if (gsm.getPushpinCount() <= 0) {
            Print.sysPrintln("Missing '-gp=<lat>/<lon>,<lat>/<lon>'", new Object[0]);
            System.exit(99);
        }
        gsm.setZoom(gsm.calculateZoom());
        Print.sysPrintln(gsm.toString(), new Object[0]);
    }
}

